/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.database.Database;
import oracle.cluster.database.Service;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.server.ServerPoolImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupArgs;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.util.Utils;

public class ServerGroupImpl
extends ServerPoolImpl
implements ServerGroup {
    ServerGroupImpl(ResourceAttribute nameAttr) throws ServerGroupException {
        super(nameAttr);
    }

    ServerGroupImpl(ResourceAttribute nameAttr, CRSEntity sibling) throws ServerGroupException {
        super(nameAttr, sibling);
    }

    void create(boolean forceFlag, int minSize, int maxSize, int importance, String exclusiveGroups, List<ServerGroup> parentList, Server ... serverList) throws AlreadyExistsException, ServerGroupException {
        try {
            List<ResourceAttribute> attrList = ResourceType.getAttributes(ResourceType.ServerPool.class);
            for (ResourceAttribute attr : attrList) {
                int i;
                if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.MIN_SIZE.name())) {
                    attr.setValue(String.valueOf(minSize));
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.MAX_SIZE.name())) {
                    attr.setValue(String.valueOf(maxSize));
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.IMPORTANCE.name())) {
                    attr.setValue(String.valueOf(importance));
                }
                if (exclusiveGroups != null && attr.getName().equalsIgnoreCase(ResourceType.ServerPool.EXCLUSIVE_POOLS.name())) {
                    attr.setValue(exclusiveGroups);
                }
                if (serverList.length > 0 && attr.getName().equalsIgnoreCase(ResourceType.ServerPool.SERVER_NAMES.name())) {
                    String[] serverNames = new String[serverList.length];
                    for (i = 0; i < serverList.length; ++i) {
                        try {
                            serverNames[i] = serverList[i].node().getName();
                            continue;
                        }
                        catch (ServerException e) {
                            throw new ServerGroupException(e);
                        }
                        catch (NodeException e) {
                            throw new ServerGroupException(e);
                        }
                    }
                    attr.setValue(Utils.getString(serverNames, String.valueOf(" ")));
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ServerPool.SERVER_CATEGORY.name()) && serverList.length > 0) {
                    attr.setValue("");
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.ServerPool.PARENT_POOLS.name())) continue;
                String[] parentNames = new String[parentList.size()];
                for (i = 0; i < parentList.size(); ++i) {
                    parentNames[i] = parentList.get(i).getName();
                }
                attr.setValue(Utils.getString(parentNames, String.valueOf(" ")));
            }
            this.m_crsServerPool.register(attrList, forceFlag);
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCsMsgID.SP_ALREADY_EXISTS, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public boolean hasExecutePermissions() throws ServerGroupException {
        return true;
    }

    @Override
    public boolean hasUpdatePermissions() throws ServerGroupException {
        return true;
    }

    @Override
    public String getExclusiveGroups() throws ServerGroupException {
        return this.getValue(ResourceType.ServerPool.EXCLUSIVE_POOLS.name());
    }

    @Override
    public void setExclusiveGroups(String exclusiveGroups) throws ServerGroupException {
        if (exclusiveGroups == null || exclusiveGroups.trim().length() == 0) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "exclusiveGroups", exclusiveGroups);
        }
        this.setValue(ResourceType.ServerPool.EXCLUSIVE_POOLS, exclusiveGroups);
    }

    @Override
    public List<ServerGroup> parents() throws ServerGroupException {
        try {
            String value = this.getValue(ResourceType.ServerPool.PARENT_POOLS.name());
            if (value.length() == 0) {
                return new ArrayList<ServerGroup>(0);
            }
            String[] parents = value.split(String.valueOf(" "));
            ArrayList<ServerGroup> parentList = new ArrayList<ServerGroup>(parents.length);
            CRSFactoryImpl factory = CRSFactoryImpl.getInstance();
            for (int i = 0; i < parents.length; ++i) {
                parentList.add(new ServerGroupImpl(factory.create(ResourceType.ServerPool.NAME.name(), parents[i])));
            }
            return parentList;
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_FAILED, (Throwable)e, ResourceType.ServerPool.PARENT_POOLS.name(), this.getUserAssignedName());
        }
    }

    @Override
    public List<ServerGroup> children() throws ServerGroupException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter filter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceType.ServerPool.PARENT_POOLS.name(), this.getName());
            List<ResourceAttribute> spAttrList = crsFactory.searchResources(this.crsEntity(), CRSEntity.Type.ServerPool, filter);
            ArrayList<ServerGroupImpl> childrenList = new ArrayList<ServerGroupImpl>(spAttrList.size());
            for (ResourceAttribute attr : spAttrList) {
                childrenList.add(new ServerGroupImpl(crsFactory.create(ResourceType.ServerPool.NAME.name(), attr.getValue())));
            }
            return Collections.unmodifiableList(childrenList);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_CHILDREN_FAILED, (Throwable)e, this.getName());
        }
        catch (NotExistsException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.SP_GET_CHILDREN_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setParents(List<ServerGroup> parentList) throws ServerGroupException {
        if (parentList == null || parentList.size() == 0) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "parentList", parentList);
        }
        String[] parentGrps = new String[parentList.size()];
        int i = 0;
        for (ServerGroup sg : parentList) {
            parentGrps[i++] = sg.getName();
        }
        this.setValue(ResourceType.ServerPool.PARENT_POOLS, Utils.getString(parentGrps, String.valueOf(" ")));
    }

    public void moveServers(List<Server> serverList, ServerGroup serverGroup) throws CompositeOperationException, ServerGroupException {
        serverGroup.relocateServers(serverList);
    }

    @Override
    public List<Server> configuredServers() throws ServerGroupException {
        return this.candidateServers();
    }

    public Database database() throws NotExistsException, ServerGroupException {
        try {
            List<Database> dbList = DatabaseFactoryImpl.getInstance().getDatabases(this);
            if (dbList.size() == 1) {
                return dbList.get(0);
            }
            if (dbList.size() == 0) {
                throw new NotExistsException((MessageKey)PrCsMsgID.SP_NOT_HOSTING_DB, this.getUserAssignedName());
            }
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, this.getUserAssignedName());
        }
        catch (SoftwareModuleException sme) {
            throw new ServerGroupException(sme);
        }
    }

    @Override
    public List<Service> services() throws ServerGroupException {
        try {
            List<Service> srvList = DatabaseFactoryImpl.getInstance().getServices(this);
            return srvList;
        }
        catch (SoftwareModuleException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    public List<String> serviceNames(String dbName) throws ServerGroupException {
        try {
            List<String> srvList = DatabaseFactoryImpl.getInstance().getServiceNames(this, dbName);
            return srvList;
        }
        catch (SoftwareModuleException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    public boolean isServerPool() throws ServerGroupException {
        String name = this.getName();
        if (name.equals(ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString())) {
            return false;
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ServerPool.NAME.name(), name);
            Filter parentsFilter = crsFactory.getFilter(Filter.Comparator.NOT_EQ, ResourceType.ServerPool.PARENT_POOLS.name(), "");
            Filter childrenFilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceType.ServerPool.PARENT_POOLS.name(), name);
            Filter filter = crsFactory.getFilter(Filter.Operator.AND, nameFilter, parentsFilter);
            filter = crsFactory.getFilter(Filter.Operator.OR, filter, childrenFilter);
            List<ResourceAttribute> list = crsFactory.searchResources(this.crsEntity(), CRSEntity.Type.ServerPool, filter);
            return list.size() == 0;
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.IS_SP_CHECK_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new ServerGroupException((MessageKey)PrCsMsgID.IS_SP_CHECK_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void modify(boolean forceFlag, ServerGroupArgs args) throws ServerGroupException {
        String exclusiveGroups = args.getExclusiveGroups();
        List<ServerGroup> parentList = args.getParents();
        ArrayList<ResourceAttribute> raList = new ArrayList<ResourceAttribute>();
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            if (exclusiveGroups != null) {
                if (exclusiveGroups.trim().length() == 0) {
                    throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "exclusiveGroups", exclusiveGroups);
                }
                raList.add(cf.create(ResourceType.ServerPool.EXCLUSIVE_POOLS.name(), exclusiveGroups));
            }
            if (parentList != null) {
                if (parentList.size() == 0) {
                    throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "parentList", parentList);
                }
                String[] parentGrps = new String[parentList.size()];
                int i = 0;
                for (ServerGroup sg : parentList) {
                    parentGrps[i++] = sg.getName();
                }
                raList.add(cf.create(ResourceType.ServerPool.PARENT_POOLS.name(), Utils.getString(parentGrps, String.valueOf(" "))));
            }
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
        super.modifyHelper(forceFlag, args, raList);
    }

    static void evaluateServerGroupCreation(String groupName, Server[] serverList) throws ServerGroupException {
        if (serverList == null || serverList.length == 0) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverList", serverList);
        }
        if (groupName == null) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "groupName", groupName);
        }
        ServerGroupImpl.evaluateCreation(groupName, false, serverList.length, serverList.length, 1, serverList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ServerGroupImpl)) {
            return false;
        }
        ServerGroupImpl other = (ServerGroupImpl)obj;
        return this.m_name != null && this.m_name.equalsIgnoreCase(other.m_name);
    }
}

