/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.scan;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.RTEArg;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.scan.ScanImpl;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.gridnamingservice.QueryTypes;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;

public class ScanVIPImpl
extends SoftwareModuleImpl
implements ScanVIP {
    private ResourceAttribute m_nameAttr;
    private int m_networkNumber;
    private int m_ordinalNum;

    ScanVIPImpl(ResourceAttribute nameAttr) throws ScanVIPException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ScanVIP.NAME.name())) {
                throw new ScanVIPException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.ScanVIP.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !".vip".toString().equalsIgnoreCase(String.valueOf('.') + value[2])) {
                throw new ScanVIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ScanVIP.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = value[1];
            Trace.out("Display name is \"" + this.m_displayName + "\"");
            int startIndexOfNetnumField = value[1].lastIndexOf("_net");
            int startIndexOfOrdinalNumField = value[1].lastIndexOf(ResourceLiterals.SCAN.toString()) + ResourceLiterals.SCAN.toString().length();
            if (startIndexOfOrdinalNumField == -1 || startIndexOfNetnumField != -1 && startIndexOfOrdinalNumField > startIndexOfNetnumField) {
                Trace.out("Failed to find ordinal number for scan vip: " + this.m_displayName);
                throw new ScanVIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ScanVIP.NAME.name(), nameAttr.getValue());
            }
            try {
                if (startIndexOfNetnumField != -1) {
                    this.m_ordinalNum = Integer.parseInt(value[1].substring(startIndexOfOrdinalNumField, startIndexOfNetnumField));
                    Trace.out("ordinal number = " + this.m_ordinalNum);
                    this.m_networkNumber = Integer.parseInt(value[1].substring(startIndexOfNetnumField += "_net".length()));
                    Trace.out("network number = " + this.m_networkNumber);
                } else {
                    this.m_networkNumber = 1;
                    Trace.out("network number = " + this.m_networkNumber);
                    this.m_ordinalNum = Integer.parseInt(value[1].substring(startIndexOfOrdinalNumField));
                    Trace.out("ordinal number = " + this.m_ordinalNum);
                }
            }
            catch (NumberFormatException nfe) {
                Trace.out("Failed to get network number or ordinal number: " + nfe.getMessage());
                throw new ScanVIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ScanVIP.NAME.name(), nameAttr.getValue());
            }
            try {
                this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
            }
            catch (NotExistsException notExistsException) {}
        }
        catch (CRSException e) {
            throw new ScanVIPException(e);
        }
    }

    void create(String scanName, Network network, Version version, InetAddress vipAddress) throws AlreadyExistsException, ScanVIPException {
        if (vipAddress == null) {
            this.create(scanName, network, version, null, null);
        } else if (vipAddress instanceof Inet4Address) {
            this.create(scanName, network, version, (Inet4Address)vipAddress, null);
        } else if (vipAddress instanceof Inet6Address) {
            this.create(scanName, network, version, null, (Inet6Address)vipAddress);
        }
    }

    void create(String scanName, Network network, Version version, Inet4Address vipAddressIPv4, Inet6Address vipAddressIPv6) throws AlreadyExistsException, ScanVIPException {
        this.createInternal(scanName, network, version, vipAddressIPv4, vipAddressIPv6, null);
    }

    void create(String scanName, Network network, Version version, String nodeName) throws AlreadyExistsException, ScanVIPException {
        this.createInternal(scanName, network, version, null, null, nodeName);
    }

    private void createInternal(String scanName, Network network, Version version, Inet4Address vipAddressIPv4, Inet6Address vipAddressIPv6, String nodeName) throws AlreadyExistsException, ScanVIPException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new ScanVIPException(sme);
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> attrList = null;
            ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), network.getName());
            ResourceAttribute scanVIPTypeAttr = crsFactory.create(ResourceType.ScanVIP.NAME.name(), ResourceType.ScanVIP.NAME.toString());
            if (!crsFactory.isRegistered(netAttr.getValue(), CRSEntity.Type.Resource)) {
                throw new ScanVIPException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, netAttr.getValue());
            }
            attrList = crsFactory.getResourceTypeEntity(scanVIPTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                String attributeName = attr.getName();
                if (attributeName.equalsIgnoreCase(ResourceType.ScanVIP.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ResourceType.ScanVIP.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.SCAN_VIP_RES_DESC.toString());
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ResourceType.ScanVIP.SCAN_NAME.name())) {
                    attr.setValue(scanName);
                    continue;
                }
                if (!attributeName.equalsIgnoreCase(ResourceType.ScanVIP.NETNUM.name())) continue;
                attr.setValue(String.valueOf(this.m_networkNumber));
            }
            String oraVIPValue = "";
            if (vipAddressIPv4 != null && vipAddressIPv6 == null) {
                oraVIPValue = vipAddressIPv4.getHostAddress();
            } else if (vipAddressIPv4 == null && vipAddressIPv6 != null) {
                oraVIPValue = vipAddressIPv6.getHostAddress();
            } else if (vipAddressIPv4 != null && vipAddressIPv6 != null) {
                oraVIPValue = vipAddressIPv4.getHostAddress() + " " + vipAddressIPv6.getHostAddress();
            }
            if (nodeName != null) {
                oraVIPValue = nodeName;
            }
            if (!oraVIPValue.equals("")) {
                Trace.out("About to set USR_ORA_VIP = " + oraVIPValue);
                attrList.add(crsFactory.create(ResourceType.ClusterVIP.USR_ORA_VIP.name(), oraVIPValue));
            }
            if (nodeName != null) {
                Trace.out("About to set HOSTING_MEMBERS = " + nodeName);
                attrList.add(crsFactory.create(ResourceType.ClusterVIP.HOSTING_MEMBERS.name(), nodeName));
                Trace.out("About to unset SERVER_CATEGORY");
                attrList.add(crsFactory.create(ResourceType.ClusterVIP.SERVER_CATEGORY.name(), ""));
            }
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            DHCPServerType serverType = DHCPServerType.NONE;
            try {
                serverType = network.addressType() == IPAddressUtil.IPAddrType.IPv4 ? network.dhcpServerType() : network.dhcpServerTypeIPv6();
                Trace.out("DHCPServerType is " + serverType.toString());
            }
            catch (NetworkException ne) {
                throw new ScanVIPException(ne);
            }
            this.createScanVIPDepAttrs(attrList, network);
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.ROOT);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException crse) {
            throw new ScanVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)crse, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws ScanVIPException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new ScanVIPException(e);
        }
    }

    void createScanVIPDepAttrs(List<ResourceAttribute> attrList, Network network) throws ScanVIPException {
        this.createScanVIPDepAttrsHelper(attrList, network, true, true);
    }

    void upgradeScanVIPDepAttrs(List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws ScanVIPException {
        this.createScanVIPDepAttrsHelper(attrList, this.network(), inclStartDep, inclStopDep);
    }

    private void createScanVIPDepAttrsHelper(List<ResourceAttribute> attrList, Network network, boolean inclStartDep, boolean inclStopDep) throws ScanVIPException {
        Trace.out("Calling createScanVIPDepAttrs");
        if (!inclStartDep && !inclStopDep) {
            return;
        }
        HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
        HashMap<String, String> condMap = new HashMap<String, String>();
        try {
            argMap.put("network", new RTEArg("network", RTEArg.RTEArgType.Res, network.getName()));
        }
        catch (RTENativeException e) {
            throw new ScanVIPException(e);
        }
        try {
            String depHint;
            String dep;
            RTENativeResult result;
            String template;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (inclStartDep) {
                template = ResourceType.ScanVIP.START_DEPENDENCIES_TEMPLATE.toString();
                result = crsFactory.rteEvalAttrValue(template, argMap, new Version().toString(), condMap, this.m_nameAttr.getValue());
                dep = result.getAttrValue();
                depHint = result.getAttrValueHint();
                Trace.out((Object)"START_DEPENDENCIES is %s", dep);
                Trace.out((Object)"START_DEPENDENCIES_RTE_INTERNAL is %s", depHint);
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dep));
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
            }
            if (inclStopDep) {
                template = ResourceType.ScanVIP.STOP_DEPENDENCIES_TEMPLATE.toString();
                result = crsFactory.rteEvalAttrValue(template, argMap, new Version().toString(), condMap, this.m_nameAttr.getValue());
                dep = result.getAttrValue();
                depHint = result.getAttrValueHint();
                Trace.out((Object)"STOP_DEPENDENCIES is %s", dep);
                Trace.out((Object)"STOP_DEPENDENCIES_RTE_INTERNAL is %s", depHint);
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), dep));
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
            }
        }
        catch (CRSException e) {
            throw new ScanVIPException(e);
        }
    }

    @Override
    public Network network() throws ScanVIPException {
        try {
            return NodeAppsFactoryImpl.getInstance().getNetwork(this.m_crsResource);
        }
        catch (SoftwareModuleException e) {
            throw new ScanVIPException(e);
        }
    }

    void setNetwork(Network network) throws ScanVIPException {
        try {
            String template;
            List<ResourceAttribute> deps = this.m_crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name());
            ResourceAttribute startDep = deps.get(0);
            ResourceAttribute startDepHint = deps.get(1);
            ResourceAttribute stopDep = deps.get(2);
            ResourceAttribute stopDepHint = deps.get(3);
            String version = null;
            Map<String, RTEArg> argMap = null;
            Map<String, String> condMap = null;
            try {
                String template2 = ResourceType.ScanVIP.START_DEPENDENCIES_TEMPLATE.toString();
                ArrayList<String> argNameList = new ArrayList<String>();
                argNameList.add("network");
                String attrValue = startDep.getValue();
                String attrValueHint = startDepHint.getValue();
                RTENativeResult result = CRSFactoryImpl.getInstance().rteGetArgList(template2, argNameList, attrValue, attrValueHint, version, this.m_nameAttr.getValue());
                argMap = result.getRTEArgMap();
                condMap = result.getCondMap();
            }
            catch (CRSException e) {
                throw new ScanVIPException(e);
            }
            try {
                argMap.put("network", new RTEArg("network", RTEArg.RTEArgType.Res, network.getName()));
            }
            catch (RTENativeException e) {
                throw new ScanVIPException(e);
            }
            String newStartDep = null;
            String newStartDepHint = null;
            try {
                template = ResourceType.ScanVIP.START_DEPENDENCIES_TEMPLATE.toString();
                RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, version, condMap, this.m_nameAttr.getValue());
                newStartDep = result.getAttrValue();
                newStartDepHint = result.getAttrValueHint();
            }
            catch (CRSException e) {
                throw new ScanVIPException(e);
            }
            try {
                template = ResourceType.ScanVIP.STOP_DEPENDENCIES_TEMPLATE.toString();
                ArrayList<String> argNameList = new ArrayList<String>();
                argNameList.add("network");
                String attrValue = stopDep.getValue();
                String attrValueHint = stopDepHint.getValue();
                RTENativeResult result = CRSFactoryImpl.getInstance().rteGetArgList(template, argNameList, attrValue, attrValueHint, version, this.m_nameAttr.getValue());
                argMap = result.getRTEArgMap();
                condMap = result.getCondMap();
            }
            catch (CRSException e) {
                throw new ScanVIPException(e);
            }
            try {
                argMap.put("network", new RTEArg("network", RTEArg.RTEArgType.Res, network.getName()));
            }
            catch (RTENativeException e) {
                throw new ScanVIPException(e);
            }
            String newStopDep = null;
            String newStopDepHint = null;
            try {
                String template3 = ResourceType.ScanVIP.STOP_DEPENDENCIES_TEMPLATE.toString();
                RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template3, argMap, version, condMap, this.m_nameAttr.getValue());
                newStopDep = result.getAttrValue();
                newStopDepHint = result.getAttrValueHint();
            }
            catch (CRSException e) {
                throw new ScanVIPException(e);
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            this.m_crsResource.update(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), newStartDep), crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), newStartDepHint), crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), newStopDep), crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), newStopDepHint));
        }
        catch (CRSException e) {
            throw new ScanVIPException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public InetAddress address() throws ScanVIPException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            String vipName = attr.getValue();
            Trace.out("vipName=" + vipName);
            if (vipName.length() == 0) {
                return null;
            }
            return InetAddress.getByName(vipName);
        }
        catch (CRSException e) {
            throw new ScanVIPException(e);
        }
        catch (UnknownHostException e) {
            throw new ScanVIPException(e);
        }
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> addresses() throws ScanVIPException {
        HashMap<IPAddressUtil.IPAddrType, InetAddress> inetAddressMap = new HashMap<IPAddressUtil.IPAddrType, InetAddress>();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            String vipName = attr.getValue().trim();
            Trace.out("vipName =" + vipName);
            int vipNameDelimiterIndex = vipName.indexOf(" ");
            if (vipNameDelimiterIndex != -1) {
                String ipv4Value = vipName.substring(0, vipNameDelimiterIndex);
                String ipv6Value = vipName.substring(vipNameDelimiterIndex + 1);
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, InetAddress.getByName(ipv4Value));
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, InetAddress.getByName(ipv6Value));
                return inetAddressMap;
            }
            if (vipName.length() == 0) {
                return this.dynamicAddresses();
            }
            InetAddress inetAddress = InetAddress.getByName(vipName);
            if (inetAddress instanceof Inet4Address) {
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, inetAddress);
            } else if (inetAddress instanceof Inet6Address) {
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, inetAddress);
            }
            return inetAddressMap;
        }
        catch (CRSException crse) {
            throw new ScanVIPException(crse);
        }
        catch (UnknownHostException uhe) {
            throw new ScanVIPException(uhe);
        }
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> dynamicAddresses() throws ScanVIPException {
        HashMap<IPAddressUtil.IPAddrType, InetAddress> inetAddressMap = new HashMap<IPAddressUtil.IPAddrType, InetAddress>();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.GEN_USR_ORA_VIP.name());
            String scanVIPDynamicAddr = attr.getValue().trim();
            if (scanVIPDynamicAddr.isEmpty()) {
                return inetAddressMap;
            }
            int vipDynamicAddrDelimiterIndex = scanVIPDynamicAddr.indexOf(" ");
            if (vipDynamicAddrDelimiterIndex != -1) {
                String ipv4Value = scanVIPDynamicAddr.substring(0, vipDynamicAddrDelimiterIndex);
                String ipv6Value = scanVIPDynamicAddr.substring(vipDynamicAddrDelimiterIndex + 1);
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, InetAddress.getByName(ipv4Value));
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, InetAddress.getByName(ipv6Value));
                return inetAddressMap;
            }
            Trace.out("scanVIPDynamicAddr =" + scanVIPDynamicAddr);
            InetAddress inetAddress = InetAddress.getByName(scanVIPDynamicAddr);
            if (inetAddress instanceof Inet4Address) {
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, inetAddress);
            } else if (inetAddress instanceof Inet6Address) {
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, inetAddress);
            }
            return inetAddressMap;
        }
        catch (CRSException crse) {
            throw new ScanVIPException(crse);
        }
        catch (UnknownHostException uhe) {
            throw new ScanVIPException(uhe);
        }
    }

    @Override
    public int getOrdinalNum() {
        return this.m_ordinalNum;
    }

    @Override
    public String getScanName() throws ScanVIPException {
        return this.internalGetScanName(false);
    }

    @Override
    public String getFQDNScanName() throws ScanVIPException {
        return this.internalGetScanName(true);
    }

    private String internalGetScanName(boolean doAppendGnsSubd) throws ScanVIPException {
        String scanName = null;
        String retSName = null;
        try {
            scanName = this.m_crsResource.getAttribute(ResourceType.ScanVIP.SCAN_NAME.name()).getValue().trim();
            Trace.out("SCAN_NAME attribute value: " + scanName);
            retSName = scanName;
            if (doAppendGnsSubd) {
                String gnsdomain = null;
                Trace.out("Getting FQDN for scan name: " + scanName);
                Network network = this.network();
                Map<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = network.dhcpServerTypes();
                boolean hasIPv4Subnet = serverTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4);
                boolean hasIPv6Subnet = serverTypeMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6);
                DHCPServerType ipv4ServerType = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                DHCPServerType ipv6ServerType = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                if (hasIPv4Subnet && ipv4ServerType != DHCPServerType.NONE || hasIPv6Subnet && ipv6ServerType != DHCPServerType.NONE) {
                    GNS gns = null;
                    Trace.out("Dynamic network type. Append GNS subdomain");
                    try {
                        gns = GNSFactory.getInstance().getGNS();
                    }
                    catch (NotExistsException e) {
                        Trace.out("Got GNSException when calling getGNS: " + e.getMessage());
                    }
                    catch (VIPNotFoundException e) {
                        Trace.out("Got VIPNotFoundException when calling getGNS: " + e.getMessage());
                    }
                    catch (SoftwareModuleException e) {
                        Trace.out("Got SoftwareModuleException when calling getGNS: " + e.getMessage());
                    }
                    if (gns != null) {
                        QueryTypes queryType = QueryTypes.SUBDOMAIN;
                        try {
                            gnsdomain = gns.query(QueryTypes.SUBDOMAIN);
                        }
                        catch (GNSException e) {
                            Trace.out("Warning: Got GNSException: " + e.getMessage());
                        }
                    }
                    if (gnsdomain != null) {
                        String[] scanNameArr = scanName.split(Pattern.quote(String.valueOf('.')));
                        if (scanNameArr.length > 0) {
                            retSName = scanNameArr[0];
                        }
                        retSName = retSName + '.' + gnsdomain;
                        Trace.out("Using GNS subdomain: " + gnsdomain);
                    }
                }
            }
            Trace.out("Scan name to return:" + retSName);
            return retSName;
        }
        catch (NetworkException e) {
            Trace.out("Got NetworkException: " + e.getMessage());
            throw new ScanVIPException(e);
        }
        catch (CRSException e) {
            Trace.out("Got CRSException: " + e.getMessage());
            throw new ScanVIPException(e);
        }
    }

    @Override
    public Scan scan() throws ScanException {
        return ScanImpl.getInstance(this.m_networkNumber);
    }

    @Override
    public ScanListener listener() throws NotExistsException, ScanVIPException {
        try {
            int netNum = this.network().getNumber();
            List<ScanListener> slsnrList = ScanFactoryImpl.getInstance().getScanListeners(netNum);
            StringBuilder errSb = new StringBuilder();
            for (ScanListener slsnr : slsnrList) {
                ScanVIP sVIP = slsnr.vip();
                if (this.getName().equals(sVIP.getName())) {
                    return slsnr;
                }
                if (errSb.length() > 0) {
                    errSb.append("," + sVIP.getName());
                    continue;
                }
                errSb.append(sVIP.getName());
            }
            throw new NotExistsException((MessageKey)PrCsMsgID.SLSNR_FOR_SVIP_NOT_FOUND, this.getUserAssignedName(), errSb.toString());
        }
        catch (SoftwareModuleException e) {
            throw new ScanVIPException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, ScanVIPException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ScanVIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    public void removeAddressType(IPAddressUtil.IPAddrType addrType) throws ScanVIPException {
        if (addrType != IPAddressUtil.IPAddrType.IPv4 && addrType != IPAddressUtil.IPAddrType.IPv6 && addrType != IPAddressUtil.IPAddrType.BOTH) {
            throw new ScanVIPException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "scan-vip_error-02");
        }
        try {
            ResourceAttribute usrOraVIPAttr = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
            String existingValue = usrOraVIPAttr.getValue();
            int delimiterIndex = existingValue.indexOf(" ");
            if (addrType == IPAddressUtil.IPAddrType.BOTH) {
                usrOraVIPAttr.setValue("");
            } else if (delimiterIndex != -1) {
                String ipv4Value = existingValue.substring(0, delimiterIndex);
                String ipv6Value = existingValue.substring(delimiterIndex + 1);
                if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                    usrOraVIPAttr.setValue(ipv6Value);
                } else {
                    usrOraVIPAttr.setValue(ipv4Value);
                }
            } else if (IPAddressUtil.isIPv4AddressString(existingValue)) {
                if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                    usrOraVIPAttr.setValue("");
                }
            } else if (IPAddressUtil.isIPv6AddressString(existingValue)) {
                if (addrType == IPAddressUtil.IPAddrType.IPv6) {
                    usrOraVIPAttr.setValue("");
                }
            } else if (existingValue.trim().length() != 0) {
                Trace.out("Internal error: The existing value of USR_ORA_VIP (" + existingValue + ") is neither an IPv4 nor an IPv6 adddress as expected");
                throw new ScanVIPException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "scan-vip_error-01");
            }
            Trace.out("Changing value of attribute \"" + usrOraVIPAttr.getName() + "\" to \"" + usrOraVIPAttr.getValue() + "\"");
            this.m_crsResource.update(usrOraVIPAttr);
        }
        catch (CRSException crse) {
            throw new ScanVIPException(crse);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ScanVIPException {
        String restype = null;
        String resname = null;
        String clientid = null;
        ClusterUtil clusterutil = null;
        DHCPServerType serverType = DHCPServerType.NONE;
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new ScanVIPException(e);
        }
        try {
            serverType = this.network().dhcpServerType();
            if (serverType == DHCPServerType.DHCP || serverType == DHCPServerType.AUTOCONFIG) {
                clusterutil = new ClusterUtil();
                CRSResource crsRes = this.crsResource();
                ResourceAttribute attr = ((CRSResourceImpl)crsRes).getAttribute(ResourceLiterals.TYPE.name());
                resname = this.getName();
                restype = attr.getValue();
                clientid = clusterutil.getClientID(resname, restype);
                Trace.out("Network type is DHCP. Client id is " + clientid + "; Resource name is " + resname + "; Resource type is " + restype);
            }
        }
        catch (CRSException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        catch (ClusterUtilException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        catch (NotExistsException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        catch (NetworkException e) {
            Trace.out("Got CRSException when collecting clustername, resourcename and resourcetype: " + e.getMessage());
        }
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new ScanVIPException(e);
        }
        if ((serverType == DHCPServerType.DHCP || serverType == DHCPServerType.AUTOCONFIG) && clientid != null) {
            try {
                clusterutil.DHCPReleaseLease(clientid);
            }
            catch (ClusterUtilException e) {
                Trace.out("Got CRSException when calling clusterutil.DHCPReleaseLease: " + e.getMessage());
            }
            try {
                GNS gns = GNSFactory.getInstance().getGNS();
                String gnsname = clientid;
                Trace.out("Calling gns.deleteName for " + gnsname);
                gns.deleteName(gnsname);
            }
            catch (GNSException e) {
                Trace.out("Got GNSException when calling gns.deleteName: " + e.getMessage());
            }
            catch (VIPNotFoundException e) {
                Trace.out("Got VIPNotFoundException when calling gns.deleteName: " + e.getMessage());
            }
            catch (SoftwareModuleException e) {
                Trace.out("Got SoftwareModuleException when calling gns.deleteName: " + e.getMessage());
            }
            catch (NotExistsException e) {
                Trace.out("Got NotExistsException when calling gns.deleteName: " + e.getMessage());
            }
        }
    }

    public static String getResourceName(int netnum, int ordinalNumber) {
        if (netnum == 1) {
            return "ora." + ResourceLiterals.SCAN.toString() + String.valueOf(ordinalNumber) + ".vip";
        }
        return "ora." + ResourceLiterals.SCAN.toString() + String.valueOf(ordinalNumber) + '_' + "net" + String.valueOf(netnum) + ".vip";
    }

    @Override
    public int compareTo(ScanVIP other) {
        return Integer.compare(this.getOrdinalNum(), other.getOrdinalNum());
    }
}

