/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.scan;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.scan.ScanImpl;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanListenerException;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ScanListenerImpl
extends SoftwareModuleImpl
implements ScanListener {
    private ResourceAttribute m_nameAttr;
    private int m_networkNumber;

    ScanListenerImpl(ResourceAttribute nameAttr) throws ScanListenerException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ScanListener.NAME.name())) {
                throw new ScanListenerException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.ScanListener.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.LSNR.toString().equalsIgnoreCase(value[2]) || value[1].indexOf(String.valueOf('_')) < 0) {
                throw new ScanListenerException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ScanListener.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = value[1];
            Trace.out("Display name is \"" + this.m_displayName + "\"");
            int startIndexOfNetnumField = value[1].lastIndexOf('_' + "net".toUpperCase());
            this.m_networkNumber = startIndexOfNetnumField != -1 ? Integer.parseInt(value[1].substring(startIndexOfNetnumField += "_net".length())) : 1;
            Trace.out("network number = " + this.m_networkNumber);
            try {
                this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
            }
            catch (NotExistsException notExistsException) {}
        }
        catch (CRSException crse) {
            throw new ScanListenerException(crse);
        }
    }

    void create(Endpoints endpoints, ScanVIP scanVIP, Version version) throws AlreadyExistsException, ScanListenerException {
        this.create(endpoints, scanVIP, version, null, null);
    }

    void create(Endpoints endpoints, ScanVIP scanVIP, Version version, String invitedNodes, String invitedSubnets) throws AlreadyExistsException, ScanListenerException {
        try {
            String portStr = endpoints.getTCPPortCRSValue();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute scanLsnrTypeAttr = crsFactory.create(ResourceType.ScanListener.NAME.name(), ResourceType.ScanListener.NAME.toString());
            ResourceAttribute scanVIPAttr = crsFactory.create(ResourceType.ScanVIP.NAME.name(), scanVIP.getName());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(scanLsnrTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                String attributeName = attr.getName();
                if (attributeName.equalsIgnoreCase(ResourceType.ScanListener.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ResourceType.ScanListener.NETNUM.name())) {
                    attr.setValue(String.valueOf(this.m_networkNumber));
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ResourceType.ScanListener.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.SCAN_LSNR_RES_DESC.toString());
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ResourceType.ScanListener.ENDPOINTS.name())) {
                    attr.setValue(endpoints.toCRSValue());
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ResourceType.ScanListener.PORT.name()) && portStr != null) {
                    attr.setValue(portStr);
                    continue;
                }
                if (attributeName.equalsIgnoreCase(ResourceType.ScanListener.REGISTRATION_INVITED_NODES.name()) && invitedNodes != null) {
                    attr.setValue(invitedNodes);
                    continue;
                }
                if (!attributeName.equalsIgnoreCase(ResourceType.ScanListener.REGISTRATION_INVITED_SUBNETS.name()) || invitedSubnets == null) continue;
                attr.setValue(invitedSubnets);
            }
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            ResourceDependency hardDep = crsFactory.createResourceDependency(scanVIPAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency pullDep = crsFactory.createResourceDependency(scanVIPAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency disperseDep = crsFactory.createResourceDependency(scanLsnrTypeAttr, ResourceDependency.DepType.DISPERSION_ACTIVE_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep, disperseDep, pullDep)));
            hardDep = crsFactory.createResourceDependency(scanVIPAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), hardDep.toString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException crse) {
            throw new ScanListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)crse, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws ScanListenerException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new ScanListenerException(e);
        }
    }

    @Override
    public Network network() throws ScanListenerException {
        try {
            return this.vip().network();
        }
        catch (ScanVIPException e) {
            throw new ScanListenerException(e);
        }
    }

    @Override
    public String getListenerName() throws NotExistsException, ScanListenerException {
        try {
            if (this.m_crsResource.isRegistered()) {
                String displayNameLowerCase = this.m_displayName.toLowerCase();
                int indexOfUnderscoreScan = displayNameLowerCase.lastIndexOf('_' + "scan".toLowerCase());
                return this.m_displayName.substring(0, indexOfUnderscoreScan);
            }
            throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, this.getName());
        }
        catch (CRSException crse) {
            throw new ScanListenerException(crse);
        }
    }

    @Override
    public Endpoints getEndpoints() throws ScanListenerException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ScanListener.ENDPOINTS.name());
            Trace.out((Object)"attr.getValue() = ", attr.getValue());
            Endpoints scanEndpoints = NodeAppsFactoryImpl.getInstance().createEndpoints(attr.getValue(), " ");
            Trace.out("scanEndpoints =" + scanEndpoints.toCRSValue());
            return scanEndpoints;
        }
        catch (CRSException e) {
            throw new ScanListenerException(e);
        }
        catch (ListenerException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
    }

    void setEndpoints(Endpoints scanEndpoints) throws ScanListenerException {
        try {
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            attrList.add(CRSFactoryImpl.getInstance().create(ResourceType.ScanListener.ENDPOINTS.name(), scanEndpoints.toCRSValue()));
            String portStr = scanEndpoints.getTCPPortCRSValue();
            if (portStr != null) {
                attrList.add(CRSFactoryImpl.getInstance().create(ResourceType.ScanListener.PORT.name(), portStr));
            }
            this.m_crsResource.update(attrList.toArray(new ResourceAttribute[attrList.size()]));
        }
        catch (CRSException e) {
            throw new ScanListenerException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    @Deprecated
    public int getPort() throws ScanListenerException {
        int[] tcpports = this.getEndpoints().getTCPPortArr();
        if (tcpports.length > 0) {
            return tcpports[0];
        }
        throw new ScanListenerException((MessageKey)PrCsMsgID.SCAN_LSNR_ONE_TCP_PORT, tcpports.length);
    }

    void setPort(int scanPort) throws ScanListenerException {
        try {
            Endpoints endp = NodeAppsFactoryImpl.getInstance().createEndpoints(String.valueOf(scanPort), " ");
            this.setEndpoints(endp);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
    }

    @Override
    public String getInvitedNodes() throws ScanListenerException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.ScanListener.REGISTRATION_INVITED_NODES.name()).getValue();
        }
        catch (CRSException e) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.GET_INVITEDNODES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setInvitedNodes(String invitedNodes) throws ScanListenerException {
        if (invitedNodes == null) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "REGISTRATION_INVITED_NODES", invitedNodes);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ScanListener.REGISTRATION_INVITED_NODES.name(), invitedNodes));
        }
        catch (CRSException e) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.SET_INVITEDNODES_FAILED, (Throwable)e, invitedNodes, this.getUserAssignedName());
        }
    }

    @Override
    public String getInvitedSubnets() throws ScanListenerException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.ScanListener.REGISTRATION_INVITED_SUBNETS.name()).getValue();
        }
        catch (CRSException e) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.GET_INVITEDSUBNETS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setInvitedSubnets(String invitedSubnets) throws ScanListenerException {
        if (invitedSubnets == null) {
            throw new ScanListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "REGISTRATION_INVITED_SUBNETS", invitedSubnets);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ScanListener.REGISTRATION_INVITED_SUBNETS.name(), invitedSubnets));
        }
        catch (CRSException e) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.SET_INVITEDSUBNETS_FAILED, (Throwable)e, invitedSubnets, this.getUserAssignedName());
        }
    }

    @Override
    public Scan scan() throws ScanException {
        ResourceAttribute netnumAttr;
        try {
            netnumAttr = this.m_crsResource.getAttribute(ResourceType.ScanListener.NETNUM.name());
        }
        catch (CRSException crse) {
            throw new ScanListenerException(crse);
        }
        Trace.out("Retriving ScanImpl instance for network with netnum=" + netnumAttr.getValue());
        return ScanImpl.getInstance(Integer.valueOf(netnumAttr.getValue()));
    }

    @Override
    public ScanVIP vip() throws ScanListenerException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            String[] depNames = ResourceDependency.getResourceNames(attr, ResourceDependency.DepType.HARD_DEP);
            StringBuilder errSb = new StringBuilder();
            for (String resName : depNames) {
                if (resName.endsWith(ResourceLiterals.VIP.toString())) {
                    return ScanFactoryImpl.getInstance().getScanVIP(resName);
                }
                if (errSb.length() > 0) {
                    errSb.append("," + resName);
                    continue;
                }
                errSb.append(resName);
            }
            throw new ScanListenerException((MessageKey)PrCsMsgID.SVIP_FOR_SLSNR_NOT_FOUND, this.getUserAssignedName(), errSb.toString());
        }
        catch (NotExistsException e) {
            throw new ScanListenerException(e);
        }
        catch (ScanVIPException e) {
            throw new ScanListenerException(e);
        }
        catch (CRSException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, ScanListenerException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ScanListenerException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
    }

    public static String getResourceName(String scanListenerName, int netnum, int ordinalNumber) {
        scanListenerName = scanListenerName == null ? ResourceLiterals.LISTENER.toString().toUpperCase() : scanListenerName.toUpperCase();
        if (netnum == 1) {
            return "ora." + scanListenerName + '_' + ResourceLiterals.SCAN.toString().toUpperCase() + String.valueOf(ordinalNumber) + ".lsnr";
        }
        return "ora." + scanListenerName + '_' + ResourceLiterals.SCAN.toString().toUpperCase() + String.valueOf(ordinalNumber) + '_' + "net".toUpperCase() + String.valueOf(netnum) + ".lsnr";
    }
}

