/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.scan;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.scan.ScanListenerImpl;
import oracle.cluster.impl.scan.ScanVIPImpl;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanListenerException;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.PortException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ScanImpl
implements Scan {
    private static ScanImpl s_instance;
    private int m_netnum;
    private List<ScanVIP> m_scanVIPList;
    private List<ScanListener> m_scanListenerList;

    private ScanImpl(int netnum) throws ScanException {
        this.m_netnum = netnum;
        this.initialize();
    }

    private synchronized void initialize() throws ScanException {
        block5: {
            try {
                ScanFactoryImpl scanFactory = ScanFactoryImpl.getInstance();
                try {
                    this.m_scanVIPList = scanFactory.getScanVIPs(this.m_netnum);
                    this.m_scanListenerList = scanFactory.getScanListeners(this.m_netnum);
                }
                catch (NotExistsException e) {
                    Trace.out("NEE message = " + e.getMessage());
                    if (this.m_scanVIPList == null) {
                        this.m_scanVIPList = new ArrayList<ScanVIP>();
                        this.m_scanListenerList = new ArrayList<ScanListener>();
                        break block5;
                    }
                    this.m_scanListenerList = new ArrayList<ScanListener>();
                }
            }
            catch (SoftwareModuleException e) {
                throw new ScanException(e);
            }
        }
    }

    static synchronized ScanImpl getInstance(int netnum) throws ScanException {
        if (null == s_instance) {
            s_instance = new ScanImpl(netnum);
        }
        return s_instance;
    }

    @Override
    public String getListenerName() throws NotExistsException, ScanException {
        if (this.m_scanListenerList.size() == 0) {
            this.initialize();
        }
        if (this.m_scanListenerList.size() > 0) {
            return this.m_scanListenerList.get(0).getListenerName();
        }
        if (this.m_netnum == 1) {
            throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, ResourceLiterals.SCAN.toString() + " " + ResourceLiterals.LISTENER.toString());
        }
        throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, ResourceLiterals.SCAN.toString() + '_' + (Object)((Object)ResourceLiterals.NET) + this.m_netnum + " " + ResourceLiterals.LISTENER.toString());
    }

    @Override
    public Network network() throws ScanException {
        if (this.m_scanVIPList.size() == 0) {
            this.initialize();
        }
        if (this.m_scanVIPList.size() > 0) {
            return this.m_scanVIPList.get(0).network();
        }
        throw new ScanException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, ResourceLiterals.SCAN_VIP.toString());
    }

    @Override
    public void setNetwork(Network network) throws ScanException {
        ScanVIPException excep = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m_scanVIPList.size(); ++i) {
            ScanVIP scanVIP = this.m_scanVIPList.get(i);
            try {
                ((ScanVIPImpl)scanVIP).setNetwork(network);
                continue;
            }
            catch (ScanVIPException e) {
                excep = e;
                sb.append(scanVIP.getName());
            }
        }
        if (sb.length() > 0) {
            throw new ScanException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)excep, sb.toString());
        }
    }

    @Override
    public String getScanName() throws ScanException {
        return this.m_scanVIPList.get(0).getFQDNScanName();
    }

    @Override
    @Deprecated
    public int getPort() throws ScanException {
        if (this.m_scanListenerList.size() == 0) {
            this.initialize();
        }
        if (this.m_scanListenerList.size() > 0) {
            return this.m_scanListenerList.get(0).getPort();
        }
        throw new ScanException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, ResourceLiterals.SCAN.toString() + " " + ResourceLiterals.LISTENER.toString());
    }

    @Override
    @Deprecated
    public void setPort(int scanPort) throws PortException, ScanException {
        ScanListenerException excep = null;
        StringBuilder sb = new StringBuilder();
        if (scanPort < 1) {
            throw new PortException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "scanPort", scanPort);
        }
        try {
            String[] names = ScanFactoryImpl.getInstance().getScanVIPNames(this.m_netnum);
            if (names.length > 0) {
                NodeAppsFactoryImpl.getInstance().checkPorts(names, new int[]{scanPort});
            }
        }
        catch (SoftwareModuleException e) {
            throw new ScanException(e);
        }
        catch (CompositeOperationException e) {
            for (int i = 0; i < this.m_scanListenerList.size(); ++i) {
                if (i < this.m_scanListenerList.size() - 1) {
                    sb.append(this.m_scanListenerList.get(i).getName() + ",");
                    continue;
                }
                sb.append(this.m_scanListenerList.get(i).getName());
            }
            throw new PortException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)e, sb.toString());
        }
        if (this.m_scanListenerList.size() == 0) {
            this.initialize();
        }
        if (this.m_scanListenerList.size() == 0) {
            excep = new ScanListenerException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, ResourceLiterals.SCAN.toString() + " " + ResourceLiterals.LISTENER.toString());
            sb.append(excep.getMessage());
        } else {
            for (int i = 0; i < this.m_scanListenerList.size(); ++i) {
                ScanListenerImpl scanLsnr = (ScanListenerImpl)this.m_scanListenerList.get(i);
                try {
                    scanLsnr.setPort(scanPort);
                    continue;
                }
                catch (ScanListenerException e) {
                    excep = e;
                    sb.append(scanLsnr.getName());
                }
            }
        }
        if (sb.length() > 0) {
            throw new ScanException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)excep, sb.toString());
        }
    }

    @Override
    public List<ScanVIP> vips() throws ScanException {
        ArrayList<ScanVIP> vipList = new ArrayList<ScanVIP>(this.m_scanVIPList.size());
        for (ScanVIP scanVIP : this.m_scanVIPList) {
            vipList.add(scanVIP);
        }
        return vipList;
    }

    @Override
    public List<ScanListener> listeners() throws ScanException {
        if (this.m_scanListenerList.size() == 0) {
            this.initialize();
        }
        ArrayList<ScanListener> lsnrList = new ArrayList<ScanListener>(this.m_scanListenerList.size());
        for (ScanListener scanLsnr : this.m_scanListenerList) {
            lsnrList.add(scanLsnr);
        }
        return lsnrList;
    }

    @Override
    public void enable() throws CompositeOperationException, ScanException {
        this.setEnableDisable(true, new Node[0]);
    }

    @Override
    public void disable() throws CompositeOperationException, ScanException {
        this.setEnableDisable(false, new Node[0]);
    }

    @Override
    public void start() throws CompositeOperationException, ScanException {
        this.startResources(new Node[0]);
    }

    @Override
    public void stop(boolean force) throws CompositeOperationException, ScanException {
        this.stopResources(force, new Node[0]);
    }

    @Override
    public void enable(Node node) throws CompositeOperationException, ScanException {
        this.setEnableDisable(true, node);
    }

    @Override
    public void disable(Node node) throws CompositeOperationException, ScanException {
        this.setEnableDisable(false, node);
    }

    @Override
    public void start(Node node) throws CompositeOperationException, ScanException {
        this.startResources(node);
    }

    @Override
    public void stop(Node node, boolean force) throws CompositeOperationException, ScanException {
        this.stopResources(force, node);
    }

    @Override
    public void remove(boolean force) throws CompositeOperationException, ScanException {
        NativeResult nativeResult;
        int i;
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<Object, NativeResult> resultMap = new LinkedHashMap<Object, NativeResult>(this.m_scanListenerList.size() + this.m_scanVIPList.size());
        boolean compositeResult = true;
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new ScanException(e);
        }
        for (i = 0; i < this.m_scanListenerList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanListener scanLsnr = this.m_scanListenerList.get(i);
            try {
                scanLsnr.remove(force);
                nativeResult.setStatus(true);
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (AlreadyRunningException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (ScanListenerException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
            }
        }
        for (i = 0; i < this.m_scanVIPList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanVIP scanVIP = this.m_scanVIPList.get(i);
            try {
                scanVIP.remove(force);
                nativeResult.setStatus(true);
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (AlreadyRunningException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (ScanVIPException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
            }
        }
        if (!compositeResult) {
            throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_REMOVE_FAILED, resultMap, sb.toString());
        }
        resultMap.clear();
        resultMap = null;
    }

    private void startResources(Node ... nodes) throws CompositeOperationException, ScanException {
        NativeResult nativeResult;
        int i;
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<Object, NativeResult> resultMap = new LinkedHashMap<Object, NativeResult>(this.m_scanListenerList.size() + this.m_scanVIPList.size());
        boolean compositeResult = true;
        ArrayList<Node> nodeList = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            nodeList.add(node);
        }
        for (i = 0; i < this.m_scanVIPList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanVIPImpl scanVIP = (ScanVIPImpl)this.m_scanVIPList.get(i);
            try {
                if (nodeList.size() == 0) {
                    scanVIP.start();
                } else {
                    scanVIP.start(nodeList);
                }
                nativeResult.setStatus(true);
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (AlreadyRunningException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (CompositeOperationException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (SoftwareModuleException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
            }
        }
        for (i = 0; i < this.m_scanListenerList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanListenerImpl scanLsnr = (ScanListenerImpl)this.m_scanListenerList.get(i);
            try {
                if (nodeList.size() == 0) {
                    scanLsnr.start();
                } else {
                    scanLsnr.start(nodeList);
                }
                nativeResult.setStatus(true);
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (AlreadyRunningException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (CompositeOperationException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (SoftwareModuleException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
            }
        }
        if (!compositeResult) {
            throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_START_FAILED, resultMap, sb.toString());
        }
        resultMap.clear();
        resultMap = null;
    }

    private void stopResources(boolean forceStop, Node ... nodes) throws CompositeOperationException, ScanException {
        NativeResult nativeResult;
        int i;
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<Object, NativeResult> resultMap = new LinkedHashMap<Object, NativeResult>(this.m_scanListenerList.size() + this.m_scanVIPList.size());
        boolean compositeResult = true;
        ArrayList<Node> nodeList = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            nodeList.add(node);
        }
        for (i = 0; i < this.m_scanListenerList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanListenerImpl scanLsnr = (ScanListenerImpl)this.m_scanListenerList.get(i);
            try {
                if (nodeList.size() == 0) {
                    scanLsnr.stop(forceStop);
                } else {
                    scanLsnr.stop(nodeList, forceStop);
                }
                nativeResult.setStatus(true);
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (AlreadyStoppedException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (CompositeOperationException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (SoftwareModuleException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
            }
        }
        for (i = 0; i < this.m_scanVIPList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanVIPImpl scanVIP = (ScanVIPImpl)this.m_scanVIPList.get(i);
            try {
                if (nodeList.size() == 0) {
                    scanVIP.stop(forceStop);
                } else {
                    scanVIP.stop(nodeList, forceStop);
                }
                nativeResult.setStatus(true);
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (AlreadyStoppedException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (CompositeOperationException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (SoftwareModuleException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
            }
        }
        if (!compositeResult) {
            throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_STOP_FAILED, resultMap, sb.toString());
        }
        resultMap.clear();
        resultMap = null;
    }

    private void setEnableDisable(boolean bEnable, Node ... nodes) throws CompositeOperationException, ScanException {
        NativeResult nativeResult;
        int i;
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<Object, NativeResult> resultMap = new LinkedHashMap<Object, NativeResult>(this.m_scanListenerList.size() + this.m_scanVIPList.size());
        boolean compositeResult = true;
        ArrayList<Node> nodeList = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            nodeList.add(node);
        }
        for (i = 0; i < this.m_scanListenerList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanListenerImpl scanLsnr = (ScanListenerImpl)this.m_scanListenerList.get(i);
            try {
                if (nodeList.size() == 0) {
                    if (bEnable) {
                        scanLsnr.enable();
                    } else {
                        scanLsnr.disable();
                    }
                } else if (bEnable) {
                    scanLsnr.enable(nodeList);
                } else {
                    scanLsnr.disable(nodeList);
                }
                nativeResult.setStatus(true);
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (AlreadyEnabledException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (AlreadyDisabledException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (CompositeOperationException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
                continue;
            }
            catch (SoftwareModuleException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanLsnr.getName() + " ");
                resultMap.put(scanLsnr.getName(), nativeResult);
            }
        }
        for (i = 0; i < this.m_scanVIPList.size(); ++i) {
            nativeResult = new NativeResult();
            ScanVIPImpl scanVIP = (ScanVIPImpl)this.m_scanVIPList.get(i);
            try {
                if (nodeList.size() == 0) {
                    if (bEnable) {
                        scanVIP.enable();
                    } else {
                        scanVIP.disable();
                    }
                } else if (bEnable) {
                    scanVIP.enable(nodeList);
                } else {
                    scanVIP.disable(nodeList);
                }
                nativeResult.setStatus(true);
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (AlreadyEnabledException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (AlreadyDisabledException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (CompositeOperationException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
                continue;
            }
            catch (SoftwareModuleException e) {
                compositeResult = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                sb.append(scanVIP.getName() + " ");
                resultMap.put(scanVIP.getName(), nativeResult);
            }
        }
        if (!compositeResult) {
            throw new CompositeOperationException((MessageKey)(bEnable ? PrCsMsgID.SCAN_ENABLE_FAILED : PrCsMsgID.SCAN_DISABLE_FAILED), resultMap, sb.toString());
        }
        resultMap.clear();
        resultMap = null;
    }
}

