/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.scan;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CRSResourceTypeEntity;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.scan.ScanImpl;
import oracle.cluster.impl.scan.ScanListenerImpl;
import oracle.cluster.impl.scan.ScanVIPImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanListenerException;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.gridnamingservice.QueryTypes;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;

public class ScanFactoryImpl {
    private static final int DEFAULT_SCANVIPS_COUNT = 3;
    private static ScanFactoryImpl s_instance;

    private ScanFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized ScanFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new ScanFactoryImpl();
        }
        return s_instance;
    }

    public static String defaultScanLsnrName() {
        String scanLsnrName = ResourceLiterals.LISTENER.toString().toUpperCase();
        Trace.out("default scanLsnrName is " + scanLsnrName);
        return scanLsnrName;
    }

    public List<ScanVIP> createScanVIP(String scanName, Network network, Version version) throws CompositeOperationException, ScanVIPException {
        return this.createScanVIP(scanName, null, network, version);
    }

    public List<ScanVIP> createScanVIP(String scanName, String[] vips, Network network, Version version) throws CompositeOperationException, ScanVIPException {
        try {
            return this.addScanVIPs(scanName, vips, network, version);
        }
        catch (AlreadyExistsException e) {
            throw new ScanVIPException(e);
        }
    }

    public List<ScanVIP> addScanVIPs(String scanName, String[] vips, Network network, Version version) throws CompositeOperationException, ScanVIPException, AlreadyExistsException {
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        boolean isOPCEnv = false;
        try {
            isOPCEnv = clusterwareInfo.isOPCEnv();
        }
        catch (InstallException ie) {
            Trace.out("Error detecting if OPC env. Details:\n" + ie.getMessage());
            throw new ScanVIPException(ie);
        }
        Trace.out("Is OPC env: " + isOPCEnv);
        boolean isODASingleIP = false;
        boolean isODALite = false;
        if (!isOPCEnv) {
            try {
                isODASingleIP = clusterwareInfo.isODASingleIPEnv();
                if (!isODASingleIP) {
                    isODALite = clusterwareInfo.isODALiteEnv();
                }
            }
            catch (InstallException ie) {
                Trace.out("Error detecting if ODA SingleIP env. Details:\n" + ie.getMessage());
                throw new ScanVIPException(ie);
            }
        }
        Trace.out("Is ODA Single IP env: " + isODASingleIP);
        try {
            int netnum;
            int numOfScanVIPs;
            List<InetAddress> addrListIPv4 = null;
            List<InetAddress> addrListIPv6 = null;
            if (isOPCEnv || isODASingleIP || isODALite) {
                numOfScanVIPs = vips.length;
            } else {
                Map<IPAddressUtil.IPAddrType, List<InetAddress>> scanAddrMap = this.getScanAddrMap(scanName, vips, network, false, false);
                addrListIPv4 = scanAddrMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                addrListIPv6 = scanAddrMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                int numOfIPv4Addr = addrListIPv4.size();
                int numOfIPv6Addr = addrListIPv6.size();
                if (numOfIPv6Addr == 0 && numOfIPv4Addr == 0) {
                    throw new ScanVIPException((MessageKey)PrCsMsgID.NO_IPV4_OR_IPV6_FOR_SCAN_NAME, scanName);
                }
                if (numOfIPv4Addr != 0 && numOfIPv6Addr != 0 && numOfIPv4Addr != numOfIPv6Addr) {
                    throw new ScanVIPException((MessageKey)PrCsMsgID.IPV4_IPV6_SIZE_MISMATCH, scanName, numOfIPv4Addr, numOfIPv6Addr);
                }
                numOfScanVIPs = numOfIPv4Addr != 0 ? numOfIPv4Addr : numOfIPv6Addr;
            }
            try {
                netnum = network.getNumber();
            }
            catch (NetworkException ne) {
                throw new ScanVIPException((MessageKey)PrCnMsgID.NETNUM_RETRIEVAL_ERROR, (Throwable)ne, new Object[0]);
            }
            try {
                List<ScanVIP> scanVIPList = this.getScanVIPs(netnum);
                Trace.out("SCAN VIPs were already added to network with netnum=" + netnum);
                throw new AlreadyExistsException((MessageKey)PrCsMsgID.SCAN_VIP_ALREADY_CREATED, netnum);
            }
            catch (NotExistsException nee) {
                Trace.out("Calling createScanVIP. There is no scan vip created.");
                ArrayList<ScanVIP> scanVIPList = new ArrayList<ScanVIP>(numOfScanVIPs);
                HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(numOfScanVIPs);
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                for (int i = 0; i < numOfScanVIPs; ++i) {
                    String resourceName = ScanVIPImpl.getResourceName(netnum, i + 1);
                    NativeResult nativeResult = new NativeResult();
                    try {
                        ScanVIPImpl scanVIP = new ScanVIPImpl(crsFactory.create(ResourceType.ScanVIP.NAME.name(), resourceName));
                        if (isOPCEnv || isODASingleIP || isODALite) {
                            scanVIP.create(scanName, network, version, vips[i]);
                        } else {
                            Inet4Address ipv4Addr = !addrListIPv4.isEmpty() ? (Inet4Address)addrListIPv4.get(i) : null;
                            Inet6Address ipv6Addr = !addrListIPv6.isEmpty() ? (Inet6Address)addrListIPv6.get(i) : null;
                            scanVIP.create(scanName, network, version, ipv4Addr, ipv6Addr);
                        }
                        scanVIPList.add(scanVIP);
                        nativeResult.setStatus(true);
                        resultMap.put(resourceName, nativeResult);
                        continue;
                    }
                    catch (AlreadyExistsException aee) {
                        nativeResult.setStatus(false);
                        nativeResult.setException(aee);
                        resultMap.put(resourceName, nativeResult);
                        continue;
                    }
                    catch (CRSException crse) {
                        nativeResult.setStatus(false);
                        nativeResult.setException(crse);
                        resultMap.put(resourceName, nativeResult);
                    }
                }
                if (scanVIPList.size() == numOfScanVIPs) {
                    resultMap.clear();
                    resultMap = null;
                    return scanVIPList;
                }
                throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_CREATE_FAILED, resultMap, scanName);
            }
        }
        catch (CRSException crse) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_CREATE_FAILED, (Throwable)crse, scanName);
        }
    }

    public Network getNetworkForScan() throws NotExistsException, NetworkException {
        Network nw;
        block3: {
            nw = null;
            try {
                List<ScanVIP> svipList = this.getScanVIPs();
                if (svipList == null) break block3;
                for (ScanVIP svip : svipList) {
                    if (nw != null || (nw = svip.network()) == null) continue;
                    break;
                }
            }
            catch (ScanVIPException e) {
                throw new NetworkException(e);
            }
        }
        return nw;
    }

    public void removeScanVIPs(boolean force) throws CompositeOperationException, NotExistsException, ScanVIPException {
        this.removeScanVIPs(1, force);
    }

    public void removeScanVIPs(int netnum, boolean force) throws CompositeOperationException, NotExistsException, ScanVIPException {
        List<ScanVIP> svipList = null;
        String scanName = null;
        boolean status = true;
        Network netw = null;
        DHCPServerType serverType = DHCPServerType.NONE;
        try {
            Trace.out("Getting Node apps instance");
            NodeAppsFactoryImpl naf = NodeAppsFactoryImpl.getInstance();
            Trace.out("Got Node apps instance, search network");
            netw = naf.getNetwork(String.valueOf(netnum));
            Trace.out("Network found");
        }
        catch (NotExistsException nee) {
            Trace.out("Network with number " + netnum + " does not exist");
        }
        catch (NetworkException ne) {
            Trace.out("Cannot get network with number " + netnum);
        }
        catch (SoftwareModuleException e) {
            Trace.out("Cannot get instance of NodeAppsFactory: " + e.getMessage());
        }
        svipList = netw != null ? this.getScanVIPs(netnum) : this.getAllScanVIPs();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(svipList.size());
        for (ScanVIP svip : svipList) {
            String resourceName = svip.getName();
            scanName = netw != null ? svip.getScanName() : svip.getUserAssignedName();
            Trace.out("SCAN VIP resource name is " + resourceName);
            NativeResult nativeResult = new NativeResult();
            try {
                svip.remove(force);
            }
            catch (AlreadyRunningException e) {
                Trace.out(e.getMessage());
                status = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                resultMap.put(resourceName, nativeResult);
            }
            catch (ScanVIPException e) {
                Trace.out(e.getMessage());
                status = false;
                nativeResult.setStatus(false);
                nativeResult.setException(e);
                resultMap.put(resourceName, nativeResult);
            }
        }
        if (status) {
            resultMap.clear();
            resultMap = null;
            if (scanName != null) {
                this.unadvertiseName(scanName);
            }
        } else {
            Trace.out("Throw CompositeOperationException.");
            throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_REMOVE_FAILED, resultMap, scanName);
        }
    }

    public List<ScanVIP> modifyScanVIP(String scanName) throws CompositeOperationException, ScanVIPException {
        return this.modifyScanVIP(scanName, null);
    }

    public List<ScanVIP> modifyScanVIP(String scanName, String[] vips) throws CompositeOperationException, ScanVIPException {
        return this.modifyScanVIP(1, scanName, vips);
    }

    public List<ScanVIP> modifyScanVIP(int netnum, String scanName, String[] vips) throws CompositeOperationException, ScanVIPException {
        List<ScanVIP> scanVIPList;
        block82: {
            scanVIPList = null;
            String before_modify_scan_name = null;
            try {
                ScanVIPImpl scanVIP;
                String resourceName;
                Map vipMap;
                boolean status = true;
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                scanVIPList = this.getScanVIPs(netnum);
                int svipSize = scanVIPList.size();
                if (svipSize > 0) {
                    before_modify_scan_name = scanVIPList.get(0).getScanName();
                    Trace.out("Before modify scan name is : " + before_modify_scan_name);
                }
                Version version = new Version();
                Network network = NodeAppsFactoryImpl.getInstance().getNetwork(String.valueOf(netnum));
                Map<IPAddressUtil.IPAddrType, DHCPServerType> serverTypeMap = network.dhcpServerTypes();
                boolean useDNS = serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4) == DHCPServerType.DHCP || serverTypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6) == DHCPServerType.AUTOCONFIG;
                Map<IPAddressUtil.IPAddrType, List<InetAddress>> scanAddrMap = this.getScanAddrMap(scanName, vips, network, useDNS, false);
                List<InetAddress> addrListIPv4 = scanAddrMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                List<InetAddress> addrListIPv6 = scanAddrMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                int numOfIPv4Addr = addrListIPv4.size();
                int numOfIPv6Addr = addrListIPv6.size();
                if (numOfIPv6Addr == 0 && numOfIPv4Addr == 0) {
                    throw new ScanVIPException((MessageKey)PrCsMsgID.NO_IPV4_OR_IPV6_FOR_SCAN_NAME, scanName);
                }
                if (numOfIPv4Addr != 0 && numOfIPv6Addr != 0 && numOfIPv4Addr != numOfIPv6Addr) {
                    throw new ScanVIPException((MessageKey)PrCsMsgID.IPV4_IPV6_SIZE_MISMATCH, scanName, numOfIPv4Addr, numOfIPv6Addr);
                }
                if (network.addressType() == IPAddressUtil.IPAddrType.BOTH) {
                    if (numOfIPv4Addr == 0) {
                        throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_NAME_DOES_NOT_RESOLVE_TO_BOTH, scanName, "IPv4");
                    }
                    if (numOfIPv6Addr == 0) {
                        throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_NAME_DOES_NOT_RESOLVE_TO_BOTH, scanName, "IPv6");
                    }
                }
                try {
                    this.setScanNameHelper(scanName, netnum, true);
                }
                catch (ScanVIPException svipe) {
                    throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_MODIFY_FAILED, (Throwable)svipe, scanName);
                }
                int numOfScanVIPs = numOfIPv4Addr != 0 ? numOfIPv4Addr : numOfIPv6Addr;
                HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(numOfScanVIPs);
                HashMap<InetAddress, ScanVIP> addrNameMap = new HashMap<InetAddress, ScanVIP>(2 * scanVIPList.size());
                HashMap<IPAddressUtil.IPAddrType, ArrayList<InetAddress>> curAddr = new HashMap<IPAddressUtil.IPAddrType, ArrayList<InetAddress>>(2 * scanVIPList.size());
                HashMap<ScanVIP, Map<IPAddressUtil.IPAddrType, InetAddress>> scanVIPAddrMap = new HashMap<ScanVIP, Map<IPAddressUtil.IPAddrType, InetAddress>>(scanVIPList.size());
                HashSet modSet = null;
                HashSet<InetAddress> newSet = null;
                HashSet keepSet = null;
                HashSet curSet = null;
                Collections.sort(scanVIPList);
                for (ScanVIP svip : scanVIPList) {
                    List<InetAddress> tmpList;
                    Map<IPAddressUtil.IPAddrType, InetAddress> tmpMap = svip.addresses();
                    Trace.out("Current address map for vip %s is %s", svip.getUserAssignedName(), tmpMap.toString());
                    scanVIPAddrMap.put(svip, tmpMap);
                    if (tmpMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                        tmpList = (ArrayList<InetAddress>)curAddr.get((Object)IPAddressUtil.IPAddrType.IPv4);
                        if (tmpList == null) {
                            tmpList = new ArrayList<InetAddress>();
                            curAddr.put(IPAddressUtil.IPAddrType.IPv4, (ArrayList<InetAddress>)tmpList);
                        }
                        tmpList.add(tmpMap.get((Object)IPAddressUtil.IPAddrType.IPv4));
                        addrNameMap.put(tmpMap.get((Object)IPAddressUtil.IPAddrType.IPv4), svip);
                    }
                    if (!tmpMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) continue;
                    tmpList = (List)curAddr.get((Object)IPAddressUtil.IPAddrType.IPv6);
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                        curAddr.put(IPAddressUtil.IPAddrType.IPv6, (ArrayList<InetAddress>)tmpList);
                    }
                    tmpList.add(tmpMap.get((Object)IPAddressUtil.IPAddrType.IPv6));
                    addrNameMap.put(tmpMap.get((Object)IPAddressUtil.IPAddrType.IPv6), svip);
                }
                newSet = new HashSet<InetAddress>();
                newSet.addAll(addrListIPv4);
                newSet.addAll(addrListIPv6);
                modSet = new HashSet();
                if (curAddr.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                    modSet.addAll((Collection)curAddr.get((Object)IPAddressUtil.IPAddrType.IPv4));
                }
                if (curAddr.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                    modSet.addAll((Collection)curAddr.get((Object)IPAddressUtil.IPAddrType.IPv6));
                }
                keepSet = new HashSet(modSet);
                curSet = new HashSet(modSet);
                modSet.removeAll(newSet);
                keepSet.retainAll(newSet);
                newSet.removeAll(curSet);
                if (modSet.isEmpty() && newSet.isEmpty() && !keepSet.isEmpty()) {
                    Trace.out("New SCAN name %s resolves to the same addresses as %s", scanName, before_modify_scan_name);
                    return scanVIPList;
                }
                int ix4 = 0;
                int ix6 = 0;
                HashSet<ScanVIP> modVIPList = new HashSet<ScanVIP>();
                if (numOfScanVIPs >= svipSize) {
                    for (ScanVIP svip : scanVIPList) {
                        vipMap = (Map)scanVIPAddrMap.get(svip);
                        if (vipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                            if (!keepSet.contains(vipMap.get((Object)IPAddressUtil.IPAddrType.IPv4))) {
                                if (addrListIPv4.isEmpty()) {
                                    vipMap.remove((Object)IPAddressUtil.IPAddrType.IPv4);
                                    modVIPList.add(svip);
                                } else {
                                    while (ix4 < addrListIPv4.size() && !newSet.contains(addrListIPv4.get(ix4))) {
                                        ++ix4;
                                    }
                                    if (ix4 < addrListIPv4.size()) {
                                        vipMap.put(IPAddressUtil.IPAddrType.IPv4, addrListIPv4.get(ix4++));
                                        modVIPList.add(svip);
                                    } else {
                                        Trace.out("Internal error, miscalculated scan vip indexes");
                                    }
                                }
                            }
                        } else if (!addrListIPv4.isEmpty()) {
                            while (ix4 < addrListIPv4.size() && !newSet.contains(addrListIPv4.get(ix4))) {
                                ++ix4;
                            }
                            if (ix4 < addrListIPv4.size()) {
                                vipMap.put(IPAddressUtil.IPAddrType.IPv4, addrListIPv4.get(ix4++));
                                modVIPList.add(svip);
                            } else {
                                Trace.out("Internal error, miscalculated scanvip indexes");
                            }
                        }
                        if (vipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                            if (!keepSet.contains(vipMap.get((Object)IPAddressUtil.IPAddrType.IPv6))) {
                                if (addrListIPv6.isEmpty()) {
                                    vipMap.remove((Object)IPAddressUtil.IPAddrType.IPv6);
                                    modVIPList.add(svip);
                                } else {
                                    while (ix6 < addrListIPv6.size() && !newSet.contains(addrListIPv6.get(ix6))) {
                                        ++ix6;
                                    }
                                    if (ix6 < addrListIPv6.size()) {
                                        vipMap.put(IPAddressUtil.IPAddrType.IPv6, addrListIPv6.get(ix6++));
                                        modVIPList.add(svip);
                                    } else {
                                        Trace.out("Internal error, miscalculated scan vip indexes");
                                    }
                                }
                            }
                        } else if (!addrListIPv6.isEmpty()) {
                            while (ix6 < addrListIPv6.size() && !newSet.contains(addrListIPv6.get(ix6))) {
                                ++ix6;
                            }
                            if (ix6 < addrListIPv6.size()) {
                                vipMap.put(IPAddressUtil.IPAddrType.IPv6, addrListIPv6.get(ix6++));
                                modVIPList.add(svip);
                            } else {
                                Trace.out("Internal error, miscalculated scanvip indexes");
                            }
                        }
                        Trace.out("After change address map for vip %s is %s", svip.getUserAssignedName(), vipMap.toString());
                    }
                } else {
                    for (ScanVIP svip : scanVIPList) {
                        vipMap = (Map)scanVIPAddrMap.get(svip);
                        if (ix4 < addrListIPv4.size()) {
                            vipMap.put(IPAddressUtil.IPAddrType.IPv4, addrListIPv4.get(ix4++));
                            modVIPList.add(svip);
                        }
                        if (ix6 < addrListIPv6.size()) {
                            vipMap.put(IPAddressUtil.IPAddrType.IPv6, addrListIPv6.get(ix6++));
                            modVIPList.add(svip);
                        }
                        Trace.out("After change address map for vip %s is %s", svip.getUserAssignedName(), vipMap.toString());
                    }
                }
                for (ScanVIP svip : modVIPList) {
                    StringBuilder addrStr = new StringBuilder();
                    Map vipMap2 = (Map)scanVIPAddrMap.get(svip);
                    Trace.out("About to modify addresses for vip" + svip.getUserAssignedName());
                    if (vipMap2.get((Object)IPAddressUtil.IPAddrType.IPv4) != null) {
                        addrStr.append(((InetAddress)vipMap2.get((Object)IPAddressUtil.IPAddrType.IPv4)).getHostAddress());
                    }
                    if (vipMap2.get((Object)IPAddressUtil.IPAddrType.IPv6) != null) {
                        if (addrStr.length() != 0) {
                            addrStr.append(" ");
                        }
                        addrStr.append(((InetAddress)vipMap2.get((Object)IPAddressUtil.IPAddrType.IPv6)).getHostAddress());
                    }
                    try {
                        if (addrStr.length() <= 0) continue;
                        Trace.out("New USR_ORA_VIP value:" + addrStr + " for vip " + svip.getUserAssignedName());
                        ResourceAttribute attr = CRSFactoryImpl.getInstance().create(ResourceType.ClusterVIP.USR_ORA_VIP.name(), addrStr.toString());
                        ((CRSResourceImpl)svip.crsResource()).update(attr);
                    }
                    catch (CRSException | NotExistsException e) {
                        throw new ScanVIPException(e);
                    }
                }
                if (scanVIPAddrMap.size() < numOfScanVIPs) {
                    for (int i = scanVIPAddrMap.size(); i < numOfScanVIPs; ++i) {
                        Inet4Address ipv4Addr = null;
                        Inet6Address ipv6Addr = null;
                        while (ix4 < addrListIPv4.size() && !newSet.contains(addrListIPv4.get(ix4))) {
                            ++ix4;
                        }
                        if (ix4 < addrListIPv4.size()) {
                            ipv4Addr = (Inet4Address)addrListIPv4.get(ix4++);
                        }
                        while (ix6 < addrListIPv6.size() && !newSet.contains(addrListIPv6.get(ix6))) {
                            ++ix6;
                        }
                        if (ix6 < addrListIPv6.size()) {
                            ipv6Addr = (Inet6Address)addrListIPv6.get(ix6++);
                        }
                        if (ipv4Addr == null && ipv6Addr == null) continue;
                        resourceName = ScanVIPImpl.getResourceName(netnum, i + 1);
                        Trace.out("About to create " + resourceName);
                        scanVIP = new ScanVIPImpl(crsFactory.create(ResourceType.ScanVIP.NAME.name(), resourceName));
                        try {
                            scanVIP.create(scanName, network, version, ipv4Addr, ipv6Addr);
                            scanVIPList.add(scanVIP);
                            continue;
                        }
                        catch (AlreadyExistsException impossible) {
                            Trace.out("Internal error, scan already exists");
                        }
                    }
                }
                for (int i = numOfScanVIPs; i < svipSize; ++i) {
                    resourceName = ScanVIPImpl.getResourceName(netnum, i + 1);
                    NativeResult nativeResult = new NativeResult();
                    boolean isStopFailed = false;
                    try {
                        scanVIP = (ScanVIPImpl)this.getScanVIP(resourceName);
                        ScanListener scanLsnr = null;
                        try {
                            scanLsnr = scanVIP.listener();
                            Trace.out("Remove SCAN listener " + scanLsnr.getName() + " that depents on the SCAN VIP " + scanVIP.getName());
                            if (scanLsnr.isRunning()) {
                                try {
                                    scanLsnr.stop(true);
                                }
                                catch (SoftwareModuleException sme) {
                                    Trace.out("Stopping SCAN Listener " + scanLsnr.getName() + " failed: " + sme.getMessage());
                                    isStopFailed = true;
                                }
                                catch (AlreadyStoppedException ex) {
                                    Trace.out("SCAN Listener " + scanLsnr.getName() + " is stopped.");
                                }
                            }
                            scanLsnr.remove(isStopFailed);
                        }
                        catch (NotExistsException nee) {
                            Trace.out("Can't remove. SCAN Listener for SCAN VIP " + scanVIP.getName() + " does not exist.");
                        }
                        catch (ScanListenerException e) {
                            Trace.out("Can't remove. Removing SCAN Listener " + scanLsnr.getName() + " failed: " + e.getMessage());
                            status = false;
                            nativeResult.setStatus(false);
                            nativeResult.setException(e);
                            resultMap.put(resourceName, nativeResult);
                        }
                        catch (AlreadyRunningException e) {
                            Trace.out("Can't remove. SCAN Listener " + scanLsnr.getName() + " is running.");
                            status = false;
                            nativeResult.setStatus(false);
                            nativeResult.setException(e);
                            resultMap.put(resourceName, nativeResult);
                        }
                        if (!status) continue;
                        isStopFailed = false;
                        if (scanVIP.isRunning()) {
                            try {
                                scanVIP.stop(true);
                            }
                            catch (SoftwareModuleException sme) {
                                Trace.out("Can't stop. Stopping SCAN VIP " + scanVIP.getName() + " failed: " + sme.getMessage());
                                isStopFailed = true;
                            }
                            catch (AlreadyStoppedException ex) {
                                Trace.out("SCAN VIP " + scanVIP.getName() + " is stopped.");
                            }
                        }
                        scanVIP.remove(isStopFailed);
                        continue;
                    }
                    catch (NotExistsException nee) {
                        Trace.out("Can't remove. SCANVIP " + resourceName + " does not exist.");
                        continue;
                    }
                    catch (AlreadyRunningException are) {
                        Trace.out("Can't remove. SCANVIP " + resourceName + " is running.");
                        status = false;
                        nativeResult.setStatus(false);
                        nativeResult.setException(are);
                        resultMap.put(resourceName, nativeResult);
                    }
                }
                if (status) {
                    resultMap.clear();
                    resultMap = null;
                    if (before_modify_scan_name != null && !before_modify_scan_name.equalsIgnoreCase(scanName)) {
                        this.unadvertiseName(before_modify_scan_name);
                    }
                    break block82;
                }
                Trace.out("Throw CompositeOperationException.");
                throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_MODIFY_FAILED, resultMap, scanName);
            }
            catch (NetworkException ne) {
                throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_MODIFY_FAILED, (Throwable)ne, scanName);
            }
            catch (SoftwareModuleException sme) {
                throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_MODIFY_FAILED, (Throwable)sme, scanName);
            }
            catch (NotExistsException nee) {
                throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_MODIFY_FAILED, (Throwable)nee, scanName);
            }
            catch (CRSException crse) {
                throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_MODIFY_FAILED, (Throwable)crse, scanName);
            }
        }
        return scanVIPList;
    }

    public ScanVIP getScanVIP(String resName) throws NotExistsException, ScanVIPException {
        try {
            return this.getScanVIP(CRSFactoryImpl.getInstance().create(ResourceType.ScanVIP.NAME.name(), resName));
        }
        catch (CRSException e) {
            throw new ScanVIPException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanVIPException(e);
        }
    }

    public Map<IPAddressUtil.IPAddrType, List<ScanVIP>> getMapForAllScanVIPs() throws NotExistsException, ScanVIPException {
        HashMap<IPAddressUtil.IPAddrType, List<ScanVIP>> scanVIPMap = new HashMap<IPAddressUtil.IPAddrType, List<ScanVIP>>();
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> svipList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.ScanVIP.NAME.toString()));
            if (svipList.size() == 0) {
                throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_VIPS_NOT_FOUND, ResourceLiterals.TYPE.name() + "=" + ResourceType.ScanVIP.NAME.toString(), svipList.toString());
            }
            ArrayList<ScanVIPImpl> scanVIPListIPv4 = new ArrayList<ScanVIPImpl>(svipList.size());
            ArrayList<ScanVIPImpl> scanVIPListIPv6 = new ArrayList<ScanVIPImpl>(svipList.size());
            for (ResourceAttribute attr : svipList) {
                try {
                    ScanVIPImpl currScanVIP = this.getScanVIP(attr);
                    Map<IPAddressUtil.IPAddrType, InetAddress> addressMap = currScanVIP.addresses();
                    if (addressMap.get((Object)IPAddressUtil.IPAddrType.IPv4) != null) {
                        scanVIPListIPv4.add(currScanVIP);
                    }
                    if (addressMap.get((Object)IPAddressUtil.IPAddrType.IPv6) == null) continue;
                    scanVIPListIPv6.add(currScanVIP);
                }
                catch (NotExistsException notExistsException) {}
            }
            if (scanVIPListIPv4.size() > 0) {
                scanVIPMap.put(IPAddressUtil.IPAddrType.IPv4, scanVIPListIPv4);
            }
            if (scanVIPListIPv6.size() > 0) {
                scanVIPMap.put(IPAddressUtil.IPAddrType.IPv6, scanVIPListIPv4);
            }
            return scanVIPMap;
        }
        catch (CRSException crse) {
            throw new ScanVIPException(crse);
        }
    }

    public List<ScanVIP> getAllScanVIPs() throws NotExistsException, ScanVIPException {
        return this.getScanVIPs(null);
    }

    public List<ScanVIP> getScanVIPs() throws NotExistsException, ScanVIPException {
        return this.getScanVIPs(1);
    }

    public List<ScanVIP> getScanVIPs(int netnum) throws NotExistsException, ScanVIPException {
        return this.getScanVIPs((Integer)netnum);
    }

    private List<ScanVIP> getScanVIPs(Integer netnum) throws NotExistsException, ScanVIPException {
        List<ResourceAttribute> svipResAttrList = null;
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (netnum != null) {
                String[] attrNames = new String[]{ResourceLiterals.TYPE.name(), ResourceType.ScanVIP.NETNUM.name()};
                String[] attrValues = new String[]{ResourceType.ScanVIP.NAME.toString(), String.valueOf(netnum)};
                Trace.out("Calling searchResources to get the SCAN VIPs on network with 'netnum = " + netnum + "'");
                svipResAttrList = crsFactory.searchResources_matchAll(attrNames, attrValues);
            } else {
                String attrName = ResourceLiterals.TYPE.name();
                String attrValue = ResourceType.ScanVIP.NAME.toString();
                Trace.out("Calling searchResources to get the SCAN VIPs on all networks");
                svipResAttrList = crsFactory.searchResources(crsFactory.create(attrName, attrValue));
            }
        }
        catch (CRSException crse) {
            throw new ScanVIPException(crse);
        }
        if (svipResAttrList.size() == 0) {
            if (netnum != null) {
                throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_VIPS_NOT_FOUND_ON_NETWORK, ResourceLiterals.TYPE.name() + "=" + ResourceType.ScanVIP.NAME.toString(), netnum);
            }
            throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_VIPS_NOT_FOUND, ResourceLiterals.TYPE.name() + "=" + ResourceType.ScanVIP.NAME.toString());
        }
        ArrayList<ScanVIP> scanVIPList = new ArrayList<ScanVIP>(svipResAttrList.size());
        for (ResourceAttribute resAttr : svipResAttrList) {
            try {
                scanVIPList.add(this.getScanVIP(resAttr));
            }
            catch (NotExistsException notExistsException) {}
        }
        return scanVIPList;
    }

    public List<ScanVIP> getScanVIPsByScanName(String scanName) throws NotExistsException, ScanVIPException {
        List<ResourceAttribute> svipResAttrList = null;
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String[] attrNames = new String[]{ResourceLiterals.TYPE.name(), ResourceType.ScanVIP.SCAN_NAME.name()};
            String[] attrValues = new String[]{ResourceType.ScanVIP.NAME.toString(), scanName};
            svipResAttrList = crsFactory.searchResources_matchAll(attrNames, attrValues, false);
        }
        catch (CRSException crse) {
            throw new ScanVIPException(crse);
        }
        if (svipResAttrList.size() == 0) {
            throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_VIPS_NOT_FOUND, ResourceType.ScanVIP.SCAN_NAME.name() + "=" + scanName);
        }
        ArrayList<ScanVIP> scanVIPList = new ArrayList<ScanVIP>(svipResAttrList.size());
        for (ResourceAttribute resAttr : svipResAttrList) {
            try {
                scanVIPList.add(this.getScanVIP(resAttr));
            }
            catch (NotExistsException notExistsException) {}
        }
        return scanVIPList;
    }

    ScanVIPImpl getScanVIP(ResourceAttribute resAttr) throws NotExistsException, ScanVIPException {
        try {
            ScanVIPImpl scanVIP = new ScanVIPImpl(resAttr);
            CRSResource crsRes = scanVIP.crsResource();
            return scanVIP;
        }
        catch (SoftwareModuleException e) {
            throw new ScanVIPException(e);
        }
    }

    public List<ScanListener> createScanListener(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck) throws CompositeOperationException, ScanListenerException {
        try {
            return this.addScanListeners(sLsnrName, endpoints, version, skipportscheck);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> createScanListenerwithNodes(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedNodes) throws CompositeOperationException, ScanListenerException {
        try {
            return this.addScanListenerswithNodes(sLsnrName, endpoints, version, skipportscheck, invitedNodes);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> createScanListenerwithSubnets(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        try {
            return this.addScanListenerswithSubnets(sLsnrName, endpoints, version, skipportscheck, invitedSubnets);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> createScanListener(String sLsnrName, Endpoints endpoints, Version version, boolean skipportscheck, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException {
        try {
            return this.addScanListeners(sLsnrName, endpoints, version, skipportscheck, invitedNodes, invitedSubnets);
        }
        catch (AlreadyExistsException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> addScanListeners(String scanListenerName, Endpoints endpoints, Version version, boolean skipPortCheck) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        return this.addScanListeners(scanListenerName, endpoints, version, skipPortCheck, null, null);
    }

    public List<ScanListener> addScanListeners(String scanListenerName, int netnum, Endpoints endpoints, Version version, boolean skipPortCheck) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        return this.addScanListeners(scanListenerName, netnum, endpoints, version, skipPortCheck, null, null);
    }

    public List<ScanListener> addScanListenerswithNodes(String scanListenerName, Endpoints endpoints, Version version, boolean skipPortCheck, String invitedNodes) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        return this.addScanListenerswithNodes(scanListenerName, 1, endpoints, version, skipPortCheck, invitedNodes);
    }

    public List<ScanListener> addScanListenerswithNodes(String scanListenerName, int netnum, Endpoints endpoints, Version version, boolean skipPortCheck, String invitedNodes) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        return this.addScanListeners(scanListenerName, netnum, endpoints, version, skipPortCheck, invitedNodes, null);
    }

    public List<ScanListener> addScanListenerswithSubnets(String scanListenerName, Endpoints endpoints, Version version, boolean skipPortCheck, String invitedSubnets) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        return this.addScanListeners(scanListenerName, 1, endpoints, version, skipPortCheck, null, invitedSubnets);
    }

    public List<ScanListener> addScanListenerswithSubnets(String scanListenerName, int netnum, Endpoints endpoints, Version version, boolean skipPortCheck, String invitedSubnets) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        return this.addScanListeners(scanListenerName, netnum, endpoints, version, skipPortCheck, null, invitedSubnets);
    }

    public List<ScanListener> addScanListeners(String scanListenerName, Endpoints endpoints, Version version, boolean skipPortCheck, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        return this.addScanListeners(scanListenerName, 1, endpoints, version, skipPortCheck, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> addScanListeners(String scanListenerName, int netnum, Endpoints endpoints, Version version, boolean skipPortCheck, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, AlreadyExistsException {
        String scanLsnrName = scanListenerName;
        Endpoints scanLsnrEndpoints = endpoints;
        try {
            if (this.isLeafNetwork(netnum)) {
                throw new ScanListenerException((MessageKey)PrCsMsgID.ADD_RESOURCE_ON_LEAF_NETWORK_ERROR, netnum);
            }
            if (endpoints != null && endpoints.isFirewallConfigured()) {
                throw new ScanListenerException((MessageKey)PrCnMsgID.FIREWALL_LISTENER_ERROR, new Object[]{ResourceLiterals.SCAN_LISTENER});
            }
            NodeAppsFactoryImpl naf = NodeAppsFactoryImpl.getInstance();
            if (scanListenerName == null) {
                scanLsnrName = ScanFactoryImpl.defaultScanLsnrName();
            }
            if (endpoints == null) {
                scanLsnrEndpoints = naf.createEndpoints();
            }
            int[] scanListenerPorts = scanLsnrEndpoints.getTCPPortArr();
            List<ScanVIP> svipList = this.getScanVIPs(netnum);
            Trace.out("scanLsnrName=" + scanLsnrName);
            try {
                List<ScanListener> scanLsnrList = this.getScanListeners(netnum);
                throw new AlreadyExistsException((MessageKey)PrCsMsgID.SCAN_LSNR_ALREADY_CREATED, netnum);
            }
            catch (NotExistsException nee) {
                ArrayList<ScanListener> scanLsnrList = new ArrayList<ScanListener>(svipList.size());
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                String[] vips = this.getRunningScanVIPs(netnum);
                if (vips.length > 0 && !skipPortCheck) {
                    try {
                        naf.checkPorts(vips, scanListenerPorts);
                    }
                    catch (CompositeOperationException coe) {
                        throw new ScanListenerException((MessageKey)PrCsMsgID.SCAN_LSNR_CREATE_FAILED, (Throwable)coe, scanLsnrName);
                    }
                }
                NativeResult nativeResult = null;
                HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(svipList.size());
                for (int i = 0; i < svipList.size(); ++i) {
                    ScanListenerImpl scanListener;
                    nativeResult = new NativeResult();
                    String resourceName = ScanListenerImpl.getResourceName(scanLsnrName, netnum, i + 1);
                    Trace.out("resourceName=" + resourceName);
                    try {
                        scanListener = (ScanListenerImpl)this.getScanListener(resourceName);
                    }
                    catch (NotExistsException nee2) {
                        scanListener = null;
                    }
                    try {
                        if (scanListener == null) {
                            scanListener = new ScanListenerImpl(crsFactory.create(ResourceType.ScanListener.NAME.name(), resourceName));
                            scanListener.create(scanLsnrEndpoints, svipList.get(i), version, invitedNodes, invitedSubnets);
                        }
                        scanLsnrList.add(scanListener);
                        nativeResult.setStatus(true);
                        resultMap.put(resourceName, nativeResult);
                        continue;
                    }
                    catch (AlreadyExistsException aee) {
                        nativeResult.setStatus(false);
                        nativeResult.setException(aee);
                        resultMap.put(resourceName, nativeResult);
                        continue;
                    }
                    catch (CRSException crse) {
                        nativeResult.setStatus(false);
                        nativeResult.setException(crse);
                        resultMap.put(resourceName, nativeResult);
                    }
                }
                if (scanLsnrList.size() == svipList.size()) {
                    resultMap.clear();
                    resultMap = null;
                    return scanLsnrList;
                }
                throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_LSNR_CREATE_FAILED, resultMap, scanLsnrName);
            }
        }
        catch (NotExistsException nee) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.SCAN_LSNR_CREATE_FAILED, (Throwable)nee, scanLsnrName);
        }
        catch (ScanVIPException svipe) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.SCAN_LSNR_CREATE_FAILED, (Throwable)svipe, scanLsnrName);
        }
        catch (CRSException crse) {
            throw new ScanListenerException(crse);
        }
        catch (ListenerException le) {
            throw new ScanListenerException(le);
        }
        catch (SoftwareModuleException sme) {
            throw new ScanListenerException(sme);
        }
    }

    public List<ScanListener> modifyScanListener(Endpoints endpoints) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return this.modifyScanListener(endpoints, null, null);
    }

    public List<ScanListener> modifyScanListener(Endpoints endpoints, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return this.modifyScanListener(1, endpoints, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener(int netnum, Endpoints endpoints, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        int[] tcpPortArr = null;
        int tcpPortNum = 0;
        if (this.isLeafNetwork(netnum)) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.MODIFY_RESOURCE_ON_LEAF_NETWORK_ERROR, netnum);
        }
        if (endpoints != null && endpoints.isFirewallConfigured()) {
            throw new ScanListenerException((MessageKey)PrCnMsgID.FIREWALL_LISTENER_ERROR, new Object[]{ResourceLiterals.SCAN_LISTENER});
        }
        if (endpoints == null || endpoints.getTCPPortStr() == null && endpoints.getTCPSPortStr() == null) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.SCAN_LSNR_MODIFY_FAILED, endpoints == null ? null : endpoints.toString());
        }
        tcpPortArr = endpoints.getTCPPortArr();
        if (tcpPortArr != null) {
            tcpPortNum = tcpPortArr.length;
        }
        for (int i = 0; i < tcpPortNum; ++i) {
            if (tcpPortArr[i] > 1023 && tcpPortArr[i] <= 65535) continue;
            throw new ScanListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_PORT, tcpPortArr[i]);
        }
        NativeResult nativeResult = null;
        boolean status = true;
        List<ScanListener> scanLsnrList = this.getScanListeners(netnum);
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(scanLsnrList.size());
        for (ScanListener scanLsnr : scanLsnrList) {
            try {
                ((ScanListenerImpl)scanLsnr).setEndpoints(endpoints);
                if (invitedNodes != null) {
                    ((ScanListenerImpl)scanLsnr).setInvitedNodes(invitedNodes);
                }
                if (invitedSubnets != null) {
                    ((ScanListenerImpl)scanLsnr).setInvitedSubnets(invitedSubnets);
                }
                nativeResult = new NativeResult();
                nativeResult.setStatus(true);
                resultMap.put(scanLsnr.getName(), nativeResult);
            }
            catch (ScanListenerException sle) {
                status = false;
                nativeResult.setStatus(false);
                nativeResult.setException(sle);
                resultMap.put(scanLsnr.getName(), nativeResult);
            }
        }
        if (status) {
            resultMap.clear();
            resultMap = null;
            return scanLsnrList;
        }
        throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_LSNR_MODIFY_FAILED, resultMap, endpoints.toString());
    }

    public List<ScanListener> modifyScanListener() throws CompositeOperationException, ScanListenerException, NotExistsException {
        return this.modifyScanListener(1);
    }

    public List<ScanListener> modifyScanListener(int netnum) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return this.modifyScanListener(netnum, null, null);
    }

    public List<ScanListener> modifyScanListener(String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        return this.modifyScanListener(1, invitedNodes, invitedSubnets);
    }

    public List<ScanListener> modifyScanListener(int netnum, String invitedNodes, String invitedSubnets) throws CompositeOperationException, ScanListenerException, NotExistsException {
        String scanName = null;
        int svipSize = 0;
        Endpoints scanLsnrEP = null;
        if (this.isLeafNetwork(netnum)) {
            throw new ScanListenerException((MessageKey)PrCsMsgID.MODIFY_RESOURCE_ON_LEAF_NETWORK_ERROR, netnum);
        }
        try {
            NativeResult nativeResult;
            ScanListenerImpl scanLsnr;
            String resourceName;
            int i;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ScanVIP> svipList = null;
            try {
                svipList = this.getScanVIPs(netnum);
                svipSize = svipList.size();
                Iterator<ScanVIP> iterator = svipList.iterator();
                if (iterator.hasNext()) {
                    ScanVIP svip = iterator.next();
                    scanName = svip.getScanName();
                }
            }
            catch (ScanVIPException svipe) {
                throw new ScanListenerException(svipe);
            }
            Trace.out("The number of scan vip is " + svipSize);
            List<ScanListener> scanLsnrList = this.getScanListeners(netnum);
            ScanListener slsnr = null;
            int slsnrSize = scanLsnrList.size();
            slsnr = scanLsnrList.get(0);
            scanLsnrEP = slsnr.getEndpoints();
            String scanLsnrName = slsnr.getListenerName();
            Version version = new Version();
            for (ScanListener scan : scanLsnrList) {
                Trace.out("Updating scan listener " + scan.getListenerName());
                if (invitedNodes != null) {
                    scan.setInvitedNodes(invitedNodes);
                }
                if (invitedSubnets == null) continue;
                scan.setInvitedSubnets(invitedSubnets);
            }
            HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(svipSize);
            boolean status = true;
            for (i = 0; i < svipSize; ++i) {
                resourceName = ScanListenerImpl.getResourceName(scanLsnrName, netnum, i + 1);
                Trace.out("resourceName=" + resourceName);
                try {
                    scanLsnr = (ScanListenerImpl)this.getScanListener(resourceName);
                }
                catch (NotExistsException e) {
                    scanLsnr = null;
                }
                if (scanLsnr != null) continue;
                nativeResult = new NativeResult();
                try {
                    scanLsnr = new ScanListenerImpl(crsFactory.create(ResourceType.ScanListener.NAME.name(), resourceName));
                    ScanVIP scanVIP = this.getScanVIP(ScanVIPImpl.getResourceName(netnum, i + 1));
                    scanLsnr.create(scanLsnrEP, scanVIP, version, slsnr.getInvitedNodes(), slsnr.getInvitedSubnets());
                    scanLsnrList.add(scanLsnr);
                    nativeResult.setStatus(true);
                    resultMap.put(resourceName, nativeResult);
                    continue;
                }
                catch (ScanVIPException svipe) {
                    status = false;
                    nativeResult.setStatus(false);
                    nativeResult.setException(svipe);
                    resultMap.put(resourceName, nativeResult);
                    continue;
                }
                catch (AlreadyExistsException aee) {
                    status = false;
                    nativeResult.setStatus(false);
                    nativeResult.setException(aee);
                    resultMap.put(resourceName, nativeResult);
                    continue;
                }
                catch (CRSException crse) {
                    status = false;
                    nativeResult.setStatus(false);
                    nativeResult.setException(crse);
                    resultMap.put(resourceName, nativeResult);
                }
            }
            for (i = svipSize; i < slsnrSize; ++i) {
                resourceName = ScanListenerImpl.getResourceName(scanLsnrName, netnum, i + 1);
                Trace.out("resourceName=" + resourceName);
                nativeResult = new NativeResult();
                try {
                    scanLsnr = (ScanListenerImpl)this.getScanListener(resourceName);
                    scanLsnr.remove(false);
                    nativeResult.setStatus(true);
                    resultMap.put(resourceName, nativeResult);
                    continue;
                }
                catch (NotExistsException nee) {
                    Trace.out("Can't remove. SCANVIP " + resourceName + " does not exist.");
                    continue;
                }
                catch (AlreadyRunningException are) {
                    Trace.out("Can't remove. SCANVIP " + resourceName + " is running.");
                    status = false;
                    nativeResult.setStatus(false);
                    nativeResult.setException(are);
                    resultMap.put(resourceName, nativeResult);
                }
            }
            if (status) {
                resultMap.clear();
                resultMap = null;
                return scanLsnrList;
            }
            throw new CompositeOperationException((MessageKey)PrCsMsgID.SCAN_LSNR_CREATE_FAILED, resultMap, scanLsnrName);
        }
        catch (CRSException crse) {
            throw new ScanListenerException(crse);
        }
    }

    public ScanListener getScanListener(String resName) throws NotExistsException, ScanListenerException {
        try {
            return this.getScanListener(CRSFactoryImpl.getInstance().create(ResourceType.ScanListener.NAME.name(), resName));
        }
        catch (CRSException e) {
            throw new ScanListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
    }

    ScanListenerImpl getScanListener(ResourceAttribute resAttr) throws NotExistsException, ScanListenerException {
        try {
            Trace.out("Calling new ScanListenerImpl for " + resAttr);
            ScanListenerImpl scanLsnr = new ScanListenerImpl(resAttr);
            Trace.out("Calling scanLsnr.crsResource()");
            CRSResource crsRes = scanLsnr.crsResource();
            Trace.out("Return from scanLsnr.crsResource()");
            return scanLsnr;
        }
        catch (SoftwareModuleException e) {
            throw new ScanListenerException(e);
        }
    }

    public List<ScanListener> getAllScanListeners() throws NotExistsException, ScanListenerException {
        return this.getScanListeners(null);
    }

    public List<ScanListener> getScanListeners() throws NotExistsException, ScanListenerException {
        return this.getScanListeners(1);
    }

    public List<ScanListener> getScanListeners(int netnum) throws NotExistsException, ScanListenerException {
        return this.getScanListeners((Integer)netnum);
    }

    private List<ScanListener> getScanListeners(Integer netnum) throws NotExistsException, ScanListenerException {
        List<ResourceAttribute> scanListenerResAttrList = null;
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (netnum != null) {
                String[] attrNames = new String[]{ResourceLiterals.TYPE.name(), ResourceType.ScanListener.NETNUM.name()};
                String[] attrValues = new String[]{ResourceType.ScanListener.NAME.toString(), String.valueOf(netnum)};
                Trace.out("Calling searchResources to get the SCAN listeners on network with 'netnum = " + netnum + "'");
                scanListenerResAttrList = crsFactory.searchResources_matchAll(attrNames, attrValues);
            } else {
                String attrName = ResourceLiterals.TYPE.name();
                String attrValue = ResourceType.ScanListener.NAME.toString();
                Trace.out("Calling searchResources to get the SCAN listeners on all networks");
                scanListenerResAttrList = crsFactory.searchResources(crsFactory.create(attrName, attrValue));
            }
        }
        catch (CRSException crse) {
            throw new ScanListenerException(crse);
        }
        Trace.out(scanListenerResAttrList.size() + " SCAN listeners found");
        if (scanListenerResAttrList.size() == 0) {
            if (netnum != null) {
                throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_LSNRS_NOT_FOUND_ON_NETWORK, ResourceLiterals.TYPE.name() + "=" + ResourceType.ScanListener.NAME.toString(), netnum);
            }
            throw new NotExistsException((MessageKey)PrCsMsgID.SCAN_LSNRS_NOT_FOUND, ResourceLiterals.TYPE.name() + "=" + ResourceType.ScanListener.NAME.toString());
        }
        ArrayList<ScanListener> list = new ArrayList<ScanListener>(scanListenerResAttrList.size());
        for (ResourceAttribute res : scanListenerResAttrList) {
            try {
                list.add(this.getScanListener(res));
            }
            catch (NotExistsException notExistsException) {}
        }
        return list;
    }

    public Scan getScan() throws ScanException {
        return ScanImpl.getInstance(1);
    }

    public Scan getScan(int netnum) throws ScanException {
        return ScanImpl.getInstance(netnum);
    }

    public List<Scan> getScans(int netnum) throws ScanException {
        ArrayList<Scan> scanList = new ArrayList<Scan>(1);
        scanList.add(this.getScan(netnum));
        return scanList;
    }

    public void upgradeScanVIP(Version.VersionEnum sourceVersion, Version.VersionEnum destVersion) throws UpgradeException {
        this.upgradeScanVIP(1, sourceVersion, destVersion);
    }

    public void upgradeScanVIP(int netnum, Version.VersionEnum sourceVersion, Version.VersionEnum destVersion) throws UpgradeException {
        String scanName = null;
        try {
            Version.VersionEnum version = Version.VersionEnum.getEnumMember(new Version().toString());
            if (destVersion == Version.VersionEnum.V11202 && sourceVersion == Version.VersionEnum.V11201 && !Version.isPre11202(version.toVersion())) {
                CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
                scanName = this.getScanNameHelper(netnum);
                crsFactoryImpl.upgradeType(ResourceType.ScanVIP.class);
                if (scanName != null) {
                    this.setScanNameHelper(scanName, netnum, true);
                }
            }
        }
        catch (CRSException crse) {
            throw new UpgradeException(crse);
        }
        catch (ConfigurationException e) {
            throw new UpgradeException(e);
        }
        catch (ScanVIPException e) {
            throw new UpgradeException(e);
        }
    }

    protected String[] getScanVIPNames(int netnum) throws ScanVIPException {
        try {
            List<ScanVIP> svipList = this.getScanVIPs(netnum);
            ArrayList<String> nameList = new ArrayList<String>(svipList.size());
            for (ScanVIP scanVIP : svipList) {
                if (!scanVIP.isRunning()) continue;
                nameList.add(scanVIP.address().getHostName());
            }
            String[] names = new String[nameList.size()];
            nameList.toArray(names);
            return names;
        }
        catch (NotExistsException nee) {
            throw new ScanVIPException(nee);
        }
        catch (SoftwareModuleException sme) {
            throw new ScanVIPException(sme);
        }
    }

    private String[] getRunningScanVIPs(int netnum) throws ScanVIPException {
        try {
            List<ScanVIP> svipList = this.getScanVIPs(netnum);
            ArrayList<String> vipList = new ArrayList<String>(svipList.size());
            for (ScanVIP scanVIP : svipList) {
                if (!scanVIP.isRunning()) continue;
                ResourceAttribute attr = ((CRSResourceImpl)scanVIP.crsResource()).getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
                String vipName = attr.getValue().trim();
                int vipNameDelimiterIndex = vipName.indexOf(" ");
                if (vipNameDelimiterIndex != -1) {
                    vipList.add(vipName.substring(0, vipNameDelimiterIndex));
                    vipList.add(vipName.substring(vipNameDelimiterIndex + 1));
                    continue;
                }
                if (vipName.length() == 0) {
                    Trace.out("Should never happen. A running Scan VIP should always have vip specified");
                    continue;
                }
                vipList.add(vipName);
            }
            String[] vips = new String[vipList.size()];
            vipList.toArray(vips);
            return vips;
        }
        catch (NotExistsException nee) {
            throw new ScanVIPException(nee);
        }
        catch (SoftwareModuleException sme) {
            throw new ScanVIPException(sme);
        }
        catch (CRSException ce) {
            throw new ScanVIPException(ce);
        }
    }

    String getScanNameHelper(int netnum) {
        Trace.out("Calling getScanNameHelper for scan name");
        List<ScanVIP> svipList = null;
        String scanName = null;
        try {
            svipList = this.getScanVIPs(netnum);
            CRSResource svipRes = svipList.get(0).crsResource();
            scanName = ((CRSResourceImpl)svipRes).getAttribute(ResourceType.ScanVIP.SCAN_NAME.name()).getValue().trim();
            Trace.out("Get scanName " + scanName);
        }
        catch (NotExistsException e) {
            Trace.out("No SCAN VIP registered. Do not use SCAN_NAME value in type. Return null for scanName");
        }
        catch (ScanVIPException e) {
            Trace.out("Warning: Got ScanVIPException: " + e.getMessage());
        }
        catch (CRSException e) {
            Trace.out("Warning: Got CRSException: " + e.getMessage());
        }
        return scanName;
    }

    private void setScanNameHelper(String scanName, int netnum, boolean checkScanVIPs) throws ScanVIPException, CRSException {
        Trace.out("Calling setScanNameHelper for scan name " + scanName);
        List<ScanVIP> scanVIPList = null;
        try {
            if (checkScanVIPs) {
                scanVIPList = this.getScanVIPs(netnum);
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            boolean bScanNameChanged = false;
            if (checkScanVIPs) {
                List<ResourceAttribute> attrList = null;
                block2: for (ScanVIP svip : scanVIPList) {
                    CRSResource svipRes = svip.crsResource();
                    attrList = ((CRSResourceImpl)svipRes).getAttributes(new String[0]);
                    for (ResourceAttribute attr : attrList) {
                        if (!attr.getName().equalsIgnoreCase(ResourceType.ScanVIP.SCAN_NAME.name()) || scanName.equals(attr.getValue())) continue;
                        Trace.out("For scan " + svip.getName() + ", change scan name from " + attr.getValue() + " to " + scanName);
                        ((CRSResourceImpl)svipRes).update(crsFactory.create(ResourceType.ScanVIP.SCAN_NAME.name(), scanName));
                        bScanNameChanged = true;
                        continue block2;
                    }
                }
            }
            if (bScanNameChanged) {
                ResourceAttribute scanVIPTypeAttr = crsFactory.create(ResourceType.ScanVIP.NAME.name(), ResourceType.ScanVIP.NAME.toString());
                CRSResourceTypeEntity resType = crsFactory.getResourceTypeEntity(scanVIPTypeAttr);
                resType.update(crsFactory.create(ResourceType.ScanVIP.SCAN_NAME.name(), ""));
            }
        }
        catch (NotExistsException nee) {
            throw new ScanVIPException(nee);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<IPAddressUtil.IPAddrType, List<InetAddress>> getScanAddrMap(String scanName, String[] vips, Network network, boolean useDNS, boolean skipReachabilityCheck) throws ScanVIPException {
        ArrayList<InetAddress> addrListIPv6;
        ArrayList<InetAddress> addrListIPv4;
        HashMap<IPAddressUtil.IPAddrType, List<InetAddress>> scanAddrMap = new HashMap<IPAddressUtil.IPAddrType, List<InetAddress>>();
        InetAddress[] addrList = null;
        try {
            block45: {
                List<Object> addresses;
                int numOfAttempts;
                boolean dnslookup;
                block49: {
                    block47: {
                        block48: {
                            if (vips != null) break block47;
                            dnslookup = false;
                            DHCPServerType networkDHCPServerType = network.addressType() == IPAddressUtil.IPAddrType.IPv4 ? network.dhcpServerType() : network.dhcpServerTypeIPv6();
                            if (networkDHCPServerType.equals((Object)DHCPServerType.NONE)) {
                                dnslookup = true;
                            } else {
                                GNS gns;
                                try {
                                    GNSFactory gnsFactory = GNSFactory.getInstance();
                                    gns = gnsFactory.getGNS();
                                }
                                catch (NotExistsException nee) {
                                    Trace.out("Calling getGNS. Get NotExistsException");
                                    gns = null;
                                }
                                catch (SoftwareModuleException sme) {
                                    Trace.out("Calling getGNS. Get SoftwareModuleException " + sme.getMessage());
                                    gns = null;
                                }
                                catch (VIPNotFoundException vfe) {
                                    Trace.out("Calling getGNS. Get VIPNotFoundException " + vfe.getMessage());
                                    gns = null;
                                }
                                if (gns == null || gns.getName() == null) {
                                    dnslookup = true;
                                }
                            }
                            if (!useDNS && !dnslookup) break block48;
                            numOfAttempts = 10;
                            addresses = null;
                            break block49;
                        }
                        Trace.out("Create the default addrList");
                        addrList = new InetAddress[3];
                        for (int i = 0; i < addrList.length; ++i) {
                            addrList[i] = null;
                        }
                        break block45;
                    }
                    addrList = new InetAddress[vips.length];
                    for (int i = 0; i < vips.length; ++i) {
                        addrList[i] = InetAddress.getByName(vips[i]);
                    }
                    break block45;
                }
                for (int attemptIndex = 0; attemptIndex < numOfAttempts; ++attemptIndex) {
                    try {
                        Trace.out("Attempt #" + attemptIndex + " to resolve the scanName\"" + scanName + "\" using DNS");
                        Map<IPAddressUtil.IPAddrType, List<InetAddress>> resolutionMap = IPAddressUtil.resolveHostname(scanName);
                        addresses = new ArrayList();
                        if (resolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                            addresses = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                        }
                        if (resolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                            addresses.addAll((Collection<Object>)resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv6));
                        }
                        addrList = addresses.toArray(new InetAddress[0]);
                    }
                    catch (IPAddressException ipae) {
                        Trace.out("Failed to resolve the scan name \"" + scanName + "\". Got IPAddressException " + ipae.getMessage());
                    }
                    if (addrList == null) continue;
                    Trace.out("Resolved the scanName with " + addrList.length + " vips");
                    break;
                }
                if (addrList == null) {
                    if (useDNS && !dnslookup) {
                        Trace.out("The SCAN name does not resolve in DNS. Using GNS to create new SCAN VIPs using the new SCAN name \"" + scanName + "\"");
                        addrList = new InetAddress[3];
                        for (int i = 0; i < addrList.length; ++i) {
                            addrList[i] = null;
                        }
                        break block45;
                    } else {
                        Trace.out("After " + numOfAttempts + " still failed to resolve scan name \"" + scanName + "\". Therefore, throwing ScanVIPException");
                        throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_LOOKUP_FAILED, scanName);
                    }
                }
                if (!skipReachabilityCheck) {
                    Map<Boolean, List<InetAddress>> reacMap = IPAddressUtil.getPingabilityMap(addresses);
                    List<InetAddress> addrLst = reacMap.get(Boolean.TRUE);
                    HashSet<InetAddress> addrMap = this.getAllScanAddresses(network.getNumber());
                    if (addrLst != null) {
                        StringBuilder sb = null;
                        for (InetAddress addri : addrLst) {
                            if (addrMap.contains(addri)) continue;
                            if (sb == null) {
                                sb = new StringBuilder(addri.getHostAddress());
                                continue;
                            }
                            sb.append(",");
                            sb.append(addri.getHostAddress());
                        }
                        if (sb != null) {
                            Trace.out((Object)"Addresses %s are reachable.", sb.toString());
                            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_ADDRESSES_REACHABILITY_ERROR, sb.toString());
                        }
                    }
                }
            }
            addrListIPv4 = new ArrayList<InetAddress>(addrList.length);
            addrListIPv6 = new ArrayList<InetAddress>(addrList.length);
            for (InetAddress addr : addrList) {
                String ipStr;
                block51: {
                    boolean ipv6SubnetMatch;
                    block52: {
                        int addri;
                        InetAddress[] inetAddressArray;
                        Subnet ipv6Subnet;
                        block53: {
                            String netSubnetStr;
                            VIPAddress vipAddr;
                            block46: {
                                Map<IPAddressUtil.IPAddrType, Subnet> subnetMap;
                                block50: {
                                    if (addr == null) {
                                        if (network.addressType() == IPAddressUtil.IPAddrType.IPv4) {
                                            addrListIPv4.add(addr);
                                            continue;
                                        }
                                        addrListIPv6.add(addr);
                                        continue;
                                    }
                                    subnetMap = network.subnets();
                                    ipStr = addr.getHostAddress();
                                    Trace.out("Check address " + ipStr);
                                    if (!ipStr.startsWith("10.") && !ipStr.startsWith("0.")) break block50;
                                    if (subnetMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) break block51;
                                    ipv6SubnetMatch = false;
                                    ipv6Subnet = subnetMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                                    if (ipv6Subnet == null) break block52;
                                    inetAddressArray = addrList;
                                    addri = inetAddressArray.length;
                                    break block53;
                                }
                                vipAddr = null;
                                netSubnetStr = null;
                                if (IPAddressUtil.isIPv4AddressString(ipStr)) {
                                    if (subnetMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                                        Subnet ipv4Subnet = subnetMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                                        vipAddr = new VIPAddress(ipStr, ipStr, ipv4Subnet.subnetMaskAsStr(), null);
                                        netSubnetStr = ipv4Subnet.getName();
                                        addrListIPv4.add(addr);
                                        break block46;
                                    } else {
                                        if (IPAddressUtil.getAddrTypeFromAddressOrName(scanName) == IPAddressUtil.IPAddrType.BOTH) continue;
                                        throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_NAME_RESOLVES_TO_NON_EXISTING_ADDRESS_TYPE, scanName, "IPv4", ipStr, network.getNumber(), "IPv6");
                                    }
                                }
                                if (IPAddressUtil.isIPv6AddressString(ipStr)) {
                                    if (subnetMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                                        Subnet ipv6Subnet2 = subnetMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                                        vipAddr = new VIPAddress(ipStr, ipStr, ipv6Subnet2.subnetMaskAsStr(), null);
                                        netSubnetStr = ipv6Subnet2.getName();
                                        addrListIPv6.add(addr);
                                    } else {
                                        if (IPAddressUtil.getAddrTypeFromAddressOrName(scanName) == IPAddressUtil.IPAddrType.BOTH) continue;
                                        throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_NAME_RESOLVES_TO_NON_EXISTING_ADDRESS_TYPE, scanName, "IPv6", ipStr, network.getNumber(), "IPv4");
                                    }
                                }
                            }
                            String subnetStr = vipAddr.getSubnet();
                            if (subnetStr == null || netSubnetStr == null) {
                                throw new ScanVIPException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "scan-vip_error-03");
                            }
                            boolean scanVIPSubnetMismatch = false;
                            try {
                                scanVIPSubnetMismatch = !IPAddressUtil.sameIPAddresses(subnetStr, netSubnetStr);
                            }
                            catch (IPAddressException ipae) {
                                scanVIPSubnetMismatch = true;
                            }
                            if (!scanVIPSubnetMismatch) continue;
                            if (subnetStr == null) {
                                subnetStr = "";
                            }
                            if (netSubnetStr == null) {
                                netSubnetStr = "";
                            }
                            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_VIP_DIF_SUBNET, scanName, subnetStr, ipStr, netSubnetStr, network.getNumber());
                        }
                        for (int i = 0; i < addri; ++i) {
                            String addressIPv6Subnet;
                            InetAddress address = inetAddressArray[i];
                            if (!(address instanceof Inet6Address) || !IPAddressUtil.sameIPAddresses(addressIPv6Subnet = IPAddressUtil.keepLeftHandBits(address.getHostAddress(), ipv6Subnet.getSubnetPrefix()), ipv6Subnet.getName())) continue;
                            ipv6SubnetMatch = true;
                            break;
                        }
                    }
                    if (!ipv6SubnetMatch) {
                        throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_VIP_ADDRESS_DOES_NOT_BELONG_TO_NETWORK, ipStr, network.getNumber(), "IPv6");
                    }
                }
                addrListIPv4.add(addr);
                Trace.out("Allows 10.x.x.x IP or 0.x.x.x IP " + ipStr + " for testing");
            }
        }
        catch (UnknownHostException e) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_LOOKUP_FAILED, scanName);
        }
        catch (NetworkException e) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_LOOKUP_FAILED, (Throwable)e, scanName);
        }
        catch (NotExistsException e) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_LOOKUP_FAILED, (Throwable)e, scanName);
        }
        catch (VirtualIPException e) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_LOOKUP_FAILED, (Throwable)e, scanName);
        }
        catch (IPAddressException e) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.SCAN_LOOKUP_FAILED, (Throwable)e, scanName);
        }
        scanAddrMap.put(IPAddressUtil.IPAddrType.IPv4, addrListIPv4);
        scanAddrMap.put(IPAddressUtil.IPAddrType.IPv6, addrListIPv6);
        return scanAddrMap;
    }

    private boolean isLeafNetwork(int netnum) {
        try {
            NodeAppsFactoryImpl naf = NodeAppsFactoryImpl.getInstance();
            Network netw = naf.getNetwork(String.valueOf(netnum));
            return netw.isLeafNW();
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Cannot get NodeAppsFactory instance");
            return false;
        }
        catch (NotExistsException nee) {
            Trace.out("Network " + netnum + " does not exist");
            return false;
        }
    }

    public void assertStaticAddr(IPAddressUtil.IPAddrType ipType, String scanName) throws ScanVIPException, NotExistsException {
        List<ScanVIP> vipList = this.getScanVIPsByScanName(scanName);
        boolean addrExistsIPv4 = false;
        boolean addrExistsIPv6 = false;
        for (ScanVIP svip : vipList) {
            Map<IPAddressUtil.IPAddrType, InetAddress> vipAddr = svip.addresses();
            if (ipType == IPAddressUtil.IPAddrType.BOTH) {
                addrExistsIPv4 = vipAddr.containsKey((Object)IPAddressUtil.IPAddrType.IPv4);
                addrExistsIPv6 = vipAddr.containsKey((Object)IPAddressUtil.IPAddrType.IPv6);
                if (!addrExistsIPv4 || !addrExistsIPv6) continue;
                Trace.out("Found static addresses for IPv4 and IPv6");
                return;
            }
            if (!vipAddr.containsKey((Object)ipType)) continue;
            Trace.out("Found static " + ipType.toString() + "address");
            return;
        }
        if (ipType == IPAddressUtil.IPAddrType.IPv4) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.NO_STATIC_IPV4_ADDRESSES, scanName);
        }
        if (ipType == IPAddressUtil.IPAddrType.IPv6) {
            throw new ScanVIPException((MessageKey)PrCsMsgID.NO_STATIC_IPV6_ADDRESSES, scanName);
        }
        throw new ScanVIPException((MessageKey)PrCsMsgID.NO_STATIC_IPV4_6_ADDRESSES, scanName);
    }

    public void upgradeSCANVIP12101To122LastPhase() throws UpgradeException {
        block14: {
            int netNum = -1;
            List<Network> netList = null;
            try {
                NodeAppsFactoryImpl naf = NodeAppsFactoryImpl.getInstance();
                try {
                    netList = naf.getNetworks();
                }
                catch (NotExistsException e) {
                    Trace.out("No network resource. Not an error for upgrade.");
                }
                if (netList == null) break block14;
                for (Network net : netList) {
                    boolean doRemBoth = false;
                    boolean doRemIPv4 = false;
                    boolean doRemIPv6 = false;
                    Map<IPAddressUtil.IPAddrType, DHCPServerType> serverMap = net.dhcpServerTypes();
                    if (serverMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && serverMap.get((Object)IPAddressUtil.IPAddrType.IPv4).equals((Object)DHCPServerType.DHCP)) {
                        doRemIPv4 = true;
                    }
                    if (serverMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6) && serverMap.get((Object)IPAddressUtil.IPAddrType.IPv6).equals((Object)DHCPServerType.AUTOCONFIG)) {
                        if (doRemIPv4) {
                            doRemBoth = true;
                            doRemIPv4 = false;
                        } else {
                            doRemIPv6 = true;
                        }
                    }
                    Trace.out("Remove IPv4:%b, Remove IPv6:%b, Remove BOTH:%b", doRemIPv4, doRemIPv6, doRemBoth);
                    netNum = net.getNumber();
                    List<ScanVIP> sVipList = null;
                    try {
                        sVipList = this.getScanVIPs(netNum);
                    }
                    catch (NotExistsException nee) {
                        Trace.out("No SCAN VIP resources.Not an error for upgrade.");
                    }
                    if (sVipList == null) continue;
                    for (ScanVIP sVip_i : sVipList) {
                        if (doRemBoth) {
                            ((ScanVIPImpl)sVip_i).removeAddressType(IPAddressUtil.IPAddrType.BOTH);
                        }
                        if (doRemIPv4) {
                            ((ScanVIPImpl)sVip_i).removeAddressType(IPAddressUtil.IPAddrType.IPv4);
                        }
                        if (!doRemIPv6) continue;
                        ((ScanVIPImpl)sVip_i).removeAddressType(IPAddressUtil.IPAddrType.IPv6);
                    }
                }
            }
            catch (SoftwareModuleException e) {
                Trace.out("Upgrade SCAN VIP. Got Exception." + e.getMessage());
                throw new UpgradeException(e);
            }
        }
    }

    public void upgradeScanVIPDepAttrs(ResourceAttribute resAttr, List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws UpgradeException {
        try {
            ScanVIPImpl scanVIP = new ScanVIPImpl(resAttr);
            scanVIP.upgradeScanVIPDepAttrs(attrList, inclStartDep, inclStopDep);
        }
        catch (ScanVIPException e) {
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_DEPENDENCIES, (Throwable)e, resAttr.getValue());
        }
    }

    private void unadvertiseName(String name) {
        GNS gns = null;
        try {
            GNSFactory gnsFact = GNSFactory.getInstance();
            gns = gnsFact.getGNS();
            if (!gns.isGNSConfigured(false)) {
                gns = null;
            }
        }
        catch (SoftwareModuleException | NotExistsException | VIPNotFoundException e) {
            gns = null;
            Trace.out((Object)"failed to get GNS instance: %s. Not an error", e.getMessage());
        }
        try {
            if (gns != null) {
                String gnsSubd = gns.getSubdomain();
                String gnsSubwCluster = gns.query(QueryTypes.SUBDOMAIN);
                gns.deleteName(name + '.' + gnsSubd);
                gns.deleteName(name + '.' + gnsSubwCluster);
            }
        }
        catch (GNSException ge) {
            Trace.out((Object)"Could not delete the name:%s. Not an error", ge.getMessage());
        }
    }

    private HashSet<InetAddress> getAllScanAddresses(int netnum) throws ScanVIPException {
        HashSet<InetAddress> retSet = new HashSet<InetAddress>();
        try {
            List<ScanVIP> scanVIPList = this.getScanVIPs(netnum);
            Map<IPAddressUtil.IPAddrType, InetAddress> tmpMap = null;
            for (ScanVIP svip : scanVIPList) {
                tmpMap = svip.addresses();
                Trace.out("Current address map for vip %s is %s", svip.getUserAssignedName(), tmpMap.toString());
                if (tmpMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                    retSet.add(tmpMap.get((Object)IPAddressUtil.IPAddrType.IPv4));
                }
                if (!tmpMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) continue;
                retSet.add(tmpMap.get((Object)IPAddressUtil.IPAddrType.IPv6));
            }
        }
        catch (NotExistsException nee) {
            Trace.out("There is no Scan VIP configured.");
        }
        return retSet;
    }
}

