/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.util.HashMap;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.priv.ChannelFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.RemoteArgs;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ExecCommandNoUserEqImpl
implements ExecCommandNoUserEq {
    private static final String ROOT = Utils.getRootUserName();
    private String m_asUser = null;
    private String[] m_stdin = null;
    private String m_sudoUser = null;
    private String m_password = null;
    private String m_sudoLocation = null;
    private ConfigurationSetup.ConfigMethod m_mode = null;
    private NodeProgressListener m_npListener = null;
    private static HashMap<String, String> s_lockMap = null;
    private String lock;

    ExecCommandNoUserEqImpl(RemoteArgs remoteArgs) {
        if (remoteArgs.getMode() == ConfigurationSetup.ConfigMethod.SUDO) {
            this.m_sudoUser = remoteArgs.getSudoUser().trim();
            this.m_sudoLocation = remoteArgs.getSudoLocation();
        }
        this.m_password = remoteArgs.getPassword();
        this.m_mode = remoteArgs.getMode();
        this.m_npListener = remoteArgs.getListener();
        this.m_asUser = remoteArgs.getAsUser();
        this.m_stdin = remoteArgs.getStdin();
        this.initializeLockMap();
    }

    ExecCommandNoUserEqImpl(UserInfo userInfo) throws InvalidArgsException {
        Utils.assertInputNotNull(userInfo, "userInfo");
        Utils.assertInput(userInfo.getUsername(), "user name");
        Utils.assertInput(userInfo.getPassword(), "user password");
        this.m_sudoUser = userInfo.getUsername().trim();
        this.m_password = userInfo.getPassword();
    }

    ExecCommandNoUserEqImpl(RemoteUserInfo userInfo, String asUser) throws InvalidArgsException {
        Utils.assertInputNotNull(userInfo, "userInfo");
        Utils.assertInput(asUser, "asUser");
        this.m_asUser = asUser.trim();
        if (userInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT) {
            Utils.assertInput(userInfo.getPassword(), "rootPassword");
        } else {
            ExecCommandNoUserEqImpl.validateUserPass(userInfo.getUsername(), userInfo.getPassword(), userInfo.getSudoLocation());
            this.m_sudoUser = userInfo.getUsername().trim();
            this.m_sudoLocation = userInfo.getSudoLocation();
        }
        this.m_password = userInfo.getPassword();
        this.m_mode = userInfo.getMode();
        this.initializeLockMap();
    }

    ExecCommandNoUserEqImpl(RemoteUserInfo userInfo, String asUser, String[] stdin) throws InvalidArgsException {
        Utils.assertInputNotNull(userInfo, "userInfo");
        Utils.assertInput(asUser, "asUser");
        this.m_asUser = asUser.trim();
        Utils.assertInputNotNull(stdin, "stdin");
        this.m_stdin = stdin;
        if (userInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT) {
            Utils.assertInput(userInfo.getPassword(), "rootPassword");
        } else {
            ExecCommandNoUserEqImpl.validateUserPass(userInfo.getUsername(), userInfo.getPassword(), userInfo.getSudoLocation());
            this.m_sudoUser = userInfo.getUsername().trim();
            this.m_sudoLocation = userInfo.getSudoLocation();
        }
        this.m_password = userInfo.getPassword();
        this.m_mode = userInfo.getMode();
        this.initializeLockMap();
    }

    ExecCommandNoUserEqImpl(RemoteUserInfo userInfo, String asUser, NodeProgressListener npListener) throws InvalidArgsException {
        Utils.assertInputNotNull(userInfo, "userInfo");
        Utils.assertInputNotNull(npListener, "npListener");
        this.m_npListener = npListener;
        Utils.assertInput(asUser, "asUser");
        this.m_asUser = asUser.trim();
        if (userInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT) {
            Utils.assertInput(userInfo.getPassword(), "rootPassword");
        } else {
            ExecCommandNoUserEqImpl.validateUserPass(userInfo.getUsername(), userInfo.getPassword(), userInfo.getSudoLocation());
            this.m_sudoUser = userInfo.getUsername().trim();
            this.m_sudoLocation = userInfo.getSudoLocation();
        }
        this.m_password = userInfo.getPassword();
        this.m_mode = userInfo.getMode();
        this.initializeLockMap();
    }

    ExecCommandNoUserEqImpl(RemoteUserInfo userInfo, String asUser, String[] stdin, NodeProgressListener npListener) throws InvalidArgsException {
        Utils.assertInputNotNull(userInfo, "userInfo");
        Utils.assertInputNotNull(npListener, "npListener");
        this.m_npListener = npListener;
        Utils.assertInput(asUser, "asUser");
        this.m_asUser = asUser.trim();
        Utils.assertInputNotNull(stdin, "stdin");
        this.m_stdin = stdin;
        if (userInfo.getMode() == ConfigurationSetup.ConfigMethod.ROOT) {
            Utils.assertInput(userInfo.getPassword(), "rootPassword");
        } else {
            ExecCommandNoUserEqImpl.validateUserPass(userInfo.getUsername(), userInfo.getPassword(), userInfo.getSudoLocation());
            this.m_sudoUser = userInfo.getUsername().trim();
            this.m_sudoLocation = userInfo.getSudoLocation();
        }
        this.m_password = userInfo.getPassword();
        this.m_mode = userInfo.getMode();
        this.initializeLockMap();
    }

    @Override
    public Map<String, CommandResult> runCmd(String cmd, String[] args, String[] env, String[] nodeList, int timeout) throws ExecException, CompositeOperationException, InvalidArgsException {
        Trace.out("Executing command " + cmd + " with timeout " + timeout);
        Utils.assertInput(cmd, "cmd");
        Utils.assertInputNotNull(args, "args");
        Utils.assertInputNotNull(env, "env");
        if (nodeList == null || nodeList.length < 1) {
            Trace.out("Exception: nodeList is null or empty");
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        String password = this.m_password;
        String user = this.m_sudoUser == null ? null : this.m_sudoUser;
        System.setProperty("RHP_SU_EXEC", "true");
        try {
            ChannelFactoryImpl channelFactoryImpl = ChannelFactoryImpl.getInstance();
            Map<String, CommandResult> result = channelFactoryImpl.doInternalExecuteCommand(nodeList, cmd, env, args, this.m_stdin, this.m_mode, this.m_sudoLocation, user, password, timeout, this.m_npListener, this.m_asUser);
            Trace.out("command " + cmd + " executed successfully");
            return result;
        }
        catch (ChannelException ce) {
            Trace.out("ChannelException caught in ChannelFactoryImpl.doInternalExecuteCommand: " + ce);
            throw new ExecException(ce);
        }
        catch (CompositeOperationException e) {
            Trace.out("Initial CompositeOperationException: " + e.getMessage());
            for (Object identifier : e.getOperationIdentifier()) {
                try {
                    if (e.getNativeResult(identifier).getOSErrCode() == 0) continue;
                    String node = identifier.toString();
                    Trace.out("Adding error message for node " + node + " ...");
                    NativeResult cr = e.getNativeResult(identifier);
                    if (cr.getException() != null) {
                        Trace.out("Exception received on node " + node + ":" + cr.getException().getMessage());
                        continue;
                    }
                    Trace.out("Forming per node error message for node " + node + " ...");
                    String attachedMsg = null;
                    if (cr.getOutputString() != null && cr.getOutputString()[0] != null) {
                        Trace.out("Output string: " + cr.getOutputString()[0]);
                        attachedMsg = cr.getOutputString()[0];
                    }
                    attachedMsg = attachedMsg != null && !attachedMsg.isEmpty() ? attachedMsg + (cr.getOSString() == null ? "" : Constants.LINE_SEPARATOR + cr.getOSString()) : (cr.getOSString() == null ? "" : cr.getOSString());
                    e.getNativeResult(identifier).setException(new ChannelException((MessageKey)PrCzMsgID.REMOTE_COMMAND_EXECUTION_FAILED, cmd, node, this.m_asUser == null ? ROOT : this.m_asUser, attachedMsg));
                    Trace.out("Exception for node " + node + ": " + e.getNativeResult(identifier).getException());
                }
                catch (NoSuchIdentifierException nie) {
                    Trace.out("NoSuchIdentifierException: " + nie.getMessage());
                    throw new ExecException(nie);
                }
            }
            Trace.out("Final CompositeOperationException: " + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, CommandResult> runCmd(String cmd, String[] args, String[] env, String[] nodeList, int timeout, boolean serializeFlag, String cName) throws ExecException, CompositeOperationException, InvalidArgsException {
        Trace.out("Executing command " + cmd + " with timeout " + timeout);
        if (serializeFlag && cName != null) {
            if (s_lockMap.get(cName) == null) {
                s_lockMap.put(cName, cName);
            }
            this.lock = s_lockMap.get(cName);
            Trace.out("Synchronizing on " + cName);
            String string = this.lock;
            synchronized (string) {
                Trace.out("Calling runCmd() now");
                return this.runCmd(cmd, args, env, nodeList, timeout);
            }
        }
        return this.runCmd(cmd, args, env, nodeList, timeout);
    }

    @Override
    public Map<String, CommandResult> runCmd(String cmd, String[] args, String[] nodeList, int timeout) throws ExecException, CompositeOperationException, InvalidArgsException {
        return this.runCmd(cmd, args, new String[0], nodeList, timeout);
    }

    static void validateUserPass(String sudoUser, String sudoPassword) throws InvalidArgsException {
        Utils.assertInput(sudoUser, "sudoUser");
        Utils.assertInputNotNull(sudoPassword, "sudoPassword");
    }

    static void validateUserPass(String sudoUser, String sudoPassword, String sudoLocation) throws InvalidArgsException {
        Utils.assertInput(sudoUser, "sudoUser");
        Utils.assertInputNotNull(sudoPassword, "sudoPassword");
        Utils.assertInput(sudoLocation, "sudoLocation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLockMap() {
        Class<ExecCommandNoUserEq> clazz = ExecCommandNoUserEq.class;
        synchronized (ExecCommandNoUserEq.class) {
            if (s_lockMap == null) {
                s_lockMap = new HashMap();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

