/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.remote.ExecCommand;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.ExecRunTime;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.util.ConcurrencyTimeoutException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.util.RunCtlCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.sUnixCommands;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ExecCommandImpl
implements ExecCommand {
    private static final String ROOT = oracle.cluster.impl.util.Utils.getRootUserName();
    private String m_cmd;
    private String m_node;
    private String[] m_args;
    private String[] m_env;

    public ExecRunTime runCommandNoWait(String cmd, String[] args, String[] env, String node) throws ExecException, InvalidArgsException {
        oracle.cluster.impl.util.Utils.assertInput(cmd, "cmd");
        oracle.cluster.impl.util.Utils.assertInput(node, "node");
        oracle.cluster.impl.util.Utils.assertInputNotNull(args, "args");
        oracle.cluster.impl.util.Utils.assertInputNotNull(env, "env");
        this.m_cmd = cmd;
        this.m_args = args;
        this.m_env = env;
        this.m_node = node;
        ExecRunTime execRunTime = null;
        if (!this.isLocalNode(this.m_node)) {
            int i;
            StringBuilder unixcmd = new StringBuilder();
            unixcmd.append("/usr/bin/ssh");
            unixcmd.append(sUnixCommands.NO_FALLBACK_TO_RSH);
            unixcmd.append(sUnixCommands.NO_PW_AUTHENTICATION);
            unixcmd.append(" -o StrictHostKeyChecking=yes ");
            unixcmd.append(" -o NumberOfPasswordPrompts=0 ");
            unixcmd.append(" ");
            unixcmd.append(this.m_node);
            unixcmd.append(" ");
            boolean singleQuoteExists = this.checkSingleQuotes(cmd) || this.checkSingleQuotes(Utils.getString(env, " ")) || this.checkSingleQuotes(Utils.getString(args, " "));
            unixcmd.append("/usr/bin/sh");
            unixcmd.append(" -c ");
            if (singleQuoteExists) {
                unixcmd.append('\"');
            } else {
                unixcmd.append("'");
            }
            if (env != null) {
                for (i = 0; i < env.length; ++i) {
                    unixcmd.append(env[i]);
                    unixcmd.append(" ");
                }
            }
            unixcmd.append(this.m_cmd);
            if (args != null) {
                for (i = 0; i < args.length; ++i) {
                    unixcmd.append(" ");
                    unixcmd.append(args[i]);
                }
            }
            if (singleQuoteExists) {
                unixcmd.append('\"');
            } else {
                unixcmd.append("'");
            }
            this.m_cmd = unixcmd.toString();
            Trace.out("Commmand that will be executed is :" + unixcmd);
            StringTokenizer st = new StringTokenizer(this.m_cmd);
            this.m_args = new String[st.countTokens() - 1];
            this.m_env = new String[0];
            this.m_cmd = st.nextToken();
            int i2 = 0;
            while (st.hasMoreTokens()) {
                this.m_args[i2] = st.nextToken();
                ++i2;
            }
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            boolean inherit = true;
            if (this.m_env != null && this.m_env.length == 0) {
                inherit = false;
            }
            Trace.out("To inherit parent env?: " + inherit);
            execRunTime = clusterCmd.runCmdNoWait(this.m_cmd, this.m_args, this.m_env, inherit);
        }
        catch (ClusterException e) {
            throw new ExecException(e);
        }
        return execRunTime;
    }

    @Override
    public ExecRunTime runCommandNoWait(String cmd, String[] args, String[] env) throws ExecException, InvalidArgsException {
        this.m_cmd = cmd;
        this.m_args = args;
        this.m_env = env;
        oracle.cluster.impl.util.Utils.assertInput(this.m_cmd, "cmd");
        oracle.cluster.impl.util.Utils.assertInputNotNull(this.m_args, "args");
        oracle.cluster.impl.util.Utils.assertInputNotNull(this.m_env, "env");
        ExecRunTime execRunTime = null;
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            execRunTime = clusterCmd.runCmdNoWait(this.m_cmd, this.m_args, this.m_env);
        }
        catch (ClusterException e) {
            throw new ExecException(e);
        }
        return execRunTime;
    }

    @Override
    public ExecRunTime runCommandNoWait(String cmd, String[] args) throws ExecException, InvalidArgsException {
        return this.runCommandNoWait(cmd, args, new String[0]);
    }

    @Override
    public Map<String, CommandResult> runCmd(String cmd, String[] args, String[] env, String[] nodeList, ProgressListener plsnr) throws ExecException, InvalidArgsException, CompositeOperationException {
        Trace.out("Beginning of command execution with progress listener");
        int numNodes = nodeList.length;
        ExecRunTime[] runtimes = new ExecRunTime[numNodes];
        StreamReporter[] reporters = new StreamReporter[numNodes];
        ExecutorService pool = Executors.newCachedThreadPool();
        ConcurrentHashMap futures = new ConcurrentHashMap();
        ArrayList<String> failedNodes = new ArrayList<String>();
        Trace.out("Submitting all commands...");
        for (int i = 0; i < numNodes; ++i) {
            runtimes[i] = this.runCommandNoWait(cmd, args, env, nodeList[i]);
            reporters[i] = new StreamReporter(runtimes[i], nodeList[i], plsnr);
            futures.put(nodeList[i], pool.submit(reporters[i]));
        }
        try {
            for (String node : nodeList) {
                while (!((Future)futures.get(node)).isDone()) {
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException e) {
            Trace.out(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new ExecException(e);
        }
        HashMap<Object, NativeResult> results = new HashMap<Object, NativeResult>();
        boolean isError = false;
        for (int i = 0; i < numNodes; ++i) {
            Trace.out("Status for node " + nodeList[i] + " is " + reporters[i].getResult().getStatus());
            Trace.out("Error Code for node " + nodeList[i] + " is " + reporters[i].getResult().getOSErrCode());
            if (!reporters[i].getResult().getStatus() || reporters[i].getResult().getOSErrCode() != 0) {
                isError = true;
                failedNodes.add(nodeList[i]);
            }
            results.put(nodeList[i], reporters[i].getResult());
        }
        if (isError) {
            Trace.out("Command failed on nodes " + oracle.cluster.impl.util.Utils.strListToList(failedNodes));
            throw new CompositeOperationException((MessageKey)PrCfMsgID.COMMAND_FAILED_NODES, results, this.m_cmd, oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        }
        return results;
    }

    @Override
    public Map<String, CommandResult> runCmd(String cmd, String[] args, String[] env, String[] nodeList) throws ExecException, InvalidArgsException, CompositeOperationException {
        this.m_cmd = cmd;
        this.m_args = args;
        this.m_env = env;
        Trace.out("Running command " + this.m_cmd + " ...");
        oracle.cluster.impl.util.Utils.assertInput(this.m_cmd, "cmd");
        oracle.cluster.impl.util.Utils.assertInputNotNull(this.m_args, "args");
        oracle.cluster.impl.util.Utils.assertInputNotNull(this.m_env, "env");
        oracle.cluster.impl.util.Utils.assertInputNotNull(nodeList, "nodeList");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<String, CommandResult> resultMap = new HashMap<String, CommandResult>();
        try {
            RunCtlCommand[] cmdArr = null;
            if (nodeList.length != 0) {
                cmdArr = new RunCtlCommand[nodeList.length];
                for (int i = 0; i < nodeList.length; ++i) {
                    cmdArr[i] = new RunCtlCommand(this.m_cmd, this.m_args, this.m_env, nodeList[i]);
                    Trace.out("Constructed command for " + cmdArr[i].getNode());
                }
            } else {
                cmdArr = new RunCtlCommand[]{new RunCtlCommand(this.m_cmd, this.m_args, this.m_env)};
                Trace.out("Constructed command for " + cmdArr[0].getNode());
            }
            this.parallelExecute(cmdArr, failedNodes, resultMap);
            Trace.out("Command " + this.m_cmd + " ran successfully...");
            return resultMap;
        }
        catch (ConcurrencyException e) {
            Trace.out("ConcurrencyException caught: " + e);
            throw new ExecException((MessageKey)PrCfMsgID.COMMAND_FAILED_NODES, (Throwable)e, oracle.cluster.impl.util.Utils.strArrToList(nodeList));
        }
        catch (ConcurrencyTimeoutException e) {
            Trace.out("ConcurrencyTimeoutException caught: " + e);
            throw new ExecException((MessageKey)PrCfMsgID.COMMAND_FAILED_NODES, (Throwable)e, oracle.cluster.impl.util.Utils.strArrToList(nodeList));
        }
        catch (ClusterException e) {
            Trace.out("ClusterException caught: " + e);
            throw new ExecException((MessageKey)PrCfMsgID.COMMAND_FAILED_NODES, (Throwable)e, oracle.cluster.impl.util.Utils.strArrToList(nodeList));
        }
    }

    @Override
    public Map<String, CommandResult> runCmd(String cmd, String[] args, String[] nodeList) throws ExecException, InvalidArgsException, CompositeOperationException {
        return this.runCmd(cmd, args, new String[0], nodeList);
    }

    private void parallelExecute(RunCtlCommand[] cmdArr, List<String> failedNodes, Map resultMap) throws ConcurrencyException, CompositeOperationException, ConcurrencyTimeoutException, ExecException, ClusterException {
        ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(cmdArr, new Version());
        threadExec.submit();
        for (int i = 0; i < cmdArr.length; ++i) {
            Trace.out("Checking for execution on node " + cmdArr[i].getNode());
            CommandResult cr = cmdArr[i].getCommandResult();
            if (!cr.getResultString()[0].isEmpty() && cr.getResultString()[0].contains(" :successful")) {
                int resultIndex = cr.getResultString()[0].lastIndexOf(" :successful");
                cr.setOutputString(new String[]{cr.getResultString()[0].substring(0, resultIndex)});
            }
            Trace.out("OS Error code for node " + cmdArr[i].getNode() + ":" + cr.getOSErrCode());
            if (!cr.getStatus() || cr.getOSErrCode() != 0) {
                Trace.out("Command failed for node " + cmdArr[i].getNode());
                Trace.out("Output is " + cr.getResultString()[0]);
                failedNodes.add(cmdArr[i].getNode());
                cr.setException(new ExecException(cr.getResultString()[0]));
            } else {
                Trace.out("Command succeeded for node " + cmdArr[i].getNode());
            }
            if (cmdArr[i].getNode() != null) {
                resultMap.put(cmdArr[i].getNode(), cr);
                continue;
            }
            resultMap.put(Cluster.getLocalNode(), cr);
        }
        if (failedNodes.size() == cmdArr.length) {
            Trace.out("Throwing generic command failed error");
            CompositeOperationException ce = new CompositeOperationException((MessageKey)PrCfMsgID.COMMAND_FAILED_NODES, resultMap, this.m_cmd, oracle.cluster.impl.util.Utils.strListToList(failedNodes));
            throw new ExecException((MessageKey)PrCfMsgID.COMMAND_FAILED, (Throwable)ce, this.m_cmd);
        }
        if (failedNodes.size() > 0) {
            Trace.out("Throwing partial command failed error");
            throw new CompositeOperationException((MessageKey)PrCfMsgID.COMMAND_FAILED_NODES, resultMap, this.m_cmd, oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        }
    }

    private boolean isLocalNode(String node) {
        String nodeName = null;
        int dotIdx = node.indexOf(".");
        nodeName = dotIdx != -1 ? node.substring(0, dotIdx) : node;
        try {
            String localhost = Utils.getLocalHost();
            Trace.out("Comparing '" + nodeName + "' to localhost '" + localhost + "'");
            return nodeName.equalsIgnoreCase(localhost);
        }
        catch (UnknownHostException uhe) {
            Trace.out("UnknownHostException caught: " + uhe.getMessage());
            return false;
        }
    }

    private boolean checkSingleQuotes(String arg) {
        return arg != null && arg.contains("'");
    }

    class StreamReporter
    implements Runnable {
        private String[] m_buffer;
        private String[] m_errorBuffer;
        private String m_node;
        private CommandResult m_result = new CommandResult();
        private InputStream m_in;
        private InputStream m_err;
        private ProgressListener m_plsnr = null;
        private ExecRunTime m_runtime = null;

        public StreamReporter(ExecRunTime runtime, String node, ProgressListener plsnr) {
            this.m_runtime = runtime;
            this.m_in = runtime.getInputStream();
            this.m_err = runtime.getErrorStream();
            this.m_plsnr = plsnr;
            this.m_node = node;
        }

        public CommandResult getResult() {
            return this.m_result;
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.m_in);
                BufferedReader br = new BufferedReader(isr);
                Vector<String> localBuf = new Vector<String>();
                while ((line = br.readLine()) != null) {
                    Trace.out("Read line " + line);
                    this.m_plsnr.write(this.m_node, line, true);
                    localBuf.addElement(line);
                }
                this.m_runtime.waitFor();
                this.m_buffer = new String[localBuf.size()];
                localBuf.copyInto(this.m_buffer);
                this.m_result.setOutputString(this.m_buffer);
                this.m_result.setResultString(this.m_buffer);
                if (this.m_err != null && this.m_err.toString().length() > 0) {
                    Trace.out("Checking for errors...");
                    InputStreamReader esr = new InputStreamReader(this.m_err);
                    BufferedReader ebr = new BufferedReader(esr);
                    Vector<String> errBuf = new Vector<String>();
                    while ((line = ebr.readLine()) != null) {
                        Trace.out("Error line: " + line);
                        errBuf.addElement(line);
                    }
                    if (errBuf.isEmpty()) {
                        Trace.out("No errors found");
                    } else {
                        errBuf.copyInto(this.m_errorBuffer);
                        this.m_result.setOSString(this.m_errorBuffer);
                    }
                }
                Trace.out("Done running command");
                this.m_result.setOSErrCode(this.m_runtime.exitValue());
                this.m_result.setStatus(true);
            }
            catch (IOException | InterruptedException e) {
                Trace.out(e.getClass().getSimpleName() + ": " + e.getMessage());
                this.m_result.setStatus(false);
                this.m_result.setException(e);
            }
        }
    }
}

