/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.priv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.impl.priv.ChannelCommand;
import oracle.cluster.impl.priv.JSChChannel;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.priv.ChannelProgressListener;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.util.ConcurrencyTimeoutException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ChannelFactoryImpl
implements Constants {
    private static ChannelFactoryImpl s_factoryInst = null;
    private final String m_idCommand = "/usr/bin/id";
    private static HashMap<String, Boolean> m_reqTtyMap = null;
    private static String[] m_ttyMapNodeList = null;
    private boolean m_reqTtyMapInitialized = false;
    private final String[] m_reqttyPatternArr = new String[]{"requiretty"};
    private boolean m_isStdinOrAsUserUsed = false;
    private static boolean m_noPasswdConfigChecked = false;
    private final String NOPASSWD_REG_EXP = "(?s).*\\((ALL|ALL :.*|root)\\) NOPASSWD: ALL.*";

    public static synchronized ChannelFactoryImpl getInstance() {
        if (null == s_factoryInst) {
            s_factoryInst = new ChannelFactoryImpl();
        }
        return s_factoryInst;
    }

    public void checkRootPassword(String[] nodeList, String password, int timeout) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(password, "password");
        HashMap<Object, NativeResult> rhm = new HashMap<Object, NativeResult>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        String username = Utils.getRootUserName();
        try {
            this.parallelExecute(nodeList, JSChChannel.ChannelMode.ROOT, username, password, "/usr/bin/id", null, null, null, timeout, failedNodes, rhm, null, null);
        }
        catch (ConcurrencyException ce) {
            throw new ChannelException((MessageKey)PrCzMsgID.ROOT_PASSWORD_NOT_VERIFIED, (Throwable)ce, username);
        }
        catch (ConcurrencyTimeoutException e) {
            throw new ChannelException(e);
        }
        if (failedNodes.size() == 0) {
            return;
        }
        CompositeOperationException coe = new CompositeOperationException((MessageKey)PrCzMsgID.ROOT_PASSWORD_NOT_VERIFIED_NODE, rhm, username, Utils.strListToList(failedNodes));
        throw coe;
    }

    public void checkSudoExistence(String[] nodeList, String sudoLocation, String username, String password, List<String> noPasswdConfigNodes) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(sudoLocation, "location");
        this.assertString(username, "username");
        this.assertString(password, "password");
        Trace.out("checking sudo existance at location " + sudoLocation);
        HashMap<Object, NativeResult> rhm = new HashMap<Object, NativeResult>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        try {
            ClusterCmd clusterCmd = new ClusterCmd();
            clusterCmd.pathExists(nodeList, sudoLocation, 2);
        }
        catch (ClusterException ce) {
            Trace.out("cluster exception while checking for sudo existance");
            throw new ChannelException((MessageKey)PrCzMsgID.SUDO_PBRUN_EXISTENCE_NOT_VERIFIED, (Throwable)ce, sudoLocation);
        }
        catch (ClusterOperationException e) {
            Trace.out("cluster operation exception while checking for sudo existance");
            try {
                for (int i = 0; i < nodeList.length; ++i) {
                    rhm.put(nodeList[i], e.getNativeResult(nodeList[i]));
                }
            }
            catch (NoSuchNodeException ne) {
                Trace.out("no such identifier exception" + ne.getMessage());
            }
            throw new CompositeOperationException((MessageKey)PrCzMsgID.SUDO_PBRUN_EXISTENCE_NOT_VERIFIED_NODE, rhm, sudoLocation, Utils.strListToList(failedNodes));
        }
        String command = sudoLocation + " -V";
        try {
            this.parallelExecute(nodeList, JSChChannel.ChannelMode.SHELL, username, password, command, null, null, null, 0, failedNodes, rhm, null, null);
        }
        catch (ConcurrencyException ce) {
            throw new ChannelException((MessageKey)PrCzMsgID.SUDO_EXISTENCE_RUN_FAILED, (Throwable)ce, command);
        }
        catch (ConcurrencyTimeoutException e) {
            throw new ChannelException(e);
        }
        if (failedNodes.size() != 0) {
            CompositeOperationException coe = new CompositeOperationException((MessageKey)PrCzMsgID.SUDO_EXISTENCE_RUN_FAILED_NODE, rhm, command, Utils.strListToList(failedNodes));
            throw coe;
        }
        this.populateRequireTtyMap(nodeList, sudoLocation, username, password, true, noPasswdConfigNodes);
    }

    public void checkSudoExecution(String[] nodeList, String sudoLocation, String username, String password, int timeout, List<String> noPasswdConfigNodes) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(sudoLocation, "location");
        this.assertString(username, "username");
        this.assertString(password, "password");
        this.populateRequireTtyMap(nodeList, sudoLocation, username, password, true, noPasswdConfigNodes);
        UserInfo userInfo = new UserInfo(username, password);
        this.invalidateSudoCredentialsCache(nodeList, sudoLocation, userInfo);
        HashMap<Object, NativeResult> rhm = new HashMap<Object, NativeResult>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        try {
            this.parallelExecute(nodeList, JSChChannel.ChannelMode.SUDO, username, password, "/usr/bin/id", null, null, sudoLocation, timeout, failedNodes, rhm, null, null);
        }
        catch (ConcurrencyException ce) {
            throw new ChannelException(ce);
        }
        catch (ConcurrencyTimeoutException e) {
            throw new ChannelException(e);
        }
        if (failedNodes.size() == 0) {
            return;
        }
        CompositeOperationException coe = new CompositeOperationException((MessageKey)PrCzMsgID.SUDO_EXECUTION_NOT_VERIFIED_NODE, rhm, "/usr/bin/id", sudoLocation, username, Utils.strListToList(failedNodes));
        throw coe;
    }

    public void checkPBRunExistence(String[] nodeList, String pbLocation, String username, String password) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(pbLocation, "location");
        this.assertString(username, "username");
        this.assertString(password, "password");
        Trace.out("checking pbrun existance at location " + pbLocation);
        HashMap<Object, NativeResult> rhm = new HashMap<Object, NativeResult>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        try {
            ClusterCmd clusterCmd = new ClusterCmd();
            clusterCmd.pathExists(nodeList, pbLocation, 2);
        }
        catch (ClusterException ce) {
            Trace.out("cluster exception while checking for pbrun existance");
            throw new ChannelException((MessageKey)PrCzMsgID.SUDO_PBRUN_EXISTENCE_NOT_VERIFIED, (Throwable)ce, pbLocation);
        }
        catch (ClusterOperationException e) {
            Trace.out("cluster operation exception while checking for pbrun existance");
            try {
                for (int i = 0; i < nodeList.length; ++i) {
                    rhm.put(nodeList[i], e.getNativeResult(nodeList[i]));
                }
            }
            catch (NoSuchNodeException ne) {
                Trace.out("no such identifier exception " + ne.getMessage());
            }
            throw new CompositeOperationException((MessageKey)PrCzMsgID.SUDO_PBRUN_EXISTENCE_NOT_VERIFIED_NODE, rhm, pbLocation, Utils.strListToList(failedNodes));
        }
    }

    public void checkPBRunExecution(String[] nodeList, String pbLocation, String username, String password, int timeout) throws ChannelException, CompositeOperationException {
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        return this.doInternalExecuteCommand(nodeList, command, null, null, ConfigurationSetup.ConfigMethod.ROOT, null, null, password, timeout, null, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        this.assertArgsAndEnv(args, env);
        return this.doInternalExecuteCommand(nodeList, command, env, args, ConfigurationSetup.ConfigMethod.ROOT, null, null, password, timeout, null, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        if (mode == ConfigurationSetup.ConfigMethod.ROOT) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        this.assertString(username, "username");
        this.assertString(location, "location");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        return this.doInternalExecuteCommand(nodeList, command, null, null, mode, location, username, password, timeout, null, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        if (mode == ConfigurationSetup.ConfigMethod.ROOT) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        this.assertString(username, "username");
        this.assertString(location, "location");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        this.assertArgsAndEnv(args, env);
        return this.doInternalExecuteCommand(nodeList, command, env, args, mode, location, username, password, timeout, null, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        if (null == cpListener) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cpListener");
        }
        return this.doInternalExecuteCommand(nodeList, command, null, null, ConfigurationSetup.ConfigMethod.ROOT, null, null, password, timeout, cpListener, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        this.assertArgsAndEnv(args, env);
        if (null == cpListener) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cpListener");
        }
        return this.doInternalExecuteCommand(nodeList, command, env, args, ConfigurationSetup.ConfigMethod.ROOT, null, null, password, timeout, cpListener, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        if (mode == ConfigurationSetup.ConfigMethod.ROOT) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        this.assertString(username, "username");
        this.assertString(location, "location");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        if (null == cpListener) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cpListener");
        }
        return this.doInternalExecuteCommand(nodeList, command, null, null, mode, location, username, password, timeout, cpListener, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, String asUser) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        if (mode == ConfigurationSetup.ConfigMethod.PBRUN) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        if (mode == ConfigurationSetup.ConfigMethod.SUDO) {
            this.assertString(username, "username");
            this.assertString(location, "location");
        }
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        if (null == asUser) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "asUser");
        }
        return this.doInternalExecuteCommand(nodeList, command, null, null, mode, location, username, password, timeout, null, asUser);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, String asUser) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        Trace.out("Executing command " + command);
        if (mode == ConfigurationSetup.ConfigMethod.PBRUN) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        if (mode == ConfigurationSetup.ConfigMethod.SUDO) {
            this.assertString(username, "username");
            this.assertString(location, "location");
        }
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        this.assertArgsAndEnv(args, env);
        if (null == asUser) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "asUser");
        }
        return this.doInternalExecuteCommand(nodeList, command, env, args, mode, location, username, password, timeout, null, asUser);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener, String asUser) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        if (mode == ConfigurationSetup.ConfigMethod.PBRUN) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        if (mode == ConfigurationSetup.ConfigMethod.SUDO) {
            this.assertString(username, "username");
            this.assertString(location, "location");
        }
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        if (null == asUser) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "asUser");
        }
        if (null == cpListener) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cpListener");
        }
        return this.doInternalExecuteCommand(nodeList, command, null, null, mode, location, username, password, timeout, cpListener, asUser);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        if (mode == ConfigurationSetup.ConfigMethod.ROOT) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        this.assertString(username, "username");
        this.assertString(location, "location");
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        this.assertArgsAndEnv(args, env);
        if (null == cpListener) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cpListener");
        }
        return this.doInternalExecuteCommand(nodeList, command, env, args, mode, location, username, password, timeout, cpListener, null);
    }

    public Map<String, CommandResult> executeCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, UserInfo userInfo, int timeout, ChannelProgressListener cpListener, String asUser) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(command, "command");
        Trace.out("Executing command " + command);
        if (mode == ConfigurationSetup.ConfigMethod.PBRUN) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mode");
        }
        String username = userInfo.getUsername();
        if (mode == ConfigurationSetup.ConfigMethod.SUDO) {
            this.assertString(username, "username");
            this.assertString(location, "location");
        }
        String password = userInfo.getPassword();
        this.assertString(password, "password");
        this.assertArgsAndEnv(args, env);
        if (null == asUser) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "asUser");
        }
        if (null == cpListener) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cpListener");
        }
        return this.doInternalExecuteCommand(nodeList, command, env, args, mode, location, username, password, timeout, cpListener, asUser);
    }

    public Map<String, CommandResult> doInternalExecuteCommand(String[] nodeList, String command, String[] env, String[] args, ConfigurationSetup.ConfigMethod mode, String location, String username, String password, int timeout, ChannelProgressListener cpListener, String asUser) throws ChannelException, CompositeOperationException {
        return this.doInternalExecuteCommand(nodeList, command, env, args, null, mode, location, username, password, timeout, cpListener, asUser);
    }

    public Map<String, CommandResult> doInternalExecuteCommand(String[] nodeList, String command, String[] env, String[] args, String[] stdin, ConfigurationSetup.ConfigMethod mode, String location, String username, String password, int timeout, ChannelProgressListener cpListener, String asUser) throws ChannelException, CompositeOperationException {
        Trace.out("Beginning of doInternalExecuteCommand");
        HashMap<Object, NativeResult> rhm = new HashMap<Object, NativeResult>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        JSChChannel.ChannelMode channelMode = JSChChannel.ChannelMode.ROOT;
        Trace.out("Timeout for execution is " + timeout);
        if (mode != null) {
            switch (mode) {
                case ROOT: {
                    channelMode = JSChChannel.ChannelMode.ROOT;
                    break;
                }
                case SUDO: {
                    channelMode = JSChChannel.ChannelMode.SUDO;
                    this.populateRequireTtyMap(nodeList, location, username, password, false, null);
                    break;
                }
                case PBRUN: {
                    channelMode = JSChChannel.ChannelMode.PBRUN;
                }
            }
        } else {
            channelMode = JSChChannel.ChannelMode.SHELL;
        }
        if (channelMode == JSChChannel.ChannelMode.SUDO) {
            if (stdin != null && stdin.length > 0 || asUser != null) {
                this.m_isStdinOrAsUserUsed = true;
            }
            this.invalidateSudoCredentialsCache(nodeList, location, new UserInfo(username, password));
        }
        try {
            Trace.out("Command: " + command);
            if (null == asUser) {
                this.parallelExecute(nodeList, channelMode, username, password, command, args, env, stdin, location, timeout, failedNodes, rhm, cpListener, null);
            } else {
                this.parallelExecute(nodeList, channelMode, username, password, command, args, env, stdin, location, timeout, failedNodes, rhm, cpListener, asUser);
            }
        }
        catch (ConcurrencyException ce) {
            throw new ChannelException(ce);
        }
        catch (ConcurrencyTimeoutException e) {
            throw new ChannelException(e);
        }
        if (failedNodes.size() != 0) {
            Trace.out("Command failed on nodes " + failedNodes);
            switch (channelMode) {
                case ROOT: {
                    if (null == asUser) {
                        throw new CompositeOperationException((MessageKey)PrCzMsgID.ROOT_COMMAND_EXECUTION_FAILED, rhm, command, timeout, Utils.strListToList(failedNodes));
                    }
                    throw new CompositeOperationException((MessageKey)PrCzMsgID.ROOT_ASUSER_COMMAND_EXECUTION_FAILED, rhm, command, asUser, timeout, Utils.strListToList(failedNodes));
                }
                case SUDO: {
                    if (null == asUser) {
                        throw new CompositeOperationException((MessageKey)PrCzMsgID.SUDO_COMMAND_EXECUTION_FAILED, rhm, command, location, username, timeout, Utils.strListToList(failedNodes));
                    }
                    throw new CompositeOperationException((MessageKey)PrCzMsgID.SUDO_COMMAND_EXECUTION_FAILED, rhm, command, location, asUser, timeout, Utils.strListToList(failedNodes));
                }
                case PBRUN: {
                    if (null == asUser) {
                        throw new CompositeOperationException((MessageKey)PrCzMsgID.PBRUN_COMMAND_EXECUTION_FAILED, rhm, command, location, username, timeout, Utils.strListToList(failedNodes));
                    }
                    throw new CompositeOperationException((MessageKey)PrCzMsgID.PBRUN_COMMAND_EXECUTION_FAILED, rhm, command, location, asUser, timeout, Utils.strListToList(failedNodes));
                }
                case SHELL: {
                    if (null == asUser) {
                        throw new CompositeOperationException((MessageKey)PrCzMsgID.SHELL_COMMAND_EXECUTION_FAILED, rhm, command, username, timeout, Utils.strListToList(failedNodes));
                    }
                    throw new CompositeOperationException((MessageKey)PrCzMsgID.SHELL_COMMAND_EXECUTION_FAILED, rhm, command, asUser, timeout, Utils.strListToList(failedNodes));
                }
            }
        }
        return rhm;
    }

    private void parallelExecute(String[] nodeList, JSChChannel.ChannelMode channelMode, String user, String password, String command, String[] args, String[] env, String sudoPbrunLocation, int timeout, List<String> failedNodes, Map resultMap, ChannelProgressListener cpListener, String asUser) throws ChannelException, ConcurrencyException, CompositeOperationException, ConcurrencyTimeoutException {
        this.parallelExecute(nodeList, channelMode, user, password, command, args, env, null, sudoPbrunLocation, timeout, failedNodes, resultMap, cpListener, asUser);
    }

    private void parallelExecute(String[] nodeList, JSChChannel.ChannelMode channelMode, String user, String password, String command, String[] args, String[] env, String[] stdin, String sudoPbrunLocation, int timeout, List<String> failedNodes, Map resultMap, ChannelProgressListener cpListener, String asUser) throws ChannelException, ConcurrencyException, CompositeOperationException, ConcurrencyTimeoutException {
        Trace.out("Number of remote nodes executing the command is " + nodeList.length);
        Trace.out("Command to execute: " + command);
        Command[] cmdArr = new ChannelCommand[nodeList.length];
        for (int i = 0; i < nodeList.length; ++i) {
            boolean requiretty = false;
            if (channelMode == JSChChannel.ChannelMode.SUDO && this.m_reqTtyMapInitialized) {
                requiretty = m_reqTtyMap.get(nodeList[i].toLowerCase());
            }
            cmdArr[i] = new ChannelCommand(channelMode, nodeList[i], user, password, command, args, env, stdin, sudoPbrunLocation, timeout, cpListener, requiretty, asUser);
        }
        Trace.out("creating parallel execute factory");
        ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(cmdArr, timeout, new Version());
        threadExec.submit();
        for (int i = 0; i < cmdArr.length; ++i) {
            CommandResult cr = cmdArr[i].getCommandResult();
            resultMap.put(nodeList[i], cr);
            Trace.out("Checking the the OS Error Code : " + cr.getOSErrCode());
            if (cr.getStatus() && 0 == cr.getOSErrCode()) continue;
            Trace.out("command failed on node " + nodeList[i]);
            failedNodes.add(nodeList[i]);
        }
    }

    private void assertNodes(String[] nodeList) throws ChannelException {
        if (nodeList == null || nodeList.length == 0) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node list");
        }
        for (String node : nodeList) {
            if (node != null && node.length() != 0) continue;
            Trace.out("nodeList contains invalid node name");
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node name");
        }
    }

    private void assertString(String str, String type) throws ChannelException {
        if (str == null || !type.equals("password") && str.length() == 0) {
            throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, type);
        }
    }

    private void assertArgsAndEnv(String[] arg, String[] env) throws ChannelException {
        if (arg != null && arg.length != 0) {
            return;
        }
        if (env != null && env.length != 0) {
            return;
        }
        throw new ChannelException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "arg/env");
    }

    private void populateRequireTtyMap(String[] nodeList, String sudoLocation, String username, String password, boolean checkNopasswdConfig, List<String> noPasswdConfigNodes) throws ChannelException, CompositeOperationException {
        boolean needTtyUpdate = false;
        if (m_reqTtyMap != null) {
            Trace.out("old tty map exists");
            for (String node : nodeList) {
                if (m_reqTtyMap.containsKey(node.toLowerCase())) continue;
                Trace.out("Need to update tty list with new entries");
                needTtyUpdate = true;
                this.m_reqTtyMapInitialized = false;
                break;
            }
        }
        if (!(needTtyUpdate || checkNopasswdConfig && !m_noPasswdConfigChecked)) {
            return;
        }
        HashMap rhm = new HashMap();
        ArrayList<String> failedNodes = new ArrayList<String>();
        String command = " -l";
        try {
            Trace.out("executing sudo list command");
            this.parallelExecute(nodeList, JSChChannel.ChannelMode.SUDO, username, password, command, null, null, sudoLocation, 0, failedNodes, rhm, null, null);
        }
        catch (ConcurrencyException ce) {
            throw new ChannelException((MessageKey)PrCzMsgID.SUDO_EXISTENCE_RUN_FAILED, (Throwable)ce, command);
        }
        catch (ConcurrencyTimeoutException e) {
            throw new ChannelException(e);
        }
        if (!this.m_reqTtyMapInitialized && m_reqTtyMap == null) {
            m_reqTtyMap = new HashMap();
        }
        if (checkNopasswdConfig && noPasswdConfigNodes == null) {
            noPasswdConfigNodes = new ArrayList<String>();
        }
        for (Map.Entry entry : rhm.entrySet()) {
            String node = (String)entry.getKey();
            CommandResult result = (CommandResult)entry.getValue();
            String[] resultStrArr = result.getResultString();
            String resultStr = Utils.strArrToString(resultStrArr, LINE_SEPARATOR);
            Trace.out("sudo options on node " + node + " are " + resultStr);
            if (checkNopasswdConfig && !failedNodes.contains(node) && resultStr != null && resultStr.matches("(?s).*\\((ALL|ALL :.*|root)\\) NOPASSWD: ALL.*")) {
                Trace.out("sudo is configured for NOPASSWD option on node: " + node);
                noPasswdConfigNodes.add(node);
            }
            if (this.m_reqTtyMapInitialized) continue;
            boolean ttyOptionSet = false;
            if (failedNodes.contains(node)) {
                Trace.out("requiretty set to true for node " + node);
                m_reqTtyMap.put(node.toLowerCase(), new Boolean(true));
                continue;
            }
            if (resultStr != null) {
                for (String reqttyOpt : this.m_reqttyPatternArr) {
                    if (-1 == resultStr.indexOf(reqttyOpt)) continue;
                    Trace.out("terminal request option found " + reqttyOpt);
                    m_reqTtyMap.put(node.toLowerCase(), new Boolean(true));
                    ttyOptionSet = true;
                    break;
                }
            } else {
                Trace.out("command succeeded null output");
                m_reqTtyMap.put(node.toLowerCase(), new Boolean(true));
                ttyOptionSet = true;
            }
            if (ttyOptionSet) continue;
            m_reqTtyMap.put(node.toLowerCase(), new Boolean(false));
        }
        if (!this.m_reqTtyMapInitialized) {
            this.m_reqTtyMapInitialized = true;
        }
        if (checkNopasswdConfig && !m_noPasswdConfigChecked) {
            m_noPasswdConfigChecked = true;
        }
    }

    public void invalidateSudoCredentialsCache(String[] nodeList, String sudoLocation, UserInfo userInfo) throws ChannelException, CompositeOperationException {
        this.assertNodes(nodeList);
        this.assertString(sudoLocation, "sudo location");
        ArrayList<String> failedNodes = new ArrayList<String>();
        HashMap<Object, NativeResult> rhm = new HashMap<Object, NativeResult>();
        String command = sudoLocation + " -k";
        String password = userInfo.getPassword();
        String username = userInfo.getUsername();
        this.assertString(username, "username");
        this.assertString(password, "password");
        try {
            this.parallelExecute(nodeList, JSChChannel.ChannelMode.SHELL, username, password, command, null, null, new String[0], sudoLocation, 0, failedNodes, rhm, null, null);
        }
        catch (ConcurrencyException ce) {
            throw new ChannelException((MessageKey)PrCzMsgID.SUDO_INVALIDATE_CACHE_FAILED, (Throwable)ce, command);
        }
        catch (ConcurrencyTimeoutException e) {
            throw new ChannelException(e);
        }
        if (failedNodes.size() != 0) {
            CompositeOperationException coe = new CompositeOperationException((MessageKey)PrCzMsgID.SUDO_INVALIDATE_CACHE_FAILED_NODE, rhm, command, Utils.strListToList(failedNodes));
            throw coe;
        }
    }
}

