/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.priv;

import java.net.UnknownHostException;
import oracle.cluster.impl.priv.JSChChannel;
import oracle.cluster.priv.ChannelProgressListener;
import oracle.cluster.remote.NodeProgressListener;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.UnixSystem;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ChannelCommand
extends Command {
    private String m_user;
    private String m_pwd;
    private JSChChannel.ChannelMode m_commandMode;
    private int m_timeout;
    private String m_cmd;
    private String m_sudoPbrunLocation = null;
    private String[] m_args = null;
    private String[] m_nameEnv = null;
    private String[] m_valueEnv = null;
    private ChannelProgressListener m_cpListener = null;
    private boolean m_requireTty = false;
    private String m_asUser = null;
    private String[] m_stdin = null;
    private final String SHELL_CMD_BEGIN = "/usr/bin/sh";
    private final String SHELL_CMD_EXEC_FLAG = "-c";
    private final String EXPORT_CMD = "export ";

    public ChannelCommand(JSChChannel.ChannelMode commandMode, String node, String user, String password, String shellCommand, String[] args, String[] env, String sudoPbrunLocation, int timeout, boolean requireTty) {
        this.m_commandMode = commandMode;
        this.m_node = node;
        this.m_user = user;
        this.m_pwd = password;
        this.m_cmd = shellCommand.trim();
        Trace.out("Command to execute: " + shellCommand);
        this.m_args = args;
        this.m_sudoPbrunLocation = sudoPbrunLocation;
        this.m_timeout = timeout;
        this.m_requireTty = requireTty;
        this.commandResult = new CommandResult();
        if (env != null && env.length != 0) {
            this.m_nameEnv = new String[env.length];
            this.m_valueEnv = new String[env.length];
            for (int i = 0; i < env.length; ++i) {
                int index = env[i].indexOf("=");
                this.m_nameEnv[i] = env[i].substring(0, index);
                this.m_valueEnv[i] = env[i].substring(index + 1);
            }
        }
    }

    public ChannelCommand(JSChChannel.ChannelMode commandMode, String node, String user, String password, String shellCommand, String[] args, String[] env, String sudoPbrunLocation, int timeout, boolean requireTty, String asUser) {
        this(commandMode, node, user, password, shellCommand, args, env, sudoPbrunLocation, timeout, requireTty);
        this.m_asUser = asUser;
    }

    public ChannelCommand(JSChChannel.ChannelMode commandMode, String node, String user, String password, String shellCommand, String[] args, String[] env, String[] stdin, String sudoPbrunLocation, int timeout, ChannelProgressListener cpListener, boolean requireTty, String asUser) {
        this(commandMode, node, user, password, shellCommand, args, env, sudoPbrunLocation, timeout, cpListener, requireTty, asUser);
        this.m_stdin = stdin;
    }

    public ChannelCommand(JSChChannel.ChannelMode commandMode, String node, String user, String password, String shellCommand, String[] args, String[] env, String sudoPbrunLocation, int timeout, ChannelProgressListener cpListener, boolean requireTty) {
        this(commandMode, node, user, password, shellCommand, args, env, sudoPbrunLocation, timeout, requireTty);
        this.m_cpListener = cpListener;
    }

    public ChannelCommand(JSChChannel.ChannelMode commandMode, String node, String user, String password, String shellCommand, String[] args, String[] env, String sudoPbrunLocation, int timeout, ChannelProgressListener cpListener, boolean requireTty, String asUser) {
        this(commandMode, node, user, password, shellCommand, args, env, sudoPbrunLocation, timeout, cpListener, requireTty);
        this.m_asUser = asUser;
    }

    public String getCommandString() {
        return this.m_cmd;
    }

    @Override
    public boolean execute() {
        boolean isLocal;
        JSChChannel channel = null;
        Trace.out("Executing in mode " + (Object)((Object)this.m_commandMode) + " command " + this.m_cmd + " for user " + this.m_user + " timeout= " + this.m_timeout);
        try {
            Trace.out("Node to execute on: " + this.m_node);
            String localHost = Utils.getLocalHost();
            isLocal = this.m_node.toLowerCase().equals(localHost.toLowerCase());
            Trace.out("Local Node is " + localHost);
        }
        catch (UnknownHostException uhe) {
            isLocal = false;
        }
        Trace.out("Logged in user: " + System.getProperty("user.name") + "\nSudo user: " + this.m_user + "\nAsUser: " + this.m_asUser + "\nStdin present?" + (this.m_stdin == null || this.m_stdin.length == 0 ? "false" : "true") + "\nNodeProgressListener present?" + (this.m_cpListener instanceof NodeProgressListener ? "true" : "false"));
        if (isLocal && (this.m_commandMode != JSChChannel.ChannelMode.SUDO && !this.m_cmd.trim().endsWith(" -k") || this.m_user.trim().equals(System.getProperty("user.name"))) && this.m_asUser == null && (this.m_stdin == null || this.m_stdin.length == 0) && !(this.m_cpListener instanceof NodeProgressListener)) {
            Trace.out("Executing in the local mode");
            this.commandResult = this.execLocalPseudoTerminal();
        } else {
            if (this.m_args != null && this.m_args.length != 0) {
                for (int i = 0; i < this.m_args.length; ++i) {
                    if (this.m_args[i] == null) continue;
                    this.m_cmd = this.m_cmd + " " + this.m_args[i].trim();
                }
            }
            if (this.m_nameEnv != null) {
                for (int i = 0; i < this.m_nameEnv.length; ++i) {
                    Trace.out("setting env variable " + this.m_nameEnv[i] + "=" + this.m_valueEnv[i]);
                }
            }
            channel = this.m_asUser != null ? new JSChChannel(this.m_node, this.m_user, this.m_pwd, this.m_commandMode, this.m_sudoPbrunLocation, this.m_timeout, this.m_cpListener, this.m_requireTty, this.m_asUser) : new JSChChannel(this.m_node, this.m_user, this.m_pwd, this.m_commandMode, this.m_sudoPbrunLocation, this.m_timeout, this.m_cpListener, this.m_requireTty);
            this.commandResult = channel.execCommand(this.m_cmd, this.m_nameEnv, this.m_valueEnv, this.m_stdin);
        }
        Trace.out("command executed with status: " + this.commandResult.getStatus());
        return this.commandResult.getStatus();
    }

    private CommandResult execLocalPseudoTerminal() {
        CommandResult cmdResult = new CommandResult();
        String[] cmdArray = null;
        try {
            int i;
            UnixSystem system = (UnixSystem)new SystemFactory().CreateSystem();
            if (null != this.m_cpListener) {
                this.m_cpListener.updateStatus("START", this.m_node);
            }
            cmdResult.setNodeName(this.m_node);
            if (this.m_commandMode == JSChChannel.ChannelMode.SUDO) {
                Trace.out("Executing  cmd using the SUDO mode");
                if (this.m_nameEnv != null) {
                    cmdArray = new String[4];
                    cmdArray[0] = this.m_sudoPbrunLocation;
                    cmdArray[1] = "/usr/bin/sh";
                    cmdArray[2] = "-c";
                    StringBuilder cmdBuilder = new StringBuilder();
                    for (i = 0; i < this.m_nameEnv.length; ++i) {
                        cmdBuilder.append(this.m_nameEnv[i] + "=" + this.m_valueEnv[i] + " ");
                    }
                    cmdBuilder.append(this.m_cmd);
                    if (null != this.m_args) {
                        for (i = 0; i < this.m_args.length; ++i) {
                            if (this.m_args[i] == null) continue;
                            Trace.out("args are " + this.m_args[i].trim());
                            cmdBuilder.append(" " + this.m_args[i].trim());
                        }
                    }
                    cmdArray[3] = cmdBuilder.toString();
                } else {
                    int num_params = 2;
                    if (this.m_args != null) {
                        num_params += this.m_args.length;
                    }
                    Trace.out("number of params = " + num_params);
                    cmdArray = new String[num_params];
                    cmdArray[0] = this.m_sudoPbrunLocation;
                    cmdArray[1] = this.m_cmd;
                    if (null != this.m_args) {
                        for (i = 0; i < this.m_args.length; ++i) {
                            if (this.m_args[i] == null) continue;
                            Trace.out("args are " + this.m_args[i].trim());
                            cmdArray[i + 2] = this.m_args[i].trim();
                        }
                    }
                }
            } else if (this.m_commandMode == JSChChannel.ChannelMode.ROOT) {
                if (this.m_args != null && this.m_args.length != 0) {
                    for (i = 0; i < this.m_args.length; ++i) {
                        if (this.m_args[i] == null) continue;
                        this.m_cmd = this.m_cmd + " " + this.m_args[i].trim();
                    }
                }
                Trace.out("Executing  cmd using the ROOT mode");
                if (this.m_nameEnv != null) {
                    cmdArray = new String[4];
                    cmdArray[0] = "/bin/su";
                    cmdArray[1] = "root";
                    cmdArray[2] = "-c";
                    StringBuilder cmdBuilder = new StringBuilder();
                    for (i = 0; i < this.m_nameEnv.length; ++i) {
                        cmdBuilder.append(this.m_nameEnv[i] + "=" + this.m_valueEnv[i] + " ");
                    }
                    cmdBuilder.append(this.m_cmd);
                    cmdArray[3] = cmdBuilder.toString();
                } else {
                    Trace.out("Executing  cmd using the ROOT mode");
                    cmdArray = new String[]{"/bin/su", "root", "-c", this.m_cmd};
                }
            } else if (this.m_commandMode == JSChChannel.ChannelMode.SHELL) {
                if (this.m_args != null && this.m_args.length != 0) {
                    for (i = 0; i < this.m_args.length; ++i) {
                        if (this.m_args[i] == null) continue;
                        this.m_cmd = this.m_cmd + " " + this.m_args[i].trim();
                    }
                }
                Trace.out("Executing  cmd using the SHELL mode");
                if (this.m_nameEnv != null) {
                    cmdArray = new String[3];
                    cmdArray[0] = "/usr/bin/sh";
                    cmdArray[1] = "-c";
                    StringBuilder cmdBuilder = new StringBuilder();
                    for (i = 0; i < this.m_nameEnv.length; ++i) {
                        cmdBuilder.append(this.m_nameEnv[i] + "=" + this.m_valueEnv[i] + " ");
                    }
                    cmdBuilder.append(this.m_cmd);
                    cmdArray[2] = cmdBuilder.toString();
                } else {
                    cmdArray = new String[]{"/bin/sh", "-c", this.m_cmd};
                }
            }
            for (i = 0; i < cmdArray.length; ++i) {
                Trace.out("command args are =" + cmdArray[i]);
            }
            system.execCmdLocalPseduoTerm(cmdArray, this.m_user, this.m_pwd, cmdResult);
            cmdResult.setOutputString(new String[]{cmdResult.getStringResult()});
            cmdResult.setResultString(new String[]{cmdResult.getStringResult()});
        }
        catch (NativeException ne) {
            Trace.out("Caught Native Exception");
            cmdResult.setException(ne);
            cmdResult.setStatus(false);
        }
        Trace.out("Completed Execution of command " + this.m_cmd);
        Trace.out("Result of execution is :" + cmdResult.getStringResult());
        if (null != this.m_cpListener) {
            this.m_cpListener.updateStatus("STOP", this.m_node);
        }
        return cmdResult;
    }
}

