/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.policy;

import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.policy.ConfigPolicyException;
import oracle.cluster.policy.DatabaseRank;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class DatabaseRankImpl
implements DatabaseRank {
    private int m_rank;
    private String m_name;
    private String m_displayName;

    public DatabaseRankImpl(String dbUniqueName, int rank) throws ConfigPolicyException {
        this.m_name = DatabaseFactory.getDatabaseResourceName(dbUniqueName);
        this.m_displayName = dbUniqueName;
        this.setRank(rank);
    }

    @Override
    public String getDBUniqueName() {
        return this.m_displayName;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getRank() {
        return this.m_rank;
    }

    @Override
    public void setRank(int rank) throws ConfigPolicyException {
        if (rank < 0 || rank > 5) {
            throw new ConfigPolicyException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "database-rank-error");
        }
        this.m_rank = rank;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseRankImpl) {
            return ((DatabaseRankImpl)object).getDBUniqueName().equalsIgnoreCase(this.getDBUniqueName());
        }
        return false;
    }
}

