/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.policy;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicyException;
import oracle.cluster.policy.DatabaseRank;
import oracle.cluster.resources.PrCpMsgID;
import oracle.cluster.server.ServerPool;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ConfigPolicyImpl
extends ManageableEntityImpl
implements ConfigPolicy {
    protected String m_desc;
    protected List<ServerPool> m_poolList;
    protected List<DatabaseRank> m_dbList;

    ConfigPolicyImpl(String polName) throws ConfigPolicyException {
        this.m_name = polName;
        this.m_displayName = polName;
        this.m_poolList = new ArrayList<ServerPool>();
        this.m_dbList = new ArrayList<DatabaseRank>();
    }

    @Override
    public List<ServerPool> getSPList() {
        return this.m_poolList;
    }

    @Override
    public void setSPList(List<ServerPool> spList) throws ConfigPolicyException {
        if (null == spList) {
            throw new ConfigPolicyException((MessageKey)PrCpMsgID.INVALID_PARAMETER, spList);
        }
        this.m_poolList = spList;
    }

    @Override
    public void addSP(ServerPool sp) throws ConfigPolicyException {
        this.m_poolList.add(sp);
    }

    @Override
    public List<DatabaseRank> getDBList() throws ConfigPolicyException {
        return this.m_dbList;
    }

    @Override
    public void setDBList(List<DatabaseRank> dbList) throws ConfigPolicyException {
        if (null == dbList) {
            throw new ConfigPolicyException((MessageKey)PrCpMsgID.INVALID_PARAMETER, dbList);
        }
        this.m_dbList = dbList;
    }

    @Override
    public void addDB(DatabaseRank database) throws ConfigPolicyException {
        Trace.out("Adding DatabaseRank: " + database.getName());
        if (this.m_dbList.contains(database)) {
            this.m_dbList.set(this.m_dbList.indexOf(database), database);
        } else {
            this.m_dbList.add(database);
        }
    }

    @Override
    public void removeDB(DatabaseRank database) throws ConfigPolicyException {
        this.m_dbList.remove(database);
    }
}

