/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.oc4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.oc4j.OC4J;
import oracle.cluster.oc4j.OC4JException;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class OC4JImpl
extends SoftwareModuleImpl
implements OC4J {
    private ResourceAttribute m_nameAttr = null;
    private boolean m_isQOSMServer = false;
    private final String DEFAULT_NETWORK_STR = "1";

    OC4JImpl(ResourceAttribute nameAttr) throws OC4JException {
        this(nameAttr, false);
    }

    OC4JImpl(ResourceAttribute nameAttr, boolean isQOSMServer) throws OC4JException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.OC4J.NAME.name())) {
                throw new OC4JException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.OC4J.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            Trace.out("name attr = %s", nameAttr);
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.OC4J.toString().equalsIgnoreCase(values[numValues - 1]) && !ResourceLiterals.QOSMSERVER.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new OC4JException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.OC4J.NAME.name(), nameAttr.getValue());
            }
            this.m_isQOSMServer = isQOSMServer;
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            Trace.out((Object)"display name = %s", this.m_displayName);
            this.m_crsResource = (CRSResourceImpl)((Object)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr));
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new OC4JException(e);
        }
    }

    void create(Version version) throws AlreadyExistsException, OC4JException {
        this.create(version, false);
    }

    void create(Version version, boolean isTLSEnabled) throws AlreadyExistsException, OC4JException {
        try {
            if (!this.m_isQOSMServer) {
                throw new OC4JException((MessageKey)PrCnMsgID.OC4J_ADD_NOT_SUPPORTED, new Object[0]);
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String typeVal = ResourceType.QOSMServer.NAME.toString();
            ResourceAttribute qosmSvrTypeAttr = crsFactory.create(ResourceType.QOSMServer.NAME.name(), typeVal);
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(qosmSvrTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.QOSMServer.NAME.name())) {
                    attr.setValue(OC4JImpl.getResourceName());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.QOSMServer.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.QOSMSERVER_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.QOSMServer.PORT.name())) {
                    attr.setValue(ResourceLiterals.QOSMSERVER_RMIPORT.toString());
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.QOSMServer.TLS_ENABLED.name()) || !this.m_isQOSMServer) continue;
                attr.setValue(Boolean.toString(isTLSEnabled));
            }
            NodeAppsFactoryImpl naf = NodeAppsFactoryImpl.getInstance();
            Network net = naf.getNetwork("1");
            ResourceAttribute networkAttribute = crsFactory.create(ResourceType.Network.NAME.name(), net.getName());
            ResourceDependency hardDependency = crsFactory.createResourceDependency(networkAttribute, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency pullupDependency = crsFactory.createResourceDependency(networkAttribute, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency hardIntermDependency = crsFactory.createResourceDependency(networkAttribute, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            String startDepStr = ResourceDependency.toString(hardDependency, pullupDependency);
            ResourceAttribute startDependencyAttribute = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), startDepStr);
            Trace.out((Object)"Adding \"%s\" dependency start dependencies", startDepStr);
            attrList.add(startDependencyAttribute);
            String stopdepStr = ResourceDependency.toString(hardIntermDependency);
            ResourceAttribute stopDependencyAttribute = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), stopdepStr);
            Trace.out((Object)"Adding \"%s\" dependency stop dependencies", stopdepStr);
            attrList.add(stopDependencyAttribute);
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            ResourceAttribute aclPerm = this.createACLAttr();
            attrList.add(aclPerm);
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
        }
        catch (SoftwareModuleException | CRSException | NotExistsException e) {
            throw new OC4JException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public int port() throws OC4JException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.OC4J.PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new OC4JException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NumberFormatException ne) {
            throw new OC4JException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)ne, this.getUserAssignedName());
        }
    }

    @Override
    public void setPort(int port) throws OC4JException {
        this.internalModify(port, null, false, null);
    }

    @Override
    public void setPort(int port, boolean force) throws OC4JException {
        this.internalModify(port, null, force, null);
    }

    @Override
    public void modify(int rmiPort, int httpPort) throws OC4JException {
        this.internalModify(rmiPort, httpPort, false, null);
    }

    @Override
    public void modify(int rmiPort, int httpPort, boolean force) throws OC4JException {
        this.internalModify(rmiPort, httpPort, force, null);
    }

    @Override
    public void setHttpPort(int port) throws OC4JException {
        this.internalModify(null, port, false, null);
    }

    @Override
    public void setHttpPort(int port, boolean force) throws OC4JException {
        this.internalModify(null, port, force, null);
    }

    @Override
    public int getHttpPort() throws OC4JException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.OC4J.HTTP_PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new OC4JException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NumberFormatException ne) {
            throw new OC4JException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)ne, this.getUserAssignedName());
        }
    }

    private void internalModify(Integer rmiPort, Integer httpPort, boolean force, Boolean isTLSEnabled) throws OC4JException {
        block16: {
            try {
                ResourceAttribute attr;
                boolean restartResource = false;
                if (this.isRunning()) {
                    if (force) {
                        restartResource = true;
                    } else {
                        throw new OC4JException((MessageKey)(this.m_isQOSMServer ? PrCnMsgID.QOSMSERVER_ALREADY_RUNNING : PrCnMsgID.OC4J_ALREADY_RUNNING), new Object[0]);
                    }
                }
                this.validatePort(rmiPort, httpPort);
                ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
                if (null != rmiPort) {
                    attr = this.m_crsResource.getAttribute(ResourceType.OC4J.PORT.name());
                    attr.setValue(String.valueOf(rmiPort));
                    attrList.add(attr);
                }
                if (null != httpPort) {
                    attr = this.m_crsResource.getAttribute(ResourceType.OC4J.HTTP_PORT.name());
                    attr.setValue(String.valueOf(httpPort));
                    attrList.add(attr);
                }
                if (null != isTLSEnabled && this.m_isQOSMServer) {
                    attr = this.m_crsResource.getAttribute(ResourceType.QOSMServer.TLS_ENABLED.name());
                    attr.setValue(Boolean.toString(isTLSEnabled));
                    attrList.add(attr);
                }
                if (attrList.isEmpty()) break block16;
                if (restartResource) {
                    try {
                        this.stop(true);
                    }
                    catch (AlreadyStoppedException ase) {
                        Trace.out("Resource already stopped. Continue set port");
                    }
                }
                this.m_crsResource.update(attrList);
                if (restartResource) {
                    try {
                        this.start();
                    }
                    catch (AlreadyRunningException are) {
                        Trace.out("Resource already running.");
                    }
                }
            }
            catch (AlreadyExistsException aee) {
                throw new OC4JException(aee);
            }
            catch (CRSException ce) {
                throw new OC4JException(ce);
            }
            catch (SoftwareModuleException sme) {
                throw new OC4JException(sme);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validatePort(Integer rmiPort, Integer httpPort) throws OC4JException {
        NodeAppsFactoryImpl naf;
        int ihttpPort;
        int irmiPort;
        String[] ipOrNodeList = null;
        ArrayList<Integer> portArrayList = new ArrayList<Integer>();
        if (rmiPort != null) {
            irmiPort = rmiPort;
            portArrayList.add(irmiPort);
        } else {
            irmiPort = this.port();
        }
        if (httpPort != null) {
            ihttpPort = httpPort;
            portArrayList.add(ihttpPort);
        } else {
            ihttpPort = this.getHttpPort();
        }
        if (irmiPort == ihttpPort) {
            throw new OC4JException((MessageKey)(this.m_isQOSMServer ? PrCnMsgID.QOSMSERVER_MODIFY_PORTS_SAME_NUMBER : PrCnMsgID.OC4J_MODIFY_PORTS_SAME_NUMBER), irmiPort);
        }
        try {
            naf = NodeAppsFactoryImpl.getInstance();
        }
        catch (SoftwareModuleException sfe) {
            Trace.out("This exception should never be encountered:" + sfe);
            Trace.out("Checking the availability of port failed.");
            throw new OC4JException((MessageKey)PrCnMsgID.CHECK_PORT_AVAILABILITY_FAILURE, (Throwable)sfe, new Object[0]);
        }
        try {
            List<Listener> listeners = naf.getListeners();
            for (Listener listener : listeners) {
                int[] ports;
                for (int port : ports = listener.getEndpoints().getTCPPortArr()) {
                    if (port == irmiPort) {
                        throw new OC4JException((MessageKey)(this.m_isQOSMServer ? PrCnMsgID.QOSMSERVER_MODIFY_RMIPORT_CONFLICT_LISTENER : PrCnMsgID.OC4J_MODIFY_RMIPORT_CONFLICT_LISTENER), port, listener.getName());
                    }
                    if (port != ihttpPort) continue;
                    throw new OC4JException((MessageKey)(this.m_isQOSMServer ? PrCnMsgID.QOSMSERVER_MODIFY_HTTPPORT_CONFLICT_LISTENER : PrCnMsgID.OC4J_MODIFY_HTTPPORT_CONFLICT_LISTENER), port, listener.getName());
                }
            }
        }
        catch (NotExistsException e) {
            Trace.out("There is no listener. Not an error.");
        }
        catch (ListenerException e) {
            Trace.out("Got ListenerException: " + e);
            throw new OC4JException(e);
        }
        try {
            ipOrNodeList = Cluster.getNodes();
            Iterator e = portArrayList.iterator();
            while (e.hasNext()) {
                int port = (Integer)e.next();
                try {
                    if (Utils.isPriviledgedPort(port)) {
                        Trace.out("Port " + port + " is in privileged port range.");
                        throw new OC4JException((MessageKey)PrCnMsgID.INVALID_PORT_PRIVILEGED, Integer.toString(port));
                    }
                    int[] portList = new int[]{port};
                    naf.checkPorts(ipOrNodeList, portList);
                    Trace.out("Port: " + port + " is available");
                }
                catch (CompositeOperationException coe) {
                    String localNodeName = "";
                    Trace.out("Port " + port + " is not available on node " + localNodeName + " (local node)." + "Details: " + coe);
                    StringBuilder nodeListStrBuilder = new StringBuilder("");
                    for (int i = 0; i < ipOrNodeList.length; ++i) {
                        if (i == 0) {
                            nodeListStrBuilder.append(ipOrNodeList[i]);
                            continue;
                        }
                        nodeListStrBuilder.append(", ");
                        nodeListStrBuilder.append(ipOrNodeList[i]);
                    }
                    Exception nestedException = null;
                    try {
                        nestedException = coe.getException(String.valueOf(port));
                        throw new OC4JException((MessageKey)PrCnMsgID.PORT_NOT_AVAILABLE_ACROSS_NODES, port, nodeListStrBuilder.toString(), nestedException);
                    }
                    catch (NoSuchIdentifierException nsie) {
                        Trace.out("NoSuchIdentifierException thrown b/c there is no key \"" + String.valueOf(port) + "\" in the map m_resultMap of " + "the CompositeOperationException. Details: " + nsie);
                    }
                    throw new OC4JException((MessageKey)PrCnMsgID.PORT_NOT_AVAILABLE_ACROSS_NODES, port, nodeListStrBuilder.toString(), nestedException);
                    return;
                }
            }
        }
        catch (ClusterException ce) {
            Trace.out("Unable to retrieve the list of nodes.");
            throw new OC4JException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_LIST_OF_NODES, new Object[0]);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, OC4JException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new OC4JException(e);
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.QOSMSERVER.toString();
    }

    public static String getResourceName(boolean isQOSMSrv) {
        if (isQOSMSrv) {
            return "ora." + ResourceLiterals.QOSMSERVER.toString();
        }
        return "ora." + ResourceLiterals.OC4J.toString();
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, OC4JException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new OC4JException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void enable(Node node) throws OC4JException {
        this.setEnableDisable(true, node);
    }

    @Override
    public void disable(Node node) throws OC4JException {
        this.setEnableDisable(false, node);
    }

    private void setEnableDisable(boolean bEnable, Node ... nodes) throws OC4JException {
        ArrayList<Node> nodeList = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            nodeList.add(node);
        }
        try {
            if (bEnable) {
                super.enable(nodeList);
            } else {
                super.disable(nodeList);
            }
        }
        catch (AlreadyEnabledException e) {
            throw new OC4JException(e);
        }
        catch (AlreadyDisabledException e) {
            throw new OC4JException(e);
        }
        catch (CompositeOperationException e) {
            throw new OC4JException(e);
        }
        catch (SoftwareModuleException e) {
            throw new OC4JException(e);
        }
    }

    @Override
    public void start(Node node) throws AlreadyRunningException, OC4JException {
        try {
            super.start(node);
        }
        catch (SoftwareModuleException e) {
            throw new OC4JException(e);
        }
    }

    private ResourceAttribute createACLAttr() throws CRSException {
        NativeSystem ns = new SystemFactory().CreateSystem();
        ResourcePermissionsImpl per = null;
        try {
            Util utl = new Util();
            per = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.CRS_USER);
            if (ns.isUnixSystem()) {
                Trace.out("UNIX System, setting primary group.");
                String owner = per.getOwner();
                String pGroup = utl.getPrimaryGroup(owner);
                Trace.out(" ACL pGroup[" + pGroup + "]");
                per.setPerm(ResourceType.ACL.PGROUP, pGroup, ResourceType.ACL_PERM.READ);
                String crsHome = utl.getCRSHome();
                String group = utl.getOracleGroup(crsHome);
                per.setPerm(ResourceType.ACL.GROUP, group, ResourceType.ACL_PERM.READ);
            }
            per.setPerm(ResourceType.ACL.OTHER, "", ResourceType.ACL_PERM.READ);
            String acl = ResourceLiterals.ACL_ATTR.toString();
            Trace.out(" ACL permissions [" + per.getAclString() + "]");
            ResourceAttribute aclAttr = new ResourceAttribute(acl, per.getAclString());
            return aclAttr;
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            throw new CRSException(e);
        }
    }

    @Override
    public void setTLS(boolean enableTLS) throws OC4JException {
        this.internalModify(null, null, false, enableTLS);
    }

    @Override
    public void setTLS(boolean enableTLS, boolean force) throws OC4JException {
        this.internalModify(null, null, force, enableTLS);
    }

    @Override
    public boolean isTLSEnabled() throws OC4JException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.QOSMServer.TLS_ENABLED.name());
            return Boolean.parseBoolean(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new OC4JException((MessageKey)PrCnMsgID.GET_TLS_ENABLED_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }
}

