/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nodeapps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.InterfaceType;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.home.Home;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeFactory;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.network.GlobalNetworkClassificationImpl;
import oracle.cluster.impl.network.SubnetImpl;
import oracle.cluster.impl.nodeapps.EONSImpl;
import oracle.cluster.impl.nodeapps.EndpointsImpl;
import oracle.cluster.impl.nodeapps.ListenerImpl;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.nodeapps.ONSImpl;
import oracle.cluster.impl.nodeapps.VIPImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.GlobalNetworkClassification;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.EONS;
import oracle.cluster.nodeapps.EONSException;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.InvalidFileException;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.ListenerType;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.ONS;
import oracle.cluster.nodeapps.ONSException;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrChMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.net.config.AddressConfig;
import oracle.net.config.AddressListConfig;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.Profile;
import oracle.net.config.ProfileException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.Service;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;
import oracle.net.nl.InvalidSyntaxException;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.node.PortAvailableCommand;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.supercluster.common.SCDiscoveryMethod;

public class NodeAppsFactoryImpl {
    private static NodeAppsFactoryImpl s_instance;
    private static final String NET_NUM = "netNum";
    private static final int NO_FREE_PORT = -1;
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String DESCRIPTION_LIST = "DESCRIPTION_LIST";
    private static final String WALLET_LOCATION = "WALLET_LOCATION";
    private static final String DIRECTORY_KEYWORD = "DIRECTORY";
    private static final String METHOD_KEYWORD = "METHOD";
    private static final String FILE_KEYWORD = "FILE";

    private NodeAppsFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized NodeAppsFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new NodeAppsFactoryImpl();
        }
        return s_instance;
    }

    public Network createNetwork(String netNum, DHCPServerType dhcpServerType, String netmask, String subnet, String[] ifList, String[] pingTargets, Version version, boolean isLeaf) throws AlreadyExistsException, NetworkException {
        try {
            if (isLeaf) {
                try {
                    this.validateLeafNW(Integer.parseInt(netNum));
                }
                catch (NumberFormatException nfe) {
                    throw new NetworkException((MessageKey)PrCcMsgID.INVALID_VALUE_FOR_PARAM, NET_NUM, netNum);
                }
            }
            NetworkImpl networkImpl = new NetworkImpl(CRSFactoryImpl.getInstance().create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(netNum)));
            GlobalNetworkClassificationImpl gnwcls = new GlobalNetworkClassificationImpl(subnet, netmask, ifList);
            networkImpl.create(dhcpServerType, gnwcls, pingTargets, version, isLeaf);
            return networkImpl;
        }
        catch (CRSException e) {
            throw new NetworkException(e);
        }
    }

    public GlobalNetworkClassification getGlobalNetworkClassification(String subnet, String netmask, String[] interfaces) {
        return new GlobalNetworkClassificationImpl(subnet, netmask, interfaces);
    }

    public GlobalNetworkClassification getGlobalNetworkClassification(String subnet) {
        return new GlobalNetworkClassificationImpl(subnet, null, null);
    }

    public Network getNetwork(String netNum) throws NotExistsException, NetworkException {
        try {
            NetworkImpl network = new NetworkImpl(CRSFactoryImpl.getInstance().create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(netNum)));
            CRSResource crsRes = network.crsResource();
            return network;
        }
        catch (CRSException e) {
            throw new NetworkException(e);
        }
        catch (SoftwareModuleException e) {
            throw new NetworkException(e);
        }
    }

    public Network getNetwork(int netNum, GlobalNetworkClassification gnwcls) throws NotExistsException, NetworkException {
        List<Network> nwList;
        Network nw = null;
        try {
            nwList = this.getNetworks();
        }
        catch (NotExistsException e) {
            nwList = null;
        }
        if (nwList != null) {
            for (Network currNetwork : nwList) {
                if (currNetwork.getNumber() == netNum) {
                    Subnet gnwclsSubnet;
                    ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                    boolean isOPCEnv = false;
                    try {
                        isOPCEnv = clusterwareInfo.isOPCEnv();
                    }
                    catch (InstallException ie) {
                        Trace.out("Error detecting if OPC env. Details:\n" + ie.getMessage());
                        throw new NetworkException((MessageKey)PrCnMsgID.GET_NEWTORK_FAILED, (Throwable)ie, new Object[0]);
                    }
                    if (!isOPCEnv && !currNetwork.compareSubnet(gnwclsSubnet = gnwcls.subNet())) {
                        if (gnwclsSubnet.getIPAddrType() == IPAddressUtil.IPAddrType.IPv4) {
                            Subnet ipv4Subnet = currNetwork.subnet();
                            if (!ipv4Subnet.getName().equals(gnwclsSubnet.getName())) {
                                throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_SUBNET_DIF, netNum, gnwclsSubnet.getName(), ipv4Subnet.getName());
                            }
                            if (!ipv4Subnet.subnetMaskAsStr().equals(gnwclsSubnet.subnetMaskAsStr())) {
                                throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_NETMASK_DIF, netNum, gnwclsSubnet.subnetMaskAsStr(), ipv4Subnet.subnetMaskAsStr());
                            }
                        } else if (gnwclsSubnet.getIPAddrType() == IPAddressUtil.IPAddrType.IPv6) {
                            Subnet ipv6Subnet = currNetwork.subnet_ipv6();
                            if (!ipv6Subnet.getName().equals(gnwclsSubnet.getName())) {
                                throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_SUBNET_DIF, netNum, gnwclsSubnet.getName(), ipv6Subnet.getName());
                            }
                            if (!currNetwork.subnet_ipv6().subnetMaskAsStr().equals(gnwcls.subNet().subnetMaskAsStr())) {
                                throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_NETMASK_DIF, netNum, gnwclsSubnet.subnetMaskAsStr(), ipv6Subnet.subnetMaskAsStr());
                            }
                        }
                    }
                    if (gnwcls.networkAdapters().size() != 0 && !currNetwork.compareAdapters(gnwcls.networkAdapters())) {
                        Trace.out("Adapters are not the same.");
                        StringBuffer interfaces1 = new StringBuffer();
                        List<NetworkAdapter> naList1 = gnwcls.networkAdapters();
                        boolean isFirst = true;
                        for (NetworkAdapter na1 : naList1) {
                            if (isFirst) {
                                isFirst = false;
                            } else {
                                interfaces1.append('|');
                            }
                            interfaces1.append(na1.getAdapterName());
                        }
                        List<NetworkAdapter> naList2 = currNetwork.networkAdapters();
                        if (naList2.size() == 0) {
                            throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_INTERFACE_NON, netNum, interfaces1.toString());
                        }
                        StringBuffer interfaces2 = new StringBuffer();
                        isFirst = true;
                        for (NetworkAdapter na2 : naList2) {
                            if (isFirst) {
                                isFirst = false;
                            } else {
                                interfaces2.append('|');
                            }
                            interfaces2.append(na2.getAdapterName());
                        }
                        throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_INTERFACE_DIF, netNum, interfaces1.toString(), interfaces2.toString());
                    }
                    nw = currNetwork;
                    break;
                }
                if (!currNetwork.compareSubnet(gnwcls.subNet()) || !currNetwork.compareAdapters(gnwcls.networkAdapters())) continue;
                StringBuffer interfaces1 = new StringBuffer();
                List<NetworkAdapter> naList1 = gnwcls.networkAdapters();
                for (NetworkAdapter na1 : naList1) {
                    interfaces1.append(na1.getAdapterName());
                }
                StringBuffer interfaces2 = new StringBuffer();
                List<NetworkAdapter> naList2 = currNetwork.networkAdapters();
                for (NetworkAdapter na2 : naList2) {
                    interfaces2.append(na2.getAdapterName());
                }
                Subnet gnwclsSubnet = gnwcls.subNet();
                Map<IPAddressUtil.IPAddrType, Subnet> subnetMap = currNetwork.subnets();
                Subnet subnet = subnetMap.get((Object)gnwclsSubnet.getIPAddrType());
                if (subnet == null) continue;
                throw new NetworkException((MessageKey)PrCnMsgID.NETWORK_CONFLICT_SUBNET, netNum, gnwclsSubnet.getName(), interfaces1.toString(), currNetwork.getNumber(), subnet.getName(), interfaces2);
            }
        }
        if (nw == null) {
            throw new NotExistsException((MessageKey)PrCnMsgID.NETWORK_NOT_EXIST, new Object[0]);
        }
        return nw;
    }

    public Network getNetwork(GlobalNetworkClassification gnwcls) throws NotExistsException, NetworkException {
        List<Network> nwList;
        Network nw = null;
        Trace.out("gnwcls is " + gnwcls);
        try {
            nwList = this.getNetworks();
        }
        catch (NotExistsException e) {
            nwList = null;
        }
        if (nwList != null) {
            for (Network netw : nwList) {
                if (!netw.compareSubnet(gnwcls.subNet()) || !netw.compareAdapters(gnwcls.networkAdapters())) continue;
                Trace.out("Subnet and adapters are the same");
                nw = netw;
                break;
            }
        }
        if (nw == null) {
            throw new NotExistsException((MessageKey)PrCnMsgID.NETWORK_NOT_EXIST, new Object[0]);
        }
        return nw;
    }

    public Map<IPAddressUtil.IPAddrType, String> getNetmasks(int netNum) throws NotExistsException, NetworkException {
        HashMap<IPAddressUtil.IPAddrType, String> netmaskMap = new HashMap<IPAddressUtil.IPAddrType, String>(2);
        Network network = this.getNetwork(String.valueOf(netNum));
        Map<IPAddressUtil.IPAddrType, Subnet> subnetAndNetmaskMap = network.subnets();
        Subnet subnet = subnetAndNetmaskMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
        if (subnet != null) {
            netmaskMap.put(IPAddressUtil.IPAddrType.IPv4, subnet.subnetMaskAsStr());
            Trace.out("The network resource with 'net number = " + netNum + "' has 'IPv4 netmask = " + (String)netmaskMap.get((Object)IPAddressUtil.IPAddrType.IPv4) + "'");
        }
        if ((subnet = subnetAndNetmaskMap.get((Object)IPAddressUtil.IPAddrType.IPv6)) != null) {
            netmaskMap.put(IPAddressUtil.IPAddrType.IPv6, subnet.subnetMaskAsStr());
            Trace.out("The network resource with 'net number = " + netNum + " has 'IPv6 prefix length = " + (String)netmaskMap.get((Object)IPAddressUtil.IPAddrType.IPv6) + "'");
        }
        return netmaskMap;
    }

    private void checkVIPAddressReachability(InetAddress vipAddress) throws VIPException {
        try {
            if (IPAddressUtil.isPingable(vipAddress)) {
                throw new VIPException((MessageKey)PrCcMsgID.VIP_ADDRESS_REACHABILITY_ERROR, vipAddress.getHostAddress());
            }
        }
        catch (IPAddressException ipAddressException) {
            throw new VIPException(ipAddressException);
        }
    }

    public VIP createVIP(Network network, String prefNode, Version version) throws AlreadyExistsException, VIPException {
        try {
            String vipResName = null;
            int netNum = network.getNumber();
            vipResName = netNum == this.getDefaultNetworkNumber() ? VIPImpl.getResourceName(prefNode) : VIPImpl.getResourceName(prefNode + '_' + netNum);
            VIPImpl vipImpl = new VIPImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterVIP.NAME.name(), vipResName));
            vipImpl.create(network, prefNode, version);
            return vipImpl;
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
        catch (NetworkException e) {
            throw new VIPException(e);
        }
    }

    public VIP createVIP(VIPAddress vipAddress, String vipResIden, String prefNode, int netNum, String subnet, DHCPServerType serverType, Version version) throws AlreadyExistsException, VIPException {
        return this.createVIP(vipAddress, vipResIden, prefNode, netNum, subnet, serverType, version, false);
    }

    public VIP createVIP(VIPAddress vipAddress, String vipResIden, String prefNode, int netNum, String subnet, DHCPServerType serverType, Version version, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, VIPException {
        return this.createVIP(vipAddress, vipResIden, prefNode, netNum, subnet, serverType, version, skipVIPReachabilityCheck, null);
    }

    public VIP createVIP(VIPAddress vipAddress, String vipResIden, String prefNode, int netNum, String subnet, DHCPServerType serverType, Version version, boolean skipVIPReachabilityCheck, VIPAddress natAddress) throws AlreadyExistsException, VIPException {
        try {
            String vipResName = null;
            if (!skipVIPReachabilityCheck) {
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                boolean isODAEnv = false;
                try {
                    isODAEnv = clusterwareInfo.isODAEnv();
                    if (!isODAEnv) {
                        Trace.out("Checking if ODA Lite env");
                        isODAEnv = clusterwareInfo.isODALiteEnv();
                        if (isODAEnv) {
                            Trace.out("Detected that the env is ODA Lite");
                        }
                    }
                    if (!isODAEnv) {
                        Trace.out("Checking if ODA Single IP env");
                        isODAEnv = clusterwareInfo.isODASingleIPEnv();
                        if (isODAEnv) {
                            Trace.out("Detected that the env is ODA Single IP");
                        }
                    }
                }
                catch (InstallException ie) {
                    Trace.out("Error detecting if ODA env. Details:\n" + ie.getMessage());
                    throw new VIPException((MessageKey)PrCnMsgID.ADD_VIP_FAILED, (Throwable)ie, new Object[0]);
                }
                if (!isODAEnv) {
                    boolean isOPCEnv = false;
                    try {
                        isOPCEnv = clusterwareInfo.isOPCEnv();
                    }
                    catch (InstallException ie) {
                        Trace.out("Error detecting if OPC env. Details:\n" + ie.getMessage());
                        throw new VIPException((MessageKey)PrCnMsgID.ADD_VIP_FAILED, (Throwable)ie, new Object[0]);
                    }
                    if (!isOPCEnv) {
                        this.checkVIPAddressReachability(vipAddress.getIPAddress());
                    } else {
                        Trace.out("OPC env. Skipping check for IP address reachability");
                    }
                } else {
                    Trace.out("ODA env. Skipping check for IP address reachability");
                }
            }
            vipResName = netNum == this.getDefaultNetworkNumber() ? VIPImpl.getResourceName(prefNode) : VIPImpl.getResourceName(prefNode + '_' + netNum);
            VIPImpl vipImpl = new VIPImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterVIP.NAME.name(), vipResName));
            vipImpl.create(vipAddress, prefNode, netNum, subnet, serverType, version, natAddress);
            return vipImpl;
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
    }

    public VIP createVIP(Network network, InetAddress vipAddress, String prefNode, Version version) throws AlreadyExistsException, VIPException {
        return this.createVIP(network, vipAddress, prefNode, version, false);
    }

    public VIP createVIP(Network network, InetAddress vipAddress, String prefNode, Version version, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, VIPException {
        if (vipAddress == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipAddress", vipAddress);
        }
        if (prefNode == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "prefNode", prefNode);
        }
        if (network == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "network", network);
        }
        if (version == null) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            String vipResName = null;
            if (!skipVIPReachabilityCheck) {
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                boolean isODAEnv = false;
                boolean isODALiteEnv = false;
                try {
                    isODAEnv = clusterwareInfo.isODAEnv();
                    if (!isODAEnv) {
                        Trace.out("Checking if ODA Lite env");
                        isODALiteEnv = clusterwareInfo.isODALiteEnv();
                    }
                }
                catch (InstallException ie) {
                    Trace.out(ie.getMessage());
                }
                if (!isODAEnv && !isODALiteEnv) {
                    this.checkVIPAddressReachability(vipAddress);
                }
            }
            if (network.getNumber() == this.getDefaultNetworkNumber()) {
                vipResName = VIPImpl.getResourceName(prefNode);
            } else {
                int netNum = network.getNumber();
                vipResName = VIPImpl.getResourceName(prefNode + '_' + netNum);
            }
            Trace.out("vip resource name is " + vipResName);
            VIPImpl vipImpl = new VIPImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterVIP.NAME.name(), vipResName));
            IPAddressUtil.IPAddrType ipAddrType = null;
            if (vipAddress instanceof Inet4Address) {
                ipAddrType = IPAddressUtil.IPAddrType.IPv4;
            } else if (vipAddress instanceof Inet6Address) {
                ipAddrType = IPAddressUtil.IPAddrType.IPv6;
            }
            vipImpl.create(network, vipAddress.getHostName(), ipAddrType, prefNode, version);
            return vipImpl;
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
        catch (NetworkException e) {
            throw new VIPException(e);
        }
    }

    public VIP getVIP(String nodeOrVipName) throws NotExistsException, VIPException {
        try {
            List<VIP> vipList = this.getVIPs(null, nodeOrVipName);
            int vipSize = vipList.size();
            if (vipSize == 0) {
                throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, VIPImpl.getResourceName(nodeOrVipName));
            }
            if (vipSize > 1) {
                Trace.out("Found multiple VIPs for name (" + nodeOrVipName + "): ");
                for (VIP vip : vipList) {
                    Map<IPAddressUtil.IPAddrType, InetAddress> addressMap = vip.addresses();
                    String addrName = "";
                    if (addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                        addrName = addressMap.get((Object)IPAddressUtil.IPAddrType.IPv4).getHostName();
                        if (addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                            addrName = addrName + "," + addressMap.get((Object)IPAddressUtil.IPAddrType.IPv6).getHostName();
                        }
                    } else if (addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                        addrName = addressMap.get((Object)IPAddressUtil.IPAddrType.IPv6).getHostName();
                    }
                    Trace.out("Resource name: " + vip.getName() + ", UserAssignedName: " + vip.getUserAssignedName() + ", Address name: " + addrName);
                }
                throw new VIPException((MessageKey)PrCnMsgID.MULTIPLE_VIPS_FOR_NAME, vipList.size(), nodeOrVipName);
            }
            return vipList.get(0);
        }
        catch (SoftwareModuleException e) {
            throw new VIPException(e);
        }
    }

    public VIP getVIP(String nodeName, String vipName, int netNum) throws NotExistsException, VIPException, NodeException, NetworkException {
        VIP vip = null;
        try {
            vip = this.getVIP(vipName);
            if (nodeName.equalsIgnoreCase(vip.preferredNode().getName()) && vip.network().getNumber() == netNum) {
                return vip;
            }
            throw new VIPException((MessageKey)PrCnMsgID.VIP_CONFLICT_VIPNAME, nodeName, vipName, netNum, vip.preferredNode().getName(), vip.getUserAssignedName(), vip.network().getNumber());
        }
        catch (NotExistsException nee) {
            List<VIP> vipList = this.getVIPs(netNum);
            boolean isOPCEnv = false;
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            try {
                isOPCEnv = clusterwareInfo.isOPCEnv();
            }
            catch (InstallException ie) {
                Trace.out("Error detecting if OPC env. Details:\n" + ie.getMessage());
                throw new VIPException((MessageKey)PrCnMsgID.ADD_VIP_FAILED, (Throwable)ie, new Object[0]);
            }
            boolean isODALiteEnv = false;
            try {
                if (!isOPCEnv) {
                    Trace.out("Checking if ODA Lite env");
                    isODALiteEnv = clusterwareInfo.isODALiteEnv();
                }
            }
            catch (InstallException ie) {
                Trace.out("Error detecting if ODA Lite env. Details:\n" + ie.getMessage());
                throw new VIPException(ie);
            }
            if (vipList != null && !isOPCEnv && !isODALiteEnv) {
                for (VIP vip_i : vipList) {
                    if (!vip_i.preferredNode().getName().equalsIgnoreCase(nodeName)) continue;
                    throw new VIPException((MessageKey)PrCnMsgID.VIP_CONFLICT_NETNUM_OR_NODE, nodeName, vipName, netNum, vip_i.preferredNode().getName(), vip_i.getUserAssignedName(), netNum);
                }
            }
            throw nee;
        }
    }

    public ONS createONS(String localPort, String remotePort, String[] remoteHosts, String emPort, Version version) throws AlreadyExistsException, ONSException {
        return this.createONS(localPort, remotePort, remoteHosts, emPort, version, null, false);
    }

    public ONS createONS(String localPort, String remotePort, String[] remoteHosts, String emPort, Version version, boolean skipPortCheck) throws AlreadyExistsException, ONSException {
        return this.createONS(localPort, remotePort, remoteHosts, emPort, version, null, skipPortCheck);
    }

    public ONS createONS(String localPort, String remotePort, String[] remoteHosts, String emPort, Version version, String clientData) throws AlreadyExistsException, ONSException {
        return this.createONS(localPort, remotePort, remoteHosts, emPort, version, clientData, false);
    }

    public ONS createONS(String localPort, String remotePort, String[] remoteHosts, String emPort, Version version, String clientData, boolean skipPortCheck) throws AlreadyExistsException, ONSException {
        try {
            Trace.out("Validating specified ports");
            if (localPort == null || localPort.isEmpty()) {
                localPort = ResourceLiterals.ONS_LOCAL_PORT.toString();
            }
            if (remotePort == null || remotePort.isEmpty()) {
                remotePort = ResourceLiterals.ONS_REMOTE_PORT.toString();
            }
            if (emPort == null || emPort.isEmpty()) {
                emPort = ResourceLiterals.ONS_EM_PORT.toString();
            }
            if (!skipPortCheck) {
                this.validateONSPorts(Integer.parseInt(localPort), Integer.parseInt(remotePort), Integer.parseInt(emPort));
            }
            ONSImpl onsImpl = new ONSImpl(CRSFactoryImpl.getInstance().create(ResourceType.ONS.NAME.name(), ONSImpl.getResourceName()));
            onsImpl.create(localPort, remotePort, remoteHosts, emPort, version, clientData);
            return onsImpl;
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
    }

    public ONS getONS() throws NotExistsException, ONSException {
        try {
            ONSImpl onsImpl = new ONSImpl(CRSFactoryImpl.getInstance().create(ResourceType.ONS.NAME.name(), ONSImpl.getResourceName()));
            CRSResource crsRes = onsImpl.crsResource();
            return onsImpl;
        }
        catch (CRSException e) {
            throw new ONSException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ONSException(e);
        }
    }

    public EONS createEONS(SCDiscoveryMethod discoveryMethod, String port, InetAddress mcastAddress, String mcastPort, Map<String, Integer> mbrMap, Map<String, String> props, Version version) throws AlreadyExistsException, EONSException {
        try {
            EONSImpl eonsImpl = new EONSImpl(CRSFactoryImpl.getInstance().create(ResourceType.EONS.NAME.name(), EONSImpl.getResourceName()));
            eonsImpl.create(discoveryMethod, port, mcastAddress, mcastPort, mbrMap, props, version);
            return eonsImpl;
        }
        catch (CRSException e) {
            throw new EONSException(e);
        }
    }

    public EONS getEONS() throws NotExistsException, EONSException {
        try {
            EONSImpl eonsImpl = new EONSImpl(CRSFactoryImpl.getInstance().create(ResourceType.EONS.NAME.name(), EONSImpl.getResourceName()));
            CRSResource crsRes = eonsImpl.crsResource();
            return eonsImpl;
        }
        catch (CRSException e) {
            throw new EONSException(e);
        }
        catch (SoftwareModuleException e) {
            throw new EONSException(e);
        }
    }

    public List<Listener> createASMListenersForUpgradeToFlex(Node firstNode, Version version) throws AlreadyExistsException, ListenerException {
        try {
            ArrayList<Listener> asmlsnrList = new ArrayList<Listener>();
            String crshome = ResourceLiterals.CRS_HOME_VALUE.toString();
            boolean inPublicSubnet = false;
            GlobalNetworkClassificationImpl gnwcls = null;
            Endpoints endpoints = null;
            String endpointsStr = null;
            int lsnrseq = 0;
            Listener lsnr = null;
            ListenerType lsnrType = ListenerType.ASM_LISTENER;
            String bindir = new Util().getCRSHome() + File.separator + "bin";
            Trace.out("Calling " + bindir + File.separator + "oifcfg for node " + "localnode");
            List<OIFCFGResult> interfaceList = new ClusterwareInfo().listClusterInterfaces(bindir);
            for (OIFCFGResult itf : interfaceList) {
                String ifType = itf.getInterfaceType();
                if (ifType.indexOf(InterfaceType.CLUSTER_INTERCONNECT.toString()) < 0) continue;
                gnwcls = new GlobalNetworkClassificationImpl(itf.getSubnet().getHostAddress(), "", new String[]{itf.getInterfaceName()});
                if (ifType.indexOf(InterfaceType.PUBLIC.toString()) > 0) {
                    Trace.out("The CLUSTER_INTERCONNECT interface is also PUBLIC interface: " + itf.getInterfaceName());
                    inPublicSubnet = true;
                }
                String lsnrName = ResourceLiterals.ASMNET.toString() + ++lsnrseq + (Object)((Object)ResourceLiterals.LSNR_ASM);
                int freePort = this.getFreePort(ListenerType.ASM_LISTENER, inPublicSubnet);
                Trace.out("Get free port for asm listener: " + freePort);
                endpointsStr = Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString() + ':' + Integer.toString(freePort);
                endpoints = this.createEndpoints(endpointsStr, "/");
                try {
                    Trace.out("Test whether listener already exists");
                    lsnr = this.getListener(ListenerImpl.getListenerName(lsnrType, lsnrName));
                }
                catch (NotExistsException e) {
                    Trace.out("Expected exception: listener " + lsnrName + " is not registered yet.");
                }
                if (lsnr != null) {
                    Trace.out("The asm listener " + lsnrName + " is already registered.");
                    continue;
                }
                ListenerImpl asmlsnrImpl = null;
                asmlsnrImpl = new ListenerImpl(CRSFactoryImpl.getInstance().create(ResourceType.Listener.NAME.name(), ListenerImpl.getResourceName(lsnrType, lsnrName)));
                asmlsnrImpl.createASMListener(gnwcls, version, endpoints, false);
                try {
                    asmlsnrImpl.disable();
                    Trace.out("Disable " + asmlsnrImpl.getName() + " globally");
                }
                catch (AlreadyDisabledException e) {
                    Trace.out("Got AlreadyDisabledException " + e.getMessage());
                }
                try {
                    asmlsnrImpl.enable(firstNode);
                    Trace.out("Enable " + asmlsnrImpl.getName() + " on " + firstNode.getName());
                }
                catch (AlreadyEnabledException e) {
                    Trace.out("Not an error. Got AlreadyEnabledException " + e.getMessage());
                }
                catch (NodeException e) {
                    throw new ListenerException(e);
                }
                asmlsnrList.add(asmlsnrImpl);
            }
            return asmlsnrList;
        }
        catch (UtilException e) {
            throw new ListenerException(e);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (InstallException e) {
            throw new ListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
    }

    public Listener createListener(String lsnrName, String oracleHome, int netNum, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        return this.createListener(ListenerType.LISTENER, lsnrName, oracleHome, netNum, null, version, endpoints, skipportscheck, null);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        return this.createListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, endpoints, skipportscheck, null);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, boolean skipportscheck, String user) throws AlreadyExistsException, ListenerException {
        return this.internalCreateListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, null, skipportscheck, user, null);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, boolean skipportscheck, String user, String group) throws AlreadyExistsException, ListenerException {
        return this.internalCreateListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, null, skipportscheck, user, group);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, GlobalNetworkClassification gnwcls, Version version) throws AlreadyExistsException, ListenerException {
        this.assertLsnrType(lsnrType);
        this.assertLsnrName(lsnrName);
        this.assertGlobalNetworkClassification(gnwcls);
        this.assertVersion(version);
        Endpoints endpoints = null;
        String endpointsStr = null;
        int freePort = this.getFreePort(lsnrType);
        endpointsStr = Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString() + ':' + Integer.toString(freePort);
        endpoints = this.createEndpoints(endpointsStr, "/");
        return this.internalCreateListener(lsnrType, lsnrName, null, 0, gnwcls, version, endpoints, false, null, null);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck, String user) throws AlreadyExistsException, ListenerException {
        return this.internalCreateListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, endpoints, skipportscheck, user, null);
    }

    public Listener createListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck, String user, String group) throws AlreadyExistsException, ListenerException {
        return this.internalCreateListener(lsnrType, lsnrName, oracleHome, netNum, gnwcls, version, endpoints, skipportscheck, user, group);
    }

    public void upgradeVIPDepAttrs(ResourceAttribute resAttr, List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws UpgradeException {
        try {
            VIPImpl vip = new VIPImpl(resAttr);
            vip.upgradeVIPDepAttrs(attrList, inclStartDep, inclStopDep);
        }
        catch (VIPException e) {
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_DEPENDENCIES, (Throwable)e, resAttr.getValue());
        }
    }

    public void upgradeMgmtLsnrDepAttrs(ResourceAttribute resAttr, List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws UpgradeException {
        try {
            ListenerImpl mgmtLsnrImpl = new ListenerImpl(resAttr);
            mgmtLsnrImpl.upgradeMgmtLsnrDepAttrs(attrList, inclStartDep, inclStopDep);
        }
        catch (ListenerException e) {
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_DEPENDENCIES, (Throwable)e, resAttr.getValue());
        }
    }

    private Listener internalCreateListener(ListenerType lsnrType, String lsnrName, String oracleHome, int netNum, GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck, String user, String group) throws AlreadyExistsException, ListenerException {
        if (oracleHome != null && !oracleHome.equals("%CRS_HOME%") && lsnrType != ListenerType.MGMT_LISTENER) {
            try {
                HomeFactory hf = HomeFactory.getInstance();
                Home home = hf.getHome(oracleHome);
                Version srvmversion = home.getVersion(oracleHome);
                if (!srvmversion.equals(version)) {
                    throw new ListenerException((MessageKey)PrCnMsgID.SRVM_LISTENER_VERSION_MISMATCH, version.toString(), srvmversion.toString());
                }
            }
            catch (HomeException e) {
                Trace.out("Exception caught while retriving version of srvm");
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, lsnrName);
            }
        }
        try {
            Listener lsnr = null;
            try {
                Trace.out("Test whether listener already exists");
                lsnr = this.getListener(ListenerImpl.getListenerName(lsnrType, lsnrName));
            }
            catch (NotExistsException e) {
                Trace.out("Expected exception: listener " + lsnrName + " is not registered yet.");
            }
            if (lsnr != null) {
                throw new AlreadyExistsException((MessageKey)PrCnMsgID.LISTENER_ALREADY_CREATED, lsnr.getUserAssignedName());
            }
            ListenerImpl lsnrImpl = null;
            lsnrImpl = new ListenerImpl(CRSFactoryImpl.getInstance().create(ResourceType.Listener.NAME.name(), ListenerImpl.getResourceName(lsnrType, lsnrName)));
            Endpoints ep = endpoints;
            int freePort = Integer.parseInt(ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString());
            if (endpoints == null) {
                if (!skipportscheck) {
                    freePort = this.getFreePort(lsnrType);
                }
                String endpointsStr = Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString() + ':' + Integer.toString(freePort);
                ep = this.createEndpoints(endpointsStr, "/");
            }
            if (ep != null && ep.isFirewallConfigured() && lsnrType != ListenerType.LISTENER) {
                throw new ListenerException((MessageKey)PrCnMsgID.FIREWALL_LISTENER_ERROR, lsnrType.toString());
            }
            if (lsnrType == ListenerType.LISTENER) {
                lsnrImpl.create(oracleHome, netNum, version, ep, skipportscheck, user, group);
            } else if (lsnrType == ListenerType.ASM_LISTENER) {
                if (gnwcls == null) {
                    lsnrImpl.createASMListener(version, ep, skipportscheck);
                } else {
                    lsnrImpl.createASMListener(gnwcls, version, ep, skipportscheck);
                }
            } else if (lsnrType == ListenerType.RIM_LISTENER) {
                lsnrImpl.createRIMListener(gnwcls, version, ep, skipportscheck);
            } else if (lsnrType == ListenerType.MGMT_LISTENER) {
                lsnrImpl.createMgmtListener(version, ep, skipportscheck);
            }
            return lsnrImpl;
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    public Listener createListener(String lsnrName, String oracleHome, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, NetworkException, ListenerException {
        if (oracleHome != null && !oracleHome.equals("%CRS_HOME%")) {
            try {
                HomeFactory hf = HomeFactory.getInstance();
                Home home = hf.getHome(oracleHome);
                Version srvmversion = home.getVersion(oracleHome);
                if (!srvmversion.equals(version)) {
                    throw new ListenerException((MessageKey)PrCnMsgID.SRVM_LISTENER_VERSION_MISMATCH, version.toString(), srvmversion.toString());
                }
            }
            catch (HomeException e) {
                Trace.out("Exception caught while retriving version of srvm");
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, lsnrName);
            }
        }
        try {
            Endpoints ep = endpoints;
            if (endpoints == null) {
                ep = this.createEndpoints(false);
            }
            Listener lsnr = null;
            try {
                Trace.out("Test whether listener already exists");
                lsnr = this.getListener(lsnrName);
            }
            catch (NotExistsException e) {
                Trace.out("Expected exception: listener " + lsnrName + " is not registered yet.");
            }
            if (lsnr != null) {
                throw new AlreadyExistsException((MessageKey)PrCnMsgID.LISTENER_ALREADY_CREATED, lsnr.getUserAssignedName());
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ListenerImpl lsnrImpl = new ListenerImpl(crsFactory.getInstance().create(ResourceType.Listener.NAME.name(), ListenerImpl.getResourceName(lsnrName)));
            if (!Cluster.isCluster()) {
                lsnrImpl.create(oracleHome, version, ep, skipportscheck);
            } else {
                List<ResourceAttribute> list = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.Network.NAME.toString()));
                if (list.size() == 1) {
                    lsnrImpl.create(oracleHome, Integer.parseInt(NetworkImpl.getNumber(list.get(0).getValue())), version, ep, skipportscheck);
                } else {
                    if (list.size() == 0) {
                        throw new ListenerException((MessageKey)PrCnMsgID.NO_NET_RES_EXIST, new Object[0]);
                    }
                    StringBuilder sb = new StringBuilder(list.size());
                    for (ResourceAttribute attr : list) {
                        if (sb.length() > 0) {
                            sb.append("," + attr.getValue());
                            continue;
                        }
                        sb.append(attr.getValue());
                    }
                    throw new ListenerException((MessageKey)PrCnMsgID.MULTIPLE_NET_RES_EXIST, sb.toString());
                }
            }
            return lsnrImpl;
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    public Listener getMgmtListener() throws NotExistsException, ListenerException {
        return this.getListener(ResourceLiterals.MGMTLSNR.toString());
    }

    public Listener getListener(String lsnrName) throws NotExistsException, ListenerException {
        try {
            ListenerImpl lsnrImpl = lsnrName.equalsIgnoreCase(ResourceLiterals.MGMTLSNR.toString()) ? new ListenerImpl(CRSFactoryImpl.getInstance().create(ResourceType.MgmtListener.NAME.name(), ListenerImpl.getResourceName(lsnrName))) : new ListenerImpl(CRSFactoryImpl.getInstance().create(ResourceType.Listener.NAME.name(), ListenerImpl.getResourceName(lsnrName)));
            CRSResource crsRes = lsnrImpl.crsResource();
            ResourceAttribute attr = ((CRSResourceImpl)crsRes).getAttribute(ResourceLiterals.TYPE.name());
            Trace.out("Resource type is " + attr.getValue());
            String type = attr.getValue();
            if (type.equals(ResourceType.Listener.NAME.toString()) || type.equals(ResourceType.ASMListener.NAME.toString()) || type.equals(ResourceType.RIMListener.NAME.toString()) || type.equals(ResourceType.MgmtListener.NAME.toString())) {
                return lsnrImpl;
            }
            if (attr.getValue().equals(ResourceType.ScanListener.NAME.toString())) {
                throw new ListenerException((MessageKey)PrCnMsgID.SCAN_LSNR_TYPE, lsnrName);
            }
            Trace.out("Found a resource of type '" + attr.getValue() + "'. Should never come here");
            throw new ListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, lsnrName, ResourceType.Listener.NAME.toString());
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
    }

    public List<Listener> getASMListeners() throws NotExistsException, ListenerException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.ASMListener.NAME.toString()));
            ArrayList<Listener> lsnrList = new ArrayList<Listener>(resList.size());
            NotExistsException ne = null;
            for (ResourceAttribute attr : resList) {
                try {
                    lsnrList.add(this.getListener(ListenerImpl.getUserAssignedName(attr.getValue())));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just removed asm listener resource=" + attr.getValue());
                    ne = e;
                }
            }
            if (lsnrList.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.ASMListener.NAME.toString());
                if (ne == null) {
                    ne = new NotExistsException((MessageKey)PrCnMsgID.LSNR_NOT_EXIST, new Object[0]);
                }
                throw ne;
            }
            return Collections.unmodifiableList(lsnrList);
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.ASMListener.NAME.toString());
        }
    }

    public List<Listener> getASMListeners(String subnetStr) throws NotExistsException, ListenerException {
        this.assertSubnet(subnetStr);
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQI, ResourceLiterals.TYPE.name(), ResourceType.ASMListener.NAME.toString());
            Filter subFilter = crsFactory.getFilter(Filter.Comparator.EQI, ResourceType.ASMListener.SUBNET.name(), subnetStr.trim());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, subFilter);
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.ResourceInstance, finalFilter);
            ArrayList<Listener> lsnrList = new ArrayList<Listener>(resList.size());
            NotExistsException ne = null;
            for (ResourceAttribute attr : resList) {
                try {
                    lsnrList.add(this.getListener(ListenerImpl.getUserAssignedName(attr.getValue())));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just removed asm listener resource=" + attr.getValue());
                    ne = e;
                }
            }
            if (lsnrList.isEmpty()) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.ASMListener.NAME.toString());
                if (ne == null) {
                    ne = new NotExistsException((MessageKey)PrCnMsgID.LSNR_NOT_EXIST, new Object[0]);
                }
                throw ne;
            }
            return Collections.unmodifiableList(lsnrList);
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.ASMListener.NAME.toString());
        }
    }

    public List<Listener> getRIMListeners() throws NotExistsException, ListenerException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.RIMListener.NAME.toString()));
            ArrayList<Listener> lsnrList = new ArrayList<Listener>(resList.size());
            NotExistsException ne = null;
            for (ResourceAttribute attr : resList) {
                try {
                    lsnrList.add(this.getListener(ListenerImpl.getUserAssignedName(attr.getValue())));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just removed rim listener resource=" + attr.getValue());
                    ne = e;
                }
            }
            if (lsnrList.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.RIMListener.NAME.toString());
                if (ne == null) {
                    ne = new NotExistsException((MessageKey)PrCnMsgID.LSNR_NOT_EXIST, new Object[0]);
                }
                throw ne;
            }
            return Collections.unmodifiableList(lsnrList);
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.RIMListener.NAME.toString());
        }
    }

    public List<Listener> getListeners() throws NotExistsException, ListenerException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.Listener.NAME.toString()));
            ArrayList<Listener> lsnrList = new ArrayList<Listener>(resList.size());
            NotExistsException ne = null;
            for (ResourceAttribute attr : resList) {
                try {
                    lsnrList.add(this.getListener(ListenerImpl.getUserAssignedName(attr.getValue())));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just removed listener resource=" + attr.getValue());
                    ne = e;
                }
            }
            if (lsnrList.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.Listener.NAME.toString());
                if (ne == null) {
                    ne = new NotExistsException((MessageKey)PrCnMsgID.LSNR_NOT_EXIST, new Object[0]);
                }
                throw ne;
            }
            return Collections.unmodifiableList(lsnrList);
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.Listener.NAME.toString());
        }
    }

    public List<Listener> getListeners(String oHome) throws NotExistsException, ListenerException {
        List<ResourceAttribute> resList;
        ArrayList<Listener> lsnrList = new ArrayList<Listener>(0);
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter filter_LsnrType = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceType.Listener.NAME.toString());
            Filter filter_LsnrBaseType = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.BASE_TYPE.toString(), ResourceType.Listener.NAME.toString());
            Filter filter_OHomeEq = crsFactory.getFilter(Filter.Comparator.EQI, ResourceType.Home.ORACLE_HOME.name(), oHome);
            Filter filter_LsnrTypesOr = crsFactory.getFilter(Filter.Operator.OR, filter_LsnrType, filter_LsnrBaseType);
            Filter filter_query = crsFactory.getFilter(Filter.Operator.AND, filter_LsnrTypesOr, filter_OHomeEq);
            Trace.out("Find listener resources");
            resList = crsFactory.searchResources(CRSEntity.Type.Resource, filter_query);
        }
        catch (CRSException ce) {
            throw new ListenerException(ce);
        }
        if (resList != null && resList.size() > 0) {
            lsnrList = new ArrayList(resList.size());
            for (ResourceAttribute currNameAttr : resList) {
                String currNameAttrValue = currNameAttr.getValue();
                if (currNameAttrValue == null) continue;
                currNameAttrValue = currNameAttrValue.trim();
                Trace.out("Found a listener resource -- Resource name: " + currNameAttrValue);
                lsnrList.add(new ListenerImpl(currNameAttr));
            }
        }
        if (lsnrList.size() == 0) {
            throw new NotExistsException((MessageKey)PrCnMsgID.LSNR_NOT_EXIST, new Object[0]);
        }
        return lsnrList;
    }

    public List<Listener> getListeners(Network network) throws ListenerException {
        ArrayList<Listener> resultList = new ArrayList<Listener>();
        List<Listener> lsnrList = null;
        try {
            lsnrList = this.getListeners();
            int networkNumber = network.getNumber();
            Trace.out(String.format("checking if there is listener defined for network %d", networkNumber));
            for (Listener listener : lsnrList) {
                int listenerNetworkNumber = listener.network().getNumber();
                Trace.out(String.format("Listener network %d", listenerNetworkNumber));
                if (listenerNetworkNumber != networkNumber) continue;
                resultList.add(listener);
            }
        }
        catch (NotExistsException notExistsException) {
        }
        catch (NetworkException e) {
            throw new ListenerException(e);
        }
        return Collections.unmodifiableList(resultList);
    }

    public Network createNetwork(GlobalNetworkClassification gnwcls, int netNum, DHCPServerType serverType, String[] pingTargets, Version version, boolean isLeaf) throws AlreadyExistsException, NetworkException {
        Trace.out("Calling createNetwork");
        try {
            if (isLeaf) {
                this.validateLeafNW(netNum);
            }
            ResourceAttribute netAttr = CRSFactoryImpl.getInstance().create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(netNum)));
            Trace.out("Created netAttr");
            NetworkImpl nwImpl = new NetworkImpl(netAttr);
            Trace.out("Before getting adapters");
            List<NetworkAdapter> adapters = gnwcls.networkAdapters();
            Trace.out("Got adapters: " + adapters);
            if (adapters == null) {
                Object interfaces = null;
            } else {
                int i = 0;
                String[] interfaces = new String[adapters.size()];
                for (NetworkAdapter adapter : adapters) {
                    interfaces[i++] = adapter.getAdapterName();
                }
            }
            Trace.out("Calling NetworkImpl.create()");
            nwImpl.create(serverType, gnwcls, pingTargets, version, isLeaf);
            return nwImpl;
        }
        catch (CRSException e) {
            throw new NetworkException(e);
        }
    }

    public Network getNetwork(CRSResourceImpl crsResource) throws NetworkException {
        try {
            String[] depNames;
            ResourceAttribute attr = crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            for (String res : depNames = ResourceDependency.getResourceNames(attr, ResourceDependency.DepType.HARD_DEP)) {
                if (!res.endsWith(ResourceLiterals.NETWORK.toString())) continue;
                return new NetworkImpl(CRSFactoryImpl.getInstance().create(ResourceType.Network.NAME.name(), res));
            }
            for (String res : depNames = ResourceDependency.getResourceTypeNames(attr, ResourceDependency.DepType.HARD_DEP)) {
                String netNum = ResourceType.ClusterVIP.getNetworkNumber(res);
                if (netNum == null) continue;
                return new NetworkImpl(CRSFactoryImpl.getInstance().create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(netNum)));
            }
            throw new NetworkException((MessageKey)PrCnMsgID.DEP_RES_NOT_FOUND, ResourceLiterals.NETWORK.toString(), crsResource.getName(), Utils.getString(depNames, String.valueOf(",")));
        }
        catch (CRSException e) {
            throw new NetworkException(e);
        }
    }

    public List<Network> getNetworks() throws NotExistsException, NetworkException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.Network.NAME.toString()));
            ArrayList<Network> networkList = new ArrayList<Network>(resList.size());
            NotExistsException ne = null;
            for (ResourceAttribute attr : resList) {
                try {
                    networkList.add(this.getNetwork(NetworkImpl.getNumber(attr.getValue())));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just removed network resource=" + attr.getValue());
                    ne = e;
                }
            }
            if (networkList.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.Network.NAME.toString());
                if (ne == null) {
                    ne = new NotExistsException((MessageKey)PrCnMsgID.NETWORK_NOT_EXIST, new Object[0]);
                }
                throw ne;
            }
            return Collections.unmodifiableList(networkList);
        }
        catch (CRSException e) {
            throw new NetworkException((MessageKey)PrCrMsgID.RESTYPE_LOOKUP_FAILED, (Throwable)e, ResourceType.Network.NAME.toString());
        }
    }

    public List<VIP> getVIPs(int netNumber) throws VIPException {
        String vipNetType = ResourceType.ClusterVIP.getVIPNetTypeName(netNumber);
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), vipNetType));
            Trace.out("Found " + resList.size() + " resource of " + ResourceLiterals.TYPE.name() + "=" + vipNetType + " for netNumber " + netNumber);
            ArrayList<VIP> vipList = new ArrayList<VIP>(resList.size());
            for (ResourceAttribute attr : resList) {
                try {
                    vipList.add(this.getVIP(VIPImpl.getUserAssignedName(attr.getValue())));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just removed VIP resource=" + attr.getValue());
                }
            }
            return Collections.unmodifiableList(vipList);
        }
        catch (CRSException e) {
            throw new VIPException((MessageKey)PrCrMsgID.RESTYPE_LOOKUP_FAILED, (Throwable)e, vipNetType);
        }
    }

    public List<VIP> getVIPs(String nodeName, String vipName) throws VIPException {
        int indx;
        String vipResName;
        long startTime = System.currentTimeMillis();
        String usrOraVip = ResourceType.ClusterVIP.USR_ORA_VIP.name();
        String string = vipResName = vipName == null ? "" : VIPImpl.getResourceName(vipName);
        if (nodeName != null && (indx = (nodeName = nodeName.trim()).indexOf(46)) > -1) {
            nodeName = nodeName.substring(0, indx);
        }
        LinkedList<VIPImpl> result = new LinkedList<VIPImpl>();
        InetAddress[] vipNameAddrs = new InetAddress[]{};
        boolean vipIsNodeName = false;
        Map<String, Map<String, String>> allVipsDescr = null;
        if (vipName != null) {
            try {
                ServerFactory sf = ServerFactory.getInstance();
                sf.getNode(vipName);
                vipIsNodeName = true;
            }
            catch (NodeException sf) {
            }
            catch (ServerException sf) {
                // empty catch block
            }
            if (!vipIsNodeName) {
                try {
                    vipNameAddrs = InetAddress.getAllByName(vipName);
                }
                catch (UnknownHostException e) {
                    Trace.out((Object)"No IP address for host %s could be found", vipName);
                }
            }
        }
        Trace.out("node: %s, vip %s, vipIsNodeName %b, ip list %d", nodeName, vipName, vipIsNodeName, vipNameAddrs.length);
        Filter startsWith = null;
        Filter endsWith = null;
        Filter allVipsFilter = null;
        CRSFactoryImpl crsFI = null;
        try {
            crsFI = CRSFactoryImpl.getInstance();
            startsWith = crsFI.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.TYPE.name(), "ora." + ResourceLiterals.CLUSTER_VIP.toString() + '_' + ResourceLiterals.NET.toString());
            endsWith = crsFI.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE.name(), '.' + ResourceLiterals.TYPE.toString());
            allVipsFilter = crsFI.getFilter(Filter.Operator.AND, startsWith, endsWith);
            allVipsFilter = crsFI.getFilter(Filter.Operator.AND, allVipsFilter, crsFI.getFilter(Filter.Comparator.STARTS_WITH, ResourceType.ClusterVIP.NAME.name(), "ora."));
            if (nodeName != null) {
                allVipsFilter = crsFI.getFilter(Filter.Operator.AND, allVipsFilter, crsFI.getFilter(Filter.Comparator.EQI, ResourceType.ClusterVIP.HOSTING_MEMBERS.name(), nodeName.toLowerCase()));
            }
            allVipsDescr = crsFI.searchEntities(CRSEntity.Type.Resource, false, allVipsFilter, usrOraVip);
        }
        catch (CRSException ce) {
            throw new VIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)ce, nodeName != null ? nodeName : vipName, ResourceType.ClusterVIP.NAME.toString());
        }
        block9: for (Map.Entry<String, Map<String, String>> entry : allVipsDescr.entrySet()) {
            String vName = entry.getKey();
            ResourceAttribute attr = new ResourceAttribute(ResourceType.ClusterVIP.NAME.name(), vName);
            if (vipName == null) {
                Trace.out("case 1: " + vName);
                result.add(new VIPImpl(attr));
                continue;
            }
            if (vName.equalsIgnoreCase(vipResName)) {
                Trace.out("case 2: " + vName);
                result.add(new VIPImpl(attr));
                continue;
            }
            if (vipName.equalsIgnoreCase(entry.getValue().get(usrOraVip))) {
                Trace.out("case 3: " + vName);
                result.add(new VIPImpl(attr));
                continue;
            }
            if (vipNameAddrs.length <= 0) continue;
            ArrayList vipResAddrs = new ArrayList();
            String usrOraVIPString = entry.getValue().get(usrOraVip);
            try {
                int sepIndex = usrOraVIPString.indexOf(" ");
                if (sepIndex != -1) {
                    String ipv4Value = usrOraVIPString.substring(0, sepIndex);
                    String ipv6Value = usrOraVIPString.substring(sepIndex + 1);
                    Trace.out("VIP IPv4 address is: " + ipv4Value);
                    Trace.out("VIP IPv6 address is: " + ipv6Value);
                    Collections.addAll(vipResAddrs, InetAddress.getAllByName(ipv4Value));
                    Collections.addAll(vipResAddrs, InetAddress.getAllByName(ipv6Value));
                } else {
                    Collections.addAll(vipResAddrs, InetAddress.getAllByName(usrOraVIPString));
                }
            }
            catch (UnknownHostException e) {
                Trace.out((Object)"No IP address for host %s could be found", usrOraVIPString);
                continue;
            }
            for (InetAddress resAddr : vipResAddrs) {
                Trace.out("resAddr's host address is " + resAddr.getHostAddress());
                for (InetAddress nameAddr : vipNameAddrs) {
                    Trace.out("nameAddr's host address is " + nameAddr.getHostAddress());
                    if (!resAddr.getHostAddress().equals(nameAddr.getHostAddress())) continue;
                    Trace.out("case 4: %s, addr %s", vName, resAddr.getHostAddress());
                    result.add(new VIPImpl(attr));
                    continue block9;
                }
            }
        }
        Trace.out("execution time " + (System.currentTimeMillis() - startTime));
        return Collections.unmodifiableList(result);
    }

    public List<VIP> getVIPs(String vipName, int netnum) throws VIPException {
        List<VIP> vipList;
        if (vipName == null && netnum >= 0) {
            vipList = this.getVIPs(netnum);
        } else {
            try {
                VIP vip = this.getVIP(vipName);
                vipList = new ArrayList<VIP>(1);
                if (netnum < 0 || vip.network().getNumber() == netnum) {
                    vipList.add(vip);
                }
            }
            catch (NotExistsException e) {
                vipList = new ArrayList<VIP>(0);
            }
            catch (NetworkException ne) {
                throw new VIPException(ne);
            }
        }
        return Collections.unmodifiableList(vipList);
    }

    public VIP getVIP(int netnum, String prefNode) throws VIPException, NotExistsException {
        try {
            String vipResName = null;
            vipResName = netnum == this.getDefaultNetworkNumber() ? VIPImpl.getResourceName(prefNode) : VIPImpl.getResourceName(prefNode + '_' + netnum);
            VIPImpl vipImpl = new VIPImpl(CRSFactoryImpl.getInstance().create(ResourceType.ClusterVIP.NAME.name(), vipResName));
            CRSResource crsRes = vipImpl.crsResource();
            return vipImpl;
        }
        catch (CRSException e) {
            throw new VIPException(e);
        }
        catch (SoftwareModuleException e) {
            throw new VIPException(e);
        }
    }

    public List<VIP> getVIPs(int netnum, String nodeName) throws VIPException {
        ArrayList<VIP> vipListNetnum;
        try {
            vipListNetnum = new ArrayList<VIP>();
            List<VIP> vipList = this.getConfiguredVIPs(nodeName);
            for (VIP curVIP : vipList) {
                if (curVIP.network().getNumber() != netnum) continue;
                vipListNetnum.add(curVIP);
            }
        }
        catch (NetworkException ne) {
            throw new VIPException(ne);
        }
        return Collections.unmodifiableList(vipListNetnum);
    }

    public List<VIP> getConfiguredVIPs(String nodeName) throws VIPException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter startsWith = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.TYPE.name(), "ora." + ResourceLiterals.CLUSTER_VIP.toString() + '_' + ResourceLiterals.NET.toString());
            Filter endsWith = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE.name(), '.' + ResourceLiterals.TYPE.toString());
            Filter nodeFilter = crsFactory.getFilter(Filter.Comparator.EQI, ResourceType.ClusterVIP.HOSTING_MEMBERS.name(), nodeName.toLowerCase());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, startsWith, endsWith);
            finalFilter = crsFactory.getFilter(Filter.Operator.AND, finalFilter, nodeFilter);
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.ResourceInstance, finalFilter);
            ArrayList<VIPImpl> vipList = new ArrayList<VIPImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                vipList.add(new VIPImpl(attr));
            }
            return Collections.unmodifiableList(vipList);
        }
        catch (CRSException crse) {
            Trace.out("Failed to get vips on node " + nodeName);
            throw new VIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)crse, nodeName, ResourceType.ClusterVIP.NAME.toString());
        }
    }

    public Map<String, VIP> getConfiguredVIPs(int networkNumber) throws VIPException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeStartsWithFilter = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.TYPE.name(), "ora." + ResourceLiterals.CLUSTER_VIP.toString() + '_' + ResourceLiterals.NET.toString() + networkNumber);
            Filter typeEndsWithFilter = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE.name(), '.' + ResourceLiterals.TYPE.toString());
            Filter filter = crsFactory.getFilter(Filter.Operator.AND, typeStartsWithFilter, typeEndsWithFilter);
            List<ResourceAttribute> resourceList = crsFactory.searchResources(CRSEntity.Type.ResourceInstance, filter);
            HashMap<String, VIPImpl> vipMap = new HashMap<String, VIPImpl>(resourceList.size());
            for (ResourceAttribute attr : resourceList) {
                String currNodeName;
                String resourceName = attr.getValue();
                if (!resourceName.startsWith("ora.")) continue;
                VIPImpl currVIP = new VIPImpl(attr);
                try {
                    currNodeName = currVIP.preferredNode().getHostName();
                }
                catch (NodeException ne) {
                    Trace.out("Failed to retrieve the node name for VIP \"" + currVIP.getName() + "\"");
                    throw new VIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)ne, networkNumber, ResourceType.ClusterVIP.NAME.toString());
                }
                vipMap.put(currNodeName, currVIP);
            }
            return Collections.unmodifiableMap(vipMap);
        }
        catch (CRSException crse) {
            Trace.out("Failed to get vips on network " + networkNumber);
            throw new VIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)crse, networkNumber, ResourceType.ClusterVIP.NAME.toString());
        }
    }

    public List<VIP> getVIPs(String nodeName) throws VIPException {
        return this.doGetRunningVIPs(nodeName, 0);
    }

    public List<VIP> getRunningVIPs(String nodeName) throws VIPException {
        return this.doGetRunningVIPs(nodeName, 0);
    }

    public List<VIP> getRunningVIPs(String nodeName, int netnum) throws VIPException {
        return this.doGetRunningVIPs(nodeName, netnum);
    }

    private List<VIP> doGetRunningVIPs(String nodeName, int netnum) throws VIPException {
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new VIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName");
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String filterS = "ora." + ResourceLiterals.CLUSTER_VIP.toString() + '_' + ResourceLiterals.NET.toString();
            if (netnum > 0) {
                filterS = filterS + netnum;
            }
            Filter filter1 = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.TYPE.name(), filterS.toString());
            Filter filter2 = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE.name(), '.' + ResourceLiterals.TYPE.toString());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, filter1, filter2);
            filter1 = crsFactory.getFilter(Filter.Comparator.EQI, ResourceLiterals.CRS_LAST_SERVER.toString(), nodeName);
            finalFilter = crsFactory.getFilter(Filter.Operator.AND, finalFilter, filter1);
            filter1 = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "ONLINE");
            filter2 = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "INTERMEDIATE");
            Filter stateFilter = crsFactory.getFilter(Filter.Operator.OR, filter1, filter2);
            finalFilter = crsFactory.getFilter(Filter.Operator.AND, finalFilter, stateFilter);
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.ResourceInstance, finalFilter);
            ArrayList<VIPImpl> vipList = new ArrayList<VIPImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                String resName = attr.getValue();
                if (!resName.startsWith("ora.")) continue;
                vipList.add(new VIPImpl(attr));
            }
            return Collections.unmodifiableList(vipList);
        }
        catch (CRSException e) {
            Trace.out("Failed to get vips on node " + nodeName);
            throw new VIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, nodeName, ResourceType.ClusterVIP.NAME.toString());
        }
    }

    public Endpoints createEndpoints(String pStr, String separator) throws ListenerException {
        return this.createEndpoints(pStr, separator, false);
    }

    public Endpoints createEndpoints() {
        return this.createEndpoints(false);
    }

    public Endpoints createEndpoints(String pStr, String separator, boolean isMgmtLsnr) throws ListenerException {
        return new EndpointsImpl(pStr, separator, isMgmtLsnr);
    }

    public Endpoints createEndpoints(boolean isMgmtLsnr) {
        return new EndpointsImpl(isMgmtLsnr);
    }

    public void setUpgradeModeFlags() throws CRSException {
        CRSFactoryImpl.getInstance().setUpgradeModeFlags();
    }

    public void upgradeONS11201To11202FirstPhase() throws UpgradeException {
        ONS ons = null;
        EONS eons = null;
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>(3);
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            try {
                eons = this.getEONS();
                Trace.out("Get EONS resource");
            }
            catch (NotExistsException e) {
                Trace.out("Upgrade nodeapps. EONS does not exist.");
            }
            catch (EONSException e) {
                Trace.out("Upgrade nodeapps. Got EONSException: " + e.getMessage());
                throw new UpgradeException(e);
            }
            try {
                ons = this.getONS();
                Trace.out("Get ONS resource");
            }
            catch (NotExistsException e) {
                Trace.out("Upgrade nodeapps. ONS does not exist.");
                if (Cluster.isCluster()) {
                    throw new UpgradeException(e);
                }
                Trace.out("Upgrade ONS. ONS does not exist.");
            }
            catch (ONSException e) {
                Trace.out("Upgrade nodeapps. Got ONSException: " + e.getMessage());
                throw new UpgradeException(e);
            }
            int emport = 0;
            if (eons != null) {
                try {
                    emport = ((EONSImpl)eons).getPort();
                    Trace.out("Get EMPORT: " + emport);
                }
                catch (EONSException e) {
                    Trace.out("Upgrade nodeapps. Got EONSException: " + e.getMessage());
                    throw new UpgradeException((MessageKey)PrCnMsgID.FAILED_GET_EM_PORT_IN_UPGRADE, (Throwable)e, new Object[0]);
                }
            }
            cf.upgradeType(ResourceType.ONS.class);
            attrList.add(cf.create(ResourceType.LocalResource.VERSION.name(), new Version().toString()));
            if (ons != null) {
                if (emport > 0 && emport != Integer.parseInt(ResourceLiterals.ONS_EM_PORT.toString())) {
                    attrList.add(cf.create(ResourceType.ONS.EM_PORT.name(), Integer.toString(emport)));
                }
                attrList.add(cf.create(ResourceType.ONS.USE_EVM.name(), Boolean.toString(false)));
                attrList.add(cf.create(ResourceType.LocalResource.VERSION.name(), new Version().toString()));
                CRSResourceImpl onsRes = (CRSResourceImpl)ons.crsResource();
                onsRes.update(attrList.toArray(new ResourceAttribute[attrList.size()]));
            }
        }
        catch (ONSException e) {
            throw new UpgradeException(e);
        }
        catch (NotExistsException e) {
            throw new UpgradeException(e);
        }
        catch (CRSException e) {
            throw new UpgradeException(e);
        }
    }

    public void upgradeONS11201To11202LastPhase() throws UpgradeException {
        EONS eons = null;
        ONS ons = null;
        ArrayList attrList = new ArrayList(3);
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            try {
                eons = this.getEONS();
                Trace.out("Get EONS resource");
            }
            catch (NotExistsException e) {
                Trace.out("Upgrade nodeapps. EONS does not exist.");
            }
            catch (EONSException e) {
                Trace.out("Upgrade nodeapps. Got EONSException: " + e.getMessage());
                throw new UpgradeException(e);
            }
            try {
                ons = this.getONS();
                Trace.out("Get ONS resource");
            }
            catch (NotExistsException e) {
                Trace.out("Upgrade nodeapps. ONS does not exist.");
                if (Cluster.isCluster()) {
                    throw new UpgradeException(e);
                }
                Trace.out("Upgrade ONS. ONS does not exist.");
            }
            catch (ONSException e) {
                Trace.out("Upgrade nodeapps. Got ONSException: " + e.getMessage());
                throw new UpgradeException(e);
            }
            if (ons != null) {
                ons.setUseEVM(true);
            }
            if (eons != null) {
                try {
                    eons.stop(true);
                }
                catch (AlreadyStoppedException e) {
                    Trace.out("EONS is already stopped. Not an error.");
                }
                catch (SoftwareModuleException e) {
                    Trace.out("Stopping EONS. Got SoftwareModuleException: " + e.getMessage());
                }
                try {
                    eons.remove(true);
                }
                catch (AlreadyRunningException e) {
                    Trace.out("EONS is still running when it is removed in upgrade.");
                    throw new UpgradeException((MessageKey)PrCnMsgID.FAILED_REMOVE_EONS_IN_UPGRADE, (Throwable)e, new Object[0]);
                }
                catch (EONSException e) {
                    Trace.out("Stopping EONS. Got EONSException: " + e.getMessage());
                    throw new UpgradeException((MessageKey)PrCnMsgID.FAILED_REMOVE_EONS_IN_UPGRADE, (Throwable)e, new Object[0]);
                }
            }
            try {
                EONSImpl.removeResType(true);
            }
            catch (EONSException e) {
                throw new UpgradeException((MessageKey)PrCnMsgID.FAILED_REMOVE_EONS_IN_UPGRADE, (Throwable)e, new Object[0]);
            }
        }
        catch (CRSException e) {
            throw new UpgradeException(e);
        }
        catch (ONSException e) {
            throw new UpgradeException(e);
        }
    }

    public void upgradeVIP11204To12101LastPhase() throws UpgradeException {
        try {
            boolean force = true;
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            try {
                List<Network> nwList = null;
                try {
                    nwList = this.getNetworks();
                }
                catch (NotExistsException e) {
                    Trace.out("There is no network resource. Not an error for upgrade.");
                }
                if (nwList != null) {
                    for (Network netw : nwList) {
                        int netNum = netw.getNumber();
                        if (netNum == this.getDefaultNetworkNumber()) continue;
                        List<VIP> vipList = this.getVIPs(netNum);
                        for (VIP vip_i : vipList) {
                            InetAddress vipAddress = vip_i.address();
                            String prefNode = vip_i.preferredNode().getName();
                            vip_i.remove(force);
                            Trace.out("Remove vip successful");
                            this.createVIP(netw, vipAddress, prefNode, new Version(), true);
                        }
                    }
                }
            }
            catch (VIPException e) {
                Trace.out("Upgrade VIP. Got VIPException.");
                throw new UpgradeException(e);
            }
            catch (NetworkException e) {
                Trace.out("Upgrade VIP. Got NetworkException: " + e.getMessage());
                throw new UpgradeException(e);
            }
            catch (AlreadyExistsException e) {
                throw new UpgradeException(e);
            }
            catch (NodeException e) {
                Trace.out("Upgrade VIP. Got NodeException.");
                throw new UpgradeException(e);
            }
            catch (AlreadyRunningException e) {
                Trace.out("Upgrade VIP. Got AlreadyRunningException.");
                throw new UpgradeException(e);
            }
        }
        catch (CRSException e) {
            throw new UpgradeException(e);
        }
    }

    public void upgradeMgmtLsnr12102To12201FirstPhase() throws UpgradeException {
        try {
            ListenerImpl mgmtLsnr = (ListenerImpl)this.getMgmtListener();
            Trace.out("Getting a new port for mgmt listener");
            int freePort = this.getFreePort(ListenerType.MGMT_LISTENER, true);
            Trace.out("Free port for mgmt listener: " + freePort);
            String endpStr = Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString() + ':' + Integer.toString(freePort);
            Endpoints endp = this.createEndpoints(endpStr, "/");
            mgmtLsnr.setEndpoints(endp);
            Trace.out("Mgmt listener port reconfiguration complete.");
            Trace.out("Mgmt listener dependency configuration complete.");
        }
        catch (SoftwareModuleException ex) {
            throw new UpgradeException(ex);
        }
        catch (NotExistsException ex) {
            throw new UpgradeException(ex);
        }
    }

    public void upgradeVIP12101To122LastPhase() throws UpgradeException {
        int netNum = -1;
        List<Network> netList = null;
        try {
            try {
                netList = this.getNetworks();
            }
            catch (NotExistsException e) {
                Trace.out("No network resource. Not an error for upgrade.");
            }
            if (netList != null) {
                for (Network net : netList) {
                    boolean doRemBoth = false;
                    boolean doRemIPv4 = false;
                    boolean doRemIPv6 = false;
                    Map<IPAddressUtil.IPAddrType, DHCPServerType> serverMap = net.dhcpServerTypes();
                    if (serverMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && serverMap.get((Object)IPAddressUtil.IPAddrType.IPv4).equals((Object)DHCPServerType.DHCP)) {
                        doRemIPv4 = true;
                    }
                    if (serverMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6) && serverMap.get((Object)IPAddressUtil.IPAddrType.IPv6).equals((Object)DHCPServerType.AUTOCONFIG)) {
                        if (doRemIPv4) {
                            doRemBoth = true;
                            doRemIPv4 = false;
                        } else {
                            doRemIPv6 = true;
                        }
                    }
                    Trace.out("Remove IPv4:%b, Remove IPv6:%b, Remove BOTH:%b", doRemIPv4, doRemIPv6, doRemBoth);
                    netNum = net.getNumber();
                    List<VIP> vipList = this.getVIPs(netNum);
                    for (VIP vip_i : vipList) {
                        if (doRemBoth) {
                            ((VIPImpl)vip_i).removeAddressType(IPAddressUtil.IPAddrType.BOTH);
                        }
                        if (doRemIPv4) {
                            ((VIPImpl)vip_i).removeAddressType(IPAddressUtil.IPAddrType.IPv4);
                        }
                        if (!doRemIPv6) continue;
                        ((VIPImpl)vip_i).removeAddressType(IPAddressUtil.IPAddrType.IPv6);
                    }
                }
            }
        }
        catch (NetworkException | VIPException e) {
            Trace.out("Upgrade VIP. Got Exception." + e.getMessage());
            throw new UpgradeException(e);
        }
    }

    public void assertRoot() throws SoftwareModuleException {
        boolean checkRoot;
        boolean bl = checkRoot = !Boolean.getBoolean("srvm.vip.no_root_check");
        if (checkRoot) {
            Util utl = null;
            try {
                utl = new Util();
                if (!utl.hasHAPrivilege()) {
                    throw new SoftwareModuleException((MessageKey)PrCnMsgID.NOT_PRIV_USER, utl.getCurrentUser());
                }
            }
            catch (UtilException e) {
                throw new SoftwareModuleException(e);
            }
            finally {
                if (null != utl) {
                    try {
                        utl.destroy();
                    }
                    catch (UtilException e) {
                        Trace.out((Exception)((Object)e));
                    }
                }
            }
        }
    }

    public void checkPortFree(int port) throws CompositeOperationException, ListenerException {
        this.assertPort(port);
        try {
            String[] nodeList;
            int[] portList = new int[]{port};
            ClusterUtil cu = new ClusterUtil();
            boolean isCluster = Cluster.isCluster();
            Trace.out("Is cluster: " + isCluster);
            if (isCluster) {
                nodeList = cu.getHUBNodes();
            } else {
                Trace.out("Validate on local node only");
                nodeList = new String[]{};
            }
            this.checkPortHelper(portList, nodeList);
            Trace.out("Port " + port + " is available on nodes: " + nodeList.toString());
        }
        catch (ClusterUtilException ex) {
            Trace.out("Could not get HUB nodes");
            throw new ListenerException(ex);
        }
    }

    public void checkPorts(String[] ipOrNodeList, int[] portList) throws CompositeOperationException {
        this.checkPortHelper(portList, ipOrNodeList);
    }

    public void checkPorts(int[] portList) throws CompositeOperationException {
        this.checkPortHelper(portList, new String[0]);
    }

    private void checkPortHelper(int[] portList, String ... ipOrNodeList) throws CompositeOperationException {
        StringBuilder sb = new StringBuilder();
        HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(portList.length);
        boolean compositeResult = true;
        StringBuilder nodesb = new StringBuilder();
        for (String node : ipOrNodeList) {
            if (nodesb.length() > 0) {
                nodesb.append("," + node);
                continue;
            }
            nodesb.append(node);
        }
        if (nodesb.length() == 0) {
            nodesb.append("local node");
        }
        Command[] cmdArray = new PortAvailableCommand[portList.length];
        for (int i = 0; i < portList.length; ++i) {
            cmdArray[i] = ipOrNodeList.length > 0 ? new PortAvailableCommand(ipOrNodeList, portList[i]) : new PortAvailableCommand(portList[i]);
        }
        if (cmdArray.length == 1) {
            cmdArray[0].execute();
        } else {
            ClusterCmd clusterCmd = new ClusterCmd();
            try {
                clusterCmd.submit(cmdArray);
            }
            catch (ClusterException e) {
                for (Command cmd : cmdArray) {
                    ((PortAvailableCommand)cmd).execute();
                }
            }
        }
        for (Command cmd : cmdArray) {
            CommandResult nativeResult = cmd.getCommandResult();
            int port = ((PortAvailableCommand)cmd).getPort();
            resultMap.put(String.valueOf(port), nativeResult);
            Trace.out("port=" + port + " availability status=" + nativeResult.getStatus() + " across nodeList=" + nodesb.toString());
            if (nativeResult.getStatus()) continue;
            compositeResult = false;
            if (sb.length() > 0) {
                sb.append("," + String.valueOf(port));
                continue;
            }
            sb.append(String.valueOf(port));
        }
        if (!compositeResult) {
            throw new CompositeOperationException((MessageKey)PrCnMsgID.PORTS_NOT_AVAILABLE, resultMap, sb.toString());
        }
        resultMap.clear();
        resultMap = null;
    }

    public boolean isUniqueSubnet(String subnetStr, Network networkToExclude) throws NetworkException {
        int netNumToSkip;
        List<Network> networkList;
        boolean isIPv4Subnet = IPAddressUtil.isIPv4AddressString(subnetStr);
        boolean isIPv6Subnet = IPAddressUtil.isIPv6AddressString(subnetStr);
        if (!isIPv4Subnet && !isIPv6Subnet) {
            throw new NetworkException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "check_subnet_uniqueness_error-01");
        }
        try {
            networkList = this.getNetworks();
        }
        catch (NotExistsException nee) {
            Trace.out("No network found. Hence the subnet address \"" + subnetStr + "\" is unique among the network subnets");
            return true;
        }
        int n = netNumToSkip = networkToExclude == null ? 0 : networkToExclude.getNumber();
        if (isIPv4Subnet) {
            for (Network currNetwork : networkList) {
                if (currNetwork.getNumber() == netNumToSkip) continue;
                try {
                    if (!subnetStr.equals(currNetwork.subnet().getName())) continue;
                    if (networkToExclude != null) {
                        Trace.out("The IPv4 subnet \"" + subnetStr + "\" that we want to use in network with netnum=" + netNumToSkip + " is in use by network with netnum=" + currNetwork.getNumber());
                    } else {
                        Trace.out("The IPv4 subnet \"" + subnetStr + "\"is in use by network with netnum=" + currNetwork.getNumber());
                    }
                    return false;
                }
                catch (NotExistsException notExistsException) {
                }
            }
            return true;
        }
        for (Network currNetwork : networkList) {
            if (currNetwork.getNumber() == netNumToSkip) continue;
            try {
                if (!subnetStr.equals(currNetwork.subnet_ipv6().getName())) continue;
                if (networkToExclude != null) {
                    Trace.out("The IPv6 subnet \"" + subnetStr + "\" that we want to use in network with netnum=" + netNumToSkip + " is in use by network with netnum=" + currNetwork.getNumber());
                } else {
                    Trace.out("IPv6 subnet \"" + subnetStr + "\" is in use by network with netnum=" + currNetwork.getNumber());
                }
                return false;
            }
            catch (NotExistsException notExistsException) {
            }
        }
        return true;
    }

    public int getDefaultNetworkNumber() {
        return 1;
    }

    public TreeMap<String, String> getListenerHomeNodesMap(Listener lsnr) throws ListenerException {
        TreeMap<String, String> treemap = new TreeMap<String, String>();
        boolean isCluster = Cluster.isCluster();
        if (!isCluster) {
            String localNodeName;
            try {
                localNodeName = Cluster.getHostName();
            }
            catch (ClusterException e) {
                throw new ListenerException((MessageKey)PrCtMsgID.FAILED_TO_GET_LOCAL_NODE_NAME, (Throwable)e, new Object[0]);
            }
            treemap.put(((ListenerImpl)lsnr).getOracleHome(localNodeName, isCluster), localNodeName);
        } else {
            String[] nodenames;
            try {
                nodenames = lsnr.type() == ListenerType.RIM_LISTENER ? new ClusterUtil().getRIMNodes() : new ClusterUtil().getHUBNodes();
            }
            catch (ClusterUtilException e) {
                throw new ListenerException(e);
            }
            for (String nodename : nodenames) {
                String tmphome;
                try {
                    tmphome = ((ListenerImpl)lsnr).getOracleHome(nodename, isCluster);
                    Trace.out("For %s, listener home is %s", nodename, tmphome);
                }
                catch (ListenerException e) {
                    Trace.out("Got exception: " + e.getMessage());
                    Trace.out("Skip node " + nodename);
                    tmphome = null;
                }
                if (tmphome == null) continue;
                StringBuilder nodes = new StringBuilder(nodename);
                String tmpnode = treemap.get(tmphome);
                if (tmpnode != null) {
                    nodes.append("," + tmpnode);
                    treemap.put(tmphome, nodes.toString());
                    continue;
                }
                treemap.put(tmphome, nodename);
            }
        }
        return treemap;
    }

    public String getListenerLocalHome(Listener lsnr) throws ListenerException {
        return ((ListenerImpl)lsnr).getOracleHome(null, Cluster.isCluster());
    }

    public Listener upgradeListener(String lsnrName, String oldHome, String lsnruser) throws AlreadyExistsException, ListenerException {
        try {
            String oracleHome = ResourceLiterals.CRS_HOME_VALUE.toString();
            Version version = new Version();
            Config config = new Config(oldHome, 1, null);
            String lsnrOraFilePath = null;
            int netNum = this.getDefaultNetworkNumber();
            try {
                ListenerImpl lsnr = (ListenerImpl)this.getListener(lsnrName);
                lsnrOraFilePath = ((CRSResourceImpl)lsnr.crsResource()).getEnv("TNS_ADMIN");
            }
            catch (NotExistsException nee) {
                Trace.out("Listener " + lsnrName + " not found, using default listener.ora path");
            }
            lsnrOraFilePath = lsnrOraFilePath != null && lsnrOraFilePath.trim().length() >= 0 ? lsnrOraFilePath + Constants.FILE_SEPARATOR + "listener.ora" : Constants.FILE_SEPARATOR + "network" + Constants.FILE_SEPARATOR + "admin" + Constants.FILE_SEPARATOR + "listener.ora";
            config.setFilename(3, oldHome + lsnrOraFilePath);
            List<Integer> portList = new ArrayList<Integer>();
            Endpoints ep = null;
            String endpointStr = null;
            ClusterUtil cu = new ClusterUtil();
            String lsnrCompleteName = lsnrName + '_' + cu.getLocalNodeName().toUpperCase();
            if (oracle.net.config.Listener.exists((Config)config, (String)lsnrCompleteName)) {
                Trace.out("Using listener:" + lsnrName);
                oracle.net.config.Listener lsnr = new oracle.net.config.Listener(config, lsnrCompleteName);
                Enumeration endpoints = lsnr.enumEndpoints();
                while (endpoints.hasMoreElements()) {
                    portList = this.parseSchemaConfig((SchemaObjectConfig)endpoints.nextElement(), portList);
                }
                if (portList.size() > 0) {
                    Trace.out("Ports found : " + portList.toString());
                    endpointStr = Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString() + ':';
                    for (Integer port : portList) {
                        endpointStr = endpointStr + port.toString() + "/";
                    }
                } else {
                    Trace.out("No ports found in the file, using a free default port");
                    int freePort = this.getFreePort(ListenerType.LISTENER);
                    endpointStr = Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString() + ':' + Integer.toString(freePort);
                }
            } else {
                int freePort = this.getFreePort(ListenerType.LISTENER);
                endpointStr = Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString() + ':' + Integer.toString(freePort);
            }
            Trace.out("Creating endpoint with ports:" + endpointStr);
            ep = this.createEndpoints(endpointStr, "/");
            return this.createListener(ListenerType.LISTENER, lsnrName, oracleHome, netNum, null, version, ep, true, lsnruser);
        }
        catch (ConfigException ce) {
            throw new ListenerException(ce);
        }
        catch (SoftwareModuleException sme) {
            throw new ListenerException(sme);
        }
        catch (ClusterUtilException cue) {
            throw new ListenerException(cue);
        }
        catch (CRSException crse) {
            throw new ListenerException(crse);
        }
        catch (oracle.net.config.ListenerException le) {
            throw new ListenerException(le);
        }
    }

    private List<Integer> parseSchemaConfig(SchemaObjectConfig schemaObj, List<Integer> portList) {
        switch (schemaObj.isA()) {
            case 3: {
                Vector descList = ((DescriptionListConfig)schemaObj).children;
                if (descList.isEmpty()) break;
                for (int i = 0; i < descList.size(); ++i) {
                    this.parseSchemaConfig((SchemaObjectConfig)descList.get(i), portList);
                }
                break;
            }
            case 2: {
                Vector descItemList = ((DescriptionConfig)schemaObj).children;
                if (descItemList.isEmpty()) break;
                for (int i = 0; i < descItemList.size(); ++i) {
                    this.parseSchemaConfig((SchemaObjectConfig)descItemList.get(i), portList);
                }
                break;
            }
            case 1: {
                Vector addrList = ((AddressListConfig)schemaObj).children;
                if (addrList.isEmpty()) break;
                for (int i = 0; i < addrList.size(); ++i) {
                    this.parseSchemaConfig((SchemaObjectConfig)addrList.get(i), portList);
                }
                break;
            }
            case 0: {
                Integer valueInt;
                AddressConfig addr = (AddressConfig)schemaObj;
                String prtcl = addr.getProtocol().toUpperCase();
                String value = "";
                if (!Endpoints.LsnrProtocolType.TCP_PROTOCOL.toString().equals(prtcl) || portList.contains(valueInt = new Integer(value = addr.getProtocolParam("PORT")))) break;
                portList.add(valueInt);
            }
        }
        return portList;
    }

    public int getFreePort(int startPort, int endPort) throws ListenerException {
        try {
            String[] clusterNodes = new ClusterUtil().getActiveNodes();
            return this.getFreePort(startPort, endPort, clusterNodes);
        }
        catch (ClusterUtilException cue) {
            throw new ListenerException(cue);
        }
    }

    public int getFreePort(ListenerType lsnrType) throws ListenerException {
        return this.getFreePort(lsnrType, false);
    }

    public int getFreePort(ListenerType lsnrType, boolean inPublicSubnet) throws ListenerException {
        this.assertLsnrType(lsnrType);
        try {
            int startPort = this.getPortRange(lsnrType, true);
            int endPort = this.getPortRange(lsnrType, false);
            int freePort = -1;
            if (lsnrType.equals((Object)ListenerType.RIM_LISTENER) || lsnrType.equals((Object)ListenerType.LISTENER)) {
                String[] clusterNodes = null;
                ClusterUtil cu = new ClusterUtil();
                if (lsnrType.equals((Object)ListenerType.RIM_LISTENER)) {
                    Trace.out("Looking for a free default port in leaf nodes");
                    clusterNodes = cu.getRIMNodes();
                } else if (lsnrType.equals((Object)ListenerType.LISTENER)) {
                    Trace.out("Looking for a free default port in hub nodes");
                    clusterNodes = cu.getHUBNodes();
                }
                freePort = clusterNodes.length == 0 ? startPort : this.getFreePort(startPort, endPort, true, true, true, clusterNodes);
            } else if (lsnrType == ListenerType.ASM_LISTENER) {
                boolean usePublic = Utils.isDevelopmentEnv() ? true : inPublicSubnet;
                freePort = this.getFreePort(startPort, endPort, usePublic, false, true, null);
            } else {
                freePort = lsnrType == ListenerType.MGMT_LISTENER ? this.getFreePort(startPort, endPort, true, false, true, null) : startPort;
            }
            return freePort;
        }
        catch (ClusterUtilException cue) {
            throw new ListenerException(cue);
        }
    }

    public int getFreePort(int startPort, int endPort, String[] nodeList) throws ListenerException {
        try {
            if (startPort <= 0) {
                throw new NetworkException((MessageKey)PrCnMsgID.PORT_OUT_OF_RANGE, startPort);
            }
            if (endPort <= 0) {
                throw new NetworkException((MessageKey)PrCnMsgID.PORT_OUT_OF_RANGE, endPort);
            }
            int minPort = endPort >= startPort ? startPort : endPort;
            int maxPort = endPort >= startPort ? endPort : startPort;
            int freePort = -1;
            NodeAppsFactoryImpl naf = NodeAppsFactoryImpl.getInstance();
            int[] port = new int[1];
            Trace.out("Starting free port search");
            for (int i = minPort; i <= maxPort; ++i) {
                try {
                    port[0] = i;
                    naf.checkPorts(nodeList, port);
                    Trace.out("Port " + i + " is free");
                    freePort = i;
                    break;
                }
                catch (CompositeOperationException coe) {
                    Trace.out("Port " + i + " is not free");
                    continue;
                }
            }
            return freePort;
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
    }

    private void validateLeafNW(int netNum) throws NetworkException {
        try {
            ClusterUtil cUtil = new ClusterUtil();
            if (netNum == this.getDefaultNetworkNumber()) {
                Trace.out("Cannot add leaf network on netnum" + this.getDefaultNetworkNumber());
                throw new NetworkException((MessageKey)PrCnMsgID.LEAF_DEFAULT_NETWORK_ERROR, new Object[0]);
            }
            if (cUtil.getCSSMode() != CSSMode.cssBCCLUSTERED) {
                Trace.out("Not in  Flex Cluster");
                throw new NetworkException((MessageKey)PrCnMsgID.LEAF_BIG_CLUSTER_ERROR, new Object[0]);
            }
        }
        catch (ClusterUtilException ce) {
            throw new NetworkException(ce);
        }
    }

    public boolean isPortInUse(Endpoints endpoint) throws ListenerException {
        boolean portInUse = false;
        for (int port : endpoint.getTCPPortArr()) {
            portInUse |= this.isPortInUse(port, false);
        }
        return portInUse;
    }

    private int getFreePort(int startPort, int endPort, boolean inPublicSubnet, boolean usePortAvalCmd, boolean useLsnrConfiguration, String[] nodeList) throws ListenerException {
        this.assertPort(startPort);
        this.assertPort(endPort);
        List<Integer> portList = null;
        int freePort = -1;
        if (useLsnrConfiguration) {
            Trace.out("About to query configured listeners, public subnet: " + inPublicSubnet);
            portList = inPublicSubnet ? this.getASMMgmtNodeLsnrPorts(null) : this.getASMMgmtLsnrPorts(null);
        }
        for (int i = startPort; i <= endPort; ++i) {
            boolean isCfgPortFree = true;
            boolean isCmdPortFree = true;
            if (useLsnrConfiguration && portList != null) {
                Trace.out("Checking port %d against configured listeners.", i);
                isCfgPortFree = !portList.contains(new Integer(i));
                Trace.out("Is port %d not configured for other listener resource: %s", i, isCfgPortFree);
            }
            if (usePortAvalCmd) {
                Trace.out("Checking port %d using port available command.", i);
                try {
                    if (nodeList == null) {
                        this.checkPortHelper(new int[]{i}, new String[0]);
                    } else {
                        this.checkPortHelper(new int[]{i}, nodeList);
                    }
                }
                catch (CompositeOperationException ce) {
                    isCmdPortFree = false;
                }
                Trace.out("Is port %d not being used by any other process %s", i, isCmdPortFree);
            }
            if (!isCfgPortFree || !isCmdPortFree) continue;
            freePort = i;
            break;
        }
        if (freePort == -1) {
            Trace.out("No free port in the range [" + startPort + "," + endPort + "] was found.");
            if (nodeList == null) {
                throw new ListenerException((MessageKey)PrCnMsgID.NO_DEFAULT_PORT_AVAILABLE, Integer.toString(startPort), Integer.toString(endPort));
            }
            throw new ListenerException((MessageKey)PrCnMsgID.NO_DEFAULT_PORT_AVAILABLE_IN_CLUSTER, Integer.toString(startPort), Integer.toString(endPort), Arrays.toString(nodeList).replaceAll("\\[|\\]", ""));
        }
        return freePort;
    }

    private boolean isPortInUse(int port, boolean inPublicSubnet) throws ListenerException {
        this.assertPort(port);
        List<Integer> portList = inPublicSubnet ? this.getASMMgmtNodeLsnrPorts(null) : this.getASMMgmtLsnrPorts(null);
        Trace.out("Checking port " + port);
        boolean portInUse = portList.contains(new Integer(port));
        if (portInUse) {
            Trace.out("Port " + port + " is already configured.");
        } else {
            Trace.out("Port " + port + " is available.");
        }
        return portInUse;
    }

    private List<Integer> getASMMgmtLsnrPorts(String subnetStr) throws ListenerException {
        ArrayList<ListenerType> lsnrTypeList = new ArrayList<ListenerType>();
        lsnrTypeList.add(ListenerType.ASM_LISTENER);
        lsnrTypeList.add(ListenerType.MGMT_LISTENER);
        return this.getLsnrPorts(subnetStr, lsnrTypeList);
    }

    private List<Integer> getASMMgmtNodeLsnrPorts(String subnetStr) throws ListenerException {
        ArrayList<ListenerType> lsnrTypeList = new ArrayList<ListenerType>();
        lsnrTypeList.add(ListenerType.ASM_LISTENER);
        lsnrTypeList.add(ListenerType.MGMT_LISTENER);
        lsnrTypeList.add(ListenerType.LISTENER);
        return this.getLsnrPorts(subnetStr, lsnrTypeList);
    }

    private List<Integer> getLsnrPorts(String subnetStr, List<ListenerType> lsnrTypeList) throws ListenerException {
        ArrayList<Listener> listenerList = null;
        ArrayList<Integer> portList = new ArrayList<Integer>();
        if (lsnrTypeList.contains((Object)ListenerType.ASM_LISTENER)) {
            try {
                listenerList = subnetStr != null ? new ArrayList<Listener>(this.getASMListeners(subnetStr)) : new ArrayList<Listener>(this.getASMListeners());
            }
            catch (NotExistsException nee) {
                Trace.out("No ASM listeners found");
                listenerList = new ArrayList();
            }
        }
        if (lsnrTypeList.contains((Object)ListenerType.MGMT_LISTENER)) {
            try {
                listenerList.add(this.getListener(ResourceLiterals.MGMTLSNR.toString()));
            }
            catch (NotExistsException nee) {
                Trace.out("No Mgmt listener found");
            }
        }
        if (lsnrTypeList.contains((Object)ListenerType.LISTENER)) {
            try {
                List<Listener> listeners = this.getListeners();
                for (Listener lsnr : listeners) {
                    listenerList.add(lsnr);
                }
            }
            catch (NotExistsException nee) {
                Trace.out("No listener found");
            }
        }
        for (Listener l : listenerList) {
            for (int port : l.getEndpoints().getTCPPortArr()) {
                Trace.out("Adding port " + port + " of listener " + l.getName());
                portList.add(port);
            }
        }
        return portList;
    }

    private void validateONSPorts(int localPort, int remotePort, int emPort) throws ONSException {
        Trace.out("Check that ports are not privileged");
        ArrayList<Integer> privilegedPorts = new ArrayList<Integer>(3);
        boolean isCluster = Cluster.isCluster();
        if (oracle.cluster.impl.util.Utils.isPriviledgedPort(localPort)) {
            Trace.out("Local port " + localPort + " is in privileged port range.");
            privilegedPorts.add(localPort);
        }
        if (oracle.cluster.impl.util.Utils.isPriviledgedPort(remotePort)) {
            Trace.out("Remote port " + remotePort + " is in privileged port range.");
            privilegedPorts.add(remotePort);
        }
        if (oracle.cluster.impl.util.Utils.isPriviledgedPort(emPort)) {
            Trace.out("EM port " + emPort + " is in privileged port range.");
            privilegedPorts.add(emPort);
        }
        if (privilegedPorts.size() > 0) {
            throw new ONSException((MessageKey)PrCnMsgID.INVALID_PORT_PRIVILEGED, Arrays.toString((Object[])privilegedPorts.toArray(new Integer[privilegedPorts.size()])));
        }
        try {
            if (isCluster) {
                Trace.out("Check port availability for all hub nodes");
                String[] clusterNodes = new ClusterUtil().getHUBNodes();
                this.checkPorts(clusterNodes, new int[]{localPort, remotePort, emPort});
            } else {
                Trace.out("SIHA mode, check port availability in local node");
                String[] clusterNodes = new String[]{"localnode"};
                this.checkPorts(clusterNodes, new int[]{localPort, remotePort, emPort});
            }
        }
        catch (ClusterUtilException cue) {
            throw new ONSException(cue);
        }
        catch (CompositeOperationException coe) {
            throw new ONSException(coe);
        }
    }

    public boolean validatePortConflict4Subnet(int port, String subnet) throws ListenerException {
        OIFCFGResult oifcfgResult;
        List<OIFCFGResult> oifcfgResults;
        this.assertPort(port);
        this.assertSubnet(subnet);
        String localnode = "localnode";
        Object subString = null;
        boolean isPortFree = true;
        boolean isSubnetMatch = false;
        try {
            String bindir = new Util().getCRSHome() + File.separator + "bin";
            Trace.out("Calling " + bindir + File.separator + "oifcfg for node " + localnode);
            oifcfgResults = new ClusterwareInfo().listInterfaces(localnode, bindir);
        }
        catch (UtilException e) {
            throw new ListenerException((MessageKey)PrCtMsgID.GETCRSHOME_FAIL, e.getMessage());
        }
        catch (InstallException e) {
            throw new ListenerException((MessageKey)PrCtMsgID.OIFCFG_FAIL, e.getMessage());
        }
        SubnetImpl givenSubObj = new SubnetImpl(subnet, null);
        SubnetImpl iterSubObj = null;
        String subStr = null;
        String netmaskStr = null;
        Iterator<OIFCFGResult> iterator = oifcfgResults.iterator();
        while (iterator.hasNext() && !(isSubnetMatch = ((Object)givenSubObj).equals(iterSubObj = new SubnetImpl(subStr = (oifcfgResult = iterator.next()).getSubnet().getHostAddress(), netmaskStr = oifcfgResult.getSubnetMaskAsString())))) {
        }
        if (isSubnetMatch) {
            List<Integer> portList = this.getASMMgmtLsnrPorts(subnet);
            Trace.out("Validating port " + port);
            boolean bl = isPortFree = !portList.contains(new Integer(port));
            if (isPortFree) {
                Trace.out("Port " + port + " is available.");
            } else {
                Trace.out("Port " + port + " is already configured.");
            }
        }
        return isPortFree;
    }

    public void mergeTnsNames(String srcFile, String tgtFile) throws InvalidFileException, ListenerException {
        try {
            this.assertFile(srcFile);
            this.assertFile(tgtFile, true, false, false, false);
            Config srcConfig = null;
            Config tgtConfig = null;
            List<String> srcList = null;
            List<String> tgtList = null;
            Vector endpointsVect = null;
            Service srcServ = null;
            Service tgtServ = null;
            srcConfig = new Config(srcFile, 0, null);
            tgtConfig = new Config(tgtFile, 0, null);
            srcConfig.setFilename(0, srcFile);
            tgtConfig.setFilename(0, tgtFile);
            File tgtFObj = new File(tgtFile);
            if (!tgtFObj.exists()) {
                Trace.out("Target file does not exist, copying source file...");
                tgtFObj.createNewFile();
                srcConfig.getNlpaObject().saveNLParams(tgtFile);
            } else {
                Trace.out("Merging services...");
                srcList = Arrays.asList(Service.enumServiceAliases((Config)srcConfig, null, (boolean)false));
                tgtList = Arrays.asList(Service.enumServiceAliases((Config)tgtConfig, null, (boolean)false));
                NLParamParser nlpa = srcConfig.getNlpaObject();
                for (String srv : srcList) {
                    if (tgtList.contains(srv)) continue;
                    NVPair nvp = nlpa.getNLPListElement(srv);
                    String element = nvp.getListElement(0).getName();
                    if (!element.equalsIgnoreCase(DESCRIPTION) && !element.equalsIgnoreCase(DESCRIPTION_LIST)) {
                        Trace.out((Object)"Service: %s is malformed, about to merge corrected.", srv);
                        nvp.setName(DESCRIPTION);
                        DescriptionConfig dc = new DescriptionConfig(nvp, null);
                        Vector<DescriptionConfig> endpoints = new Vector<DescriptionConfig>();
                        endpoints.addElement(dc);
                        ServiceAlias alias = new ServiceAlias(tgtConfig, srv);
                        alias.setEndpoints(endpoints);
                        alias.save(tgtConfig, false);
                        continue;
                    }
                    Trace.out((Object)"About to merge service: %s", srv);
                    srcServ = new Service(srcConfig, srv);
                    endpointsVect = new Vector(Collections.list(srcServ.enumEndpoints()));
                    tgtServ = new Service(tgtConfig, srv);
                    tgtServ.setEndpoints(endpointsVect);
                    tgtServ.save(tgtConfig, false);
                }
            }
            Trace.out("tnsnames.ora merge complete.");
        }
        catch (ConfigException ex) {
            Trace.out("Got ConfigException: " + ex.getMessage());
            throw new ListenerException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (ServiceAliasException ex) {
            Trace.out("Got ServiceAliasException: " + ex.getMessage());
            throw new ListenerException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (IOException ex) {
            Trace.out("Got IOException: " + ex.getMessage());
            throw new InvalidFileException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (SOExceptionConfig ex) {
            Trace.out("Got SOExceptionConfig: " + ex.getMessage());
            throw new InvalidFileException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
    }

    public void mergeSqlNet(String srcFile, String tgtFile, String srcOrclHome, String tgtOrclHome) throws InvalidFileException, ListenerException {
        try {
            this.assertFile(srcFile);
            this.assertFile(tgtFile, true, false, false, false);
            this.assertDirectory(srcOrclHome, true, true);
            this.assertDirectory(tgtOrclHome, true, true);
            Config srcConfig = null;
            Config tgtConfig = null;
            Profile srcServ = null;
            Profile tgtServ = null;
            srcConfig = new Config(srcFile, 0, null);
            tgtConfig = new Config(tgtFile, 0, null);
            srcConfig.setFilename(2, srcFile);
            tgtConfig.setFilename(2, tgtFile);
            File tgtFObj = new File(tgtFile);
            srcServ = new Profile(srcConfig);
            tgtServ = new Profile(tgtConfig);
            NLParamParser srcNlpa = srcConfig.getNlpa(2);
            NLParamParser tgtNlpa = null;
            if (srcServ.getParameter(WALLET_LOCATION) == null) {
                if (!tgtFObj.exists()) {
                    Trace.out("Target file does not exist, copying source file...");
                    tgtFObj.createNewFile();
                    srcNlpa.saveNLParams(tgtFile);
                }
            } else {
                if (tgtFObj.exists()) {
                    tgtNlpa = tgtConfig.getNlpa(2);
                } else {
                    tgtConfig = new Config(srcFile, 0, null);
                    tgtConfig.setFilename(2, srcFile);
                    tgtNlpa = tgtConfig.getNlpa(2);
                    tgtNlpa.removeNLPListElement(WALLET_LOCATION);
                }
                if (tgtServ.getParameter(WALLET_LOCATION) == null) {
                    NVPair nvp = srcNlpa.getNLPListElement(WALLET_LOCATION);
                    String val = nvp.getListElement(0).toString();
                    String valU = val.toUpperCase();
                    int dirIx = valU.indexOf(DIRECTORY_KEYWORD);
                    int mIx = valU.indexOf(METHOD_KEYWORD);
                    int fIx = valU.indexOf(FILE_KEYWORD);
                    if (mIx != -1 && fIx != -1 && fIx < dirIx) {
                        int bracIx = val.indexOf(41, dirIx);
                        int eqIx = val.indexOf("=", dirIx);
                        if (bracIx != -1 && eqIx != -1) {
                            String wallPath = val.substring(eqIx + 1, bracIx);
                            Trace.out("Wallet path is: " + wallPath);
                            Path ohomeP = Paths.get(srcOrclHome, new String[0]);
                            Path wallP = Paths.get(wallPath, new String[0]);
                            if (wallP.startsWith(ohomeP)) {
                                Trace.out("Wallet belongs to oracle home: " + srcOrclHome);
                                Util util = new Util();
                                ClusterCmd cCmd = new ClusterCmd();
                                String localHost = util.getLocalHostName();
                                String crsHome = util.getCRSHome();
                                Path destP = Paths.get(tgtOrclHome, new String[0]);
                                Path relPath = ohomeP.relativize(wallP);
                                String tgtPathStr = destP.resolve(relPath).toString();
                                String srcPath = wallP.toRealPath(new LinkOption[0]).toString();
                                String tmpDir = System.getProperty("java.io.tmpdir");
                                Trace.out("About to call transfer API with arguments -> ohome: %s, host: %s, srcPath: %s, tgtPath: %s, tmpDir: %s", crsHome, localHost, srcPath, tgtPathStr, tmpDir);
                                cCmd.transferDirStructureToNodes(crsHome, new String[]{localHost}, srcPath, null, null, tmpDir, new String[]{tgtPathStr});
                                String newWalStr = val.substring(0, eqIx + 1) + tgtPathStr + val.substring(bracIx);
                                Trace.out("Transfer done, updating WALLET_LOCATION parameter with: " + newWalStr);
                                nvp.setAtom(newWalStr);
                                tgtNlpa.addNLPListElement(nvp.toString());
                                tgtNlpa.saveNLParams(tgtFile);
                            } else {
                                Trace.out("Wallet directory [%s] does not belong to oracle home [%s]", wallPath, srcOrclHome);
                                if (!tgtFObj.exists()) {
                                    srcNlpa.saveNLParams(tgtFile);
                                } else {
                                    nvp.setAtom(wallPath);
                                    tgtNlpa.addNLPListElement(nvp.toString());
                                    tgtNlpa.saveNLParams(tgtFile);
                                }
                            }
                        }
                    }
                }
            }
            Trace.out("sqlnet.ora merge complete.");
        }
        catch (ConfigException | ProfileException ex) {
            Trace.out("Got Exception: " + ex.getClass().getSimpleName() + ex.getMessage());
            throw new ListenerException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, ex, srcFile, tgtFile);
        }
        catch (IOException ex) {
            Trace.out("Got IOException: " + ex.getMessage());
            throw new InvalidFileException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (NLException | ClusterException | RemoteFileOperationException | UtilException ex) {
            Trace.out("Error while copying wallet directory: " + ex.getMessage());
            throw new InvalidFileException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, ex, srcFile, tgtFile);
        }
    }

    public void mergeListenerOra(String srcFile, String tgtFile) throws InvalidFileException, ListenerException {
        try {
            this.assertFile(srcFile);
            this.assertFile(tgtFile, true, false, false, false);
            Config srcConfig = null;
            Config tgtConfig = null;
            List<String> srcList = null;
            List<String> tgtList = null;
            Object endpointsVect = null;
            Object srcLsnr = null;
            Object tgtLsnr = null;
            NLParamParser srcNlpa = null;
            NLParamParser tgtNlpa = null;
            NVPair srcNameEndp = null;
            List<Listener> lsnrList = null;
            Object lsnrObj = null;
            boolean isLsnrInCRS = false;
            srcConfig = new Config(srcFile, 0, null);
            tgtConfig = new Config(tgtFile, 0, null);
            srcConfig.setFilename(3, srcFile);
            tgtConfig.setFilename(3, tgtFile);
            srcNlpa = srcConfig.getNlpa(3);
            tgtNlpa = tgtConfig.getNlpa(3);
            File tgtFObj = new File(tgtFile);
            if (!tgtFObj.exists()) {
                Trace.out("Target file does not exist, copying source file...");
                tgtFObj.createNewFile();
                srcNlpa.saveNLParams(tgtFile);
            } else {
                Trace.out("Merging listeners...");
                srcList = Arrays.asList(oracle.net.config.Listener.enumListeners((Config)srcConfig));
                tgtList = Arrays.asList(oracle.net.config.Listener.enumListeners((Config)tgtConfig));
                lsnrList = this.getAllListeners();
                for (String lsnr : srcList) {
                    if (tgtList.contains(lsnr)) continue;
                    isLsnrInCRS = false;
                    for (Listener lsrObj : lsnrList) {
                        if (!lsrObj.getUserAssignedName().equalsIgnoreCase(lsnr)) continue;
                        isLsnrInCRS = true;
                        break;
                    }
                    if (!isLsnrInCRS) {
                        Trace.out((Object)"Listener %s is not registered in CRS", lsnr);
                        continue;
                    }
                    Trace.out((Object)"About to merge listener: %s", lsnr);
                    srcNameEndp = srcNlpa.getNLPListElement(lsnr);
                    tgtNlpa.addNLPListElement(srcNameEndp.toString());
                }
                Trace.out("Listener merge complete.");
                Trace.out("Merging listener's parameters...");
                for (String lsnr : srcList) {
                    srcNlpa.removeNLPListElement(lsnr);
                }
                srcList = Arrays.asList(srcNlpa.getNLPAllNames());
                tgtList = Arrays.asList(tgtNlpa.getNLPAllNames());
                for (String lsnrPar : srcList) {
                    if (tgtList.contains(lsnrPar)) continue;
                    Trace.out((Object)"About to merge parameter: %s", lsnrPar);
                    srcNameEndp = srcNlpa.getNLPListElement(lsnrPar);
                    tgtNlpa.addNLPListElement(srcNameEndp.toString());
                }
                tgtNlpa.saveNLParams(tgtFile);
            }
            Trace.out("listener.ora merge complete.");
        }
        catch (ConfigException ex) {
            Trace.out("Got ConfigException: " + ex.getMessage());
            throw new ListenerException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (FileNotFoundException ex) {
            Trace.out("Got FileNotFoundException: " + ex.getMessage());
            throw new InvalidFileException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (IOException ex) {
            Trace.out("Got IOException: " + ex.getMessage());
            throw new InvalidFileException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (NLException ex) {
            Trace.out("Got NLException: " + ex.getMessage());
            throw new ListenerException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
        catch (NotExistsException ex) {
            Trace.out("Got NotExistException: " + ex.getMessage());
            throw new ListenerException((MessageKey)PrCnMsgID.NETCONFIG_MERGE_ERROR, (Throwable)ex, srcFile, tgtFile);
        }
    }

    public List<Listener> getAllListeners() throws NotExistsException, ListenerException {
        try {
            Filter typeFilter = null;
            Filter finalFilter = null;
            ArrayList<ListenerImpl> lsnrList = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ListenerType[] lnsrTypes = ListenerType.values();
            if (lnsrTypes.length != 0) {
                finalFilter = crsFactory.getFilter(Filter.Comparator.EQI, ResourceLiterals.TYPE.name(), lnsrTypes[0].toString());
                for (int i = 1; i < lnsrTypes.length; ++i) {
                    typeFilter = crsFactory.getFilter(Filter.Comparator.EQI, ResourceLiterals.TYPE.name(), lnsrTypes[i].toString());
                    finalFilter = crsFactory.getFilter(Filter.Operator.OR, finalFilter, typeFilter);
                }
                Trace.out("About to query resources with filter: " + finalFilter.toString());
                List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.ResourceInstance, finalFilter);
                lsnrList = new ArrayList<ListenerImpl>(resList.size());
                for (ResourceAttribute attr : resList) {
                    lsnrList.add(new ListenerImpl(attr));
                }
            }
            if (lsnrList == null || lsnrList.isEmpty()) {
                Trace.out("Could not find any listener of any type");
                throw new NotExistsException((MessageKey)PrCnMsgID.LSNR_NOT_EXIST, new Object[0]);
            }
            return Collections.unmodifiableList(lsnrList);
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.Listener.NAME.toString());
        }
    }

    public String generateTNSAddressList(Map<String, String> hosts) throws ListenerException {
        try {
            Utils.assertInputNotNull(hosts, "hosts");
            String protocolEndpoint = "";
            new NVPair("PROTOCOL", "TCP").toString();
            String portEndpoint = "";
            String hostEndpoint = "";
            String addresses = "";
            for (Map.Entry<String, String> host : hosts.entrySet()) {
                protocolEndpoint = new NVPair("PROTOCOL", "TCP").toString();
                hostEndpoint = new NVPair("HOST", host.getKey()).toString();
                portEndpoint = new NVPair("PORT", host.getValue()).toString();
                addresses = addresses + new NVPair("ADDRESS", protocolEndpoint + hostEndpoint + portEndpoint).toString();
            }
            return new NVPair("ADDRESS_LIST", addresses).toString();
        }
        catch (InvalidSyntaxException e) {
            throw new ListenerException(e);
        }
        catch (ClusterException e) {
            throw new ListenerException(e);
        }
    }

    private void assertLsnrType(ListenerType lsnrType) throws ListenerException {
        if (lsnrType == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"lsnrType", lsnrType});
        }
    }

    private void assertLsnrName(String lsnrName) throws ListenerException {
        if (lsnrName == null || lsnrName.isEmpty()) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "lsnrName", lsnrName);
        }
    }

    private void assertOracleHome(String oracleHome) throws ListenerException {
        if (oracleHome == null || oracleHome.isEmpty()) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome", oracleHome);
        }
    }

    private void assertNetNum(int netNum) throws ListenerException {
        if (netNum < 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, NET_NUM, netNum);
        }
    }

    private void assertPort(int port) throws ListenerException {
        if (port <= 0) {
            throw new ListenerException((MessageKey)PrCnMsgID.PORT_OUT_OF_RANGE, port);
        }
    }

    private void assertGlobalNetworkClassification(GlobalNetworkClassification gnwcls) throws ListenerException {
        if (gnwcls == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "gnwcls", gnwcls);
        }
    }

    private void assertVersion(Version version) throws ListenerException {
        if (version == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
    }

    private void assertEndpoints(Endpoints endpoints) throws ListenerException {
        if (endpoints == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "endpoints", endpoints);
        }
    }

    private void assertUser(String user) throws ListenerException {
        if (user == null || user.isEmpty()) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "user", user);
        }
    }

    private void assertSubnet(String subnet) throws ListenerException {
        if (subnet == null || subnet.isEmpty()) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "subnet", subnet);
        }
    }

    private void assertFile(String filePath) throws InvalidFileException {
        this.assertFile(filePath, true, true, true, true);
    }

    private void assertFile(String filePath, boolean validateNull, boolean validateExists, boolean canRead, boolean canWrite) throws InvalidFileException {
        if (validateNull && filePath == null) {
            throw new InvalidFileException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "filepath");
        }
        File f = new File(filePath);
        if (validateExists) {
            if (!f.exists()) {
                throw new InvalidFileException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, filePath);
            }
            if (!f.isFile()) {
                throw new InvalidFileException((MessageKey)PrCfMsgID.NOT_A_FILE, filePath);
            }
        }
        if (canRead && !f.canRead()) {
            throw new InvalidFileException((MessageKey)PrChMsgID.HOME_CANNOT_READ_FILE, filePath);
        }
        if (canWrite && !f.canWrite()) {
            throw new InvalidFileException((MessageKey)PrChMsgID.CANNOT_WRITE_TO_FILE, filePath);
        }
    }

    private void assertDirectory(String dirPath, boolean validateNull, boolean validateExists) throws InvalidFileException {
        if (validateNull && dirPath == null) {
            throw new InvalidFileException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dirpath");
        }
        File f = new File(dirPath);
        if (validateExists) {
            if (!f.exists()) {
                throw new InvalidFileException((MessageKey)PrCfMsgID.DIR_NOT_EXISTS, dirPath);
            }
            if (f.isFile()) {
                throw new InvalidFileException((MessageKey)PrCfMsgID.NOT_A_DIR, dirPath);
            }
        }
    }

    private int getPortRange(ListenerType lsnrType, boolean isStartPort) {
        String tmpRet = null;
        switch (lsnrType) {
            case ASM_LISTENER: 
            case MGMT_LISTENER: 
            case RIM_LISTENER: {
                tmpRet = isStartPort ? ResourceLiterals.OTHER_LSNRS_PORT_RANGE_START.toString() : ResourceLiterals.OTHER_LSNRS_PORT_RANGE_END.toString();
                break;
            }
            case LISTENER: {
                tmpRet = isStartPort ? ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString() : ResourceLiterals.DEFAULT_LSNR_TCP_PORT_END.toString();
                break;
            }
            default: {
                Trace.out("Invalid listener type: " + lsnrType.toString());
                tmpRet = "-1";
            }
        }
        Trace.out("%s port for listener %s is %s", isStartPort ? "Start" : "End", lsnrType.toString(), tmpRet);
        return Integer.valueOf(tmpRet);
    }
}

