/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nodeapps;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASMException;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.OIFCFGUtil;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeFactory;
import oracle.cluster.home.OracleHome;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.ClusterASMImpl;
import oracle.cluster.impl.asm.IOServerImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.RTEArg;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.impl.network.GlobalNetworkClassificationImpl;
import oracle.cluster.impl.network.SubnetImpl;
import oracle.cluster.impl.nodeapps.EndpointsImpl;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.network.GlobalNetworkClassification;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.ListenerType;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NotExistsException;
import oracle.net.nl.InvalidSyntaxException;
import oracle.net.nl.NVPair;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ListenerImpl
extends SoftwareModuleImpl
implements Listener {
    private static boolean s_isCluster = Cluster.isCluster();
    private ResourceAttribute m_nameAttr;

    ListenerImpl(ResourceAttribute nameAttr) throws ListenerException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.Listener.NAME.name())) {
                throw new ListenerException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.Listener.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (!(value.length == 3 && "ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) && ResourceLiterals.LSNR.toString().equalsIgnoreCase(value[2]) || value.length == 2 && "ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) && ResourceLiterals.MGMTLSNR.toString().equalsIgnoreCase(value[1]))) {
                throw new ListenerException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Listener.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = value[1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException value) {
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    void createMgmtListener(Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        Trace.out("endpoints is " + endpoints);
        String portStr = endpoints.getTCPPortCRSValue();
        if (!skipportscheck) {
            try {
                if (NodeAppsFactoryImpl.getInstance().isPortInUse(endpoints)) {
                    throw new ListenerException((MessageKey)PrCnMsgID.ASM_MGMT_PORT_UNAVAILABLE, endpoints.getTCPPortStr());
                }
            }
            catch (SoftwareModuleException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute lsnrTypeAttr = crsFactory.create(ResourceType.MgmtListener.NAME.name(), ResourceType.MgmtListener.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(lsnrTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.MgmtListener.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.MgmtListener.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.MGMT_LSNR_RES_DESC.toString());
                    continue;
                }
                if (endpoints != null && attr.getName().equalsIgnoreCase(ResourceType.MgmtListener.ENDPOINTS.name())) {
                    attr.setValue(endpoints.toCRSValue());
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.MgmtListener.PORT.name()) || portStr == null) continue;
                attr.setValue(portStr);
            }
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            ResourcePermissionsImpl per = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.CRS_USER);
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                String owner = per.getOwner();
                try {
                    Util utl = new Util();
                    String pGroup = utl.getPrimaryGroup(owner);
                    per.setPerm(ResourceType.ACL.PGROUP, pGroup, ResourceType.ACL_PERM.READ);
                    String crsHome = utl.getCRSHome();
                    String group = utl.getOracleGroup(crsHome);
                    per.setPerm(ResourceType.ACL.GROUP, group, ResourceType.ACL_PERM.READ);
                }
                catch (UtilException e) {
                    Trace.out((Exception)((Object)e));
                    throw new ListenerException(e);
                }
            }
            per.setPerm(ResourceType.ACL.OTHER, "", ResourceType.ACL_PERM.READ);
            String acl = ResourceLiterals.ACL_ATTR.toString();
            ResourceAttribute aclAttr = new ResourceAttribute(acl, per.getAclString());
            attrList.add(aclAttr);
            this.createMgmtLsnrDepAttrs(attrList);
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    private void validateInterfaceType(GlobalNetworkClassification gnwcls, String expectedInterfaceType) throws ListenerException {
        List<OIFCFGResult> oifcfgResults;
        String oifcfgLoc;
        if (gnwcls == null || gnwcls.subNet() == null || expectedInterfaceType == null) {
            throw new ListenerException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "listener_error-01");
        }
        Subnet gnwclsSubnet = gnwcls.subNet();
        String gnwclsSubnetStr = gnwclsSubnet.getName();
        if (gnwclsSubnetStr == null || gnwclsSubnetStr.trim().length() == 0) {
            throw new ListenerException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "listener_error-02");
        }
        try {
            oifcfgLoc = new Util().getCRSHome() + File.separator + "bin";
        }
        catch (UtilException ue) {
            throw new ListenerException((MessageKey)PrCtMsgID.UNABLE_TO_VALIDATE_INTERFACE_TYPE, (Throwable)ue, gnwclsSubnetStr);
        }
        String filePathname = oifcfgLoc + File.separator + OIFCFGUtil.OIFCFGUTL;
        boolean skipCopy = false;
        try {
            skipCopy = new ClusterCmd().fileExists(filePathname);
        }
        catch (ClusterException ce) {
            Trace.out("ClusterException thrown while checking if the file \"" + filePathname + "\" exists on local node. Details:" + ce.getMessage());
            throw new ListenerException((MessageKey)PrCtMsgID.UNABLE_TO_VALIDATE_INTERFACE_TYPE, (Throwable)ce, gnwclsSubnetStr);
        }
        try {
            Trace.out("Calling " + filePathname);
            OIFCFGUtil oifcfgUtil = new OIFCFGUtil(oifcfgLoc, skipCopy, false);
            oifcfgResults = oifcfgUtil.listClusterInterfaces();
        }
        catch (CmdToolUtilException cmdtue) {
            throw new ListenerException((MessageKey)PrCtMsgID.UNABLE_TO_VALIDATE_INTERFACE_TYPE, (Throwable)cmdtue, gnwclsSubnetStr);
        }
        for (OIFCFGResult oifcfgResult : oifcfgResults) {
            String subnet = oifcfgResult.getSubnet().getHostAddress();
            String ifName = oifcfgResult.getInterfaceName();
            String ifType = oifcfgResult.getInterfaceType();
            Trace.out("Check for subnet match: subnet -->" + subnet + "  (interface name: " + ifName + ", interface type: " + ifType + ")");
            try {
                boolean subnetMatch = IPAddressUtil.sameIPAddresses(subnet, gnwclsSubnetStr);
                if (!subnetMatch || ifType.toLowerCase().indexOf(expectedInterfaceType.toLowerCase()) == -1) continue;
                return;
            }
            catch (IPAddressException ipae) {
                throw new ListenerException(ipae);
            }
        }
        throw new ListenerException((MessageKey)PrCnMsgID.LISTENER_INTERFACE_TYPE_VALIDATION_ERROR, gnwclsSubnetStr, expectedInterfaceType);
    }

    void createASMListener(Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        this.internalCreateASMListener(null, version, endpoints, skipportscheck);
    }

    void createASMListener(GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        this.assertSubnet(gnwcls);
        this.internalCreateASMListener(gnwcls, version, endpoints, skipportscheck);
    }

    private void internalCreateASMListener(GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        Trace.out("ASMListener : endpoints is " + endpoints);
        String portStr = endpoints.getTCPPortCRSValue();
        if (!skipportscheck) {
            try {
                if (NodeAppsFactoryImpl.getInstance().isPortInUse(endpoints)) {
                    throw new ListenerException((MessageKey)PrCnMsgID.ASM_MGMT_PORT_UNAVAILABLE, endpoints.getTCPPortStr());
                }
            }
            catch (SoftwareModuleException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
        }
        if (gnwcls != null) {
            this.validateASMListnerSubnet(gnwcls);
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute lsnrTypeAttr = crsFactory.create(ResourceType.ASMListener.NAME.name(), ResourceType.ASMListener.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(lsnrTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.ASMListener.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ASMListener.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.ASM_LSNR_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ASMListener.SUBNET.name()) && gnwcls != null && gnwcls.subNet() != null) {
                    attr.setValue(gnwcls.subNet().getName());
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.ASMListener.SERVER_CATEGORY.name()) || !Version.isPre12c(version)) continue;
                attr.setValue("");
            }
            String name = ResourceLiterals.NAME.toString();
            String gnsRes = "ora." + ResourceLiterals.GNS.toString();
            ResourceDependency weakDep = crsFactory.createResourceDependency(crsFactory.create(name, gnsRes), ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
            attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(weakDep)));
            if (endpoints != null) {
                attrList.add(crsFactory.create(ResourceType.Listener.ENDPOINTS.name(), endpoints.toCRSValue()));
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            Trace.out("Update dependencies in related resources for this listener");
            this.updateDependency4ASMLsnr(this.m_nameAttr, true);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException e) {
            Trace.out("CRSException encountered while updating dependencies: " + e.getMessage());
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (AlreadyExistsException aee) {
            Trace.out("AlreadyExistsException encountered while updating dependencies: " + aee.getMessage());
            throw new ListenerException((MessageKey)PrCrMsgID.DEPENDENCY_RES_NOT_EXISTS, (Throwable)aee, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException sme) {
            Trace.out("SoftwareModuleException encountered while updating dependencies: " + sme.getMessage());
            throw new ListenerException((MessageKey)PrCrMsgID.SOFTWARE_EXCEPTION, (Throwable)sme, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    void createRIMListener(GlobalNetworkClassification gnwcls, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        Trace.out("endpoints is " + endpoints);
        int[] portList = endpoints.getTCPPortArr();
        String portStr = endpoints.getTCPPortCRSValue();
        if (!skipportscheck) {
            try {
                ClusterUtil clusterUtil = new ClusterUtil();
                if (clusterUtil.getCSSMode() == CSSMode.cssBCCLUSTERED) {
                    NodeAppsFactoryImpl.getInstance().checkPorts(clusterUtil.getRIMNodes(), portList);
                }
            }
            catch (SoftwareModuleException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
            catch (ClusterUtilException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
            catch (CompositeOperationException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute lsnrTypeAttr = crsFactory.create(ResourceType.RIMListener.NAME.name(), ResourceType.RIMListener.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(lsnrTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.RIMListener.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.RIMListener.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.RIM_LSNR_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.RIMListener.SUBNET.name()) && gnwcls != null && gnwcls.subNet() != null) {
                    attr.setValue(gnwcls.subNet().getName());
                    continue;
                }
                if (endpoints == null || !attr.getName().equalsIgnoreCase(ResourceType.RIMListener.ENDPOINTS.name())) continue;
                attr.setValue(endpoints.toCRSValue());
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out("Create RIM listener " + this.m_nameAttr.getValue() + " successfully");
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    void create(String oracleHome, int netNum, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        this.create(oracleHome, netNum, version, endpoints, skipportscheck, null);
    }

    void create(String oracleHome, int netNum, Version version, Endpoints endpoints, boolean skipportscheck, String user) throws AlreadyExistsException, ListenerException {
        this.create(oracleHome, netNum, version, endpoints, skipportscheck, user, null);
    }

    void create(String oracleHome, int netNum, Version version, Endpoints endpoints, boolean skipportscheck, String user, String group) throws AlreadyExistsException, ListenerException {
        Trace.out("endpoints is " + endpoints);
        int[] portList = endpoints.getTCPPortArr();
        String portStr = endpoints.getTCPPortCRSValue();
        if (!skipportscheck) {
            try {
                String[] vipNames = this.getVIPNames(netNum);
                if (vipNames.length > 0) {
                    NodeAppsFactoryImpl.getInstance().checkPorts(vipNames, portList);
                }
                Trace.out("CheckPorts completed for VIPs");
                NodeAppsFactoryImpl.getInstance().checkPorts(portList);
                Trace.out("CheckPorts completed for local host");
            }
            catch (SoftwareModuleException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
            catch (CompositeOperationException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
        }
        try {
            NodeAppsFactoryImpl naf = NodeAppsFactoryImpl.getInstance();
            Network netw = naf.getNetwork(String.valueOf(netNum));
            if (netw.isLeafNW()) {
                throw new ListenerException((MessageKey)PrCsMsgID.ADD_RESOURCE_ON_LEAF_NETWORK_ERROR, netw.getNumber());
            }
            if (!endpoints.isFirewallConfigured() && group != null) {
                throw new ListenerException((MessageKey)PrCnMsgID.LISTENER_GROUP_ERROR, new Object[0]);
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(netNum)));
            ResourceAttribute vipNetAttr = crsFactory.create(ResourceType.ClusterVIP.NAME.name(), ResourceType.ClusterVIP.getVIPNetTypeName(netNum));
            ResourceAttribute lsnrTypeAttr = crsFactory.create(ResourceType.Listener.NAME.name(), ResourceType.Listener.NAME.toString());
            if (!crsFactory.isRegistered(netAttr.getValue(), CRSEntity.Type.Resource)) {
                throw new ListenerException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, netAttr.getValue());
            }
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(lsnrTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            String ohome = oracleHome != null ? this.getOracleHomeVal(oracleHome) : null;
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.Listener.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                } else if (attr.getName().equalsIgnoreCase(ResourceType.Listener.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.LSNR_RES_DESC.toString());
                } else if (attr.getName().equalsIgnoreCase(ResourceType.Listener.ORACLE_HOME.name())) {
                    if (ohome != null) {
                        attr.setValue(ohome);
                    }
                } else if (attr.getName().equalsIgnoreCase(ResourceType.Listener.ACTION_SCRIPT.name())) {
                    if (ohome != null) {
                        String value = attr.getValue();
                        int index = value.lastIndexOf(ResourceLiterals.PATHSEP.toString());
                        attr.setValue(ohome + ResourceLiterals.PATHSEP.toString() + "bin" + value.substring(index));
                    }
                } else if (endpoints != null && attr.getName().equalsIgnoreCase(ResourceType.Listener.ENDPOINTS.name())) {
                    attr.setValue(endpoints.toCRSValue());
                } else if (attr.getName().equalsIgnoreCase(ResourceType.Listener.LOCAL_REGISTRATION_ADDRESS.name()) && endpoints.isFirewallConfigured()) {
                    if (group != null) {
                        attr.setValue(ResourceLiterals.GROUP.toString() + ":" + group.trim());
                    } else {
                        attr.setValue("ON");
                    }
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.ScanListener.PORT.name()) || portStr == null) continue;
                attr.setValue(portStr);
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            attrList.add(crsFactory.create(ResourceType.LocalResource.ALIAS_NAME.name(), ListenerImpl.getAliasName(this.getUserAssignedName())));
            ArrayList<ResourceDependency> startList = new ArrayList<ResourceDependency>();
            ArrayList<ResourceDependency> stopList = new ArrayList<ResourceDependency>();
            if (oracleHome != null) {
                try {
                    Trace.out("Checking for Oracle home resource existance for path " + oracleHome);
                    OracleHome oh = HomeFactory.getInstance().getOracleHomeByPath(oracleHome);
                    ResourceAttribute ohRes = crsFactory.create(ResourceType.Home.NAME.name(), oh.getName());
                    startList.add(crsFactory.createResourceDependency(ohRes, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
                    startList.add(crsFactory.createResourceDependency(ohRes, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]));
                    stopList.add(crsFactory.createResourceDependency(ohRes, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
                }
                catch (NotExistsException nee) {
                    Trace.out("No Oracle home resource for ORACLE_HOME " + oracleHome + ", do not create dependencies");
                }
            }
            ResourceDependency hardDep = crsFactory.createResourceDependency(vipNetAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            startList.add(hardDep);
            ResourceDependency pullDep = crsFactory.createResourceDependency(vipNetAttr, ResourceDependency.DepType.PULLUP_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            startList.add(pullDep);
            attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(startList.toArray(new ResourceDependency[startList.size()]))));
            stopList.add(crsFactory.createResourceDependency(vipNetAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP));
            attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(stopList.toArray(new ResourceDependency[stopList.size()]))));
            if (!Cluster.isCluster() && oracleHome != null && !oracleHome.equals("%CRS_HOME%")) {
                String crsHome = new Util().getCRSHome();
                File crshomedir = new File(crsHome);
                String crshomedirstr = crshomedir.getCanonicalPath();
                File oraclehomedir = new File(oracleHome);
                String oraclehomedirstr = oraclehomedir.getCanonicalPath();
                Trace.out("crshome is " + crshomedirstr);
                Trace.out("oraclehome is " + oraclehomedirstr);
                if (!crshomedirstr.equals(oraclehomedirstr)) {
                    attrList.add(crsFactory.createSIHAResourceACL());
                }
            }
            Util utl = new Util();
            if (user != null) {
                boolean userValid = user.trim().length() > 0 ? utl.isUserValid(user) : false;
                Trace.out("checking for user" + user + " validity");
                if (!userValid) {
                    throw new ListenerException((MessageKey)PrCnMsgID.INVALID_USER, user);
                }
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            if (user != null) {
                HashMap<String, String> env = new HashMap<String, String>(1);
                String listenerOraPath = ohome + Constants.LSNR_ORA_PATH + user;
                env.put("TNS_ADMIN", listenerOraPath);
                this.m_crsResource.setEnv(env);
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                Trace.out("Setting user " + user + " permissions");
                perm.setPerm(ResourceType.ACL.OWNER, user, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
                if (new SystemFactory().CreateSystem().isUnixSystem()) {
                    Trace.out("Setting crs user permissions");
                    String crsuser = utl.getCRSUser();
                    String crsgrp = utl.getPrimaryGroup(crsuser);
                    Trace.out("Setting crs group permissions");
                    perm.setPerm(ResourceType.ACL.GROUP, crsgrp, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
                    if (ohome.equals(ResourceLiterals.CRS_HOME_VALUE.toString())) {
                        ohome = utl.getCRSHome();
                    }
                    String prigrp = utl.getOracleGroup(ohome);
                    Trace.out("Setting group permissions");
                    perm.setPerm(ResourceType.ACL.PGROUP, prigrp, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
                    Trace.out("Setting crs user permissions");
                    perm.setPerm(ResourceType.ACL.USER, crsuser, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
                }
                this.m_crsResource.setPermissions(perm);
            }
            this.updateDependency4Lsnr(this.m_nameAttr, true);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (IOException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (UtilException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws ListenerException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                perm.ntgrantOraGridLsnrPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    private String[] getVIPNames(int netNum) throws ListenerException {
        try {
            boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
            List<VIP> vipList = NodeAppsFactoryImpl.getInstance().getVIPs(netNum);
            ArrayList<String> nameList = new ArrayList<String>(2 * vipList.size());
            for (VIP vip : vipList) {
                try {
                    String nm;
                    if (!vip.isRunning()) continue;
                    Map<IPAddressUtil.IPAddrType, InetAddress> addressMap = vip.addresses();
                    if (addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                        nm = isUnix ? addressMap.get((Object)IPAddressUtil.IPAddrType.IPv4).getHostName() : addressMap.get((Object)IPAddressUtil.IPAddrType.IPv4).getHostAddress();
                        Trace.out("IPv4-name=" + nm);
                        nameList.add(nm);
                    }
                    if (!addressMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) continue;
                    nm = isUnix ? addressMap.get((Object)IPAddressUtil.IPAddrType.IPv6).getHostName() : addressMap.get((Object)IPAddressUtil.IPAddrType.IPv6).getHostAddress();
                    Trace.out("IPv6-name=" + nm);
                    nameList.add(nm);
                }
                catch (SoftwareModuleException e) {
                    throw new ListenerException(e);
                }
            }
            String[] names = new String[nameList.size()];
            nameList.toArray(names);
            return names;
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
    }

    void create(String oracleHome, Version version, Endpoints endpoints, boolean skipportscheck) throws AlreadyExistsException, ListenerException {
        int[] portList = endpoints.getTCPPortArr();
        String portStr = endpoints.getTCPPortCRSValue();
        if (!skipportscheck) {
            try {
                NodeAppsFactoryImpl.getInstance().checkPorts(portList);
            }
            catch (SoftwareModuleException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
            catch (CompositeOperationException e) {
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute lsnrTypeAttr = crsFactory.create(ResourceType.Listener.NAME.name(), ResourceType.Listener.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(lsnrTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.Listener.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                } else if (oracleHome != null && attr.getName().equalsIgnoreCase(ResourceType.Listener.ORACLE_HOME.name())) {
                    attr.setValue(this.getOracleHomeVal(oracleHome));
                } else if (endpoints != null && attr.getName().equalsIgnoreCase(ResourceType.Listener.ENDPOINTS.name())) {
                    attr.setValue(endpoints.toCRSValue());
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.Listener.PORT.name()) || portStr == null) continue;
                attr.setValue(portStr);
            }
            if (oracleHome != null) {
                try {
                    ArrayList<ResourceDependency> startList = new ArrayList<ResourceDependency>();
                    ArrayList<ResourceDependency> stopList = new ArrayList<ResourceDependency>();
                    Trace.out("Checking for Oracle home resource existance for path " + oracleHome);
                    OracleHome oh = HomeFactory.getInstance().getOracleHomeByPath(oracleHome);
                    ResourceAttribute ohRes = crsFactory.create(ResourceType.Home.NAME.name(), oh.getName());
                    startList.add(crsFactory.createResourceDependency(ohRes, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
                    startList.add(crsFactory.createResourceDependency(ohRes, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]));
                    stopList.add(crsFactory.createResourceDependency(ohRes, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
                    attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(startList.toArray(new ResourceDependency[startList.size()]))));
                    attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(stopList.toArray(new ResourceDependency[stopList.size()]))));
                }
                catch (NotExistsException nee) {
                    Trace.out("No Oracle home resource for ORACLE_HOME " + oracleHome + ", do not create dependencies");
                }
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            if (!Cluster.isCluster()) {
                attrList.add(crsFactory.createSIHAResourceACL());
            }
            Trace.out("Creating " + (Object)((Object)CRSEntity.Type.Resource));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            this.updateDependency4Lsnr(this.m_nameAttr, true);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException sme) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)sme, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public String getOracleHome() throws ListenerException {
        String ohome;
        try {
            Trace.out("m_crsResource = " + this.m_crsResource);
            ohome = this.m_crsResource.getAttribute(ResourceType.Listener.ORACLE_HOME.name()).getValue();
            if (ohome.equals("%CRS_HOME%") && !s_isCluster) {
                ohome = this.getOracleHome(null, false);
            }
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.GET_ORAHOME_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        return ohome;
    }

    @Override
    public String getOracleHome(Node node) throws NotExistsException, ListenerException {
        String nodeName;
        if (node == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        try {
            nodeName = node.getName();
        }
        catch (NodeException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.GET_ORAHOME_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        return this.getOracleHome(nodeName, s_isCluster);
    }

    @Override
    public ListenerType type() throws ListenerException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceLiterals.TYPE.name());
            Trace.out("Resource type is " + attr.getValue());
            ListenerType lsnrtype = ListenerType.getEnumMember(attr.getValue());
            return lsnrtype;
        }
        catch (EnumConstNotFoundException e) {
            throw new ListenerException(e);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    String getOracleHome(String nodeName, boolean isCluster) throws ListenerException {
        String localNodeName = null;
        String thisNodeName = nodeName;
        try {
            if (nodeName == null && this.type() == ListenerType.MGMT_LISTENER) {
                ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.MgmtListener.ORACLE_HOME.name());
                return attr.getValue();
            }
            if (!isCluster || nodeName == null) {
                try {
                    localNodeName = Utils.isDevelopmentEnv() ? Cluster.getLocalNode() : Cluster.getHostName();
                }
                catch (ClusterException e) {
                    throw new ListenerException((MessageKey)PrCtMsgID.FAILED_TO_GET_LOCAL_NODE_NAME, (Throwable)e, new Object[0]);
                }
                if (nodeName != null && !nodeName.equals(localNodeName)) {
                    throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "SIHA nodeName", nodeName);
                }
            }
            thisNodeName = nodeName != null ? nodeName : localNodeName;
            List<ResourceAttribute> attrlist = this.m_crsResource.getCurrentAttributes(thisNodeName, ResourceType.Listener.ORACLE_HOME.name());
            String ohome = attrlist.get(0).getValue();
            return ohome;
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.GET_ORAHOME_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setOracleHome(String oracleHome) throws ListenerException {
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome", oracleHome);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Listener.ORACLE_HOME.name(), this.getOracleHomeVal(oracleHome)));
            this.updateOHResDependency(oracleHome);
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.SET_ORAHOME_FAILED, (Throwable)e, oracleHome, this.getUserAssignedName());
        }
    }

    @Override
    public void setOracleHome(Node node, String oracleHome) throws ListenerException {
        String nodeName;
        if (node == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome", oracleHome);
        }
        try {
            nodeName = node.getName();
        }
        catch (NodeException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.SET_ORAHOME_FAILED, (Throwable)e, oracleHome, this.getUserAssignedName());
        }
        try {
            String attrName = ResourceType.getPerXName(ResourceType.Listener.ORACLE_HOME.name(), nodeName);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(attrName, oracleHome));
            this.updateOHResDependency(oracleHome);
        }
        catch (CRSException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.SET_PERX_ORAHOME_FAILED, (Throwable)e, oracleHome, this.getUserAssignedName(), this.getOracleHomeVal(nodeName));
        }
    }

    @Override
    @Deprecated
    public int[] getPorts() throws ListenerException {
        return this.getEndpoints().getTCPPortArr();
    }

    @Override
    public Endpoints getEndpoints() throws ListenerException {
        return this.getEndpoints(null);
    }

    @Override
    public String getGroup() throws ListenerException {
        String retVal = "";
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Listener.LOCAL_REGISTRATION_ADDRESS.name());
            String tmpStr = attr.getValue();
            Endpoints ep = this.getEndpoints();
            if (ep.isFirewallConfigured() && tmpStr != null && !tmpStr.isEmpty()) {
                Trace.out((Object)"LOCAL_REGISTRATION_ADDRESS value: %s", tmpStr);
                String[] tmpStrArr = tmpStr.split(":");
                retVal = tmpStrArr.length > 1 ? tmpStrArr[1] : this.m_crsResource.getPermissions().getGroup();
            }
        }
        catch (CRSException crse) {
            throw new ListenerException(crse);
        }
        return retVal;
    }

    @Override
    public void setGroup(String group) throws ListenerException {
        this.assertGroup(group);
        try {
            Endpoints ep = this.getEndpoints();
            if (!ep.isFirewallConfigured()) {
                throw new ListenerException((MessageKey)PrCnMsgID.LISTENER_GROUP_ERROR, new Object[0]);
            }
            String val = group.isEmpty() ? "ON" : ResourceLiterals.GROUP.toString() + ":" + group.trim();
            Trace.out((Object)"New LOCAL_REGISTRATION_ADDRESS is: %s", val);
            ResourceAttribute lraAttr = CRSFactoryImpl.getInstance().create(ResourceType.Listener.LOCAL_REGISTRATION_ADDRESS.name(), val);
            this.m_crsResource.update(lraAttr);
        }
        catch (CRSException crse) {
            throw new ListenerException(crse);
        }
    }

    @Override
    public void setEndpoints(Endpoints endpoints) throws ListenerException {
        this.assertEndpoints(endpoints);
        try {
            this.setEndpoints(endpoints, null, true, null);
        }
        catch (CompositeOperationException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public void setEndpoints(Endpoints endpoints, String group) throws ListenerException {
        this.assertEndpoints(endpoints);
        this.assertGroup(group);
        try {
            this.setEndpoints(endpoints, null, true, group);
        }
        catch (CompositeOperationException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    @Deprecated
    public void setPorts(int[] ports) throws CompositeOperationException, ListenerException {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < ports.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(" " + String.valueOf(ports[i]));
                    continue;
                }
                sb.append(String.valueOf(ports[i]));
            }
            Endpoints endp = NodeAppsFactoryImpl.getInstance().createEndpoints(sb.toString(), " ");
            this.setEndpoints(endp, null, false, null);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.SET_PORT_FAILED, (Throwable)e, sb.toString(), this.getUserAssignedName());
        }
    }

    @Override
    public int[] getPorts(Node node) throws NotExistsException, ListenerException {
        return this.getEndpoints().getTCPPortArr();
    }

    @Override
    public void setPorts(Node node, int[] ports) throws CompositeOperationException, ListenerException {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < ports.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(" " + String.valueOf(ports[i]));
                    continue;
                }
                sb.append(String.valueOf(ports[i]));
            }
            Endpoints endp = NodeAppsFactoryImpl.getInstance().createEndpoints(sb.toString(), " ");
            this.setEndpoints(endp, node, false, null);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.SET_PORT_FAILED, (Throwable)e, sb.toString(), this.getUserAssignedName());
        }
    }

    @Override
    public Subnet subnet() throws ListenerException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ASMListener.SUBNET.name());
            Trace.out("Listener subnet is " + attr.getValue());
            return new SubnetImpl(attr.getValue(), null);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public Network network() throws ListenerException {
        try {
            if (!s_isCluster) {
                throw new ListenerException((MessageKey)PrCrMsgID.NOT_ORCL_CLUSTER, this.m_nameAttr.getValue());
            }
            return NodeAppsFactoryImpl.getInstance().getNetwork(this.m_crsResource);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public void setNetwork(Network network) throws ListenerException {
        if (network == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "network");
        }
        try {
            if (network.isLeafNW()) {
                throw new ListenerException((MessageKey)PrCsMsgID.MODIFY_RESOURCE_ON_LEAF_NETWORK_ERROR, network.getNumber());
            }
            if (!s_isCluster) {
                throw new ListenerException((MessageKey)PrCrMsgID.NOT_ORCL_CLUSTER, this.m_nameAttr.getValue());
            }
            Network nt = this.network();
            String curvipnettype = ResourceType.ClusterVIP.getVIPNetTypeName(nt.getNumber());
            String newvipnettype = ResourceType.ClusterVIP.getVIPNetTypeName(network.getNumber());
            Trace.out("current vipnettype is + " + curvipnettype + ", new vipnettype is " + newvipnettype);
            ResourceAttribute attrStartDep = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            Trace.out("current value=" + attrStartDep.getValue());
            attrStartDep.setValue(attrStartDep.getValue().replaceAll(curvipnettype, newvipnettype));
            Trace.out("new value=" + attrStartDep.getValue());
            this.m_crsResource.update(attrStartDep);
            ResourceAttribute attrStopDep = this.m_crsResource.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
            Trace.out("current value=" + attrStopDep.getValue());
            attrStopDep.setValue(attrStopDep.getValue().replaceAll(curvipnettype, newvipnettype));
            Trace.out("new value=" + attrStopDep.getValue());
            this.m_crsResource.update(attrStopDep);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (NetworkException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public void setOwner(String ouser) throws ListenerException {
        block6: {
            try {
                if (this.type() == ListenerType.LISTENER) {
                    Util utl = new Util();
                    ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                    perm.setOwner(ouser);
                    if (new SystemFactory().CreateSystem().isUnixSystem()) {
                        Trace.out("Setting crs user permissions");
                        String crsuser = utl.getCRSUser();
                        String crsgrp = utl.getPrimaryGroup(crsuser);
                        Trace.out("Setting crs group permissions");
                        perm.setPerm(ResourceType.ACL.GROUP, crsgrp, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
                        String ohome = this.getOracleHome();
                        if (ohome.equals(ResourceLiterals.CRS_HOME_VALUE.toString())) {
                            ohome = utl.getCRSHome();
                        }
                        String prigrp = utl.getOracleGroup(ohome);
                        Trace.out("Setting group permissions");
                        perm.setPerm(ResourceType.ACL.PGROUP, prigrp, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
                        Trace.out("Setting crs user permissions");
                        perm.setPerm(ResourceType.ACL.USER, crsuser, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
                        this.m_crsResource.setPermissions(perm);
                    }
                    break block6;
                }
                throw new ListenerException((MessageKey)PrCnMsgID.LSNR_INVALID_MOD_USER, new Object[0]);
            }
            catch (CRSException e) {
                throw new ListenerException(e);
            }
            catch (UtilException e) {
                throw new ListenerException(e);
            }
        }
    }

    @Override
    public String getOwner() throws ListenerException {
        try {
            ResourcePermissions perm = this.m_crsResource.getPermissions();
            return perm.getOwner();
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public void setSubnet(String subnet) throws ListenerException {
        block4: {
            GlobalNetworkClassificationImpl gnwcl = new GlobalNetworkClassificationImpl(subnet, null, null);
            this.assertSubnet(gnwcl);
            this.validateASMListnerSubnet(gnwcl);
            try {
                if (this.type() == ListenerType.ASM_LISTENER) {
                    ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ASMListener.SUBNET.name());
                    attr.setValue(subnet);
                    break block4;
                }
                if (this.type() == ListenerType.RIM_LISTENER) {
                    ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.RIMListener.SUBNET.name());
                    attr.setValue(subnet);
                    break block4;
                }
                throw new ListenerException((MessageKey)PrCnMsgID.SET_GET_SUBNET_NOT_VALID, new Object[0]);
            }
            catch (CRSException e) {
                throw new ListenerException(e);
            }
        }
    }

    @Override
    public String getSubnet() throws ListenerException {
        try {
            if (this.type() == ListenerType.ASM_LISTENER) {
                ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ASMListener.SUBNET.name());
                return attr.getValue();
            }
            if (this.type() == ListenerType.RIM_LISTENER) {
                ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.RIMListener.SUBNET.name());
                return attr.getValue();
            }
            throw new ListenerException((MessageKey)PrCnMsgID.SET_GET_SUBNET_NOT_VALID, new Object[0]);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public List<VIP> vips(Node node) throws NotExistsException, ListenerException {
        if (!s_isCluster) {
            throw new ListenerException((MessageKey)PrCrMsgID.NOT_ORCL_CLUSTER, this.m_nameAttr.getValue());
        }
        throw new NotExistsException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, this.m_nameAttr.getValue(), "NOT IMPLEMENTED YET");
    }

    @Override
    public void enable(Node node) throws SoftwareModuleException, AlreadyEnabledException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            this.enable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public void disable(Node node) throws AlreadyDisabledException, SoftwareModuleException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            this.disable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public List<String> services(Node node) throws ListenerException {
        throw new ListenerException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, this.m_nameAttr.getValue(), "NOT IMPLEMENTED YET");
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, ListenerException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void updateRemove(boolean force) throws AlreadyRunningException, ListenerException {
        this.removeInternal(force, true);
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ListenerException {
        if (force && this.isASMListener()) {
            throw new ListenerException((MessageKey)PrCnMsgID.REMOVE_ASMLSNR_FAILED, this.getUserAssignedName());
        }
        if (this.type() == ListenerType.LISTENER) {
            this.removeInternal(force, true);
        } else {
            this.removeInternal(force, false);
        }
    }

    private void removeInternal(boolean force, boolean isUpdate) throws AlreadyRunningException, ListenerException {
        boolean status = false;
        try {
            ListenerType listenerType = this.type();
            if (isUpdate) {
                if (listenerType == ListenerType.ASM_LISTENER) {
                    this.updateDependency4ASMLsnr(this.m_nameAttr, false);
                } else if (listenerType == ListenerType.LISTENER) {
                    boolean isDefaultLsnr = false;
                    if (s_isCluster) {
                        boolean bl = isDefaultLsnr = this.network().getNumber() == 1;
                    }
                    if (!s_isCluster || isDefaultLsnr) {
                        this.updateDependency4Lsnr(this.m_nameAttr, false);
                    }
                }
            }
            super.remove(force);
            status = true;
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (AlreadyExistsException e) {
            throw new ListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
        finally {
            if (isUpdate && !status) {
                try {
                    ListenerType listenerType = this.type();
                    if (listenerType == ListenerType.ASM_LISTENER) {
                        this.updateDependency4ASMLsnr(this.m_nameAttr, true);
                    } else if (listenerType == ListenerType.LISTENER) {
                        this.updateDependency4Lsnr(this.m_nameAttr, true);
                    }
                }
                catch (CRSException e) {
                    throw new ListenerException(e);
                }
                catch (AlreadyExistsException e) {
                    throw new ListenerException(e);
                }
                catch (SoftwareModuleException e) {
                    throw new ListenerException(e);
                }
            }
        }
    }

    public static String getResourceName(String lsnrName) {
        return ListenerImpl.getResourceName(ListenerType.LISTENER, lsnrName);
    }

    public static String getResourceName(ListenerType lsnrType, String lsnrName) {
        String lname = ListenerImpl.getListenerName(lsnrType, lsnrName);
        String resName = lname.equalsIgnoreCase(ResourceLiterals.MGMTLSNR.toString()) ? "ora." + lname : "ora." + lname + ".lsnr";
        Trace.out("Get listener resource name " + resName);
        return resName;
    }

    public static String getListenerName(ListenerType lsnrType, String lsnrName) {
        String tlsnrName;
        if (lsnrName == null || lsnrName.trim().length() == 0) {
            tlsnrName = lsnrType == ListenerType.ASM_LISTENER ? ResourceLiterals.LISTENER.toString() + '_' + ResourceLiterals.ASM.toString() : (lsnrType == ListenerType.RIM_LISTENER ? ResourceLiterals.LISTENER.toString() + '_' + ResourceLiterals.RIM_SUFFIX.toString() : (lsnrType == ListenerType.MGMT_LISTENER ? ResourceLiterals.MGMTLSNR.toString() : ResourceLiterals.LISTENER.toString()));
        } else {
            tlsnrName = lsnrName;
            if (lsnrType == ListenerType.ASM_LISTENER && !tlsnrName.toLowerCase().endsWith('_' + ResourceLiterals.ASM.toString())) {
                tlsnrName = lsnrName + '_' + (Object)((Object)ResourceLiterals.ASM);
            } else if (lsnrType == ListenerType.RIM_LISTENER && !tlsnrName.toLowerCase().endsWith('_' + ResourceLiterals.RIM_SUFFIX.toString())) {
                tlsnrName = lsnrName + '_' + (Object)((Object)ResourceLiterals.RIM_SUFFIX);
            }
        }
        return tlsnrName.toUpperCase();
    }

    public static String getAliasName(String lsnrName) {
        return s_isCluster ? "ora." + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENAME_LOWER_CASE.toString() + ResourceLiterals.PERCENT.toString() + '.' + lsnrName.toUpperCase() + '_' + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENAME_UPPER_CASE.toString() + ResourceLiterals.PERCENT.toString() + ".lsnr" : "";
    }

    public static String getUserAssignedName(String lsnrresName) throws ListenerException {
        String[] values = lsnrresName.split(Pattern.quote(String.valueOf('.')));
        if (values.length == 2 && "ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) && ResourceLiterals.MGMTLSNR.toString().equalsIgnoreCase(values[1])) {
            return values[1];
        }
        if (values.length != 3 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.LSNR.toString().equalsIgnoreCase(values[2])) {
            throw new ListenerException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Listener.NAME.name(), lsnrresName);
        }
        return values[1];
    }

    private String getOracleHomeVal(String ohome) throws ListenerException {
        try {
            String testorclhome = System.getenv("TEST_ORCL_HOME");
            if (testorclhome != null && testorclhome.equalsIgnoreCase("true")) {
                return ohome;
            }
            boolean isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
            String defaulthome = ResourceType.Listener.ORACLE_HOME.toString();
            if (ohome.equals(defaulthome)) {
                return defaulthome;
            }
            File oraclehomedir = new File(ohome);
            String crsHome = new Util().getCRSHome();
            File crshomedir = new File(crsHome);
            String crshomedirstr = crshomedir.getCanonicalPath();
            String oraclehomedirstr = oraclehomedir.getCanonicalPath();
            Trace.out("crshome is " + crshomedirstr);
            Trace.out("oraclehome is " + oraclehomedirstr);
            if (crshomedirstr.equals(oraclehomedirstr)) {
                return defaulthome;
            }
            if (!isUnixSystem) {
                Trace.out("Check whether the home contains crsctl binary");
                File oraclehomebin = new File(ohome + File.separator + "bin");
                File[] files = oraclehomebin.listFiles();
                if (files != null) {
                    for (File file : files) {
                        Trace.out("Get the file in oraclehomebin: " + file.getName());
                        if (!file.getName().equalsIgnoreCase("crsctl.exe")) continue;
                        Trace.out("Find crsctl file: " + file.getName());
                        return defaulthome;
                    }
                }
            }
            return ohome;
        }
        catch (UtilException ue) {
            throw new ListenerException(ue);
        }
        catch (IOException e) {
            throw new ListenerException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEndpoints(Endpoints endpoints, Node node, boolean skipportscheck, String group) throws ListenerException, CompositeOperationException {
        Trace.out("endpoints is " + endpoints);
        int[] portList = endpoints.getTCPPortArr();
        ListenerType ltype = this.type();
        if (endpoints.isFirewallConfigured() && ltype != ListenerType.LISTENER) {
            throw new ListenerException((MessageKey)PrCnMsgID.FIREWALL_LISTENER_ERROR, this.type().toString());
        }
        if (!endpoints.isFirewallConfigured() && group != null) {
            throw new ListenerException((MessageKey)PrCnMsgID.LISTENER_GROUP_ERROR, new Object[0]);
        }
        if (!skipportscheck) {
            try {
                if (!s_isCluster) {
                    if (node != null) throw new ListenerException((MessageKey)PrCrMsgID.NOT_ORCL_CLUSTER, this.m_nameAttr.getValue());
                    NodeAppsFactoryImpl.getInstance().checkPorts(portList);
                } else if (node == null) {
                    String[] vipNames = this.getVIPNames(this.network().getNumber());
                    if (vipNames.length > 0) {
                        NodeAppsFactoryImpl.getInstance().checkPorts(vipNames, portList);
                    }
                    NodeAppsFactoryImpl.getInstance().checkPorts(portList);
                } else {
                    NodeAppsFactoryImpl.getInstance().checkPorts(new String[]{node.getName()}, portList);
                }
            }
            catch (SoftwareModuleException e) {
                throw new ListenerException(e);
            }
            catch (NodeException e) {
                throw new ListenerException(e);
            }
        }
        try {
            String portStr;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            String attrName = node == null ? ResourceType.Listener.ENDPOINTS.name() : ResourceType.getPerXName(ResourceType.Listener.ENDPOINTS.name(), node.getName());
            Trace.out("AttrName for endpoints is " + attrName);
            attrList.add(CRSFactoryImpl.getInstance().create(attrName, endpoints.toCRSValue()));
            String lraStr = null;
            if (ltype == ListenerType.LISTENER) {
                if (endpoints.isFirewallConfigured()) {
                    lraStr = group != null ? ResourceLiterals.GROUP.toString() + ":" + group.trim() : "ON";
                } else if (group == null && !this.getGroup().equals("")) {
                    lraStr = "";
                }
                if (lraStr != null) {
                    attrName = node == null ? ResourceType.Listener.LOCAL_REGISTRATION_ADDRESS.name() : ResourceType.getPerXName(ResourceType.Listener.LOCAL_REGISTRATION_ADDRESS.name(), node.getName());
                    Trace.out("AttrName for endpoints is " + attrName);
                    ResourceAttribute lraAttr = CRSFactoryImpl.getInstance().create(attrName, lraStr);
                    attrList.add(lraAttr);
                }
            }
            if ((portStr = endpoints.getTCPPortCRSValue()) != null) {
                attrList.add(CRSFactoryImpl.getInstance().create(ResourceType.Listener.PORT.name(), portStr));
            }
            this.m_crsResource.update(attrList.toArray(new ResourceAttribute[attrList.size()]));
            return;
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (NodeException e) {
            throw new ListenerException(e);
        }
    }

    private Endpoints getEndpoints(Node node) throws ListenerException {
        EndpointsImpl endpoints = null;
        try {
            if (!s_isCluster && node != null) {
                throw new ListenerException((MessageKey)PrCrMsgID.NOT_ORCL_CLUSTER, this.m_nameAttr.getValue());
            }
            String attrName = node == null ? ResourceType.Listener.ENDPOINTS.name() : ResourceType.getPerXName(ResourceType.Listener.ENDPOINTS.name(), node.getName());
            ResourceAttribute attr = this.m_crsResource.getAttribute(attrName);
            endpoints = this.type() == ListenerType.getEnumMember(ResourceType.MgmtListener.NAME.toString()) ? new EndpointsImpl(attr.getValue(), " ", true) : new EndpointsImpl(attr.getValue(), " ", false);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (NodeException e) {
            throw new ListenerException(e);
        }
        catch (EnumConstNotFoundException e) {
            throw new ListenerException(e);
        }
        return endpoints;
    }

    private void updateDependency4Lsnr(ResourceAttribute attr, boolean bAdd) throws ASMException, SoftwareModuleException, CRSException, AlreadyExistsException {
        try {
            String ohome = this.m_crsResource.getAttribute(ResourceType.Listener.ORACLE_HOME.name()).getValue();
            Trace.out((Object)"Current ORACLE_HOME: %s", ohome);
            if (ohome != null && ohome.equals(ResourceLiterals.CRS_HOME_VALUE.toString())) {
                Trace.out("Current listener runs from %CRS_HOME%, updating dependency");
                ASMFactoryImpl asmfact = ASMFactoryImpl.getInstance();
                asmfact.updateASMDependency4Lsnr(attr, bAdd);
            }
        }
        catch (NotExistsException notExistsException) {
            // empty catch block
        }
    }

    @Override
    public void updateDependency4ASMLsnr(boolean bAdd) throws ListenerException {
        this.updateDependency4ASMLsnr(this.m_nameAttr, bAdd);
    }

    void updateDependency4ASMLsnr(ResourceAttribute attr, boolean bAdd) throws ListenerException {
        try {
            ASMFactoryImpl asmfact = ASMFactoryImpl.getInstance();
            List<ResourceAttribute> resList = this.getDependentRes4ASMListener(bAdd);
            for (ResourceAttribute attribute : resList) {
                if (attribute.getValue().equals("ora." + ResourceLiterals.ASM.toString())) {
                    Trace.out("Updating dependencies for ASM resource...");
                    asmfact.updateASMDependency4ASMLsnr(attr, bAdd);
                }
                if (!attribute.getValue().equals("ora." + ResourceLiterals.IOSERVER.toString())) continue;
                Trace.out("Updating dependencies for IOServer resource...");
                asmfact.updateIOServerDependency4ASMLsnr(attr, bAdd);
            }
        }
        catch (NotExistsException e) {
            throw new ListenerException(e);
        }
        catch (AlreadyExistsException e) {
            throw new ListenerException(e);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
    }

    private List<ResourceAttribute> getDependentRes4ASMListener(boolean bAdd) throws CRSException, ListenerException {
        ResourceAttribute res;
        ArrayList<ResourceAttribute> resList = new ArrayList<ResourceAttribute>();
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        if (crsFactory.isRegistered((res = crsFactory.create(ResourceType.LocalASM.NAME.name(), ClusterASMImpl.getResourceName())).getValue(), CRSEntity.Type.Resource)) {
            resList.add(res);
        }
        if (crsFactory.isRegistered((res = crsFactory.create(ResourceType.IOServer.NAME.name(), IOServerImpl.getResourceName())).getValue(), CRSEntity.Type.Resource)) {
            resList.add(res);
        }
        return resList;
    }

    @Override
    public String getTNSAddressList() throws ListenerException {
        try {
            int[] prt = this.getPorts();
            String prtno = prt.length > 0 ? "" + prt[0] : "0";
            InetAddress[] InetArr = this.getMgmtListenerAddresses();
            int count = InetArr.length;
            String[] addrArr = new String[count];
            for (int i = 0; i < count; ++i) {
                Trace.out("Getting address from: " + InetArr[i].toString());
                String[] arr = InetArr[i].toString().split("/");
                addrArr[i] = arr[1];
            }
            String prtcl = new NVPair("PROTOCOL", "TCP").toString();
            String port = new NVPair("PORT", prtno).toString();
            String addresses = "";
            for (int i = 0; i < addrArr.length; ++i) {
                String host = new NVPair("HOST", addrArr[i]).toString();
                addresses = addresses + new NVPair("ADDRESS", prtcl + host + port).toString();
            }
            return new NVPair("ADDRESS_LIST", addresses).toString();
        }
        catch (InvalidSyntaxException e) {
            throw new ListenerException(e);
        }
        catch (NotExistsException e) {
            throw new ListenerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
    }

    @Override
    public InetAddress getMgmtListenerAddress() throws NotExistsException, ListenerException {
        return this.getMgmtListenerAddresses()[0];
    }

    @Override
    public InetAddress[] getMgmtListenerAddresses() throws NotExistsException, ListenerException {
        String addrStr = null;
        try {
            Listener mgmtListener = NodeAppsFactoryImpl.getInstance().getListener(ResourceLiterals.MGMTLSNR.toString());
            if (mgmtListener.isRunning()) {
                Trace.out("Mgmt listener is running");
                ResourceAttribute nameAttr = new ResourceAttribute(ResourceType.MgmtListener.NAME.name(), "ora." + ResourceLiterals.MGMTLSNR.toString().toUpperCase());
                Map<String, String> result = ((CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr)).getStateDetails();
                if (result != null) {
                    for (String node : result.keySet()) {
                        addrStr = result.get(node);
                    }
                } else {
                    throw new ListenerException((MessageKey)PrCnMsgID.STATE_DETAILS_EMPTY, new Object[0]);
                }
                Trace.out("The address string is " + addrStr);
                String[] addresses = addrStr.split(" ");
                int count = addresses.length;
                InetAddress[] InetArr = new InetAddress[count];
                for (int i = 0; i < count; ++i) {
                    Trace.out("Adding " + addresses[i]);
                    InetArr[i] = InetAddress.getByName(addresses[i]);
                }
                return InetArr;
            }
            throw new ListenerException((MessageKey)PrCnMsgID.MGMTLSNR_NOT_RUNNING, new Object[0]);
        }
        catch (SoftwareModuleException e) {
            throw new ListenerException(e);
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (UnknownHostException e) {
            throw new ListenerException((MessageKey)PrCnMsgID.UNKNOWN_HOST, addrStr);
        }
    }

    @Override
    public void extendToLeaf(boolean doExtend) throws ListenerException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Listener.SERVER_CATEGORY.name());
            if (doExtend) {
                Trace.out("Cleaning SERVER_CATEGORY attribute");
                attr.setValue("");
            } else {
                Trace.out("Setting SERVER_CATEGORY attribute to HUB");
                attr.setValue(ResourceLiterals.HUB_CATEGORY.toString());
            }
            this.m_crsResource.update(attr);
        }
        catch (CRSException ce) {
            throw new ListenerException(ce);
        }
    }

    @Override
    public boolean isExtended() throws ListenerException {
        boolean retVal = false;
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Listener.SERVER_CATEGORY.name());
            String attrVal = attr.getValue();
            if (attrVal.isEmpty()) {
                Trace.out("Listener can run on both LEAF and HUB nodes");
                retVal = true;
            } else {
                Trace.out((Object)"Listener can run only on %s nodes", attrVal);
            }
        }
        catch (CRSException ce) {
            throw new ListenerException(ce);
        }
        return retVal;
    }

    @Override
    public boolean isASMListener() throws ListenerException {
        boolean retVal = false;
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceLiterals.TYPE.name());
            String attrVal = attr.getValue();
            Trace.out("Listener resource type " + attrVal);
            if (!attrVal.isEmpty() && attrVal.equalsIgnoreCase(ResourceType.ASMListener.NAME.toString())) {
                retVal = true;
            }
        }
        catch (CRSException ce) {
            throw new ListenerException(ce);
        }
        return retVal;
    }

    private void validateASMListnerSubnet(GlobalNetworkClassification gnwcls) throws ListenerException {
        NodeAppsFactoryImpl naf;
        try {
            naf = NodeAppsFactoryImpl.getInstance();
        }
        catch (SoftwareModuleException ex) {
            Trace.out("Could not get NodeAppsFactory instance");
            throw new ListenerException(ex);
        }
        try {
            List<Listener> asmListeners = naf.getASMListeners();
            for (Listener lsnr : asmListeners) {
                SubnetImpl lsSubnet = new SubnetImpl(lsnr.getSubnet(), null);
                if (!gnwcls.subNet().equals(lsSubnet)) continue;
                Trace.out("Listener %s is already configured with subnet %s", lsnr.getName(), lsSubnet.getName());
                throw new ListenerException((MessageKey)PrCnMsgID.ASM_LISTENER_SUBNET_ERROR, lsSubnet.getName(), lsnr.getUserAssignedName());
            }
            Trace.out((Object)"No other ASM listner is configured for subnet %s", gnwcls.subNet().getName());
        }
        catch (NotExistsException ex) {
            Trace.out("There is no other ASM Listener configured");
        }
    }

    private void assertSubnet(GlobalNetworkClassification sub) throws ListenerException {
        String subStr = null;
        if (sub == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "listener-subnet01");
        }
        subStr = sub.subNet().getName();
        if (subStr == null || subStr.isEmpty()) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "subnet");
        }
    }

    private void assertEndpoints(Endpoints endpoints) throws ListenerException {
        if (endpoints == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "endpoints", endpoints);
        }
    }

    private void assertGroup(String group) throws ListenerException {
        if (group == null) {
            throw new ListenerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "group", group);
        }
    }

    private void updateOHResDependency(String oHome) throws CRSException, ListenerException {
        try {
            Trace.out("Checking for Oracle home resource existance for path " + oHome);
            HomeFactory hFact = HomeFactory.getInstance();
            OracleHome oh = hFact.getOracleHomeByPath(oHome);
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            CRSResourceImpl crsRes = (CRSResourceImpl)this.crsResource();
            try {
                String oldHomeStr = this.getOracleHome();
                OracleHome oldHome = hFact.getOracleHomeByPath(oldHomeStr);
                ResourceAttribute oldOHRes = crsFactory.create(ResourceType.Home.NAME.name(), oldHome.getName());
                Trace.out("Removing dependencies to old Oracle Home " + oldHomeStr);
                ResourceDependency.updateDependency(crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name()), oldOHRes, ResourceDependency.DepType.HARD_DEP, false);
                ResourceDependency.updateDependency(crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name()), oldOHRes, ResourceDependency.DepType.PULLUP_DEP, false);
                ResourceDependency.updateDependencyAttrModifier(false, crsRes.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name()), oldOHRes, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            }
            catch (NotExistsException nee) {
                Trace.out("No Oracle home resource for old home.");
            }
            ResourceAttribute ohRes = crsFactory.create(ResourceType.Home.NAME.name(), oh.getName());
            Trace.out("Adding dependencies to Oracle Home " + oHome);
            ResourceDependency.updateDependency(crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name()), ohRes, ResourceDependency.DepType.HARD_DEP, true);
            ResourceDependency.updateDependency(crsRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name()), ohRes, ResourceDependency.DepType.PULLUP_DEP, true);
            ResourceDependency.updateDependencyAttrModifier(true, crsRes.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name()), ohRes, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
        }
        catch (NotExistsException nee) {
            Trace.out("No Oracle home resource for ORACLE_HOME " + oHome + ", do not create dependencies");
        }
        catch (HomeException he) {
            throw new ListenerException(he);
        }
    }

    void upgradeMgmtLsnrDepAttrs(List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws ListenerException {
        this.createMgmtLsnrDepAttrsHelper(attrList, inclStartDep, inclStopDep);
    }

    void createMgmtLsnrDepAttrs(List<ResourceAttribute> attrList) throws ListenerException {
        this.createMgmtLsnrDepAttrsHelper(attrList, true, true);
    }

    private void createMgmtLsnrDepAttrsHelper(List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws ListenerException {
        Trace.out("Calling createMgmtLsnrDepAttrs");
        if (!inclStartDep && !inclStopDep) {
            return;
        }
        Version version = new Version();
        HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
        HashMap<String, String> condMap = new HashMap<String, String>();
        try {
            String depHint;
            String dep;
            RTENativeResult result;
            String template;
            CRSFactoryImpl crsf = CRSFactoryImpl.getInstance();
            int dfltNtw = 1;
            RTEArg arg = new RTEArg("cluster_vip_net", RTEArg.RTEArgType.ResType, ResourceType.ClusterVIP.getVIPNetTypeName(dfltNtw));
            argMap.put("cluster_vip_net", arg);
            if (inclStartDep) {
                template = ResourceType.MgmtListener.START_DEPENDENCIES_TEMPLATE.toString();
                result = crsf.rteEvalAttrValue(template, argMap, version.toString(), condMap, this.m_nameAttr.getValue());
                dep = result.getAttrValue();
                depHint = result.getAttrValueHint();
                Trace.out((Object)"START_DEPENDENCIES is %s", dep);
                Trace.out((Object)"START_DEPENDENCIES_RTE_INTERNAL is %s", depHint);
                attrList.add(crsf.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dep));
                attrList.add(crsf.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
            }
            if (inclStopDep) {
                template = ResourceType.MgmtListener.STOP_DEPENDENCIES_TEMPLATE.toString();
                result = crsf.rteEvalAttrValue(template, argMap, version.toString(), condMap, this.m_nameAttr.getValue());
                dep = result.getAttrValue();
                depHint = result.getAttrValueHint();
                Trace.out((Object)"STOP_DEPENDENCIES is %s", dep);
                Trace.out((Object)"STOP_DEPENDENCIES_RTE_INTERNAL is %s", depHint);
                attrList.add(crsf.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), dep));
                attrList.add(crsf.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
            }
        }
        catch (CRSException e) {
            throw new ListenerException(e);
        }
        catch (RTENativeException e) {
            throw new ListenerException(e);
        }
    }
}

