/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nodeapps;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.nodeapps.Endpoints;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.resources.PrCnMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class EndpointsImpl
implements Endpoints {
    private TCPLsnrProtocol m_tcplp = null;
    private TCPSLsnrProtocol m_tcpslp = null;
    private IPCLsnrProtocol m_ipclp = null;
    private NMPLsnrProtocol m_nmplp = null;
    private SDPLsnrProtocol m_sdplp = null;
    private EXADIRECTLsnrProtocol m_exalp = null;

    EndpointsImpl() {
        this(false);
    }

    EndpointsImpl(boolean isMgmtLsnr) {
        this.m_tcplp = new TCPLsnrProtocol();
        try {
            if (isMgmtLsnr) {
                this.m_tcplp.addValue(ResourceLiterals.DEFAULT_MGMTLSNR_TCP_PORT.toString());
            } else {
                this.m_tcplp.addValue(ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString());
            }
        }
        catch (ListenerException listenerException) {
            // empty catch block
        }
    }

    EndpointsImpl(String pStr, String separator) throws ListenerException {
        this(pStr, separator, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    EndpointsImpl(String pStr, String separator, boolean isMgmtLsnr) throws ListenerException {
        Trace.out("Get listener endpoints from " + pStr);
        int count = 0;
        StringTokenizer fields = null;
        if (pStr == null) {
            count = 0;
        } else {
            if (separator.equals("/") && pStr.indexOf(" ") != -1) {
                throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_ENDPOINTS, pStr, separator, " ");
            }
            if (separator.equals(" ") && pStr.indexOf("/") != -1) {
                throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_ENDPOINTS, pStr, separator, "/");
            }
            fields = new StringTokenizer(pStr, separator);
            count = fields.countTokens();
        }
        Trace.out("Token count is " + count);
        String pSubStr = null;
        Endpoints.LsnrProtocolType type = null;
        String values = null;
        Boolean firewallParam = null;
        if (count == 0) {
            this.m_tcplp = new TCPLsnrProtocol();
            if (isMgmtLsnr) {
                this.m_tcplp.addValue(ResourceLiterals.DEFAULT_MGMTLSNR_TCP_PORT.toString());
                return;
            } else {
                this.m_tcplp.addValue(ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString());
            }
            return;
        } else {
            boolean idx = false;
            for (int i = 0; i < count; ++i) {
                pSubStr = fields.nextToken();
                String[] pStrArr = pSubStr.split(Pattern.quote(String.valueOf(':')));
                if (pStrArr.length > 1) {
                    type = Endpoints.LsnrProtocolType.getEnumMember(pStrArr[0]);
                    values = pStrArr[1];
                    Trace.out("LsnrProtocol type = " + (Object)((Object)type) + ", values = " + values);
                    if (pStrArr.length == 3) {
                        Trace.out("Protocol extra parameter is " + pStrArr[2]);
                        String[] fwStrArr = pStrArr[2].split("=");
                        if (!fwStrArr[0].equalsIgnoreCase("FIREWALL") || fwStrArr.length != 2) throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_PROTOCOLVALUE, pStrArr[2]);
                        if (fwStrArr[1].equalsIgnoreCase("ON")) {
                            firewallParam = true;
                        } else {
                            if (!fwStrArr[1].equalsIgnoreCase("OFF")) throw new ListenerException((MessageKey)PrCnMsgID.FIREWALL_INVALID_VALUE, fwStrArr[1]);
                            firewallParam = false;
                        }
                    }
                    if (pStrArr.length > 3) {
                        throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_PROTOCOLTYPE, pSubStr);
                    }
                } else {
                    type = Endpoints.LsnrProtocolType.TCP_PROTOCOL;
                    values = pSubStr;
                }
                StringTokenizer vfields = null;
                vfields = new StringTokenizer(values, ",");
                int vcount = vfields.countTokens();
                LsnrProtocol lp = null;
                if (vcount <= 0) continue;
                switch (type) {
                    case TCP_PROTOCOL: {
                        if (this.m_tcplp == null) {
                            this.m_tcplp = new TCPLsnrProtocol();
                        }
                        lp = this.m_tcplp;
                        break;
                    }
                    case IPC_PROTOCOL: {
                        if (this.m_ipclp == null) {
                            this.m_ipclp = new IPCLsnrProtocol();
                        }
                        lp = this.m_ipclp;
                        break;
                    }
                    case TCPS_PROTOCOL: {
                        if (this.m_tcpslp == null) {
                            this.m_tcpslp = new TCPSLsnrProtocol();
                        }
                        lp = this.m_tcpslp;
                        break;
                    }
                    case NMP_PROTOCOL: {
                        if (this.m_nmplp == null) {
                            this.m_nmplp = new NMPLsnrProtocol();
                        }
                        lp = this.m_nmplp;
                        break;
                    }
                    case SDP_PROTOCOL: {
                        if (this.m_sdplp == null) {
                            this.m_sdplp = new SDPLsnrProtocol();
                        }
                        lp = this.m_sdplp;
                        break;
                    }
                    case EXADIRECT_PROTOCOL: {
                        if (this.m_exalp == null) {
                            this.m_exalp = new EXADIRECTLsnrProtocol();
                        }
                        lp = this.m_exalp;
                        break;
                    }
                }
                if (lp == null) continue;
                for (int j = 0; j < vcount; ++j) {
                    lp.addValue(vfields.nextToken());
                }
                if (firewallParam == null) continue;
                lp.setFirewall(firewallParam);
            }
        }
    }

    @Override
    public String toString() {
        return this.convertToString("/");
    }

    @Override
    public String toCRSValue() {
        return this.convertToString(" ");
    }

    private String convertToString(String separator) {
        StringBuilder endpoints = new StringBuilder();
        boolean first = true;
        if (this.m_tcplp != null) {
            endpoints.append(this.m_tcplp.toString());
            first = false;
        }
        if (this.m_ipclp != null) {
            if (!first) {
                endpoints.append(separator);
            }
            endpoints.append(this.m_ipclp.toString());
            first = false;
        }
        if (this.m_tcpslp != null) {
            if (!first) {
                endpoints.append(separator);
            }
            endpoints.append(this.m_tcpslp.toString());
            first = false;
        }
        if (this.m_nmplp != null) {
            if (!first) {
                endpoints.append(separator);
            }
            endpoints.append(this.m_nmplp.toString());
            first = false;
        }
        if (this.m_sdplp != null) {
            if (!first) {
                endpoints.append(separator);
            }
            endpoints.append(this.m_sdplp.toString());
            first = false;
        }
        if (this.m_exalp != null) {
            if (!first) {
                endpoints.append(separator);
            }
            endpoints.append(this.m_exalp.toString());
            first = false;
        }
        return endpoints.toString();
    }

    @Override
    public boolean equals(Endpoints ep) {
        return this.toString().equals(ep.toString());
    }

    @Override
    public String getTCPPortStr() {
        if (this.m_tcplp != null) {
            return this.m_tcplp.valuesToString();
        }
        return null;
    }

    @Override
    public String getTCPPortCRSValue() {
        if (this.m_tcplp != null) {
            ArrayList<String> values = this.m_tcplp.getValues();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String ival : values) {
                if (first) {
                    sb.append(ival.toString());
                    first = false;
                    continue;
                }
                sb.append(" " + ival.toString());
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public int[] getTCPPortArr() {
        if (this.m_tcplp == null) {
            return new int[0];
        }
        ArrayList<String> portList = this.m_tcplp.getValues();
        int len = portList.size();
        int[] ports = new int[len];
        int i = 0;
        for (String port : portList) {
            ports[i++] = Integer.parseInt(port);
        }
        return ports;
    }

    @Override
    public String getTCPSPortStr() {
        if (this.m_tcpslp != null) {
            return this.m_tcpslp.valuesToString();
        }
        return null;
    }

    public String getEXADIRECTPortStr() {
        if (this.m_exalp != null) {
            return this.m_exalp.valuesToString();
        }
        return null;
    }

    @Override
    public Map<Endpoints.LsnrProtocolType, Boolean> getFirewallStatus() {
        EnumMap<Endpoints.LsnrProtocolType, Boolean> resMap = new EnumMap<Endpoints.LsnrProtocolType, Boolean>(Endpoints.LsnrProtocolType.class);
        Boolean tmpStatus = null;
        tmpStatus = this.m_tcplp == null ? null : this.m_tcplp.getFirewallStatus();
        resMap.put(Endpoints.LsnrProtocolType.TCP_PROTOCOL, tmpStatus);
        tmpStatus = this.m_tcpslp == null ? null : this.m_tcpslp.getFirewallStatus();
        resMap.put(Endpoints.LsnrProtocolType.TCPS_PROTOCOL, tmpStatus);
        tmpStatus = this.m_sdplp == null ? null : this.m_sdplp.getFirewallStatus();
        resMap.put(Endpoints.LsnrProtocolType.SDP_PROTOCOL, tmpStatus);
        tmpStatus = this.m_exalp == null ? null : this.m_exalp.getFirewallStatus();
        resMap.put(Endpoints.LsnrProtocolType.EXADIRECT_PROTOCOL, tmpStatus);
        Trace.out("Return map with size " + resMap.size());
        return resMap;
    }

    @Override
    public boolean isFirewallConfigured() {
        Map<Endpoints.LsnrProtocolType, Boolean> pMap = this.getFirewallStatus();
        for (Endpoints.LsnrProtocolType lp : pMap.keySet()) {
            Boolean fwStat = pMap.get((Object)lp);
            if (fwStat == null) continue;
            Trace.out("Firewall is " + fwStat.toString().toLowerCase() + " for protocol " + lp.toString());
            return true;
        }
        return false;
    }

    class EXADIRECTLsnrProtocol
    extends LsnrProtocol {
        EXADIRECTLsnrProtocol() {
            super(Endpoints.LsnrProtocolType.EXADIRECT_PROTOCOL);
        }

        @Override
        String addValue(String portStr) throws ListenerException {
            return this.addPortValue(portStr);
        }
    }

    class NMPLsnrProtocol
    extends LsnrProtocol {
        NMPLsnrProtocol() {
            super(Endpoints.LsnrProtocolType.NMP_PROTOCOL);
        }

        @Override
        String addValue(String pipeName) throws ListenerException {
            return this.addStringValue(pipeName);
        }
    }

    class IPCLsnrProtocol
    extends LsnrProtocol {
        IPCLsnrProtocol() {
            super(Endpoints.LsnrProtocolType.IPC_PROTOCOL);
        }

        @Override
        String addValue(String keyStr) throws ListenerException {
            return this.addStringValue(keyStr);
        }
    }

    class SDPLsnrProtocol
    extends LsnrProtocol {
        SDPLsnrProtocol() {
            super(Endpoints.LsnrProtocolType.SDP_PROTOCOL);
        }

        @Override
        String addValue(String portStr) throws ListenerException {
            return this.addPortValue(portStr);
        }
    }

    class TCPSLsnrProtocol
    extends LsnrProtocol {
        TCPSLsnrProtocol() {
            super(Endpoints.LsnrProtocolType.TCPS_PROTOCOL);
        }

        @Override
        String addValue(String portStr) throws ListenerException {
            return this.addPortValue(portStr);
        }
    }

    class TCPLsnrProtocol
    extends LsnrProtocol {
        TCPLsnrProtocol() {
            super(Endpoints.LsnrProtocolType.TCP_PROTOCOL);
        }

        @Override
        String addValue(String portStr) throws ListenerException {
            return this.addPortValue(portStr);
        }
    }

    class LsnrProtocol {
        Endpoints.LsnrProtocolType m_type;
        ArrayList<String> m_values;
        private Boolean m_isFirewall = null;

        LsnrProtocol(Endpoints.LsnrProtocolType type) {
            this.m_type = type;
            this.m_values = new ArrayList();
        }

        Endpoints.LsnrProtocolType getType() {
            return this.m_type;
        }

        ArrayList<String> getValues() {
            return this.m_values;
        }

        String addPortValue(String portStr) throws ListenerException {
            Trace.out("Calling parseInt to check " + portStr);
            int portInt = 0;
            try {
                portInt = Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_PORT, portStr);
            }
            Trace.out("Get port number " + portInt);
            if (portInt <= 0) {
                throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_PORT, portStr);
            }
            return this.addStringValue(portStr);
        }

        String addStringValue(String val) throws ListenerException {
            if (val.indexOf(":") != -1) {
                throw new ListenerException((MessageKey)PrCnMsgID.INVALID_LSNR_PROTOCOLVALUE, val);
            }
            for (String ival : this.m_values) {
                if (!ival.equals(val)) continue;
                throw new ListenerException((MessageKey)PrCnMsgID.DUPLICATED_LSNR_PROTOCOLVALUE, val);
            }
            this.m_values.add(val);
            return val;
        }

        public void setFirewall(Boolean firewallStatus) throws ListenerException {
            switch (this.m_type) {
                case TCP_PROTOCOL: 
                case TCPS_PROTOCOL: 
                case SDP_PROTOCOL: 
                case EXADIRECT_PROTOCOL: {
                    this.m_isFirewall = firewallStatus;
                    break;
                }
                default: {
                    throw new ListenerException((MessageKey)PrCnMsgID.FIREWALL_ENDPOINT_ERROR, this.m_type.toString());
                }
            }
        }

        public Boolean getFirewallStatus() {
            return this.m_isFirewall;
        }

        public String valuesToString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            ArrayList<String> values = this.getValues();
            for (String ival : values) {
                if (first) {
                    sb.append(ival.toString());
                    first = false;
                    continue;
                }
                sb.append("," + ival.toString());
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getType().toString()).append(":").append(this.valuesToString());
            if (this.m_isFirewall != null) {
                sb.append(':').append("FIREWALL").append("=");
                if (this.m_isFirewall.booleanValue()) {
                    sb.append("ON");
                } else {
                    sb.append("OFF");
                }
            }
            return sb.toString();
        }

        String addValue(String val) throws ListenerException {
            return this.addPortValue(val);
        }
    }
}

