/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.nodeapps;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CRSResourceTypeEntity;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.nodeapps.EONS;
import oracle.cluster.nodeapps.EONSException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.eons.BridgeFilter;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.common.ClusterTier;
import oracle.supercluster.common.SCDiscoveryMethod;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.GossipServerResourceImpl;
import oracle.supercluster.impl.cluster.SCTierImpl;
import oracle.supercluster.resources.SclcMsgID;

public class EONSImpl
extends SoftwareModuleImpl
implements EONS,
ClusterTier {
    private ResourceAttribute m_nameAttr;
    private SCTierImpl m_tierImpl;

    EONSImpl(ResourceAttribute nameAttr) throws EONSException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.EONS.NAME.name())) {
                throw new EONSException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.EONS.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.EONS.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new EONSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.EONS.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
            this.m_tierImpl = ClusterFactoryImpl.getInstance().getSCTierImpl(this.m_crsResource, true);
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new EONSException(e);
        }
        catch (SoftwareModuleException e) {
            throw new EONSException(e);
        }
        catch (SCTierException e) {
            throw new EONSException(e);
        }
    }

    void create(SCDiscoveryMethod discoveryMethod, String port, InetAddress mcastAddress, String mcastPort, Map<String, Integer> mbrMap, Map<String, String> props, Version version) throws AlreadyExistsException, EONSException {
        try {
            if (Cluster.isCluster()) {
                NodeAppsFactoryImpl.getInstance().assertRoot();
            }
        }
        catch (SoftwareModuleException e) {
            throw new EONSException(e);
        }
        if (SCDiscoveryMethod.MULTICAST.equals((Object)discoveryMethod)) {
            if (mcastAddress == null) {
                throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastAddress", mcastAddress);
            }
            if (mcastPort == null || mcastPort.trim().length() == 0) {
                throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastPort", mcastPort);
            }
            if (!mcastAddress.isMulticastAddress()) {
                throw new EONSException((MessageKey)SclcMsgID.NOT_MCAST_ADDRESS, mcastAddress.getHostAddress());
            }
        } else if (SCDiscoveryMethod.LIST.equals((Object)discoveryMethod)) {
            if (mbrMap == null || mbrMap.size() == 0) {
                throw new EONSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mbrMap", mbrMap);
            }
        } else if (SCDiscoveryMethod.GOSSIP_SERVERS.equals((Object)discoveryMethod)) {
            try {
                GossipServerResourceImpl gsrImpl = (GossipServerResourceImpl)ClusterFactoryImpl.getInstance().getGossipServerResource();
            }
            catch (NotExistsException e) {
                throw new EONSException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (SoftwareModuleException e) {
                throw new EONSException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
        }
        try {
            List<ResourceAttribute> attrList;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute eonsTypeAttr = crsFactory.create(ResourceType.EONS.NAME.name(), ResourceType.EONS.NAME.toString());
            if (!crsFactory.isRegistered(eonsTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                if (!crsFactory.isRegistered(ResourceType.LocalResource.NAME.toString(), CRSEntity.Type.ResourceType)) {
                    crsFactory.create(CRSEntity.Type.ResourceType, ResourceType.getAttributes(ResourceType.LocalResource.class));
                }
                attrList = ResourceType.getAttributes(ResourceType.EONS.class);
                crsFactory.create(CRSEntity.Type.ResourceType, attrList);
            } else {
                attrList = crsFactory.getResourceTypeEntity(eonsTypeAttr).getAttributes(new String[0]);
            }
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.EONS.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.EONS.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.EONS_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.EONS.DISCOVERY_METHOD.name())) {
                    attr.setValue(discoveryMethod.toString());
                    continue;
                }
                if (SCDiscoveryMethod.MULTICAST.equals((Object)discoveryMethod) && attr.getName().equalsIgnoreCase(ResourceType.EONS.MCAST_ADDRESS.name())) {
                    attr.setValue(ClusterFactoryImpl.getMulticastAddress((InetAddress)mcastAddress, (String)mcastPort));
                    continue;
                }
                if (SCDiscoveryMethod.LIST.equals((Object)discoveryMethod) && attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.MEMBER_LIST.name())) {
                    attr.setValue(ClusterFactoryImpl.getMemberList(mbrMap));
                    continue;
                }
                if (port != null && attr.getName().equalsIgnoreCase(ResourceType.EONS.PORT.name())) {
                    attr.setValue(port);
                    continue;
                }
                if (props == null || !attr.getName().equalsIgnoreCase(ResourceType.EONS.PROPERTIES.name())) continue;
                StringBuilder sb = new StringBuilder();
                for (String key : props.keySet()) {
                    if (sb.length() > 0) {
                        sb.append(" " + key.trim() + "=" + props.get(key).trim());
                        continue;
                    }
                    sb.append(key.trim() + "=" + props.get(key).trim());
                }
                attr.setValue(sb.toString());
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            this.m_crsResource = Cluster.isCluster() ? (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER) : (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out("about to set m_tierImpl");
            this.m_tierImpl = ClusterFactoryImpl.getInstance().getSCTierImpl(this.m_crsResource, true);
        }
        catch (CRSException e) {
            throw new EONSException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new EONSException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SCTierException e) {
            throw new EONSException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public ClusterTier tier() throws SCTierException {
        return this;
    }

    public String getTierName() throws SCTierException {
        return this.m_tierImpl.getTierName();
    }

    public int port() throws SCTierException {
        return this.m_tierImpl.port();
    }

    public int getPort() throws EONSException {
        try {
            int eonsport = this.port();
            return eonsport;
        }
        catch (SCTierException e) {
            throw new EONSException(e);
        }
    }

    public SCDiscoveryMethod discoveryMethod() throws SCTierException {
        return this.m_tierImpl.discoveryMethod();
    }

    @Override
    public Map<String, String> properties() throws EONSException {
        try {
            return this.m_tierImpl.properties();
        }
        catch (SCTierException e) {
            throw new EONSException(e);
        }
    }

    @Override
    public void setProperties(Map<String, String> props) throws EONSException {
        try {
            this.m_tierImpl.setProperties(props);
        }
        catch (SCTierException e) {
            throw new EONSException(e);
        }
    }

    public List<SCDiscoveryServer> discoveryServers() throws SCTierException {
        return this.m_tierImpl.discoveryServers();
    }

    public InetAddress getMulticastAddress() throws SCTierException {
        return this.m_tierImpl.getMulticastAddress();
    }

    public int getMulticastPort() throws SCTierException {
        return this.m_tierImpl.getMulticastPort();
    }

    public Map<String, Integer> memberList() throws SCTierException {
        return this.m_tierImpl.memberList();
    }

    public List<BridgeFilter> getFilters(BridgeFilter.FILTERLOCATION location) throws SCTierException {
        throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_FILTERS_FAILED, true, location.toString(), this.tier().getName()));
    }

    public void insertFilters(BridgeFilter.FILTERLOCATION location, List<BridgeFilter> filters) throws SCTierException {
        StringBuilder sb = new StringBuilder();
        for (BridgeFilter filter : filters) {
            if (sb.length() > 0) {
                sb.append("," + filter.toString());
                continue;
            }
            sb.append(filter.toString());
        }
        throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.SET_FILTERS_FAILED, true, sb.toString(), location.toString(), this.tier().getName(), "NOT IMPLEMENTED"));
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.EONS.toString();
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, EONSException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new EONSException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    public boolean isClusterTier() throws SCTierException {
        return this.m_tierImpl.isClusterTier();
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, EONSException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new EONSException(e);
        }
    }

    public static void removeResType(boolean force) throws EONSException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ResourceAttribute eonsTypeAttr = cf.create(ResourceType.EONS.NAME.name(), ResourceType.EONS.NAME.toString());
            CRSResourceTypeEntity resType = cf.getResourceTypeEntity(eonsTypeAttr);
            Trace.out("Check whether the eons resource type exists");
            if (resType.isRegistered()) {
                Trace.out("Unregister the eons resource type");
                resType.unregister(true);
            }
        }
        catch (CRSException e) {
            throw new EONSException((MessageKey)PrCnMsgID.FAILED_UNREGISTER_EONS_TYPE, (Throwable)e, new Object[0]);
        }
    }

    public void setMulticastAddress(InetAddress mcastAddress) throws SCTierException {
        this.m_tierImpl.setMulticastAddress(mcastAddress);
    }

    public void setMulticastPort(String mcastPort) throws SCTierException {
        this.m_tierImpl.setMulticastPort(mcastPort);
    }

    public void setListenPort(String localPort) throws SCTierException {
        this.m_tierImpl.setListenPort(localPort);
    }
}

