/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.logger;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.common.cnative.ClusterNative;
import oracle.cluster.impl.logger.DiagnosticsUtil;
import oracle.cluster.impl.logger.SRVLoggerImpl;
import oracle.cluster.impl.logger.TraceMessageData;
import oracle.cluster.logger.FileOutput;
import oracle.cluster.logger.SRVLevel;
import oracle.cluster.logger.TraceLogger;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.InvalidPathException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class TraceLoggerImpl
extends SRVLoggerImpl
implements TraceLogger {
    private static Throwable s_thTrace;
    private static final String FILE_SEPARATOR;
    private static final String MAJOR_EVENT_TAG = "[MAJOR EVENT] ";
    private static String s_currentProcessID;
    private static boolean s_bTraceEnabled;
    private static boolean s_bTraceSetupNeeded;
    private static EnumSet<NTFlags> apiTraceSet;
    private static boolean s_bNativeTraceEnabled;
    private static boolean s_bJNITraceEnabled;
    private static boolean s_bNativeCSSTraceEnabled;
    private static boolean s_bNativeOCRTraceEnabled;
    private static boolean s_bNativeCRSTraceEnabled;
    private List m_skipClassList = new ArrayList();
    private static Queue<TraceMessageData> s_MinorMsgQueue;
    private static Queue<TraceMessageData> s_DiagDataQueue;
    private static boolean s_bDiagEnabled;
    private static boolean s_bDiagFileReady;
    private static int s_minorCnt;
    private static final int MAX_MINOR_ALLOWED = 300;
    private static List<String> m_pkgToBufferList;
    private static List<String> m_pkgToSkipList;
    private final Object m_syncObject = new Object();
    private static String s_sessionDiagFilePath;
    private static ThreadLocal<Integer> s_uid;
    private static int s_uid_helper;
    private static final String s_timeStamp;

    public TraceLoggerImpl() {
        Trace.setTraceLogger(this);
        if (s_bTraceSetupNeeded && s_bNativeTraceEnabled) {
            TraceLoggerImpl.enableNativeTrace();
        } else if (!s_bTraceSetupNeeded) {
            this.startDiagnostics();
        }
        this.addClassToSkip("oracle.ops.mgmt.trace.Trace");
        this.addClassToSkip("oracle.cluster.impl.logger.TraceLoggerImpl");
        this.addClassToSkip("oracle.cluster.impl.logger.SRVLoggerImpl");
        this.addPkgToBufferMessages("oracle.ops.mgmt");
        this.addPkgToBufferMessages("oracle.cluster");
        this.addPackageToSkip("oracle.ops.opsctl");
        if (s_bTraceSetupNeeded) {
            s_bTraceEnabled = true;
            s_bTraceSetupNeeded = false;
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return s_bTraceEnabled;
    }

    @Override
    public boolean isNativeTraceEnabled() {
        return s_bNativeTraceEnabled;
    }

    @Override
    public boolean isJNITraceEnabled() {
        return s_bJNITraceEnabled;
    }

    @Override
    public boolean isCRSNativeTraceEnabled() {
        return s_bNativeCRSTraceEnabled;
    }

    @Override
    public void traceEnabled(boolean bState) {
        s_bTraceEnabled = bState;
        Trace.internalTraceEnabled(bState);
        Trace.internalSetTraceLevel(5);
        if (bState) {
            this.stopDiagnostics();
            Trace.setTraceLogger();
        } else {
            this.startDiagnostics();
        }
    }

    @Override
    public void nativeTraceEnabled(boolean bState) {
        if (s_bNativeTraceEnabled == bState) {
            return;
        }
        s_bNativeTraceEnabled = bState;
        if (bState) {
            TraceLoggerImpl.enableNativeTrace();
        } else {
            s_bNativeTraceEnabled = false;
            s_bNativeCSSTraceEnabled = false;
            s_bNativeCRSTraceEnabled = false;
            s_bNativeOCRTraceEnabled = false;
            s_bJNITraceEnabled = false;
            apiTraceSet.remove((Object)NTFlags.Native);
            apiTraceSet.remove((Object)NTFlags.JNI);
            apiTraceSet.remove((Object)NTFlags.NativeCRS);
            apiTraceSet.remove((Object)NTFlags.NativeOCR);
            apiTraceSet.remove((Object)NTFlags.NativeCSS);
        }
    }

    @Override
    public void JNITraceEnabled(boolean bState) {
        if (s_bJNITraceEnabled == bState) {
            return;
        }
        if (bState) {
            apiTraceSet.add(NTFlags.JNI);
        } else {
            apiTraceSet.remove((Object)NTFlags.JNI);
        }
        s_bJNITraceEnabled = bState;
    }

    @Override
    public void CSSTraceEnabled(boolean bState) {
        if (s_bNativeCSSTraceEnabled == bState) {
            return;
        }
        if (bState) {
            s_bNativeTraceEnabled = true;
            apiTraceSet.add(NTFlags.Native);
            s_bJNITraceEnabled = true;
            apiTraceSet.add(NTFlags.JNI);
            s_bNativeCSSTraceEnabled = true;
            apiTraceSet.add(NTFlags.NativeCSS);
            NativeSystem ns = new SystemFactory().CreateSystem();
            try {
                ns.loadSRVMHASNativeLibrary();
            }
            catch (NativeException ne) {
                return;
            }
            ClusterNative.setupCSSNativeTrace();
        } else {
            ClusterNative.unsetupCSSNativeTrace();
            s_bNativeCSSTraceEnabled = false;
            apiTraceSet.remove((Object)NTFlags.NativeCSS);
        }
    }

    @Override
    public void CRSTraceEnabled(boolean bState) {
        if (s_bNativeCRSTraceEnabled == bState) {
            return;
        }
        if (bState) {
            s_bNativeTraceEnabled = true;
            s_bNativeCRSTraceEnabled = true;
            s_bJNITraceEnabled = true;
            apiTraceSet.add(NTFlags.Native);
            apiTraceSet.add(NTFlags.JNI);
            apiTraceSet.add(NTFlags.NativeCRS);
        } else {
            apiTraceSet.remove((Object)NTFlags.NativeCRS);
            s_bNativeCRSTraceEnabled = false;
        }
    }

    @Override
    public void OCRTraceEnabled(boolean bState) throws Exception {
        throw new Exception("Not Implemented");
    }

    private static void enableNativeTrace() {
        if (s_bDiagEnabled) {
            return;
        }
        apiTraceSet.add(NTFlags.Native);
        apiTraceSet.add(NTFlags.JNI);
        apiTraceSet.add(NTFlags.NativeCRS);
        apiTraceSet.add(NTFlags.NativeOCR);
        apiTraceSet.add(NTFlags.NativeCSS);
        TraceLoggerImpl.setupNativeTracing();
    }

    private static void setupNativeTracing() {
        s_bNativeCSSTraceEnabled = true;
        s_bNativeTraceEnabled = true;
        s_bNativeCRSTraceEnabled = true;
        s_bNativeOCRTraceEnabled = true;
        s_bJNITraceEnabled = true;
        NativeSystem ns = new SystemFactory().CreateSystem();
        try {
            ns.loadSRVMHASNativeLibrary();
            ClusterNative.setupCSSNativeTrace();
        }
        catch (NativeException nativeException) {
            // empty catch block
        }
    }

    @Override
    public void traceLoggerEnabled(boolean bState) {
        s_bTraceEnabled = bState;
        if (bState) {
            this.stopDiagnostics();
        } else {
            this.startDiagnostics();
        }
    }

    @Override
    public void write(String msg, boolean noHeader) {
        this.writeInternal(SRVLevel.DEBUG_LEVEL, msg, noHeader);
    }

    @Override
    public void write(String msg) {
        this.writeInternal(SRVLevel.DEBUG_LEVEL, msg, false);
    }

    @Override
    public void write(Exception exp) {
        if (s_bTraceEnabled) {
            super.write(exp);
        } else if (exp != null) {
            StringWriter sw = new StringWriter();
            exp.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            this.writeInternal(SRVLevel.DEBUG_LEVEL, exceptionAsString, false);
        }
    }

    @Override
    public void write(boolean isMajor, String msg) {
        this.write(isMajor, msg, false);
    }

    @Override
    public void write(boolean isMajor, String msg, boolean noHeader) {
        StringBuilder sb = new StringBuilder();
        if (!isMajor) {
            this.writeInternal(SRVLevel.DEBUG_LEVEL, msg, noHeader);
        } else if (msg != null && !"".equals(msg)) {
            sb.append(MAJOR_EVENT_TAG);
            sb.append(msg);
            this.writeInternal(SRVLevel.DEBUG_LEVEL, sb.toString(), noHeader);
        }
    }

    @Override
    public void write(Level level, String msg) {
        this.writeInternal(level, msg, false);
    }

    @Override
    public void write(Level level, String msg, boolean noHeader) {
        this.writeInternal(level, msg, noHeader);
    }

    private void writeInternal(Level level, String msg, boolean noHeader) {
        boolean isBuffered = false;
        s_thTrace = new Throwable();
        StackTraceElement[] elements = s_thTrace.getStackTrace();
        if (elements.length == 0) {
            return;
        }
        if (!s_bTraceEnabled) {
            if (!s_bDiagEnabled) {
                return;
            }
            for (int i = elements.length - 1; i > 0; --i) {
                if (TraceLoggerImpl.isSRVMSkippedPkg(elements[i].getClassName())) {
                    return;
                }
                if (!TraceLoggerImpl.isSRVMBufferedPkg(elements[i].getClassName())) continue;
                isBuffered = true;
                break;
            }
        }
        if (s_bTraceEnabled && !noHeader || isBuffered) {
            int numFramesToSkip;
            StringBuilder tracePrefix = new StringBuilder();
            SimpleDateFormat sdf = new SimpleDateFormat(" yyyy-MM-dd HH:mm:ss.SSS z ");
            int currentUID = this.getUID();
            if (currentUID != 0) {
                tracePrefix.append("[UID:" + currentUID + "] ");
            }
            tracePrefix.append("[" + Thread.currentThread().getName() + "] [" + sdf.format(new Date()) + "] ");
            for (numFramesToSkip = 0; numFramesToSkip < elements.length && this.m_skipClassList.contains(elements[numFramesToSkip].getClassName()); ++numFramesToSkip) {
            }
            if (numFramesToSkip == elements.length) {
                --numFramesToSkip;
            }
            StackTraceElement stElem = elements[numFramesToSkip];
            String trace_info_line = stElem.toString();
            String packageName = TraceLoggerImpl.extractPackageName(trace_info_line);
            String className = stElem.getClassName();
            tracePrefix.append("[" + (className.length() > packageName.length() ? className.substring(packageName.length() + 1) : className) + "." + (stElem.isNativeMethod() ? "Native" : stElem.getMethodName() + ":" + stElem.getLineNumber()) + "]  ");
            msg = tracePrefix.append(msg).toString();
        }
        if (isBuffered) {
            this.bufferedWrite(level, msg);
        }
        if (s_bTraceEnabled) {
            super.write(level, msg);
        }
    }

    public static void diagnosticsEnabled(boolean state) {
        s_bDiagEnabled = state;
    }

    @Override
    public boolean logDiagnosticMessages() {
        if (s_bTraceEnabled || !s_bDiagEnabled) {
            return true;
        }
        if (!TraceLoggerImpl.isLoggingNeeded()) {
            return false;
        }
        TraceLoggerImpl.writeDiagnosticLog();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void writeDiagnosticLog() {
        boolean isAppend = true;
        boolean isSavePreviousLog = false;
        int maxLogOutputSize = 0xA00000;
        int maxLogOutputFiles = 10;
        String DIAG_MARKER = "-----------------------------";
        String sessionDiagFile = TraceLoggerImpl.getDiagnosticsFile();
        if (s_DiagDataQueue.isEmpty() || !s_bDiagEnabled || sessionDiagFile == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(" yyyy-MM-dd HH:mm:ss.SSS z ");
        String diagDumpTimeStamp = sdf.format(new Date());
        try (FileOutput fout = null;){
            fout = new FileOutput(sessionDiagFile, maxLogOutputSize, maxLogOutputFiles, isAppend, isSavePreviousLog);
            TraceMessageData data = null;
            LogRecord lr = new LogRecord(SRVLevel.INFORMATION_LEVEL, DIAG_MARKER + " Diagnostic Message START " + diagDumpTimeStamp + DIAG_MARKER);
            fout.print(lr);
            do {
                if ((data = s_DiagDataQueue.poll()) == null) continue;
                lr = new LogRecord(data.getLevel(), data.getMessage());
                fout.print(lr);
            } while (!s_DiagDataQueue.isEmpty());
            lr = new LogRecord(SRVLevel.INFORMATION_LEVEL, "Relevant Stack Frame :");
            fout.print(lr);
            StringWriter st = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(st));
            lr = new LogRecord(SRVLevel.INFORMATION_LEVEL, st.toString());
            fout.print(lr);
            lr = new LogRecord(SRVLevel.INFORMATION_LEVEL, DIAG_MARKER + " Diagnostic Message  END" + diagDumpTimeStamp + DIAG_MARKER);
            fout.print(lr);
            s_MinorMsgQueue.clear();
            s_minorCnt = 0;
            fout.flush();
        }
    }

    private static int getLastExceptionFrame(StackTraceElement[] elements) {
        int interestedFrame = -1;
        for (int i = 0; i < elements.length; ++i) {
            String fullClassName = elements[i].getClassName();
            if (!fullClassName.contains("TraceLoggerImpl")) {
                if (DiagnosticsUtil.isExceptionSerious(fullClassName)) {
                    interestedFrame = i;
                    continue;
                }
                if (!fullClassName.endsWith("Exception")) continue;
                return -1;
            }
            if (interestedFrame == -1) continue;
            return -1;
        }
        return interestedFrame;
    }

    @Override
    public void setUID(int uid) {
        if (s_uid == null) {
            s_uid = new ThreadLocal();
        }
        s_uid.set(uid);
    }

    @Override
    public void setHelperUID(int uid) {
        s_uid_helper = uid;
    }

    @Override
    public int getUID() {
        if (s_uid == null || s_uid.get() == null) {
            return s_uid_helper;
        }
        return s_uid.get();
    }

    public static boolean isLoggingNeeded() {
        String curExceptionName = null;
        Throwable steTrace = new Throwable();
        StackTraceElement[] elements = steTrace.getStackTrace();
        if (elements.length < 4) {
            return false;
        }
        int srvmExpFrame = TraceLoggerImpl.getLastExceptionFrame(elements);
        if (srvmExpFrame == -1) {
            return false;
        }
        String fullClassName = elements[srvmExpFrame].getClassName();
        curExceptionName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        for (int k = elements.length - 1; k > srvmExpFrame; --k) {
            if (!TraceLoggerImpl.isSRVMSkippedPkg(elements[k].getClassName())) continue;
            return false;
        }
        for (int i = srvmExpFrame + 1; i < elements.length; ++i) {
            String fClassName = elements[i].getClassName();
            if (!TraceLoggerImpl.isSRVMBufferedPkg(fClassName)) {
                return true;
            }
            if (DiagnosticsUtil.isExceptionSerious(fClassName)) {
                curExceptionName = fClassName.substring(fClassName.lastIndexOf(46) + 1);
                continue;
            }
            if (TraceLoggerImpl.isCallerExceptionTypeSame(elements[i], curExceptionName)) continue;
            return false;
        }
        return false;
    }

    private static boolean isSRVMSkippedPkg(String fullClassName) {
        boolean isSkipped = false;
        for (String pkg : m_pkgToSkipList) {
            isSkipped = fullClassName.toLowerCase().contains(pkg.toLowerCase());
            if (!isSkipped) continue;
            return isSkipped;
        }
        return isSkipped;
    }

    private static boolean isSRVMBufferedPkg(String fullClassName) {
        boolean isMonitored = false;
        for (String bufferedpkg : m_pkgToBufferList) {
            isMonitored = fullClassName.toLowerCase().contains(bufferedpkg.toLowerCase());
            if (!isMonitored) continue;
            return isMonitored;
        }
        return isMonitored;
    }

    private void stopDiagnostics() {
        s_bDiagEnabled = false;
        TraceLoggerImpl.disableNativeDiagBuffering();
    }

    private void startDiagnostics() {
        if (s_bTraceEnabled) {
            return;
        }
        super.setLevel(SRVLevel.DEBUG_LEVEL);
        Trace.internalSetTraceLevel(this.convertToTraceLevel(SRVLevel.DEBUG_LEVEL));
        this.JNITraceEnabled(true);
        s_bDiagEnabled = true;
    }

    private static void disableNativeDiagBuffering() {
        if (!apiTraceSet.contains((Object)NTFlags.Native)) {
            s_bNativeTraceEnabled = false;
        }
        if (!apiTraceSet.contains((Object)NTFlags.NativeCRS)) {
            s_bNativeCRSTraceEnabled = false;
        }
        if (!apiTraceSet.contains((Object)NTFlags.NativeOCR)) {
            s_bNativeOCRTraceEnabled = false;
        }
        if (!apiTraceSet.contains((Object)NTFlags.NativeCSS)) {
            s_bNativeCSSTraceEnabled = false;
        }
        if (!apiTraceSet.contains((Object)NTFlags.JNI)) {
            s_bJNITraceEnabled = false;
        }
    }

    private static String getDiagnosticsFile() {
        String baseDir = null;
        String logDir = null;
        String localNode = null;
        if (s_sessionDiagFilePath != null) {
            return s_sessionDiagFilePath + FILE_SEPARATOR + "srvm-" + s_timeStamp + ".trc";
        }
        ClusterwareInfo cwi = new ClusterwareInfo();
        try {
            baseDir = cwi.getCRSHomeOracleBase(new Version());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (baseDir == null) {
            logDir = System.getProperty("oracle.installer.scratchPath");
        } else {
            try {
                localNode = Utils.getLocalNodeName();
            }
            catch (UnknownHostException e) {
                return null;
            }
            logDir = baseDir + File.separator + "crsdata" + File.separator + localNode + File.separator + "trace" + FILE_SEPARATOR + "srvm";
        }
        if (logDir == null) {
            return null;
        }
        ClusterCmd cmd = new ClusterCmd();
        File fLogDir = new File(logDir);
        try {
            if (fLogDir.exists()) {
                if (!cmd.isDirWritable(logDir)) {
                    return null;
                }
            } else {
                String[] nodeList;
                if (localNode == null) {
                    localNode = Utils.getLocalNodeName();
                }
                if (!cmd.createDirWithPermissionsOnNodes(nodeList = new String[]{localNode}, logDir, "775")) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        s_sessionDiagFilePath = logDir;
        return s_sessionDiagFilePath + FILE_SEPARATOR + "srvm-" + s_timeStamp + ".trc";
    }

    @Override
    public void setDiagnosticsLogPath(String pathName) throws InvalidPathException {
        String actualPath;
        if (pathName == null || "".equals(pathName)) {
            throw new InvalidPathException(MessageBundle.getMessageBundle("Prkc").getMessage("1179", true, new String[]{"pathName"}));
        }
        File dirPath = new File(pathName);
        ClusterCmd cmd = new ClusterCmd();
        try {
            if (!dirPath.isDirectory()) {
                throw new InvalidPathException(MessageBundle.getMessageBundle("Prkc").getMessage("1152", true, new String[]{pathName}));
            }
            if (!cmd.isDirWritable(pathName)) {
                MessageBundle.getMessageBundle(PrCgMsgID.facility);
                throw new InvalidPathException(MessageBundle.getMessage(PrCgMsgID.NON_WRITABLE_PATH, true, pathName));
            }
        }
        catch (SecurityException se) {
            throw new InvalidPathException(se.getMessage());
        }
        catch (ClusterException ce) {
            throw new InvalidPathException(ce.getMessage());
        }
        try {
            actualPath = dirPath.getCanonicalPath();
        }
        catch (IOException e) {
            actualPath = dirPath.getAbsolutePath();
        }
        s_sessionDiagFilePath = actualPath;
    }

    private static boolean isCallerExceptionTypeSame(StackTraceElement element, String curExceptionName) {
        String callingMethod = element.getMethodName();
        try {
            Method[] allMethods;
            Class<?> callerClass = Class.forName(element.getClassName());
            for (Method m : allMethods = callerClass.getDeclaredMethods()) {
                if (!m.getName().equals(callingMethod)) continue;
                Class<?>[] xType = m.getExceptionTypes();
                for (int i = 0; i < xType.length; ++i) {
                    String xName = xType[i].getName();
                    if (!curExceptionName.equals(xName = xName.substring(xName.lastIndexOf(46) + 1))) continue;
                    return true;
                }
                return false;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferedWrite(Level level, String msg) {
        TraceMessageData msgData = new TraceMessageData(level, msg.trim());
        if (msg.contains(MAJOR_EVENT_TAG)) {
            s_DiagDataQueue.add(msgData);
        } else {
            Object object = this.m_syncObject;
            synchronized (object) {
                s_DiagDataQueue.add(msgData);
                s_MinorMsgQueue.add(msgData);
                if (++s_minorCnt >= 300) {
                    msgData = s_MinorMsgQueue.poll();
                    if (msgData != null) {
                        s_DiagDataQueue.remove(msgData);
                    }
                    --s_minorCnt;
                }
            }
        }
    }

    public void addPackageToSkip(String pkgName) {
        m_pkgToSkipList.add(pkgName);
    }

    public void addPkgToBufferMessages(String pkgName) {
        m_pkgToBufferList.add(pkgName);
    }

    @Override
    public void addClassToSkip(String className) {
        this.m_skipClassList.add(className);
    }

    private static String extractPackageName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        int count = st.countTokens();
        StringBuffer buf = new StringBuffer();
        String packagename = null;
        for (int i = 0; i < count - 4; ++i) {
            String newtoken = st.nextToken();
            buf.append(newtoken + ".");
        }
        buf.append(st.nextToken());
        packagename = buf.toString();
        return packagename;
    }

    @Override
    public int convertToTraceLevel(SRVLevel loggerLevel) {
        int level = 5;
        int intValue = loggerLevel.intValue();
        if (intValue == SRVLevel.CODE_TRACE.intValue()) {
            level = 1;
        } else if (intValue == SRVLevel.ENTRY_EXIT.intValue()) {
            level = 2;
        } else if (intValue == SRVLevel.DEVELOPER_LEVEL.intValue()) {
            level = 3;
        } else if (intValue == SRVLevel.ADMIN_LEVEL.intValue()) {
            level = 4;
        } else if (intValue == SRVLevel.DEBUG_LEVEL.intValue()) {
            level = 5;
        } else if (intValue == SRVLevel.INFORMATION_LEVEL.intValue()) {
            level = 8;
        } else if (intValue == SRVLevel.WARNING_LEVEL.intValue()) {
            level = 12;
        } else if (intValue == SRVLevel.ERROR_LEVEL.intValue()) {
            level = 15;
        } else if (intValue == SRVLevel.CRITICAL_LEVEL.intValue()) {
            level = 16;
        }
        return level;
    }

    private SRVLevel convertToSRVLevel(int level) {
        if (level == 1) {
            return SRVLevel.CODE_TRACE;
        }
        if (level == 2) {
            return SRVLevel.ENTRY_EXIT;
        }
        if (level == 3) {
            return SRVLevel.DEVELOPER_LEVEL;
        }
        if (level == 4) {
            return SRVLevel.ADMIN_LEVEL;
        }
        if (level == 5) {
            return SRVLevel.DEBUG_LEVEL;
        }
        if (level == 8) {
            return SRVLevel.INFORMATION_LEVEL;
        }
        if (level == 12) {
            return SRVLevel.WARNING_LEVEL;
        }
        if (level == 15) {
            return SRVLevel.ERROR_LEVEL;
        }
        if (level == 16) {
            return SRVLevel.CRITICAL_LEVEL;
        }
        return SRVLevel.DEBUG_LEVEL;
    }

    @Override
    public void setLevel(int level) {
        this.setLevel(this.convertToSRVLevel(level));
    }

    @Override
    public void setLevel(SRVLevel level) {
        super.setLevel(level);
        Trace.internalSetTraceLevel(this.convertToTraceLevel(level));
    }

    @Override
    public void traceLoggerSetLevel(SRVLevel level) {
        super.setLevel(level);
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        s_currentProcessID = ManagementFactory.getRuntimeMXBean().getName();
        s_bTraceEnabled = false;
        s_bTraceSetupNeeded = false;
        apiTraceSet = EnumSet.noneOf(NTFlags.class);
        s_bNativeTraceEnabled = false;
        s_bJNITraceEnabled = false;
        s_bNativeCSSTraceEnabled = false;
        s_bNativeOCRTraceEnabled = false;
        s_bNativeCRSTraceEnabled = false;
        s_MinorMsgQueue = new ConcurrentLinkedQueue<TraceMessageData>();
        s_DiagDataQueue = new ConcurrentLinkedQueue<TraceMessageData>();
        s_bDiagEnabled = false;
        s_bDiagFileReady = false;
        s_minorCnt = 0;
        m_pkgToBufferList = new ArrayList<String>();
        m_pkgToSkipList = new ArrayList<String>();
        s_sessionDiagFilePath = null;
        s_uid = null;
        s_uid_helper = 0;
        s_timeStamp = new SimpleDateFormat("yyyyMMdd_kkmmss").format(new Date());
        s_bTraceSetupNeeded = Boolean.getBoolean("TRACING.ENABLED");
        s_bNativeTraceEnabled = Boolean.getBoolean("NATIVETRACING.ENABLED");
        if (s_bNativeTraceEnabled) {
            apiTraceSet.add(NTFlags.Native);
        }
        if (s_bJNITraceEnabled = Boolean.getBoolean("JNITRACING.ENABLED")) {
            apiTraceSet.add(NTFlags.JNI);
        }
    }

    private static enum NTFlags {
        Native,
        JNI,
        NativeCSS,
        NativeOCR,
        NativeCRS;

    }
}

