/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.install;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.common.ClusterException;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.impl.install.WinExecCommand;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.NodeStatus;
import oracle.cluster.priv.ChannelProgressListener;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.util.ConcurrencyTimeoutException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

class WinExecConcur {
    WinExecConcur() {
    }

    public void executeCommand(String script, String[] nodes, String[] args, String[] env, String srcLoc, String destLoc, Map<String, NodeStatus> nodeStatusMap, int timeout, ChannelProgressListener cpListener) throws CompositeOperationException, ClusterException {
        Command[] cmdArr = new WinExecCommand[nodes.length];
        CompositeOperationException cex = null;
        for (int i = 0; i < nodes.length; ++i) {
            cmdArr[i] = new WinExecCommand(script, nodes[i], args, env, srcLoc, destLoc, cpListener);
        }
        try {
            Trace.out("Creating Parallel execute factory");
            ParallelCommand threadExec = ParallelCommandFactory.getParallelCommand(cmdArr, timeout, new Version());
            threadExec.submit();
        }
        catch (ConcurrencyException ce) {
            Trace.out("Exception in parallel execution " + ce.getMessage());
            throw new ClusterException(ce);
        }
        catch (ConcurrencyTimeoutException cte) {
            Trace.out("Timeout during execution of command " + cte.getMessage());
            throw new ClusterException(cte);
        }
        catch (CompositeOperationException coe) {
            cex = coe;
            Trace.out(coe.getMessage());
        }
        HashMap<Object, NativeResult> hMap = new HashMap<Object, NativeResult>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        for (int i = 0; i < nodes.length; ++i) {
            CommandResult cResult = cmdArr[i].getCommandResult();
            hMap.put(cResult.getNodeName(), cResult);
            if (!cResult.getStatus() || 0 != cResult.getOSErrCode()) {
                failedNodes.add(cResult.getNodeName());
                Trace.out("Failed node is " + cResult.getNodeName());
            }
            this.loadResultsWin(cResult, nodeStatusMap);
        }
        Trace.out("Failed nodes are " + Utils.strListToList(failedNodes));
        if (null != cex) {
            throw cex;
        }
        if (0 != failedNodes.size()) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.SCRIPT_EXECUTION_FAILED, hMap, script, Utils.strListToList(failedNodes));
        }
    }

    public void loadResultsWin(CommandResult result, Map<String, NodeStatus> nodeStatusMap) {
        String node = result.getNodeName();
        boolean status = result.getStatus();
        int exitCode = result.getOSErrCode();
        Exception excp = result.getException();
        String err = result.getErrorString();
        String[] resultStringArr = result.getResultString();
        String out = Utils.strArrToString(resultStringArr, null);
        boolean isRebootReqd = false;
        if (null != out) {
            if (-1 != out.indexOf("CLSRSC-400:")) {
                isRebootReqd = true;
            }
        } else {
            out = " ";
        }
        NodeStatus nodeStatus = new NodeStatus(status, out, err, excp, exitCode, isRebootReqd);
        nodeStatusMap.put(node, nodeStatus);
    }
}

