/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.install;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.cluster.priv.ChannelProgressListener;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class WinExecCommand
extends Command {
    private String m_srcloc;
    private String m_destloc;
    private String[] m_args = null;
    private String[] m_env = null;
    private String m_script;
    private ChannelProgressListener m_cpListener;

    public WinExecCommand(String script, String node, String[] args, String[] env, String srcLoc, String destLoc, ChannelProgressListener cpListener) {
        this.m_node = node;
        this.m_srcloc = srcLoc;
        this.m_destloc = destLoc;
        this.m_args = args;
        this.m_script = script;
        this.m_env = env;
        this.commandResult = new CommandResult();
        this.m_cpListener = cpListener;
    }

    @Override
    public boolean execute() {
        boolean isLocal = false;
        try {
            String localHost = Utils.getLocalHost();
            isLocal = this.m_node.toLowerCase().startsWith(localHost.toLowerCase());
            Trace.out("Local Node is " + localHost);
        }
        catch (UnknownHostException uhe) {
            Trace.out("Couldn't get the local hostname, proceeding assuming it as remote node");
        }
        if (null != this.m_cpListener) {
            this.m_cpListener.updateStatus("START", this.m_node);
        }
        Trace.out("Setting node name in the commandResult object before executing the command on the node");
        this.commandResult.setNodeName(this.m_node);
        if (isLocal) {
            Trace.out("This is local node , continuing with the execution on the local node");
            this.executeLocal();
        } else {
            RemoteExecCommand cmd = null;
            Trace.out("Creating RemoteExecCommand for nodename " + this.m_node);
            String windir = System.getenv("windir");
            String cmdExec = windir + "\\system32\\cmd.exe";
            ArrayList<String> cmdArrayList = new ArrayList<String>();
            cmdArrayList.add("/c");
            cmdArrayList.add(this.m_script);
            if (null != this.m_args) {
                for (String arg : this.m_args) {
                    if (null == arg) continue;
                    cmdArrayList.add(arg.trim());
                }
            }
            String[] arg_RemExec = new String[cmdArrayList.size()];
            cmdArrayList.toArray(arg_RemExec);
            Trace.out("The command prepared and passed is " + cmdExec + " " + arg_RemExec);
            cmd = new RemoteExecCommand(cmdExec, arg_RemExec, this.m_env, this.m_node, null, this.m_srcloc, this.m_destloc, (NativeResult)this.commandResult, true);
            cmd.execute();
        }
        if (null != this.m_cpListener) {
            this.m_cpListener.updateStatus("STOP", this.m_node);
        }
        return this.commandResult.getStatus();
    }

    public void executeLocal() {
        ArrayList<String> cmdArrayList = new ArrayList<String>();
        String windir = System.getenv("windir");
        String cmdExec = windir + "\\system32\\cmd.exe";
        cmdArrayList.add(cmdExec);
        cmdArrayList.add("/c");
        cmdArrayList.add(this.m_script);
        if (null != this.m_args) {
            for (String arg : this.m_args) {
                if (null == arg) continue;
                cmdArrayList.add(arg.trim());
            }
        }
        Object[] cmdArray = new String[cmdArrayList.size()];
        cmdArrayList.toArray(cmdArray);
        Trace.out("Inside executeLocal() , cmdArray is " + Arrays.toString(cmdArray));
        RuntimeExec runtime = new RuntimeExec((String[])cmdArray, null, this.m_env);
        int retval = runtime.runCommand();
        String[] cmdOutput = runtime.getOutput();
        Object[] rtErr = runtime.getError();
        int exitVal = runtime.getExitValue();
        Exception e = runtime.getException();
        Trace.out("retval =  " + retval);
        Trace.out("exitval =  " + exitVal);
        Trace.out("rtErrLength =  " + rtErr.length);
        if (retval != 0 || exitVal != 0) {
            Trace.out("Failed to execute command. Command = " + Arrays.toString(cmdArray) + " error = " + Arrays.toString(rtErr));
        }
        this.commandResult.setNodeName(this.m_node);
        this.commandResult.setStatus(true);
        this.commandResult.setOPSMErrCode(exitVal);
        this.commandResult.setOSErrCode(exitVal);
        this.commandResult.setException(e);
        this.commandResult.setResultString(cmdOutput);
    }
}

