/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.install;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.install.InstallImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.install.Install;
import oracle.cluster.install.InstallException;
import oracle.cluster.install.InstallGroup;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiClusterInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class InstallGroupImpl
implements InstallGroup {
    protected static final int NOHOME_TYPE = 1;
    protected static final int CRSHOME_TYPE = 2;
    protected static final int HAHOME_TYPE = 4;
    protected static final int DBHOME_TYPE = 8;
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private int m_homeTypeExist = 1;
    static final String OUI_LOC_PROPERTY = "oracle.installer.oui_loc";
    static final String DOT_SEPARATOR = ".";
    protected boolean m_isLocal = false;
    protected String m_homeName = null;
    protected String m_homeLoc = null;
    protected Node[] m_nodelist = null;
    protected String m_localNode = null;

    InstallGroupImpl(String compName, String ouiLoc, int homeType) throws InstallException {
        String original_ouiLoc = null;
        OiicStandardInventorySession session = null;
        try {
            Trace.out("OUI_LOC_PROPERTY = oracle.installer.oui_loc");
            original_ouiLoc = System.getProperty(OUI_LOC_PROPERTY);
            System.setProperty(OUI_LOC_PROPERTY, ouiLoc);
            session = new OiicStandardInventorySession(compName, new Version().toString());
            session.initSession(2);
            OiiiInstallInventory inv = session.getInstallAreaControl().getInstallInventory();
            Vector homes = inv.getHomes();
            String crsHome = new ClusterwareInfo().getCRSHome(new Version());
            crsHome = new File(crsHome).getCanonicalPath();
            for (int j = 0; j < homes.size(); ++j) {
                OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(j);
                String homeLocation = homeInfo.getLocation();
                if (!(homeLocation = new File(homeLocation).getCanonicalPath()).endsWith(File.separator)) {
                    homeLocation = homeLocation + File.separator;
                }
                if (!crsHome.endsWith(File.separator)) {
                    crsHome = crsHome + File.separator;
                }
                if (!IS_UNIX_SYSTEM) {
                    homeLocation.toLowerCase();
                    crsHome.toLowerCase();
                }
                Trace.out("Comparing home location (found in the inventory of installed CRS homes): \"" + homeLocation + "\" with the CRS home \"" + crsHome + "\"");
                if (!homeLocation.equals(crsHome)) continue;
                Vector nodelistVect = homeInfo.getNodeList();
                ServerFactoryImpl factory = ServerFactoryImpl.getInstance();
                if (nodelistVect != null && nodelistVect.size() > 0) {
                    if ((homeType & 2) <= 0) continue;
                    Trace.out("nodelist vector is not null");
                    Trace.out("size of nodelist vector = " + nodelistVect.size());
                    this.m_nodelist = new Node[nodelistVect.size()];
                    for (int i = 0; i < this.m_nodelist.length; ++i) {
                        String nodename = (String)nodelistVect.elementAt(i);
                        Trace.out("nodename[" + i + "]=" + nodename);
                        this.m_nodelist[i] = factory.getNode(nodename, false);
                    }
                    this.m_homeTypeExist = 2;
                } else {
                    if ((homeType & 4) <= 0) continue;
                    Trace.out("nodelist vector is null");
                    this.m_nodelist = new Node[1];
                    this.m_nodelist[0] = factory.getNode(InstallGroupImpl.getLocalNode(), false);
                    this.m_homeTypeExist = 4;
                }
                this.m_homeLoc = homeInfo.getLocation();
                Trace.out("Home location = " + this.m_homeLoc);
                this.m_homeName = homeInfo.getName();
                Trace.out("Home name = " + this.m_homeName);
                this.m_localNode = homeInfo.getLocalNode();
                Trace.out("local node + " + this.m_localNode);
                break;
            }
        }
        catch (OiiiInventoryDoesNotExistException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_INSTALL_INFO_FAILED, (Throwable)e, ouiLoc);
        }
        catch (OiitTargetLockNotAvailableException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_INSTALL_INFO_FAILED, (Throwable)e, ouiLoc);
        }
        catch (NodeException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_INSTALL_INFO_FAILED, (Throwable)e, ouiLoc);
        }
        catch (ServerException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_INSTALL_INFO_FAILED, (Throwable)e, ouiLoc);
        }
        catch (UnknownHostException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_INSTALL_INFO_FAILED, (Throwable)e, ouiLoc);
        }
        catch (IOException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_INSTALL_INFO_FAILED, (Throwable)e, ouiLoc);
        }
        finally {
            if (session != null) {
                session.endSession();
            }
            if (original_ouiLoc != null) {
                System.setProperty(OUI_LOC_PROPERTY, original_ouiLoc);
            } else {
                System.clearProperty(OUI_LOC_PROPERTY);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InstallGroupImpl(String compName, String ouiLoc, String nodename, int homeType) throws InstallException {
        String original_ouiLoc = null;
        OiicStandardInventorySession session = null;
        try {
            Trace.out("OUI_LOC_PROPERTY = oracle.installer.oui_loc");
            original_ouiLoc = System.getProperty(OUI_LOC_PROPERTY);
            System.setProperty(OUI_LOC_PROPERTY, ouiLoc);
            session = new OiicStandardInventorySession(compName, new Version().toString());
            session.initSession(0);
            OiiiClusterInstallInventory oClusterInstInv = new OiiiClusterInstallInventory();
            Trace.out("getting list of home locations on remote node");
            List homeLocs = oClusterInstInv.getHomes(nodename);
            if (homeLocs == null) {
                Trace.out("homeLocs is null");
                return;
            }
            Trace.out("homeLocs size = " + homeLocs.size());
            String crsHome = new ClusterwareInfo().getCRSHome(new Version());
            crsHome = new File(crsHome).getCanonicalPath();
            int j = 0;
            while (j < homeLocs.size()) {
                block22: {
                    OiiiRemoteHome oRemoteHome;
                    block25: {
                        ServerFactoryImpl factory;
                        block23: {
                            block24: {
                                oRemoteHome = oClusterInstInv.getRemoteHome(nodename, (String)homeLocs.get(j));
                                String homeLocation = oRemoteHome.getLocation();
                                if (!(homeLocation = new File(homeLocation).getCanonicalPath()).endsWith(File.separator)) {
                                    homeLocation = homeLocation + File.separator;
                                }
                                if (!crsHome.endsWith(File.separator)) {
                                    crsHome = crsHome + File.separator;
                                }
                                if (!IS_UNIX_SYSTEM) {
                                    homeLocation.toLowerCase();
                                    crsHome.toLowerCase();
                                }
                                Trace.out("Comparing home location (found in the inventory of remote installed homes): \"" + homeLocation + "\" with CRS home \"" + crsHome + "\"");
                                if (!homeLocation.equals(crsHome)) break block22;
                                Trace.out("Some form of CRS home " + j + " found, home name = " + oRemoteHome.getName());
                                Vector nodelist = oRemoteHome.getNodeList();
                                factory = ServerFactoryImpl.getInstance();
                                if (nodelist == null || nodelist.size() <= 0) break block23;
                                Trace.out("node list is not null");
                                Trace.out("node list size = " + nodelist.size());
                                Trace.out("nodelist[0] = " + (String)nodelist.get(0));
                                if ((homeType & 2) <= 0) break block24;
                                Trace.out("Found CRS Home");
                                this.m_nodelist = new Node[nodelist.size()];
                                for (int i = 0; i < nodelist.size(); ++i) {
                                    String node = (String)nodelist.get(i);
                                    Trace.out("node name = " + node);
                                    this.m_nodelist[i] = factory.getNode(node, false);
                                }
                                this.m_homeTypeExist = 2;
                                break block25;
                            }
                            Trace.out("searching the next one");
                            break block22;
                        }
                        Trace.out("node list is null");
                        if ((homeType & 4) <= 0) break block22;
                        Trace.out("Found HA Home");
                        this.m_nodelist = new Node[1];
                        this.m_nodelist[0] = factory.getNode(InstallGroupImpl.getLocalNode(), false);
                        this.m_homeTypeExist = 4;
                    }
                    this.m_homeLoc = oRemoteHome.getLocation();
                    this.m_homeName = oRemoteHome.getName();
                    this.m_localNode = oRemoteHome.getLocalNode();
                    Trace.out("local node = " + this.m_localNode);
                    return;
                }
                ++j;
            }
            return;
        }
        catch (NodeException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_REMOTE_INSTALL_INFO_FAILED, (Throwable)e, nodename, ouiLoc);
        }
        catch (ServerException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_REMOTE_INSTALL_INFO_FAILED, (Throwable)e, nodename, ouiLoc);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_REMOTE_INSTALL_INFO_FAILED, (Throwable)e, nodename, ouiLoc);
        }
        catch (OiitTargetLockNotAvailableException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_REMOTE_INSTALL_INFO_FAILED, (Throwable)e, nodename, ouiLoc);
        }
        catch (IOException e) {
            Trace.out(e.getMessage());
            throw new InstallException((MessageKey)PrCiMsgID.GET_REMOTE_INSTALL_INFO_FAILED, (Throwable)e, nodename, ouiLoc);
        }
        finally {
            if (session != null) {
                session.endSession();
            }
            if (original_ouiLoc != null) {
                System.setProperty(OUI_LOC_PROPERTY, original_ouiLoc);
            } else {
                System.clearProperty(OUI_LOC_PROPERTY);
            }
        }
    }

    @Override
    public Node[] fetchNodelist() {
        return this.m_nodelist;
    }

    @Override
    public String getDirectory() {
        return this.m_homeLoc;
    }

    @Override
    public boolean hasNodelist() {
        return this.m_isLocal;
    }

    @Override
    public Map<Node, Install> installs() {
        HashMap<Node, Install> m = new HashMap<Node, Install>();
        for (Node node : this.m_nodelist) {
            m.put(node, new InstallImpl(node, this.m_homeName));
        }
        return m;
    }

    private static String getLocalNode() throws UnknownHostException {
        String node = InetAddress.getLocalHost().getHostName();
        int index = node.indexOf(DOT_SEPARATOR);
        if (index != -1) {
            node = node.substring(0, index);
        }
        Trace.out("Local node of this host is " + node);
        return node;
    }

    protected boolean isHomeTypeExist(int type) {
        return (this.m_homeTypeExist & type) > 0;
    }
}

