/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.install;

import java.io.File;
import oracle.cluster.impl.install.CRSInstallImpl;
import oracle.cluster.impl.install.HAInstallImpl;
import oracle.cluster.install.CRSInstall;
import oracle.cluster.install.HAInstall;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;

public class InstallFactoryImpl {
    private static InstallFactoryImpl s_instance;

    private InstallFactoryImpl() throws InstallException {
    }

    public static synchronized InstallFactoryImpl getInstance() throws InstallException {
        if (s_instance == null) {
            s_instance = new InstallFactoryImpl();
        }
        return s_instance;
    }

    public CRSInstall getCRSInstall(String ouiLoc) throws InstallException, NotExistsException {
        this.assertOUILoc(ouiLoc);
        return new CRSInstallImpl(ouiLoc);
    }

    public CRSInstall getCRSInstall(String ouiLoc, String nodename) throws InstallException, NotExistsException {
        this.assertOUILoc(ouiLoc);
        this.assertNodeName(nodename);
        return new CRSInstallImpl(ouiLoc, nodename);
    }

    public HAInstall getHAInstall(String ouiLoc) throws InstallException, NotExistsException {
        this.assertOUILoc(ouiLoc);
        return new HAInstallImpl(ouiLoc);
    }

    public HAInstall getHAInstall(String ouiLoc, String nodename) throws InstallException, NotExistsException {
        this.assertOUILoc(ouiLoc);
        this.assertNodeName(nodename);
        return new HAInstallImpl(ouiLoc, nodename);
    }

    private void assertOUILoc(String ouiLoc) throws InstallException {
        if (ouiLoc == null || ouiLoc.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ouiLoc", ouiLoc);
        }
        File ouiFile = new File(ouiLoc);
        if (!ouiFile.isAbsolute()) {
            throw new InstallException((MessageKey)PrCcMsgID.PATH_IS_NOT_ABSOLUTE, ouiLoc);
        }
        if (!ouiFile.exists()) {
            throw new InstallException((MessageKey)PrCcMsgID.PATH_NOT_EXISTS, ouiLoc);
        }
        if (!ouiFile.isDirectory()) {
            throw new InstallException((MessageKey)PrCcMsgID.PATH_IS_NOT_DIR, ouiLoc);
        }
    }

    private void assertNodeName(String nodeName) throws InstallException {
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new InstallException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
    }
}

