/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.home;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.SRVCTLUtil;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.UnsupportedVersionException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.cvu.CVU;
import oracle.cluster.cvu.CVUException;
import oracle.cluster.cvu.CVUFactory;
import oracle.cluster.database.CardinalDatabase;
import oracle.cluster.database.CardinalService;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.home.Home;
import oracle.cluster.home.HomeException;
import oracle.cluster.impl.asm.DiskGroupImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.impl.nodeapps.ListenerImpl;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.InstallException;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.nodeapps.ONS;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrChMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class HomeImpl
extends SoftwareModuleImpl
implements Home {
    private String m_ohome = null;
    private Node m_node = null;
    private String m_chome = null;
    protected boolean m_isCRSHome = false;
    protected boolean m_isHAHome = false;
    protected boolean m_isCluster = false;

    HomeImpl(String oraHome) throws HomeException {
        this.m_ohome = oraHome;
        this.m_isCluster = Cluster.isCluster();
        String testorclhome = System.getenv("TEST_ORCL_HOME");
        this.m_chome = testorclhome != null ? testorclhome : oraHome;
        this.m_isCRSHome = this.isCRSHome(this.m_chome);
        this.m_isHAHome = this.isHAHome(this.m_chome);
    }

    HomeImpl(String oraHome, Node ClusterNode) throws HomeException {
        this(oraHome);
        this.m_node = ClusterNode;
    }

    private void assertFile(String filePathname) throws HomeException {
        if (filePathname == null) {
            throw new HomeException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "stateFile");
        }
        File fileToValidate = new File(filePathname);
        if (!fileToValidate.exists()) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_FILE_NOT_FOUND, filePathname);
        }
        if (fileToValidate.isDirectory()) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NOT_A_FILE, filePathname);
        }
        if (!fileToValidate.canRead()) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CANNOT_READ_FILE, filePathname);
        }
    }

    @Override
    public void stop(String sfile, boolean force, String options) throws HomeException {
        if (this.m_isCluster) {
            if (!this.m_isCRSHome) {
                this.stopDBHomeres(this.m_node, this.m_ohome, sfile, force, false, options);
            } else {
                this.stopCRSHomeres(this.m_node, this.m_ohome, sfile, force, false, options);
            }
        } else if (!this.m_isHAHome) {
            this.stopDBHomeres(this.m_node, this.m_ohome, sfile, force, false, options);
        } else {
            this.stopHAHomeres(this.m_node, this.m_ohome, sfile, force, false, options);
        }
    }

    @Override
    public void start(String sfile) throws HomeException {
        this.assertFile(sfile);
        if (this.m_isCluster) {
            if (!this.m_isCRSHome) {
                this.startDBHomeres(this.m_node, this.m_ohome, sfile);
            } else {
                this.startCRSHomeres(this.m_node, this.m_ohome, sfile);
            }
        } else if (!this.m_isHAHome) {
            this.startDBHomeres(this.m_node, this.m_ohome, sfile);
        } else {
            this.startHAHomeres(this.m_node, this.m_ohome, sfile);
        }
    }

    @Override
    public ArrayList<String> status(String sfile) throws HomeException {
        ArrayList<String> resList = null;
        if (this.m_isCluster) {
            resList = !this.m_isCRSHome ? this.statusDBHomeres(this.m_node, this.m_ohome, sfile) : this.statusCRSHomeres(this.m_node, this.m_ohome, sfile);
        } else if (!this.m_isHAHome) {
            resList = this.statusDBHomeres(this.m_node, this.m_ohome, sfile);
        } else {
            Trace.out("checking status on a SIHA home");
            resList = this.statusHAHomeres(this.m_node, this.m_ohome, sfile);
        }
        return resList;
    }

    @Override
    public Version getVersion(String node, String oHome) throws HomeException {
        return this.internalGetVersion(oHome, node, false);
    }

    @Override
    public Version getVersion(String oHome) throws HomeException {
        return this.internalGetVersion(oHome, null, false);
    }

    @Override
    public Version getVersion(String oHome, boolean compatible) throws HomeException {
        return this.internalGetVersion(oHome, null, true);
    }

    @Override
    public Version getVersion(String node, String oHome, boolean compatible) throws HomeException {
        return this.internalGetVersion(oHome, node, compatible);
    }

    @Override
    public void versionCheck() throws UnsupportedVersionException, HomeException {
        try {
            Version version = this.getVersion(this.m_ohome, true);
            Trace.out("Successfully retrieved Oracle home's version : " + version.toString());
            if (Version.isPre112(version)) {
                throw new UnsupportedVersionException((MessageKey)PrCdMsgID.PRE112_HOME_NOT_SUPPORTED, this.m_ohome, version.toString());
            }
        }
        catch (HomeException e) {
            if (e.getMessage().contains("PRKC-1137")) {
                throw new UnsupportedVersionException((MessageKey)PrChMsgID.HOME_UNKNOWN_VERSION, (Throwable)e, this.m_ohome);
            }
            throw new HomeException(e);
        }
    }

    private Version internalGetVersion(String oHome, String node, boolean compatible) throws HomeException {
        try {
            Version srvCtlver = null;
            srvCtlver = compatible ? (node != null && !node.isEmpty() ? new SRVCTLUtil(oHome).getSRVCTLVersion(node) : new SRVCTLUtil(oHome).getSRVCTLVersion()) : (node != null && !node.isEmpty() ? new SRVCTLUtil(oHome).getSRVCTLVersionNLS(node) : new SRVCTLUtil(oHome).getSRVCTLVersionNLS());
            return srvCtlver;
        }
        catch (CmdToolUtilException cmdte) {
            throw new HomeException(cmdte);
        }
    }

    private boolean isCRSHome(String chome) throws HomeException {
        try {
            String crsHome = new Util().getCRSHome();
            if (crsHome.equalsIgnoreCase(chome)) {
                return true;
            }
        }
        catch (UtilException ue) {
            throw new HomeException(ue);
        }
        return false;
    }

    private boolean isHAHome(String chome) throws HomeException {
        if (!this.m_isCluster) {
            try {
                String haHome = new Util().getCRSHome();
                if (haHome.equalsIgnoreCase(chome)) {
                    return true;
                }
            }
            catch (UtilException ue) {
                throw new HomeException(ue);
            }
        }
        return false;
    }

    private void writeres(List<ResourceAttribute> list, String fname, String restype) throws HomeException {
        try {
            FileWriter fstream = new FileWriter(fname, true);
            BufferedWriter out = new BufferedWriter(fstream);
            for (ResourceAttribute attr : list) {
                String resname = attr.getValue();
                Trace.out("resname = " + resname);
                out.write(restype + resname);
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            throw new HomeException(e);
        }
    }

    private void writeresname(String resname, String fname, String restype) throws HomeException {
        try {
            FileWriter fstream = new FileWriter(fname, true);
            BufferedWriter out = new BufferedWriter(fstream);
            Trace.out("resname = " + resname);
            out.write(restype + resname);
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            throw new HomeException(e);
        }
    }

    private void stopDBHomeres(Node node, String orclhome, String fname, boolean force, boolean chkstat, String options) throws HomeException {
        try {
            File f = new File(fname);
            if (f.exists()) {
                f.delete();
            }
            FileWriter fstream = null;
            try {
                fstream = new FileWriter(fname, true);
            }
            catch (IOException ioe) {
                throw new HomeException((MessageKey)PrChMsgID.CANNOT_CREATE_OR_OPEN_FILE, (Throwable)ioe, fname);
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter filter = null;
            Filter resFilter = null;
            Filter stateNotOfflineFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.NOT_EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "OFFLINE".toString());
            Filter internalStateFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.INTERNAL_STATE.toString(), "STARTING");
            Filter stateFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.OR, stateNotOfflineFilter, internalStateFilter);
            filter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Database.ORACLE_HOME.name(), orclhome);
            if (node != null) {
                resFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.CRS_LAST_SERVER.toString(), node.getName());
                filter = crsFactory.getFilter(Filter.Operator.AND, filter, resFilter);
            }
            filter = crsFactory.getFilter(Filter.Operator.AND, filter, stateFilter);
            Filter resDbFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            Filter dbFilter = crsFactory.getFilter(Filter.Operator.AND, filter, resDbFilter);
            Filter resLsnrFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Listener.NAME.toString());
            Filter lsnrFilter = crsFactory.getFilter(Filter.Operator.AND, filter, resLsnrFilter);
            resFilter = crsFactory.getFilter(Filter.Operator.OR, resDbFilter, resLsnrFilter);
            filter = crsFactory.getFilter(Filter.Operator.AND, filter, resFilter);
            if (node != null && this.m_isCluster) {
                Trace.out("database home is being stopped in a rolling fashion");
                DatabaseFactory df = DatabaseFactory.getInstance();
                try {
                    for (Database db : df.getDatabases(orclhome)) {
                        ((DatabaseImpl)db).processDB4OJVMPatching(Arrays.asList(node.getName()), true);
                    }
                }
                catch (NotExistsException nee) {
                    Trace.out("home %s does not contain any databases : %s", orclhome, nee);
                }
            }
            ResourceAttribute[] optionsRes = null;
            List<ResourceAttribute> resToStopList = crsFactory.searchResources(CRSEntity.Type.ResourceInstance, filter);
            if (null != options) {
                optionsRes = new ResourceAttribute[1];
                Enum[] soArr = this.getStopOpt(options);
                optionsRes[0] = CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_STOP_MODE.name(), Utils.getEnumString(soArr, String.valueOf(" ")));
                if (!chkstat) {
                    Trace.out("dbFilter: " + dbFilter.toString());
                    CRSFactoryImpl.stopResources(dbFilter, true, false, optionsRes);
                    Trace.out("lsnrFilter: " + lsnrFilter.toString());
                    CRSFactoryImpl.stopResources(lsnrFilter, force, false, null);
                }
            } else if (!chkstat) {
                Trace.out("StopDBHome filter: " + filter.toString());
                CRSFactoryImpl.stopResources(filter, true, false, optionsRes);
            }
            try {
                BufferedWriter out = new BufferedWriter(fstream);
                for (ResourceAttribute attr : resToStopList) {
                    String resName = attr.getValue();
                    Trace.out("StopDBHome write resName = " + resName);
                    if (resName.endsWith(ResourceLiterals.DB.toString())) {
                        out.write(ResourceLiterals.DB.toString() + '-' + DatabaseImpl.getUserAssignedName(resName));
                        out.newLine();
                        continue;
                    }
                    if (!resName.endsWith(ResourceLiterals.LSNR.toString())) continue;
                    out.write(ResourceLiterals.LSNR.toString() + '-' + ListenerImpl.getUserAssignedName(resName));
                    out.newLine();
                }
                out.close();
            }
            catch (IOException ioe) {
                throw new HomeException((MessageKey)PrChMsgID.CANNOT_WRITE_TO_FILE, (Throwable)ioe, fname);
            }
        }
        catch (CRSException ce) {
            if (chkstat) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ORACLE_HOME_STATUS, (Throwable)ce, orclhome);
            }
            throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_STOP_FAILED, (Throwable)ce, orclhome);
        }
        catch (SoftwareModuleException se) {
            if (chkstat) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ORACLE_HOME_STATUS, (Throwable)se, orclhome);
            }
            throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_STOP_FAILED, (Throwable)se, orclhome);
        }
        catch (NodeException ne) {
            if (chkstat) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ORACLE_HOME_STATUS, (Throwable)ne, orclhome);
            }
            throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_STOP_FAILED, (Throwable)ne, orclhome);
        }
        catch (CompositeOperationException coe) {
            if (chkstat) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ORACLE_HOME_STATUS, (Throwable)coe, orclhome);
            }
            throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_STOP_FAILED, (Throwable)coe, orclhome);
        }
        catch (AlreadyStoppedException ase) {
            Trace.out("Warning AlreadyStoppedException" + ase.getMessage());
        }
    }

    private void startDBHomeres(Node node, String orclhome, String fname) throws HomeException {
        block22: {
            try {
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                DatabaseFactory dbFactory = DatabaseFactory.getInstance();
                NodeAppsFactory naFactory = NodeAppsFactory.getInstance();
                boolean isEnabled = true;
                ArrayList<String> reslist = this.createlist(fname);
                int size = reslist.size();
                Trace.out("size is" + size);
                String resName = null;
                Filter filter = null;
                Filter resFilter = null;
                StringBuilder errorMsg = new StringBuilder();
                for (int i = size - 1; i >= 0; --i) {
                    Trace.out("i is " + i);
                    resName = reslist.get(i);
                    Trace.out("resname is " + resName);
                    if (resName.startsWith(ResourceLiterals.DB.toString())) {
                        resName = resName.substring(resName.indexOf(45) + 1);
                        Trace.out("dbresname = " + resName);
                        try {
                            Database db = dbFactory.getDatabase(resName);
                            resName = DatabaseImpl.getResourceName(resName);
                            resFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), resName);
                            boolean bl = isEnabled = node == null ? db.isEnabled() : db.isEnabled(node);
                            if (!isEnabled) continue;
                            if (filter == null) {
                                filter = resFilter;
                                continue;
                            }
                            filter = crsFactory.getFilter(Filter.Operator.OR, filter, resFilter);
                        }
                        catch (NotExistsException e) {
                            errorMsg.append(errorMsg.length() > 0 ? ", " + resName : resName);
                        }
                        continue;
                    }
                    if (!resName.startsWith(ResourceLiterals.LSNR.toString())) continue;
                    resName = resName.substring(resName.indexOf(45) + 1);
                    Trace.out("listener name is " + resName);
                    try {
                        Listener lnsr = naFactory.getListener(resName);
                        resName = ListenerImpl.getResourceName(resName);
                        resFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Listener.NAME.name(), resName);
                        boolean bl = isEnabled = node == null ? lnsr.isEnabled() : lnsr.isEnabled(node);
                        if (!isEnabled) continue;
                        if (filter == null) {
                            filter = resFilter;
                            continue;
                        }
                        filter = crsFactory.getFilter(Filter.Operator.OR, filter, resFilter);
                        continue;
                    }
                    catch (NotExistsException e) {
                        errorMsg.append(errorMsg.length() > 0 ? ", " + resName : resName);
                    }
                }
                if (errorMsg.length() > 0) {
                    throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLEDB_START_FAILED, errorMsg.toString());
                }
                try {
                    if (filter != null) {
                        if (node == null) {
                            CRSFactoryImpl.startResources(filter, null, null);
                        } else {
                            CRSFactoryImpl.startResources(filter, node.getName(), null);
                        }
                        Trace.out("Listener Started ");
                        Trace.out("Service Started ");
                        Trace.out("DB Started ");
                    }
                }
                catch (AlreadyRunningException i) {
                    // empty catch block
                }
                if (node == null || !this.m_isCluster) break block22;
                Trace.out("database home is being started in a rolling fashion");
                try {
                    for (Database db : dbFactory.getDatabases(orclhome)) {
                        ((DatabaseImpl)db).processDB4OJVMPatching(Arrays.asList(node.getName()), false);
                    }
                }
                catch (NotExistsException nee) {
                    Trace.out("home %s does not contain any databases : %s", orclhome, nee);
                }
            }
            catch (NodeException ne) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_START_FAILED, (Throwable)ne, orclhome);
            }
            catch (CRSException ce) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_START_FAILED, (Throwable)ce, orclhome);
            }
            catch (SoftwareModuleException e) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_START_FAILED, (Throwable)e, orclhome);
            }
            catch (CompositeOperationException coe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_START_FAILED, (Throwable)coe, orclhome);
            }
        }
    }

    private void stopCRSHomeres(Node node, String crshome, String fname, boolean force, boolean chkstat, String options) throws HomeException {
        File f = new File(fname);
        if (f.exists()) {
            f.delete();
        }
        StringBuffer errMsg = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        boolean asmStop = false;
        boolean lsnrStop = false;
        boolean scanlsnrStop = false;
        boolean svipStop = false;
        boolean onsStop = false;
        boolean netStop = false;
        boolean vipStop = false;
        boolean gsdStop = false;
        boolean gnsStop = false;
        boolean dgStop = false;
        boolean cvuStop = false;
        try {
            List<ResourceAttribute> list;
            List<ResourceAttribute> netresList;
            Filter vipfilter;
            List<ResourceAttribute> vipresList;
            List<ResourceAttribute> gnsresList;
            List<ResourceAttribute> list2;
            List<ResourceAttribute> list3;
            List<ResourceAttribute> scanlsnrresList;
            List<ResourceAttribute> lsnrresList;
            boolean isOCROnASM;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter dgfilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceLiterals.TYPE.name(), ResourceLiterals.DISKGROUP.toString());
            List<ResourceAttribute> dgresList = crsFactory.searchResources(CRSEntity.Type.Resource, dgfilter);
            if (dgresList.size() != 0) {
                for (ResourceAttribute attr : dgresList) {
                    String resname = attr.getValue();
                    Trace.out("dgresname = " + resname);
                    String dgname = DiskGroupImpl.getUserAssignedName((String)resname);
                    ASMFactory aSMFactory = ASMFactory.getInstance();
                    DiskGroup diskGroup = aSMFactory.getDiskGroup(dgname);
                    Trace.out("diskgroup  name is " + (String)dgname);
                    try {
                        dgStop = this.stopDG(diskGroup, node, force, chkstat);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    if (!dgStop) continue;
                    this.writeresname(resname, fname, ResourceLiterals.DISKGROUP.toString() + '-');
                }
            }
            List<ResourceAttribute> asmresList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceLiterals.ASM_TYPE.toString()));
            try {
                isOCROnASM = new ClusterwareInfo().isOCROnASM();
            }
            catch (InstallException ie) {
                throw new HomeException(ie);
            }
            if (asmresList.size() != 0 && !isOCROnASM) {
                try {
                    asmStop = this.stopASM(node, fname, force, chkstat, options);
                }
                catch (HomeException he) {
                    errMsg.append(he.getMessage() + lineSep);
                }
                if (asmStop) {
                    this.writeres(asmresList, fname, ResourceLiterals.ASM.toString() + '-');
                }
            }
            if ((lsnrresList = crsFactory.searchResources(crsFactory.create(ResourceType.Listener.ORACLE_HOME.name(), "%CRS_HOME%"))).size() != 0) {
                for (ResourceAttribute resourceAttribute : lsnrresList) {
                    String string = resourceAttribute.getValue();
                    if (!string.endsWith(".lsnr")) continue;
                    Trace.out("lsnrresname = " + string);
                    String lsnrname = ListenerImpl.getUserAssignedName(string);
                    NodeAppsFactory naf = NodeAppsFactory.getInstance();
                    Listener lsnr = naf.getListener(lsnrname);
                    Trace.out("listener name is " + lsnrname);
                    try {
                        lsnrStop = this.stopListener(lsnr, node, force, chkstat);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    if (!lsnrStop) continue;
                    this.writeresname(lsnrname, fname, ResourceLiterals.LSNR.toString() + '-');
                }
            }
            if ((scanlsnrresList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.ScanListener.NAME.toString()))).size() != 0) {
                for (ResourceAttribute resourceAttribute : scanlsnrresList) {
                    String resname = resourceAttribute.getValue();
                    String scanlsnrName = this.getName(resname);
                    Trace.out("Scan Listener Name =" + scanlsnrName);
                    try {
                        scanlsnrStop = this.stopScanListener(resname, node, force, chkstat);
                        if (!scanlsnrStop) continue;
                        this.writeresname(resname, fname, ResourceLiterals.SCAN_LISTENER.toString() + '-');
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                }
            }
            if ((list3 = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.ScanVIP.NAME.toString()))).size() != 0) {
                for (ResourceAttribute attr : list3) {
                    String resname = attr.getValue();
                    String scanvipName = this.getName(resname);
                    Trace.out("Scan Vip Name =" + scanvipName);
                    try {
                        svipStop = this.stopScanVip(resname, node, force, chkstat);
                        if (!svipStop) continue;
                        this.writeresname(resname, fname, ResourceLiterals.SCAN_VIP.toString() + '-');
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                }
            }
            if ((list2 = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.ONS.NAME.toString()))).size() != 0) {
                try {
                    onsStop = this.stopONS(node, force, chkstat);
                }
                catch (HomeException he) {
                    errMsg.append(he.getMessage() + lineSep);
                }
                if (onsStop) {
                    this.writeres(list2, fname, ResourceLiterals.ONS.toString() + '-');
                }
            }
            if ((gnsresList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.GNS.NAME.toString()))).size() != 0) {
                try {
                    gnsStop = this.stopGNS(node, force, chkstat);
                }
                catch (HomeException he) {
                    errMsg.append(he.getMessage() + lineSep);
                }
                if (gnsStop) {
                    this.writeres(gnsresList, fname, ResourceLiterals.GNS.toString() + '-');
                }
            }
            if ((vipresList = crsFactory.searchResources(CRSEntity.Type.Resource, vipfilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceLiterals.TYPE.name(), ResourceLiterals.CLUSTER_VIP.toString()))).size() != 0) {
                for (ResourceAttribute resourceAttribute : vipresList) {
                    String vipName = this.getName(resourceAttribute.getValue());
                    Trace.out("VipName =" + vipName);
                    try {
                        Trace.out("Stopping VIP res =" + resourceAttribute.getValue());
                        vipStop = this.stopVIP(vipName, node, force, chkstat);
                        if (!vipStop) continue;
                        this.writeresname(resourceAttribute.getValue(), fname, ResourceLiterals.VIP.toString() + '-');
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                }
            }
            if ((netresList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.Network.NAME.toString()))).size() != 0) {
                for (ResourceAttribute attr : netresList) {
                    try {
                        netStop = this.stopNETWORK(node, force, chkstat);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    if (!netStop) continue;
                    this.writeres(netresList, fname, ResourceLiterals.NET.toString() + '-');
                }
            }
            if ((list = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.CVU.NAME.toString()))).size() != 0) {
                try {
                    cvuStop = this.stopCVU(node, force, chkstat);
                }
                catch (HomeException he) {
                    errMsg.append(he.getMessage() + lineSep);
                }
                if (cvuStop) {
                    this.writeres(list, fname, ResourceLiterals.CVU.toString() + '-');
                }
            }
            if (errMsg.length() != 0) {
                if (chkstat) {
                    throw new HomeException((MessageKey)PrChMsgID.HOME_ORACLE_STATUS_FAIL1, errMsg);
                }
                throw new HomeException((MessageKey)PrChMsgID.HOME_CRS_STOP_FAIL1, errMsg);
            }
        }
        catch (CRSException ce) {
            if (chkstat) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_CRS_HOME_STATUS, (Throwable)ce, crshome);
            }
            throw new HomeException((MessageKey)PrChMsgID.HOME_CRS_STOP_FAILED, (Throwable)ce, crshome);
        }
        catch (SoftwareModuleException se) {
            if (chkstat) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_CRS_HOME_STATUS, (Throwable)se, crshome);
            }
            throw new HomeException((MessageKey)PrChMsgID.HOME_CRS_STOP_FAILED, (Throwable)se, crshome);
        }
        catch (NotExistsException nee) {
            if (chkstat) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_CRS_HOME_STATUS, (Throwable)nee, crshome);
            }
            throw new HomeException((MessageKey)PrChMsgID.HOME_CRS_STOP_FAILED, (Throwable)nee, crshome);
        }
    }

    private void stopHAHomeres(Node node, String crshome, String fname, boolean force, boolean chkstat, String options) throws HomeException {
        this.stopCRSHomeres(node, crshome, fname, force, false, options);
    }

    private void startHAHomeres(Node node, String crshome, String fname) throws HomeException {
        this.startCRSHomeres(node, crshome, fname);
    }

    private void startCRSHomeres(Node node, String crshome, String fname) throws HomeException {
        StringBuffer errMsg = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        boolean asmStart = false;
        boolean lsnrStart = false;
        boolean scanlsnrStart = false;
        boolean svipStart = false;
        boolean onsStart = false;
        boolean netStart = false;
        boolean vipStart = false;
        boolean gsdStart = false;
        boolean gnsStart = false;
        boolean dgStart = false;
        boolean cvuStart = false;
        try {
            ArrayList<String> reslist = this.createlist(fname);
            int size = reslist.size();
            Trace.out("size is" + size);
            String resname = null;
            for (int i = size - 1; i >= 0; --i) {
                Trace.out("i is " + i);
                resname = reslist.get(i);
                Trace.out("resname is " + resname);
                if (resname.startsWith(ResourceLiterals.CVU.toString())) {
                    try {
                        cvuStart = this.startCVU(node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.ONS.toString())) {
                    try {
                        onsStart = this.startONS(node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.NET.toString())) {
                    try {
                        netStart = this.startNETWORK(node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.GNS.toString())) {
                    try {
                        gnsStart = this.startGNS(node, vipStart);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.VIP.toString())) {
                    String vipresname = resname.substring(resname.indexOf(45) + 1);
                    String vipname = this.getName(vipresname);
                    try {
                        vipStart = this.startVIP(vipname, node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.SCAN_VIP.toString())) {
                    String svipresname = resname.substring(resname.indexOf(45) + 1);
                    try {
                        svipStart = this.startScanVip(svipresname, node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.LSNR.toString())) {
                    NodeAppsFactory naf = NodeAppsFactory.getInstance();
                    String lsnrname = resname.substring(resname.indexOf(45) + 1);
                    Listener lsnr = naf.getListener(lsnrname);
                    try {
                        lsnrStart = this.startListener(lsnr, node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.ASM.toString())) {
                    try {
                        asmStart = this.startASM(node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (resname.startsWith(ResourceLiterals.DISKGROUP.toString())) {
                    String dgresname = resname.substring(resname.indexOf(45) + 1);
                    String dgname = this.getName(dgresname);
                    ASMFactory af = ASMFactory.getInstance();
                    DiskGroup dg = af.getDiskGroup(dgname);
                    try {
                        dgStart = this.startDG(dg, node);
                    }
                    catch (HomeException he) {
                        errMsg.append(he.getMessage() + lineSep);
                    }
                    continue;
                }
                if (!resname.startsWith(ResourceLiterals.SCAN_LISTENER.toString())) continue;
                String slsnrresname = resname.substring(resname.indexOf(45) + 1);
                try {
                    scanlsnrStart = this.startScanListener(slsnrresname, node);
                    continue;
                }
                catch (HomeException he) {
                    errMsg.append(he.getMessage() + lineSep);
                }
            }
            if (errMsg.length() != 0) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_CRS_START_FAIL1, errMsg);
            }
        }
        catch (SoftwareModuleException e) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CRS_START_FAILED, (Throwable)e, crshome);
        }
        catch (NotExistsException ne) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CRS_START_FAILED, (Throwable)ne, crshome);
        }
    }

    private boolean stopService(Service svc, Node node, boolean force, boolean chkstat) throws HomeException {
        boolean serviceStopped;
        block25: {
            serviceStopped = false;
            Trace.out("calling stop service");
            try {
                List<Node> nodes;
                CRSResource crsResource;
                if (!this.m_isCluster) {
                    boolean isRunning;
                    try {
                        isRunning = svc.isRunning();
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SERVICE_STATUS, (Throwable)sme, svc.getName());
                    }
                    if (isRunning) {
                        if (!chkstat) {
                            svc.stop(true);
                        }
                        serviceStopped = true;
                    }
                    break block25;
                }
                boolean isCardinal = svc.isCardinal();
                if (isCardinal) {
                    boolean isRunning;
                    Trace.out("cardinal service");
                    CardinalService csvc = (CardinalService)svc;
                    Trace.out("enter service stop");
                    try {
                        isRunning = csvc.isRunning(node);
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SERVICE_STATUS, (Throwable)sme, csvc.getName());
                    }
                    if (isRunning) {
                        if (!chkstat) {
                            Trace.out("stopping cardinal service");
                            csvc.stop(true, this.getNodeList(node));
                        }
                        serviceStopped = true;
                    }
                    break block25;
                }
                try {
                    crsResource = svc.crsResource();
                }
                catch (NotExistsException nee) {
                    throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SERVICE_STATUS, (Throwable)nee, svc.getName());
                }
                catch (ServiceException se) {
                    throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SERVICE_STATUS, (Throwable)se, svc.getName());
                }
                try {
                    nodes = crsResource.fetchRunningNodes();
                }
                catch (CRSException crse) {
                    throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SERVICE_STATUS, (Throwable)crse, crsResource.getName());
                }
                if (nodes.size() == 0) {
                    Trace.out("No nodes is hosting this service");
                } else {
                    for (Node i : nodes) {
                        Trace.out("enter for loop for service");
                        Trace.out("Node name is " + i.getName());
                        if (!i.getName().equalsIgnoreCase(node.getName())) continue;
                        if (!chkstat) {
                            Trace.out("enter service stop");
                            svc.stop(true);
                        }
                        serviceStopped = true;
                    }
                }
            }
            catch (AlreadyStoppedException ase) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_STOP_FAILED, (Throwable)ase, new Object[0]);
            }
            catch (CompositeOperationException coe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_STOP_FAILED, (Throwable)coe, new Object[0]);
            }
            catch (CRSException ce) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_STOP_FAILED, (Throwable)ce, new Object[0]);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_STOP_FAILED, (Throwable)sme, new Object[0]);
            }
            catch (NodeException ne) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_STOP_FAILED, (Throwable)ne, new Object[0]);
            }
        }
        return serviceStopped;
    }

    private boolean stopDatabase(Database db, Node node, boolean force, boolean chkstat, String options) throws HomeException {
        boolean dbStopped;
        block25: {
            dbStopped = false;
            StopOptions[] soArr = null;
            Trace.out("stopping db instances");
            try {
                if (!this.m_isCluster) {
                    boolean isRunning;
                    try {
                        isRunning = db.isRunning();
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SERVICE_STATUS, (Throwable)sme, db.getName());
                    }
                    if (isRunning) {
                        if (!chkstat) {
                            if (options != null) {
                                soArr = this.getStopOpt(options);
                                db.stop(soArr, force);
                            } else {
                                db.stop(force);
                            }
                        }
                        dbStopped = true;
                    }
                    break block25;
                }
                boolean isCardinal = db.isCardinal();
                if (isCardinal) {
                    boolean isRunning;
                    CardinalDatabase cdb;
                    Trace.out("cardinal db");
                    DatabaseFactory df = DatabaseFactory.getInstance();
                    try {
                        cdb = df.getCardinalDatabase(db.getUserAssignedName());
                    }
                    catch (NotExistsException nee) {
                        throw new HomeException((MessageKey)PrChMsgID.DB_RESOURCE_DOES_NOT_EXIST, (Throwable)nee, db.getName());
                    }
                    try {
                        isRunning = cdb.isRunning(node);
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_DATABASE_STATUS, (Throwable)sme, cdb.getName());
                    }
                    if (isRunning) {
                        if (!chkstat) {
                            Trace.out("enter instance stop");
                            if (options != null) {
                                List<StopOptions> solist = this.getOptList(options);
                                Trace.out("stopping db with options " + options);
                                cdb.stop(this.getNodeList(node), solist, true);
                            } else {
                                cdb.stop(this.getNodeList(node), true);
                            }
                        }
                        dbStopped = true;
                    }
                    break block25;
                }
                Trace.out("non-cardinal db");
                List<DatabaseInstance> instList = db.instances();
                for (DatabaseInstance i : instList) {
                    boolean isRunning;
                    try {
                        isRunning = i.isRunning(node);
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_DB_INSTANCE_STATUS, (Throwable)sme, i.getName());
                    }
                    if (!isRunning) continue;
                    if (!chkstat) {
                        Trace.out("enter instance stop");
                        i.stop(true);
                    }
                    dbStopped = true;
                }
            }
            catch (AlreadyStoppedException ase) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DB_STOP_FAILED, (Throwable)ase, new Object[0]);
            }
            catch (DatabaseException de) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DB_STOP_FAILED, (Throwable)de, new Object[0]);
            }
            catch (CompositeOperationException coe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DB_STOP_FAILED, (Throwable)coe, new Object[0]);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DB_STOP_FAILED, (Throwable)sme, new Object[0]);
            }
        }
        return dbStopped;
    }

    private boolean stopListener(Listener lsnr, Node node, boolean force, boolean chkstat) throws HomeException {
        boolean lsnrStopped;
        block13: {
            lsnrStopped = false;
            try {
                boolean isRunning;
                if (!this.m_isCluster) {
                    boolean isRunning2;
                    try {
                        isRunning2 = lsnr.isRunning();
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_LISTENER_STATUS, (Throwable)sme, lsnr.getName());
                    }
                    if (isRunning2) {
                        if (!chkstat) {
                            lsnr.stop(force);
                        }
                        lsnrStopped = true;
                    }
                    break block13;
                }
                ArrayList<Node> nodes = new ArrayList<Node>(1);
                nodes.add(node);
                try {
                    isRunning = lsnr.isRunning(node);
                }
                catch (SoftwareModuleException sme) {
                    throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_LISTENER_STATUS, (Throwable)sme, lsnr.getName());
                }
                if (isRunning) {
                    if (!chkstat) {
                        lsnr.stop(nodes, force);
                    }
                    lsnrStopped = true;
                }
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_LSNR_STOP_FAILED, (Throwable)sme, new Object[0]);
            }
            catch (AlreadyStoppedException aee) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_LSNR_STOP_FAILED, (Throwable)aee, new Object[0]);
            }
            catch (CompositeOperationException coe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_LSNR_STOP_FAILED, (Throwable)coe, new Object[0]);
            }
        }
        return lsnrStopped;
    }

    private boolean startListener(Listener lsnr, Node node) throws HomeException {
        boolean force = true;
        boolean lsnStart = false;
        try {
            if (!this.m_isCluster) {
                lsnr.start();
                lsnStart = true;
            } else {
                lsnr.start(this.getNodeList(node));
                lsnStart = true;
            }
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_LSNR_START_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (AlreadyRunningException are) {
            Trace.out("Listener resource \"" + lsnr.getUserAssignedName() + "\" is already running." + are);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_LSNR_START_FAILED, (Throwable)coe, new Object[0]);
        }
        return lsnStart;
    }

    private boolean stopVIP(String vipname, Node node, boolean force, boolean chkstat) throws HomeException {
        NodeAppsFactory naf = null;
        boolean vipStopped = false;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        try {
            boolean isRunning;
            Trace.out("nodename = " + node.getName());
            Trace.out("vipname = " + vipname);
            VIP vip = naf.getVIP(vipname);
            Trace.out("Stop vip " + vip.getUserAssignedName());
            try {
                isRunning = vip.isRunning(node);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_VIP_STATUS, (Throwable)sme, vip.getName());
            }
            if (isRunning) {
                if (!chkstat) {
                    vip.stop(this.getNodeList(node), force);
                }
                vipStopped = true;
            }
        }
        catch (AlreadyStoppedException ase) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_VIP_STOP_FAILED, (Throwable)ase, new Object[0]);
        }
        catch (NotExistsException nse) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_VIP_STOP_FAILED, (Throwable)nse, new Object[0]);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_VIP_STOP_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (NodeException ne) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_VIP_STOP_FAILED, (Throwable)ne, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_VIP_STOP_FAILED, (Throwable)coe, new Object[0]);
        }
        return vipStopped;
    }

    private boolean startVIP(String vipname, Node node) throws HomeException {
        NodeAppsFactory naf = null;
        boolean vipStart = false;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        try {
            VIP vip = naf.getVIP(vipname);
            Trace.out("Start vip " + vip.getUserAssignedName());
            vip.start();
            vipStart = true;
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_VIP_START_FAILED, (Throwable)nee, new Object[0]);
        }
        catch (AlreadyRunningException ase) {
            Trace.out("VIP resource is already running." + ase);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_VIP_START_FAILED, (Throwable)sme, new Object[0]);
        }
        return vipStart;
    }

    private boolean stopScanVip(String resname, Node node, boolean force, boolean chkstat) throws HomeException {
        ScanFactoryImpl sf = null;
        boolean svipStopped = false;
        try {
            boolean isRunning;
            sf = ScanFactoryImpl.getInstance();
            ScanVIP svip = sf.getScanVIP(resname);
            try {
                isRunning = svip.isRunning(node);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SCAN_VIP_STATUS, (Throwable)sme, svip.getName());
            }
            if (isRunning) {
                if (!chkstat) {
                    svip.stop(force);
                }
                svipStopped = true;
            }
        }
        catch (AlreadyStoppedException ase) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANVIP_STOP_FAILED, (Throwable)ase, new Object[0]);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANVIP_STOP_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANVIP_STOP_FAILED, (Throwable)nee, new Object[0]);
        }
        return svipStopped;
    }

    private boolean startScanVip(String resname, Node node) throws HomeException {
        ScanFactoryImpl sf = null;
        boolean svipStart = false;
        ScanVIP svip = null;
        try {
            sf = ScanFactoryImpl.getInstance();
            svip = sf.getScanVIP(resname);
            if (!svip.isRunning(node)) {
                svip.start();
                svipStart = true;
            }
        }
        catch (AlreadyRunningException are) {
            Trace.out("ScanVIP resource \"" + svip.getUserAssignedName() + "\" is already running." + are);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANVIP_START_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (NotExistsException ne) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANVIP_START_FAILED, (Throwable)ne, new Object[0]);
        }
        return svipStart;
    }

    private boolean stopScanListener(String resname, Node node, boolean force, boolean chkstat) throws HomeException {
        ScanFactoryImpl sf = null;
        boolean slsnrStopped = false;
        try {
            boolean isRunning;
            sf = ScanFactoryImpl.getInstance();
            ScanListener slsnr = sf.getScanListener(resname);
            try {
                isRunning = slsnr.isRunning(node);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_SCAN_LISTENER_STATUS, (Throwable)sme, slsnr.getName());
            }
            if (isRunning) {
                if (!chkstat) {
                    slsnr.stop(force);
                }
                slsnrStopped = true;
            }
        }
        catch (AlreadyStoppedException ase) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANLSNR_STOP_FAILED, (Throwable)ase, new Object[0]);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANLSNR_STOP_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANLSNR_STOP_FAILED, (Throwable)nee, new Object[0]);
        }
        return slsnrStopped;
    }

    private boolean startScanListener(String resname, Node node) throws HomeException {
        ScanFactoryImpl sf = null;
        boolean slsnrStart = false;
        try {
            sf = ScanFactoryImpl.getInstance();
            ScanListener slsnr = sf.getScanListener(resname);
            if (!slsnr.isRunning(node)) {
                slsnr.start(node);
                slsnrStart = true;
            }
        }
        catch (AlreadyRunningException ase) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANLSNR_START_FAILED, (Throwable)ase, new Object[0]);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANLSNR_START_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (NotExistsException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SCANLSNR_START_FAILED, (Throwable)sme, new Object[0]);
        }
        return slsnrStart;
    }

    private boolean stopONS(Node node, boolean force, boolean chkstat) throws HomeException {
        boolean onsStopped;
        block16: {
            NodeAppsFactory naf = null;
            onsStopped = false;
            try {
                naf = NodeAppsFactory.getInstance();
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException(sme);
            }
            try {
                boolean isRunning;
                ONS ons = naf.getONS();
                if (!this.m_isCluster) {
                    boolean isRunning2;
                    try {
                        isRunning2 = ons.isRunning();
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ONS_STATUS, (Throwable)sme, ons.getName());
                    }
                    if (isRunning2) {
                        if (!chkstat) {
                            ons.stop(force);
                        }
                        onsStopped = true;
                    }
                    break block16;
                }
                try {
                    isRunning = ons.isRunning(node);
                }
                catch (SoftwareModuleException sme) {
                    throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ONS_STATUS, (Throwable)sme, ons.getName());
                }
                if (isRunning) {
                    if (!chkstat) {
                        ons.stop(this.getNodeList(node), force);
                    }
                    onsStopped = true;
                }
            }
            catch (NotExistsException nee) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ONS_STOP_FAILED, (Throwable)nee, new Object[0]);
            }
            catch (AlreadyStoppedException ase) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ONS_STOP_FAILED, (Throwable)ase, new Object[0]);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ONS_STOP_FAILED, (Throwable)sme, new Object[0]);
            }
            catch (CompositeOperationException coe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ONS_STOP_FAILED, (Throwable)coe, new Object[0]);
            }
        }
        return onsStopped;
    }

    private boolean startONS(Node node) throws HomeException {
        NodeAppsFactory naf = null;
        boolean onsStart = false;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        try {
            ONS ons = naf.getONS();
            if (!this.m_isCluster) {
                ons.start();
            } else {
                ons.start(this.getNodeList(node));
            }
            onsStart = true;
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_ONS_START_FAILED, (Throwable)nee, new Object[0]);
        }
        catch (AlreadyRunningException are) {
            Trace.out("ONS resource is already running." + are);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_ONS_START_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_ONS_START_FAILED, (Throwable)coe, new Object[0]);
        }
        return onsStart;
    }

    private boolean stopNETWORK(Node node, boolean force, boolean chkstat) throws HomeException {
        NodeAppsFactory naf = null;
        boolean netStopped = false;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        try {
            boolean isRunning;
            Network nw = naf.getNetwork(1);
            try {
                isRunning = nw.isRunning(node);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_NETWORK_STATUS, (Throwable)sme, nw.getName());
            }
            if (isRunning) {
                if (!chkstat) {
                    nw.stop(this.getNodeList(node), force);
                }
                netStopped = true;
            }
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NET_STOP_FAILED, (Throwable)nee, new Object[0]);
        }
        catch (AlreadyStoppedException ase) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NET_STOP_FAILED, (Throwable)ase, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NET_STOP_FAILED, (Throwable)coe, new Object[0]);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NET_STOP_FAILED, (Throwable)sme, new Object[0]);
        }
        return netStopped;
    }

    private boolean startNETWORK(Node node) throws HomeException {
        NodeAppsFactory naf = null;
        boolean netStart = false;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        try {
            Network nw = naf.getNetwork(1);
            nw.start(this.getNodeList(node));
            netStart = true;
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NET_START_FAILED, (Throwable)nee, new Object[0]);
        }
        catch (AlreadyRunningException are) {
            Trace.out("Network resource is already running." + are);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NET_START_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_NET_START_FAILED, (Throwable)coe, new Object[0]);
        }
        return netStart;
    }

    private boolean stopGNS(Node node, boolean force, boolean chkstat) throws HomeException {
        GNSFactory gf = null;
        boolean gnsStopped = false;
        try {
            gf = GNSFactory.getInstance();
        }
        catch (VIPNotFoundException vnfe) {
            throw new HomeException(vnfe);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        try {
            boolean isRunning;
            GNS gns = gf.getGNS();
            try {
                isRunning = gns.isRunning(node);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_GNS_STATUS, (Throwable)sme, gns.getName());
            }
            if (isRunning) {
                if (!chkstat) {
                    gns.stop(force);
                }
                gnsStopped = true;
            }
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_STOP_FAILED, nee);
        }
        catch (VIPNotFoundException vnfe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_STOP_FAILED, new Object[]{vnfe});
        }
        catch (GNSException ge) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_STOP_FAILED, ge);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_STOP_FAILED, sme);
        }
        return gnsStopped;
    }

    private boolean startGNS(Node node, boolean vipStart) throws HomeException {
        GNSFactory gf = null;
        boolean gnsStart = false;
        try {
            gf = GNSFactory.getInstance();
        }
        catch (VIPNotFoundException vnfe) {
            throw new HomeException(vnfe);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        try {
            GNS gns = gf.getGNS();
            if (!vipStart || !gns.isRunning()) {
                gns.start();
            }
            gnsStart = true;
        }
        catch (AlreadyRunningException are) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_START_FAILED, are);
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_START_FAILED, nee);
        }
        catch (VIPNotFoundException vnfe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_START_FAILED, new Object[]{vnfe});
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_GNS_START_FAILED, sme);
        }
        return gnsStart;
    }

    private boolean stopASM(Node node, String fname, boolean force, boolean chkstat, String options) throws HomeException {
        boolean asmStopped;
        block18: {
            asmStopped = false;
            try {
                boolean isRunning;
                FileWriter fstream = new FileWriter(fname, true);
                BufferedWriter out = new BufferedWriter(fstream);
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                Filter dbasmfilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceLiterals.DG.toString());
                List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.Resource, dbasmfilter);
                for (ResourceAttribute attr : resList) {
                    String resname = attr.getValue();
                    if (!resname.endsWith(".db")) continue;
                    Trace.out("dbresname = " + resname);
                    DatabaseFactory df = DatabaseFactory.getInstance();
                    String dbName = DatabaseImpl.getUserAssignedName(resname);
                    Trace.out("dbName = " + dbName);
                    Database db = df.getDatabase(dbName);
                    List<Service> svcList = db.services();
                    for (Service s : svcList) {
                        Trace.out("service name is " + s.getUserAssignedName());
                        String svcname = ServiceImpl.getResourceName(s.getUserAssignedName(), dbName, false);
                        Trace.out("service resname is " + svcname);
                        boolean serviceStop = this.stopService(s, node, force, chkstat);
                        if (!serviceStop) continue;
                        out.write(ResourceLiterals.SVC.toString() + '-' + s.getUserAssignedName());
                        out.newLine();
                    }
                    boolean dbStop = this.stopDatabase(db, node, force, chkstat, options);
                    if (!dbStop) continue;
                    out.write(ResourceLiterals.DB.toString() + '-' + dbName);
                    out.newLine();
                }
                ASMFactory asmfact = ASMFactory.getInstance();
                ASM asm = asmfact.getASM();
                if (!this.m_isCluster) {
                    boolean isRunning2;
                    try {
                        isRunning2 = asm.isRunning();
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ASM_STATUS, (Throwable)sme, asm.getName());
                    }
                    if (isRunning2) {
                        if (!chkstat) {
                            asm.stop(force);
                        }
                        asmStopped = true;
                    }
                    break block18;
                }
                try {
                    isRunning = asm.isRunning(node);
                }
                catch (SoftwareModuleException sme) {
                    throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_ASM_STATUS, (Throwable)sme, asm.getName());
                }
                if (isRunning) {
                    if (!chkstat) {
                        asm.stop(this.getNodeList(node), force);
                    }
                    asmStopped = true;
                }
            }
            catch (NotExistsException nee) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_STOP_FAILED, (Throwable)nee, new Object[0]);
            }
            catch (AlreadyStoppedException ase) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_STOP_FAILED, (Throwable)ase, new Object[0]);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_STOP_FAILED, (Throwable)sme, new Object[0]);
            }
            catch (CompositeOperationException coe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_STOP_FAILED, (Throwable)coe, new Object[0]);
            }
            catch (CRSException cre) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_STOP_FAILED, (Throwable)cre, new Object[0]);
            }
            catch (IOException ioe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_STOP_FAILED, (Throwable)ioe, new Object[0]);
            }
        }
        return asmStopped;
    }

    private boolean startASM(Node node) throws HomeException {
        Object asmInstList = null;
        Object dgList = null;
        Object dbinstList = null;
        boolean asmStart = false;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            ASM asm = asmfact.getASM();
            if (!this.m_isCluster) {
                asm.start();
            } else {
                asm.start(this.getNodeList(node));
            }
            asmStart = true;
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_START_FAILED, (Throwable)nee, new Object[0]);
        }
        catch (AlreadyRunningException are) {
            Trace.out("ASM resource is already running." + are);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_START_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_ASM_START_FAILED, (Throwable)coe, new Object[0]);
        }
        return asmStart;
    }

    private boolean stopDG(DiskGroup diskg, Node node, boolean force, boolean chkstat) throws HomeException {
        boolean dgStopped;
        block14: {
            dgStopped = false;
            try {
                boolean isRunning;
                if (!this.m_isCluster) {
                    boolean isRunning2;
                    try {
                        isRunning2 = diskg.isRunning();
                    }
                    catch (SoftwareModuleException sme) {
                        throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_DISK_GROUP_STATUS, (Throwable)sme, diskg.getName());
                    }
                    if (isRunning2) {
                        if (!chkstat) {
                            diskg.stop(force);
                        }
                        dgStopped = true;
                    }
                    break block14;
                }
                try {
                    isRunning = diskg.isRunning(node);
                }
                catch (SoftwareModuleException sme) {
                    throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_DISK_GROUP_STATUS, (Throwable)sme, diskg.getName());
                }
                if (isRunning) {
                    if (!chkstat) {
                        diskg.stop(this.getNodeList(node), force);
                    }
                    dgStopped = true;
                }
            }
            catch (ASMException ae) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DG_STOP_FAILED, (Throwable)ae, new Object[0]);
            }
            catch (AlreadyStoppedException ase) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DG_STOP_FAILED, (Throwable)ase, new Object[0]);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DG_STOP_FAILED, (Throwable)sme, new Object[0]);
            }
            catch (CompositeOperationException coe) {
                throw new HomeException((MessageKey)PrChMsgID.HOME_DG_STOP_FAILED, (Throwable)coe, new Object[0]);
            }
        }
        return dgStopped;
    }

    private boolean startDG(DiskGroup diskg, Node node) throws HomeException {
        boolean dgStart = false;
        try {
            if (!this.m_isCluster) {
                diskg.start();
            } else {
                diskg.start(this.getNodeList(node));
            }
            dgStart = true;
        }
        catch (ASMException ae) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_DG_START_FAILED, (Throwable)ae, new Object[0]);
        }
        catch (AlreadyRunningException ae) {
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_DG_START_FAILED, (Throwable)sme, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_DG_START_FAILED, (Throwable)coe, new Object[0]);
        }
        return dgStart;
    }

    private List<Node> getNodeList(Node node) throws HomeException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        return nodeList;
    }

    private ArrayList<String> createlist(String fname) throws HomeException {
        ArrayList<String> resList = new ArrayList<String>();
        try {
            Trace.out("entering createlist");
            FileReader fstream = new FileReader(fname);
            BufferedReader bufRead = new BufferedReader(fstream);
            String resname = null;
            resname = bufRead.readLine();
            Trace.out("resname in createlist is " + resname);
            while (resname != null) {
                resList.add(resname);
                resname = bufRead.readLine();
                Trace.out("resname in while " + resname);
            }
            bufRead.close();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new HomeException(e);
        }
        catch (IOException ioe) {
            throw new HomeException(ioe);
        }
        finally {
            return resList;
        }
    }

    private boolean startService(Service svc, Node node) throws HomeException {
        Trace.out("calling start service");
        StartOptions[] stArr = new StartOptions[]{StartOptions.OPEN};
        boolean svcStart = false;
        try {
            if (!this.m_isCluster) {
                svc.start(stArr);
                svcStart = true;
            } else {
                boolean isCardinal = svc.isCardinal();
                if (isCardinal) {
                    Trace.out("starting cardinal service");
                    DatabaseFactory df = DatabaseFactory.getInstance();
                    Database db = svc.database();
                    CardinalService csvc = df.getCardinalService(db.getUserAssignedName(), svc.getUserAssignedName());
                    csvc.start(this.getNodeList(node));
                    svcStart = true;
                } else {
                    Trace.out("non-cardinal service");
                    svc.start(stArr);
                }
            }
        }
        catch (AlreadyRunningException are) {
            Trace.out("Service resource \"" + svc.getUserAssignedName() + "\" is already running." + are);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_START_FAILED, (Throwable)coe, new Object[0]);
        }
        catch (NotExistsException noe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_START_FAILED, (Throwable)noe, new Object[0]);
        }
        catch (SoftwareModuleException se) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_SERVICE_START_FAILED, (Throwable)se, new Object[0]);
        }
        return svcStart;
    }

    private boolean startDatabase(Database db, Node node) throws HomeException {
        Trace.out("starting db instances");
        boolean dbStart = false;
        try {
            if (!this.m_isCluster) {
                db.start();
                dbStart = true;
            } else {
                boolean isCardinal = db.isCardinal();
                if (isCardinal) {
                    Trace.out("cardinal db");
                    DatabaseFactory df = DatabaseFactory.getInstance();
                    CardinalDatabase cdb = df.getCardinalDatabase(db.getUserAssignedName());
                    cdb.start(this.getNodeList(node));
                    dbStart = true;
                } else {
                    Trace.out("non-cardinal db");
                    db.start();
                }
            }
        }
        catch (AlreadyRunningException are) {
            Trace.out("Database resource \"" + db.getUserAssignedName() + "\" is already running." + are);
        }
        catch (DatabaseException de) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_DB_START_FAILED, (Throwable)de, new Object[0]);
        }
        catch (NotExistsException noe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_DB_START_FAILED, (Throwable)noe, new Object[0]);
        }
        catch (SoftwareModuleException se) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_DB_START_FAILED, (Throwable)se, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_DB_START_FAILED, (Throwable)coe, new Object[0]);
        }
        return dbStart;
    }

    private boolean stopCVU(Node node, boolean force, boolean chkstat) throws HomeException {
        boolean cvuStopped = false;
        try {
            boolean isRunning;
            CVUFactory cv = CVUFactory.getInstance();
            CVU cvu = cv.getCVU();
            try {
                isRunning = cvu.isRunning(node);
            }
            catch (SoftwareModuleException sme) {
                throw new HomeException((MessageKey)PrChMsgID.FAILED_WHILE_CHECKING_CVU_RESOURCE_STATUS, (Throwable)sme, cvu.getName());
            }
            if (isRunning) {
                if (!chkstat) {
                    cvu.stop(force);
                }
                cvuStopped = true;
            }
        }
        catch (AlreadyStoppedException ase) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_STOP_FAILED, (Throwable)ase, new Object[0]);
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_STOP_FAILED, (Throwable)nee, new Object[0]);
        }
        catch (CVUException cve) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_STOP_FAILED, (Throwable)cve, new Object[0]);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_STOP_FAILED, (Throwable)sme, new Object[0]);
        }
        return cvuStopped;
    }

    private boolean startCVU(Node node) throws HomeException {
        boolean cvuStart = false;
        try {
            CVUFactory cv = CVUFactory.getInstance();
            CVU cvu = cv.getCVU();
            cvu.start();
            cvuStart = true;
        }
        catch (AlreadyRunningException are) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_START_FAILED, (Throwable)are, new Object[0]);
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_START_FAILED, (Throwable)nee, new Object[0]);
        }
        catch (CVUException cve) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_START_FAILED, (Throwable)cve, new Object[0]);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException((MessageKey)PrChMsgID.HOME_CVU_START_FAILED, (Throwable)sme, new Object[0]);
        }
        return cvuStart;
    }

    private ArrayList<String> statusDBHomeres(Node node, String orclhome, String sfile) throws HomeException {
        this.stopDBHomeres(node, orclhome, sfile, false, true, null);
        ArrayList<String> resList = this.createlist(sfile);
        return resList;
    }

    private ArrayList<String> statusCRSHomeres(Node node, String orclhome, String sfile) throws HomeException {
        this.stopCRSHomeres(node, orclhome, sfile, false, true, null);
        ArrayList<String> resList = this.createlist(sfile);
        return resList;
    }

    private ArrayList<String> statusHAHomeres(Node node, String orclhome, String sfile) throws HomeException {
        this.stopCRSHomeres(node, orclhome, sfile, false, true, null);
        ArrayList<String> resList = this.createlist(sfile);
        return resList;
    }

    private String getName(String resName) throws HomeException {
        String[] values = resName.split(Pattern.quote(String.valueOf('.')));
        if (values.length != 3 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.'))) {
            Trace.out("Error: Expect the resource name to have 3 fields and start with ora");
            Trace.out(" It has " + values.length + " fields. It starts with " + values[0]);
            throw new HomeException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, "", resName);
        }
        return values[1];
    }

    private List<StopOptions> getOptList(String options) throws DatabaseException {
        String[] optValues = options.split(",");
        ArrayList<StopOptions> solist = new ArrayList<StopOptions>(optValues.length);
        for (int i = 0; i < optValues.length; ++i) {
            solist.add(StopOptions.getEnumMember(optValues[i].trim()));
        }
        return solist;
    }

    private StopOptions[] getStopOpt(String options) throws DatabaseException {
        String[] optValues = options.split(",");
        StopOptions[] soArr = new StopOptions[optValues.length];
        for (int i = 0; i < soArr.length; ++i) {
            soArr[i] = StopOptions.getEnumMember(optValues[i].trim());
        }
        return soArr;
    }
}

