/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.hanfs;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.hanfs.MountFS;
import oracle.cluster.hanfs.MountFSArgs;
import oracle.cluster.hanfs.MountFSException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.hanfs.HANFSFactoryImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCeMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CryptoUtil;
import oracle.cluster.util.CryptoUtilException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class MountFSImpl
extends SoftwareModuleImpl
implements MountFS {
    private static String REMOVE_SPEC_CHARS = "[^a-zA-Z0-9]";
    protected ResourceAttribute m_nameAttr;

    public MountFSImpl(ResourceAttribute nameAttr) throws MountFSException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.MountFS.NAME.name())) {
            throw new MountFSException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.MountFS.NAME.name(), nameAttr.getName());
        }
        Trace.out("resource attribute NAME = " + nameAttr.getValue());
        String MountFSResName = nameAttr.getValue();
        boolean validName = MountFSResName.indexOf(46, MountFSResName.indexOf(46) + 1) != -1;
        Trace.out("validName" + validName);
        String[] values = new String[3];
        if (validName) {
            values[0] = MountFSResName.substring(0, MountFSResName.indexOf(46) + 1);
            values[1] = MountFSResName.substring(MountFSResName.indexOf(46) + 1, MountFSResName.lastIndexOf(46));
            values[2] = MountFSResName.substring(MountFSResName.lastIndexOf(46) + 1, MountFSResName.length());
            validName &= "ora.".equalsIgnoreCase(values[0]);
            validName &= ResourceLiterals.MOUNTFS.toString().equalsIgnoreCase(values[values.length - 1]);
        }
        if (!validName) {
            Trace.out("InvalidMountFS name");
            String name = ResourceType.MountFS.NAME.name();
            throw new MountFSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, name, MountFSResName);
        }
        this.m_nameAttr = nameAttr;
        this.m_displayName = this.m_name = this.m_nameAttr.getValue();
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException nee) {
            Trace.out("MountFS resource \"" + nameAttr.getValue() + "\" is not yet created, which is ok");
        }
        catch (CRSException crse) {
            throw new MountFSException(crse);
        }
    }

    public void create(String mountPointPath, String exportPath, String exportServer, String user, String mountOptions) throws AlreadyExistsException, MountFSException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new MountFSException(sme);
        }
        try {
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute attr = new ResourceAttribute(ResourceType.MountFS.NAME.name(), this.m_nameAttr.getValue());
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceLiterals.TYPE.name(), ResourceType.MountFS.NAME.toString());
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceType.MountFS.MOUNTPOINT_PATH.name(), mountPointPath);
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceType.MountFS.INTERNAL_MOUNTPOINT_PATH.name(), mountPointPath);
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceType.MountFS.EXPORT_PATH.name(), exportPath);
            attrList.add(attr);
            attr = new ResourceAttribute(ResourceType.MountFS.EXPORT_SERVER.name(), exportServer);
            attrList.add(attr);
            if (mountOptions != null && !mountOptions.equalsIgnoreCase("\"\"") && !mountOptions.equalsIgnoreCase("''")) {
                attr = new ResourceAttribute(ResourceType.MountFS.FS_OPTIONS.name(), mountOptions);
                Trace.out("   Resource attribute: " + attr.getName() + "=" + attr.getValue());
                attrList.add(attr);
            }
            Version version = new Version();
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            boolean userValid = false;
            if (user != null && user.trim().length() > 0) {
                Trace.out("Checking for user validity");
                userValid = new Util().isUserValid(user);
                if (!userValid) {
                    throw new NotExistsException((MessageKey)PrCaMsgID.INVALID_USER, user);
                }
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out("MountFS resource created");
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
            Util utl = new Util();
            String crsUser = utl.getCRSUser();
            if (user == null && new SystemFactory().CreateSystem().isUnixSystem()) {
                user = crsUser;
            }
            Trace.out("Setting permissions for user " + user);
            perm.setPerm(ResourceType.ACL.USER, user, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
            if (!user.equals(crsUser)) {
                perm.setPerm(ResourceType.ACL.USER, crsUser, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
            }
            Trace.out("Generated MountFS ACL String: " + perm.getAclString());
            Trace.out("Setting pgroup of CRS user");
            String crsGroup = utl.getPrimaryGroup(crsUser);
            perm.setPerm(ResourceType.ACL.PGROUP, crsGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            this.m_crsResource.setPermissions(perm);
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCaMsgID.NFS_ALREADY_EXISTS, (Throwable)e, mountPointPath);
        }
        catch (NotExistsException e) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue(), mountPointPath);
        }
        catch (CRSException e) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue(), mountPointPath);
        }
        catch (UtilException e) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_CREATE_FAILED, (Throwable)e, this.m_nameAttr.getValue(), mountPointPath);
        }
    }

    @Override
    public void modifyMountFS(MountFSArgs mtArgs) throws MountFSException {
        try {
            ResourceAttribute attr;
            HANFSFactoryImpl nFactory;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            String mountPointPath = mtArgs.getMountPointPath();
            String exportServer = mtArgs.getExportServer();
            String exportPath = mtArgs.getExportPath();
            String mountOptions = mtArgs.getMountOptions();
            String user = mtArgs.getUser();
            if (this.isRunning()) {
                Trace.out("MountFS resource is running, unable to modify");
                throw new MountFSException((MessageKey)PrCeMsgID.MOUNTFS_MODIFY_RUNNING, new Object[0]);
            }
            if (mountPointPath != null) {
                nFactory = HANFSFactoryImpl.getInstance();
                nFactory.validateMountFS(mountPointPath);
                attr = new ResourceAttribute(ResourceType.MountFS.MOUNTPOINT_PATH.name(), mountPointPath);
                Trace.out("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\"");
                attrList.add(attr);
            }
            if (exportServer != null) {
                nFactory = HANFSFactoryImpl.getInstance();
                nFactory.validateExportServer(exportServer);
                attr = new ResourceAttribute(ResourceType.MountFS.EXPORT_SERVER.name(), exportServer);
                Trace.out("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\"");
                attrList.add(attr);
            }
            if (exportPath != null) {
                attr = new ResourceAttribute(ResourceType.MountFS.EXPORT_PATH.name(), exportPath);
                Trace.out("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\"");
                attrList.add(attr);
            }
            if (mountOptions != null) {
                attr = new ResourceAttribute(ResourceType.MountFS.FS_OPTIONS.name(), mountOptions);
                Trace.out("Modifying resource attribute \"" + attr.getName() + "\". New value: \"" + attr.getValue() + "\"");
                attrList.add(attr);
            }
            if (user != null) {
                Trace.out("Changing the user to " + user);
                this.setUser(user);
            }
            if (attrList.size() > 0) {
                this.m_crsResource.update(false, attrList.toArray(new ResourceAttribute[attrList.size()]));
            }
        }
        catch (SoftwareModuleException sme) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_MODIFY_FAILED, (Throwable)sme, this.getMountPointPath());
        }
        catch (CRSException crse) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_MODIFY_FAILED, (Throwable)crse, this.getMountPointPath());
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, MountFSException {
        try {
            if (!this.isGHCreated()) {
                NodeAppsFactoryImpl.getInstance().assertRoot();
            }
            super.remove(force);
        }
        catch (SoftwareModuleException sme) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_REMOVE_FAILED, (Throwable)sme, this.getMountPointPath());
        }
    }

    @Override
    public String getExportServer() throws MountFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.MountFS.EXPORT_SERVER.name()).getValue();
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public void setExportServer(String exportServer) throws MountFSException {
        try {
            HANFSFactoryImpl nFactory = HANFSFactoryImpl.getInstance();
            nFactory.validateExportServer(exportServer);
            ResourceAttribute expServerAttr = CRSFactoryImpl.getInstance().create(ResourceType.MountFS.EXPORT_SERVER.name(), exportServer);
            this.m_crsResource.update(expServerAttr);
        }
        catch (SoftwareModuleException sme) {
            throw new MountFSException(sme);
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public String getExportPath() throws MountFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.MountFS.EXPORT_PATH.name()).getValue();
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public void setExportPath(String exportPath) throws MountFSException {
        try {
            ResourceAttribute expPathAttr = CRSFactoryImpl.getInstance().create(ResourceType.MountFS.EXPORT_PATH.name(), exportPath);
            this.m_crsResource.update(expPathAttr);
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public String getMountPointPath() throws MountFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.MountFS.MOUNTPOINT_PATH.name()).getValue();
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public String getMountFSName() {
        String[] name = this.m_displayName.split("\\.");
        return name[1];
    }

    @Override
    public String getMountOptions() throws MountFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.MountFS.FS_OPTIONS.name()).getValue();
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public List<String> getUsers() throws MountFSException {
        try {
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
            return perm.getUsers();
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public String getType() throws MountFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.MountFS.MOUNT_TYPE.name()).getValue();
        }
        catch (CRSException ce) {
            throw new MountFSException(ce);
        }
    }

    @Override
    public void setMountOptions(String mountOptions) throws MountFSException {
        try {
            ResourceAttribute mtOptionsAttr = CRSFactoryImpl.getInstance().create(ResourceType.MountFS.MOUNTPOINT_PATH.name(), mountOptions);
            this.m_crsResource.update(mtOptionsAttr);
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public void setUser(String user) throws MountFSException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new MountFSException(sme);
        }
        try {
            Trace.out("Setting user information");
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
            List<String> users = perm.getUsers();
            for (String currUser : users) {
                perm.setPerm(ResourceType.ACL.USER, currUser, new ResourceType.ACL_PERM[0]);
            }
            Trace.out("Setting user' " + user + "permissions");
            perm.setPerm(ResourceType.ACL.USER, user, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
            this.m_crsResource.setPermissions(perm);
        }
        catch (CRSException crse) {
            throw new MountFSException((MessageKey)PrCaMsgID.SET_NFS_USER_FAILED, (Throwable)crse, new Object[0]);
        }
    }

    @Override
    public boolean isGHCreated() throws MountFSException {
        try {
            String ghCreated = this.m_crsResource.getAttribute(ResourceType.MountFS.GH_CREATED.name()).getValue();
            Trace.out("Gridhomes created resource flag:" + ghCreated);
            return ghCreated.equals("1");
        }
        catch (CRSException cse) {
            throw new MountFSException(cse);
        }
    }

    @Override
    public void setGHCreated(boolean ghCreated) throws MountFSException {
        try {
            ResourceAttribute ghCreatedAttr = this.m_crsResource.getAttribute(ResourceType.MountFS.GH_CREATED.name());
            Trace.out("Setting GH created flag to " + ghCreated);
            String value = ghCreated ? "1" : "0";
            ghCreatedAttr.setValue(value);
            this.m_crsResource.update(ghCreatedAttr);
        }
        catch (CRSException e) {
            Trace.out("Got CRSException: " + e.getMessage());
            throw new MountFSException(e);
        }
    }

    public static String getResourceName(String MountFSResName) {
        return "ora." + MountFSResName.toLowerCase() + '.' + (Object)((Object)ResourceLiterals.MOUNTFS);
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, MountFSException {
        try {
            Trace.out("calling parent's crsResource");
            return super.crsResource();
        }
        catch (SoftwareModuleException sme) {
            throw new MountFSException(sme);
        }
    }

    public static String hashMountPath(String mountpath) throws MountFSException {
        try {
            CryptoUtil cu = new CryptoUtil();
            Trace.out("Encrypting mount path " + mountpath + " for unique resource name");
            byte[] encMtPath = cu.getHash(mountpath);
            String cryptMount = cu.byte2Hex(encMtPath);
            Trace.out("Encrypted mount path: " + cryptMount + "");
            return cryptMount;
        }
        catch (CryptoUtilException cue) {
            throw new MountFSException(cue);
        }
    }
}

