/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.hanfs;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.hanfs.ExportFS;
import oracle.cluster.hanfs.ExportFSException;
import oracle.cluster.hanfs.ExportType;
import oracle.cluster.hanfs.HAVIP;
import oracle.cluster.hanfs.HAVIPException;
import oracle.cluster.hanfs.MountFS;
import oracle.cluster.hanfs.MountFSArgs;
import oracle.cluster.hanfs.MountFSException;
import oracle.cluster.hanfs.NetStorageService;
import oracle.cluster.hanfs.NetStorageServiceException;
import oracle.cluster.hanfs.Platform;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceNames;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.hanfs.ExportFSImpl;
import oracle.cluster.impl.hanfs.HAVIPImpl;
import oracle.cluster.impl.hanfs.MountFSImpl;
import oracle.cluster.impl.hanfs.NFSServiceImpl;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCeMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;

public class HANFSFactoryImpl {
    private static HANFSFactoryImpl s_instance;

    private HANFSFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized HANFSFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new HANFSFactoryImpl();
        }
        return s_instance;
    }

    public HAVIP createHAVIP(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description) throws AlreadyExistsException, HAVIPException {
        return this.createHAVIP(vipAddress, id, netNum, subnet, serverType, version, description, false);
    }

    public HAVIP createHAVIP(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, HAVIPException {
        try {
            String vipResName = HAVIPImpl.getResourceName(id);
            HAVIPImpl havipImpl = new HAVIPImpl(CRSFactoryImpl.getInstance().create(ResourceType.HAVIP.NAME.name(), vipResName));
            havipImpl.create(vipAddress, id, netNum, subnet, serverType, version, description, skipVIPReachabilityCheck);
            return havipImpl;
        }
        catch (CRSException e) {
            throw new HAVIPException(e);
        }
    }

    public HAVIP createHAVIP(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description, boolean skipVIPReachabilityCheck, String homeNode) throws AlreadyExistsException, HAVIPException {
        try {
            if (null == homeNode) {
                throw new HAVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "homenode");
            }
            String vipResName = HAVIPImpl.getResourceName(id);
            HAVIPImpl havipImpl = new HAVIPImpl(CRSFactoryImpl.getInstance().create(ResourceType.HAVIP.NAME.name(), vipResName));
            havipImpl.create(vipAddress, id, netNum, subnet, serverType, version, description, skipVIPReachabilityCheck, homeNode);
            return havipImpl;
        }
        catch (CRSException e) {
            throw new HAVIPException(e);
        }
    }

    public HAVIP createHAVIP(InetAddress vipAddress, Network network, Version version, String id, String description) throws AlreadyExistsException, HAVIPException {
        return this.createHAVIP(vipAddress, network, version, id, description, false);
    }

    public HAVIP createHAVIP(InetAddress vipAddress, Network network, Version version, String id, String description, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, HAVIPException {
        if (vipAddress == null) {
            throw new HAVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "vipAddress");
        }
        if (id == null) {
            throw new HAVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "id");
        }
        if (network == null) {
            throw new HAVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "network");
        }
        if (version == null) {
            throw new HAVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        if (description == null) {
            throw new HAVIPException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "description");
        }
        try {
            if (!skipVIPReachabilityCheck && IPAddressUtil.isPingable(vipAddress)) {
                throw new HAVIPException((MessageKey)PrCcMsgID.VIP_ADDRESS_REACHABILITY_ERROR, vipAddress.getHostAddress());
            }
            String vipResName = HAVIPImpl.getResourceName(id);
            HAVIPImpl havipImpl = new HAVIPImpl(CRSFactoryImpl.getInstance().create(ResourceType.HAVIP.NAME.name(), vipResName));
            IPAddressUtil.IPAddrType ipAddrType = null;
            if (vipAddress instanceof Inet4Address) {
                ipAddrType = IPAddressUtil.IPAddrType.IPv4;
            } else if (vipAddress instanceof Inet6Address) {
                ipAddrType = IPAddressUtil.IPAddrType.IPv6;
            }
            havipImpl.create(network, vipAddress.getHostName(), ipAddrType, id, version, description);
            return havipImpl;
        }
        catch (CRSException e) {
            throw new HAVIPException(e);
        }
        catch (IPAddressException ipAddressException) {
            throw new HAVIPException(ipAddressException);
        }
    }

    public HAVIP getHAVIP(String id) throws NotExistsException, HAVIPException {
        try {
            String resName = HAVIPImpl.getResourceName(id);
            Trace.out("About to query resources with name " + resName);
            Filter nameFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceLiterals.NAME.name(), resName);
            List<ResourceAttribute> resList = CRSFactoryImpl.getInstance().searchResources(CRSEntity.Type.ResourceInstance, nameFilter);
            if (resList.isEmpty()) {
                throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, resName);
            }
            HAVIPImpl havipImpl = new HAVIPImpl(resList.get(0));
            CRSResource crsRes = havipImpl.crsResource();
            return havipImpl;
        }
        catch (CRSException e) {
            throw new HAVIPException(e);
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException(e);
        }
    }

    public HAVIP getHAVIPbyAddress(String vipOrName) throws NotExistsException, HAVIPException {
        try {
            List<HAVIP> havipList = this.getHAVIPs();
            InetAddress inet = null;
            Map<IPAddressUtil.IPAddrType, InetAddress> vipMap = null;
            IPAddressUtil.IPAddrType inputAddrType = IPAddressUtil.getAddrTypeFromAddressOrName(vipOrName);
            if (inputAddrType == IPAddressUtil.IPAddrType.BOTH) {
                Map<IPAddressUtil.IPAddrType, List<InetAddress>> inputMap = IPAddressUtil.resolveHostname(vipOrName);
                InetAddress currentIPv4 = null;
                InetAddress currentIPv6 = null;
                InetAddress inputIPv4 = null;
                InetAddress inputIPv6 = null;
                for (HAVIP vip : havipList) {
                    vipMap = vip.addresses();
                    if (!vipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) || !vipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) continue;
                    currentIPv4 = vipMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                    currentIPv6 = vipMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                    inputIPv4 = inputMap.get((Object)IPAddressUtil.IPAddrType.IPv4).get(0);
                    inputIPv6 = inputMap.get((Object)IPAddressUtil.IPAddrType.IPv6).get(0);
                    if (!currentIPv4.equals(inputIPv4) || !currentIPv6.equals(inputIPv6)) continue;
                    Trace.out("havip exists for vipname " + vipOrName);
                    return vip;
                }
            } else {
                for (HAVIP vip : havipList) {
                    vipMap = vip.addresses();
                    if (!vipMap.containsKey((Object)inputAddrType)) continue;
                    inet = vipMap.get((Object)inputAddrType);
                    Trace.out("address passed is " + vipOrName);
                    if (!IPAddressUtil.sameIPAddresses(inet.getHostAddress(), vipOrName)) continue;
                    Trace.out("havip exists for address " + vipOrName);
                    return vip;
                }
            }
            throw new NotExistsException((MessageKey)PrCeMsgID.HAVIP_ADDRESS_NOT_EXIST, vipOrName);
        }
        catch (SoftwareModuleException sme) {
            throw new HAVIPException(sme);
        }
        catch (IPAddressException ipe) {
            throw new HAVIPException(ipe);
        }
    }

    public List<HAVIP> getHAVIPs() throws NotExistsException, HAVIPException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.HAVIP.NAME.toString()));
            if (resList.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.HAVIP.NAME.toString());
                throw new NotExistsException((MessageKey)PrCeMsgID.HAVIP_RES_NOT_EXIST, new Object[0]);
            }
            ArrayList<HAVIPImpl> vipList = new ArrayList<HAVIPImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                vipList.add(new HAVIPImpl(attr));
            }
            return Collections.unmodifiableList(vipList);
        }
        catch (CRSException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.HAVIP.NAME.toString());
        }
    }

    public List<ExportFS> getExportFSs() throws NotExistsException, ExportFSException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter expfilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceLiterals.TYPE.name(), ResourceLiterals.EXPORTFS.toString());
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.Resource, expfilter);
            if (resList.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.ExportFS.NAME.toString());
                throw new NotExistsException((MessageKey)PrCeMsgID.EXPORTFS_RES_NOT_EXIST, new Object[0]);
            }
            ArrayList<ExportFSImpl> expList = new ArrayList<ExportFSImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                expList.add(new ExportFSImpl(attr));
            }
            return Collections.unmodifiableList(expList);
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.ExportFS.NAME.toString());
        }
    }

    public List<ExportFS> getExportFSs(String id) throws NotExistsException, ExportFSException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter expfilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.ExportFS.getExportTypeName(id).toString());
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.Resource, expfilter);
            if (resList.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.ExportFS.getExportTypeName(id).toString());
                throw new NotExistsException((MessageKey)PrCeMsgID.EXPORTFS_RES_HAVIP_NOT_EXIST, id);
            }
            ArrayList<ExportFSImpl> expList = new ArrayList<ExportFSImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                expList.add(new ExportFSImpl(attr));
            }
            return Collections.unmodifiableList(expList);
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.GET_EXPORTFS_HAVIP_FAILED, (Throwable)e, id);
        }
    }

    public ExportFS createExportFS(String id, String expName, String exportPath, String clients, String expOptions, Version version, boolean ghExport) throws AlreadyExistsException, ExportFSException {
        return this.createExportFS(id, expName, exportPath, clients, expOptions, null, version, ghExport);
    }

    public ExportFS createExportFS(String id, String expName, String exportPath, String clients, String expOptions, ExportType expType, Version version, boolean ghExport) throws AlreadyExistsException, ExportFSException {
        if (null == id || id.trim().length() == 0) {
            throw new ExportFSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "id");
        }
        if (null == exportPath || exportPath.trim().length() == 0) {
            throw new ExportFSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "exportPath");
        }
        if (null == version) {
            throw new ExportFSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        if (null == expName) {
            throw new ExportFSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "expname");
        }
        boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
        if (exportPath != null && exportPath.trim().length() > 0) {
            File f = new File(exportPath);
            if (!f.isAbsolute()) {
                throw new ExportFSException((MessageKey)PrCcMsgID.PATH_IS_NOT_ABSOLUTE, exportPath);
            }
            if (isUnix) {
                Trace.out("Checking for existence of export path");
                if (!f.exists()) {
                    throw new ExportFSException((MessageKey)PrCcMsgID.PATH_NOT_EXISTS, exportPath);
                }
                if (!f.isDirectory()) {
                    throw new ExportFSException((MessageKey)PrCcMsgID.PATH_IS_NOT_DIR, exportPath);
                }
            }
        }
        try {
            ExportFS fs = this.getExportFS(expName);
            throw new AlreadyExistsException((MessageKey)PrCeMsgID.EXPORTFS_ALREADY_EXISTS, expName);
        }
        catch (NotExistsException fs) {
            String resourceName;
            if (expType != null) {
                Platform platform;
                Platform platform2 = platform = isUnix ? Platform.UNIX : Platform.WINDOWS;
                if (!platform.supportedExportTypes().contains((Object)expType)) {
                    Trace.out("Unsupported export type" + expType.getValue() + " for platform " + platform.getValue());
                    throw new ExportFSException((MessageKey)PrCcMsgID.UNSUPPORTED_EXPORT_TYPE, new Object[]{expType});
                }
            } else {
                expType = isUnix ? ExportType.NFS : ExportType.SMB;
            }
            try {
                resourceName = ResourceNames.getExportFSResourceName(expName);
                Trace.out("resourceName = " + resourceName);
            }
            catch (CRSException rne) {
                throw new ExportFSException(rne);
            }
            ExportFSImpl expImpl = null;
            try {
                Trace.out("Ready to create export filesystem");
                expImpl = new ExportFSImpl(CRSFactoryImpl.getInstance().create(ResourceType.ExportFS.NAME.name(), resourceName));
                expImpl.create(id, expName, exportPath, clients, expOptions, expType, version, ghExport);
            }
            catch (NotExistsException notExistsException) {
            }
            catch (CRSException e) {
                throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_CREATE_FAILED, (Throwable)e, resourceName);
            }
            return expImpl;
        }
    }

    public MountFS createMountFS(String mountPointPath, String name, String exportPath, String exportServer) throws AlreadyExistsException, MountFSException {
        MountFSArgs mtArgs = new MountFSArgs();
        try {
            mtArgs.setMountPointPath(mountPointPath);
            mtArgs.setMountFSName(name);
            mtArgs.setExportPath(exportPath);
            mtArgs.setExportServer(exportServer);
        }
        catch (MountFSException afse) {
            throw new MountFSException(afse);
        }
        return this.createMountFS(mtArgs);
    }

    public MountFS createMountFS(MountFSArgs mtArgs) throws AlreadyExistsException, MountFSException {
        String resourceName;
        String mountPoint = mtArgs.getMountPointPath();
        String name = mtArgs.getMountFSName().toLowerCase();
        String exportServer = mtArgs.getExportServer();
        String exportPath = mtArgs.getExportPath();
        String mountOptions = mtArgs.getMountOptions();
        String user = mtArgs.getUser();
        try {
            this.validateMountFS(mountPoint);
            this.validateExportServer(exportServer);
            resourceName = HANFSFactoryImpl.getNFSResourceName(name);
            Trace.out("resourceName = " + resourceName);
            Trace.out("Checking if MountFS name is in use");
            try {
                MountFS mtfs = this.getMountFSbyName(name);
                Trace.out("MountFS name '" + name + "' already registered");
                throw new AlreadyExistsException((MessageKey)PrCaMsgID.NFS_NAME_ALREADY_IN_USE, name);
            }
            catch (NotExistsException nee) {
                Trace.out("MountFS name is not in use");
            }
        }
        catch (CRSException rne) {
            throw new MountFSException(rne);
        }
        try {
            MountFSImpl mtfs = new MountFSImpl(CRSFactoryImpl.getInstance().create(ResourceType.MountFS.NAME.name(), resourceName));
            mtfs.create(mountPoint, exportPath, exportServer, user, mountOptions);
            return mtfs;
        }
        catch (CRSException rne) {
            throw new MountFSException(rne);
        }
    }

    public NetStorageService createNetStorageService(AsmClusterFileSystem acfs) throws AlreadyExistsException, NetStorageServiceException {
        if (acfs == null) {
            throw new NetStorageServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "acfs", acfs);
        }
        try {
            NFSServiceImpl nfss = new NFSServiceImpl(CRSFactoryImpl.getInstance().create(ResourceType.NetStorageService.NAME.name(), NFSServiceImpl.getResourceName()));
            nfss.create(acfs);
            return nfss;
        }
        catch (CRSException rne) {
            throw new NetStorageServiceException(rne);
        }
    }

    public MountFS getMountFS(String mountpointpath) throws NotExistsException, MountFSException {
        if (null == mountpointpath) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_INVALID_MTPOINT, new Object[0]);
        }
        try {
            CRSFactoryImpl crsFactory = null;
            String[] attrNames = new String[]{ResourceLiterals.TYPE.name(), ResourceType.MountFS.MOUNTPOINT_PATH.name()};
            String[] attrValues = new String[]{ResourceType.MountFS.NAME.toString(), mountpointpath};
            crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources_matchAll(attrNames, attrValues);
            if (resList != null && resList.size() > 0) {
                Trace.out("Resource found");
                ResourceAttribute resource = resList.get(0);
                return new MountFSImpl(resource);
            }
            throw new NotExistsException((MessageKey)PrCaMsgID.NFS_RES_NOT_EXIST, mountpointpath);
        }
        catch (CRSException crse) {
            throw new MountFSException(crse);
        }
    }

    public MountFS getMountFSbyName(String resName) throws NotExistsException, MountFSException {
        if (null == resName || resName.trim().length() == 0) {
            throw new MountFSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "resName");
        }
        try {
            MountFSImpl mtfsImpl = new MountFSImpl(CRSFactoryImpl.getInstance().create(ResourceType.MountFS.NAME.name(), MountFSImpl.getResourceName(resName)));
            CRSResource crsRes = mtfsImpl.crsResource();
            return mtfsImpl;
        }
        catch (CRSException e) {
            throw new MountFSException(e);
        }
        catch (SoftwareModuleException e) {
            throw new MountFSException(e);
        }
    }

    public NetStorageService getNetStorageService() throws NotExistsException, NetStorageServiceException {
        try {
            NFSServiceImpl nssImpl = new NFSServiceImpl(CRSFactoryImpl.getInstance().create(ResourceType.NetStorageService.NAME.name(), NFSServiceImpl.getResourceName()));
            CRSResource crsRes = nssImpl.crsResource();
            return nssImpl;
        }
        catch (SoftwareModuleException | CRSException e) {
            throw new NetStorageServiceException(e);
        }
    }

    public List<MountFS> getMountFSList() throws NotExistsException, MountFSException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.MountFS.NAME.toString()));
            ArrayList<MountFSImpl> mtfsList = new ArrayList<MountFSImpl>(resList.size());
            for (ResourceAttribute attr : resList) {
                mtfsList.add(new MountFSImpl(attr));
            }
            return Collections.unmodifiableList(mtfsList);
        }
        catch (CRSException e) {
            throw new MountFSException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceType.MountFS.NAME.toString());
        }
    }

    public MountFS getMountFSbyPath(String path) throws NotExistsException, MountFSException {
        try {
            if (path.length() > 1 && path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            int index = 0;
            boolean firstPass = true;
            String aux_mtp = path;
            while (true) {
                if (!firstPass) {
                    index = aux_mtp.lastIndexOf(File.separator);
                    if (index == 0 && aux_mtp.length() >= 1) {
                        aux_mtp = aux_mtp.substring(0, index + 1);
                    } else if (index > 0) {
                        aux_mtp = aux_mtp.substring(0, index);
                    }
                }
                try {
                    Trace.out("Checking mount point:" + aux_mtp);
                    return this.getMountFS(aux_mtp);
                }
                catch (NotExistsException nee) {
                    Trace.out("No MountFS resource for " + aux_mtp);
                    firstPass = false;
                    if (index > 0) continue;
                    Trace.out("No parent found");
                    throw new NotExistsException((MessageKey)PrCaMsgID.NFS_RES_NOT_EXIST, path);
                }
                break;
            }
        }
        catch (SoftwareModuleException sme) {
            throw new MountFSException(sme);
        }
    }

    public void upgradeExportFS12101To12102LastPhase() throws UpgradeException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            crsFactory.upgradeType(ResourceType.ExportFS.class);
            HashMap<String, ResourceAttribute> attrMap = null;
            List<ExportFS> exportList = null;
            try {
                exportList = this.getExportFSs();
            }
            catch (NotExistsException nee) {
                Trace.out("No ExportFS resources found to upgrade");
                return;
            }
            if (exportList.size() > 0 && exportList != null) {
                attrMap = new HashMap<String, ResourceAttribute>();
                attrMap.put(ResourceType.LocalResource.START_DEPENDENCIES.name(), crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ""));
                for (ExportFS export : exportList) {
                    ResourceAttribute exportAttr;
                    CRSResourceImpl res = (CRSResourceImpl)export.crsResource();
                    ResourceAttribute startDep = res.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
                    boolean success = ResourceDependency.updateDependencyAttr(startDep, exportAttr = crsFactory.create(ResourceType.ExportFS.NAME.name(), ResourceType.ExportFS.NAME.toString()), ResourceDependency.DepType.DISPERSION_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, true);
                    if (!success) {
                        throw new UpgradeException((MessageKey)PrCaMsgID.EXPORTFS_UPGRADE_FAILED, Version.VersionEnum.V12101.toString(), Version.VersionEnum.V12102.toString());
                    }
                    Trace.out("Updated start dependencies: " + startDep.getValue());
                    ((ResourceAttribute)attrMap.get(ResourceType.LocalResource.START_DEPENDENCIES.name())).setValue(startDep.getValue());
                    ResourceAttribute[] attrArr = attrMap.values().toArray(new ResourceAttribute[attrMap.size()]);
                    if (attrArr.length <= 0) continue;
                    CRSResourceImpl crsResImpl = (CRSResourceImpl)export.crsResource();
                    crsResImpl.update(attrArr);
                }
            }
        }
        catch (CRSException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.EXPORTFS_UPGRADE_FAILED, (Throwable)e, Version.VersionEnum.V12101.toString(), Version.VersionEnum.V12102.toString());
        }
        catch (ExportFSException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.EXPORTFS_UPGRADE_FAILED, (Throwable)e, Version.VersionEnum.V12101.toString(), Version.VersionEnum.V12102.toString());
        }
        catch (NotExistsException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.EXPORTFS_UPGRADE_FAILED, (Throwable)e, Version.VersionEnum.V12101.toString(), Version.VersionEnum.V12102.toString());
        }
        catch (SoftwareModuleException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.EXPORTFS_UPGRADE_FAILED, (Throwable)e, Version.VersionEnum.V12101.toString(), Version.VersionEnum.V12102.toString());
        }
    }

    public void upgradeHAVIP12101To122LastPhase() throws UpgradeException {
        try {
            List<HAVIP> havipList = this.getHAVIPs();
            String userId = null;
            ResourceAttribute idAttr = null;
            for (HAVIP vip : havipList) {
                userId = vip.getUserAssignedName();
                CRSResourceImpl res = (CRSResourceImpl)vip.crsResource();
                idAttr = res.getAttribute(ResourceType.HAVIP.HAVIP_ID.name());
                idAttr.setValue(userId);
                res.update(idAttr);
            }
        }
        catch (CRSException | HAVIPException e) {
            throw new UpgradeException((MessageKey)PrCaMsgID.HAVIP_UPGRADE_FAILED, (Throwable)e, Version.VersionEnum.V12102.toString(), Version.VersionEnum.V12200.toString());
        }
        catch (NotExistsException nee) {
            Trace.out("No HAVIP resources configured, not an error for upgrade");
        }
    }

    public ExportFS getExportFS(String expname) throws NotExistsException, ExportFSException {
        try {
            ExportFSImpl expfsImpl = new ExportFSImpl(CRSFactoryImpl.getInstance().create(ResourceType.ExportFS.NAME.name(), ExportFSImpl.getResourceName(expname)), false);
            return expfsImpl;
        }
        catch (CRSException e) {
            throw new ExportFSException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ExportFSException(e);
        }
    }

    public void startExportFSforHAVIP(String id) throws ExportFSException, AlreadyRunningException, CompositeOperationException {
        try {
            Filter expFilter = this.getFilter(id);
            CRSFactoryImpl.startResources(expFilter, false, null, null);
        }
        catch (CRSException ce) {
            throw new ExportFSException(ce);
        }
    }

    public void stopExportFSforHAVIP(String id, boolean force) throws ExportFSException, AlreadyStoppedException, CompositeOperationException {
        try {
            Filter expFilter = this.getFilter(id);
            CRSFactoryImpl.stopResources(expFilter, force, false, null);
        }
        catch (CRSException ce) {
            throw new ExportFSException(ce);
        }
    }

    public void startExportFSforHAVIP(String id, ExportType exportType) throws ExportFSException, AlreadyRunningException, CompositeOperationException {
        try {
            exportType = exportType != null ? exportType : ExportType.NFS;
            Filter expFilter = this.getFilter(id, exportType);
            CRSFactoryImpl.startResources(expFilter, false, null, null);
        }
        catch (CRSException ce) {
            throw new ExportFSException(ce);
        }
    }

    public void stopExportFSforHAVIP(String id, ExportType exportType, boolean force) throws ExportFSException, AlreadyStoppedException, CompositeOperationException {
        try {
            exportType = exportType != null ? exportType : ExportType.NFS;
            Filter expFilter = this.getFilter(id, exportType);
            CRSFactoryImpl.stopResources(expFilter, force, false, null);
        }
        catch (CRSException ce) {
            throw new ExportFSException(ce);
        }
    }

    private Filter getFilter(String id) throws CRSException {
        return this.getFilter(id, null);
    }

    private Filter getFilter(String id, ExportType exportType) throws CRSException {
        exportType = exportType != null ? exportType : ExportType.NFS;
        Filter expFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.ExportFS.getExportTypeName(id.toLowerCase()));
        Trace.out("Adding export type to ExportFS filter");
        Filter typeFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.ExportFS.EXPORT_TYPE.name(), exportType.getValue());
        expFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, expFilter, typeFilter);
        return expFilter;
    }

    private Filter getMountFSbyPathFilter(String path) throws CRSException {
        Filter mFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE_ATTR.toString(), ResourceLiterals.MOUNTFS_TYPE.toString());
        Trace.out("Adding path to the filter");
        Filter pathFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.MountFS.MOUNTPOINT_PATH.name(), path);
        mFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, mFilter, pathFilter);
        return mFilter;
    }

    public void validateMountFS(String mountPointPath) throws MountFSException {
        Trace.out("Starting NFS mount point validation");
        if (mountPointPath == null || mountPointPath.length() == 0) {
            throw new MountFSException((MessageKey)PrCaMsgID.NFS_INVALID_MTPOINT, new Object[0]);
        }
        try {
            Trace.out("Checking if path is of ACFS type");
            OFSUtil acfsUtil = new OFSUtil(new Util().getCRSHome());
            if (acfsUtil.isOFSPartition(mountPointPath)) {
                Trace.out("ACFS resource uses mount point path");
                throw new MountFSException((MessageKey)PrCaMsgID.NFS_MOUNTPOINT_IN_USE, mountPointPath);
            }
        }
        catch (CmdToolUtilException cmde) {
            Trace.out(cmde.getMessage());
        }
        catch (UtilException ue) {
            throw new MountFSException(ue);
        }
    }

    public boolean isPathOnMountFS(String path) throws MountFSException {
        try {
            return this.getMountFSbyPath(path) != null;
        }
        catch (NotExistsException nee) {
            return false;
        }
    }

    public void validateExportServer(String addressOrName) throws MountFSException {
        try {
            boolean isReachable = false;
            Trace.out("Starting ip address or hostname validation");
            InetAddress inetAddress = InetAddress.getByName(addressOrName);
        }
        catch (UnknownHostException uhe) {
            Trace.out("Host does not exist");
            Trace.out(uhe.getMessage());
            throw new MountFSException((MessageKey)PrCaMsgID.EXPORTSERVER_CHECK_FAILED, addressOrName);
        }
        catch (IOException ioe) {
            Trace.out("Network error");
            throw new MountFSException(ioe);
        }
    }

    public static String getNFSResourceName(String name) throws CRSException {
        if (name == null || name.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "MountFS name");
        }
        return "ora." + name.toLowerCase() + '.' + (Object)((Object)ResourceLiterals.MOUNTFS);
    }
}

