/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.hanfs;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.hanfs.ExportFS;
import oracle.cluster.hanfs.ExportFSArgs;
import oracle.cluster.hanfs.ExportFSException;
import oracle.cluster.hanfs.ExportType;
import oracle.cluster.hanfs.HANFSFactory;
import oracle.cluster.hanfs.HAVIP;
import oracle.cluster.hanfs.NetStorageService;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceNames;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.hanfs.HANFSFactoryImpl;
import oracle.cluster.impl.hanfs.HAVIPImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCeMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;

public class ExportFSImpl
extends SoftwareModuleImpl
implements ExportFS {
    private ResourceAttribute m_nameAttr;

    ExportFSImpl(ResourceAttribute nameAttr) throws ExportFSException, NotExistsException {
        this(nameAttr, true);
    }

    ExportFSImpl(ResourceAttribute nameAttr, boolean ignoreIfNotExist) throws ExportFSException, NotExistsException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ExportFS.NAME.name())) {
            throw new ExportFSException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceType.ExportFS.NAME.name(), nameAttr.getName());
        }
        Trace.out("value of attribute = " + nameAttr.getValue());
        String displayName = ExportFSImpl.getUserAssignedNames(nameAttr.getValue());
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = displayName;
        Trace.out("m_name = " + this.m_name + ", m_displayName = " + this.m_displayName);
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
        }
        catch (NotExistsException nee) {
            if (!ignoreIfNotExist) {
                throw nee;
            }
        }
        catch (CRSException e) {
            throw new ExportFSException(e);
        }
    }

    public void create(String id, String expName, String expPath, String expClients, String expOptions, ExportType expType, Version version, boolean ghExport) throws AlreadyExistsException, ExportFSException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new ExportFSException(e);
        }
        if (null == expClients && expType != ExportType.SMB) {
            try {
                HANFSFactoryImpl hanfsfactImpl = HANFSFactoryImpl.getInstance();
                HAVIP havip = hanfsfactImpl.getHAVIP(id);
                Map<IPAddressUtil.IPAddrType, InetAddress> havipMap = havip.addresses();
                Subnet subnetw = null;
                Network netw = havip.network();
                if (havipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                    Trace.out("HAVIP Address is IPv4");
                    subnetw = netw.subnet();
                    expClients = subnetw.getName() + "/" + subnetw.getSubnetPrefix();
                }
                if (havipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                    Trace.out("HAVIP Address is IPv6");
                    subnetw = netw.subnet_ipv6();
                    expClients = expClients != null ? expClients + "," + subnetw.getName() + "/" + subnetw.getSubnetPrefix() : subnetw.getName() + "/" + subnetw.getSubnetPrefix();
                }
                Trace.out("Default expClients = " + expClients);
            }
            catch (SoftwareModuleException sme) {
                throw new ExportFSException(sme);
            }
            catch (NotExistsException nee) {
                throw new ExportFSException(nee);
            }
        }
        if (ghExport) {
            this.internalValidatePathClientsHavip(expPath, expClients, id, null, expType, false);
        } else {
            this.internalValidatePathClientsHavip(expPath, expClients, id, null, expType, true);
        }
        try {
            String expCanonicalpath = null;
            AsmClusterFileSystem acfs = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute expfsTypeAttr = crsFactory.create(ResourceType.ExportFS.NAME.name(), ResourceType.ExportFS.getExportTypeName(id.toLowerCase()));
            ResourceAttribute expfsAttr = crsFactory.create(ResourceType.ExportFS.NAME.name(), ResourceType.ExportFS.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(expfsTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.ExportFS.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ExportFS.EXPORT_PATH.name())) {
                    if (!new File(expPath).isAbsolute()) {
                        throw new ExportFSException((MessageKey)PrCeMsgID.INVALID_EXPORT_PATH, expPath);
                    }
                    File exportPath = new File(expPath);
                    expCanonicalpath = exportPath.getCanonicalPath();
                    Trace.out("export path in canonical form is " + expCanonicalpath);
                    acfs = this.findACFS(expCanonicalpath);
                    if (acfs != null) {
                        attr.setValue(expCanonicalpath);
                        continue;
                    }
                    Trace.out("Export path " + expPath + " does not resolve to an ACFS resource");
                    throw new ExportFSException((MessageKey)PrCeMsgID.ACFS_NOT_EXIST, expPath);
                }
                if (expOptions != null && attr.getName().equalsIgnoreCase(ResourceType.ExportFS.EXPORT_OPTIONS.name())) {
                    attr.setValue(expOptions);
                    continue;
                }
                if (expClients != null && attr.getName().equalsIgnoreCase(ResourceType.ExportFS.EXPORT_CLIENTS.name())) {
                    attr.setValue(expClients);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.ExportFS.EXPORT_TYPE.name())) {
                    attr.setValue(expType.getValue());
                    continue;
                }
                if (!ghExport || !attr.getName().equalsIgnoreCase(ResourceType.ExportFS.GH_CREATED.name())) continue;
                attr.setValue("1");
            }
            Trace.out("Adding Version attribute");
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            for (ResourceAttribute dependency : this.generateExportDependencies(acfs, id)) {
                attrList.add(dependency);
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.ROOT);
            Trace.out("Successfully created exportfs filesystem resource");
            Trace.out("updating the associated HAVIP dependencies");
            HANFSFactoryImpl hanfsfactImpl = HANFSFactoryImpl.getInstance();
            HAVIP havip = hanfsfactImpl.getHAVIP(id);
            Network netw = havip.network();
            HAVIPImpl.setHAVIPdeps(id, netw);
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCeMsgID.EXPORTFS_ALREADY_EXISTS, (Throwable)e, new Object[0]);
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
        catch (SoftwareModuleException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
        catch (NotExistsException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
        catch (IOException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public String getExportPath() throws ExportFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.ExportFS.EXPORT_PATH.name()).getValue();
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.GET_EXPORTPATH_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public String getExportOptions() throws ExportFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.ExportFS.EXPORT_OPTIONS.name()).getValue();
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.GET_EXPORTOPTIONS_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public String getExportClients() throws ExportFSException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.ExportFS.EXPORT_CLIENTS.name()).getValue();
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.GET_EXPORTCLIENTS_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void setExportPath(String exportPath) throws ExportFSException {
        if (!new File(exportPath).isAbsolute()) {
            throw new ExportFSException((MessageKey)PrCeMsgID.INVALID_EXPORT_PATH, exportPath);
        }
        this.internalValidatePathClientsHavip(exportPath, this.getExportClients(), this.getHAVIPid(), null, this.getExportType(), true);
        try {
            exportPath = new File(exportPath).getCanonicalPath();
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ExportFS.EXPORT_PATH.name(), exportPath));
        }
        catch (IOException ioe) {
            throw new ExportFSException((MessageKey)PrCeMsgID.INVALID_CANONICAL_PATH, (Throwable)ioe, exportPath);
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.SET_EXPORTPATH_FAILED, (Throwable)e, exportPath, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void setExportOptions(String exportOptions) throws ExportFSException {
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ExportFS.EXPORT_OPTIONS.name(), exportOptions));
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.SET_EXPORTOPTIONS_FAILED, (Throwable)e, exportOptions, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void setExportClients(String exportClients) throws ExportFSException {
        this.internalValidatePathClientsHavip(this.getExportPath(), exportClients, this.getHAVIPid(), null, this.getExportType(), false);
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ExportFS.EXPORT_CLIENTS.name(), exportClients));
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.SET_EXPORTCLIENTS_FAILED, (Throwable)e, exportClients, this.m_nameAttr.getValue());
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, ExportFSException {
        try {
            Trace.out("calling parent's crsResource");
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ExportFSException(e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ExportFSException {
        String havipid = null;
        try {
            havipid = this.getHAVIPid();
            super.remove(force);
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute havipAttr = crsFactory.create(ResourceType.HAVIP.NAME.name(), HAVIPImpl.getResourceName(havipid));
            if (!crsFactory.isRegistered(havipAttr.getValue(), CRSEntity.Type.Resource)) {
                Trace.out("Havip " + havipid + " does not exist");
            } else {
                Trace.out("updating the havip dependencies after export resource remove");
                HANFSFactoryImpl hanfsfactImpl = HANFSFactoryImpl.getInstance();
                HAVIP havip = hanfsfactImpl.getHAVIP(havipid);
                Network netw = havip.network();
                HAVIPImpl.setHAVIPdeps(havipid, netw);
            }
        }
        catch (SoftwareModuleException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_REMOVE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
        catch (CRSException ce) {
            throw new ExportFSException(ce);
        }
        catch (NotExistsException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_REMOVE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    public static String getResourceName(String expname) throws CRSException {
        return ResourceNames.getExportFSResourceName(expname);
    }

    @Override
    public String getHAVIPid() throws ExportFSException {
        String havipid = null;
        try {
            String exptype = this.m_crsResource.getAttribute(ResourceLiterals.TYPE.name()).getValue();
            Trace.out("The type value is " + exptype);
            String[] tokens = exptype.trim().split(Pattern.quote(String.valueOf('.')));
            Trace.out("length is " + tokens.length);
            if (tokens.length < 3) {
                throw new ExportFSException((MessageKey)PrCeMsgID.HAVIP_RES_NOT_EXIST, new Object[0]);
            }
            havipid = tokens[1].trim();
            Trace.out("The havip id is " + havipid);
        }
        catch (CRSException crse) {
            throw new ExportFSException(crse);
        }
        return havipid;
    }

    @Override
    public ExportType getExportType() throws ExportFSException {
        try {
            String type = this.m_crsResource.getAttribute(ResourceType.ExportFS.EXPORT_TYPE.name()).getValue();
            return ExportType.getMember(type);
        }
        catch (CRSException crse) {
            throw new ExportFSException(crse);
        }
    }

    public static final String getUserAssignedNames(String expResName) throws ExportFSException {
        if (expResName == null || expResName.trim().length() == 0) {
            throw new ExportFSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "expResName");
        }
        boolean validName = expResName.indexOf(46, expResName.indexOf(46) + 1) != -1;
        String[] values = new String[3];
        if (validName) {
            values[0] = expResName.substring(0, expResName.indexOf(46) + 1);
            values[1] = expResName.substring(expResName.indexOf(46) + 1, expResName.lastIndexOf(46));
            values[2] = expResName.substring(expResName.lastIndexOf(46) + 1, expResName.length());
            validName &= "ora.".equalsIgnoreCase(values[0]);
            validName &= ResourceLiterals.EXPORTFS.toString().equalsIgnoreCase(values[values.length - 1]);
        }
        if (!validName) {
            Trace.out("splitResourceName invalid user Assigned Name");
            throw new ExportFSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ExportFS.NAME.name(), expResName);
        }
        return values[1];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ExportFSImpl fs = (ExportFSImpl)obj;
        return this.m_name != null && this.m_name.equals(fs.getName());
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : super.hashCode();
    }

    private AsmClusterFileSystem findACFS(String exppath) throws ExportFSException {
        OFSUtil ofsutil = null;
        String mtpoint = null;
        AsmClusterFileSystem acfs = null;
        String volDevice = "";
        try {
            Trace.out("Export path passed is " + exppath);
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            ofsutil = nativeSystem.isUnixSystem() ? new OFSUtil() : new OFSUtil(new Util().getCRSHome() + File.separator + "bin");
            mtpoint = ofsutil.getMountpoint(exppath);
            if (mtpoint != null) {
                volDevice = ofsutil.getVolumeDevice(mtpoint);
                ASMFactoryImpl asmfactImpl = ASMFactoryImpl.getInstance();
                acfs = asmfactImpl.getAsmClusterFileSystem(volDevice, new Util().getCRSHome());
                CRSResource crsRes = acfs.crsResource();
                ResourceAttribute attr = ((CRSResourceImpl)crsRes).getAttribute(ResourceLiterals.TYPE.name());
                if (attr.getValue().equals(ResourceLiterals.CLUSTER_ACFS_TYPE.toString())) {
                    throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_INVALID_ACFS, exppath);
                }
            }
            return acfs;
        }
        catch (NotExistsException e) {
            throw new ExportFSException(e);
        }
        catch (CmdToolUtilException e) {
            throw new ExportFSException(e);
        }
        catch (UtilException e) {
            throw new ExportFSException(e);
        }
        catch (AsmClusterFileSystemException e) {
            throw new ExportFSException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ExportFSException(e);
        }
        catch (CRSException e) {
            throw new ExportFSException(e);
        }
    }

    @Override
    public void modify(ExportFSArgs expFSArgs) throws ExportFSException {
        String exportPath = expFSArgs.getExportPath();
        String exportOptions = expFSArgs.getExportOptions();
        String exportClients = expFSArgs.getExportClients();
        String havipId = this.getHAVIPid();
        if (null != exportPath && null != exportClients) {
            this.internalValidatePathClientsHavip(exportPath, exportClients, havipId, null, this.getExportType(), true);
        } else if (null != exportPath) {
            this.internalValidatePathClientsHavip(exportPath, this.getExportClients(), havipId, null, this.getExportType(), true);
        } else if (null != exportClients) {
            this.internalValidatePathClientsHavip(this.getExportPath(), exportClients, havipId, null, this.getExportType(), false);
        }
        try {
            ResourceAttribute attr;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            if (null != exportOptions) {
                attr = this.m_crsResource.getAttribute(ResourceType.ExportFS.EXPORT_OPTIONS.name());
                attr.setValue(exportOptions);
                attrList.add(attr);
            }
            if (null != exportPath) {
                String expCanonicalPath = null;
                File exportPathFile = new File(exportPath);
                if (!exportPathFile.isAbsolute()) {
                    throw new ExportFSException((MessageKey)PrCeMsgID.INVALID_EXPORT_PATH, exportPath);
                }
                expCanonicalPath = exportPathFile.getCanonicalPath();
                Trace.out("export path in canonical form is " + expCanonicalPath);
                AsmClusterFileSystem acfs = this.findACFS(expCanonicalPath);
                if (acfs != null) {
                    attr = this.m_crsResource.getAttribute(ResourceType.ExportFS.EXPORT_PATH.name());
                    attr.setValue(exportPath);
                    attrList.add(attr);
                    for (ResourceAttribute dependency : this.generateExportDependencies(acfs, havipId)) {
                        attrList.add(dependency);
                    }
                } else {
                    Trace.out("Export path " + exportPath + " does not resolve to an ACFS resource");
                    throw new ExportFSException((MessageKey)PrCeMsgID.ACFS_NOT_EXIST, exportPath);
                }
            }
            if (null != exportClients) {
                attr = this.m_crsResource.getAttribute(ResourceType.ExportFS.EXPORT_CLIENTS.name());
                attr.setValue(exportClients);
                attrList.add(attr);
            }
            Trace.out("Changing attributes of Exportfs");
            if (!attrList.isEmpty()) {
                this.m_crsResource.update(attrList);
            }
        }
        catch (AlreadyExistsException aee) {
            throw new ExportFSException(aee);
        }
        catch (NotExistsException nee) {
            throw new ExportFSException(nee);
        }
        catch (CRSException crse) {
            throw new ExportFSException(crse);
        }
        catch (IOException ioe) {
            throw new ExportFSException((MessageKey)PrCeMsgID.INVALID_CANONICAL_PATH, (Throwable)ioe, exportPath);
        }
    }

    @Override
    public void validateExportFSHomeNode(String homeNode) throws ExportFSException {
        this.internalValidatePathClientsHavip(this.getExportPath(), this.getExportClients(), this.getHAVIPid(), homeNode, null, false);
    }

    private void internalValidatePathClientsHavip(String expPath, String expClients, String havipId, String homeNode, ExportType expType, boolean validateNested) throws ExportFSException {
        try {
            List<ResourceAttribute> resList;
            Filter filterClause;
            Filter pathFilter;
            if (expClients != null && !expClients.isEmpty() && expType == ExportType.SMB) {
                Trace.out("Clients option provided for a CIFS export: " + expClients);
                throw new ExportFSException((MessageKey)PrCcMsgID.UNSUPPORTED_CLIENTS_CIFS, new Object[0]);
            }
            if (!new File(expPath).isAbsolute()) {
                throw new ExportFSException((MessageKey)PrCeMsgID.INVALID_EXPORT_PATH, expPath);
            }
            expPath = new File(expPath).getCanonicalPath();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter expFilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceLiterals.TYPE.name(), ResourceLiterals.EXPORTFS.toString());
            if (validateNested && !DeterminePlatform.getOSName().equals("Linux")) {
                ExportFSImpl expFs;
                Filter nqFilter;
                String expPathParent = expPath;
                if (expPathParent.length() > 1 && expPathParent.endsWith(File.separator)) {
                    expPathParent = expPathParent.substring(0, expPathParent.length() - 1);
                }
                int index = 0;
                ArrayList<String> paths = new ArrayList<String>();
                do {
                    if ((index = expPathParent.lastIndexOf(File.separator)) > 0) {
                        expPathParent = expPathParent.substring(0, index);
                    } else if (index == 0) {
                        expPathParent = expPathParent.substring(0, index + 1);
                    }
                    paths.add(expPathParent);
                } while (index > 0);
                pathFilter = crsFactory.getORFilter(ResourceType.ExportFS.EXPORT_PATH.name(), Filter.Comparator.EQ, paths.toArray(new String[paths.size()]));
                Filter childFilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceType.ExportFS.EXPORT_PATH.name(), expPath.charAt(expPath.length() - 1) == File.separatorChar ? expPath : expPath + File.separator);
                Filter andFilter = crsFactory.getFilter(Filter.Operator.AND, childFilter, nqFilter = crsFactory.getFilter(Filter.Comparator.NOT_EQ, ResourceType.ExportFS.EXPORT_PATH.name(), expPath));
                Filter orFilter = crsFactory.getFilter(Filter.Operator.OR, andFilter, pathFilter);
                filterClause = crsFactory.getFilter(Filter.Operator.AND, expFilter, orFilter);
                resList = crsFactory.searchResources(CRSEntity.Type.Resource, filterClause);
                if (resList.size() > 0 && !(expFs = new ExportFSImpl(resList.get(0))).getName().equals(this.getName())) {
                    if (expFs.getExportPath().length() < expPath.length()) {
                        throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_NESTED, expPath, expFs.getUserAssignedName());
                    }
                    throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_PARENT, expPath, expFs.getUserAssignedName());
                }
            }
            pathFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ExportFS.EXPORT_PATH.name(), expPath);
            filterClause = crsFactory.getFilter(Filter.Operator.AND, expFilter, pathFilter);
            Trace.out("validatepath filter :" + filterClause.toString());
            resList = crsFactory.searchResources(CRSEntity.Type.Resource, filterClause);
            if (resList.size() == 0) {
                return;
            }
            HANFSFactory nfsFac = HANFSFactory.getInstance();
            if (null == expClients) {
                expClients = "";
            }
            List<String> expClientList = Arrays.asList(expClients.split(Pattern.quote(String.valueOf(","))));
            boolean equalClient = false;
            String expClientStr = null;
            for (ResourceAttribute attr : resList) {
                ExportFSImpl curExpFs = new ExportFSImpl(attr);
                if (curExpFs.getName().equals(this.getName())) continue;
                List<String> curClientList = Arrays.asList(curExpFs.getExportClients().split(Pattern.quote(String.valueOf(","))));
                block9: for (int i = 0; i < expClientList.size() && !equalClient; ++i) {
                    expClientStr = expClientList.get(i);
                    for (String curClientStr : curClientList) {
                        try {
                            if (!InetAddress.getByName(expClientStr).equals(InetAddress.getByName(curClientStr))) continue;
                            equalClient = true;
                        }
                        catch (UnknownHostException uhe) {
                            if (!expClientStr.trim().equals(curClientStr.trim())) continue;
                            equalClient = true;
                        }
                        continue block9;
                    }
                }
                if (!equalClient) continue;
                if (null == homeNode) {
                    HAVIP havip = nfsFac.getHAVIP(havipId);
                    homeNode = havip.getHomeNode();
                }
                HAVIP curHavip = nfsFac.getHAVIP(curExpFs.getHAVIPid());
                String curHomeNode = curHavip.getHomeNode();
                boolean sameHomeNode = false;
                if (homeNode.length() > 0 && homeNode.equals(curHavip.getHomeNode())) {
                    sameHomeNode = true;
                }
                if (homeNode.length() == 0 || !DeterminePlatform.getOSName().equals("Linux")) {
                    if (expClients.trim().length() == 0) {
                        throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_PATH_CONFIGURED, expPath, curExpFs.getUserAssignedName());
                    }
                    throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_PATH_CONFIGURED_OPTIONS, expPath, expClientStr, curExpFs.getUserAssignedName());
                }
                if (curHomeNode.length() != 0 && !sameHomeNode) continue;
                throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_PATH_CONFIGURED_HAVIP, this.getUserAssignedName(), expPath, curExpFs.getUserAssignedName(), curHavip.getUserAssignedName());
            }
        }
        catch (SoftwareModuleException sme) {
            throw new ExportFSException(sme);
        }
        catch (NotExistsException nee) {
            Trace.out("Checking ExportFS Path: Could not get the list of ExportFS");
        }
        catch (IOException ioe) {
            throw new ExportFSException((MessageKey)PrCeMsgID.INVALID_CANONICAL_PATH, (Throwable)ioe, expPath);
        }
        catch (CRSException e) {
            throw new ExportFSException(e);
        }
    }

    void setNetworkStorageServiceDependency() throws ExportFSException {
        try {
            boolean netStorageExists = false;
            NetStorageService nss = null;
            try {
                nss = HANFSFactory.getInstance().getNetStorageService();
                netStorageExists = true;
            }
            catch (NotExistsException notAnError) {
                Trace.out("NetStorageService resource does not exist");
            }
            if (netStorageExists) {
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>(2);
                ResourceAttribute nssAttr = crsFactory.create(ResourceType.NetStorageService.NAME.name(), nss.getName());
                ResourceAttribute startDep = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
                ResourceDependency.updateDependency(startDep, nssAttr, ResourceDependency.DepType.HARD_DEP, true);
                ResourceDependency.updateDependency(startDep, nssAttr, ResourceDependency.DepType.PULLUP_DEP, true);
                Trace.out("New START_DEPENDENCY=" + startDep.getValue());
                ResourceAttribute stopDep = this.m_crsResource.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
                ResourceDependency.updateDependency(stopDep, nssAttr, ResourceDependency.DepType.HARD_DEP, true);
                Trace.out("New STOP_DEPENDENCY=" + stopDep.getValue());
                attrList.add(startDep);
                attrList.add(stopDep);
                this.m_crsResource.update(attrList);
            }
        }
        catch (SoftwareModuleException | CRSException e) {
            throw new ExportFSException(e);
        }
        catch (AlreadyExistsException ae) {
            Trace.out("Start and stop dependencies were already set correctly");
        }
    }

    private List<ResourceAttribute> generateExportDependencies(AsmClusterFileSystem acfs, String id) throws NotExistsException, ExportFSException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>(2);
            ResourceAttribute acfsAttr = crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfs.getName());
            ResourceAttribute exportAttr = crsFactory.create(ResourceType.ExportFS.NAME.name(), ResourceType.ExportFS.NAME.toString());
            ResourceDependency hardDep = crsFactory.createResourceDependency(acfsAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            Trace.out("hardDep = " + ResourceDependency.toString(hardDep));
            ResourceDependency pullupDep = crsFactory.createResourceDependency(acfsAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            Trace.out("pullupDep = " + ResourceDependency.toString(pullupDep));
            HANFSFactoryImpl hanfsfactImpl = HANFSFactoryImpl.getInstance();
            HAVIP havip = hanfsfactImpl.getHAVIP(id);
            ResourceDependency attractDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.HAVIP.NAME.name(), havip.getName()), ResourceDependency.DepType.ATTRACTION_DEP, new ResourceDependency.DepModifier[0]);
            Trace.out("attractDep = " + ResourceDependency.toString(attractDep));
            ResourceDependency dispersionDep = crsFactory.createResourceDependency(exportAttr, ResourceDependency.DepType.DISPERSION_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            Trace.out("dispersionDep = " + ResourceDependency.toString(dispersionDep));
            boolean netStorageExists = false;
            NetStorageService nss = null;
            ResourceDependency hardDep2 = null;
            try {
                nss = HANFSFactory.getInstance().getNetStorageService();
                netStorageExists = true;
            }
            catch (NotExistsException notExistsException) {
                // empty catch block
            }
            if (netStorageExists) {
                ResourceAttribute nssAttr = crsFactory.create(ResourceType.NetStorageService.NAME.name(), nss.getName());
                hardDep2 = crsFactory.createResourceDependency(nssAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                ResourceDependency pullupDep2 = crsFactory.createResourceDependency(nssAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep, pullupDep, hardDep2, pullupDep2, attractDep, dispersionDep)));
            } else {
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep, pullupDep, attractDep, dispersionDep)));
            }
            ResourceDependency stopDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfs.getName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            Trace.out("stopDep = " + ResourceDependency.toString(stopDep));
            if (netStorageExists) {
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(stopDep, hardDep2)));
            } else {
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(stopDep)));
            }
            return attrList;
        }
        catch (CRSException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
        catch (SoftwareModuleException e) {
            throw new ExportFSException((MessageKey)PrCeMsgID.EXPORTFS_RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }
}

