/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome.credentials;

import java.util.UUID;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.gridhome.credentials.Credentials;
import oracle.cluster.gridhome.credentials.CredentialsException;
import oracle.cluster.impl.gridhome.credentials.CredNative;
import oracle.cluster.impl.gridhome.credentials.CredNativeException;
import oracle.cluster.impl.gridhome.credentials.CredNativeResult;
import oracle.cluster.jwccred.common.ClientException;
import oracle.cluster.jwccred.common.StoreException;
import oracle.cluster.jwccred.seckeys.KeytoolUtilFactory;
import oracle.cluster.jwccred.seckeys.impl.CRSKeytoolUtil;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CredentialsFactoryImpl {
    public static String DOMAIN = "GRIDHOME";
    private static CredentialsFactoryImpl s_instance;

    private CredentialsFactoryImpl() throws CredentialsException {
    }

    public static synchronized CredentialsFactoryImpl getInstance() throws CredentialsException {
        try {
            SRVMContext ctx = SRVMContext.getInstance();
            ctx.init();
        }
        catch (SRVMContextException sce) {
            Trace.out(sce.getMessage());
            throw new CredentialsException(sce);
        }
        if (null == s_instance) {
            s_instance = new CredentialsFactoryImpl();
        }
        return s_instance;
    }

    public void createClientData(String clusterName, Credentials creds) throws CredentialsException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase();
        }
        try {
            Trace.out("Loading SRVM HAS native library");
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredNativeResult result = new CredNativeResult(creds);
        try {
            Trace.out("Before calling native create client data api");
            CredNative.createClientData(result, DOMAIN, clusterName);
            Trace.out("After calling  native create client data api");
            if (!result.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = result.getOSString();
                if (errorString != null) {
                    Trace.out("Credential exception  " + errorString);
                    throw new CredentialsException((MessageKey)PrCgMsgID.CREATE_CLIENT_DATA_FAILED, clusterName);
                }
            }
        }
        catch (CredNativeException e) {
            throw new CredentialsException(e);
        }
    }

    public void exportClientData(String clusterName, String dataFile, Credentials creds) throws CredentialsException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredNativeResult result = new CredNativeResult(creds);
        try {
            Trace.out("Exporting client data for clustername " + clusterName + " to path " + dataFile);
            CredNative.exportClientData(result, DOMAIN, clusterName, dataFile);
            if (!result.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = result.getOSString();
                if (errorString != null) {
                    Trace.out("Credential exception  " + errorString);
                    throw new CredentialsException((MessageKey)PrCgMsgID.EXPORT_CLIENT_DATA_FAILED, clusterName, dataFile);
                }
            }
        }
        catch (CredNativeException e) {
            throw new CredentialsException(e);
        }
    }

    public String exportClientDataBuf(String clusterName, Credentials creds) throws CredentialsException {
        return this.internalExportClientDataBuf(clusterName, creds, null, new Version().toString());
    }

    public String exportClientDataBuf(String clusterName, Credentials creds, String version) throws CredentialsException {
        return this.internalExportClientDataBuf(clusterName, creds, null, version);
    }

    public String exportClientDataBuf(String clusterName, Credentials creds, String credFile, String version) throws CredentialsException {
        if (credFile == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "credFile");
        }
        return this.internalExportClientDataBuf(clusterName, creds, credFile, version);
    }

    private String internalExportClientDataBuf(String clusterName, Credentials creds, String credFile, String version) throws CredentialsException {
        if (credFile == null || credFile.isEmpty()) {
            credFile = System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID().toString() + ".xml";
        }
        Version verObj = null;
        try {
            verObj = Version.getVersion(version);
        }
        catch (ConfigurationException ce) {
            throw new CredentialsException(ce);
        }
        if (Version.isPre12102(verObj)) {
            throw new CredentialsException((MessageKey)PrCgMsgID.INVALID_CRED_VERSION, true, version);
        }
        boolean isRHPSection = !verObj.equals(Version.get12102Version());
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredNativeResult result = new CredNativeResult(creds);
        try {
            if (clusterName != null) {
                clusterName = clusterName.toLowerCase();
            }
            Trace.out("Before calling exportClientDataBuf for cluster name: " + clusterName);
            GridHomeFactory gridFact = GridHomeFactory.getInstance();
            String certificate = null;
            String rhpsGUID = null;
            if (gridFact.isTLSEnabled()) {
                CRSKeytoolUtil crsKeyTool = KeytoolUtilFactory.getCRSKeytoolUtilInstance();
                certificate = crsKeyTool.getClusterRootCert();
                Trace.out("Cluster certificate : " + certificate);
                rhpsGUID = new ClusterUtil().getClusterGUID();
                Trace.out("RHPS cluster guid : " + rhpsGUID);
            }
            CredNative.exportClientDataBuf(result, DOMAIN, clusterName, credFile, isRHPSection, certificate, rhpsGUID);
            Trace.out("After calling exportClientDataBuf for cluster name: " + clusterName);
            if (!result.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = result.getOSString();
                if (errorString != null) {
                    Trace.out("Credential exception  " + errorString);
                    throw new CredentialsException((MessageKey)PrCgMsgID.EXPORT_CLIENT_DATA_BUF_FAILED, clusterName);
                }
            }
            Trace.out("credential data is as follows:");
            Trace.out(creds.getClientData());
            return creds.getClientData();
        }
        catch (CredNativeException e) {
            throw new CredentialsException(e);
        }
        catch (StoreException e) {
            throw new CredentialsException(e);
        }
        catch (ClientException e) {
            throw new CredentialsException(e);
        }
        catch (ClusterUtilException e) {
            throw new CredentialsException(e);
        }
        catch (SoftwareModuleException e) {
            throw new CredentialsException(e);
        }
    }

    public void importClientData(String clusterName, String dataFile) throws CredentialsException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase();
        }
        CredNativeResult result = new CredNativeResult();
        try {
            CredNative.importClientData(result, DOMAIN, clusterName, dataFile);
            if (!result.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = result.getOSString();
                if (errorString != null) {
                    Trace.out("Credential exception  " + errorString);
                    throw new CredentialsException((MessageKey)PrCgMsgID.IMPORT_CLIENT_DATA_FAILED, dataFile, clusterName);
                }
            }
        }
        catch (CredNativeException e) {
            throw new CredentialsException(e);
        }
    }

    public String getClientSecret(String clusterName) throws CredentialsException {
        Credentials cred = this.getCredSecret(clusterName);
        return cred.getghcPassword();
    }

    public String getServerSecret(String clusterName) throws CredentialsException {
        Credentials cred = this.getCredSecret(clusterName);
        return cred.getghsPassword();
    }

    private Credentials getCredSecret(String clientName) throws CredentialsException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        if (clientName != null) {
            clientName = clientName.toLowerCase();
        }
        CredNativeResult result = new CredNativeResult();
        try {
            String errorString;
            Trace.out("Domain is...." + DOMAIN);
            Trace.out("Client name is...." + clientName);
            String pass = CredNative.getClientSecret(result, DOMAIN, clientName);
            if (!result.getBooleanResult() && (errorString = result.getOSString()) != null) {
                Trace.out("Credential exception  " + errorString);
                throw new CredentialsException((MessageKey)PrCgMsgID.GET_CLIENT_SECRET_FAILED, clientName);
            }
            Credentials cred = new Credentials(pass);
            return cred;
        }
        catch (CredNativeException e) {
            throw new CredentialsException(e);
        }
    }

    public void deleteClientCredentials(String clusterName) throws CredentialsException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            Trace.out("Loading SRVM HAS native library");
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase();
        }
        CredNativeResult result = new CredNativeResult();
        try {
            Trace.out("Domain is...." + DOMAIN);
            Trace.out("Client name is...." + clusterName);
            Trace.out("Before calling native deleteClientCredentials");
            CredNative.deleteClientCredentials(result, DOMAIN, clusterName);
            Trace.out("After calling native deleteClientCredentials");
            if (result.getBooleanResult()) {
                String errorString = result.getOSString();
                Trace.out("Credential exception  " + errorString);
                throw new CredentialsException((MessageKey)PrCgMsgID.DELETE_CLIENT_CREDENTIALS_FAILED, clusterName, errorString);
            }
        }
        catch (CredNativeException e) {
            throw new CredentialsException(e);
        }
    }
}

