/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome.credentials;

import oracle.cluster.gridhome.credentials.Credentials;
import oracle.cluster.gridhome.credentials.CredentialsException;
import oracle.cluster.impl.gridhome.credentials.CredNativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;

class CredNativeResult
extends NativeResult {
    private Credentials m_cred = null;

    CredNativeResult(Credentials cred) {
        this.m_cred = cred;
    }

    CredNativeResult() {
    }

    private String getUser() {
        return this.m_cred.getUser();
    }

    private String getPassword() {
        return this.m_cred.getPassword();
    }

    private String getPropValue(String propName) {
        return this.m_cred.getProperties().get(propName);
    }

    private void setClientData(String clientData) throws CredNativeException {
        try {
            Trace.out("Setting clientData: " + clientData);
            this.m_cred.setClientData(clientData);
            Trace.out("Finish setting clientData");
        }
        catch (CredentialsException e) {
            Trace.out("Encountered CredentialsException: " + e.getMessage());
            throw new CredNativeException(e);
        }
    }
}

