/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome.client;

import java.io.IOException;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import oracle.cluster.impl.gridhome.client.GHJMXConnector;
import oracle.cluster.impl.gridhome.client.GHLibException;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class GHOperationProxy {
    private MBeanServerConnection m_mbsc;
    private JMXConnector m_jmxc;
    private String m_systemID;
    private ObjectName m_ghMBeanObjName;

    private GHOperationProxy(MBeanServerConnection mbsc, String systemID, ObjectName objName) throws GHLibException {
        this.m_mbsc = mbsc;
        this.m_ghMBeanObjName = objName;
        this.m_systemID = systemID;
    }

    private GHOperationProxy(JMXConnector jmxc, String systemID, ObjectName objName) throws GHLibException {
        this.m_jmxc = jmxc;
        this.m_systemID = systemID;
        this.m_ghMBeanObjName = objName;
        try {
            this.m_mbsc = jmxc.getMBeanServerConnection();
        }
        catch (IOException e) {
            Trace.out("IOException enountered: " + e.getMessage());
            throw new GHLibException(e);
        }
    }

    public static GHOperationProxy newInstance(MBeanServerConnection mbsc, String systemID, ObjectName on) throws GHLibException {
        if (mbsc == null) {
            throw new GHLibException((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, "GHOperationProxy-newInstance-error_1");
        }
        GHOperationProxy proxy = new GHOperationProxy(mbsc, systemID, on);
        return proxy;
    }

    public static GHOperationProxy newInstance(JMXConnector jmxc, String systemID, ObjectName on) throws GHLibException {
        if (jmxc == null) {
            throw new GHLibException((MessageKey)PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, "GHOperationProxy-newInstance2-error_1");
        }
        GHOperationProxy proxy = new GHOperationProxy(jmxc, systemID, on);
        return proxy;
    }

    void close() throws GHLibException {
        Trace.out("Closing JMX server connection");
        if (this.m_jmxc != null) {
            try {
                this.m_jmxc.close();
            }
            catch (IOException e) {
                Trace.out("IOException enountered: " + e.getMessage());
                throw new GHLibException(e);
            }
            this.m_jmxc = null;
        } else if (this.m_mbsc != null) {
            GHJMXConnector.close(this.m_mbsc);
        }
        this.m_mbsc = null;
    }

    public String serverVersion() throws GHLibException {
        String method = "serverVersion";
        return this.invoke("serverVersion", null, null);
    }

    public String invokeAction(String methodName, HashMap<String, String> params, HashMap<String, String> options) throws GHLibException {
        String paramArgs = params.toString();
        Trace.out("parameters = " + paramArgs);
        String optArgs = options.toString();
        Trace.out("options = " + optArgs);
        return this.invoke(methodName, new Object[]{paramArgs, optArgs}, new String[]{"java.lang.String", "java.lang.String"});
    }

    private String invoke(String method, Object[] objs, String[] objTypes) throws GHLibException {
        try {
            String retVal = (String)this.m_mbsc.invoke(this.m_ghMBeanObjName, method, objs, objTypes);
            return retVal;
        }
        catch (MBeanException e) {
            Trace.out("MBeanException enountered: " + e.getMessage());
            throw new GHLibException(method + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            Trace.out("IOException enountered: " + e.getMessage());
            throw new GHLibException((MessageKey)PrCgMsgID.OC4J_CONNECT_LOST, new Object[0]);
        }
        catch (InstanceNotFoundException e) {
            Trace.out("InstanceNotFoundException enountered: " + e.getMessage());
            throw new GHLibException(method + ": " + e.getMessage(), e);
        }
        catch (ReflectionException e) {
            Trace.out("ReflectionException enountered: " + e.getMessage());
            throw new GHLibException(method + ": " + e.getMessage(), e);
        }
    }
}

