/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import oracle.cluster.impl.gridhome.client.GHJMXConnector;
import oracle.cluster.impl.gridhome.client.GHLibException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GHMBeanFactoryProxy {
    private MBeanServerConnection m_mbsc;
    private JMXConnector m_jmxc;
    private ObjectName m_ghFactoryName;

    private GHMBeanFactoryProxy(MBeanServerConnection mbsc, ObjectName objName) throws GHLibException {
        this.m_mbsc = mbsc;
        this.m_ghFactoryName = objName;
    }

    private GHMBeanFactoryProxy(JMXConnector jmxc, ObjectName objName) throws GHLibException {
        this.m_jmxc = jmxc;
        this.m_ghFactoryName = objName;
        try {
            this.m_mbsc = jmxc.getMBeanServerConnection();
        }
        catch (IOException e) {
            Trace.out("IOException enountered: " + e.getMessage());
            throw new GHLibException(e);
        }
    }

    public static GHMBeanFactoryProxy newInstance(String dnsName, int port, String userID, String password, String mbeanName, Locale locale) throws GHLibException {
        if (dnsName == null) {
            throw new GHLibException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dnsName");
        }
        boolean tomcat = Utils.useTomcat();
        MBeanServerConnection mbsc = null;
        JMXConnector jmxc = null;
        ObjectName on = null;
        QueryExp qe = null;
        if (dnsName != null) {
            try {
                if (tomcat) {
                    jmxc = GHJMXConnector.getTCConnector(dnsName, port, userID, password, locale);
                    mbsc = jmxc.getMBeanServerConnection();
                } else {
                    mbsc = GHJMXConnector.getConnector(dnsName, port, userID, password, locale);
                }
                on = new ObjectName(mbeanName);
                Trace.out("before query msbc");
                Set<ObjectName> onset = mbsc.queryNames(on, qe);
                Trace.out("after query msbc");
                Iterator<ObjectName> iter = onset.iterator();
                if (iter.hasNext()) {
                    on = iter.next();
                }
            }
            catch (Exception e) {
                Trace.out("GHMBeanFactoryProxy.newInstance(): " + e.getMessage());
                throw new GHLibException(e);
            }
        }
        if (mbsc != null && on != null) {
            if (tomcat) {
                return new GHMBeanFactoryProxy(jmxc, on);
            }
            return new GHMBeanFactoryProxy(mbsc, on);
        }
        return null;
    }

    void close() throws GHLibException {
        Trace.out("Closing JMX server connection");
        if (this.m_jmxc != null) {
            try {
                this.m_jmxc.close();
            }
            catch (IOException e) {
                Trace.out("IOException enountered: " + e.getMessage());
                throw new GHLibException(e);
            }
            this.m_jmxc = null;
        } else if (this.m_mbsc != null) {
            GHJMXConnector.close(this.m_mbsc);
        }
        this.m_mbsc = null;
    }

    public static GHMBeanFactoryProxy newInstance(String dnsName, int port, String userID, String password, String mbeanName) throws GHLibException {
        return GHMBeanFactoryProxy.newInstance(dnsName, port, userID, password, mbeanName, Locale.getDefault());
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.m_mbsc;
    }

    public JMXConnector getJMXConnector() {
        return this.m_jmxc;
    }

    public ObjectName startGHInstance(String systemID) throws GHLibException {
        String method = "startGHInstance";
        try {
            ObjectName on = (ObjectName)this.m_mbsc.invoke(this.m_ghFactoryName, "startGHInstance", new Object[]{systemID}, new String[]{"java.lang.String"});
            return on;
        }
        catch (MBeanException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_START_FAILED, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_START_FAILED, (Throwable)e, new Object[0]);
        }
        catch (InstanceNotFoundException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_START_FAILED, (Throwable)e, new Object[0]);
        }
        catch (ReflectionException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_START_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public void destroyGHInstance(String systemID) throws GHLibException {
        String method = "destroyGHInstance";
        try {
            this.m_mbsc.invoke(this.m_ghFactoryName, "destroyGHInstance", new Object[]{systemID}, new String[]{"java.lang.String"});
        }
        catch (MBeanException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_DESTROY_FAILED, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_DESTROY_FAILED, (Throwable)e, new Object[0]);
        }
        catch (InstanceNotFoundException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_DESTROY_FAILED, (Throwable)e, new Object[0]);
        }
        catch (ReflectionException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_DESTROY_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public void stopGHInstance(String systemID) throws GHLibException {
        String method = "stopGHInstance";
        try {
            this.m_mbsc.invoke(this.m_ghFactoryName, "stopGHInstance", new Object[]{systemID}, new String[]{"java.lang.String"});
        }
        catch (MBeanException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_STOP_FAILED, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_STOP_FAILED, (Throwable)e, new Object[0]);
        }
        catch (InstanceNotFoundException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_STOP_FAILED, (Throwable)e, new Object[0]);
        }
        catch (ReflectionException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_STOP_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public String getGHVersion() throws GHLibException {
        String method = "getGHVersion";
        try {
            String version = (String)this.m_mbsc.invoke(this.m_ghFactoryName, "getGHVersion", null, null);
            return version;
        }
        catch (MBeanException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_GET_VERSION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_GET_VERSION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (InstanceNotFoundException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_GET_VERSION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (ReflectionException e) {
            throw new GHLibException((MessageKey)PrCgMsgID.GH_GET_VERSION_FAILED, (Throwable)e, new Object[0]);
        }
    }
}

