/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.CommunicationException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.impl.gridhome.client.GHLibException;
import oracle.cluster.jwccred.tls.RMISSLClientSocketFactoryDynamicTM;
import oracle.cluster.jwccred.tls.TLSConfiguration;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class GHJMXConnector {
    public static MBeanServerConnection getConnector(String dnsName, int port, String userID, String password, Locale locale) throws GHLibException {
        Object serv = null;
        try {
            Class<?> connectorCls = Class.forName("oracle.oc4j.admin.jmx.client.Connector");
            Class<?> domainCls = Class.forName("oracle.oc4j.admin.jmx.shared.Domain");
            Class<?> oc4jDomainFactCls = Class.forName("oracle.oc4j.admin.jmx.client.Oc4jDomainFactory");
            Method getDomainMethod = oc4jDomainFactCls.getDeclaredMethod("getDomain", String.class, Integer.TYPE, String.class, String.class);
            Object domain = getDomainMethod.invoke(null, dnsName, port, userID, password);
            Method setLocaleMethod = domainCls.getDeclaredMethod("setLocale", Locale.class);
            setLocaleMethod.invoke(domain, locale);
            Method setConnMethod = domainCls.getDeclaredMethod("setConnectionCaching", Boolean.TYPE);
            setConnMethod.invoke(domain, false);
            PrintStream console = System.out;
            try {
                boolean tracingOn = Boolean.getBoolean("TRACING.ENABLED");
                String traceFileName = System.getProperty("srvm.ghctl.tracefile");
                File file = tracingOn && traceFileName != null ? new File(traceFileName) : new File("/dev/null");
                System.setOut(new PrintStream(new FileOutputStream(file)));
                Class<?> clMBeanServProxyFactCls = Class.forName("oracle.oc4j.admin.jmx.client.ClientMBeanServerProxyFactory");
                Method getMBServerMethod = clMBeanServProxyFactCls.getDeclaredMethod("getMBeanServer", domainCls);
                serv = getMBServerMethod.invoke(null, domain);
            }
            catch (Exception e) {
                System.setOut(console);
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    if (!(t instanceof CommunicationException)) continue;
                    Trace.out("Communication Exception while connecting to OC4J");
                    throw new GHLibException(MessageBundle.getMessageBundle(PrCgMsgID.facility).getMessage(PrCgMsgID.OC4J_COMMUNICATION_FAILED, true));
                }
                Trace.out(e.getMessage());
                throw new GHLibException(e);
            }
            System.setOut(console);
        }
        catch (ClassNotFoundException e) {
            Trace.out(e.getMessage());
            throw new GHLibException(e);
        }
        catch (IllegalAccessException e) {
            Trace.out(e.getMessage());
            throw new GHLibException(e);
        }
        catch (InvocationTargetException e) {
            Trace.out(e.getMessage());
            throw new GHLibException(e);
        }
        catch (NoSuchMethodException e) {
            Trace.out(e.getMessage());
            throw new GHLibException(e);
        }
        return (MBeanServerConnection)serv;
    }

    public static JMXConnector getTCConnector(String dnsName, int port, String userID, String password, Locale locale) throws GHLibException {
        try {
            Trace.out("Getting MBeanServerConnection");
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + dnsName + ":" + port + "/jmxrmi");
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.credentials", new char[][]{userID.toCharArray(), password.toCharArray()});
            GridHomeFactory gridFact = GridHomeFactory.getInstance();
            if (gridFact.isTLSEnabled()) {
                Trace.out("Setting TLS client properties");
                TLSConfiguration tlsConf = TLSConfiguration.getInstance();
                tlsConf.setClientTLSProperties();
                RMISSLClientSocketFactoryDynamicTM csf = new RMISSLClientSocketFactoryDynamicTM();
                env.put("jmx.remote.rmi.client.socket.factory", csf);
                env.put("com.sun.jndi.rmi.factory.socket", csf);
            }
            JMXConnector jmxc = JMXConnectorFactory.newJMXConnector(url, env);
            jmxc.connect();
            return jmxc;
        }
        catch (IOException e) {
            Trace.out((Object)"IOException: %s", e.getMessage());
            throw new GHLibException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out((Object)"SoftwareModuleException: %s", e.getMessage());
            throw new GHLibException(e);
        }
    }

    static void close(MBeanServerConnection mbsc) {
        if (mbsc != null) {
            try {
                Class<?> connectorCls = Class.forName("oracle.oc4j.admin.jmx.client.Connector");
                MBeanServerConnection conn = mbsc;
                connectorCls.getMethod("release", new Class[0]).invoke((Object)conn, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                Trace.out(e.getMessage());
            }
            catch (IllegalAccessException e) {
                Trace.out(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Trace.out(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                Trace.out(e.getMessage());
            }
        }
    }
}

