/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import oracle.cluster.common.Cluster;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.InterruptHandler;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.Credentials;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gridhome.GridHomeClient;
import oracle.cluster.gridhome.GridHomeClientException;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.gridhome.GridHomeServer;
import oracle.cluster.gridhome.GridHomeServerException;
import oracle.cluster.gridhome.client.GridHomeActionException;
import oracle.cluster.gridhome.client.GridHomeActionResult;
import oracle.cluster.gridhome.client.InvalidActionArgumentException;
import oracle.cluster.impl.gridhome.client.GHLibException;
import oracle.cluster.impl.gridhome.client.GHMBeanFactoryProxy;
import oracle.cluster.impl.gridhome.client.GHOperationProxy;
import oracle.cluster.impl.gridhome.client.InternalParameter;
import oracle.cluster.install.InstallException;
import oracle.cluster.jwccred.common.ClientException;
import oracle.cluster.jwccred.common.StoreException;
import oracle.cluster.jwccred.seckeys.KeytoolUtilFactory;
import oracle.cluster.jwccred.seckeys.impl.CRSKeytoolUtil;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.CryptoUtil;
import oracle.cluster.util.CryptoUtilException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.GHAdminWallet;
import oracle.gridhome.container.GHException;
import oracle.gridhome.impl.util.MBeanHelper;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ClientFactoryImpl {
    private static ClientFactoryImpl s_instance;
    private static String ADD_CLIENT_METHOD;
    private static String EXPORT_CLIENT_METHOD;
    private static String VERIFY_CLIENT_METHOD;
    private static String DISCOVER_CLIENT_METHOD;
    private static String IMPORT_IMAGE_METHOD;
    private static String ADD_WORKINGCOPY_METHOD;
    private static String ADD_DATABASE_METHOD;
    private static String MOVE_GIHOME_METHOD;
    private static String UPGRADE_DATABASE_METHOD;
    private static String DELETE_WORKINGCOPY_METHOD;
    private static String DELETE_AUDIT_METHOD;
    private static String QUERY_AUDIT_METHOD;
    private static String DELETE_DATABASE_METHOD;
    private static String MOVE_DATABASE_METHOD;
    private static String TEMP_MNT_PATH;
    private static String SUDO_METHOD;
    private static String ROOT_METHOD;
    private static String TRUE;
    private static String FALSE;
    private static String SINGLE;
    private static final String TEMP_DIR;
    public static final String FILE_SEPARATOR;
    private static final String NEWLINE;
    private static String TARGET_STANDALONE;
    public static final String ASMCLIENT_FILENAME = "asmclientdata.txt";
    public static final String GNSCLIENT_FILENAME = "gnsclientdata.txt";
    public static final String CLUSTERMANIFEST_FILENAME = "clustermanifest.xml";
    public static final String JWCADMIN_USER = "jwcadmin";
    public static final String RHP_DOMAIN = "rhp";
    public static final String JMX_SRV_URL = "service:jmx:rmi:///jndi/rmi://";
    public static final String JMXRMI = "/jmxrmi";
    private static InterruptHandler m_intHndlr;
    private static MessageBundle m_msgBndl;
    private Method m_intHndlrMthd = null;
    private List<Object> m_params = null;
    private ProgressListener m_plsnr = null;
    private static boolean m_tomcat;
    private static String m_clusterGUID;

    private ClientFactoryImpl() throws GridHomeActionException {
        m_tomcat = Utils.useTomcat();
        m_intHndlr = new InterruptHandler();
        try {
            m_clusterGUID = new ClusterUtil().getClusterGUID();
        }
        catch (ClusterUtilException e) {
            Trace.out("ClusterUtilException: " + e.getMessage());
            throw new GridHomeActionException(e);
        }
    }

    public static synchronized ClientFactoryImpl getInstance() throws GridHomeActionException {
        if (null == s_instance) {
            s_instance = new ClientFactoryImpl();
        }
        return s_instance;
    }

    public void addInterruptHandler(Method method, List<Object> params) throws GridHomeActionException {
        this.m_intHndlrMthd = method;
        this.m_params = params;
    }

    public GridHomeActionResult submitAction(String methodName, HashMap<String, String> options) throws InvalidActionArgumentException, GridHomeActionException {
        return this.submitAction(methodName, options, null, null);
    }

    /*
     * Exception decompiling
     */
    public GridHomeActionResult submitAction(String methodName, HashMap<String, String> options, String verb, String noun) throws InvalidActionArgumentException, GridHomeActionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GHOperationProxy connect(String clusterName) throws GridHomeActionException {
        try {
            GridHomeFactory gridFact = GridHomeFactory.getInstance();
            if (gridFact.isTLSEnabled()) {
                CRSKeytoolUtil crsKeyTool = KeytoolUtilFactory.getCRSKeytoolUtilInstance();
                crsKeyTool.exportTrustedEntries();
            }
            GHMBeanFactoryProxy ghfactory = GHMBeanFactoryProxy.newInstance(this.getGHHostName(), this.getGHRmiPort(), ClientFactoryImpl.getAdminUser(), String.valueOf(ClientFactoryImpl.getAdminPasswd()), "gridhome:version=12.2.0.0.0,type=factory,*");
            String domain = "gridhome";
            Trace.out("domain=" + domain);
            ObjectName operationMBeanName = MBeanHelper.createGHOperationMBeanName((String)clusterName, (String)new Version().toString(), (String)domain);
            Trace.out("Operation MBean name = " + operationMBeanName.toString());
            GHOperationProxy ghOperation = null;
            if (m_tomcat) {
                JMXConnector jmxc = ghfactory.getJMXConnector();
                ghOperation = GHOperationProxy.newInstance(jmxc, clusterName, operationMBeanName);
            } else {
                MBeanServerConnection mbeanServer = ghfactory.getMBeanServerConnection();
                ghOperation = GHOperationProxy.newInstance(mbeanServer, clusterName, operationMBeanName);
            }
            Trace.out("Finish getting GHOperationProxy");
            return ghOperation;
        }
        catch (CRSException e) {
            throw new GridHomeActionException((MessageKey)PrCgMsgID.OC4J_CONNECT_FAILED, (Throwable)e, clusterName);
        }
        catch (GHException e) {
            throw new GridHomeActionException((MessageKey)PrCgMsgID.OC4J_CONNECT_FAILED, (Throwable)e, clusterName);
        }
        catch (GHLibException e) {
            throw new GridHomeActionException((MessageKey)PrCgMsgID.OC4J_CONNECT_FAILED, (Throwable)e, clusterName);
        }
        catch (NodeException e) {
            throw new GridHomeActionException((MessageKey)PrCgMsgID.OC4J_CONNECT_FAILED, (Throwable)e, clusterName);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeActionException((MessageKey)PrCgMsgID.OC4J_CONNECT_FAILED, (Throwable)e, clusterName);
        }
        catch (StoreException e) {
            throw new GridHomeActionException((MessageKey)PrCgMsgID.OC4J_CONNECT_FAILED, (Throwable)e, clusterName);
        }
        catch (ClientException e) {
            throw new GridHomeActionException((MessageKey)PrCgMsgID.OC4J_CONNECT_FAILED, (Throwable)e, clusterName);
        }
    }

    private static char[] getSecret(String domain, String user) throws GridHomeActionException {
        try {
            Credentials c;
            StringBuilder domainPath = new StringBuilder("JWC");
            domainPath.append("/");
            domainPath.append(m_clusterGUID);
            domainPath.append("/");
            domainPath.append(domain);
            CredentialsSet credSet = CredentialsFactory.getInstance().getDomainByPath(domainPath.toString()).getCredentialsSet(CredentialsType.USERPASS);
            UserPassCredentials upc = null;
            Iterator<Credentials> iterator = credSet.getAllCredentials().iterator();
            while (iterator.hasNext() && !user.equals((upc = (UserPassCredentials)(c = iterator.next())).getUsername())) {
                upc = null;
            }
            if (upc == null) {
                throw new GridHomeActionException((MessageKey)PrCgMsgID.USER_NOT_EXISTS, user);
            }
            return new PasswordAuthentication(upc.getUsername(), upc.getPassword().toCharArray()).getPassword();
        }
        catch (CredentialsException e) {
            Trace.out((Object)"CredentialsException: %s", e.getMessage());
            throw new GridHomeActionException(e);
        }
        catch (ManageableEntityException e) {
            Trace.out((Object)"ManageableEntityException: %s", e.getMessage());
            throw new GridHomeActionException(e);
        }
    }

    private String getGHHostName() throws CRSException, NodeException, GridHomeServerException, GridHomeClientException, SoftwareModuleException {
        GridHomeFactory ghFact = GridHomeFactory.getInstance();
        try {
            GridHomeServer ghs = ghFact.getGridHomeServer();
            List<Node> ghsNodes = ghs.crsResource().fetchRunningNodes();
            if (ghsNodes.size() == 0) {
                throw new GridHomeServerException((MessageKey)PrCgMsgID.GHS_NOT_RUNNING, true);
            }
            return ghsNodes.get(0).getName();
        }
        catch (NotExistsException e) {
            try {
                GridHomeClient ghc = ghFact.getGridHomeClient();
                List<Node> ghcNodes = ghc.crsResource().fetchRunningNodes();
                if (ghcNodes.size() == 0) {
                    throw new GridHomeClientException((MessageKey)PrCgMsgID.GHC_NOT_RUNNING, true);
                }
                return ghcNodes.get(0).getName();
            }
            catch (NotExistsException ex) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GHS_OR_GHC_NOT_CONFIGURED, true);
            }
        }
    }

    private int getGHRmiPort() throws SoftwareModuleException {
        GridHomeFactory ghFact = GridHomeFactory.getInstance();
        try {
            GridHomeServer ghs = ghFact.getGridHomeServer();
            return ghs.port();
        }
        catch (NotExistsException e) {
            try {
                GridHomeClient ghc = ghFact.getGridHomeClient();
                return ghc.port();
            }
            catch (NotExistsException ex) {
                throw new SoftwareModuleException(ex);
            }
        }
    }

    public static String getAdminUser() {
        return m_tomcat ? JWCADMIN_USER : "oc4jadmin";
    }

    public static char[] getAdminPasswd() throws GridHomeActionException, GridHomeClientException {
        Trace.out("Getting GHAdminPassword...");
        char[] passwd = null;
        try {
            if (m_tomcat) {
                passwd = ClientFactoryImpl.getSecret(RHP_DOMAIN, ClientFactoryImpl.getAdminUser());
            } else {
                GHAdminWallet ghwallet = GHAdminWallet.getInstance();
                ghwallet.open();
                passwd = ghwallet.getPassword().toCharArray();
                ghwallet.close();
            }
        }
        catch (CLSWException e) {
            Trace.out("Failed to te initialize CLSW context: " + e.toString());
            throw new GridHomeClientException(e);
        }
        Trace.out("admin passwd obtained");
        return passwd;
    }

    private String doExportClientData(String blobFile, String retVal) throws GridHomeActionException {
        try {
            GridHomeActionResult result = new GridHomeActionResult(retVal);
            String[] outputArr = result.getOutput();
            if (result.isSuccess()) {
                Trace.out(outputArr[0]);
                PrintWriter pw = new PrintWriter(blobFile);
                pw.print(outputArr[0]);
                pw.close();
                Trace.out("Completed export of blobFile = " + blobFile);
                return "<STATUS>" + GridHomeActionResult.ActionStatus.SUCCESS.toString() + "</STATUS>";
            }
            return retVal;
        }
        catch (FileNotFoundException e) {
            throw new GridHomeActionException(e);
        }
    }

    private String getTempImageMntPath(String imageName) throws GridHomeActionException {
        boolean isPathExists = false;
        String[] nodeList = null;
        int numTries = 0;
        String path = null;
        try {
            nodeList = new ClusterUtil().getActiveNodes();
            ClusterCmd clusterCmd = new ClusterCmd();
            do {
                path = TEMP_MNT_PATH + File.separator + imageName + (int)(Math.random() * 999999.0);
                Trace.out("Temporary mount path is..." + path);
                isPathExists = clusterCmd.pathExists(nodeList, path, 1);
                if (numTries > 10) {
                    throw new GridHomeActionException((MessageKey)PrCgMsgID.MAX_MNT_PATH_GEN_TRIES, true);
                }
                ++numTries;
            } while (isPathExists);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException e) {
            Trace.out("clusterException while checking for mountpath existance");
        }
        catch (ClusterUtilException e) {
            Trace.out("clusterutil exception while checking for mountpath existance");
        }
        catch (ClusterOperationException e) {
            Trace.out("ClusterOperationException while checking for mountpath existance");
        }
        return path;
    }

    public static String encryptPassword(String pass) throws CryptoUtilException, GridHomeServerException, SoftwareModuleException, NotExistsException {
        CryptoUtil cu = new CryptoUtil();
        GridHomeServer ghs = GridHomeFactory.getInstance().getGridHomeServer();
        String encryptKey = ghs.getEncryptKey();
        byte[] passArr = cu.encrypt(encryptKey, pass);
        String encryptPass = cu.byte2Hex(passArr);
        return encryptPass;
    }

    private String getPassword(String prompt) throws NativeException {
        char[] passwd = new SystemFactory().CreateSystem().readFromConsole(false, prompt);
        if (null == passwd) {
            return null;
        }
        return new String(passwd);
    }

    private boolean isRHPPatchinProgress() throws SoftwareModuleException, GridHomeServerException, GridHomeClientException, SoftwareModuleException {
        boolean isPatchinProgress = false;
        try {
            GridHomeServer ghs = GridHomeFactory.getInstance().getGridHomeServer();
            if (ghs.isGIPatchinProgress()) {
                isPatchinProgress = true;
            }
        }
        catch (NotExistsException e) {
            try {
                GridHomeClient ghc = GridHomeFactory.getInstance().getGridHomeClient();
                if (ghc.isGIPatchinProgress()) {
                    isPatchinProgress = true;
                }
            }
            catch (NotExistsException ex) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GHS_OR_GHC_NOT_CONFIGURED, true);
            }
        }
        return isPatchinProgress;
    }

    private boolean isRHPRunning() throws SoftwareModuleException, GridHomeServerException, GridHomeClientException, SoftwareModuleException {
        boolean isRunning = false;
        try {
            GridHomeServer ghs = GridHomeFactory.getInstance().getGridHomeServer();
            if (ghs.isRunning()) {
                isRunning = true;
            }
        }
        catch (NotExistsException e) {
            try {
                GridHomeClient ghc = GridHomeFactory.getInstance().getGridHomeClient();
                if (ghc.isRunning()) {
                    isRunning = true;
                }
            }
            catch (NotExistsException ex) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GHS_OR_GHC_NOT_CONFIGURED, true);
            }
        }
        return isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String moveGIself(String clusterName, HashMap<String, String> options, HashMap<String, String> params, String initRHPnode) throws GridHomeActionException {
        Trace.out("Entering the move GI self code");
        GHOperationProxy opProxy = null;
        String retVal = null;
        GridHomeActionException gae = null;
        try {
            if (this.isRHPPatchinProgress()) {
                Trace.out("RHP patch in progress is set");
                Trace.out("Initial RHP node is " + initRHPnode);
                boolean isCRSRunning = false;
                boolean isRHPRunning = false;
                boolean isCRSStopped = false;
                int loopcount1 = 1000;
                int loopcount2 = 1000;
                String crsHome = new Util().getCRSHome();
                ClusterwareInfo cwInfo = new ClusterwareInfo();
                Trace.out("Wait for CRS to stop completely");
                for (int loopcount3 = 1000; !isCRSStopped && loopcount3 > 0; --loopcount3) {
                    try {
                        isCRSRunning = cwInfo.isCRSRunning(crsHome, initRHPnode);
                        if (!isCRSRunning) {
                            isCRSStopped = true;
                        }
                    }
                    catch (InstallException re) {
                        Trace.out("Got install exception" + re.getMessage());
                    }
                    Trace.out("decrementing wait loop for crs health check");
                    Thread.sleep(500L);
                }
                if (!isCRSStopped) {
                    Trace.out("Timed out waiting for CRS to be up");
                    throw new GridHomeActionException((MessageKey)PrCgMsgID.CRS_CHECK_TIMEDOUT, false);
                }
                Trace.out("Wait for CRS to start completely");
                while (!isCRSRunning && loopcount1 > 0) {
                    try {
                        isCRSRunning = cwInfo.isCRSRunning(crsHome, initRHPnode);
                    }
                    catch (InstallException re) {
                        Trace.out("Got install exception" + re.getMessage());
                    }
                    Trace.out("decrementing wait loop for crs health check");
                    --loopcount1;
                    Thread.sleep(500L);
                }
                if (!isCRSRunning) {
                    Trace.out("Timed out waiting for CRS to be up");
                    throw new GridHomeActionException((MessageKey)PrCgMsgID.CRS_CHECK_TIMEDOUT, false);
                }
                while (!isRHPRunning && loopcount2 > 0) {
                    isRHPRunning = this.isRHPRunning();
                    Trace.out("decrementing wait loop for rhp health check");
                    --loopcount2;
                    Thread.sleep(500L);
                }
                if (!isRHPRunning) {
                    Trace.out("Timed out waiting for RHP to be up");
                    throw new GridHomeActionException((MessageKey)PrCgMsgID.RHP_CHECK_TIMEDOUT, false);
                }
                Trace.out("connecting to rhp for second move invoke");
                Thread.sleep(15000L);
                opProxy = this.connect(clusterName);
                params.put(InternalParameter.GI_PATCH_PROGRESS.toString(), "TRUE");
                retVal = opProxy.invokeAction("moveGIHome", params, options);
            }
            String isCRSRunning = retVal;
            return isCRSRunning;
        }
        catch (InterruptedException | GridHomeClientException | GridHomeServerException | GHLibException | UtilException e) {
            Trace.out("%s: %s", e.getClass().getSimpleName(), e.getMessage());
            gae = new GridHomeActionException((MessageKey)PrCgMsgID.MOVE_GI_SELF_FAILED, e, clusterName);
            String string = null;
            return string;
        }
        catch (SoftwareModuleException e) {
            Trace.out((Object)"SoftwareModuleException: %s", e.getMessage());
            gae = new GridHomeActionException((MessageKey)PrCgMsgID.MOVE_GI_SELF_FAILED, (Throwable)e, clusterName);
            String string = null;
            return string;
        }
        finally {
            if (opProxy != null) {
                try {
                    opProxy.close();
                }
                catch (GHLibException e) {
                    Trace.out((Object)"GHLibException: %s", e.getMessage());
                    GridHomeActionException aux = new GridHomeActionException((MessageKey)PrCgMsgID.CLOSE_PROXY_FAILED, (Throwable)e, new Object[0]);
                    gae = gae == null ? aux : new GridHomeActionException(gae, aux.getMessage());
                }
            }
            if (gae != null) {
                throw gae;
            }
        }
    }

    private void relocateRHPTo(Node tgtNode) throws GridHomeActionException {
        if (tgtNode != null) {
            String clusterName = null;
            try {
                Trace.out((Object)"relocating RHP to %s ...", tgtNode.getName());
                Cluster cluster = CommonFactory.getInstance().getCluster();
                clusterName = cluster.getName();
                try {
                    Trace.out("checking if RHPS exists ...");
                    GridHomeServer ghs = GridHomeFactory.getInstance().getGridHomeServer();
                    Trace.out("relocating RHPS ...");
                    if (this.m_plsnr != null) {
                        this.m_plsnr.write(MessageBundle.getMessage(PrCgMsgID.RELOCATE_RHPS, false, tgtNode.getName()));
                    }
                    ghs.relocateTo(tgtNode);
                    Trace.out("relocated RHPS");
                }
                catch (NotExistsException nee) {
                    Trace.out("checking if RHPC exists ...");
                    try {
                        GridHomeClient ghc = GridHomeFactory.getInstance().getGridHomeClient();
                        Trace.out("relocating RHPC ...");
                        if (this.m_plsnr != null) {
                            this.m_plsnr.write(MessageBundle.getMessage(PrCgMsgID.RELOCATE_RHPC, false, tgtNode.getName()));
                        }
                        ghc.relocateTo(tgtNode);
                        Trace.out("relocated RHPC");
                    }
                    catch (NotExistsException nee2) {
                        throw new GridHomeClientException((MessageKey)PrCgMsgID.GHS_OR_GHC_NOT_CONFIGURED, true);
                    }
                }
                Trace.out("waiting for RHP to come back online ...");
                boolean isRHPRunning = false;
                for (int count = 1000; !isRHPRunning && count > 0; --count) {
                    isRHPRunning = this.isRHPRunning();
                    Trace.out("decrementing wait loop for rhp health check");
                    Thread.sleep(500L);
                }
                if (!isRHPRunning) {
                    Trace.out("Timed out waiting for RHP to come back online");
                    throw new GridHomeActionException((MessageKey)PrCgMsgID.RHP_CHECK_TIMEDOUT, false);
                }
            }
            catch (InterruptedException | ClusterException | RelocateException | GridHomeClientException | GridHomeServerException | NotRunningException | NodeException e) {
                Trace.out("attempt to relocate RHP failed with exception %s : %s", e.getClass().getName(), e);
                throw new GridHomeActionException((MessageKey)PrCgMsgID.MOVE_GI_SELF_FAILED, (Throwable)e, clusterName);
            }
            catch (ManageableEntityException e) {
                Trace.out("attempt to relocate RHP failed with ManageableEntityException : %s", e);
                throw new GridHomeActionException((MessageKey)PrCgMsgID.MOVE_GI_SELF_FAILED, (Throwable)e, clusterName);
            }
        }
    }

    private boolean getIsPromptPassResult(String retVal) throws GridHomeActionException {
        boolean isPrompt = false;
        GridHomeActionResult result = new GridHomeActionResult(retVal);
        if (result.isSuccess()) {
            String output = result.getAllOutputs();
            Trace.out("Result is :" + output);
            if (TRUE.equals(output)) {
                isPrompt = true;
            }
        }
        return isPrompt;
    }

    static {
        ADD_CLIENT_METHOD = "addClient";
        EXPORT_CLIENT_METHOD = "exportClient";
        VERIFY_CLIENT_METHOD = "verifyClient";
        DISCOVER_CLIENT_METHOD = "discoverClient";
        IMPORT_IMAGE_METHOD = "importIntoImage";
        ADD_WORKINGCOPY_METHOD = "addWorkingCopy";
        ADD_DATABASE_METHOD = "addDatabase";
        MOVE_GIHOME_METHOD = "moveGIHome";
        UPGRADE_DATABASE_METHOD = "upgradeDatabase";
        DELETE_WORKINGCOPY_METHOD = "deleteWorkingCopy";
        DELETE_AUDIT_METHOD = "deleteAudit";
        QUERY_AUDIT_METHOD = "queryAudit";
        DELETE_DATABASE_METHOD = "deleteDatabase";
        MOVE_DATABASE_METHOD = "moveDatabase";
        TEMP_MNT_PATH = "/mnt";
        SUDO_METHOD = "sudo";
        ROOT_METHOD = "root";
        TRUE = "TRUE";
        FALSE = "FALSE";
        SINGLE = "SINGLE";
        TEMP_DIR = System.getProperty("java.io.tmpdir");
        FILE_SEPARATOR = System.getProperty("file.separator");
        NEWLINE = System.getProperty("line.separator");
        TARGET_STANDALONE = "STANDALONE";
        m_intHndlr = null;
        m_tomcat = false;
        m_clusterGUID = null;
        m_msgBndl = MessageBundle.getMessageBundle(PrCgMsgID.facility);
        m_msgBndl.setPackage("oracle.cluster.resources");
    }
}

