/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.adminhelper.AdminHelper;
import oracle.cluster.adminhelper.AdminHelperException;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.asm.Volume;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.cmdtools.SRVMHELPERUtil;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.SharedKeyCredentials;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gridhome.GridHomeClient;
import oracle.cluster.gridhome.GridHomeException;
import oracle.cluster.gridhome.GridHomeServer;
import oracle.cluster.gridhome.GridHomeServerArgs;
import oracle.cluster.gridhome.GridHomeServerException;
import oracle.cluster.impl.adminhelper.AdminHelperFactoryImpl;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.DiskGroupImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.gns.GNSImpl;
import oracle.cluster.impl.gridhome.GridHomeCommonImpl;
import oracle.cluster.impl.gridhome.GridHomeFactoryImpl;
import oracle.cluster.impl.gridhome.credentials.CredentialsFactoryImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.CryptoAlg;
import oracle.cluster.util.CryptoUtil;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GridHomeServerImpl
extends GridHomeCommonImpl
implements GridHomeServer {
    private static final String CHECKPT_BASE_DIR = "chkbase";
    private static final String CHECKPT_DIR = "GHcheckpoints";
    private static final String CHECKPT_VOLNAME = "ghchkpt";
    private static final String RES_NOT_FOUND_ERR = "PRCR-1097";
    private static final MessageBundle m_msgBndl_PrCg = MessageBundle.getMessageBundle(PrCgMsgID.facility);
    private boolean m_tomcat = Utils.useTomcat();

    GridHomeServerImpl(ResourceAttribute nameAttr) throws GridHomeServerException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.GHS.NAME.name()) && !nameAttr.getName().equalsIgnoreCase(ResourceType.RHPS.NAME.name())) {
                throw new GridHomeServerException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), this.m_tomcat ? ResourceType.RHPS.NAME.name() : ResourceType.GHS.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.GHS.toString().equalsIgnoreCase(values[numValues - 1]) && !ResourceLiterals.RHPSERVER.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new GridHomeServerException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, this.m_tomcat ? ResourceType.RHPS.NAME.name() : ResourceType.GHS.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            this.m_crsResource = (CRSResourceImpl)((Object)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr));
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new GridHomeServerException(e);
        }
    }

    void create(String storagePath, List<DiskGroup> dgList, Version version) throws AlreadyExistsException, GridHomeServerException {
        this.create(storagePath, dgList, version, null, null);
    }

    void create(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient, GridHomeServerArgs ghsArgs) throws AlreadyExistsException, GridHomeServerException {
        this.create(storagePath, dgList, version, plsnrClient, ghsArgs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient, GridHomeServerArgs ghsArgs, boolean isUpg) throws AlreadyExistsException, GridHomeServerException {
        block84: {
            MgmtDatabase mgmtDB = null;
            try {
                if (ghsArgs == null || !ghsArgs.getForce()) {
                    mgmtDB = DatabaseFactoryImpl.getInstance().getMgmtDatabase();
                }
            }
            catch (NotExistsException e) {
                throw new GridHomeServerException((MessageKey)PrCgMsgID.GHS_NOTEXISTS_GET_DATABASE_FAILED, (Throwable)e, new Object[0]);
            }
            catch (SoftwareModuleException e) {
                throw new GridHomeServerException((MessageKey)PrCgMsgID.GHS_GET_DATABASE_FAILED, (Throwable)e, new Object[0]);
            }
            GridHomeFactoryImpl ghFactImpl = null;
            if (!isUpg) {
                try {
                    boolean isACFS = new ClusterwareInfo().isACFSDriversConfigured(new Util().getCRSHome());
                    if (!isACFS) {
                        throw new GridHomeServerException((MessageKey)PrCgMsgID.ACFS_NOT_CONFIGURED_GHS, new Object[0]);
                    }
                }
                catch (InstallException e) {
                    throw new GridHomeServerException((MessageKey)PrCgMsgID.ACFS_CHECK_FAILED_GHS, (Throwable)e, new Object[0]);
                }
                catch (UtilException e) {
                    throw new GridHomeServerException((MessageKey)PrCgMsgID.ACFS_CHECK_FAILED_GHS, (Throwable)e, new Object[0]);
                }
                this.assertStoragePath(storagePath);
                try {
                    storagePath = new File(storagePath).getCanonicalPath().trim();
                }
                catch (IOException e) {
                    Trace.out("failed to get canonical storage path: " + e.getMessage());
                    throw new GridHomeServerException(e);
                }
                if (storagePath.length() > 1 && storagePath.endsWith(File.separator)) {
                    storagePath = storagePath.substring(0, storagePath.length() - 1);
                }
                Trace.out("canonical storage path: " + storagePath);
                try {
                    NodeAppsFactoryImpl.getInstance().assertRoot();
                }
                catch (SoftwareModuleException e) {
                    throw new GridHomeServerException(e);
                }
                GridHomeClient ghc = null;
                try {
                    ghFactImpl = GridHomeFactoryImpl.getInstance();
                    ghc = ghFactImpl.getGridHomeClient();
                }
                catch (SoftwareModuleException e) {
                    throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_GHC_RES_FAILED, (Throwable)e, new Object[0]);
                }
                catch (NotExistsException e) {
                    // empty catch block
                }
                if (ghc != null) {
                    throw new GridHomeServerException((MessageKey)PrCgMsgID.ADD_GHS_WITH_GHC_PRESENT, new Object[0]);
                }
            }
            AdminHelperFactoryImpl ahFact = null;
            AdminHelper helper = null;
            try {
                ahFact = AdminHelperFactoryImpl.getInstance();
                helper = ahFact.createAdminHelper(version);
            }
            catch (AlreadyExistsException e) {
                try {
                    helper = ahFact.getAdminHelper();
                }
                catch (NotExistsException nee) {
                    throw new GridHomeServerException(nee);
                }
                catch (AdminHelperException ahe) {
                    throw new GridHomeServerException(ahe);
                }
            }
            catch (AdminHelperException e) {
                throw new GridHomeServerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (SoftwareModuleException e) {
                throw new GridHomeServerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            GridHomeServerException ghsExcpt = null;
            try {
                List<ResourceAttribute> attrList;
                ResourceAttribute ghsTypeAttr;
                AsmClusterFileSystem acfs;
                String emailAddress = null;
                String mailServerAddress = null;
                String mailServerPort = null;
                Util utl = new Util();
                String crsHome = utl.getCRSHome();
                String crsUser = utl.getOracleUser(crsHome, null);
                SRVMHELPERUtil shu = new SRVMHELPERUtil(crsHome);
                DiskGroup diskGroup = dgList.get(0);
                String dgName = diskGroup.getUserAssignedName();
                ASMCMDUtil asmcmdutil = new ASMCMDUtil(crsHome);
                ASMFactoryImpl asmFactImpl = ASMFactoryImpl.getInstance();
                if (isUpg) {
                    String voldev = asmcmdutil.getVolumeDevice(dgName, CHECKPT_VOLNAME, crsUser);
                    acfs = asmFactImpl.getAsmClusterFileSystem(voldev);
                } else {
                    if (ghsArgs == null || !ghsArgs.getForce()) {
                        try {
                            Trace.out("Check if the mgmtdb is running");
                            if (!mgmtDB.isRunning()) {
                                Trace.out("Mgmtdb is not running, starting it");
                                mgmtDB.start();
                            }
                        }
                        catch (AlreadyRunningException are) {
                            Trace.out("Management database is already running");
                        }
                        Trace.out("Going to create credentials for grid home");
                        shu.runMgmtca(crsUser);
                    }
                    String mtptPath = storagePath + File.separator + CHECKPT_BASE_DIR;
                    Trace.out(" Going to create volume");
                    try {
                        if (plsnrClient != null) {
                            plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.CREATING_VOLUME, false));
                        }
                        asmcmdutil.createVolume(dgName, CHECKPT_VOLNAME, 5, crsUser);
                    }
                    catch (AlreadyExistsException e) {
                        Trace.out(" volume already exists");
                    }
                    catch (NotExistsException e) {
                        // empty catch block
                    }
                    String voldev = asmcmdutil.getVolumeDevice(dgName, CHECKPT_VOLNAME, crsUser);
                    Trace.out(" Going to create file system and its resource");
                    OFSUtil acfsutil = new OFSUtil(true);
                    if (plsnrClient != null) {
                        plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.CHECK_FS_EXISTENCE, false));
                    }
                    try {
                        asmFactImpl.getFileSystem(voldev);
                        Trace.out(" File system exists already");
                    }
                    catch (NotExistsException e) {
                        if (plsnrClient != null) {
                            plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.CREATING_ACFS, false));
                        }
                        acfsutil.createACFSfs(voldev, crsUser);
                    }
                    try {
                        acfs = asmFactImpl.createAsmClusterFileSystem(voldev, CHECKPT_VOLNAME, dgName, mtptPath, crsUser, new Version());
                    }
                    catch (AlreadyExistsException e) {
                        Trace.out(" File system resource already exists");
                        acfs = asmFactImpl.getAsmClusterFileSystem(voldev);
                    }
                    try {
                        if (plsnrClient != null) {
                            plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.STARTING_ACFS, false));
                        }
                        Trace.out(" Going to start file system resource");
                        acfs.start();
                        File chkDir = new File(mtptPath + File.separator + CHECKPT_DIR);
                        shu.makeDir(crsUser, utl.getLocalHostName(), chkDir.getCanonicalPath());
                    }
                    catch (AlreadyRunningException e) {
                        Trace.out(" File system resource already started");
                    }
                    catch (IOException e) {
                        throw new GridHomeServerException(e);
                    }
                    catch (CmdToolUtilException e) {
                        throw new GridHomeServerException(e);
                    }
                    try {
                        if (plsnrClient != null) {
                            plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.CREATE_AUTH_KEYS, false));
                        }
                        ghFactImpl.createAuthKeys();
                    }
                    catch (SoftwareModuleException e) {
                        throw new GridHomeServerException(e);
                    }
                    if (ghsArgs != null) {
                        emailAddress = ghsArgs.getEmailAddress();
                        mailServerAddress = ghsArgs.getMailServerAddress();
                        mailServerPort = ghsArgs.getMailServerPort();
                    }
                    if (emailAddress != null) {
                        this.createNotificationCredentials(ghsArgs);
                    }
                }
                shu.createGHCreds(crsUser, null, "false", isUpg);
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                if (this.m_tomcat) {
                    ghsTypeAttr = crsFactory.create(ResourceType.RHPS.NAME.name(), ResourceType.RHPS.NAME.toString());
                    attrList = crsFactory.getResourceTypeEntity(ghsTypeAttr).getAttributes(new String[0]);
                    attrList = ResourceType.getProfile(attrList);
                    for (ResourceAttribute attr : attrList) {
                        if (attr.getName().equalsIgnoreCase(ResourceType.RHPS.NAME.name())) {
                            attr.setValue(GridHomeServerImpl.getResourceName2());
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase(ResourceType.RHPS.DESCRIPTION.name())) {
                            attr.setValue(ResourceLiterals.RHPS_RES_DESC.toString());
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase(ResourceType.RHPS.STORAGE_BASE_PATH.name())) {
                            attr.setValue(storagePath);
                            continue;
                        }
                        if (emailAddress != null && attr.getName().equalsIgnoreCase(ResourceType.RHPS.EMAIL_ADDRESS.name())) {
                            attr.setValue(emailAddress);
                            continue;
                        }
                        if (mailServerAddress != null && attr.getName().equalsIgnoreCase(ResourceType.RHPS.MAIL_SERVER_ADDRESS.name())) {
                            attr.setValue(mailServerAddress);
                            continue;
                        }
                        if (mailServerPort == null || !attr.getName().equalsIgnoreCase(ResourceType.RHPS.MAIL_SERVER_PORT.name())) continue;
                        attr.setValue(String.valueOf(mailServerPort));
                    }
                } else {
                    ghsTypeAttr = crsFactory.create(ResourceType.GHS.NAME.name(), ResourceType.GHS.NAME.toString());
                    attrList = crsFactory.getResourceTypeEntity(ghsTypeAttr).getAttributes(new String[0]);
                    attrList = ResourceType.getProfile(attrList);
                    for (ResourceAttribute attr : attrList) {
                        if (attr.getName().equalsIgnoreCase(ResourceType.GHS.NAME.name())) {
                            attr.setValue(GridHomeServerImpl.getResourceName());
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase(ResourceType.GHS.DESCRIPTION.name())) {
                            attr.setValue(ResourceLiterals.GHS_RES_DESC.toString());
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase(ResourceType.GHS.STORAGE_BASE_PATH.name())) {
                            attr.setValue(storagePath);
                            continue;
                        }
                        if (emailAddress != null && attr.getName().equalsIgnoreCase(ResourceType.GHS.EMAIL_ADDRESS.name())) {
                            attr.setValue(emailAddress);
                            continue;
                        }
                        if (mailServerAddress != null && attr.getName().equalsIgnoreCase(ResourceType.GHS.MAIL_SERVER_ADDRESS.name())) {
                            attr.setValue(mailServerAddress);
                            continue;
                        }
                        if (mailServerPort == null || !attr.getName().equalsIgnoreCase(ResourceType.GHS.MAIL_SERVER_PORT.name())) continue;
                        attr.setValue(String.valueOf(mailServerPort));
                    }
                }
                attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
                ResourceDependency dbHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Database.NAME.name(), DatabaseImpl.getResourceName(ResourceLiterals.MGMTDB_UNIQUE_NAME.toString())), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                ResourceDependency helperHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.ADMINHELPER.NAME.name(), helper.getName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                ResourceDependency acfsHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfs.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                ResourceDependency acfsPullup = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfs.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                StringBuilder dgSB = null;
                for (DiskGroup dg : dgList) {
                    if (dgSB != null) {
                        dgSB.append("," + dg.getName());
                        continue;
                    }
                    dgSB = new StringBuilder(dg.getName());
                }
                ResourceDependency dgWeakDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.DiskGroup.NAME.name(), dgSB.toString()), ResourceDependency.DepType.WEAK_DEP, new ResourceDependency.DepModifier[0]);
                ResourceDependency acfsStopDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfs.getName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
                ResourceAttribute startDep = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(dgWeakDep, dbHardDep, helperHardDep, acfsHardDep, acfsPullup));
                ResourceAttribute stopDep = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(acfsStopDep));
                attrList.add(startDep);
                attrList.add(stopDep);
                if (new SystemFactory().CreateSystem().isUnixSystem()) {
                    ResourcePermissionsImpl perm = crsFactory.createPerm(ResourceType.ACL_CREATOR.ROOT);
                    String user = perm.getUsers().get(0);
                    Trace.out("user = " + user);
                    perm.setPerm(ResourceType.ACL.USER, user, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
                    attrList.add(crsFactory.create(ResourceLiterals.ACL_ATTR.toString(), perm.getAclString()));
                }
                boolean force = ghsArgs != null && ghsArgs.getForce();
                this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, force);
            }
            catch (AsmClusterFileSystemException | CmdToolUtilException | GridHomeException | NotExistsException | UtilException e) {
                ghsExcpt = new GridHomeServerException((MessageKey)PrCgMsgID.CREATE_GHS_FAILED, e, new Object[0]);
            }
            catch (SoftwareModuleException | CRSException e) {
                ghsExcpt = new GridHomeServerException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            finally {
                if (ghsExcpt == null) break block84;
                Trace.out("Cleaning up since an exception is encountered");
                try {
                    if (plsnrClient != null) {
                        plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.CHECK_CLIENT_EXISTENCE, false));
                    }
                    this.internalRemove(dgList, true, true, plsnrClient, false);
                }
                catch (AlreadyRunningException e) {
                    Trace.out(" Already runningexception" + e);
                }
                throw ghsExcpt;
            }
        }
    }

    @Override
    public int port() throws GridHomeServerException {
        try {
            if (this.m_tomcat) {
                ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.RHPS.PORT.name());
                return Integer.parseInt(attr.getValue().trim());
            }
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.GHS.PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (NumberFormatException | CRSException e) {
            Trace.out("%s, %s", e.getClass().getSimpleName(), e.getMessage());
            throw new GridHomeServerException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setPort(int port) throws GridHomeServerException {
        this.setPort(port, false);
    }

    @Override
    public void setPort(int port, boolean force) throws GridHomeServerException {
        String[] ipOrNodeList = null;
        if (oracle.cluster.impl.util.Utils.isPriviledgedPort(port)) {
            Trace.out("Port " + port + " is in privileged port range.");
            throw new GridHomeServerException((MessageKey)PrCnMsgID.INVALID_PORT_PRIVILEGED, Integer.toString(port));
        }
        try {
            ipOrNodeList = Cluster.getNodes();
            int[] portList = new int[]{port};
            NodeAppsFactoryImpl.getInstance().checkPorts(ipOrNodeList, portList);
        }
        catch (ClusterException ce) {
            Trace.out("Unable to retrieve the list of nodes.");
            throw new GridHomeServerException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_LIST_OF_NODES, new Object[0]);
        }
        catch (SoftwareModuleException sfe) {
            Trace.out("This exception should never be encoutnered.");
            Trace.out("Checking the availability of port " + port + " failed.");
            throw new GridHomeServerException((MessageKey)PrCnMsgID.CHECK_PORT_AVAILABILITY_FAILURE, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            String localNodeName = "";
            Trace.out("Port " + port + " is not available on node " + localNodeName + " (local node)." + "Details: " + coe.getMessage());
            StringBuilder nodeListStrBuilder = new StringBuilder("");
            for (int i = 0; i < ipOrNodeList.length; ++i) {
                if (i == 0) {
                    nodeListStrBuilder.append(ipOrNodeList[i]);
                    continue;
                }
                nodeListStrBuilder.append(", ");
                nodeListStrBuilder.append(ipOrNodeList[i]);
            }
            Exception nestedException = null;
            try {
                nestedException = coe.getException(String.valueOf(port));
            }
            catch (NoSuchIdentifierException nsie) {
                Trace.out("NoSuchIdentifierException thrown b/c there is no key \"" + String.valueOf(port) + "\" in the map m_resultMap of " + "the CompositeOperationException. Details: " + nsie.getMessage());
            }
            throw new GridHomeServerException((MessageKey)PrCnMsgID.PORT_NOT_AVAILABLE_ACROSS_NODES, port, nodeListStrBuilder.toString(), nestedException);
        }
        try {
            boolean restartResource;
            Trace.out("Port" + Integer.toString(port) + " is available");
            boolean bl = restartResource = force && this.isRunning();
            if (restartResource) {
                try {
                    this.stop(force);
                }
                catch (AlreadyStoppedException ase) {
                    Trace.out("Resource already stopped. Continue set port");
                }
            }
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPS.PORT.name(), String.valueOf(port)));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHS.PORT.name(), String.valueOf(port)));
            }
            if (restartResource) {
                try {
                    this.start();
                }
                catch (AlreadyRunningException are) {
                    Trace.out("Resource already running.");
                }
            }
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.SET_GHS_PORT_FAILED, (Throwable)e, port);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.SET_GHS_PORT_FAILED, (Throwable)e, port);
        }
    }

    @Override
    public String getStoragePath() throws GridHomeServerException {
        try {
            if (this.m_tomcat) {
                return this.m_crsResource.getAttribute(ResourceType.RHPS.STORAGE_BASE_PATH.name()).getValue();
            }
            return this.m_crsResource.getAttribute(ResourceType.GHS.STORAGE_BASE_PATH.name()).getValue();
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_STORAGE_PATH_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public String getSWCopyMethod() throws GridHomeServerException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.RHPS.SWCOPY_METHOD.name()).getValue();
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_SWCOPY_METHOD_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public CryptoAlg getCryptoAlg() throws GridHomeServerException {
        try {
            if (this.m_tomcat) {
                String alg = this.m_crsResource.getAttribute(ResourceType.RHPS.CRYPTO_ALGORITHM.name()).getValue();
                return CryptoAlg.getEnumMember(alg);
            }
            String alg = this.m_crsResource.getAttribute(ResourceType.GHS.CRYPTO_ALGORITHM.name()).getValue();
            return CryptoAlg.getEnumMember(alg);
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GHS_GET_CRYPTO_ALGO_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (EnumConstNotFoundException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GHS_GET_CRYPTO_ALGO_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setEmailAddress(String emailAddress) throws GridHomeServerException {
        try {
            super.setEmailAddress(emailAddress);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public String getEmailAddress() throws GridHomeServerException {
        try {
            return super.getEmailAddress();
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public void setMailServerAddress(String mailServer) throws GridHomeServerException {
        try {
            super.setMailServerAddress(mailServer);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public String getMailServerAddress() throws GridHomeServerException {
        try {
            return super.getMailServerAddress();
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public void setMailServerPort(String port) throws GridHomeServerException {
        try {
            super.setMailServerPort(port);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public String getMailServerPort() throws GridHomeServerException {
        try {
            return super.getMailServerPort();
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public String getCkptBase() throws GridHomeServerException {
        return this.getStoragePath() + File.separator + CHECKPT_BASE_DIR + File.separator + CHECKPT_DIR;
    }

    @Override
    public void setStoragePath(String storagePath) throws GridHomeServerException {
        if ((storagePath = storagePath.trim()).endsWith(File.separator)) {
            storagePath = storagePath.substring(0, storagePath.length() - 1);
        }
        this.assertStoragePath(storagePath);
        try {
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPS.STORAGE_BASE_PATH.name(), storagePath));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHS.STORAGE_BASE_PATH.name(), storagePath));
            }
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.SET_STORAGE_PATH_FAILED, (Throwable)e, storagePath, this.getUserAssignedName());
        }
    }

    @Override
    public void setGNSDependencies(boolean bAdd) throws GridHomeServerException {
        Trace.out("Updating GNS dependencies...");
        String gnsName = GNSImpl.getResourceName();
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute startAttr = this.m_crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
            ResourceAttribute stopAttr = this.m_crsResource.getAttributes(ResourceType.LocalResource.STOP_DEPENDENCIES.name()).get(0);
            Trace.out("Before update: " + startAttr.getName() + "=" + startAttr.getValue());
            Trace.out("Before update: " + stopAttr.getName() + "=" + stopAttr.getValue());
            if (!(bAdd || startAttr.getValue().contains(gnsName) && stopAttr.getValue().contains(gnsName))) {
                Trace.out("GNS dependencies do not exist on RHPS.");
                return;
            }
            ResourceAttribute gnsAttr = crsFactory.create(ResourceType.GNS.NAME.name(), gnsName);
            if (bAdd) {
                ResourceDependency.updateDependencyAttrModifier(true, startAttr, gnsAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                ResourceDependency.updateDependencyAttrModifier(true, startAttr, gnsAttr, ResourceDependency.DepType.PULLUP_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                ResourceDependency.updateDependencyAttrModifier(true, stopAttr, gnsAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            } else {
                ResourceDependency.updateDependencyAttrModifier(false, startAttr, gnsAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                ResourceDependency.updateDependencyAttrModifier(false, startAttr, gnsAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                ResourceDependency.updateDependencyAttrModifier(false, stopAttr, gnsAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            }
            this.m_crsResource.update(startAttr, stopAttr);
            Trace.out("After update: " + startAttr.getName() + "=" + startAttr.getValue());
            Trace.out("After update: " + stopAttr.getName() + "=" + stopAttr.getValue());
        }
        catch (CRSException e) {
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public boolean isClientExists() throws GridHomeServerException {
        try {
            String isGHCsExists;
            try {
                isGHCsExists = this.m_crsResource.getAttribute(ResourceType.RHPS.RHPC_EXIST.name()).getValue();
                Trace.out((Object)"RHPC exist: %s", isGHCsExists);
            }
            catch (CRSException e) {
                if (e.getMessage().contains(RES_NOT_FOUND_ERR)) {
                    isGHCsExists = this.m_crsResource.getAttribute(ResourceType.GHS.GHC_EXIST.name()).getValue();
                    Trace.out((Object)"GHC exist: %s", isGHCsExists);
                }
                Trace.out((Object)"CRSException: %s", e.getMessage());
                throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_IS_GHC_EXISTS_FAILED, (Throwable)e, new Object[0]);
            }
            return Boolean.parseBoolean(isGHCsExists);
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_IS_GHC_EXISTS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setClientExists(boolean isExists) throws GridHomeServerException {
        try {
            String exists = Boolean.valueOf(isExists).toString().toLowerCase();
            Trace.out((Object)"Setting Client Exists to %s", exists);
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPS.RHPC_EXIST.name(), exists));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHS.GHC_EXIST.name(), exists));
            }
            Trace.out((Object)"END..Setting Client Exists to %s", exists);
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeServerException((MessageKey)PrCgMsgID.SET_IS_GHC_EXISTS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean imageExists() throws GridHomeServerException {
        try {
            String imagesExist = this.m_crsResource.getAttribute(ResourceType.GHS.IMAGE_EXIST.name()).getValue();
            Trace.out("Images exist on RHPS..." + imagesExist);
            return Boolean.parseBoolean(imagesExist);
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_IMAGE_EXIST_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setImageExists(boolean exists) throws GridHomeServerException {
        try {
            Trace.out("Setting images exist on RHPS...." + Boolean.valueOf(exists).toString());
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHS.IMAGE_EXIST.name(), Boolean.valueOf(exists).toString().toLowerCase()));
            Trace.out("END..Setting the images exist..." + Boolean.valueOf(exists).toString());
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeServerException((MessageKey)PrCgMsgID.SET_IMAGE_EXIST_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public String getDatabaseName() throws GridHomeServerException {
        return ResourceLiterals.GHS_DBNAME.toString();
    }

    @Override
    public String getDatabaseSchema() throws GridHomeServerException {
        try {
            if (this.m_tomcat) {
                return this.m_crsResource.getAttribute(ResourceType.RHPS.DB_SCHEMA.name()).getValue();
            }
            return this.m_crsResource.getAttribute(ResourceType.GHS.DB_SCHEMA.name()).getValue();
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_DBSCHEMA_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void addDiskGroup(DiskGroup dg) throws GridHomeServerException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute resAttr = this.m_crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
            ResourceAttribute dgAttr = crsFactory.create(ResourceType.DiskGroup.NAME.name(), dg.getName());
            ResourceDependency.updateDependency(resAttr, dgAttr, ResourceDependency.DepType.WEAK_DEP, true);
            this.m_crsResource.update(resAttr);
        }
        catch (CRSException e) {
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public void removeDiskGroup(DiskGroup dg) throws GridHomeServerException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute resAttr = this.m_crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
            ResourceAttribute dgAttr = crsFactory.create(ResourceType.DiskGroup.NAME.name(), dg.getName());
            ResourceDependency.updateDependency(resAttr, dgAttr, ResourceDependency.DepType.WEAK_DEP, false);
            this.m_crsResource.update(resAttr);
        }
        catch (CRSException e) {
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public List<DiskGroup> diskGroups() throws GridHomeServerException {
        try {
            ArrayList<Object> dgList = null;
            ResourceAttribute startDepAttr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            Trace.out("start value = " + startDepAttr.getValue());
            String[] resNames = ResourceDependency.getResourceNames(startDepAttr, ResourceDependency.DepType.WEAK_DEP);
            if (resNames.length == 0) {
                dgList = new ArrayList<DiskGroup>(0);
            } else {
                Trace.out("resNames length is " + resNames.length);
                ASMFactoryImpl asmFactory = ASMFactoryImpl.getInstance();
                dgList = new ArrayList(resNames.length);
                for (String resourceName : resNames) {
                    Trace.out("resourceName = " + resourceName);
                    try {
                        String dgName = null;
                        try {
                            dgName = DiskGroupImpl.getUserAssignedName((String)resourceName);
                        }
                        catch (ASMException e) {
                            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_DISKGROUP_FAILED, (Throwable)e, this.getUserAssignedName());
                        }
                        Trace.out("disk group name = " + dgName);
                        dgList.add(asmFactory.getDiskGroup(dgName));
                    }
                    catch (NotExistsException ne) {
                        throw new GridHomeServerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)ne, resourceName, this.getUserAssignedName());
                    }
                }
            }
            return dgList;
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_DISKGROUP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_DISKGROUP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    private void removeStorage(List<DiskGroup> dgList) throws GridHomeServerException {
        try {
            ASMFactoryImpl asmfactImpl = ASMFactoryImpl.getInstance();
            List volList = null;
            try {
                volList = asmfactImpl.getVolumes(null, CHECKPT_VOLNAME, null);
            }
            catch (NotExistsException e) {
                Trace.out("exception here is okay, logging exception: " + e.getMessage());
                return;
            }
            String dgName = null;
            String volDevice = null;
            for (Volume vol : volList) {
                for (DiskGroup dg : dgList) {
                    if (!vol.getDiskGroup().equalsIgnoreCase(dg.getUserAssignedName())) continue;
                    dgName = dg.getUserAssignedName();
                    volDevice = vol.getVolumeDevice();
                    break;
                }
                if (dgName == null) continue;
                break;
            }
            if (dgName == null) {
                Trace.out("No volume has been created");
                return;
            }
            AsmClusterFileSystem acfs = null;
            try {
                acfs = asmfactImpl.getAsmClusterFileSystem(volDevice);
                try {
                    acfs.stop(true);
                }
                catch (AlreadyStoppedException e) {
                    Trace.out("exception here is okay, logging exception: " + e.getMessage());
                }
                catch (SoftwareModuleException e) {
                    Trace.out("exception here is okay, logging exception: " + e.getMessage());
                }
                try {
                    acfs.remove(true);
                }
                catch (AlreadyRunningException e) {
                    Trace.out("exception here is okay, logging exception: " + e.getMessage());
                }
            }
            catch (NotExistsException e) {
                Trace.out("exception here is okay, logging exception: " + e.getMessage());
            }
            Util utl = new Util();
            String crsHome = utl.getCRSHome();
            String crsUser = utl.getOracleUser(crsHome, null);
            ASMCMDUtil asmcmdutil = new ASMCMDUtil(crsHome);
            asmcmdutil.deleteVolume(CHECKPT_VOLNAME, dgName, crsUser);
        }
        catch (CmdToolUtilException e) {
            throw new GridHomeServerException(e);
        }
        catch (NotExistsException e) {
            throw new GridHomeServerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException(e);
        }
        catch (UtilException e) {
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public void remove(boolean force, ProgressListener plsnrClient) throws AlreadyRunningException, GridHomeServerException {
        this.internalRemove(null, force, false, plsnrClient, false);
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, GridHomeServerException {
        this.remove(force, null);
    }

    @Override
    public void removeResOnly() throws AlreadyRunningException, GridHomeServerException {
        this.internalRemove(null, true, false, null, true);
    }

    private void internalRemove(List<DiskGroup> diskGroupList, boolean force, boolean toIgnore, ProgressListener plsnrClient, boolean resOnly) throws AlreadyRunningException, GridHomeServerException {
        block29: {
            try {
                NodeAppsFactoryImpl.getInstance().assertRoot();
            }
            catch (SoftwareModuleException e) {
                throw new GridHomeServerException(e);
            }
            try {
                List<DiskGroup> dglist = diskGroupList;
                boolean isExist = true;
                if (toIgnore) {
                    try {
                        this.crsResource();
                        isExist = true;
                    }
                    catch (NotExistsException e) {
                        isExist = false;
                        Trace.out("resource does not exist, message: " + e.getMessage());
                    }
                }
                if (isExist) {
                    boolean isUp = this.isRunning();
                    if (!force) {
                        if (plsnrClient != null) {
                            plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.CHECK_CLIENT_EXISTENCE, false));
                        }
                        boolean isClientsExists = this.isClientExists();
                        Trace.out((Object)"Client exists: %s", String.valueOf(isClientsExists));
                        if (isClientsExists) {
                            Trace.out("Failed to delete GHS as one or more GHCs exist and no force option specified");
                            throw new GridHomeServerException((MessageKey)PrCgMsgID.DELETE_GHS_FAILED_GHCS_EXIST, new Object[0]);
                        }
                        if (this.imageExists()) {
                            throw new GridHomeServerException((MessageKey)PrCgMsgID.DELETE_GHS_FAILED_IMAGES_EXIST, new Object[0]);
                        }
                        if (isUp) {
                            throw new AlreadyRunningException((MessageKey)PrCgMsgID.GHS_IS_RUNNING, new Object[0]);
                        }
                    }
                    if (isUp) {
                        try {
                            if (plsnrClient != null) {
                                plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.STOP_GHS, false));
                            }
                            this.stop(force);
                        }
                        catch (AlreadyStoppedException e) {
                            Trace.out("exception here is okay, logging exception: " + e.getMessage());
                        }
                    }
                    if (dglist == null) {
                        if (plsnrClient != null) {
                            plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.RETRIEVE_DISKGROUP_LIST, false));
                        }
                        Trace.out("Retrieving list of diskgroups");
                        dglist = this.diskGroups();
                    }
                    if (!resOnly) {
                        this.removeNotificationCredentials();
                    }
                    super.remove(force);
                }
                if (resOnly) break block29;
                if (plsnrClient != null) {
                    plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.REMOVE_DISKGROUP_LIST, false));
                }
                this.removeStorage(dglist);
                this.removeAllAdminHelpers();
                try {
                    AdminHelperFactoryImpl ahFact = AdminHelperFactoryImpl.getInstance();
                    AdminHelper helper = ahFact.getAdminHelper();
                    helper.remove(true);
                }
                catch (NotExistsException ahFact) {
                }
                catch (AdminHelperException ahe) {
                    throw new GridHomeServerException(ahe);
                }
                try {
                    this.removeEncryptKeyCredentials();
                }
                catch (CredentialsException e) {
                    Trace.out("Received Credentials exception while deleting the encrypt key " + e.getMessage());
                    throw new GridHomeServerException(e);
                }
                catch (NotExistsException e) {
                    Trace.out("Received Not exixts exception while deleting the encrypt key " + e.getMessage());
                }
                GridHomeFactoryImpl ghFactImpl = GridHomeFactoryImpl.getInstance();
                if (plsnrClient != null) {
                    plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.DELETE_AUTH_KEYS, false));
                }
                ghFactImpl.deleteAuthKeys();
            }
            catch (GridHomeException e) {
                Trace.out("GridHomeException: " + e.getMessage());
                throw new GridHomeServerException(e);
            }
            catch (SoftwareModuleException e) {
                Trace.out("SoftwareModuleException: " + e.getMessage());
                throw new GridHomeServerException(e);
            }
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, GridHomeServerException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void start(Node node) throws AlreadyRunningException, GridHomeServerException {
        try {
            super.start(node);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException(e);
        }
        Trace.out("Creating encrypt key credentials");
        this.createEncryptKeyCredentials();
    }

    @Override
    public void start() throws AlreadyRunningException, GridHomeServerException {
        try {
            super.start();
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException(e);
        }
        Trace.out("Creating encrypt key credentials");
        this.createEncryptKeyCredentials();
    }

    @Override
    public void enable(Node node) throws AlreadyEnabledException, GridHomeServerException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.enable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new GridHomeServerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public void disable(Node node) throws AlreadyDisabledException, GridHomeServerException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.disable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new GridHomeServerException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.GHS.toString();
    }

    public static String getResourceName2() {
        return "ora." + ResourceLiterals.RHPSERVER.toString();
    }

    private void assertStoragePath(String sPath) throws GridHomeServerException {
        if (sPath == null || sPath.trim().length() == 0) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sPath");
        }
        if (!new File(sPath).isAbsolute()) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.INVALID_STORAGE_PATH, sPath);
        }
    }

    private void createEncryptKeyCredentials() throws GridHomeServerException {
        try {
            char[] encryptKeyArr = CredentialsFactory.generateRandomPassword();
            String encryptKey = String.valueOf(encryptKeyArr);
            byte[] byteArr = encryptKey.getBytes();
            String hexEncryptKey = new CryptoUtil().byte2Hex(byteArr);
            Trace.out("Search Gridhome domain and place the new domain under it");
            CredentialsFactory credFact = CredentialsFactory.getInstance();
            CredDomain gridhomeDomain = credFact.getDomainByPath(CredentialsFactoryImpl.DOMAIN, true);
            CredDomain encryptKeyDomain = credFact.createDomain("ENCRYPT_KEY", gridhomeDomain);
            CredentialsSet encryptKeyCredSet = encryptKeyDomain.createCredentialSet(CredentialsType.SHAREDKEY);
            encryptKeyCredSet.createSharedKeyCredentials(hexEncryptKey);
            Util utl = new Util();
            if (utl.hasHAPrivilege()) {
                Trace.out("Setting CRS user permissions for encrypt key");
                String crsUser = utl.getCRSUser();
                String pGroup = utl.getPrimaryGroup(crsUser);
                encryptKeyDomain.setOwner(crsUser);
                Trace.out("Setting READ group permissions to GRIDHOME. Group : " + pGroup);
                gridhomeDomain.setPGroup(pGroup);
                gridhomeDomain.setPGroupPerms(CredentialsACLPerm.READ);
            }
        }
        catch (CredentialsException e) {
            Trace.out("Caught credential exception while writing encrypt key: " + e.getMessage());
            throw new GridHomeServerException(e);
        }
        catch (NotExistsException e) {
            Trace.out("Caught Not exists exception while writing encrypt key: " + e.getMessage());
            throw new GridHomeServerException(e);
        }
        catch (UtilException e) {
            Trace.out("Caught Util exception while writing encrypt key: " + e.getMessage());
            throw new GridHomeServerException(e);
        }
        catch (AlreadyExistsException e) {
            Trace.out("Caught credential exception while writing encrypt key: " + e.getMessage());
            Trace.out("Ignore this error as we are fine if encrypt key credentials already  exist");
        }
    }

    private void removeEncryptKeyCredentials() throws CredentialsException, NotExistsException {
        Trace.out("Search Gridhome domain and place the new domain under it");
        CredentialsFactory credFact = CredentialsFactory.getInstance();
        CredDomain gridhomeDomain = credFact.getDomainByPath(CredentialsFactoryImpl.DOMAIN, true);
        CredDomain encryptKeyDomain = credFact.getDomainByPath("ENCRYPT_KEY", gridhomeDomain);
        encryptKeyDomain.remove();
    }

    @Override
    public String getEncryptKey() throws GridHomeServerException {
        try {
            CredentialsFactory credFact = CredentialsFactory.getInstance();
            CredDomain gridhomeDomain = credFact.getDomainByPath(CredentialsFactoryImpl.DOMAIN, true);
            CredDomain encryptKeyDomain = credFact.getDomainByPath("ENCRYPT_KEY", gridhomeDomain);
            CredentialsSet encryptKeyCredSet = encryptKeyDomain.getCredentialsSet(CredentialsType.SHAREDKEY);
            SharedKeyCredentials cred = encryptKeyCredSet.getSharedKeyCredentials(0);
            return cred.getSharedKey();
        }
        catch (CredentialsException e) {
            Trace.out("Caught Credentials exception while retreieving encrypt key " + e.getMessage());
            throw new GridHomeServerException(e);
        }
        catch (NotExistsException e) {
            Trace.out("Caught Not exists exception while retreieving encrypt key " + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    void modify(GridHomeServerArgs ghsArgs) throws GridHomeServerException {
        if (ghsArgs == null) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ghsArgs");
        }
        try {
            if (ghsArgs.getEmailAddress() != null || ghsArgs.getMailServerAddress() != null || ghsArgs.getMailServerPort() != null) {
                this.modifyNotificationCredentials(ghsArgs);
            }
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    @Override
    public boolean isGIPatchinProgress() throws GridHomeServerException {
        try {
            String isGIPatchinProgress = null;
            isGIPatchinProgress = this.m_tomcat ? this.m_crsResource.getAttribute(ResourceType.RHPS.GIPATCH_INPROGRESS.name()).getValue() : this.m_crsResource.getAttribute(ResourceType.GHS.GIPATCH_INPROGRESS.name()).getValue();
            Trace.out((Object)"Is GI Patch in progress ... %s", isGIPatchinProgress);
            return Boolean.parseBoolean(isGIPatchinProgress);
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeServerException((MessageKey)PrCgMsgID.GET_IS_GIPATCH_PROGRESS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setGIPatchinProgress(boolean isGIPatchinProgress) throws GridHomeServerException {
        try {
            String val = Boolean.valueOf(isGIPatchinProgress).toString();
            Trace.out((Object)"Setting the GI Patch in progress to %s", val);
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPS.GIPATCH_INPROGRESS.name(), val.toLowerCase()));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHS.GIPATCH_INPROGRESS.name(), val.toLowerCase()));
            }
            Trace.out((Object)"END..Setting the GI Patch in progress to %s", val);
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeServerException((MessageKey)PrCgMsgID.SET_IS_GIPATCH_PROGRESS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean isTLSEnabled() throws GridHomeServerException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.RHPS.TLS_ENABLED.name());
            return Boolean.parseBoolean(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCnMsgID.GET_TLS_ENABLED_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    static {
        m_msgBndl_PrCg.setPackage("oracle.cluster.resources");
    }
}

