/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.SRVMHELPERUtil;
import oracle.cluster.common.NodeRole;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.crs.CRSException;
import oracle.cluster.gridhome.GHContainerType;
import oracle.cluster.gridhome.GridHomeClient;
import oracle.cluster.gridhome.GridHomeClientArgs;
import oracle.cluster.gridhome.GridHomeClientException;
import oracle.cluster.gridhome.GridHomeException;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.gridhome.GridHomeServer;
import oracle.cluster.gridhome.GridHomeServerArgs;
import oracle.cluster.gridhome.GridHomeServerException;
import oracle.cluster.gridhome.RHPContainerType;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.gridhome.GridHomeClientImpl;
import oracle.cluster.impl.gridhome.GridHomeServerImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GridHomeFactoryImpl {
    private static GridHomeFactoryImpl s_instance;
    private boolean m_tomcat = Utils.useTomcat();

    private GridHomeFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized GridHomeFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new GridHomeFactoryImpl();
        }
        return s_instance;
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version) throws AlreadyExistsException, GridHomeServerException {
        return this.createGridHomeServer(storagePath, dgList, version, null, null);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, boolean isUpg) throws AlreadyExistsException, GridHomeServerException {
        return this.doCreateGridHomeServer(storagePath, dgList, version, null, null, isUpg);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient) throws AlreadyExistsException, GridHomeServerException {
        return this.createGridHomeServer(storagePath, dgList, version, plsnrClient, null);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, GridHomeServerArgs ghsArgs) throws AlreadyExistsException, GridHomeServerException {
        return this.createGridHomeServer(storagePath, dgList, version, null, ghsArgs);
    }

    public GridHomeServer createGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient, GridHomeServerArgs ghsArgs) throws AlreadyExistsException, GridHomeServerException {
        return this.doCreateGridHomeServer(storagePath, dgList, version, plsnrClient, ghsArgs, false);
    }

    private GridHomeServer doCreateGridHomeServer(String storagePath, List<DiskGroup> dgList, Version version, ProgressListener plsnrClient, GridHomeServerArgs ghsArgs, boolean isUpg) throws AlreadyExistsException, GridHomeServerException {
        if (storagePath == null || storagePath.trim().length() == 0) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "storagePath");
        }
        if (dgList == null || dgList.size() == 0) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgList");
        }
        if (version == null) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeServerException(e);
        }
        try {
            if (new ClusterUtil().getNodeActiveRole() == NodeRole.RIM) {
                throw new GridHomeServerException((MessageKey)PrCgMsgID.CREATE_GHS_FROM_LEAF, new Object[0]);
            }
        }
        catch (ClusterUtilException e) {
            Trace.out("clusterutil exception while checking for node role");
            throw new GridHomeServerException(e);
        }
        try {
            this.validateADVMCompatibility(dgList, true, false);
        }
        catch (GridHomeClientException e) {
            Trace.out("Should never come here");
        }
        try {
            GridHomeServerImpl ghsImpl = null;
            if (this.m_tomcat) {
                Trace.out("Using Tomcat");
                ghsImpl = new GridHomeServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.RHPS.NAME.name(), GridHomeServerImpl.getResourceName2()));
            } else {
                Trace.out("Using OC4J");
                ghsImpl = new GridHomeServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.GHS.NAME.name(), GridHomeServerImpl.getResourceName()));
            }
            ghsImpl.create(storagePath, dgList, version, plsnrClient, ghsArgs, isUpg);
            return ghsImpl;
        }
        catch (CRSException e) {
            throw new GridHomeServerException((MessageKey)PrCgMsgID.CREATE_GHS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public GridHomeServer getGridHomeServer() throws NotExistsException, GridHomeServerException {
        return this.getGridHomeServer(new Version());
    }

    public GridHomeServer getGridHomeServer(Version ver) throws NotExistsException, GridHomeServerException {
        try {
            GridHomeServerImpl ghsImpl;
            if (Version.isPre122(ver) || !this.m_tomcat) {
                Trace.out("Returning GHS resource");
                ghsImpl = new GridHomeServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.GHS.NAME.name(), GridHomeServerImpl.getResourceName()));
            } else {
                Trace.out("Returning RHPS resource");
                ghsImpl = new GridHomeServerImpl(CRSFactoryImpl.getInstance().create(ResourceType.RHPS.NAME.name(), GridHomeServerImpl.getResourceName2()));
            }
            ghsImpl.crsResource();
            return ghsImpl;
        }
        catch (SoftwareModuleException | CRSException e) {
            Trace.out("%s: %s", e.getClass().getSimpleName(), e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    public static String getRHPSSchemaName() {
        String ver = "GHSUSER" + new Version().toString();
        int aux = ver.lastIndexOf(".");
        return ver.substring(0, aux).replaceAll("\\.", "");
    }

    public GridHomeClient createGridHomeClient(String clientData, Version version) throws AlreadyExistsException, GridHomeClientException {
        return this.doCreateGridHomeClient(clientData, null, version, null);
    }

    public GridHomeClient createGridHomeClient(String clientData, GridHomeClientArgs ghcArgs, Version version) throws AlreadyExistsException, GridHomeClientException {
        return this.createGridHomeClient(clientData, ghcArgs, version, null);
    }

    public GridHomeClient createGridHomeClient(String clientData, GridHomeClientArgs ghcArgs, Version version, ProgressListener plsnrClient) throws AlreadyExistsException, GridHomeClientException {
        if (ghcArgs == null) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ghcArgs");
        }
        return this.doCreateGridHomeClient(clientData, ghcArgs, version, plsnrClient);
    }

    private GridHomeClient doCreateGridHomeClient(String clientData, GridHomeClientArgs ghcArgs, Version version, ProgressListener plsnrClient) throws AlreadyExistsException, GridHomeClientException {
        if (clientData == null || clientData.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "clientData");
        }
        if (version == null) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException(e);
        }
        DiskGroup diskGroup = null;
        if (ghcArgs != null) {
            diskGroup = ghcArgs.getDiskGroup();
        }
        if (diskGroup != null) {
            ArrayList<DiskGroup> dgList = new ArrayList<DiskGroup>();
            dgList.add(diskGroup);
            try {
                this.validateADVMCompatibility(dgList, false, false);
            }
            catch (GridHomeServerException e) {
                Trace.out("Should never come here");
            }
        }
        try {
            CredentialsFactory cfact = CredentialsFactory.getInstance();
            String clusterName = cfact.getCredentialProperty(clientData, "GH_attributes", "GHC_SITE_NAME");
            if (!clusterName.equalsIgnoreCase(this.getGridHomeSiteName())) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.WRONG_CRED_FILE, clusterName, this.getGridHomeSiteName());
            }
            GridHomeClientImpl ghcImpl = null;
            if (this.m_tomcat) {
                Trace.out("Using Tomcat");
                ghcImpl = new GridHomeClientImpl(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.NAME.name(), GridHomeClientImpl.getResourceName2()));
            } else {
                Trace.out("Using OC4J");
                ghcImpl = new GridHomeClientImpl(CRSFactoryImpl.getInstance().create(ResourceType.GHC.NAME.name(), GridHomeClientImpl.getResourceName()));
            }
            ghcImpl.create(clientData, ghcArgs, version, plsnrClient);
            return ghcImpl;
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.CREATE_GHC_FAILED, (Throwable)e, new Object[0]);
        }
        catch (CredentialsException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.CREATE_GHC_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public GridHomeClient getGridHomeClient() throws NotExistsException, GridHomeClientException {
        return this.getGridHomeClient(new Version());
    }

    public GridHomeClient getGridHomeClient(Version ver) throws NotExistsException, GridHomeClientException {
        try {
            GridHomeClientImpl ghcImpl;
            if (Version.isPre122(ver) || !this.m_tomcat) {
                Trace.out("Returning GHC resource");
                ghcImpl = new GridHomeClientImpl(CRSFactoryImpl.getInstance().create(ResourceType.GHC.NAME.name(), GridHomeClientImpl.getResourceName()));
            } else {
                Trace.out("Returning RHPC resource");
                ghcImpl = new GridHomeClientImpl(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.NAME.name(), GridHomeClientImpl.getResourceName2()));
            }
            ghcImpl.crsResource();
            return ghcImpl;
        }
        catch (SoftwareModuleException | CRSException e) {
            Trace.out("%s: %s", e.getClass().getSimpleName(), e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    public void modifyGridHomeClient(GridHomeClientArgs ghcArgs) throws NotExistsException, GridHomeClientException {
        if (ghcArgs == null) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ghcArgs");
        }
        try {
            this.assertNonRootUser();
        }
        catch (GridHomeException e) {
            throw new GridHomeClientException(e);
        }
        DiskGroup diskGroup = ghcArgs.getDiskGroup();
        if (diskGroup != null) {
            ArrayList<DiskGroup> dgList = new ArrayList<DiskGroup>();
            dgList.add(diskGroup);
            try {
                this.validateADVMCompatibility(dgList, false, true);
            }
            catch (GridHomeServerException e) {
                Trace.out("Should never come here");
            }
        }
        GridHomeClientImpl ghcImpl = (GridHomeClientImpl)this.getGridHomeClient();
        ghcImpl.modify(ghcArgs);
    }

    public void modifyGridHomeServer(GridHomeServerArgs ghsArgs) throws NotExistsException, GridHomeServerException {
        if (ghsArgs == null) {
            throw new GridHomeServerException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ghsArgs");
        }
        try {
            this.assertNonRootUser();
        }
        catch (GridHomeException e) {
            throw new GridHomeServerException(e);
        }
        GridHomeServerImpl ghsImpl = (GridHomeServerImpl)this.getGridHomeServer();
        ghsImpl.modify(ghsArgs);
    }

    public GHContainerType getGridHomeClusterType() throws SoftwareModuleException {
        GHContainerType ghType = GHContainerType.NONE;
        try {
            GridHomeServer ghs = this.getGridHomeServer();
            ghType = GHContainerType.GHS;
        }
        catch (NotExistsException nee) {
            try {
                GridHomeClient ghc = this.getGridHomeClient();
                ghType = GHContainerType.GHC;
            }
            catch (NotExistsException ne) {
                Trace.out("GHC Not exists Exception: " + ne.getMessage());
                throw new SoftwareModuleException((MessageKey)PrCgMsgID.GHS_GHC_NOT_EXISTS, (Throwable)ne, new Object[0]);
            }
            catch (GridHomeClientException ghce) {
                Trace.out("GHC Exception : " + ghce.getMessage());
                throw new SoftwareModuleException(ghce);
            }
        }
        catch (GridHomeServerException ghse) {
            Trace.out("GHS Exception : " + ghse.getMessage());
            throw new SoftwareModuleException(ghse);
        }
        return ghType;
    }

    public RHPContainerType getRHPClusterType() throws GridHomeException {
        RHPContainerType ghType = RHPContainerType.NONE;
        try {
            this.getGridHomeServer();
            ghType = RHPContainerType.RHPS;
        }
        catch (NotExistsException nee) {
            try {
                this.getGridHomeClient();
                ghType = RHPContainerType.RHPC;
            }
            catch (NotExistsException ne) {
                Trace.out("RHP does not exist ");
                ghType = RHPContainerType.NONE;
            }
            catch (GridHomeClientException ghce) {
                Trace.out("GridHomeClientException : " + ghce.getMessage());
                throw new GridHomeException(ghce);
            }
        }
        catch (GridHomeServerException ghse) {
            Trace.out("GridHomeServerException : " + ghse.getMessage());
            throw new GridHomeException(ghse);
        }
        return ghType;
    }

    public String getGridHomeSiteName() throws GridHomeClientException {
        try {
            return new ClusterUtil().getClusterName();
        }
        catch (ClusterUtilException e) {
            throw new GridHomeClientException(e);
        }
    }

    public void createAuthKeys() throws SoftwareModuleException {
        try {
            Util utl = new Util();
            OCR ocr = OCR.init(3);
            String crsHome = utl.getCRSHome();
            String sysKey = "SYSTEM";
            String GHKey = sysKey + "." + "GRIDHOME";
            String uAuthKey = GHKey + "." + "USERAUTH";
            ocr.createKey(GHKey, 6, sysKey, crsHome);
            ocr.createKey(uAuthKey, 6, GHKey, crsHome);
        }
        catch (OCRException e) {
            throw new SoftwareModuleException(e);
        }
        catch (UtilException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public void deleteAuthKeys() throws SoftwareModuleException {
        try {
            OCR ocr = OCR.init(3);
            ocr.deleteKey("SYSTEM.GRIDHOME", true);
        }
        catch (OCRException e) {
            throw new SoftwareModuleException(e);
        }
    }

    private void validateADVMCompatibility(List<DiskGroup> dgList, boolean isGHS, boolean isModify) throws GridHomeServerException, GridHomeClientException {
        try {
            Util utl = new Util();
            String crsHome = utl.getCRSHome();
            String crsUser = utl.getOracleUser(crsHome, null);
            ASMCMDUtil asmcmd = new ASMCMDUtil(crsHome);
            Version advmCmpVersion = null;
            String dgName = null;
            for (DiskGroup dg : dgList) {
                dgName = dg.getUserAssignedName();
                advmCmpVersion = isModify ? asmcmd.getADVMCompatibility(dgName) : asmcmd.getADVMCompatibility(dgName, crsUser);
                Trace.out("ADVM compatibility version for DG " + dgName + ": " + advmCmpVersion.toString());
                if (!Version.isPre12c(advmCmpVersion)) continue;
                Trace.out("ADVM compatibility is less than 12.1.0.0 for disk group " + dg.getName());
                if (isGHS) {
                    throw new GridHomeServerException((MessageKey)PrCgMsgID.GHS_DG_ADVMCOMPAT_FAILED, advmCmpVersion.toString(), dgName);
                }
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GHS_DG_ADVMCOMPAT_FAILED, advmCmpVersion.toString(), dgName);
            }
        }
        catch (UtilException ue) {
            Trace.out(ue.getMessage());
            if (isGHS) {
                throw new GridHomeServerException(ue);
            }
            throw new GridHomeClientException(ue);
        }
        catch (CmdToolUtilException cue) {
            Trace.out(cue.getMessage());
            if (isGHS) {
                throw new GridHomeServerException(cue);
            }
            throw new GridHomeClientException(cue);
        }
    }

    private void assertNonRootUser() throws GridHomeException {
        Util utl = null;
        try {
            utl = new Util();
            if (utl.hasHAPrivilege()) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.PRIV_USER, new Object[0]);
            }
        }
        catch (UtilException ue) {
            throw new GridHomeException(ue);
        }
    }

    public void resetRepos() throws GridHomeServerException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
            Util utl = new Util();
            String crsHome = utl.getCRSHome();
            String crsUser = utl.getOracleUser(crsHome, null);
            SRVMHELPERUtil shu = new SRVMHELPERUtil(crsHome);
            shu.resetRepos(crsUser);
            try {
                this.getGridHomeServer().setClientExists(false);
            }
            catch (NotExistsException e) {
                Trace.out((Object)"NotExistsException: %s", e.getMessage());
            }
        }
        catch (CmdToolUtilException | SoftwareModuleException | UtilException e) {
            Trace.out("%s: %s", e.getClass().getSimpleName(), e.getMessage());
            throw new GridHomeServerException(e);
        }
    }

    public void upgradeClientFrom121() throws AlreadyExistsException, GridHomeClientException {
        try {
            GridHomeClientImpl ghc = new GridHomeClientImpl(CRSFactoryImpl.getInstance().create(ResourceType.GHC.NAME.name(), GridHomeClientImpl.getResourceName()));
            ghc.crsResource();
            try {
                ghc.stop(false);
            }
            catch (AlreadyStoppedException e) {
                Trace.out("GHC already stopped");
            }
            GridHomeClientImpl rhpc = new GridHomeClientImpl(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.NAME.name(), GridHomeClientImpl.getResourceName2()));
            rhpc.upgradeFrom121(ghc);
            rhpc.disable();
        }
        catch (AlreadyDisabledException | NotExistsException e) {
            Trace.out((Object)"Ignoring %s for RHPC", e.getClass().getSimpleName());
        }
        catch (SoftwareModuleException | CRSException e) {
            Trace.out("%s: %s", e.getClass().getSimpleName(), e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    public boolean isTLSEnabled() throws SoftwareModuleException {
        GridHomeFactory ghFact = null;
        try {
            ghFact = GridHomeFactory.getInstance();
            GridHomeServer ghs = ghFact.getGridHomeServer();
            return ghs.isTLSEnabled();
        }
        catch (NotExistsException e) {
            try {
                GridHomeClient ghc = ghFact.getGridHomeClient();
                return ghc.isTLSEnabled();
            }
            catch (NotExistsException ex) {
                throw new SoftwareModuleException(ex);
            }
            catch (GridHomeClientException e1) {
                throw new SoftwareModuleException(e1);
            }
        }
    }
}

