/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome;

import java.util.Map;
import oracle.cluster.adminhelper.AdminHelper;
import oracle.cluster.adminhelper.AdminHelperException;
import oracle.cluster.adminhelper.AdminHelperFactory;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.email.Email;
import oracle.cluster.email.EmailException;
import oracle.cluster.email.EmailFactory;
import oracle.cluster.gridhome.GridHomeArgs;
import oracle.cluster.gridhome.GridHomeException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.email.EmailImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class GridHomeCommonImpl
extends SoftwareModuleImpl {
    protected ResourceAttribute m_nameAttr;
    protected static final String GRIDHOME_DOMAIN = "GRIDHOME";
    protected static final String NOTIFICATION_SUB_DOMAIN = "@NOTIFICATION";
    private static MessageBundle m_msgBndl = MessageBundle.getMessageBundle(PrCgMsgID.facility);

    protected void setEmailAddress(String emailAddress) throws GridHomeException {
        Trace.out("Email address is..." + emailAddress);
        try {
            this.sureNotNull(emailAddress, "emailAddress");
            if (emailAddress.trim().length() != 0) {
                GridHomeArgs ghArgs = new GridHomeArgs();
                ghArgs.checkEmailAddressFormat(emailAddress);
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceLiterals.EMAIL_ADDRESS.toString(), emailAddress));
        }
        catch (CRSException e) {
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_SET_EMAIL_ADDRESS_FAILED, (Throwable)e, emailAddress);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeException(e);
        }
    }

    public String getEmailAddress() throws GridHomeException {
        try {
            String emailAddress = this.m_crsResource.getAttribute(ResourceLiterals.EMAIL_ADDRESS.toString()).getValue();
            return emailAddress;
        }
        catch (CRSException e) {
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_GET_EMAIL_ADDRESS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public void setMailServerAddress(String mailServer) throws GridHomeException {
        Trace.out("Mail server address is...." + mailServer);
        try {
            this.sureNotNull(mailServer, "mailServerAddress");
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceLiterals.MAIL_SERVER_ADDRESS.toString(), mailServer));
        }
        catch (CRSException e) {
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_SET_MAIL_SERVER_ADDRESS_FAILED, (Throwable)e, mailServer);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeException(e);
        }
    }

    public String getMailServerAddress() throws GridHomeException {
        try {
            String mailServerAddress = this.m_crsResource.getAttribute(ResourceLiterals.MAIL_SERVER_ADDRESS.toString()).getValue();
            return mailServerAddress;
        }
        catch (CRSException e) {
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_GET_MAIL_SERVER_ADDRESS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public void setMailServerPort(String mailServerPort) throws GridHomeException {
        Trace.out("Mail server prot is...." + mailServerPort);
        try {
            this.sureNotNull(mailServerPort, "mailServerPort");
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceLiterals.MAIL_SERVER_PORT.toString(), String.valueOf(mailServerPort)));
        }
        catch (CRSException e) {
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_SET_MAIL_SERVER_PORT_FAILED, (Throwable)e, mailServerPort);
        }
    }

    public String getMailServerPort() throws GridHomeException {
        try {
            String mailServerPort = this.m_crsResource.getAttribute(ResourceLiterals.MAIL_SERVER_PORT.toString()).getValue();
            Trace.out("Mail server port is..." + mailServerPort);
            return mailServerPort;
        }
        catch (CRSException e) {
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_GET_MAIL_SERVER_PORT_FAILED, (Throwable)e, new Object[0]);
        }
    }

    protected void createNotificationCredentials(GridHomeArgs ghArgs) throws GridHomeException {
        try {
            EmailFactory mailFact = EmailFactory.getInstance();
            EmailImpl email = new EmailImpl(ghArgs.getEmailAddress(), ghArgs.getPassword(), ghArgs.getMailServerAddress(), Integer.parseInt(ghArgs.getMailServerPort()), GRIDHOME_DOMAIN, NOTIFICATION_SUB_DOMAIN);
            mailFact.registerEmail(email);
            email.sendEmail(m_msgBndl.getMessage(PrCgMsgID.REGISTER_EMAIL_ADDRESS_RHP_SUBJECT, false), m_msgBndl.getMessage(PrCgMsgID.REGISTER_EMAIL_ADDRESS_RHP_MESSAGE, false), ghArgs.getEmailAddress());
        }
        catch (EmailException e) {
            Trace.out("EmailException ..." + e.getMessage());
            throw new GridHomeException(e);
        }
    }

    protected void modifyNotificationCredentials(GridHomeArgs ghArgs) throws GridHomeException {
        block13: {
            String emailAddress = "";
            String mailServerAddress = "";
            String mailServerPort = "";
            try {
                Object sb = null;
                String emailAddressOpt = ghArgs.getEmailAddress();
                String mailServerAddressOpt = ghArgs.getMailServerAddress();
                String mailServerPortOpt = ghArgs.getMailServerPort();
                emailAddress = this.getEmailAddress();
                mailServerAddress = this.getMailServerAddress();
                mailServerPort = this.getMailServerPort();
                Trace.out("Email address option is..." + emailAddressOpt + " resource attr value is..." + emailAddress);
                Trace.out("mail server address option is..." + mailServerAddressOpt + " resource attr value is..." + mailServerAddress);
                Trace.out("mail server port option is..." + mailServerPortOpt + " resource attr value is..." + mailServerPort);
                boolean isEmailSet = emailAddress.trim().length() != 0 && emailAddressOpt == null || emailAddressOpt != null && emailAddressOpt.trim().length() != 0;
                Trace.out("Is email set...." + isEmailSet);
                boolean isMailServerSet = mailServerAddress.trim().length() != 0 && mailServerAddressOpt == null || mailServerAddressOpt != null && mailServerAddressOpt.trim().length() != 0;
                Trace.out("is mailserver address set...." + isMailServerSet);
                boolean isMailPortSet = mailServerPort.trim().length() != 0 && mailServerPortOpt == null || mailServerPortOpt != null && mailServerPortOpt.trim().length() != 0;
                Trace.out("is mailserver port set...." + isMailPortSet);
                boolean isModifyAllowed = isEmailSet && isMailServerSet && isMailPortSet || !isEmailSet && !isMailServerSet && !isMailPortSet;
                Trace.out("Is modify operation allowed? : " + isModifyAllowed);
                if (!isModifyAllowed) {
                    Trace.out("Modification of RHP instance failed either all options need to set or unset");
                    throw new GridHomeException((MessageKey)PrCgMsgID.MODIFY_RHP_FAILED, true);
                }
                if (emailAddressOpt != null) {
                    Trace.out("Setting email attr with " + emailAddressOpt);
                    this.setEmailAddress(emailAddressOpt);
                    Trace.out("DONE:Setting email attr with " + emailAddressOpt);
                }
                if (mailServerAddressOpt != null) {
                    Trace.out("Setting server addr attr with " + mailServerAddressOpt);
                    this.setMailServerAddress(mailServerAddressOpt);
                    Trace.out("DONE: Setting server addr attr with " + mailServerAddressOpt);
                }
                if (mailServerPortOpt != null) {
                    Trace.out("Setting port attr with " + mailServerPortOpt);
                    this.setMailServerPort(mailServerPortOpt);
                    Trace.out("DONE: Setting port attr with " + mailServerPortOpt);
                }
                EmailFactory mailFact = EmailFactory.getInstance();
                Email email = null;
                if (emailAddressOpt != null) {
                    if (emailAddressOpt.trim().length() != 0) {
                        try {
                            Trace.out("Fetching and and modifying the credentials...");
                            email = mailFact.getEmail(GRIDHOME_DOMAIN, NOTIFICATION_SUB_DOMAIN, mailServerAddress, mailServerPort.length() > 0 ? Integer.parseInt(mailServerPort) : 0);
                            email.modify(this.getEmailAddress(), ghArgs.getPassword(), this.getMailServerAddress(), this.getMailServerPort().length() > 0 ? Integer.parseInt(this.getMailServerPort()) : 0);
                        }
                        catch (NotExistsException e) {
                            Trace.out("Credentials not exists....creating it...");
                            email = new EmailImpl(this.getEmailAddress(), ghArgs.getPassword(), this.getMailServerAddress(), this.getMailServerPort().length() > 0 ? Integer.parseInt(this.getMailServerPort()) : 0, GRIDHOME_DOMAIN, NOTIFICATION_SUB_DOMAIN);
                            mailFact.registerEmail(email);
                        }
                        email.sendEmail(m_msgBndl.getMessage(PrCgMsgID.MODIFY_EMAIL_ADDRESS_RHP_SUBJECT, false), m_msgBndl.getMessage(PrCgMsgID.REGISTER_EMAIL_ADDRESS_RHP_MESSAGE, false), this.getEmailAddress());
                        break block13;
                    }
                    Trace.out("Removing the notification credentials...");
                    this.removeNotificationCredentials();
                    break block13;
                }
                if (emailAddress.trim().length() != 0) {
                    try {
                        Trace.out("Fetching and sending mail....");
                        email = mailFact.getEmail(GRIDHOME_DOMAIN, NOTIFICATION_SUB_DOMAIN, this.getMailServerAddress(), this.getMailServerPort().length() > 0 ? Integer.parseInt(this.getMailServerPort()) : 0);
                        email.sendEmail(m_msgBndl.getMessage(PrCgMsgID.REGISTER_EMAIL_ADDRESS_RHP_SUBJECT, false), m_msgBndl.getMessage(PrCgMsgID.REGISTER_EMAIL_ADDRESS_RHP_MESSAGE, false), this.getEmailAddress());
                    }
                    catch (NotExistsException e) {
                        Trace.out("RHP instance was not configured with email notification");
                    }
                }
            }
            catch (EmailException e) {
                this.setEmailAddress(emailAddress);
                this.setMailServerAddress(mailServerAddress);
                this.setMailServerPort(mailServerPort);
                Trace.out("EmailException..." + e.getMessage());
                throw new GridHomeException(e);
            }
        }
    }

    protected void removeNotificationCredentials() throws GridHomeException {
        try {
            if (this.isConfigured()) {
                EmailFactory mailFact = EmailFactory.getInstance();
                Email email = mailFact.getEmail(GRIDHOME_DOMAIN, NOTIFICATION_SUB_DOMAIN, this.getMailServerAddress(), this.getMailServerPort().length() > 0 ? Integer.parseInt(this.getMailServerPort()) : 0);
                email.remove();
            }
        }
        catch (EmailException e) {
            Trace.out("EmailException..." + e.getMessage());
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_REMOVE_EMAIL_CREDENTIALS_FAILED, (Throwable)e, new Object[0]);
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException..." + e.getMessage());
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException..." + e.getMessage());
            throw new GridHomeException((MessageKey)PrCgMsgID.RHP_REMOVE_EMAIL_CREDENTIALS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    protected void sureNotNull(Object o, String name) throws GridHomeException {
        if (o == null) {
            throw new GridHomeException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, name);
        }
    }

    public void removeAllAdminHelpers() throws GridHomeException {
        try {
            Trace.out("Entering removeAllAdminHelpers");
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.ADMINHELPER.NAME.toString());
            String attrName = ResourceType.ADMINHELPER.NAME.name();
            Map<String, Map<String, String>> rData = crsFactory.searchEntities(CRSEntity.Type.Resource, false, typeFilter, attrName);
            AdminHelperFactory admhf = AdminHelperFactory.getInstance();
            AdminHelper helper = null;
            for (String riId : rData.keySet()) {
                Trace.out("riId: " + riId);
                Map<String, String> tmp = rData.get(riId);
                String helperName = tmp.get(attrName);
                Trace.out("helper name : " + helperName);
                if (!helperName.endsWith(ResourceLiterals.ADMINHELPERSUFFIX.toString())) {
                    Trace.out("Skipping default helper: " + helperName);
                    continue;
                }
                try {
                    helper = admhf.getAdminHelper(helperName);
                    Trace.out("Removing helper " + helperName);
                    if (helper.isRunning()) {
                        try {
                            helper.stop(true);
                        }
                        catch (AlreadyStoppedException e) {
                            Trace.out("AlreadyStoppedException: " + e.getMessage());
                        }
                    }
                    helper.remove(true);
                    Trace.out("Admin helper removed succesfully.");
                }
                catch (AdminHelperException e) {
                    Trace.out("AdminHelperException: " + e.getMessage());
                }
                catch (SoftwareModuleException e) {
                    Trace.out("SoftwareModuleException: " + e.getMessage());
                }
                catch (NotExistsException e) {
                    Trace.out("NotExistsException: " + e.getMessage());
                }
                catch (AlreadyRunningException e) {
                    Trace.out("AlreadyRunningException: " + e.getMessage());
                }
            }
            Trace.out("Exiting removeAllAdminHelpers");
        }
        catch (CRSException e) {
            Trace.out("CRSException: " + e.getMessage());
            throw new GridHomeException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException: " + e.getMessage());
            throw new GridHomeException(e);
        }
    }

    static {
        m_msgBndl.setPackage("oracle.cluster.resources");
    }
}

