/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.adminhelper.AdminHelper;
import oracle.cluster.adminhelper.AdminHelperException;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.SRVMHELPERUtil;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gridhome.GridHomeClient;
import oracle.cluster.gridhome.GridHomeClientArgs;
import oracle.cluster.gridhome.GridHomeClientException;
import oracle.cluster.gridhome.GridHomeException;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.gridhome.GridHomeServer;
import oracle.cluster.gridhome.credentials.CredentialsFactory;
import oracle.cluster.impl.adminhelper.AdminHelperFactoryImpl;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.DiskGroupImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.gridhome.GridHomeCommonImpl;
import oracle.cluster.impl.gridhome.GridHomeFactoryImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.jwccred.common.StoreException;
import oracle.cluster.jwccred.seckeys.KeytoolUtilFactory;
import oracle.cluster.jwccred.seckeys.impl.CRSKeytoolUtil;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.CryptoAlg;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GridHomeClientImpl
extends GridHomeCommonImpl
implements GridHomeClient {
    public static final String GHS_SITE_NAME = "GHS_SITE_NAME";
    public static final String GNS_DISCOVERY_STRING = "GNS_DISCOVERY_STRING";
    public static final String GNS_SUBDOMAIN_STRING = "GNS_SUBDOMAIN_STRING";
    public static final String RHPS_CERTIFICATE = "RHPS_CERTIFICATE";
    public static final String RHPS_GUID = "RHPS_GUID";
    private static final String RES_NOT_FOUND_ERR = "PRCR-1097";
    private static final MessageBundle m_msgBndl_PrCg = MessageBundle.getMessageBundle(PrCgMsgID.facility);
    private boolean m_tomcat = Utils.useTomcat();

    GridHomeClientImpl(ResourceAttribute nameAttr) throws GridHomeClientException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.GHC.NAME.name()) && !nameAttr.getName().equalsIgnoreCase(ResourceType.RHPC.NAME.name())) {
                throw new GridHomeClientException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.GHC.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.GHC.toString().equalsIgnoreCase(values[numValues - 1]) && !ResourceLiterals.RHPCLIENT.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new GridHomeClientException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, this.m_tomcat ? ResourceType.RHPC.NAME.name() : ResourceType.GHC.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            this.m_crsResource = (CRSResourceImpl)((Object)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr));
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new GridHomeClientException(e);
        }
    }

    void create(String clientData, Version version) throws AlreadyExistsException, GridHomeClientException {
        this.create(clientData, null, version);
    }

    void create(String clientData, GridHomeClientArgs ghcArgs, Version version, ProgressListener plsnrClient) throws AlreadyExistsException, GridHomeClientException {
        this.create(clientData, ghcArgs, version, plsnrClient, null);
    }

    void create(String clientData, GridHomeClientArgs ghcArgs, Version version, ProgressListener plsnrClient, GridHomeClient ghc) throws AlreadyExistsException, GridHomeClientException {
        boolean isUpg;
        GridHomeFactoryImpl ghFactImpl = null;
        boolean bl = isUpg = ghc != null;
        if (!isUpg) {
            this.assertClientData(clientData);
            GridHomeServer ghs = null;
            try {
                ghFactImpl = GridHomeFactoryImpl.getInstance();
                ghs = ghFactImpl.getGridHomeServer();
            }
            catch (SoftwareModuleException e) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_GHS_RES_FAILED, (Throwable)e, new Object[0]);
            }
            catch (NotExistsException e) {
                // empty catch block
            }
            if (ghs != null) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.ADD_GHC_WITH_GHS_PRESENT, new Object[0]);
            }
        }
        AdminHelperFactoryImpl ahFact = null;
        AdminHelper helper = null;
        try {
            ahFact = AdminHelperFactoryImpl.getInstance();
            helper = ahFact.createAdminHelper(version);
        }
        catch (AlreadyExistsException e) {
            try {
                helper = ahFact.getAdminHelper();
            }
            catch (NotExistsException nee) {
                throw new GridHomeClientException(nee);
            }
            catch (AdminHelperException ahe) {
                throw new GridHomeClientException(ahe);
            }
        }
        catch (AdminHelperException e) {
            throw new GridHomeClientException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        try {
            List<ResourceAttribute> attrList;
            ResourceAttribute ghcTypeAttr;
            String gnsSubDomainString;
            String gnsString;
            String serverClusterName;
            String clusterName;
            DiskGroup diskGroup = null;
            String storagePath = null;
            String emailAddress = null;
            String mailServerAddress = null;
            String mailServerPort = null;
            String rhpsCertificate = null;
            String rhpsGUID = null;
            String portStr = null;
            oracle.cluster.credentials.CredentialsFactory cfact = oracle.cluster.credentials.CredentialsFactory.getInstance();
            if (isUpg) {
                clusterName = GridHomeFactoryImpl.getInstance().getGridHomeSiteName();
                storagePath = ghc.getStoragePath();
                serverClusterName = ghc.getServerClusterName();
                gnsString = ghc.getGNSDiscoveryString();
                gnsSubDomainString = ghc.getGNSSubDomainString();
                portStr = String.valueOf(ghc.port());
                try {
                    diskGroup = ghc.diskGroup();
                }
                catch (NotExistsException e) {
                    Trace.out("No DG configured for GHC");
                }
            } else {
                clusterName = cfact.getCredentialProperty(clientData, "GH_attributes", "GHC_SITE_NAME");
                serverClusterName = cfact.getCredentialProperty(clientData, "GH_attributes", GHS_SITE_NAME);
                gnsString = cfact.getCredentialProperty(clientData, "GH_attributes", GNS_DISCOVERY_STRING);
                gnsSubDomainString = cfact.getCredentialProperty(clientData, "GH_attributes", GNS_SUBDOMAIN_STRING);
                rhpsCertificate = cfact.getCredentialProperty(clientData, "GH_attributes", RHPS_CERTIFICATE);
                rhpsGUID = cfact.getCredentialProperty(clientData, "GH_attributes", RHPS_GUID);
                if (ghcArgs != null) {
                    diskGroup = ghcArgs.getDiskGroup();
                    storagePath = ghcArgs.getStoragePath();
                    emailAddress = ghcArgs.getEmailAddress();
                    mailServerAddress = ghcArgs.getMailServerAddress();
                    mailServerPort = ghcArgs.getMailServerPort();
                }
                if (ResourceType.RHPC.TLS_ENABLED.toString().equalsIgnoreCase(Boolean.toString(true))) {
                    Trace.out("Adding rhps server trust entries. Certificate: " + rhpsCertificate + " GUID: " + rhpsGUID);
                    CRSKeytoolUtil crsKeyTool = KeytoolUtilFactory.getCRSKeytoolUtilInstance();
                    crsKeyTool.addTrustEntry(rhpsCertificate, rhpsGUID);
                }
            }
            if (emailAddress != null) {
                this.createNotificationCredentials(ghcArgs);
            }
            Util utl = new Util();
            String crsHome = utl.getCRSHome();
            String crsUser = utl.getOracleUser(crsHome, null);
            SRVMHELPERUtil shu = new SRVMHELPERUtil(crsHome);
            if (!isUpg) {
                Trace.out("START: Importing Client data");
                CredentialsFactory ghCredfact = CredentialsFactory.getInstance();
                if (plsnrClient != null) {
                    plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.IMPORT_CLIENT_DATA, false));
                }
                ghCredfact.importClientData(clusterName, clientData);
                Trace.out("END: Importing Client data");
                shu.createGHCreds(crsUser, clusterName, "false");
                if (plsnrClient != null) {
                    plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.CREATE_AUTH_KEYS, false));
                }
                ghFactImpl.createAuthKeys();
            } else {
                shu.createGHCreds(clusterName, "false");
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (this.m_tomcat) {
                ghcTypeAttr = crsFactory.create(ResourceType.RHPC.NAME.name(), ResourceType.RHPC.NAME.toString());
                attrList = crsFactory.getResourceTypeEntity(ghcTypeAttr).getAttributes(new String[0]);
                attrList = ResourceType.getProfile(attrList);
                for (ResourceAttribute attr : attrList) {
                    if (attr.getName().equalsIgnoreCase(ResourceType.RHPC.NAME.name())) {
                        attr.setValue(GridHomeClientImpl.getResourceName2());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.RHPC.DESCRIPTION.name())) {
                        attr.setValue(ResourceLiterals.RHPC_RES_DESC.toString());
                        continue;
                    }
                    if (storagePath != null && attr.getName().equalsIgnoreCase(ResourceType.RHPC.STORAGE_BASE_PATH.name())) {
                        attr.setValue(storagePath);
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.RHPC.RHPS_CLUSTERNAME.name())) {
                        attr.setValue(serverClusterName);
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.RHPC.GNS_DISCOVERY_STRING.name())) {
                        attr.setValue(gnsString);
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.RHPC.GNS_SUBDOMAIN_STRING.name())) {
                        attr.setValue(gnsSubDomainString);
                        continue;
                    }
                    if (portStr != null && attr.getName().equalsIgnoreCase(ResourceType.RHPC.PORT.name())) {
                        attr.setValue(portStr);
                        continue;
                    }
                    if (emailAddress != null && attr.getName().equalsIgnoreCase(ResourceType.RHPC.EMAIL_ADDRESS.name())) {
                        attr.setValue(emailAddress);
                        continue;
                    }
                    if (mailServerAddress != null && attr.getName().equalsIgnoreCase(ResourceType.RHPC.MAIL_SERVER_ADDRESS.name())) {
                        attr.setValue(mailServerAddress);
                        continue;
                    }
                    if (mailServerPort == null || !attr.getName().equalsIgnoreCase(ResourceType.RHPC.MAIL_SERVER_PORT.name())) continue;
                    attr.setValue(mailServerPort);
                }
            } else {
                ghcTypeAttr = crsFactory.create(ResourceType.GHC.NAME.name(), ResourceType.GHC.NAME.toString());
                attrList = crsFactory.getResourceTypeEntity(ghcTypeAttr).getAttributes(new String[0]);
                attrList = ResourceType.getProfile(attrList);
                for (ResourceAttribute attr : attrList) {
                    if (attr.getName().equalsIgnoreCase(ResourceType.GHC.NAME.name())) {
                        attr.setValue(GridHomeClientImpl.getResourceName());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.GHC.DESCRIPTION.name())) {
                        attr.setValue(ResourceLiterals.GHC_RES_DESC.toString());
                        continue;
                    }
                    if (storagePath != null && attr.getName().equalsIgnoreCase(ResourceType.GHC.STORAGE_BASE_PATH.name())) {
                        attr.setValue(storagePath);
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.GHC.GHS_CLUSTERNAME.name())) {
                        attr.setValue(serverClusterName);
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.GHC.GNS_DISCOVERY_STRING.name())) {
                        attr.setValue(gnsString);
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.GHC.GNS_SUBDOMAIN_STRING.name())) {
                        attr.setValue(gnsSubDomainString);
                        continue;
                    }
                    if (emailAddress != null && attr.getName().equalsIgnoreCase(ResourceType.GHC.EMAIL_ADDRESS.name())) {
                        attr.setValue(emailAddress);
                        continue;
                    }
                    if (mailServerAddress != null && attr.getName().equalsIgnoreCase(ResourceType.GHC.MAIL_SERVER_ADDRESS.name())) {
                        attr.setValue(mailServerAddress);
                        continue;
                    }
                    if (mailServerPort == null || !attr.getName().equalsIgnoreCase(ResourceType.GHC.MAIL_SERVER_PORT.name())) continue;
                    attr.setValue(mailServerPort);
                }
            }
            if (!isUpg) {
                GNSFactory gnsfact = GNSFactory.getInstance();
                if (plsnrClient != null) {
                    plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.QUERY_GNS_SERVER, false));
                }
                gnsfact.executeDNSQueryForHostPort(gnsString, gnsSubDomainString, "._OraGhs._tcp", serverClusterName);
            }
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            ResourceDependency helperHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.ADMINHELPER.NAME.name(), helper.getName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
            ResourceDependency dgWeakDep = diskGroup != null ? crsFactory.createResourceDependency(crsFactory.create(ResourceType.DiskGroup.NAME.name(), diskGroup.getName()), ResourceDependency.DepType.WEAK_DEP, new ResourceDependency.DepModifier[0]) : null;
            ResourceAttribute startDep = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(helperHardDep, dgWeakDep));
            attrList.add(startDep);
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                ResourcePermissionsImpl perm = crsFactory.createPerm(ResourceType.ACL_CREATOR.ROOT);
                String user = perm.getUsers().get(0);
                Trace.out("user = " + user);
                perm.setPerm(ResourceType.ACL.USER, user, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
                attrList.add(crsFactory.create(ResourceLiterals.ACL_ATTR.toString(), perm.getAclString()));
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
        }
        catch (CredentialsException e) {
            throw new GridHomeClientException(e);
        }
        catch (oracle.cluster.gridhome.credentials.CredentialsException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.IMPORT_CLIENTDATA_FAILED, (Throwable)e, clientData);
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (CmdToolUtilException e) {
            throw new GridHomeClientException(e);
        }
        catch (GNSException e) {
            Trace.out("GNSException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
        catch (VIPNotFoundException e) {
            Trace.out("VIPNotFoundException: " + e.getMessage());
            throw new GridHomeClientException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException(e);
        }
        catch (UtilException e) {
            throw new GridHomeClientException(e);
        }
        catch (StoreException e) {
            throw new GridHomeClientException(e);
        }
    }

    void upgradeFrom121(GridHomeClient ghc) throws AlreadyExistsException, GridHomeClientException {
        Trace.out("Upgrading GHC to RHPC");
        this.create(null, null, new Version(), null, ghc);
    }

    void create(String clientData, GridHomeClientArgs ghcArgs, Version version) throws AlreadyExistsException, GridHomeClientException {
        this.create(clientData, ghcArgs, version, null);
    }

    @Override
    public int port() throws GridHomeClientException {
        try {
            if (this.m_tomcat) {
                ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.RHPC.PORT.name());
                return Integer.parseInt(attr.getValue().trim());
            }
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.GHC.PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NumberFormatException ne) {
            throw new GridHomeClientException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)ne, this.getUserAssignedName());
        }
    }

    @Override
    public void setPort(int port) throws GridHomeClientException {
        String[] ipOrNodeList = null;
        if (oracle.cluster.impl.util.Utils.isPriviledgedPort(port)) {
            Trace.out("Port " + port + " is in privileged port range.");
            throw new GridHomeClientException((MessageKey)PrCnMsgID.INVALID_PORT_PRIVILEGED, Integer.toString(port));
        }
        try {
            ipOrNodeList = Cluster.getNodes();
            int[] portList = new int[]{port};
            NodeAppsFactoryImpl.getInstance().checkPorts(ipOrNodeList, portList);
        }
        catch (ClusterException ce) {
            Trace.out("Unable to retrieve the list of nodes.");
            throw new GridHomeClientException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_LIST_OF_NODES, new Object[0]);
        }
        catch (SoftwareModuleException sfe) {
            Trace.out("This exception should never be encoutnered.");
            Trace.out("Checking the availability of port " + port + " failed.");
            throw new GridHomeClientException((MessageKey)PrCnMsgID.CHECK_PORT_AVAILABILITY_FAILURE, new Object[0]);
        }
        catch (CompositeOperationException coe) {
            String localNodeName = "";
            Trace.out("Port " + port + " is not available on node " + localNodeName + " (local node)." + "Details: " + coe.getMessage());
            StringBuilder nodeListStrBuilder = new StringBuilder("");
            for (int i = 0; i < ipOrNodeList.length; ++i) {
                if (i == 0) {
                    nodeListStrBuilder.append(ipOrNodeList[i]);
                    continue;
                }
                nodeListStrBuilder.append(", ");
                nodeListStrBuilder.append(ipOrNodeList[i]);
            }
            Exception nestedException = null;
            try {
                nestedException = coe.getException(String.valueOf(port));
            }
            catch (NoSuchIdentifierException nsie) {
                Trace.out("NoSuchIdentifierException thrown b/c there is no key \"" + String.valueOf(port) + "\" in the map m_resultMap of " + "the CompositeOperationException. Details: " + nsie.getMessage());
            }
            throw new GridHomeClientException((MessageKey)PrCnMsgID.PORT_NOT_AVAILABLE_ACROSS_NODES, port, nodeListStrBuilder.toString(), nestedException);
        }
        try {
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.PORT.name(), String.valueOf(port)));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHC.PORT.name(), String.valueOf(port)));
            }
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.SET_GHC_PORT_FAILED, (Throwable)e, port);
        }
    }

    @Override
    public void setServerClusterName(String clusterName) throws GridHomeClientException {
        if (clusterName == null || clusterName.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "clusterName");
        }
        try {
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.RHPS_CLUSTERNAME.name(), clusterName));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHC.GHS_CLUSTERNAME.name(), clusterName));
            }
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.SET_GHS_CLUSTERNAME_FAILED, (Throwable)e, clusterName, this.getUserAssignedName());
        }
    }

    @Override
    public String getServerClusterName() throws GridHomeClientException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.RHPC.RHPS_CLUSTERNAME.name()).getValue();
        }
        catch (CRSException e) {
            try {
                if (e.getMessage().contains(RES_NOT_FOUND_ERR)) {
                    return this.m_crsResource.getAttribute(ResourceType.GHC.GHS_CLUSTERNAME.name()).getValue();
                }
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_GHS_CLUSTERNAME_FAILED, (Throwable)e, this.getUserAssignedName());
            }
            catch (CRSException e2) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_GHS_CLUSTERNAME_FAILED, (Throwable)e2, this.getUserAssignedName());
            }
        }
    }

    @Override
    public void setGNSDiscoveryString(String gnsStr) throws GridHomeClientException {
        if (gnsStr == null || gnsStr.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "gnsStr");
        }
        try {
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.GNS_DISCOVERY_STRING.name(), gnsStr));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHC.GNS_DISCOVERY_STRING.name(), gnsStr));
            }
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.SET_GNS_STRING_FAILED, (Throwable)e, gnsStr, this.getUserAssignedName());
        }
    }

    @Override
    public void setGNSSubDomainString(String gnsSubDomainStr) throws GridHomeClientException {
        if (gnsSubDomainStr == null || gnsSubDomainStr.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "gnsSubDomainStr");
        }
        try {
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.GNS_SUBDOMAIN_STRING.name(), gnsSubDomainStr));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHC.GNS_SUBDOMAIN_STRING.name(), gnsSubDomainStr));
            }
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.SET_GNS_SUBDOMAIN_STRING_FAILED, (Throwable)e, gnsSubDomainStr, this.getUserAssignedName());
        }
    }

    @Override
    public String getGNSDiscoveryString() throws GridHomeClientException {
        try {
            if (this.m_tomcat) {
                return this.m_crsResource.getAttribute(ResourceType.RHPC.GNS_DISCOVERY_STRING.name()).getValue();
            }
            return this.m_crsResource.getAttribute(ResourceType.GHC.GNS_DISCOVERY_STRING.name()).getValue();
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_GNS_STRING_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public String getGNSSubDomainString() throws GridHomeClientException {
        try {
            if (this.m_tomcat) {
                return this.m_crsResource.getAttribute(ResourceType.RHPC.GNS_SUBDOMAIN_STRING.name()).getValue();
            }
            return this.m_crsResource.getAttribute(ResourceType.GHC.GNS_SUBDOMAIN_STRING.name()).getValue();
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_GNS_SUBDOMAIN_STRING_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public CryptoAlg getCryptoAlg() throws GridHomeClientException {
        try {
            if (this.m_tomcat) {
                String alg = this.m_crsResource.getAttribute(ResourceType.RHPC.CRYPTO_ALGORITHM.name()).getValue();
                return CryptoAlg.getEnumMember(alg);
            }
            String alg = this.m_crsResource.getAttribute(ResourceType.GHC.CRYPTO_ALGORITHM.name()).getValue();
            return CryptoAlg.getEnumMember(alg);
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GHC_GET_CRYPTO_ALGO_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (EnumConstNotFoundException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GHC_GET_CRYPTO_ALGO_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setClientData(String clientData) throws GridHomeClientException {
        try {
            this.assertClientData(clientData);
            oracle.cluster.credentials.CredentialsFactory cfact = oracle.cluster.credentials.CredentialsFactory.getInstance();
            String clusterName = cfact.getCredentialProperty(clientData, "GH_attributes", "GHC_SITE_NAME");
            GridHomeFactory ghfact = GridHomeFactory.getInstance();
            if (!clusterName.equalsIgnoreCase(ghfact.getGridHomeSiteName())) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.WRONG_CRED_FILE, clusterName, ghfact.getGridHomeSiteName());
            }
            Trace.out("START: Importing Client data");
            CredentialsFactory ghCredfact = CredentialsFactory.getInstance();
            ghCredfact.importClientData(clusterName, clientData);
            Trace.out("END: Importing Client data");
            Util utl = new Util();
            String crsHome = utl.getCRSHome();
            SRVMHELPERUtil shu = new SRVMHELPERUtil(crsHome);
            shu.createGHCreds(clusterName, "true");
            String propval = cfact.getCredentialProperty(clientData, "GH_attributes", GHS_SITE_NAME);
            if (propval != null && propval.trim().length() != 0) {
                Trace.out("server cluster name = " + propval);
                this.setServerClusterName(propval);
            }
            if ((propval = cfact.getCredentialProperty(clientData, "GH_attributes", GNS_DISCOVERY_STRING)) != null && propval.trim().length() != 0) {
                Trace.out("GNS discovery string = " + propval);
                this.setGNSDiscoveryString(propval);
            }
            if ((propval = cfact.getCredentialProperty(clientData, "GH_attributes", GNS_SUBDOMAIN_STRING)) != null && propval.trim().length() != 0) {
                Trace.out("GNS subdomain string = " + propval);
                this.setGNSSubDomainString(propval);
            }
            if (this.isTLSEnabled()) {
                String rhpsCertificate = cfact.getCredentialProperty(clientData, "GH_attributes", RHPS_CERTIFICATE);
                String rhpsGUID = cfact.getCredentialProperty(clientData, "GH_attributes", RHPS_GUID);
                CRSKeytoolUtil crsKeyTool = KeytoolUtilFactory.getCRSKeytoolUtilInstance();
                crsKeyTool.addTrustEntry(rhpsCertificate, rhpsGUID);
            }
        }
        catch (CredentialsException e) {
            throw new GridHomeClientException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException(e);
        }
        catch (oracle.cluster.gridhome.credentials.CredentialsException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.IMPORT_CLIENTDATA_FAILED, (Throwable)e, clientData);
        }
        catch (CmdToolUtilException e) {
            throw new GridHomeClientException(e);
        }
        catch (UtilException e) {
            throw new GridHomeClientException(e);
        }
        catch (StoreException e) {
            throw new GridHomeClientException(e);
        }
    }

    public void setDiskGroup(DiskGroup dg) throws GridHomeClientException {
        if (dg == null) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dg");
        }
        try {
            try {
                DiskGroup existingDg = this.diskGroup();
                throw new GridHomeClientException((MessageKey)PrCgMsgID.DG_ALREADY_CONFIGURED, dg.getUserAssignedName());
            }
            catch (NotExistsException existingDg) {
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                ResourceAttribute resAttr = this.m_crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
                ResourceAttribute dgAttr = crsFactory.create(ResourceType.DiskGroup.NAME.name(), dg.getName());
                ResourceDependency.updateDependency(resAttr, dgAttr, ResourceDependency.DepType.WEAK_DEP, true);
                this.m_crsResource.update(resAttr);
            }
        }
        catch (CRSException e) {
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public DiskGroup diskGroup() throws NotExistsException, GridHomeClientException {
        try {
            ResourceAttribute startDepAttr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            Trace.out("start value = " + startDepAttr.getValue());
            String[] resNames = ResourceDependency.getResourceNames(startDepAttr, ResourceDependency.DepType.WEAK_DEP);
            if (resNames.length == 0) {
                throw new NotExistsException((MessageKey)PrCgMsgID.DG_NOT_CONFIGURED, new Object[0]);
            }
            Trace.out("resNames length is " + resNames.length);
            ASMFactoryImpl asmFactory = ASMFactoryImpl.getInstance();
            for (String resourceName : resNames) {
                Trace.out("resourceName = " + resourceName);
                try {
                    String dgName = null;
                    try {
                        dgName = DiskGroupImpl.getUserAssignedName((String)resourceName);
                    }
                    catch (ASMException e) {
                        continue;
                    }
                    Trace.out("disk group name = " + dgName);
                    return asmFactory.getDiskGroup(dgName);
                }
                catch (NotExistsException ne) {
                    throw new GridHomeClientException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)ne, resourceName, this.getUserAssignedName());
                }
            }
            throw new NotExistsException((MessageKey)PrCgMsgID.DG_NOT_CONFIGURED, new Object[0]);
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_DISKGROUP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_DISKGROUP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    private void assertStoragePath(String sPath) throws GridHomeClientException {
        if (sPath == null || sPath.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sPath");
        }
        if (!new File(sPath).isAbsolute()) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.INVALID_STORAGE_PATH, sPath);
        }
    }

    public void setStoragePath(String storagePath) throws GridHomeClientException {
        this.assertStoragePath(storagePath);
        storagePath = storagePath.trim();
        if (storagePath.endsWith(File.separator)) {
            storagePath = storagePath.substring(0, storagePath.length() - 1);
        }
        try {
            String existingPath = this.getStoragePath();
            if (existingPath != null && existingPath.length() > 0) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.STORAGE_PATH_ALREADY_CONFIGURED, storagePath);
            }
            try {
                DiskGroup diskGroup = this.diskGroup();
            }
            catch (NotExistsException e) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.MODIFY_STORAGE_NO_DG_FAILED, storagePath);
            }
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.STORAGE_BASE_PATH.name(), storagePath));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHC.STORAGE_BASE_PATH.name(), storagePath));
            }
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.SET_GHC_STORAGE_PATH_FAILED, (Throwable)e, storagePath);
        }
    }

    @Override
    public String getStoragePath() throws GridHomeClientException {
        try {
            if (this.m_tomcat) {
                return this.m_crsResource.getAttribute(ResourceType.RHPC.STORAGE_BASE_PATH.name()).getValue();
            }
            return this.m_crsResource.getAttribute(ResourceType.GHC.STORAGE_BASE_PATH.name()).getValue();
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_GHC_STORAGE_PATH_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setWorkingCopyExists(boolean workingcopyExistsFlag) throws GridHomeClientException {
        Trace.out("Set the existence of dependent workingcopies on RHPC: " + String.valueOf(workingcopyExistsFlag));
        try {
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.WORKINGCOPY_EXISTS.name(), String.valueOf(workingcopyExistsFlag)));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHC.WORKINGCOPY_EXISTS.name(), String.valueOf(workingcopyExistsFlag)));
            }
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.SET_WORKINGCOPY_EXISTS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public boolean workingCopyExists() throws GridHomeClientException {
        try {
            if (this.m_tomcat) {
                return Boolean.parseBoolean(this.m_crsResource.getAttribute(ResourceType.RHPC.WORKINGCOPY_EXISTS.name()).getValue());
            }
            return Boolean.parseBoolean(this.m_crsResource.getAttribute(ResourceType.GHC.WORKINGCOPY_EXISTS.name()).getValue());
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_WORKINGCOPY_EXISTS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setEmailAddress(String emailAddress) throws GridHomeClientException {
        try {
            super.setEmailAddress(emailAddress);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public String getEmailAddress() throws GridHomeClientException {
        try {
            return super.getEmailAddress();
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public void setMailServerAddress(String mailServer) throws GridHomeClientException {
        try {
            super.setMailServerAddress(mailServer);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public String getMailServerAddress() throws GridHomeClientException {
        try {
            return super.getMailServerAddress();
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public void setMailServerPort(String port) throws GridHomeClientException {
        try {
            super.setMailServerPort(port);
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public String getMailServerPort() throws GridHomeClientException {
        try {
            return super.getMailServerPort();
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    void modify(GridHomeClientArgs ghcArgs) throws GridHomeClientException {
        if (ghcArgs == null) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "ghcArgs");
        }
        DiskGroup dg = ghcArgs.getDiskGroup();
        String storagePath = ghcArgs.getStoragePath();
        Integer port = ghcArgs.getPort();
        String clientData = ghcArgs.getClientData();
        if (dg != null) {
            this.setDiskGroup(dg);
        }
        if (storagePath != null) {
            this.setStoragePath(storagePath);
        }
        if (clientData != null) {
            this.setClientData(clientData);
        }
        if (port != null) {
            this.setPort(port);
        }
        try {
            Trace.out("Email adderss..." + ghcArgs.getEmailAddress());
            Trace.out("mail serever adderss..." + ghcArgs.getMailServerAddress());
            Trace.out("mail port ..." + ghcArgs.getMailServerPort());
            if (ghcArgs.getEmailAddress() != null || ghcArgs.getMailServerAddress() != null || ghcArgs.getMailServerPort() != null) {
                this.modifyNotificationCredentials(ghcArgs);
            }
        }
        catch (GridHomeException e) {
            Trace.out("GridHomeException ..." + e.getMessage());
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public void remove(boolean force, ProgressListener plsnrClient) throws AlreadyRunningException, GridHomeClientException {
        this.internalRemove(force, plsnrClient, false);
    }

    @Override
    public void removeResOnly() throws AlreadyRunningException, GridHomeClientException {
        this.internalRemove(true, null, true);
    }

    public void internalRemove(boolean force, ProgressListener plsnrClient, boolean resOnly) throws AlreadyRunningException, GridHomeClientException {
        block19: {
            try {
                NodeAppsFactoryImpl.getInstance().assertRoot();
            }
            catch (SoftwareModuleException e) {
                throw new GridHomeClientException(e);
            }
            if (!force && this.workingCopyExists()) {
                throw new GridHomeClientException((MessageKey)PrCgMsgID.GHC_WORKINGCOPY_EXISTS, new Object[0]);
            }
            try {
                boolean isUp = this.isRunning();
                if (!force && isUp) {
                    throw new AlreadyRunningException((MessageKey)PrCgMsgID.GHC_IS_RUNNING, new Object[0]);
                }
                if (isUp) {
                    try {
                        if (plsnrClient != null) {
                            plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.STOP_GHC, false));
                        }
                        this.stop(force);
                    }
                    catch (AlreadyStoppedException e) {
                        Trace.out("exception here is okay, logging exception: " + e.getMessage());
                    }
                }
                if (!resOnly) {
                    this.removeNotificationCredentials();
                }
                super.remove(force);
                if (resOnly) break block19;
                this.removeAllAdminHelpers();
                try {
                    AdminHelperFactoryImpl ahFact = AdminHelperFactoryImpl.getInstance();
                    AdminHelper helper = ahFact.getAdminHelper();
                    helper.remove(true);
                }
                catch (NotExistsException ahFact) {
                }
                catch (AdminHelperException ahe) {
                    throw new GridHomeClientException(ahe);
                }
                GridHomeFactoryImpl ghFactImpl = GridHomeFactoryImpl.getInstance();
                if (plsnrClient != null) {
                    plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.DELETE_AUTH_KEYS, false));
                }
                ghFactImpl.deleteAuthKeys();
                String ghcClusterName = new ClusterUtil().getClusterName();
                Trace.out("Deleting client credentials from the credential wallet");
                if (plsnrClient != null) {
                    plsnrClient.write(m_msgBndl_PrCg.getMessage(PrCgMsgID.DELETE_CLIENT_CREDENTIALS, false));
                }
                CredentialsFactory cfact = CredentialsFactory.getInstance();
                cfact.deleteClientCredentials(ghcClusterName);
                Trace.out("Deleted client credentials from the credential wallet");
            }
            catch (GridHomeException e) {
                Trace.out("GridHomeException: " + e.getMessage());
                throw new GridHomeClientException(e);
            }
            catch (SoftwareModuleException e) {
                throw new GridHomeClientException(e);
            }
            catch (ClusterUtilException e) {
                throw new GridHomeClientException(e);
            }
            catch (oracle.cluster.gridhome.credentials.CredentialsException e) {
                throw new GridHomeClientException(e);
            }
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, GridHomeClientException {
        this.remove(force, null);
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, GridHomeClientException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void start(Node node) throws AlreadyRunningException, GridHomeClientException {
        try {
            super.start(node);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public void enable(Node node) throws AlreadyEnabledException, GridHomeClientException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.enable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new GridHomeClientException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException(e);
        }
    }

    @Override
    public void disable(Node node) throws AlreadyDisabledException, GridHomeClientException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.disable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new GridHomeClientException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GridHomeClientException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.GHC.toString();
    }

    public static String getResourceName2() {
        return "ora." + ResourceLiterals.RHPCLIENT.toString();
    }

    private void assertClientData(String cData) throws GridHomeClientException {
        if (cData == null || cData.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "cPath");
        }
        File f = new File(cData);
        if (!f.exists()) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.CLIENT_DATA_NOT_EXIST, cData);
        }
        if (f.isDirectory()) {
            throw new GridHomeClientException((MessageKey)PrCgMsgID.CLIENT_DATA_NOT_FILE, cData);
        }
    }

    @Override
    public boolean isGIPatchinProgress() throws GridHomeClientException {
        try {
            String isGIPatchinProgress = null;
            isGIPatchinProgress = this.m_tomcat ? this.m_crsResource.getAttribute(ResourceType.RHPC.GIPATCH_INPROGRESS.name()).getValue() : this.m_crsResource.getAttribute(ResourceType.GHC.GIPATCH_INPROGRESS.name()).getValue();
            Trace.out((Object)"Is GI Patch in progress ... %s", isGIPatchinProgress);
            return Boolean.parseBoolean(isGIPatchinProgress);
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeClientException((MessageKey)PrCgMsgID.GET_IS_GIPATCH_PROGRESS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setGIPatchinProgress(boolean isGIPatchinProgress) throws GridHomeClientException {
        try {
            String val = Boolean.valueOf(isGIPatchinProgress).toString();
            Trace.out((Object)"Setting the GI Patch in progress to %s", val);
            if (this.m_tomcat) {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.RHPC.GIPATCH_INPROGRESS.name(), val.toLowerCase()));
            } else {
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GHC.GIPATCH_INPROGRESS.name(), val.toLowerCase()));
            }
            Trace.out((Object)"END..Setting the GI Patch in progress to %s", val);
        }
        catch (CRSException e) {
            Trace.out("CRSException...." + e.getMessage());
            throw new GridHomeClientException((MessageKey)PrCgMsgID.SET_IS_GIPATCH_PROGRESS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean isTLSEnabled() throws GridHomeClientException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.RHPC.TLS_ENABLED.name());
            return Boolean.parseBoolean(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new GridHomeClientException((MessageKey)PrCnMsgID.GET_TLS_ENABLED_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    static {
        m_msgBndl_PrCg.setPackage("oracle.cluster.resources");
    }
}

