/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gns;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.Relocatable;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.gns.GNSVIPException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GNSVIPImpl
extends SoftwareModuleImpl
implements GNSVIP {
    private static final ResourceType.GNSVIP gnsResourceTypeName = ResourceType.GNSVIP.NAME;
    private static final String gnsVipName = gnsResourceTypeName.name();
    private ResourceAttribute m_nameAttr;
    private static boolean s_isProductionEnv = true;

    GNSVIPImpl() throws GNSVIPException {
        String attributeName = null;
        try {
            CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
            String resourceName = "ora." + ResourceLiterals.GNS.toString() + "." + ResourceLiterals.VIP.toString();
            Trace.out("Creating VIP resource type: %s", resourceName);
            this.m_nameAttr = crsFactoryImpl.create(gnsVipName, resourceName);
            Trace.out("Created VIP resource type: %s", resourceName);
            this.m_name = this.m_nameAttr.getValue();
            String[] values = this.m_name.split(Pattern.quote(String.valueOf('.')));
            this.m_displayName = values[1];
            attributeName = this.m_nameAttr.getName();
            Trace.out("Getting CRS resource \"%s\"", this.m_nameAttr.getValue());
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
            Trace.out("Got CRS resource \"%s\"", this.m_nameAttr.getValue());
        }
        catch (NotExistsException notExistsException) {
            Trace.out("VIP resource \"%s\" does not exist - ignoring so that it can be created later.", this.m_nameAttr.getValue());
        }
        catch (CRSException crsException) {
            Trace.out("Caught CRS exception creating VIP resource \"%s\": %s", this.m_nameAttr.getValue(), crsException.getMessage());
            throw new GNSVIPException(crsException);
        }
        Trace.out("returning");
    }

    @Override
    public void start() throws SoftwareModuleException, AlreadyRunningException {
        try {
            super.start();
        }
        catch (AlreadyRunningException alreadyRunningException) {
            if (s_isProductionEnv) {
                throw alreadyRunningException;
            }
            Trace.out("In development environment - ignoring \"already running exception\"");
        }
    }

    @Override
    public void start(Node node) throws SoftwareModuleException, AlreadyRunningException {
        try {
            super.start(node);
        }
        catch (AlreadyRunningException alreadyRunningException) {
            if (s_isProductionEnv) {
                throw alreadyRunningException;
            }
            Trace.out("In development environment - ignoring \"already running exception\"");
        }
    }

    @Override
    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        super.stop(force);
    }

    @Override
    public void stop(Node node, boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        super.stop(node, force);
    }

    void create(VIPAddress vipAddress, Network network, Version version) throws AlreadyExistsException, GNSVIPException {
        this.create(vipAddress, network, version, false);
    }

    void create(VIPAddress vipAddress, Network network, Version version, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, GNSVIPException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new GNSVIPException(e);
        }
        try {
            int listSize;
            String skipOpt = System.getenv("TEST_SKIP_GNS_VALIDATION");
            if (Utils.isDevelopmentEnv()) {
                if (skipOpt == null && !skipVIPReachabilityCheck) {
                    this.checkGNSVIPReachable(vipAddress.getIPAddress());
                }
            } else if (!skipVIPReachabilityCheck) {
                this.checkGNSVIPReachable(vipAddress.getIPAddress());
            }
            Trace.out("Creating vip with address %s", vipAddress.getAddressAsString());
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute networkAttribute = crsFactory.create(ResourceType.Network.NAME.name(), network.getName());
            ResourceAttribute gnsVIPTypeAttr = crsFactory.create(gnsResourceTypeName.name(), gnsResourceTypeName.toString());
            String networkName = networkAttribute.getValue();
            Trace.out("Checking for network %s", networkName);
            if (!crsFactory.isRegistered(networkName, CRSEntity.Type.Resource)) {
                throw new GNSVIPException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, networkName);
            }
            List<ResourceAttribute> resourceAttributeList = crsFactory.getResourceTypeEntity(gnsVIPTypeAttr).getAttributes(new String[0]);
            resourceAttributeList = ResourceType.getProfile(resourceAttributeList);
            for (ResourceAttribute resourceAttribute : resourceAttributeList) {
                if (!resourceAttribute.getName().equalsIgnoreCase(this.m_nameAttr.getName())) continue;
                Trace.out("Setting attribute %s OLD: \"%s\" NEW: \"%s\"", resourceAttribute.getName(), resourceAttribute.getValue(), this.m_nameAttr.getValue());
                resourceAttribute.setValue(this.m_nameAttr.getValue());
                break;
            }
            String resourceName = "ora." + ResourceLiterals.GNS.toString() + "." + ResourceLiterals.VIP.toString();
            Trace.out("Reset VIP resource to %s", resourceName);
            this.m_nameAttr = CRSFactoryImpl.getInstance().create(gnsVipName, resourceName);
            Trace.out("Created VIP resource: %s", resourceName);
            for (ResourceAttribute attribute : resourceAttributeList) {
                if (!attribute.getName().equalsIgnoreCase(ResourceType.GNSVIP.NAME.name())) continue;
                Trace.out("Setting resource name to \"%s\".", this.m_nameAttr.getValue());
                attribute.setValue(this.m_nameAttr.getValue());
                break;
            }
            String string = vipAddress.getVIPOrName();
            Map<IPAddressUtil.IPAddrType, List<InetAddress>> resolutionMap = IPAddressUtil.resolveHostname(string);
            InetAddress ipv4InetAddress = null;
            InetAddress ipv6InetAddress = null;
            Trace.out("MAP size is....." + resolutionMap.size());
            if (resolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                listSize = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv4).size();
                if (listSize > 1) {
                    Trace.out("GNS VIPName " + string + " resolves to" + "more than one IPv4 address");
                    throw new GNSVIPException((MessageKey)PrCrMsgID.GNS_VIPNAME_ERROR, new Object[]{string, IPAddressUtil.IPAddrType.IPv4});
                }
                ipv4InetAddress = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv4).get(0);
                Trace.out("IP V4 address...." + ipv4InetAddress.getHostAddress());
            }
            if (resolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                listSize = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv6).size();
                if (listSize > 1) {
                    Trace.out("GNS VIPName " + string + " resolves to" + "more than one IPv6 address");
                    throw new GNSVIPException((MessageKey)PrCrMsgID.GNS_VIPNAME_ERROR, new Object[]{string, IPAddressUtil.IPAddrType.IPv6});
                }
                ipv6InetAddress = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv6).get(0);
                Trace.out("IPV6 address...." + ipv6InetAddress.getHostAddress());
            }
            String oraVIPValue = "";
            if (ipv4InetAddress != null && ipv6InetAddress == null) {
                oraVIPValue = ipv4InetAddress.getHostAddress();
            } else if (ipv4InetAddress == null && ipv6InetAddress != null) {
                oraVIPValue = ipv6InetAddress.getHostAddress();
            } else if (ipv4InetAddress != null && ipv6InetAddress != null) {
                oraVIPValue = ipv4InetAddress.getHostAddress() + " " + ipv6InetAddress.getHostAddress();
            }
            if (!oraVIPValue.equals("")) {
                GNSVIPImpl.addAttribute(crsFactory, resourceAttributeList, ResourceType.ClusterVIP.USR_ORA_VIP.name(), oraVIPValue);
            }
            GNSVIPImpl.addAttribute(crsFactory, resourceAttributeList, ResourceType.ClusterResource.VERSION.name(), version.toString());
            ResourceDependency hardDependency = crsFactory.createResourceDependency(networkAttribute, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency pullupDependency = crsFactory.createResourceDependency(networkAttribute, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            String dependencyName = ResourceType.LocalResource.START_DEPENDENCIES.name();
            String dependencies = ResourceDependency.toString(hardDependency, pullupDependency);
            ResourceAttribute startDependencyAttribute = crsFactory.create(dependencyName, dependencies);
            Trace.out("Adding \"%s\" dependency", dependencyName);
            resourceAttributeList.add(startDependencyAttribute);
            dependencyName = ResourceType.LocalResource.STOP_DEPENDENCIES.name();
            ResourceAttribute stopDependencyAttribute = crsFactory.create(dependencyName, crsFactory.createResourceDependency(networkAttribute, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP).toString());
            Trace.out("Adding \"%s\" dependency", dependencyName);
            resourceAttributeList.add(stopDependencyAttribute);
            if (Trace.isTraceEnabled()) {
                Trace.out("Creating CRS resource - Attributes:");
                for (ResourceAttribute attribute : resourceAttributeList) {
                    String value = attribute.getValue();
                    if (value == null) {
                        value = "NULL";
                    }
                    Trace.out("%s %s", attribute.getName(), value);
                }
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, resourceAttributeList, ResourceType.ACL_CREATOR.ROOT);
            this.ntGrantAclsForTransparentHA();
        }
        catch (CRSException crsException) {
            throw new GNSVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)crsException, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (IPAddressException e) {
            Trace.out("Caught IPAddress exception creating VIP resource \"%s\": %s", this.m_nameAttr.getValue(), e.getMessage());
            throw new GNSVIPException(e);
        }
        Trace.out("Created vip with address %s", vipAddress.getAddressAsString());
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws GNSVIPException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new GNSVIPException(e);
        }
    }

    private static void addResource(CRSFactoryImpl crsFactory, List<ResourceAttribute> attributeList, ResourceType.GNSVIP vipAttribute, String value) throws GNSVIPException {
        GNSVIPImpl.addAttribute(crsFactory, attributeList, vipAttribute.name(), value);
    }

    private static void addAttribute(CRSFactoryImpl crsFactory, List<ResourceAttribute> attributeList, String name, String value) throws GNSVIPException {
        try {
            Trace.out("Adding \"%s\" attribute with value \"%s\"", name, value);
            ResourceAttribute attribute = crsFactory.create(name, value);
            attributeList.add(attribute);
        }
        catch (CRSException crsException) {
            Trace.out("Adding \"%s\" attribute with value \"%s\" failed: %s", name, value, crsException.getMessage());
            throw new GNSVIPException(crsException);
        }
    }

    @Override
    public Network network() throws GNSVIPException {
        try {
            return NodeAppsFactoryImpl.getInstance().getNetwork(this.m_crsResource);
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSVIPException(softwareModuleException);
        }
    }

    @Override
    public void setNetwork(Network network) throws GNSVIPException {
        try {
            String attributeName = ResourceType.LocalResource.START_DEPENDENCIES.name();
            ResourceAttribute startDependencyAttribute = this.m_crsResource.getAttribute(attributeName);
            attributeName = ResourceType.LocalResource.STOP_DEPENDENCIES.name();
            ResourceAttribute stopDependencyAttribute = this.m_crsResource.getAttribute(attributeName);
            Pattern pattern = Pattern.compile(NetworkImpl.getFilter(), 2);
            String patternString = pattern.toString();
            Trace.out("Pattern is " + patternString);
            String networkName = network.getName();
            Trace.out("Network name: " + networkName);
            String currentValue = startDependencyAttribute.getValue();
            Trace.out("Current start dependencies: \"%s\"", currentValue);
            String newValue = currentValue.replaceAll(patternString, networkName);
            Trace.out("New start dependency attribute value: \"%s\"", newValue);
            startDependencyAttribute.setValue(newValue);
            currentValue = stopDependencyAttribute.getValue();
            Trace.out("Current stop dependencies: \"%s\"", currentValue);
            newValue = currentValue.replaceAll(patternString, networkName);
            Trace.out("New stop dependency attribute value: \"%s\"", newValue);
            stopDependencyAttribute.setValue(newValue);
            Trace.out("Updated start dependencies: \"%s\"", startDependencyAttribute.getValue());
            Trace.out("Updated stop dependencies:  \"%s\"", stopDependencyAttribute.getValue());
            this.m_crsResource.update(startDependencyAttribute, stopDependencyAttribute);
        }
        catch (CRSException crsException) {
            throw new GNSVIPException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)crsException, this.m_nameAttr.getValue());
        }
    }

    @Override
    public InetAddress address() throws GNSVIPException {
        try {
            String vipAddress = this.getIPAddress();
            return InetAddress.getByName(vipAddress);
        }
        catch (UnknownHostException unknownHostException) {
            throw new GNSVIPException(unknownHostException);
        }
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> addresses() throws GNSVIPException {
        HashMap<IPAddressUtil.IPAddrType, InetAddress> inetAddressMap = new HashMap<IPAddressUtil.IPAddrType, InetAddress>();
        String vipAddresses = this.getIPAddress();
        try {
            if (vipAddresses == null || vipAddresses.length() == 0) {
                Trace.out("USR_ORA_VIP empty");
                throw new GNSVIPException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "GNS-addr-error_1");
            }
            int vipAddressDelimiterIndex = vipAddresses.indexOf(" ");
            if (vipAddressDelimiterIndex != -1) {
                String ipv4Value = vipAddresses.substring(0, vipAddressDelimiterIndex);
                String ipv6Value = vipAddresses.substring(vipAddressDelimiterIndex + 1);
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, InetAddress.getByName(ipv4Value));
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, InetAddress.getByName(ipv6Value));
            } else {
                InetAddress inet = InetAddress.getByName(vipAddresses);
                if (inet instanceof Inet4Address) {
                    Trace.out((Object)"IPv4 Address: %s", inet.getHostAddress());
                    inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, inet);
                } else {
                    Trace.out((Object)"IPv6 Address: %s", inet.getHostAddress());
                    inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, inet);
                }
            }
        }
        catch (UnknownHostException uhe) {
            throw new GNSVIPException((MessageKey)PrCnMsgID.UNKNOWN_HOST, (Throwable)uhe, vipAddresses);
        }
        return inetAddressMap;
    }

    public String getResourceName() throws GNSVIPException {
        try {
            ResourceAttribute resourceAttribute = this.m_crsResource.getAttribute(ResourceType.GNSVIP.NAME.name());
            String value = resourceAttribute.getValue().trim();
            return value;
        }
        catch (CRSException crsException) {
            throw new GNSVIPException(crsException);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, GNSVIPException {
        try {
            return super.crsResource();
        }
        catch (NotExistsException notExistsException) {
            Trace.out("CRS resource \"%s\" does not exist or is not registered", this.m_nameAttr.getValue());
            throw notExistsException;
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Lookup of CRS resource \"%s\" failed.", this.m_nameAttr.getValue());
            throw new GNSVIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)softwareModuleException, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate();
        }
        catch (NotExistsException notExistsException) {
            throw new RelocateException(notExistsException);
        }
        catch (CRSException crsException) {
            throw new RelocateException(crsException);
        }
    }

    @Override
    public void relocate(Node sourceNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(sourceNode);
        }
        catch (NotExistsException notExistsException) {
            throw new RelocateException(notExistsException);
        }
        catch (CRSException crsException) {
            throw new RelocateException(crsException);
        }
    }

    @Override
    public void relocateTo(Node destinationNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocateTo(destinationNode);
        }
        catch (NotExistsException notExistsException) {
            throw new RelocateException(notExistsException);
        }
        catch (CRSException crsException) {
            throw new RelocateException(crsException);
        }
    }

    @Override
    public void relocate(Node sourceNode, Node destinationNode) throws NotRunningException, RelocateException {
        String destinationName;
        String sourceName;
        try {
            sourceName = sourceNode == null ? "null" : sourceNode.getName();
            destinationName = destinationNode == null ? "null" : destinationNode.getName();
        }
        catch (NodeException nodeException) {
            throw new RelocateException(nodeException);
        }
        try {
            Trace.out("Relocating from node \"%s\" to \"%s\"", sourceName, destinationName);
            Relocatable relocatable = CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            relocatable.relocate(sourceNode, destinationNode);
            Trace.out("Relocate from node \"%s\" to \"%s\" succeeded", sourceName, destinationName);
        }
        catch (NotExistsException notExistsException) {
            Trace.out("Relocate from node \"%s\" to \"%s\" failed: %s", sourceName, destinationName, notExistsException.getMessage());
            throw new RelocateException(notExistsException);
        }
        catch (CRSException crsException) {
            Trace.out("Relocate from node \"%s\" to \"%s\" failed due to CRS error: %s", sourceName, destinationName, crsException.getMessage());
            throw new RelocateException(crsException);
        }
        catch (Exception exception) {
            Trace.out("Relocate from node \"%s\" to \"%s\" failed: %s", sourceName, destinationName, exception.getMessage());
            throw new RelocateException(exception);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, GNSVIPException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSVIPException(softwareModuleException);
        }
    }

    @Override
    public String getIPAddress() throws GNSVIPException {
        ResourceAttribute nameAttribute;
        try {
            nameAttribute = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.USR_ORA_VIP.name());
        }
        catch (CRSException crsException) {
            throw new GNSVIPException(crsException);
        }
        String vipAddress = nameAttribute.getValue().trim();
        Trace.out("VIP address =" + vipAddress);
        return vipAddress;
    }

    private void checkGNSVIPReachable(InetAddress ipAddress) throws GNSVIPException {
        try {
            if (IPAddressUtil.isPingable(ipAddress)) {
                throw new GNSVIPException((MessageKey)PrCcMsgID.VIP_ADDRESS_REACHABILITY_ERROR, ipAddress.getHostAddress());
            }
        }
        catch (IPAddressException ipAddressException) {
            throw new GNSVIPException(ipAddressException);
        }
    }

    protected ResourceAttribute getNameAttribute() throws GNSVIPException {
        return this.m_nameAttr;
    }

    public void removeAddressType(IPAddressUtil.IPAddrType addrType) throws GNSVIPException {
        if (addrType != IPAddressUtil.IPAddrType.IPv4 && addrType != IPAddressUtil.IPAddrType.IPv6 && addrType != IPAddressUtil.IPAddrType.BOTH) {
            throw new GNSVIPException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "gnsvip_error-02");
        }
        try {
            ResourceAttribute usrOraVIPAttr = this.m_crsResource.getAttribute(ResourceType.GNSVIP.USR_ORA_VIP.name());
            String existingValue = usrOraVIPAttr.getValue();
            int delimiterIndex = existingValue.indexOf(" ");
            if (addrType == IPAddressUtil.IPAddrType.BOTH) {
                usrOraVIPAttr.setValue("");
            }
            if (delimiterIndex != -1) {
                String ipv4Value = existingValue.substring(0, delimiterIndex);
                String ipv6Value = existingValue.substring(delimiterIndex + 1);
                if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                    usrOraVIPAttr.setValue(ipv6Value);
                } else {
                    usrOraVIPAttr.setValue(ipv4Value);
                }
            } else if ((existingValue = existingValue.trim()).length() > 0) {
                try {
                    IPAddressUtil.IPAddrType vipAddrType = IPAddressUtil.getAddrTypeFromAddressOrName(existingValue.trim());
                    if (addrType == vipAddrType) {
                        usrOraVIPAttr.setValue("");
                    } else if (vipAddrType == IPAddressUtil.IPAddrType.BOTH) {
                        Network vipNetwork = this.network();
                        Map<IPAddressUtil.IPAddrType, DHCPServerType> nettypeMap = vipNetwork.dhcpServerTypes();
                        if (addrType == IPAddressUtil.IPAddrType.IPv4 && nettypeMap.get((Object)IPAddressUtil.IPAddrType.IPv6) == DHCPServerType.AUTOCONFIG || addrType == IPAddressUtil.IPAddrType.IPv6 && nettypeMap.get((Object)IPAddressUtil.IPAddrType.IPv4) == DHCPServerType.DHCP) {
                            usrOraVIPAttr.setValue("");
                        }
                    }
                }
                catch (IPAddressException ipae) {
                    throw new GNSVIPException(ipae);
                }
                catch (NetworkException ne) {
                    throw new GNSVIPException(ne);
                }
            }
            Trace.out("Changing value of attribute \"" + usrOraVIPAttr.getName() + "\" to \"" + usrOraVIPAttr.getValue() + "\"");
            this.m_crsResource.update(usrOraVIPAttr);
        }
        catch (CRSException crse) {
            throw new GNSVIPException(crse);
        }
    }

    static {
        s_isProductionEnv = !Utils.isDevelopmentEnv();
    }
}

