/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gns;

import oracle.cluster.gns.GNSInternalErrorException;
import oracle.cluster.gns.GNSQueryTypes;
import oracle.cluster.resources.PrCsMsgID;
import oracle.gridnamingservice.GNSInfo;
import oracle.gridnamingservice.QueryTypes;
import oracle.ops.mgmt.nls.MessageBundle;

public class GNSQueryResults {
    private StringBuffer messageBuffer = new StringBuffer();
    private MessageBundle messageBundle = null;
    private static MessageBundle s_prkzMsg_Bundle = MessageBundle.getMessageBundle("Prkz");

    public GNSQueryResults(MessageBundle messageBundle, GNSInfo gnsInfo) {
        this.messageBundle = messageBundle;
        this.append(gnsInfo);
    }

    private void append(GNSInfo gnsInfo) {
        GNSQueryResult[] queryResults;
        for (GNSQueryResult results : queryResults = new GNSQueryResult[]{new GNSQueryResult(GNSQueryTypes.BRIDGE_PORT, gnsInfo.getBridgePort()), new GNSQueryResult(GNSQueryTypes.MULTICAST_PORT, gnsInfo.getMulticastPort()), new GNSQueryResult(GNSQueryTypes.STATUS, gnsInfo.getStatus()), new GNSQueryResult(GNSQueryTypes.SUBDOMAIN, gnsInfo.getSubdomain()), new GNSQueryResult(GNSQueryTypes.VERSION, gnsInfo.getVersion()), new GNSQueryResult(GNSQueryTypes.CLUSTER_GUID, gnsInfo.getClusterGUID()), new GNSQueryResult(GNSQueryTypes.CLUSTER_NAME, gnsInfo.getClusterName()), new GNSQueryResult(GNSQueryTypes.CLUSTER_TYPE, gnsInfo.getClusterType()), new GNSQueryResult(GNSQueryTypes.LOG_LEVEL, gnsInfo.getLogLevel()), new GNSQueryResult(GNSQueryTypes.LISTENING_ADDRESSES, gnsInfo.getListeningAddresses())}) {
            this.append(results.queryType, results.queryResult, gnsInfo);
        }
    }

    private void append(GNSQueryTypes queryType, String value, GNSInfo gnsInfo) {
        String formatID = FormatID.get(queryType);
        if (queryType == GNSQueryTypes.SUBDOMAIN && value == null && gnsInfo.isDomainWanted()) {
            value = s_prkzMsg_Bundle.getMessage("1077", false);
        }
        if (value != null) {
            if (this.messageBuffer.length() > 0) {
                this.messageBuffer.append('\n');
            }
            this.messageBuffer.append(this.messageBundle.getMessage(formatID, false, new Object[]{value}));
        }
    }

    public String toString() {
        return this.messageBuffer.toString();
    }

    static enum FormatID {
        BRIDGE_PORT(GNSQueryTypes.BRIDGE_PORT, "2606"),
        MULTICAST_PORT(GNSQueryTypes.MULTICAST_PORT, "2610"),
        STATUS(GNSQueryTypes.STATUS, "2607"),
        SUBDOMAIN(GNSQueryTypes.SUBDOMAIN, "2605"),
        VERSION(GNSQueryTypes.VERSION, "2608"),
        CLUSTER_GUID(GNSQueryTypes.CLUSTER_GUID, "2623"),
        CLUSTER_NAME(GNSQueryTypes.CLUSTER_NAME, "2624"),
        CLUSTER_TYPE(GNSQueryTypes.CLUSTER_TYPE, "2627"),
        LOG_LEVEL(GNSQueryTypes.LOG_LEVEL, "2625"),
        LISTENING_ADDRESSES(GNSQueryTypes.LISTENING_ADDRESSES, "2626");

        GNSQueryTypes queryType;
        String formatID;

        private FormatID(GNSQueryTypes queryType, String formatID) {
            this.queryType = queryType;
            this.formatID = formatID;
        }

        private static String get(GNSQueryTypes gnsQueryType) {
            for (FormatID id : FormatID.values()) {
                if (gnsQueryType != id.queryType) continue;
                return id.formatID;
            }
            throw new GNSInternalErrorException(PrCsMsgID.GNS_INTERNAL_ERROR_BAD_QUERY_TYPE, gnsQueryType.name());
        }

        private static String get(QueryTypes queryType) {
            for (FormatID id : FormatID.values()) {
                if (queryType != id.queryType.getGNSQueryType()) continue;
                return id.formatID;
            }
            throw new GNSInternalErrorException(PrCsMsgID.GNS_INTERNAL_ERROR_BAD_QUERY_TYPE, queryType.name());
        }
    }

    private static class GNSQueryResult {
        GNSQueryTypes queryType;
        String queryResult;

        GNSQueryResult(GNSQueryTypes queryType, String queryResult) {
            this.queryType = queryType;
            this.queryResult = queryResult;
        }

        GNSQueryResult(GNSQueryTypes queryType, Integer queryResult) {
            this(queryType, queryResult == null ? null : queryResult.toString());
        }
    }
}

