/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gns;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.GridNamingService;
import oracle.gridnamingservice.GridNamingServiceException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GNSImportExport {
    protected static void exportInstance(String instanceFileName) throws ExportException {
        Object proc = null;
        String gnsTree = GridNamingService.getOCRSubtree();
        String ocrDump = null;
        String oracleHome = null;
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String FILE_SEPARATOR = System.getProperty("file.separator");
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        try {
            Util utl = new Util();
            oracleHome = utl.getCRSHome();
            Trace.out("ORACLE_HOME=" + oracleHome);
        }
        catch (UtilException ue) {
            Trace.out("failed to get ORACLE_HOME.");
            Trace.out((Exception)((Object)ue));
            ExportException ee = new ExportException("Prko", "9082", ue);
            Trace.out("failed to get ORACLE_HOME - throwing " + ee.getMessage());
            throw ee;
        }
        ocrDump = oracleHome + (oracleHome.endsWith(FILE_SEPARATOR) ? "bin" : FILE_SEPARATOR + "bin") + FILE_SEPARATOR + nativeSys.getExeName("ocrdump");
        String[] cmd = new String[]{ocrDump, instanceFileName, "-xml", "-keyname", gnsTree};
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        int ret = runtimeExec.runCommand();
        String[] output = runtimeExec.getOutput();
        String[] error = runtimeExec.getError();
        String command = GNSImportExport.arrayToString(cmd);
        if (ret == 0 && output.length == 0 && error.length == 0) {
            Trace.out("Command : \"" + command + "\" - Succeeded");
        }
        if (ret != 0 || output.length > 0 || error.length > 0) {
            String output_msg = GNSImportExport.arrayToString(output);
            String error_msg = GNSImportExport.arrayToString(error);
            Trace.out("Command: \"" + command + "\" Failed with Output : " + output_msg + " Error: " + error_msg);
            throw new ExportException(output_msg + LINE_SEPARATOR + error_msg);
        }
    }

    private static String arrayToString(String[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (String string : array) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected static void importInstance(String instanceFileName) throws ImportException {
        DocumentBuilder xmlParser = null;
        Document dom = null;
        Object domElement = null;
        NodeList nodeList = null;
        Element root = null;
        String key_value = "";
        String key_name = "";
        boolean isValid = false;
        String subdomain = null;
        String configDomain = null;
        String gnsTree = GridNamingService.getOCRSubtree();
        DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
        File instance_file = new File(instanceFileName);
        if (!instance_file.isFile() || instance_file.isDirectory() || 0L == instance_file.length()) {
            Trace.out("Import file " + instanceFileName + " is invalid");
            throw new ImportException("Prkf", "1267", instanceFileName);
        }
        try {
            GNS gns = GNSFactory.getInstance().getGNS();
            configDomain = gns.getSubdomain();
        }
        catch (SoftwareModuleException sme) {
            Trace.out((Object)"Software module exception: %s", sme.toString());
            Trace.out(sme);
            throw new ImportFailedException(instanceFileName, sme);
        }
        catch (NotExistsException nee) {
            Trace.out((Object)"GNS resource Not Exists: %s", nee.toString());
            Trace.out(nee);
            throw new ImportFailedException(instanceFileName, nee);
        }
        catch (VIPNotFoundException vnfe) {
            Trace.out((Object)"VIP not found exception : %s", vnfe.toString());
            Trace.out((Exception)((Object)vnfe));
            throw new ImportFailedException(instanceFileName, (Exception)((Object)vnfe));
        }
        try {
            xmlParser = xmlFactory.newDocumentBuilder();
            dom = xmlParser.parse(instanceFileName);
        }
        catch (FileNotFoundException fnf) {
            Trace.out("Import file " + instanceFileName + " not found.");
            Trace.out(fnf);
            throw new ImportException("Prkf", "1104", instanceFileName);
        }
        catch (SAXException se) {
            Trace.out("Failed to parse import file");
            Trace.out(se);
            throw new ImportFailedException(instanceFileName, se);
        }
        catch (IOException ioe) {
            Trace.out("Failed to parse import file");
            Trace.out(ioe);
            throw new ImportFailedException(instanceFileName, ioe);
        }
        catch (ParserConfigurationException pce) {
            Trace.out("Failed to parse import file");
            Trace.out(pce);
            throw new ImportFailedException(instanceFileName, pce);
        }
        root = dom.getDocumentElement();
        nodeList = dom.getElementsByTagName("KEY");
        if (nodeList == null && nodeList.getLength() <= 0) {
            Trace.out("Invalid Import file: " + instanceFileName);
            throw new InvalidImportFileException(instanceFileName);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nNode = nodeList.item(i);
            if (nNode.getNodeType() != 1) continue;
            Element el = (Element)nNode;
            key_name = GNSImportExport.getTagValue("NAME", el);
            if (!key_name.startsWith(gnsTree)) {
                Trace.out("Invalid key in import file:" + instanceFileName);
                throw new ImportException("Prko", "9085", instanceFileName);
            }
            key_value = GNSImportExport.getTagValue("VALUE", el);
            if (key_name.endsWith("VERSION") && !(isValid = GridNamingService.checkGNSVersion((String)key_value))) {
                Trace.out("GNS version mismatch in import file: " + instanceFileName);
                throw new VersionMismatchException(instanceFileName);
            }
            if (key_name.endsWith("subdomain") && !(subdomain = key_value).equalsIgnoreCase(configDomain)) {
                Trace.out("GNS subdomain :" + subdomain + " did not match to the configured subdomain :" + configDomain);
                throw new ImportException("Prkf", "1142", subdomain, instanceFileName, configDomain);
            }
            int perm = GNSImportExport.getOCRKeyPermissions(GNSImportExport.getTagValue("USER_PERMISSION", el), GNSImportExport.getTagValue("GROUP_PERMISSION", el), GNSImportExport.getTagValue("OTHER_PERMISSION", el), instanceFileName);
            int dtype = GNSImportExport.getOCRKeyValueDataType(GNSImportExport.getTagValue("VALUE_TYPE", el), instanceFileName);
            try {
                GridNamingService.importInstanceKey((String)subdomain, (String)key_name, (String)key_value, (int)dtype, (int)perm);
                continue;
            }
            catch (GridNamingServiceException gnse) {
                Trace.out("Failed to import file :" + instanceFileName + " Details :" + gnse.getMessage());
                Trace.out((Exception)((Object)gnse));
                throw new ImportFailedException(instanceFileName, (Exception)((Object)gnse));
            }
        }
    }

    private static String getTagValue(String tag, Element element) {
        NodeList nList = element.getElementsByTagName(tag).item(0).getChildNodes();
        if (nList.getLength() > 0) {
            Node nValue = nList.item(0);
            return nValue.getNodeValue();
        }
        return "";
    }

    private static int getOCRKeyPermissions(String User2, String Group2, String Other, String instanceFileName) throws ImportException {
        String permission = "";
        permission = permission + GNSImportExport.getOCRPermissionsValue(User2, instanceFileName);
        permission = permission + GNSImportExport.getOCRPermissionsValue(Group2, instanceFileName);
        permission = permission + GNSImportExport.getOCRPermissionsValue(Other, instanceFileName);
        return Integer.parseInt(permission);
    }

    private static String getOCRPermissionsValue(String perm, String instanceFileName) throws ImportException {
        if (perm.equals("PROCR_ALL_ACCESS")) {
            return "7";
        }
        if (perm.equals("PROCR_READ")) {
            return "4";
        }
        if (perm.equals("PROCR_WRITE")) {
            return "2";
        }
        if (perm.equals("PROCR_NONE")) {
            return "0";
        }
        Trace.out("getOCRPermissionsValue() failed. Invalid permission:" + perm + " in import file: " + instanceFileName);
        throw new InvalidImportFileException(instanceFileName);
    }

    private static int getOCRKeyValueDataType(String dtype, String instanceFileName) throws ImportException {
        String datatype = "";
        String[] temp = dtype.split("\\s+");
        if (temp[0].equals("UB4")) {
            return Integer.parseInt("1");
        }
        if (temp[0].equals("UBIG_ORA")) {
            return Integer.parseInt("2");
        }
        if (temp[0].equals("ORATEXT")) {
            return Integer.parseInt("3");
        }
        if (temp[0].equals("MULTI_ORATEXT")) {
            return Integer.parseInt("4");
        }
        if (temp[0].equals("BYTESTREAM")) {
            return Integer.parseInt("5");
        }
        if (temp[0].equals("UNDEF")) {
            return Integer.parseInt("0");
        }
        Trace.out("getOCRKeyValueDataType() failed. Invalid data type: " + dtype + "in import file: " + instanceFileName);
        throw new InvalidImportFileException(instanceFileName);
    }

    private static class ImportException
    extends GNSException {
        private static final long serialVersionUID = 1L;

        ImportException(String facility, String key, Object ... args) {
            super(facility, key, args);
        }

        ImportException(String facility, String key, Throwable cause, Object ... args) {
            super(facility, key, cause, args);
        }
    }

    private static class VersionMismatchException
    extends ImportException {
        private static final long serialVersionUID = 1L;

        VersionMismatchException(String instanceFileName) {
            super("Prko", "9084", instanceFileName);
        }
    }

    private static class InvalidImportFileException
    extends ImportException {
        private static final long serialVersionUID = 1L;

        InvalidImportFileException(String instanceFileName) {
            super("Prko", "9083", instanceFileName);
        }
    }

    private static class ImportFailedException
    extends ImportException {
        private static final long serialVersionUID = 1L;

        ImportFailedException(String instanceFileName, Exception exception) {
            super("Prko", "9086", exception, instanceFileName);
        }
    }

    private static class ExportException
    extends GNSException {
        private static final long serialVersionUID = 1L;

        ExportException(String facility, String key, Throwable cause) {
            super(facility, key, cause);
        }

        ExportException(String message) {
            super(new Exception(message));
        }
    }
}

