/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gns;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.crs.CRSException;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSDomainAlreadyExistsException;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSInternalErrorException;
import oracle.cluster.gns.GNSQueryTypes;
import oracle.cluster.gns.GNSRole;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.gns.GNSVIPException;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.gns.GNSImpl;
import oracle.cluster.impl.gns.GNSVIPImpl;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.AdvertiseRecord;
import oracle.gridnamingservice.GNSClusterTypes;
import oracle.gridnamingservice.GNSInfo;
import oracle.gridnamingservice.GNSRecordList;
import oracle.gridnamingservice.GridNamingService;
import oracle.gridnamingservice.GridNamingServiceException;
import oracle.gridnamingservice.QueryTypes;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class GNSFactoryImpl {
    private static GNSFactoryImpl s_instance;
    private static GNSImpl s_gnsImpl;
    private GNSVIPImpl m_gnsVIPImpl = null;

    private GNSFactoryImpl() throws VIPNotFoundException, SoftwareModuleException {
        s_gnsImpl = GNSImpl.getInstance();
    }

    public static synchronized GNSFactoryImpl getInstance() throws VIPNotFoundException, SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new GNSFactoryImpl();
        }
        return s_instance;
    }

    public void create(GNSVIP vip, Version version) throws GNSException, VIPNotFoundException, NotExistsException, AlreadyExistsException {
        GNSImpl.getInstance().create(vip, version);
    }

    public void create(GNSVIP gnsVIP, String domain) throws GNSException, GNSDomainAlreadyExistsException, AlreadyExistsException {
        try {
            this.assertVIP(gnsVIP);
            this.assertDomain(domain);
            GNSImpl gns = GNSImpl.getInstance();
            Trace.out("Adding GNS resource with vip: " + gnsVIP.getIPAddress());
            gns.create(gnsVIP, new Version());
            Trace.out((Object)"Added gns resource, registering domain %s", domain);
            String subnetMask = this.getSubnetMask(gnsVIP);
            Trace.out("Adding GNS domain: \"%s\" address: \"%s\" subnet: \"%s\"", domain, gnsVIP.getIPAddress(), subnetMask);
            gns.addDomain(domain, gnsVIP.getIPAddress(), subnetMask);
        }
        catch (VIPNotFoundException ex) {
            throw new GNSException(ex);
        }
        catch (NotExistsException ex) {
            throw new GNSException(ex);
        }
        catch (NetworkException ex) {
            throw new GNSException(ex);
        }
    }

    public void create(String clientData, GNSVIP gnsVIP) throws GNSException, AlreadyExistsException {
        try {
            this.assertVIP(gnsVIP);
            GNSImpl gns = GNSImpl.getInstance();
            Trace.out("Adding GNS resource with vip: " + gnsVIP.getIPAddress());
            gns.create(gnsVIP, new Version(), GNSRole.SECONDARY);
            Trace.out((Object)"Added gns resource, registering clientdata %s", clientData);
            gns.addSecondary(gnsVIP.getIPAddress(), clientData);
        }
        catch (VIPNotFoundException ex) {
            throw new GNSException(ex);
        }
    }

    public GNSVIP createVIP(VIPAddress vipAddress, Network network, Version version) throws GNSVIPException, AlreadyExistsException {
        return this.createVIP(vipAddress, network, version, false);
    }

    public GNSVIP createVIP(VIPAddress vipAddress, Network network, Version version, boolean skipVIPReachabilityCheck) throws GNSVIPException, AlreadyExistsException {
        String skipOpt = System.getenv("TEST_SKIP_GNS_VALIDATION");
        if (Utils.isDevelopmentEnv()) {
            Trace.out("It is DEV ENV...");
            if (skipOpt == null && !skipVIPReachabilityCheck) {
                Trace.out("skip ENV  not set or It skip option not set...");
                this.checkGNSVIPReachable(vipAddress.getIPAddress());
            }
        } else if (!skipVIPReachabilityCheck) {
            Trace.out("It is Production ENV..");
            this.checkGNSVIPReachable(vipAddress.getIPAddress());
        }
        try {
            GNSVIP registeredVIP = this.getVIP();
            if (network.getNumber() != registeredVIP.network().getNumber()) {
                throw new GNSVIPException((MessageKey)PrCsMsgID.GNS_VIP_NET_MISMATCH, network.getNumber(), registeredVIP.network().getNumber());
            }
            Trace.out("Specified vip was already added.");
        }
        catch (VIPNotFoundException vipNotFoundException) {
            Trace.out("No GNS VIP found - continuing on to create the VIP.");
        }
        catch (NetworkException networkException) {
            throw new GNSVIPException((MessageKey)PrCsMsgID.GNS_CREATE_FAILED, (Throwable)networkException, vipAddress.getVIPName());
        }
        if (this.m_gnsVIPImpl == null) {
            Trace.out("Creating GNS VIP object");
            this.m_gnsVIPImpl = new GNSVIPImpl();
            Trace.out("Created GNS VIP object");
        } else {
            Trace.out("GNS VIP EXIST....");
        }
        Trace.out("Creating GNS VIP");
        this.m_gnsVIPImpl.create(vipAddress, network, version, skipVIPReachabilityCheck);
        Trace.out("Created GNS VIP");
        return this.m_gnsVIPImpl;
    }

    public void modify(String domain, String[] allowedNetworks, String[] deniedNetworks) throws GNSException {
        GNSVIP gnsVip;
        if (domain == null && allowedNetworks == null && deniedNetworks == null) {
            throw new GNSInternalErrorException(PrCsMsgID.GNS_INTERNAL_ERROR_NO_ATTRIBUTES, true);
        }
        try {
            gnsVip = GNSFactoryImpl.getInstance().getVIP();
        }
        catch (VIPNotFoundException vipNotFoundException) {
            throw new GNSException(vipNotFoundException);
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSException(softwareModuleException);
        }
        boolean isRunning = false;
        try {
            isRunning = gnsVip.isRunning();
            if (isRunning) {
                gnsVip.stop(false);
            }
        }
        catch (AlreadyStoppedException alreadyStoppedException) {
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSException(softwareModuleException);
        }
        try {
            GridNamingService.modify((String)domain, (String[])allowedNetworks, (String[])deniedNetworks);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
        try {
            if (isRunning) {
                gnsVip.start();
            }
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSException(softwareModuleException);
        }
        catch (AlreadyRunningException alreadyRunningException) {
            throw new RuntimeException(alreadyRunningException);
        }
    }

    public GNSVIP modifyVIP(VIPAddress ipAddress) throws GNSException {
        return this.modifyVIP(ipAddress, false);
    }

    public GNSVIP modifyVIP(VIPAddress ipAddress, boolean skipVIPReachabilityCheck) throws GNSException {
        GNSVIP gnsVIP;
        String mAddress = null;
        InetAddress newAddress = ipAddress.getIPAddress();
        String newAddressStr = newAddress.getHostAddress();
        String skipOpt = System.getenv("TEST_SKIP_GNS_VALIDATION");
        if (Utils.isDevelopmentEnv()) {
            if (skipOpt == null && !skipVIPReachabilityCheck) {
                this.checkGNSVIPReachable(newAddress);
            }
        } else if (!skipVIPReachabilityCheck) {
            this.checkGNSVIPReachable(newAddress);
        }
        try {
            int listSize;
            mAddress = ipAddress.getUsrVIP();
            gnsVIP = this.getVIP();
            String attributeName = ResourceType.ClusterVIP.USR_ORA_VIP.name();
            Map<IPAddressUtil.IPAddrType, List<InetAddress>> resolutionMap = IPAddressUtil.resolveHostname(mAddress);
            Map<IPAddressUtil.IPAddrType, InetAddress> curMap = gnsVIP.addresses();
            InetAddress ipv4InetAddress = null;
            InetAddress ipv6InetAddress = null;
            Trace.out("MAP size is....." + resolutionMap.size());
            if (resolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                listSize = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv4).size();
                if (listSize > 1) {
                    Trace.out("GNS VIPName " + mAddress + " resolves to" + "more than one IPv4 address");
                    throw new GNSVIPException((MessageKey)PrCrMsgID.GNS_VIPNAME_ERROR, new Object[]{mAddress, IPAddressUtil.IPAddrType.IPv4});
                }
                ipv4InetAddress = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv4).get(0);
                Trace.out("IP V4 address...." + ipv4InetAddress.getHostAddress());
            }
            if (resolutionMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                listSize = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv6).size();
                if (listSize > 1) {
                    Trace.out("GNS VIPName " + mAddress + " resolves to" + "more than one IPv6 address");
                    throw new GNSVIPException((MessageKey)PrCrMsgID.GNS_VIPNAME_ERROR, new Object[]{mAddress, IPAddressUtil.IPAddrType.IPv6});
                }
                ipv6InetAddress = resolutionMap.get((Object)IPAddressUtil.IPAddrType.IPv6).get(0);
                Trace.out("IPV6 address...." + ipv6InetAddress.getHostAddress());
            }
            String oraVIPValue = null;
            String ipv4AddrStr = null;
            String ipv6AddrStr = null;
            if (curMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                ipv4AddrStr = curMap.get((Object)IPAddressUtil.IPAddrType.IPv4).getHostAddress();
            }
            if (curMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                ipv6AddrStr = curMap.get((Object)IPAddressUtil.IPAddrType.IPv6).getHostAddress();
            }
            if (ipv4InetAddress != null) {
                ipv4AddrStr = ipv4InetAddress.getHostAddress();
            }
            if (ipv6InetAddress != null) {
                ipv6AddrStr = ipv6InetAddress.getHostAddress();
            }
            oraVIPValue = ipv4AddrStr != null && ipv6AddrStr != null ? ipv4AddrStr + " " + ipv6AddrStr : (ipv4AddrStr != null ? ipv4AddrStr : ipv6AddrStr);
            ResourceAttribute attribute = CRSFactoryImpl.getInstance().create(attributeName, oraVIPValue);
            Trace.out("Changing value of \"%s\" to \"%s\"", attributeName, newAddress);
            ((CRSResourceImpl)gnsVIP.crsResource()).update(attribute);
            Trace.out("Changed value of \"%s\" to \"%s\"", attributeName, newAddress);
        }
        catch (VIPNotFoundException vipNotFoundException) {
            throw new GNSVIPException((MessageKey)PrCsMsgID.GNS_MODIFY_FAILED, (Throwable)vipNotFoundException, newAddress);
        }
        catch (NotExistsException notExistsException) {
            throw new GNSVIPException((MessageKey)PrCsMsgID.GNS_MODIFY_FAILED, (Throwable)notExistsException, newAddress);
        }
        catch (CRSException crsException) {
            throw new GNSVIPException((MessageKey)PrCsMsgID.GNS_MODIFY_FAILED, (Throwable)crsException, newAddress);
        }
        catch (SoftwareModuleException swexception) {
            throw new GNSVIPException((MessageKey)PrCsMsgID.GNS_MODIFY_FAILED, (Throwable)swexception, newAddress);
        }
        catch (IPAddressException ipAddressException) {
            throw new GNSVIPException((MessageKey)PrCsMsgID.GNS_MODIFY_FAILED, (Throwable)ipAddressException, newAddress);
        }
        return gnsVIP;
    }

    public GNSVIP getVIP() throws VIPNotFoundException, GNSVIPException {
        try {
            if (this.m_gnsVIPImpl == null) {
                this.m_gnsVIPImpl = new GNSVIPImpl();
            }
            this.m_gnsVIPImpl.crsResource();
            return this.m_gnsVIPImpl;
        }
        catch (NotExistsException notExistsException) {
            Trace.out("Caught not exists exception: %s - throwing \"vip not found\"");
            throw new VIPNotFoundException(notExistsException.getMessage());
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Caught software module exception %s: %s", softwareModuleException.getClass().getName(), softwareModuleException.getMessage());
            throw new GNSVIPException(softwareModuleException);
        }
    }

    public void remove() throws GNSException {
        this.remove(false);
    }

    public void remove(boolean force) throws GNSException {
        try {
            this.getVIP().remove(force);
        }
        catch (AlreadyRunningException alreadyRunningException) {
            throw new GNSVIPException(alreadyRunningException);
        }
        catch (VIPNotFoundException vipNotFoundException) {
            throw new GNSVIPException(vipNotFoundException);
        }
    }

    public GNS getGNS() throws NotExistsException, VIPNotFoundException, GNSException {
        return GNSImpl.getInstance();
    }

    public String query(GNSQueryTypes queryType) throws GNSException {
        try {
            GNSImpl gns = GNSImpl.getInstance();
            GNSInfo gnsInfo = gns.query(new QueryTypes[]{QueryTypes.ALL_EXCEPT_CONFIG}, 1);
            return gns.getQueryResult(gnsInfo, queryType.getGNSQueryType());
        }
        catch (VIPNotFoundException e) {
            throw new GNSException(e);
        }
    }

    public GNSInfo query(MessageBundle messageBundle, GNSQueryTypes[] queryTypes) throws GNSException {
        String results = null;
        StringBuilder message = new StringBuilder();
        boolean isNWOptSet = false;
        GNSInfo gnsInfo = null;
        try {
            GNSImpl gns = GNSImpl.getInstance();
            GNSQueryTypes[] validQueryTypes = GNSQueryTypes.getValues();
            QueryTypes[] tempQueryTypes = new QueryTypes[validQueryTypes.length];
            int count = 0;
            for (GNSQueryTypes queryType : queryTypes) {
                if (queryType == null) continue;
                if (queryType.isGNS()) {
                    tempQueryTypes[count++] = queryType.getGNSQueryType();
                }
                if (!queryType.equals(GNSQueryTypes.NETWORK)) continue;
                isNWOptSet = true;
            }
            if (count > 0) {
                gnsInfo = gns.query(tempQueryTypes, count);
            }
            if (isNWOptSet) {
                String networkName = this.getVIP().network().getName();
                message.append(messageBundle.getMessage("2609", false, new Object[]{networkName}));
            }
            if (results != null) {
                if (message.length() > 0) {
                    message.append('\n');
                }
                message.append(results);
            }
        }
        catch (VIPNotFoundException vipNotFoundException) {
            throw new GNSException(vipNotFoundException);
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSException(softwareModuleException);
        }
        return gnsInfo;
    }

    public String[] executeDNSQueryForHostPort(String vipAddr, String gnsSubDomain, String serviceName, String clusterName) throws GNSException {
        boolean hasSubDomain;
        Trace.out("executeDNSQueryForHostPort IMPL.....");
        boolean bl = hasSubDomain = gnsSubDomain != null && !gnsSubDomain.trim().isEmpty() && !gnsSubDomain.equals("N_FWD");
        if (!hasSubDomain) {
            gnsSubDomain = clusterName + '.' + "N_FWD";
        }
        String fullServiceName = this.getfullSVCName(serviceName, clusterName);
        String gnsURL = this.getPsuedoDNSURL(vipAddr, gnsSubDomain);
        Trace.out("GNS Address :" + gnsURL + " And service name to query " + serviceName);
        String server = null;
        String port = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", gnsURL);
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(fullServiceName, new String[]{"SRV"});
            int numAttrs = 0;
            if (attrs.get("SRV") != null) {
                numAttrs = attrs.get("SRV").size();
            }
            if (numAttrs < 1) {
                Trace.out("No SRV record for service " + serviceName + " found in GNS " + gnsURL);
                throw new GNSException((MessageKey)PrCsMsgID.NO_SRV_RECORD_FOR_SERVICE, serviceName);
            }
            for (int i = 0; i < numAttrs; ++i) {
                String attr = (String)attrs.get("SRV").get(i);
                Trace.out("Attr: " + attr);
                String[] data = attr.split(" ");
                if (data.length != 4) {
                    Trace.out("Invalid format for SRV record " + attr + "  returned from GNS");
                    throw new GNSException((MessageKey)PrCsMsgID.INVALID_SRV_FORMAT, attr);
                }
                port = data[2];
                server = data[3].substring(0, data[3].length() - 1);
                Trace.out("Server Address: " + server + " Port :" + port);
            }
            ctx.close();
            return new String[]{server, port};
        }
        catch (NamingException e) {
            Trace.out(e);
            throw new GNSException((MessageKey)PrCsMsgID.GET_HOSTPORT_FAILED, e.getMessage());
        }
    }

    public String executeDNSQueryForHost(String vipAddr, String gnsSubDomain, String serviceName, String clusterName, String hostName) throws GNSException {
        boolean hasSubDomain;
        Trace.out("executeDNSQuery for host.....");
        Trace.out("VIP address " + vipAddr + " subdomain is..." + gnsSubDomain + "  service " + serviceName + "  clustgername " + clusterName + " hostname " + hostName);
        boolean bl = hasSubDomain = gnsSubDomain != null && !gnsSubDomain.trim().isEmpty() && !gnsSubDomain.equals("N_FWD");
        if (!hasSubDomain) {
            gnsSubDomain = clusterName + '.' + "N_FWD";
        }
        String gnsURL = this.getPsuedoDNSURL(vipAddr, gnsSubDomain);
        Trace.out("GNS Address :" + gnsURL + " And service name to query " + serviceName);
        String ipAddress = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", gnsURL);
            InitialDirContext ctx = new InitialDirContext(env);
            Trace.out("Querying A or AAAA record....");
            Attributes attrs = ctx.getAttributes(hostName, new String[]{"A"});
            int numAttrs = 0;
            numAttrs = attrs.get("A").size();
            if (numAttrs < 1) {
                Trace.out("No A record for cluster " + hostName + " found in GNS " + gnsURL);
                attrs = ctx.getAttributes(hostName, new String[]{"AAAA"});
                if (attrs.get("AAAA") != null) {
                    numAttrs = attrs.get("AAAA").size();
                }
                if (numAttrs < 1) {
                    ipAddress = null;
                } else {
                    for (int i = 0; i < numAttrs; ++i) {
                        ipAddress = (String)attrs.get("AAAA").get(i);
                        Trace.out("Attr: " + attrs);
                    }
                }
            } else {
                for (int i = 0; i < numAttrs; ++i) {
                    ipAddress = (String)attrs.get("A").get(i);
                    Trace.out("Attr: " + attrs);
                }
            }
            Trace.out("host ipaddress is: " + ipAddress);
            ctx.close();
            return ipAddress;
        }
        catch (NamingException e) {
            Trace.out(e);
            throw new GNSException((MessageKey)PrCsMsgID.GET_HOSTPORT_FAILED, e.getMessage());
        }
    }

    private String getfullSVCName(String serviceName, String clusterName) {
        Trace.out("getfullSVCName...");
        StringBuilder fullSvcName = new StringBuilder("GH");
        fullSvcName.append(clusterName).append(serviceName);
        Trace.out("serviceName is " + serviceName + " and fullServiceName = " + fullSvcName);
        return fullSvcName.toString();
    }

    private String getPsuedoDNSURL(String IPaddr, String subDomain) {
        Trace.out("getPsuedoDNSURL...");
        String gns_url = "dns://" + IPaddr + "/" + subDomain;
        Trace.out("Psuedo DNS URL is: " + gns_url);
        return gns_url;
    }

    public GNSRecordList queryRecords() throws GNSException {
        return this.queryRecords(null, null);
    }

    public GNSRecordList queryRecords(String name) throws GNSException {
        return this.queryRecords(null, null);
    }

    public GNSRecordList queryRecords(String name, String recordType) throws GNSException {
        try {
            return GridNamingService.queryRecords((String)name, (String)recordType);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    protected void finalize() {
        if (null != s_gnsImpl) {
            s_gnsImpl.finalize();
            s_gnsImpl = null;
        }
    }

    public void importCredentials(String fileName) throws GNSException {
        if (fileName == null) {
            throw new GNSInternalErrorException(PrCsMsgID.GNS_INTERNAL_ERROR_NO_ATTRIBUTES, true);
        }
        s_gnsImpl.importCredentials(fileName);
    }

    public void exportCredentials(String fileName) throws GNSException {
        if (fileName == null) {
            throw new GNSInternalErrorException(PrCsMsgID.GNS_INTERNAL_ERROR_NO_ATTRIBUTES, true);
        }
        s_gnsImpl.exportCredentials(fileName);
    }

    public void validateSubdomainName(String domain) throws GNSException {
        if (null == domain) {
            throw new GNSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "domain", domain);
        }
        try {
            GridNamingService.validateSubdomainName((String)domain);
        }
        catch (GridNamingServiceException e) {
            throw new GNSException(e);
        }
    }

    public static String getGNSSubSubDomain(String clusterName, GNSProperties gnsProps) throws GNSException {
        String subSubDomain = null;
        if (gnsProps == null) {
            throw new GNSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "GNSProperties");
        }
        try {
            String subDomain;
            subSubDomain = subDomain = gnsProps.getGNSSubDomain();
        }
        catch (CredentialsException e) {
            throw new GNSException(e);
        }
        return subSubDomain;
    }

    private void checkGNSVIPReachable(InetAddress ipAddress) throws GNSVIPException {
        try {
            Trace.out("Check for GNS Reachability...");
            if (IPAddressUtil.isPingable(ipAddress)) {
                throw new GNSVIPException((MessageKey)PrCcMsgID.VIP_ADDRESS_REACHABILITY_ERROR, ipAddress.getHostAddress());
            }
        }
        catch (IPAddressException ipAddressException) {
            throw new GNSVIPException(ipAddressException);
        }
    }

    public boolean isGNSClient() {
        GNSClusterTypes gcType = GridNamingService.getClusterType();
        return gcType == GNSClusterTypes.CLIENT;
    }

    public boolean isGNSConfigured(boolean serverOnly) throws GNSException {
        Trace.out(" Checking isGNSConfigured");
        GNSClusterTypes gcType = GridNamingService.getClusterType();
        if (gcType == GNSClusterTypes.NOT_CONFIGURED) {
            return false;
        }
        if (gcType == GNSClusterTypes.SERVER) {
            return true;
        }
        return !serverOnly && gcType == GNSClusterTypes.CLIENT;
    }

    public GNSRecordList getInstanceList() throws GNSException {
        try {
            GNSRecordList iList = GridNamingService.getInstanceList();
            for (int i = 0; i < iList.size(); ++i) {
                Trace.out("Record[%d]: %s", i, ((AdvertiseRecord)iList.get(i)).getName());
            }
            return iList;
        }
        catch (GridNamingServiceException gne) {
            throw new GNSException(gne);
        }
    }

    private String getSubnetMask(GNSVIP gnsVIP) throws NotExistsException, GNSVIPException, NetworkException {
        Map<IPAddressUtil.IPAddrType, Subnet> subnetMap = gnsVIP.network().subnets();
        Subnet ipv4Subnet = subnetMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
        Subnet ipv6Subnet = subnetMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
        String subnetMask = "";
        if (ipv4Subnet != null && ipv6Subnet != null) {
            subnetMask = ipv4Subnet.subnetMaskAsStr();
        } else if (ipv4Subnet != null && ipv6Subnet == null) {
            subnetMask = ipv4Subnet.subnetMaskAsStr();
        } else if (ipv4Subnet == null && ipv6Subnet != null) {
            subnetMask = ipv6Subnet.subnetMaskAsStr();
        }
        return subnetMask;
    }

    private void assertVIP(GNSVIP gnsVIP) throws GNSException {
        if (gnsVIP == null || gnsVIP.getIPAddress().isEmpty()) {
            throw new GNSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "gnsVIP", gnsVIP);
        }
    }

    private void assertDomain(String domain) throws GNSException {
        if (domain == null || domain.isEmpty()) {
            throw new GNSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "domain", domain);
        }
    }

    static {
        s_gnsImpl = null;
    }
}

