/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.email;

import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.email.Email;
import oracle.cluster.email.EmailException;
import oracle.cluster.impl.credentials.CredentialsAttribute;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class EmailImpl
implements Email {
    private static final String DBA_GROUP = "dba";
    private String m_emailAddress = null;
    private String m_password = null;
    private String m_mailServerAddress = null;
    private Integer m_mailServerPort = null;
    private String m_domain = null;
    private String m_subDomain = null;

    public EmailImpl(String emailAddress, String password, String mailServerAddress, Integer mailServerPort, String domain, String subDomain) throws EmailException {
        this.m_emailAddress = emailAddress;
        this.m_password = password;
        this.m_mailServerAddress = mailServerAddress;
        this.m_mailServerPort = mailServerPort;
        this.m_domain = domain;
        this.m_subDomain = subDomain;
    }

    @Override
    public void register() throws EmailException {
        this.authenticate();
        try {
            Trace.out("Storing email credentials in credential wallet...");
            CredDomain subDomain = this.internalCreateDomain();
            CredentialsSet credSet = null;
            try {
                credSet = subDomain.getCredentialsSet(CredentialsType.USERPASS);
            }
            catch (NotExistsException e) {
                try {
                    credSet = subDomain.createCredentialSet(CredentialsType.USERPASS);
                }
                catch (AlreadyExistsException ae) {
                    Trace.out("AlreadyExistsException..." + e.getMessage());
                }
            }
            UserPassCredentials userPass = credSet.createUserPassCredentials(this.m_emailAddress, this.m_password);
            this.changeSubDomainPermissions(subDomain);
        }
        catch (CredentialsException e) {
            Trace.out("EmailException ..." + e.getMessage());
            throw new EmailException((MessageKey)PrCgMsgID.FAILED_TO_REGISTER_EMAIL_CREDENTIALS, (Throwable)e, this.m_emailAddress, this.m_domain, this.m_subDomain);
        }
    }

    @Override
    public void modify(String emailAddress, String password, String mailServerAddress, Integer mailServerPort) throws EmailException {
        try {
            this.m_emailAddress = emailAddress;
            this.m_password = password;
            this.m_mailServerAddress = mailServerAddress;
            this.m_mailServerPort = mailServerPort;
            this.authenticate();
            this.remove(false);
            Trace.out("Modifying email credentials in credential wallet...");
            CredDomain subDomain = this.internalCreateDomain();
            CredentialsSet credSet = null;
            try {
                credSet = subDomain.getCredentialsSet(CredentialsType.USERPASS);
                UserPassCredentials userPass = credSet.getUserPassCredentials(0);
                credSet.removeCredentials(0);
            }
            catch (NotExistsException e) {
                Trace.out("NotExistsException..." + e.getMessage());
            }
            try {
                credSet = subDomain.createCredentialSet(CredentialsType.USERPASS);
                UserPassCredentials e = credSet.createUserPassCredentials(this.m_emailAddress, this.m_password);
            }
            catch (AlreadyExistsException e) {
                Trace.out("User pass credentials already exists..." + e.getMessage());
            }
        }
        catch (CredentialsException e) {
            Trace.out("EmailException ..." + e.getMessage());
            throw new EmailException(e);
        }
    }

    private CredDomain internalCreateDomain() throws EmailException {
        CredDomain baseDomain = null;
        CredDomain subDomain = null;
        Object credSet = null;
        try {
            CredentialsFactory credfact = CredentialsFactory.getInstance();
            try {
                baseDomain = credfact.getDomainByPath(this.m_domain, true);
                Trace.out("Domain .." + this.m_domain + "exists...");
            }
            catch (NotExistsException ne) {
                Trace.out("Domain " + this.m_domain + " not exists...");
                try {
                    baseDomain = credfact.createDomain(this.m_domain, true);
                }
                catch (AlreadyExistsException e) {
                    Trace.out("AlreadyExistsException..." + e.getMessage());
                }
            }
            try {
                subDomain = credfact.getDomainByPath(this.m_subDomain, baseDomain);
                Trace.out("Sudb domain..." + this.m_subDomain + "  exists...");
            }
            catch (NotExistsException ne) {
                Trace.out("Subdomain " + this.m_subDomain + " not exists with domain " + this.m_domain);
                try {
                    subDomain = credfact.createDomain(this.m_subDomain, baseDomain);
                }
                catch (AlreadyExistsException e) {
                    Trace.out("AlreadyExistsException..." + e.getMessage());
                }
            }
            return subDomain;
        }
        catch (CredentialsException e) {
            Trace.out("EmailException ..." + e.getMessage());
            throw new EmailException(e);
        }
    }

    private void changeSubDomainPermissions(CredDomain subDomain) throws EmailException {
        try {
            HashMap<String, String> attrs = new HashMap<String, String>();
            String user = new Util().getCRSUser();
            Trace.out("Changing subdomain permissions to user ..." + user);
            attrs.put(CredentialsAttribute.OWNER.getValue(), user);
            attrs.put(CredentialsAttribute.GROUP.getValue(), DBA_GROUP);
            attrs.put(CredentialsAttribute.OWNER_PERMS.getValue(), CredentialsFactory.formatOwnerACLString(user, CredentialsACLPerm.READ, CredentialsACLPerm.WRITE));
            attrs.put(CredentialsAttribute.GROUP_PERMS.getValue(), CredentialsFactory.formatGroupACLString(DBA_GROUP, CredentialsACLPerm.READ, CredentialsACLPerm.WRITE));
            attrs.put(CredentialsAttribute.OTHER_PERMS.getValue(), CredentialsFactory.formatOtherACLString(CredentialsACLPerm.READ, CredentialsACLPerm.WRITE));
            subDomain.setAttributes(attrs);
        }
        catch (CredentialsException | UtilException e) {
            Trace.out("%s....%s", e.getClass().getSimpleName(), e.getMessage());
            throw new EmailException(e);
        }
    }

    @Override
    public void remove() throws EmailException {
        this.remove(true);
    }

    @Override
    public void remove(boolean removeSubDomain) throws EmailException {
        try {
            Trace.out("Removing notification credentials ...");
            CredentialsFactory credfact = CredentialsFactory.getInstance();
            CredDomain baseDomain = credfact.getDomainByPath(this.m_domain, true);
            CredDomain subDomain = credfact.getDomainByPath(this.m_subDomain, baseDomain);
            CredentialsSet credSet = subDomain.getCredentialsSet(CredentialsType.USERPASS);
            credSet.removeCredentials(0);
            if (removeSubDomain) {
                Trace.out("Removing subdomain...");
                subDomain.remove();
            }
        }
        catch (NotExistsException e) {
            Trace.out("Credentials does not exists...");
        }
        catch (CredentialsException e) {
            Trace.out("CredentialException ..." + e.getMessage());
            throw new EmailException(e);
        }
    }

    @Override
    public void sendEmail(String subject, String msg, String toAddress) throws EmailException {
        this.internalSendEmail(subject, msg, new String[]{toAddress});
    }

    @Override
    public void sendEmail(String subject, String msg, String[] toAddress) throws EmailException {
        this.internalSendEmail(subject, msg, toAddress);
    }

    private void internalSendEmail(String subject, String msg, String[] toAddress) throws EmailException {
        this.sureNotNull(this.m_mailServerAddress, "mailServerAddress");
        if (this.m_mailServerPort == null) {
            throw new EmailException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mailServerPort");
        }
        if (toAddress == null || toAddress != null && toAddress.length == 0) {
            throw new EmailException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "toAddress");
        }
        try {
            Properties prop = this.getMailProperties();
            Authenticator auth = null;
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EmailImpl.this.m_emailAddress, EmailImpl.this.m_password);
                }
            };
            Trace.out("Getting session...");
            Session session = Session.getDefaultInstance((Properties)prop, (Authenticator)auth);
            Trace.out("DONE: Getting session...");
            MimeMessage mesg = this.createMessage(session, this.m_emailAddress, toAddress, subject, msg);
            Trace.out("Sending mail....");
            Transport.send((Message)mesg);
            Trace.out("DONE:Sending mail....");
        }
        catch (MessagingException e) {
            Trace.out((Object)"MessagingException: %s", e.getMessage());
            throw new EmailException(e);
        }
    }

    private Properties getMailProperties() {
        Trace.out("Mail port is...." + this.m_mailServerPort.toString());
        Properties mailProps = new Properties();
        mailProps.put("mail.transport.protocol", "smtp");
        mailProps.setProperty("mail.smtp.host", this.m_mailServerAddress);
        mailProps.setProperty("mail.smtp.port", this.m_mailServerPort.toString());
        mailProps.setProperty("mail.smtp.sendpartial", "true");
        if (!Utils.isDevelopmentEnv()) {
            mailProps.setProperty("mail.smtp.sendpartial", "true");
            mailProps.put("mail.smtp.socketFactory.port", this.m_mailServerPort.toString());
            mailProps.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        mailProps.put("mail.smtp.auth", "true");
        return mailProps;
    }

    private MimeMessage createMessage(Session session, String from, String[] toAddress, String subject, String body) throws MessagingException {
        MimeMessage msg = new MimeMessage(session);
        InternetAddress[] address = new InternetAddress[toAddress.length];
        for (int i = 0; i < toAddress.length; ++i) {
            address[i] = new InternetAddress(toAddress[i]);
        }
        msg.setFrom((Address)new InternetAddress(from));
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setText(body);
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        return msg;
    }

    private void sureNotNull(Object o, String name) throws EmailException {
        if (o == null || o.toString().trim().length() == 0) {
            throw new EmailException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, name);
        }
    }

    private void authenticate() throws EmailException {
        this.sureNotNull(this.m_emailAddress, "emailAddress");
        this.sureNotNull(this.m_mailServerAddress, "mailServerAddress");
        if (this.m_mailServerPort == null) {
            throw new EmailException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mailServerPort");
        }
        Properties prop = this.getMailProperties();
        Trace.out("Authenticating email account details");
        Session session = Session.getInstance((Properties)prop);
        try {
            Transport transport = session.getTransport("smtp");
            transport.connect(this.m_mailServerAddress, this.m_emailAddress, this.m_password);
            transport.close();
            Trace.out("Email authentication complete");
        }
        catch (AuthenticationFailedException e) {
            Trace.out((Object)"Email authentication failed. Exception: %s", e.getMessage());
            throw new EmailException((MessageKey)PrCcMsgID.GH_EMAIL_AUTHENTICATION_FAILED, new Object[0]);
        }
        catch (MessagingException e) {
            Trace.out((Object)"Connection to email server failed. Exception: %s", e.getMessage());
            throw new EmailException((MessageKey)PrCcMsgID.GH_FAILED_EMAIL_SERVER_CONNECTION, new Object[0]);
        }
    }
}

