/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.email;

import java.util.List;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.Credentials;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.email.Email;
import oracle.cluster.email.EmailException;
import oracle.cluster.impl.email.EmailImpl;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.trace.Trace;

public class EmailFactoryImpl {
    private static EmailFactoryImpl s_instance = null;

    public static synchronized EmailFactoryImpl getInstance() throws EmailException {
        if (s_instance == null) {
            s_instance = new EmailFactoryImpl();
        }
        return s_instance;
    }

    public void registerEmail(Email email) throws EmailException {
        email.register();
    }

    public Email getEmail(String domain, String subDomain, String mailServerAddress, Integer mailServerPort) throws NotExistsException, EmailException {
        try {
            Trace.out("Getting notification credentials ...");
            CredentialsFactory credfact = CredentialsFactory.getInstance();
            CredDomain baseDomain = credfact.getDomainByPath(domain, true);
            CredDomain credSubDomain = credfact.getDomainByPath(subDomain, baseDomain);
            CredentialsSet credSet = credSubDomain.getCredentialsSet(CredentialsType.USERPASS);
            List<Credentials> credentials = credSet.getAllCredentials();
            UserPassCredentials userPass = credSet.getUserPassCredentials(0);
            EmailImpl email = new EmailImpl(userPass.getUsername(), userPass.getPassword(), mailServerAddress, mailServerPort, domain, subDomain);
            return email;
        }
        catch (CredentialsException e) {
            Trace.out("CredentialException ..." + e.getMessage());
            throw new EmailException(e);
        }
    }
}

