/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.deployment.acfsclone;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.regex.PatternSyntaxException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.deployment.acfsclone.ACFSCloneSnapshotException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

abstract class ACFSCloneSnapshot {
    static final String[] KEYS = new String[]{"qfu6tvp037789qo1"};
    static final String CLONESNAP_MSG_ACK1 = "ack1";
    static final String CLONESNAP_MSG_ACK2 = "ack2";
    static final String CLONESNAP_MSG_ACK3 = "ack3";
    static final String CLONESNAP_MSG_INVALID_KEY = "invalid key";
    static final String CLONESNAP_MSG_ERR1 = "err1";
    static final String CLONESNAP_CMD_DELIMITER = ";===;";
    static final String INVALID_MSG = "invalid";
    static final String ACFSUTL_ARG_SNAP = "snap";
    static final String ACFSUTL_ARG_CLONE = "duplicate";
    static final String ACFSUTL_ARG_INCCLONE = "-i";
    static final String ACFSUTL_ARG_APPLY = "apply";
    static final String ACFSUTL_ARG_CREATE = "create";
    static final String EOT = "==end of transmission==";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final int NO_TIMEOUT = 0;
    static final int CMD_SUCCESS = 0;
    static final int NUM_SRC_PERMITS = 2;
    static final int NUM_DST_PERMITS = 1;
    static final String ACFSUTIL_SNAP_NOT_EXIST = "ACFS-03051";
    static final String ACFSUTIL_INVALID_MOUNT_PATH = "ACFS-03044";
    static final String ACFSUTIL_SNAP_ALREADY_EXISTS = "ACFS-03050";
    static final String ACFSUTIL_DST_FS_NOT_EMPTY = "ACFS-05031";
    static final String ACFSUTIL_CLONE_TARGET_MODIFIED = "ACFS-05905";
    static final String ACFSUTIL_SNAP_RO = "ACFS-05902";

    ACFSCloneSnapshot() {
    }

    void closeInputStream(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
            Trace.out("ACFSCloneSnapshot-closeInStream : closed input stream");
        }
        catch (IOException e) {
            Trace.out("ACFSCloneSnapshot-closeInStream-IOE : " + e);
        }
    }

    void closeOutputStream(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
            Trace.out("ACFSCloneSnapshot-closeOutStream : closed output stream");
        }
        catch (IOException e) {
            Trace.out("ACFSCloneSnapshot-closeOutStream-IOE : " + e);
        }
    }

    void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.shutdownOutput();
            socket.close();
            Trace.out("ACFSCloneSnapshot-closeSocket : closed socket");
        }
        catch (IOException e) {
            Trace.out("ACFSCloneSnapshot-closeSocket-IOE : " + e);
        }
    }

    class ClientRequestMessage {
        ClientRequestMessage() {
        }

        String generateClientRequestMsg(String lsnrKey, String ... args) throws InvalidArgsException {
            if (args.length == 0) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ClientRequestMessage-generateClientRequestMsg");
            }
            StringBuilder cmd = new StringBuilder();
            cmd.append(args[0]);
            for (int i = 1; i < args.length; ++i) {
                cmd.append(ACFSCloneSnapshot.CLONESNAP_CMD_DELIMITER);
                cmd.append(args[i]);
            }
            return this.generateClientMsg2Lsnr(cmd.toString(), lsnrKey);
        }

        String generateClientMsg2Lsnr(String msg, String lsnrKey) {
            return lsnrKey + ":===:" + msg;
        }

        boolean verifyKeyInClientMsg(String msg, String lsnrKey) throws InvalidArgsException {
            String clientKey = this.getKeyFromClientMsg(msg);
            if (!clientKey.equals(lsnrKey)) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ClientRequestMessage-verifyKey");
            }
            return true;
        }

        String getKeyFromClientMsg(String msg) throws InvalidArgsException {
            if (msg == null || msg.trim().isEmpty() || !msg.contains(":===:")) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ClientRequestMessage-getKey");
            }
            String key = "";
            try {
                String[] vals = msg.split(":===:");
                key = vals[0];
            }
            catch (PatternSyntaxException pse) {
                Trace.out("ClientRequestMessage-getKey-PSE : " + pse);
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)pse, "ClientRequestMessage-getKey");
            }
            return key;
        }

        RequestMessages getReqIDFromClientMsg(String msg) throws InvalidArgsException {
            if (msg == null || msg.trim().isEmpty() || !msg.contains(":===:") || !msg.contains(ACFSCloneSnapshot.CLONESNAP_CMD_DELIMITER)) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ClientRequestMessage-getReqIDFromClientMsg");
            }
            String req = msg.split(":===:")[1];
            String[] reqArgs = req.split(ACFSCloneSnapshot.CLONESNAP_CMD_DELIMITER);
            RequestMessages reqID = null;
            try {
                reqID = RequestMessages.getEnumMember(reqArgs[0]);
            }
            catch (ACFSCloneSnapshotException acse) {
                Trace.out("ClientRequestMessage-getReqIDFromClientMsg-ACSE : " + acse);
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)acse, "ClientRequestMessage-getReqIDFromClientMsg");
            }
            return reqID;
        }

        List<String> getArgsFromClientMsg(String msg) throws InvalidArgsException {
            if (msg == null || msg.trim().isEmpty() || !msg.contains(":===:") || !msg.contains(ACFSCloneSnapshot.CLONESNAP_CMD_DELIMITER)) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ClientRequestMessage-getArgsFromClientMsg-illegal argument");
            }
            String req = msg.split(":===:")[1];
            String[] reqArgs = req.split(ACFSCloneSnapshot.CLONESNAP_CMD_DELIMITER);
            if (reqArgs.length < 2) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ClientRequestMessage-getArgsFromClientMsg-invalid argument");
            }
            ArrayList<String> args = new ArrayList<String>();
            for (int i = 1; i < reqArgs.length; ++i) {
                args.add(reqArgs[i]);
            }
            return args;
        }
    }

    static enum RequestMessages {
        APPLY_NONINC_CLONE(100),
        APPLY_INC_CLONE(101),
        CREATE_RW_SNAP(102),
        CREATE_RWCHILD_SNAP(103),
        CONVERT_SNAP2RO(104);

        private final int value;

        private RequestMessages(int newValue) {
            this.value = newValue;
        }

        int getValue() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        static RequestMessages getEnumMember(String id) throws ACFSCloneSnapshotException {
            try {
                return RequestMessages.getEnumMember(Integer.parseInt(id));
            }
            catch (NumberFormatException nfe) {
                Trace.out("ACFSCloneSnapshot-RequestMessages-NFE : " + nfe);
                throw new ACFSCloneSnapshotException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)nfe, "ACFSCloneSnapshot-RequestMessages-invalid request id");
            }
        }

        static RequestMessages getEnumMember(int id) throws ACFSCloneSnapshotException {
            for (RequestMessages msg : RequestMessages.values()) {
                if (msg.getValue() != id) continue;
                return msg;
            }
            throw new ACFSCloneSnapshotException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneSnapshot-RequestMessages-invalid request id");
        }
    }

    class StreamReader
    implements Runnable {
        private InputStream m_input;
        private StringBuilder m_buf;
        private boolean m_isSuccess = false;
        private Semaphore m_sema = null;

        StreamReader(InputStream input) {
            this.m_input = input;
            this.m_buf = new StringBuilder();
            this.setSuccess(false);
        }

        StreamReader(InputStream input, Semaphore copyWait) throws InterruptedException {
            this(input);
            try {
                this.m_sema = copyWait;
                this.m_sema.acquire();
            }
            catch (InterruptedException ie) {
                Trace.out("StreamReader-IE : " + ie);
                throw ie;
            }
        }

        private synchronized void setSuccess(boolean isSuccess) {
            this.m_isSuccess = isSuccess;
        }

        synchronized boolean isSuccess() {
            return this.m_isSuccess;
        }

        private synchronized void appendString(String line) {
            this.m_buf.append(line + LINE_SEPARATOR);
        }

        synchronized String getString() {
            return this.m_buf.toString();
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader inReader = new BufferedReader(new InputStreamReader(this.m_input));
                while ((line = inReader.readLine()) != null && !ACFSCloneSnapshot.EOT.equals(line)) {
                    this.appendString(line);
                }
                this.setSuccess(true);
                Trace.out("StreamReader : Exiting successfully");
            }
            catch (IOException e) {
                Trace.out("StreamReader-IOE1 : " + e);
            }
            finally {
                if (this.m_sema != null) {
                    this.m_sema.release();
                }
            }
        }
    }
}

