/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.StartOptions;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyUpgradedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.Service;
import oracle.ops.mgmt.database.ServiceException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class UpgradeDatabaseConfig {
    private String m_dbUniqueName = null;
    private String m_oracleHome = null;
    private Version m_version = new Version();
    private String m_oldOracleHome = null;
    private ParallelServer m_ps = null;
    private ParallelServerConfig m_psConfig = null;
    private DatabaseOptionalArgs m_dbOptArgs = null;
    private ServerGroup m_dbSG = null;
    private DatabaseImpl m_database = null;
    private Map<String, LinkedList> m_servicesMap = null;

    UpgradeDatabaseConfig(String dbUniqueName, String oracleHome) throws UpgradeException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new UpgradeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        try {
            DatabaseImpl.assertOracleHome(oracleHome);
        }
        catch (DatabaseException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, dbUniqueName, this.m_version.toString(), oracleHome);
        }
        this.m_dbUniqueName = dbUniqueName;
        this.m_oracleHome = oracleHome;
    }

    void upgrade() throws AlreadyUpgradedException, UpgradeException, CompositeOperationException {
        DatabaseFactoryImpl dfImpl = null;
        Version dbVersion = null;
        try {
            dfImpl = DatabaseFactoryImpl.getInstance();
            dbVersion = dfImpl.getDatabaseVersion(this.m_dbUniqueName);
        }
        catch (NotExistsException e) {
            try {
                dbVersion = Cluster.getParallelServerVersion(this.m_dbUniqueName);
            }
            catch (ConfigurationException ce) {
                throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)ce, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
            }
        }
        catch (SoftwareModuleException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
        if (Version.isPre10i(dbVersion)) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UNSUPPORTED_UPGRADE_VERSION, this.m_dbUniqueName, dbVersion.toString());
        }
        this.checkOracleUser(this.m_oracleHome);
        if (!Version.isPre112(dbVersion)) {
            try {
                DatabaseImpl db = (DatabaseImpl)dfImpl.getDatabase(this.m_dbUniqueName, dbVersion);
                this.m_oldOracleHome = db.getOracleHome();
                this.checkOracleUser(this.m_oldOracleHome);
                db.upgrade(this.m_oracleHome);
                return;
            }
            catch (DatabaseException e) {
                throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
            }
            catch (NotExistsException e) {
                throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
            }
        }
        try {
            this.m_ps = Cluster.getParallelServer(this.m_dbUniqueName, null, dbVersion);
            this.m_psConfig = this.m_ps.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
        this.m_oldOracleHome = this.m_psConfig.getOracleHome();
        this.checkOracleUser(this.m_oldOracleHome);
        this.populateDatabase();
        this.populateServices();
        this.removeHADBAndServices();
        Trace.out("Creating TB database configuration");
        this.createDatabase();
        Trace.out("Create TB service configuration");
        this.createServices();
        Trace.out("Successfully upgraded database and service configuration");
    }

    private void populateDatabase() throws UpgradeException {
        try {
            Trace.out("Getting pre-TB database information");
            this.m_dbOptArgs = new DatabaseOptionalArgs();
            String dbName = this.m_psConfig.getDBName() == null ? "" : this.m_psConfig.getDBName();
            Trace.out("db name = " + dbName);
            this.m_dbOptArgs.setDBName(dbName);
            String dbDomain = this.m_psConfig.getDomain() == null ? "" : this.m_psConfig.getDomain();
            Trace.out("db domain = " + dbDomain);
            this.m_dbOptArgs.setDBDomain(dbDomain);
            String spfile = this.m_psConfig.getSPFile() == null ? "" : this.m_psConfig.getSPFile();
            Trace.out("spfile = " + spfile);
            this.m_dbOptArgs.setSPFile(spfile);
            if (this.m_psConfig.getRole() != null && this.m_psConfig.getRole().trim().length() != 0) {
                this.m_dbOptArgs.setDBRole(DBRole.getEnumMember(this.m_psConfig.getRole()));
            }
            if (this.m_psConfig.getStartOpt() != null && this.m_psConfig.getStartOpt().trim().length() != 0) {
                this.m_dbOptArgs.setStartMode(StartOptions.getEnumMember(this.m_psConfig.getStartOpt()));
            }
            if (this.m_psConfig.getManagementPolicy() != null && this.m_psConfig.getManagementPolicy().trim().length() != 0) {
                this.m_dbOptArgs.setMgmtPolicy(ManagementPolicy.getEnumMember(this.m_psConfig.getManagementPolicy()));
            }
            Vector vInstances = this.m_psConfig.getInstances();
            HashMap<String, Node> instMap = new HashMap<String, Node>(vInstances.size());
            Iterator iter = vInstances.iterator();
            ServerFactory sf = ServerFactory.getInstance();
            while (iter.hasNext()) {
                Instance inst = (Instance)iter.next();
                instMap.put(inst.getName(), sf.getNode(inst.getNode()));
            }
            this.m_dbOptArgs.setInstanceNodeMap(instMap);
        }
        catch (DatabaseException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
        catch (NodeException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
        catch (ServerException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
    }

    private void populateServices() throws UpgradeException {
        Trace.out("Getting pre-TB services information");
        String[] services = this.m_psConfig.enumerateServices();
        if (services == null || services.length == 0) {
            this.m_servicesMap = new LinkedHashMap<String, LinkedList>(0);
            return;
        }
        try {
            this.m_servicesMap = new LinkedHashMap<String, LinkedList>(services.length);
            for (String svcName : services) {
                Trace.out("service = " + svcName);
                Service service = new Service(svcName, this.m_ps);
                String tafPolicy = service.getTAFPolicy();
                ServiceTAF sTAF = tafPolicy == null || tafPolicy.trim().length() == 0 ? ServiceTAF.NONE : ServiceTAF.getEnumMember(tafPolicy);
                String[] preInsts = service.getPreferred();
                String[] availInsts = service.getAvailable();
                LinkedList<Object> details = new LinkedList<Object>();
                details.add((Object)sTAF);
                details.add(preInsts != null ? Arrays.asList(preInsts) : new ArrayList(0));
                details.add(availInsts != null ? Arrays.asList(availInsts) : new ArrayList(0));
                this.m_servicesMap.put(svcName, details);
            }
        }
        catch (ServiceException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
    }

    private void removeHADBAndServices() throws UpgradeException {
        Trace.out("Deleting HA services from OCR");
        if (this.m_servicesMap.size() == 0) {
            Trace.out("database has no services to remove");
        }
        Service service = null;
        for (String svcName : this.m_servicesMap.keySet()) {
            Trace.out("Service to be deleted: " + svcName);
            try {
                service = new Service(svcName, this.m_ps);
                Trace.out("Trying to stop service " + svcName);
                service.stop(null, false, true);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            try {
                Trace.out("Trying to remove the service");
                service.remove(true);
            }
            catch (ServiceException e) {
                throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
            }
        }
        try {
            Trace.out("stopping the database");
            this.m_ps.stop();
        }
        catch (oracle.ops.mgmt.database.DatabaseException e) {
            Trace.out("Not able to stop the database");
        }
        try {
            Trace.out("Remove pre TB database configuration forcefully");
            this.m_ps.remove(true);
        }
        catch (oracle.ops.mgmt.database.DatabaseException e) {
            Trace.out("Failed to delete the database configuration");
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
    }

    /*
     * Exception decompiling
     */
    private void createDatabase() throws UpgradeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createServices() throws UpgradeException {
        if (this.m_servicesMap.size() == 0) {
            Trace.out("database has no services to create");
            return;
        }
        try {
            DatabaseFactoryImpl df = DatabaseFactoryImpl.getInstance();
            for (String svcName : this.m_servicesMap.keySet()) {
                LinkedList details = this.m_servicesMap.get(svcName);
                ServiceTAF sTaf = (ServiceTAF)((Object)details.get(0));
                List prefInsts = (List)details.get(1);
                List availInsts = (List)details.get(2);
                String sgName = this.m_dbUniqueName + '_' + svcName;
                Server[] prefServ = this.getServerList(prefInsts);
                Server[] availServ = this.getServerList(availInsts);
                int maxSize = prefServ.length + availServ.length;
                ServerFactory sf = ServerFactory.getInstance();
                ArrayList<ServerGroup> parent = new ArrayList<ServerGroup>(1);
                parent.add(this.m_dbSG);
                Server[] allServ = new Server[maxSize];
                System.arraycopy(prefServ, 0, allServ, 0, prefServ.length);
                if (availServ.length > 0) {
                    System.arraycopy(availServ, 0, allServ, prefServ.length, availServ.length);
                }
                ServerGroup svcSG = sf.createServerGroup(sgName, 0, maxSize, 0, null, parent, allServ);
                ServiceArgs servArgs = new ServiceArgs();
                servArgs.setServerGroup(svcSG);
                ServiceCardinality card = ServiceCardinality.COUNTED;
                card.setCount(prefInsts.size());
                servArgs.setServiceCardinality(card);
                df.createService(svcName, this.m_database, sTaf, servArgs, new Version());
            }
        }
        catch (AlreadyExistsException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
        catch (ServerException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
        catch (SoftwareModuleException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
    }

    private Server[] getServerList(List<String> instances) throws UpgradeException {
        ArrayList<Server> serverList = new ArrayList<Server>(instances.size());
        try {
            Map<String, Node> instNodeMap = this.m_dbOptArgs.getInstNodeMap();
            block2: for (String inst : instances) {
                for (String instName : instNodeMap.keySet()) {
                    if (!instName.equalsIgnoreCase(inst)) continue;
                    serverList.add(instNodeMap.get(instName).server());
                    continue block2;
                }
            }
        }
        catch (NodeException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
        return serverList.toArray(new Server[serverList.size()]);
    }

    private void checkOracleUser(String oracleHome) throws UpgradeException {
        try {
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (UtilException e) {
            throw new UpgradeException((MessageKey)PrCdMsgID.UPGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_version.toString(), this.m_oracleHome);
        }
    }
}

