/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import oracle.cluster.database.Database;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.SingleInstanceService;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class SingleInstanceServiceImpl
extends ServiceImpl
implements SingleInstanceService {
    SingleInstanceServiceImpl(ResourceAttribute nameAttr) throws ServiceException {
        super(nameAttr, null);
    }

    SingleInstanceServiceImpl(ResourceAttribute nameAttr, String serviceName) throws ServiceException {
        super(nameAttr, serviceName);
    }

    @Override
    public ServerGroup serverGroup() throws ServerGroupException {
        try {
            return ((DatabaseImpl)this.database()).serverGroup();
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        catch (ServiceException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, ServiceException {
        this.create(database, tafPolicy, serviceArgs, version, false);
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs svcArgs, Version version, boolean checkListener) throws AlreadyExistsException, ServiceException {
        if (tafPolicy == ServiceTAF.PRECONNECT) {
            throw new ServiceException((MessageKey)PrCdMsgID.PRECONNECT_4_SIDB, database.getUserAssignedName());
        }
        super.create(database, tafPolicy, svcArgs, version, checkListener);
    }

    @Override
    void modify(ServiceArgs serviceArgs, boolean global) throws ServiceException {
        ServiceCardinality card = serviceArgs.getServiceCardinality();
        if (ServiceCardinality.UNIFORM == card || ServiceCardinality.COUNTED == card) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_CARD_FOR_SI_SVC, new Object[]{card, this.getUserAssignedName()});
        }
        ServerGroup serverPool = serviceArgs.getServerGroup();
        if (serverPool != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.CANNOT_MOD_SP_OF_SI_SVC, serverPool.getUserAssignedName(), this.getUserAssignedName());
        }
        super.modify(serviceArgs, global);
    }

    @Override
    void modify(ServiceArgs serviceArgs) throws ServiceException {
        this.modify(serviceArgs, false);
    }
}

