/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSNotRegisteredException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.database.CLBGoal;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.FailoverMethod;
import oracle.cluster.database.FailoverRestore;
import oracle.cluster.database.FailoverType;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.RLBGoal;
import oracle.cluster.database.SIDBType;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceStopArgs;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.ServiceType;
import oracle.cluster.database.SessionStateEnum;
import oracle.cluster.database.SingleInstanceDatabase;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.crs.cops.RTEArg;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.impl.database.Common;
import oracle.cluster.impl.database.DatabaseAction;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ServiceImpl
extends SoftwareModuleImpl
implements Service {
    protected ResourceAttribute m_nameAttr;

    protected ServiceImpl(ResourceAttribute nameAttr, String serviceName) throws ServiceException {
        this(null, nameAttr, serviceName);
    }

    protected ServiceImpl(CRSEntity sibling, ResourceAttribute nameAttr, String serviceName) throws ServiceException {
        this.checkNameAndInit(nameAttr);
        try {
            this.m_crsResource = sibling == null ? (CRSResourceImpl)CRSFactoryImpl.getInstance().getRegisteredOrNot(this.m_nameAttr) : (CRSResourceImpl)CRSFactoryImpl.getInstance().getRegisteredOrNot(this.m_nameAttr, sibling);
            try {
                this.m_displayName = this.m_crsResource.getAttribute(ResourceType.Service.SERVICE_NAME.name()).getValue();
            }
            catch (CRSNotRegisteredException e) {
                if (serviceName != null) {
                    this.m_displayName = serviceName;
                }
            }
        }
        catch (CRSException e) {
            Trace.out("CRSException encountered: nameAttr=" + nameAttr.toString() + "   " + e);
            throw new ServiceException(e);
        }
    }

    private void checkNameAndInit(ResourceAttribute nameAttr) throws ServiceException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceType.Service.NAME.name())) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.Service.NAME.name());
        }
        Trace.out("value of attribute = " + nameAttr.getValue());
        String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
        if (value.length < 4 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.SVC.toString().equalsIgnoreCase(value[value.length - 1])) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Service.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < value.length - 1; ++i) {
            if (sb.length() > 0) {
                sb.append('.' + value[i]);
                continue;
            }
            sb.append(value[i]);
        }
        this.m_displayName = sb.toString();
    }

    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, ServiceException {
        this.create(database, tafPolicy, serviceArgs, version, false);
    }

    void create(Database database, ServiceTAF tafPolicy, ServiceArgs svcArgs, Version version, boolean checkListener) throws AlreadyExistsException, ServiceException {
        this.create(database, tafPolicy, svcArgs, version, checkListener, false);
    }

    void create(Database database, ServiceTAF tafPolicy, ServiceArgs svcArgs, Version version, boolean checkListener, boolean onlyUpdate) throws AlreadyExistsException, ServiceException {
        String serviceName = this.getUserAssignedName();
        try {
            this.validateServiceName(serviceName, database.getUserAssignedName(), database.getDomain(), false);
            Util util = new Util();
            Trace.out("about to check whether current user is oracle user");
            database.checkOracleUser();
        }
        catch (UtilException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, this.getUserAssignedName(), database.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, this.getUserAssignedName(), database.getUserAssignedName());
        }
        boolean isCluster = Cluster.isCluster();
        Network network = null;
        ServiceCardinality cardinality = null;
        ServerGroup serverGroup = null;
        boolean disconnect = false;
        DBRole[] roles = null;
        String pqservice = null;
        String mainservice = null;
        ServiceType serviceType = null;
        ServiceArgs serviceArgs = svcArgs;
        if (serviceArgs == null) {
            serviceArgs = new ServiceArgs();
        }
        if ((serviceType = serviceArgs.getServiceType()) == ServiceType.PQ) {
            network = null;
            mainservice = serviceArgs.getMainService();
            if (mainservice != null && mainservice.trim().length() != 0) {
                this.validateServiceName(mainservice, null, null, false);
            }
        } else {
            network = serviceArgs.getNetwork();
            pqservice = serviceArgs.getPQService();
            if (pqservice != null && pqservice.trim().length() != 0) {
                this.validateServiceName(pqservice, null, null, false);
            }
        }
        serverGroup = serviceType == ServiceType.RF ? serviceArgs.getRFPool() : serviceArgs.getServerGroup();
        Trace.out("Check the server category for server group " + serverGroup);
        if (serverGroup != null) {
            try {
                if (serviceType == ServiceType.PQ) {
                    Common.checkPQServerCategory(serverGroup);
                } else if (serviceType == ServiceType.RF) {
                    Trace.out("RF service");
                    Common.checkRFServerCategory(serverGroup);
                } else {
                    Common.checkPrimaryServerCategory(serverGroup);
                }
            }
            catch (DatabaseException e) {
                throw new ServiceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), serviceName);
            }
        }
        cardinality = serviceArgs.getServiceCardinality();
        disconnect = serviceArgs.getDisconnectOpt() != null ? serviceArgs.getDisconnectOpt() : false;
        roles = serviceArgs.getRoles();
        try {
            CRSResource.CSSCritical cssCritical;
            Object subnet2;
            if (network != null) {
                if (serviceType == ServiceType.RF) {
                    if (!network.isExtendedNW()) {
                        throw new ServiceException((MessageKey)PrCsMsgID.ADD_RF_SVC_UNPROPAGATED_NW, network.getNumber());
                    }
                } else if (network.isLeafNW()) {
                    throw new ServiceException((MessageKey)PrCsMsgID.ADD_RESOURCE_ON_LEAF_NETWORK_ERROR, network.getNumber());
                }
            }
            if (cardinality == null) {
                cardinality = isCluster && serverGroup != null && serverGroup.isServerPool() ? ServiceCardinality.UNIFORM : ServiceCardinality.SINGLETON;
            }
            ManagementPolicy dbpolicy = database.getMgmtPolicy();
            if (serviceArgs.getMgmtPolicy() != null) {
                Trace.out("checking compatibility in managment policy");
                if (serviceArgs.getMgmtPolicy() == ManagementPolicy.AUTOMATIC && (dbpolicy == ManagementPolicy.MANUAL || dbpolicy == ManagementPolicy.NORESTART)) {
                    throw new ServiceException((MessageKey)PrCdMsgID.DB_SERV_MGMT_POLICY_ERR, serviceName, database.getUserAssignedName());
                }
            } else if (dbpolicy == ManagementPolicy.NORESTART) {
                serviceArgs.setMgmtPolicy(ManagementPolicy.MANUAL);
            } else {
                serviceArgs.setMgmtPolicy(dbpolicy);
            }
            boolean isServiceCentric = false;
            List<ServerGroup> dbSGList = null;
            Trace.out("Getting Oracle Home");
            String oracleHome = database.getOracleHome();
            boolean isClusterDB = database.isClusterDatabase();
            DatabaseType dbType = database.databaseType();
            Trace.out("Checking cardinality and taf policy");
            if (cardinality == ServiceCardinality.UNIFORM && tafPolicy == ServiceTAF.PRECONNECT) {
                throw new ServiceException((MessageKey)PrCdMsgID.CARDINALITY_TAF_ERROR, cardinality.toString(), tafPolicy.toString(), serviceName);
            }
            if (!onlyUpdate && isCluster && dbType == DatabaseType.RAC) {
                String sgName = serverGroup.getUserAssignedName();
                Trace.out("Checking whether server group, " + sgName + " is db-centric or service-centric");
                isServiceCentric = serverGroup.isServerPool();
                dbSGList = database.serverGroups();
                if (!isServiceCentric) {
                    if (dbSGList.size() != 1) {
                        throw new ServiceException((MessageKey)PrCdMsgID.INVALID_DB_CENTRIC_CONFIG, DatabaseImpl.getServerGroupString(dbSGList, ",", true), database.getUserAssignedName());
                    }
                    StringBuilder dbSb = new StringBuilder();
                    StringBuilder svcSb = new StringBuilder();
                    List<Database> dbList = serverGroup.databases();
                    List<Service> svcList = serverGroup.services();
                    for (Database db : dbList) {
                        if (dbSb.length() > 0) {
                            dbSb.append("," + db.getUserAssignedName());
                            continue;
                        }
                        dbSb.append(db.getUserAssignedName());
                    }
                    Iterator<Database> iterator = svcList.iterator();
                    while (iterator.hasNext()) {
                        Service svc = (Service)((Object)iterator.next());
                        if (svcSb.length() > 0) {
                            svcSb.append("," + svc.getUserAssignedName());
                            continue;
                        }
                        svcSb.append(svc.getUserAssignedName());
                    }
                    if (dbSb.length() > 0 && svcSb.length() > 0) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.EXISTING_DB_CENTRIC_CONFIG, serverGroup.getUserAssignedName(), database.getUserAssignedName(), dbSb.toString(), svcSb.toString());
                    }
                    if (dbSb.length() > 0) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.EXISTING_DB_CENTRIC_CONFIG_DB, serverGroup.getUserAssignedName(), database.getUserAssignedName(), dbSb.toString());
                    }
                    if (svcSb.length() > 0) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.EXISTING_DB_CENTRIC_CONFIG_SERV, serverGroup.getUserAssignedName(), database.getUserAssignedName(), svcSb.toString());
                    }
                }
                for (ServerGroup dbsgrp : dbSGList) {
                    if (!dbsgrp.isServerPool()) {
                        if (isServiceCentric) {
                            throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_DB_SERV_CENTRIC_CONFIG, serviceName, database.getUserAssignedName());
                        }
                        List<ServerGroup> sgParents = serverGroup.parents();
                        for (ServerGroup sg : sgParents) {
                            if (sg.getName().equals(dbsgrp.getName())) continue;
                            throw new ServiceException((MessageKey)PrCdMsgID.PARENT_GROUPS_DIFFERENCE, sgName, database.getUserAssignedName());
                        }
                        continue;
                    }
                    if (isServiceCentric) continue;
                    throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_DB_DB_CENTRIC_CONFIG, serviceName, database.getUserAssignedName());
                }
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (!onlyUpdate && serviceType != ServiceType.PQ) {
                if (isCluster) {
                    Trace.out("Checking for existence of cluster vip");
                    ResourceAttribute vipNetAttr = crsFactory.create(ResourceType.ClusterVIP.NAME.name(), ResourceType.ClusterVIP.getVIPNetTypeName(network.getNumber()));
                    if (!crsFactory.isRegistered(vipNetAttr.getValue(), CRSEntity.Type.ResourceType)) {
                        throw new ServiceException((MessageKey)PrCrMsgID.RES_TYPE_NOT_EXISTS, vipNetAttr.getValue());
                    }
                }
                if (isCluster && checkListener) {
                    int serviceNetwork = network.getNumber();
                    String networkInfo = String.format("%d", network.getNumber());
                    try {
                        Map<IPAddressUtil.IPAddrType, Subnet> subnetMap = network.subnets();
                        Subnet ipv4Subnet = subnetMap.get((Object)IPAddressUtil.IPAddrType.IPv4);
                        Subnet ipv6Subnet = subnetMap.get((Object)IPAddressUtil.IPAddrType.IPv6);
                        subnet2 = "";
                        String subnetMask = "";
                        if (ipv4Subnet != null && ipv6Subnet != null) {
                            networkInfo = String.format("%s, %s", ipv4Subnet.getName(), ipv6Subnet.getName());
                        } else if (ipv4Subnet != null && ipv6Subnet == null) {
                            subnet2 = ipv4Subnet.getName();
                            subnetMask = ipv4Subnet.subnetMaskAsStr();
                            networkInfo = String.format("%s/%s", subnet2, subnetMask);
                        } else if (ipv4Subnet == null && ipv6Subnet != null) {
                            subnet2 = ipv6Subnet.getName();
                            subnetMask = ipv6Subnet.subnetMaskAsStr();
                            networkInfo = String.format("%s/%s", subnet2, subnetMask);
                        }
                    }
                    catch (NotExistsException subnetMap) {
                    }
                    catch (NetworkException subnetMap) {
                        // empty catch block
                    }
                    Trace.out(String.format("Service network %d, info %s", serviceNetwork, networkInfo));
                    boolean networkOK = false;
                    SoftwareModuleException err = null;
                    try {
                        networkOK = NodeAppsFactoryImpl.getInstance().getListeners(network).size() > 0;
                    }
                    catch (ListenerException e) {
                        err = e;
                    }
                    catch (SoftwareModuleException e) {
                        err = e;
                    }
                    if (err != null) {
                        throw new ServiceException((MessageKey)PrCdMsgID.SERV_CHECK_NTWK_FAILED, (Throwable)err, networkInfo);
                    }
                    if (!networkOK) {
                        throw new ServiceException((MessageKey)PrCdMsgID.SERV_CHECK_BAD_NTWK, networkInfo, serviceName);
                    }
                }
            }
            ResourceAttribute svcTypeAttr = crsFactory.create(ResourceType.Service.NAME.name(), ResourceType.Service.NAME.toString());
            List<ResourceAttribute> attrList0 = crsFactory.getResourceTypeEntity(svcTypeAttr).getAttributes(new String[0]);
            attrList0 = ResourceType.getProfile(attrList0);
            String svcPoolName = isCluster && (dbType == DatabaseType.SIDB && database.getSIDBType() != SIDBType.FIXED || dbType == DatabaseType.RACOneNode) ? ((DatabaseImpl)database).serverGroup().getName() : (serverGroup != null ? serverGroup.getName() : null);
            Trace.out("Getting attribute list for normal service");
            List<ResourceAttribute> attrList = this.createServiceAttr(attrList0, serviceName, database.getUserAssignedName(), network != null ? network.getNumber() : -1, tafPolicy, svcPoolName, disconnect, false, roles, version, database, cardinality, serviceArgs, isCluster, isClusterDB, dbType);
            if (!isCluster) {
                attrList.add(crsFactory.createSIHAResourceACL());
            }
            if ((cssCritical = serviceArgs.getCSSCriticalOption()) != null && !database.isAdminManaged()) {
                throw new ServiceException((MessageKey)PrCdMsgID.CSS_CRITICAL_NA2, this.getUserAssignedName(), database.getUserAssignedName());
            }
            attrList.add(crsFactory.create(ResourceType.Service.CSS_CRITICAL.name(), cssCritical != null ? cssCritical.toString() : ResourceType.Service.CSS_CRITICAL.toString()));
            Trace.out("Printing the service profile");
            for (ResourceAttribute attr : attrList) {
                Trace.out(attr.getName() + "=" + attr.getValue());
            }
            Trace.out("Checking if srvctl interrupt handler is being tested");
            if (Utils.isSRVCTLInterruptTest()) {
                Trace.out("Testing interrupt handler for 'srvctl add service'");
                Trace.enableLogging("StartSRVCTLAddServiceInterruptTest.trc", true);
                Trace.out("Waiting for CTRL-C ...");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException subnet2) {
                    // empty catch block
                }
            }
            if (!onlyUpdate) {
                this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            } else {
                this.m_crsResource.update(attrList);
            }
            if (tafPolicy == ServiceTAF.PRECONNECT) {
                try {
                    Trace.out("Getting attribute list for preconnect service");
                    attrList = this.createServiceAttr(attrList0, serviceName, database.getUserAssignedName(), network != null ? network.getNumber() : -1, tafPolicy, serverGroup != null ? serverGroup.getName() : null, disconnect, true, roles, version, database, ServiceCardinality.SINGLETON, serviceArgs, isCluster, isClusterDB, dbType);
                    Trace.out("Printing the TAF service profile");
                    for (ResourceAttribute attr : attrList) {
                        Trace.out(attr.getName() + "=" + attr.getValue());
                    }
                    Trace.out("Finished printing the TAF service profile");
                    if (!onlyUpdate) {
                        subnet2 = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
                    }
                }
                catch (CRSException e) {
                    Trace.out("Exception during add preconnect service:" + e);
                    this.m_crsResource.remove(true);
                    throw new ServiceException((MessageKey)PrCdMsgID.CREATE_PRECONNECT_SVC_FAILED, (Throwable)e, serviceName);
                }
            }
            if (!onlyUpdate && isCluster && dbType == DatabaseType.RAC && isServiceCentric) {
                if (serviceType != ServiceType.RF) {
                    this.updateDBSrvPools(database, ServiceType.MAIN, serverGroup, false);
                }
                if (serviceType == ServiceType.PQ) {
                    this.updateDBSrvPools(database, ServiceType.PQ, serverGroup, false);
                }
                if (serviceType == ServiceType.RF) {
                    this.updateDBSrvPools(database, ServiceType.RF, serverGroup, false);
                }
            }
            if (!new SystemFactory().CreateSystem().isUnixSystem() && !Version.isPre12c(version)) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantHomeUserPermissions(database.getOracleHome(), version, true);
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException((MessageKey)PrCdMsgID.SVC_ALREADY_EXISTS, serviceName, e);
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), serviceName);
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), serviceName);
        }
        catch (NetworkException e) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), serviceName);
        }
        catch (ServerGroupException e) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), serviceName);
        }
    }

    ServiceImpl(String resourceName, SnapshotImpl snapshot) throws ServiceException {
        this.m_nameAttr = new ResourceAttribute(ResourceType.Database.NAME.name(), resourceName);
        this.m_name = resourceName;
        this.m_version = snapshot.getResourceVersion(resourceName);
        this.m_displayName = snapshot.getServiceName(resourceName);
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getSnapshotResource(this.m_nameAttr, snapshot);
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    ServiceImpl(String resourceName, EntityOperations.EntityOpsMode mode) throws ServiceException {
        this.m_name = resourceName;
        this.m_nameAttr = new ResourceAttribute(ResourceType.Service.NAME.name(), resourceName);
        this.m_version = new Version();
        this.m_displayName = this.getUserAssignedSvcName(resourceName);
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getResource(this.m_nameAttr, mode);
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    private String getUserAssignedSvcName(String resourceName) throws ServiceException {
        String[] value = resourceName.split(Pattern.quote(String.valueOf('.')));
        if (value.length < 4 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.SVC.toString().equalsIgnoreCase(value[value.length - 1])) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Service.NAME.name(), resourceName);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < value.length - 1; ++i) {
            if (sb.length() > 0) {
                sb.append('.' + value[i]);
                continue;
            }
            sb.append(value[i]);
        }
        return sb.toString();
    }

    private List<ResourceAttribute> createServiceAttr(List<ResourceAttribute> attrList, String serviceName, String dbUniqueName, int netNum, ServiceTAF tafPolicy, String serverGroupName, boolean disconnect, boolean isCreatePreconnectSrv, DBRole[] roles, Version version, Database database, ServiceCardinality cardinality, ServiceArgs args, boolean isCluster, boolean isClusterDB, DatabaseType dbType) throws CRSException, DatabaseException, ServiceException {
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        String cardValue = cardinality.toString();
        Boolean dtp = args.getDTP();
        Boolean aqhaNotification = args.getAQHANotification();
        Boolean global = args.getGlobal();
        FailoverType ft = args.getFailoverType();
        FailoverMethod fm = args.getFailoverMethod();
        FailoverRestore fr = args.getFailoverRestore();
        Integer failoverRetry = args.getFailoverRetry();
        Integer failoverDelay = args.getFailoverDelay();
        RLBGoal rg = args.getRLBGoal();
        CLBGoal cg = args.getCLBGoal();
        ManagementPolicy mgmtPolicy = args.getMgmtPolicy();
        String edition = args.getEdition();
        String pqservice = args.getPQService();
        String mainservice = args.getMainService();
        ServiceType serviceType = args.getServiceType();
        String plugDB = args.getPDB();
        String maxLagTime = args.getMaxLagTime();
        String sqltrans = args.getTranslationProfile();
        Boolean commitOutcome = args.getCommitOutcome();
        Integer retention = args.getRetention();
        Integer replayInittime = args.getReplayInitiationTime();
        SessionStateEnum sessionState = args.getSessionState();
        Integer gsmFlags = args.getGSMFlags();
        Integer drainTimeout = args.getDrainTimeout();
        Enum[] stopOptions = args.getStopOptions();
        String stopOpt = stopOptions != null ? oracle.cluster.impl.util.Utils.getEnumString(stopOptions, String.valueOf(",")) : null;
        ServiceType servType = args.getServiceType();
        ServerGroup rfpool = args.getRFPool();
        ResourceAttribute aclAttr = null;
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            aclAttr = database.createACLAttr();
            attrList.add(aclAttr);
        }
        Trace.out("Setting attribute values");
        for (ResourceAttribute attr : attrList) {
            String attrName = attr.getName();
            Trace.out("Attribute value for attribute " + attrName + " is " + attr.getValue());
            if (attrName.equalsIgnoreCase(ResourceType.Service.NAME.name())) {
                attr.setValue(ServiceImpl.getResourceName(dbUniqueName, serviceName, isCreatePreconnectSrv));
                continue;
            }
            if (attr.getName().equalsIgnoreCase(ResourceType.Service.ACTIONS.name())) {
                Trace.out("Create action attr for Service " + this.m_nameAttr.getValue());
                if (aclAttr != null) {
                    attr.setValue(Common.createActionsAttr(aclAttr.getValue(), ResourceType.Service.NAME.toString(), this.m_nameAttr.getValue()));
                } else {
                    attr.setValue(Common.createActionsAttr(null, ResourceType.Service.NAME.toString(), this.m_nameAttr.getValue()));
                }
                Trace.out("Created ACTIONS attribute");
                continue;
            }
            if (attr.getName().equalsIgnoreCase(ResourceType.Service.SERVICE_NAME.name())) {
                if (!isCreatePreconnectSrv) {
                    attr.setValue(serviceName);
                    continue;
                }
                attr.setValue(ServiceImpl.getPreconnectServiceName(serviceName));
                continue;
            }
            if (attr.getName().equalsIgnoreCase(ResourceType.Service.DESCRIPTION.name())) {
                attr.setValue(ResourceLiterals.SVC_RES_DESC.toString());
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.USR_ORA_DISCONNECT.name())) {
                attr.setValue(Boolean.valueOf(disconnect).toString().toLowerCase());
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.DEFAULT_TEMPLATE.name())) {
                attr.setValue(ServiceImpl.getServiceEvtValue(dbUniqueName));
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.RESTART_ATTEMPTS.name()) && isCluster && !isClusterDB) {
                attr.setValue(ResourceType.Database.RESTART_ATTEMPTS.toString());
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.SERVER_POOLS.name()) && isCluster && database.getSIDBType() != SIDBType.FIXED) {
                if (serverGroupName == null) continue;
                attr.setValue(serverGroupName);
                continue;
            }
            if (pqservice != null && attrName.equalsIgnoreCase(ResourceType.Service.SERVICE_NAME_PQ.name())) {
                attr.setValue(pqservice);
                continue;
            }
            if (serviceType != null && attrName.equalsIgnoreCase(ResourceType.Service.SERVICE_TYPE.name())) {
                attr.setValue(serviceType.toString());
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.TAF_POLICY.name())) {
                attr.setValue(tafPolicy.toString());
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.MANAGEMENT_POLICY.name())) {
                attr.setValue(mgmtPolicy.toString());
                continue;
            }
            if (roles != null && attrName.equalsIgnoreCase(ResourceType.Service.ROLE.name())) {
                attr.setValue(DBRole.toString(roles));
                continue;
            }
            if (dtp != null && attrName.equalsIgnoreCase(ResourceType.Service.DTP.name())) {
                attr.setValue(dtp != false ? "1" : "0");
                continue;
            }
            if (rfpool != null && attrName.equalsIgnoreCase(ResourceType.Service.RF_SERVICE.name())) {
                attr.setValue("1");
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.AQ_HA_NOTIFICATION.name())) {
                if (Cluster.isCluster() && ft != null && ft.toString().equalsIgnoreCase("TRANSACTION")) {
                    if (aqhaNotification == null) {
                        attr.setValue("1");
                    } else if (aqhaNotification != null && !aqhaNotification.booleanValue()) {
                        throw new ServiceException((MessageKey)PrCdMsgID.AQHA_FALSE_FOTYPE_TRANS, new Object[0]);
                    }
                }
                if (aqhaNotification == null) continue;
                attr.setValue(aqhaNotification != false ? "1" : "0");
                continue;
            }
            if (global != null && attrName.equalsIgnoreCase(ResourceType.Service.GLOBAL.name())) {
                attr.setValue(Boolean.toString(global));
                continue;
            }
            if (commitOutcome != null && attrName.equalsIgnoreCase(ResourceType.Service.COMMIT_OUTCOME.name())) {
                attr.setValue(commitOutcome != false ? "1" : "0");
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.FAILOVER_TYPE.name())) {
                if (ft != null) {
                    if (ft.toString().equalsIgnoreCase("TRANSACTION")) {
                        if (commitOutcome != null && commitOutcome.booleanValue()) {
                            attr.setValue(ft.toString());
                            continue;
                        }
                        throw new ServiceException((MessageKey)PrCdMsgID.ADD_MODIFY_FAILOVER_TYPE_NOT_ALLOWED, new Object[0]);
                    }
                    attr.setValue(ft.toString());
                    continue;
                }
                attr.setValue("");
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.FAILOVER_METHOD.name())) {
                attr.setValue(fm != null ? fm.toString() : "");
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.FAILOVER_RETRIES.name())) {
                attr.setValue(failoverRetry != null ? failoverRetry.toString() : "");
                continue;
            }
            if (fr != null && attrName.equalsIgnoreCase(ResourceType.Service.FAILOVER_RESTORE.name())) {
                attr.setValue(fr.toString());
                continue;
            }
            if (failoverDelay != null && attrName.equalsIgnoreCase(ResourceType.Service.TAF_FAILOVER_DELAY.name())) {
                attr.setValue(failoverDelay.toString());
                continue;
            }
            if (edition != null && attrName.equalsIgnoreCase(ResourceType.Service.EDITION.name())) {
                attr.setValue(edition);
                continue;
            }
            if (plugDB != null && attrName.equalsIgnoreCase(ResourceType.Service.PLUGGABLE_DATABASE.name())) {
                ServiceImpl.validatePDB(plugDB);
                this.validateServiceName(serviceName, plugDB, database.getDomain(), true);
                attr.setValue(plugDB);
                continue;
            }
            if (maxLagTime != null && attrName.equalsIgnoreCase(ResourceType.Service.MAX_LAG_TIME.name())) {
                attr.setValue(maxLagTime);
                continue;
            }
            if (sqltrans != null && attrName.equalsIgnoreCase(ResourceType.Service.SQL_TRANSLATION_PROFILE.name())) {
                attr.setValue(sqltrans);
                continue;
            }
            if (retention != null && serviceType != ServiceType.PQ && attrName.equalsIgnoreCase(ResourceType.Service.RETENTION.name())) {
                if (retention > 2592000) {
                    throw new ServiceException((MessageKey)PrCdMsgID.INVALID_RETENTION_VALUE, retention, 2592000);
                }
                if (commitOutcome != null && commitOutcome.booleanValue()) {
                    attr.setValue(retention.toString());
                    continue;
                }
                throw new ServiceException((MessageKey)PrCdMsgID.ADD_MODIFY_RETENTION_NOT_ALLOWED, new Object[0]);
            }
            if (replayInittime != null && serviceType != ServiceType.PQ && attrName.equalsIgnoreCase(ResourceType.Service.REPLAY_INITIATION_TIME.name())) {
                if (replayInittime > 86400) {
                    throw new ServiceException((MessageKey)PrCdMsgID.INVALID_REPLAY_INITIATION_TIME, replayInittime, 86400);
                }
                if (ft != null && ft.toString().equalsIgnoreCase("TRANSACTION")) {
                    attr.setValue(replayInittime.toString());
                    continue;
                }
                throw new ServiceException((MessageKey)PrCdMsgID.FAILOVER_TYPE_NOT_TRANS_REPLAY, new Object[0]);
            }
            if (serviceType != ServiceType.PQ && attrName.equalsIgnoreCase(ResourceType.Service.SESSION_STATE_CONSISTENCY.name())) {
                if (sessionState != null) {
                    if (ft != null && ft.toString().equalsIgnoreCase("TRANSACTION")) {
                        attr.setValue(sessionState.toString());
                        continue;
                    }
                    throw new ServiceException((MessageKey)PrCdMsgID.FAILOVER_TYPE_NOT_TRANS_SESSION_STATE, new Object[0]);
                }
                attr.setValue(SessionStateEnum.DYNAMIC.toString());
                continue;
            }
            if (rg != null && attrName.equalsIgnoreCase(ResourceType.Service.RLB_GOAL.name())) {
                attr.setValue(rg.toString());
                continue;
            }
            if (cg != null && attrName.equalsIgnoreCase(ResourceType.Service.CLB_GOAL.name())) {
                attr.setValue(cg.toString());
                continue;
            }
            if (gsmFlags != null && gsmFlags != -1 && attrName.equalsIgnoreCase(ResourceType.Service.GSM_FLAGS.name())) {
                if (global != null && global.booleanValue()) {
                    attr.setValue(gsmFlags.toString());
                    continue;
                }
                throw new ServiceException((MessageKey)PrCdMsgID.NON_GLOBAL_SERVICE, serviceName);
            }
            if (servType != ServiceType.PQ && drainTimeout != null && drainTimeout > -1 && attrName.equalsIgnoreCase(ResourceType.Service.DRAIN_TIMEOUT.name())) {
                Common.checkDrainStopOpt(drainTimeout, stopOpt);
                attr.setValue(drainTimeout.toString());
                continue;
            }
            if (attrName.equalsIgnoreCase(ResourceType.Service.STOP_OPTION.name())) {
                if (stopOpt == null) continue;
                attr.setValue(stopOpt);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ResourceType.Service.CHECK_INTERVAL.name())) continue;
            attr.setValue("0");
        }
        if (mgmtPolicy.toString().equals(ManagementPolicy.MANUAL.toString())) {
            attrList.add(crsFactory.create(ResourceType.LocalResource.AUTO_START.name(), CRSResource.AutoStart.NEVER.toString()));
        } else if (mgmtPolicy.toString().equals(ManagementPolicy.AUTOMATIC.toString())) {
            attrList.add(crsFactory.create(ResourceType.LocalResource.AUTO_START.name(), CRSResource.AutoStart.RESTORE.toString()));
        }
        Trace.out("Adding version");
        attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
        if (!isCluster) {
            attrList.add(crsFactory.create(ResourceType.ClusterResource.PLACEMENT.name(), "balanced"));
        }
        if (serviceType == ServiceType.PQ && mainservice == null) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "service-error-01");
        }
        attrList.addAll(this.createStartStopDep(serviceName, mainservice, database, serviceType, cardinality, isCreatePreconnectSrv, mgmtPolicy, netNum, version, attrList));
        if (dbType == DatabaseType.RACOneNode || dbType == DatabaseType.SIDB) {
            attrList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), String.valueOf(1)));
        } else {
            attrList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), cardValue));
        }
        if (database.getSIDBType() == SIDBType.FIXED) {
            String nodeName = "";
            try {
                nodeName = ((SingleInstanceDatabase)database).getNode().getName();
            }
            catch (NodeException e) {
                throw new DatabaseException(e);
            }
            attrList.add(crsFactory.create(ResourceType.ClusterVIP.HOSTING_MEMBERS.name(), nodeName));
            Trace.out("Setting HOSTING_MEMBERS = " + nodeName);
        }
        attrList.add(crsFactory.create(ResourceType.Service.RELOCATE_KIND.name(), ResourceLiterals.RELOCATE_KIND_ONLINE.toString()));
        return attrList;
    }

    List<ResourceAttribute> createStartStopDep(String svcName, String mainSvc, Database database, ServiceType svcType, ServiceCardinality cardinality, boolean isCreatePreconnectSvc, ManagementPolicy mgmtPolicy, int netNum, Version version, List<ResourceAttribute> attrList) throws ServiceException {
        String depHint;
        String dep;
        RTENativeResult result;
        String template;
        CRSFactoryImpl crsFactory;
        Trace.out("generating values for START and STOP dependencies ...");
        String dbName = database.getUserAssignedName();
        String dbResName = database.getName();
        String svcResName = ServiceImpl.getResourceName(dbName, svcName, !isCreatePreconnectSvc);
        ArrayList<ResourceAttribute> retval = new ArrayList<ResourceAttribute>();
        HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
        HashMap<String, String> condMap = new HashMap<String, String>();
        try {
            argMap.put("mainService", new RTEArg("mainService", RTEArg.RTEArgType.Res, mainSvc != null && !mainSvc.trim().isEmpty() ? ServiceImpl.getResourceName(dbName, mainSvc, false) : ""));
            argMap.put("service", new RTEArg("service", RTEArg.RTEArgType.Res, svcResName));
            argMap.put("cluster_vip_net", new RTEArg("cluster_vip_net", RTEArg.RTEArgType.ResList, netNum != -1 ? ResourceType.ClusterVIP.getVIPNetTypeName(netNum) : ""));
            argMap.put("database", new RTEArg("database", RTEArg.RTEArgType.Res, dbResName));
        }
        catch (RTENativeException e) {
            Trace.out((Object)"failed to create RTEArg due to RTENativeException : %s", e.getMessage());
            throw new ServiceException(e);
        }
        Trace.out((Object)"arguments : ", ((Object)argMap).toString());
        try {
            condMap.put("SERVICE_TYPE", svcType.toString());
            condMap.put("isCluster", Cluster.isCluster() ? "True" : "False");
            condMap.put("isCreatePreconnectSrv", isCreatePreconnectSvc ? "True" : "False");
            condMap.put("SERVICE_CARDINALITY", cardinality == ServiceCardinality.SINGLETON ? "1" : "0");
            condMap.put("UPDATE_SERVICE_TYPE", "False");
            condMap.put("UPDATE_VIP_TYPE", "False");
            condMap.put("MANAGEMENT_POLICY", mgmtPolicy.toString());
            condMap.put("DB_MANAGEMENT_POLICY", database.getMgmtPolicy().toString());
            condMap.put("NET_NUM", String.valueOf(netNum));
            condMap.put("ADD_PULLUP_ALWAYS_DB", "False");
            condMap.put("ADD_PULLUP_ALWAYS_SVC", "False");
            Trace.out((Object)"conditions : ", ((Object)condMap).toString());
        }
        catch (DatabaseException e) {
            Trace.out("failed to create conditions due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
        try {
            crsFactory = CRSFactoryImpl.getInstance();
            template = ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString();
            result = crsFactory.rteEvalAttrValue(template, argMap, version.toString(), condMap, svcResName);
            dep = result.getAttrValue();
            depHint = result.getAttrValueHint();
            String[] deps = this.updatePullupRTE(attrList, database, isCreatePreconnectSvc, dep, depHint);
            Trace.out((Object)"START_DEPENDENCIES : %s", deps[0]);
            Trace.out((Object)"START_DEPENDENCIES_RTE_INTERNAL : %s", deps[1]);
            retval.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), deps[0]));
            retval.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), deps[1]));
        }
        catch (CRSException e) {
            Trace.out("failed to create START_DEP attributes due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
        try {
            crsFactory = CRSFactoryImpl.getInstance();
            template = ResourceType.Service.STOP_DEPENDENCIES_TEMPLATE.toString();
            result = crsFactory.rteEvalAttrValue(template, argMap, version.toString(), condMap, svcResName);
            dep = result.getAttrValue();
            depHint = result.getAttrValueHint();
            Trace.out((Object)"STOP_DEPENDENCIES : %s", dep);
            Trace.out((Object)"STOP_DEPENDENCIES_RTE_INTERNAL : %s", depHint);
            retval.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), dep));
            retval.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), depHint));
        }
        catch (CRSException e) {
            Trace.out("failed to create STOP_DEP attributes due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
        return retval;
    }

    private void updateDBSrvPools(Database database, ServiceType serviceType, ServerGroup serverGroup, boolean remove) throws ServerGroupException {
        List<ServerGroup> sgList = null;
        boolean listChanged = false;
        sgList = serviceType == ServiceType.PQ ? database.getPQPools() : (serviceType == ServiceType.RF ? database.getRFPools() : database.serverGroups());
        if (sgList.contains(serverGroup)) {
            if (remove) {
                Trace.out("Remove " + serverGroup.getUserAssignedName() + " from srv pool list");
                sgList.remove(serverGroup);
                listChanged = true;
            }
        } else if (!remove) {
            Trace.out("Add " + serverGroup.getUserAssignedName() + " to srv pool list");
            sgList.add(serverGroup);
            listChanged = true;
        }
        if (listChanged) {
            Trace.out("Commit changes in srv pool list");
            if (serviceType == ServiceType.PQ) {
                database.setPQPools(sgList);
            } else if (serviceType == ServiceType.RF) {
                database.setRFPools(sgList);
            } else {
                database.setServerGroups(sgList, false, true);
            }
        }
    }

    private void removeOldRFPool(Database db, ServerGroup oldRFPool) throws ServiceException {
        try {
            List<String> services = oldRFPool.serviceNames(db.getUserAssignedName());
            if (services.contains(this.getName())) {
                Trace.out("Current service is in old rf pool");
                services.remove(this.getName());
            }
            if (services.size() == 0) {
                Trace.out("Removing old reader farm pool configuration from DB");
                this.updateDBSrvPools(db, ServiceType.RF, oldRFPool, true);
            } else {
                Trace.out("Other services are members of reader farm pool, do not remove from DB");
            }
        }
        catch (ServerGroupException sge) {
            throw new ServiceException(sge);
        }
    }

    @Override
    public boolean isCardinal() throws ServiceException {
        boolean isCard = false;
        Database db = this.database();
        try {
            String version;
            if (db.isClusterDatabase() && !Version.isPre11i(Version.getVersion(version = this.m_crsResource.getAttribute(ResourceType.LocalResource.VERSION.name()).getValue()))) {
                isCard = true;
            }
        }
        catch (ConfigurationException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.IS_SVC_CARDINAL_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.IS_SVC_CARDINAL_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.IS_SVC_CARDINAL_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        return isCard;
    }

    @Override
    public boolean isGlobal() throws ServiceException {
        boolean isGlob = false;
        Database db = this.database();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Service.GLOBAL.name());
            if (attr.getValue().equalsIgnoreCase("true") || attr.getValue().equals("1")) {
                isGlob = true;
            }
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.IS_SVC_CARDINAL_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        return isGlob;
    }

    public boolean isCommitSet() throws ServiceException {
        boolean isCommit = false;
        Database db = this.database();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Service.COMMIT_OUTCOME.name());
            Trace.out("In isCommitSet():Got the CRS attribute, commmit outcome = " + attr.getValue());
            if (attr.getValue().equals("1")) {
                isCommit = true;
            }
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_COMMIT_OUTCOME_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        return isCommit;
    }

    public boolean isFailoverTransactional() throws ServiceException {
        boolean isTrans = false;
        Database db = this.database();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Service.FAILOVER_TYPE.name());
            if (attr.getValue().equalsIgnoreCase("TRANSACTION")) {
                isTrans = true;
            }
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_FAILOVER_TYPE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        return isTrans;
    }

    @Override
    public boolean isRFService() throws ServiceException {
        boolean isRF = false;
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Service.RF_SERVICE.name());
            if (attr.getValue().equalsIgnoreCase("1")) {
                isRF = true;
            }
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        return isRF;
    }

    @Override
    public Database database() throws ServiceException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Service.NAME.name());
            String value = attr.getValue().trim();
            Trace.out("service name =" + value);
            if (value.length() > 0) {
                int index1 = value.indexOf(46);
                if (index1 < 0) {
                    throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_DB_FAILED, this.getUserAssignedName());
                }
                String value1 = value.substring(index1 + 1);
                int index2 = value1.indexOf(".");
                if (index2 < 0) {
                    throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_DB_FAILED, this.getUserAssignedName());
                }
                String dbUniqueName = value1.substring(0, index2);
                Trace.out("dbUniqueName = " + dbUniqueName);
                return this.m_crsResource.getDatabase(dbUniqueName);
            }
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_DB_FAILED, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public List<DatabaseInstance> getProviderInstances() throws ServiceException {
        try {
            return this.database().instances();
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_PROVIDER_INST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        this.start(false);
    }

    @Override
    public void start(boolean global) throws AlreadyRunningException, SoftwareModuleException {
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            this.startHelper(null, args);
        }
        catch (CompositeOperationException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public void start(StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        this.start(startupOptions, false);
    }

    @Override
    public void start(StartOptions[] startupOptions, boolean global) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        ServiceArgs args = new ServiceArgs();
        args.setStartOptions(startupOptions);
        args.setGlobal(global);
        this.startHelper(null, args);
    }

    @Override
    public void start(List<DatabaseInstance> instances, StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        this.start(instances, startupOptions, false);
    }

    @Override
    public void start(List<DatabaseInstance> instances, StartOptions[] startupOptions, boolean global) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        ServiceArgs args = new ServiceArgs();
        args.setStartOptions(startupOptions);
        args.setGlobal(global);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (DatabaseInstance ins : instances) {
            try {
                nodes.add(ins.node());
            }
            catch (InstanceException e) {
                throw new ServiceException((MessageKey)PrCdMsgID.SERV_START_FAILED, (Throwable)e, this.getUserAssignedName());
            }
        }
        this.startHelper(nodes, args);
    }

    @Override
    public void start(ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        this.startHelper(null, args);
    }

    @Override
    public void start(List<DatabaseInstance> instances, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (DatabaseInstance ins : instances) {
            try {
                nodes.add(ins.node());
            }
            catch (InstanceException e) {
                throw new ServiceException((MessageKey)PrCdMsgID.SERV_START_FAILED, (Throwable)e, this.getUserAssignedName());
            }
        }
        try {
            args.setForceFlag(this.database().databaseType() == DatabaseType.RAC);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
        this.startHelper(nodes, args);
    }

    protected void startHelper(List<Node> nodeList, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        Boolean globalVal = null;
        Boolean forceVal = null;
        Enum[] startupOptions = null;
        if (args != null) {
            forceVal = args.getForceFlag();
            globalVal = args.getGlobal();
            startupOptions = args.getStartOptions();
        }
        boolean global = globalVal != null ? globalVal : false;
        boolean forceFlag = forceVal != null ? forceVal : false;
        try {
            if (this.isGlobal() && !global) {
                throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
            }
            ResourceAttribute[] options = null;
            if (startupOptions != null && startupOptions.length > 0) {
                Database db = this.database();
                if (!db.isRunning()) {
                    boolean badOptionFound = false;
                    StringBuilder badOpt = new StringBuilder();
                    for (Enum opt : startupOptions) {
                        if (((StartOptions)opt).isValidForService()) continue;
                        if (badOptionFound) {
                            badOpt.append(',');
                        }
                        badOpt.append(((StartOptions)opt).toString());
                        badOptionFound = true;
                    }
                    if (badOptionFound) {
                        throw new ServiceException((MessageKey)PrCdMsgID.SERV_BAD_STARTOPT, this.getUserAssignedName(), db.getUserAssignedName(), badOpt.toString());
                    }
                }
                options = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(startupOptions, String.valueOf(" ")))};
            }
            CRSResourceImpl crsResImpl = this.m_crsResource;
            if (nodeList == null && options == null) {
                crsResImpl.start(forceFlag);
            } else if (nodeList != null && options != null) {
                crsResImpl.start(forceFlag, nodeList, options);
            } else if (nodeList == null) {
                crsResImpl.start(forceFlag, options);
            } else {
                crsResImpl.start(forceFlag, nodeList);
            }
        }
        catch (AlreadyRunningException e) {
            throw new AlreadyRunningException((MessageKey)PrCcMsgID.ALREADY_RUNNING, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_START_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_START_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void stop(List<DatabaseInstance> instances, StopOptions[] stopOptions, boolean disconnect) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        this.stop(instances, stopOptions, disconnect, false);
    }

    @Override
    public void stop(List<DatabaseInstance> instances, StopOptions[] stopOptions, boolean disconnect, boolean noreplay) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (DatabaseInstance ins : instances) {
            try {
                nodes.add(ins.node());
                this.stopHelper(nodes, stopOptions, disconnect, false, noreplay);
            }
            catch (InstanceException e) {
                throw new ServiceException((MessageKey)PrCdMsgID.SERV_START_FAILED, (Throwable)e, this.getUserAssignedName());
            }
        }
    }

    @Override
    public void stop(StopOptions[] stopOptions, boolean disconnect) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        this.stop(stopOptions, disconnect, false);
    }

    @Override
    public void stop(StopOptions[] stopOptions, boolean disconnect, boolean global) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        this.stop(null, stopOptions, disconnect, global, false);
    }

    @Override
    public void stop(StopOptions[] stopOptions, boolean disconnect, boolean global, boolean noreplay) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        this.stop(null, stopOptions, disconnect, global, noreplay);
    }

    @Override
    public void stop(List<DatabaseInstance> instances, StopOptions[] stopOptions, boolean disconnect, boolean noreplay, boolean global) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        ServiceArgs args = new ServiceArgs();
        if (stopOptions != null) {
            args.setStopOptions(stopOptions);
        }
        args.setDisconnectOpt(disconnect);
        args.setGlobal(global);
        args.setNoreplay(noreplay);
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (instances != null) {
            for (DatabaseInstance ins : instances) {
                try {
                    nodes.add(ins.node());
                }
                catch (InstanceException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.SERV_STOP_FAILED, (Throwable)e, this.getUserAssignedName());
                }
            }
        }
        this.stopHelper2(nodes, args);
    }

    public void stop(List<DatabaseInstance> instances, ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (instances != null) {
            for (DatabaseInstance ins : instances) {
                try {
                    nodes.add(ins.node());
                }
                catch (InstanceException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.SERV_STOP_FAILED, (Throwable)e, this.getUserAssignedName());
                }
            }
        }
        this.stopHelper2(nodes, args);
    }

    protected void stopHelper(List<Node> nodes, StopOptions[] stopOptions, boolean disconnect, boolean noreplay, boolean global) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        ServiceArgs args = new ServiceArgs();
        if (stopOptions != null) {
            args.setStopOptions(stopOptions);
        }
        args.setDisconnectOpt(disconnect);
        args.setGlobal(global);
        args.setNoreplay(noreplay);
        this.stopHelper2(nodes, args);
    }

    protected void stopHelper2(List<Node> nodes, ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        ResourceAttribute[] options = null;
        Boolean disconnect = args.getDisconnectOpt();
        Boolean noreplay = args.getNoreplay();
        Boolean global = args.getGlobal();
        boolean wait = false;
        Boolean waitFlag = args.getWait();
        if (waitFlag != null) {
            wait = waitFlag;
        }
        args.getWait();
        Enum[] stopOptions = args.getStopOptions();
        Integer drainTimeout = args.getDrainTimeout();
        try {
            boolean keepDepTgt;
            String drainStr;
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            if (this.isGlobal() && !global.booleanValue()) {
                throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
            }
            if (noreplay.booleanValue() && !disconnect.booleanValue()) {
                throw new ServiceException((MessageKey)PrCdMsgID.NOREPLAY_NOT_ALLOWED, this.getUserAssignedName());
            }
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            if (disconnect != null) {
                attrList.add(cf.create(ResourceType.Service.USR_ORA_DISCONNECT.name(), disconnect.toString()));
            }
            if (noreplay != null) {
                attrList.add(cf.create(ResourceType.Service.SESSION_NOREPLAY.name(), noreplay.toString()));
            }
            if (stopOptions != null && stopOptions.length > 0) {
                String drainStr2;
                String stopOpt = oracle.cluster.impl.util.Utils.getEnumString(stopOptions, String.valueOf(" "));
                Integer drainTime = null;
                drainTime = drainTimeout != null ? drainTimeout : ((drainStr2 = this.getDrainTimeout()) != null && drainStr2.length() != 0 ? Integer.valueOf(Integer.parseInt(drainStr2)) : null);
                Common.checkDrainStopOpt(drainTime, stopOpt);
                attrList.add(cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), stopOpt));
            }
            int waitTime = 0;
            if (drainTimeout != null) {
                Common.checkDrainStopOpt(drainTimeout, this.getStopOption());
                drainStr = drainTimeout > -1 ? drainTimeout.toString() : "";
                attrList.add(cf.create(ResourceType.Service.DRAIN_TIMEOUT.name(), drainStr));
                waitTime = drainTimeout == -1 ? 0 : drainTimeout;
            } else {
                drainStr = this.getDrainTimeout();
                if (!drainStr.trim().isEmpty()) {
                    waitTime = Integer.parseInt(drainStr);
                }
            }
            String drainID = null;
            if (wait) {
                drainID = Common.getDrainID();
                attrList.add(cf.create(ResourceType.Service.DRAIN_ID.name(), drainID));
            }
            options = attrList.toArray(new ResourceAttribute[attrList.size()]);
            boolean bl = keepDepTgt = this.getTAF() != ServiceTAF.PRECONNECT;
            if (nodes == null && options == null) {
                if (!keepDepTgt) {
                    this.m_crsResource.stop(true, keepDepTgt);
                } else {
                    this.m_crsResource.stop(false);
                }
            } else if (nodes == null) {
                if (!keepDepTgt) {
                    this.m_crsResource.stop(true, keepDepTgt, options);
                } else {
                    this.m_crsResource.stop(false, options);
                }
            } else {
                this.m_crsResource.stop(nodes, false, options);
            }
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_STOP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public String getMainService() throws ServiceException {
        String mainSvc = "";
        try {
            String[] depNames;
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            Version resVer = this.version();
            boolean isPre12201 = Version.isPre122(resVer);
            Trace.out("Is resource version %s pre-12.2.0.1? %b", resVer.toString(), isPre12201);
            for (String res : depNames = ResourceDependency.getResourceNames(attr, isPre12201 ? ResourceDependency.DepType.WEAK_DEP : ResourceDependency.DepType.HARD_DEP)) {
                if (!res.endsWith(ResourceLiterals.SVC.toString())) continue;
                mainSvc = this.getUserAssignedSvcName(res);
            }
            return mainSvc;
        }
        catch (CRSException | NoVersionAvailableException e) {
            Trace.out("failed to retrieve main service due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("failed to retrieve main service due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
    }

    @Override
    public String getPQService() throws ServiceException {
        try {
            String pqsvc = this.m_crsResource.getAttribute(ResourceType.Service.SERVICE_NAME_PQ.name()).getValue();
            return pqsvc;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_PQ_SERVICE_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setPQService(String pqservice) throws ServiceException {
        String pqsvc = pqservice == null ? "" : pqservice;
        try {
            Trace.out("Input pqservice " + pqservice + ", set pq service " + pqsvc);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Service.SERVICE_NAME_PQ.name(), pqsvc));
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SET_PQ_SERVICE_FAILED, (Throwable)e, pqsvc, this.getUserAssignedName());
        }
    }

    @Override
    public ServerGroup getServerGroup() throws ServiceException {
        String serverGroupStr = "";
        try {
            serverGroupStr = this.m_crsResource.getAttribute(ResourceType.Service.SERVER_POOLS.name()).getValue();
            return ServerFactoryImpl.getInstance().getServerGroup(serverGroupStr);
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
        catch (ServerException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ServiceType getServiceType() throws ServiceException {
        String serviceTypeStr = "";
        try {
            serviceTypeStr = this.m_crsResource.getAttribute(ResourceType.Service.SERVICE_TYPE.name()).getValue();
            return ServiceType.getEnumMember(serviceTypeStr);
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_TYPE_FAILED, (Throwable)e, serviceTypeStr, this.m_name);
        }
    }

    @Override
    public void setServiceType(ServiceType serviceType) throws ServiceException {
        if (serviceType == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceType", serviceType.toString());
        }
        String serviceTypeStr = serviceType.toString();
        try {
            Trace.out("Set service type " + serviceTypeStr);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Service.SERVICE_TYPE.name(), serviceTypeStr));
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SET_SERVICE_TYPE_FAILED, (Throwable)e, serviceTypeStr, this.getUserAssignedName());
        }
    }

    @Override
    public String getEdition() throws ServiceException {
        try {
            String edition = this.m_crsResource.getAttribute(ResourceType.Service.EDITION.name()).getValue();
            return edition;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_EDITION_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public String getMaxLagTime() throws ServiceException {
        try {
            String maxLagTime = this.m_crsResource.getAttribute(ResourceType.Service.MAX_LAG_TIME.name()).getValue();
            Trace.out("maxLagTime is " + maxLagTime);
            return maxLagTime;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_MAX_LAG_TIME_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public String getPDB() throws ServiceException {
        try {
            String plugDB = this.m_crsResource.getAttribute(ResourceType.Service.PLUGGABLE_DATABASE.name()).getValue();
            Trace.out("ServiceImpl.getPDB:pdb is " + plugDB);
            return plugDB;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_PLUGGABLE_DATABASE_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public String getTranslationProfile() throws ServiceException {
        try {
            String sqltrans = this.m_crsResource.getAttribute(ResourceType.Service.SQL_TRANSLATION_PROFILE.name()).getValue();
            Trace.out("ServiceImpl.getTranslationProfile:sqltrans is " + sqltrans);
            return sqltrans;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SQL_TRANSLATION_PROFILE_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public ServiceTAF getTAF() throws ServiceException {
        try {
            String taf = this.m_crsResource.getAttribute(ResourceType.Service.TAF_POLICY.name()).getValue();
            return ServiceTAF.getEnumMember(taf);
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_TAF_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setTAF(ServiceTAF newTAF) throws ServiceException {
        if (newTAF == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"newTAF", newTAF});
        }
        try {
            DatabaseImpl database = (DatabaseImpl)this.database();
            boolean isAdminMgd = database.isDBCentric();
            DatabaseType dbType = database.databaseType();
            if (!(ServiceTAF.PRECONNECT != newTAF || isAdminMgd && dbType == DatabaseType.RAC)) {
                throw new ServiceException((MessageKey)PrCdMsgID.INVALID_SERVICE_TAF, newTAF.toString());
            }
            ServiceTAF oldTAF = null;
            boolean oldTAFPresent = true;
            try {
                oldTAF = this.getTAF();
            }
            catch (ServiceException e) {
                oldTAFPresent = false;
            }
            if (oldTAFPresent && oldTAF == newTAF) {
                return;
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            this.m_crsResource.update(crsFactory.create(ResourceType.Service.TAF_POLICY.name(), newTAF.toString()));
            if (ServiceTAF.PRECONNECT == oldTAF && ServiceTAF.PRECONNECT != newTAF) {
                Trace.out("removing preconnect service");
                this.removePreconnect(true);
            } else if (ServiceTAF.PRECONNECT != oldTAF && ServiceTAF.PRECONNECT == newTAF) {
                ServiceArgs serviceArgs = this.getArgs();
                ResourceAttribute svcTypeAttr = crsFactory.create(ResourceType.Service.NAME.name(), ResourceType.Service.NAME.toString());
                List<ResourceAttribute> attrList = ResourceType.getProfile(crsFactory.getResourceTypeEntity(svcTypeAttr).getAttributes(new String[0]));
                attrList = this.createServiceAttr(attrList, this.getUserAssignedName(), database.getUserAssignedName(), NodeAppsFactoryImpl.getInstance().getNetwork(this.m_crsResource).getNumber(), newTAF, serviceArgs.getServerGroup().getName(), serviceArgs.getDisconnectOpt(), true, serviceArgs.getRoles(), database.version(), database, ServiceCardinality.SINGLETON, serviceArgs, true, true, dbType);
                crsFactory.create(CRSEntity.Type.Resource, attrList);
            }
        }
        catch (NetworkException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_PRECONNECT_SVC_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NoVersionAvailableException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_PRECONNECT_SVC_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (AlreadyExistsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_PRECONNECT_SVC_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (AlreadyRunningException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SET_SERVICE_TAF_FAILED, (Throwable)e, newTAF.toString(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SET_SERVICE_TAF_FAILED, (Throwable)e, newTAF.toString(), this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SET_SERVICE_TAF_FAILED, (Throwable)e, newTAF.toString(), this.getUserAssignedName());
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, ServiceException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException(e);
        }
    }

    private void removePreconnect(boolean force) throws AlreadyRunningException, ServiceException {
        try {
            CRSFactoryImpl fac = CRSFactoryImpl.getInstance();
            String dbUniqueName = this.database().getUserAssignedName();
            ResourceAttribute preAttr = fac.create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, this.getUserAssignedName(), true));
            fac.get(preAttr).remove(force);
        }
        catch (NotExistsException e) {
            Trace.out("IGNORE:" + e.getMessage());
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ServiceException {
        this.remove(force, false);
    }

    @Override
    public void remove(boolean force, boolean global) throws AlreadyRunningException, ServiceException {
        Database db = null;
        try {
            db = this.database();
            db.checkOracleUser();
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.REMOVE_SERVICE_NOT_AUTHORIZED, (Throwable)e, this.m_displayName, db.getUserAssignedName());
        }
        if (this.isRFService()) {
            try {
                ServerGroup rf = this.serverGroup();
                super.remove(force);
                this.removeOldRFPool(db, rf);
            }
            catch (SoftwareModuleException sme) {
                throw new ServiceException((MessageKey)PrCdMsgID.REMOVE_SERVICE_FAILED_SP, (Throwable)sme, this.getUserAssignedName());
            }
            catch (ServerGroupException sge) {
                throw new ServiceException((MessageKey)PrCdMsgID.REMOVE_SERVICE_FAILED_SP, (Throwable)sge, this.getUserAssignedName());
            }
        }
        if (!this.isGlobal() || global) {
            ManageableEntity sg2remove = null;
            ArrayList<ServerGroup> newSGList = null;
            ArrayList<ServerGroup> newPQList = null;
            try {
                ServiceTAF taf = this.getTAF();
                if (taf.toString().equals(ServiceTAF.PRECONNECT.toString())) {
                    this.removePreconnect(force);
                }
                try {
                    if (Cluster.isCluster() && db.getSIDBType() != SIDBType.FIXED) {
                        List<ServerGroup> groups = db.serverGroups();
                        ServerGroup sg = this.serverGroup();
                        if (groups.size() == 1 && !groups.get(0).isServerPool()) {
                            if (db.databaseType() == DatabaseType.RAC) {
                                sg2remove = sg;
                            }
                        } else if (sg.serviceNames(db.getUserAssignedName()).size() == 1) {
                            List<ServerGroup> pqList = db.getPQPools();
                            if (pqList.contains(sg)) {
                                pqList.remove(sg);
                                newPQList = new ArrayList<ServerGroup>(pqList);
                            } else if (groups.contains(sg) && groups.size() - pqList.size() >= 2) {
                                groups.remove(sg);
                                newSGList = new ArrayList<ServerGroup>(groups);
                            }
                        }
                    }
                }
                catch (ServerGroupException sge) {
                    throw new ServiceException((MessageKey)PrCdMsgID.REMOVE_SERVICE_FAILED_SP, (Throwable)sge, this.getUserAssignedName());
                }
                super.remove(force);
                try {
                    if (newPQList != null) {
                        db.setPQPools(newPQList, force);
                    } else if (newSGList != null) {
                        db.setServerGroups(newSGList, force, true);
                    }
                }
                catch (ServerGroupException sge) {
                    throw new ServiceException((MessageKey)PrCdMsgID.REMOVE_SERVICE_FAILED_SP, (Throwable)sge, this.getUserAssignedName());
                }
            }
            catch (SoftwareModuleException e) {
                throw new ServiceException(e);
            }
            Trace.out("Checking if srvctl interrupt handler is being tested");
            if (Utils.isSRVCTLInterruptTest()) {
                Trace.out("Testing interrupt handler for 'srvctl remove service'");
                Trace.enableLogging("StartSRVCTLRemoveServiceInterruptTest.trc", true);
                Trace.out("Waiting for CTRL-C ...");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (sg2remove != null) {
                ManageableEntityException ex = null;
                String sgName = sg2remove.getUserAssignedName();
                try {
                    Trace.out("Removing sp %s for service %s", sg2remove.getName(), this.getName());
                    sg2remove.remove();
                }
                catch (ServerGroupException e) {
                    ex = e;
                }
                catch (CompositeOperationException e) {
                    ex = e;
                }
                if (ex != null) {
                    throw new ServiceException((MessageKey)PrCdMsgID.REMOVE_SERVICE_FAILED_SP2, (Throwable)ex, this.getUserAssignedName(), sgName);
                }
            }
        } else {
            throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_REMOVE_NOT_ALLOWED, this.getUserAssignedName());
        }
    }

    public ServerGroup serverGroup() throws ServerGroupException {
        String sgName = "";
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Service.SERVER_POOLS.name());
            sgName = attr.getValue().trim();
            Trace.out("server group name =" + sgName);
            return ServerFactoryImpl.getInstance().getServerGroup(sgName);
        }
        catch (CRSException e) {
            throw new ServerGroupException(e);
        }
        catch (NotExistsException e) {
            throw new ServerGroupException(e);
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
    }

    public ServiceCardinality getServiceCardinality() throws ServiceException {
        try {
            ResourceAttribute spAttr = this.m_crsResource.getAttribute(ResourceType.Service.SERVER_POOLS.name());
            String spAttrVal = spAttr.getValue().trim();
            Trace.out((Object)"value of SERVER_POOLS attr : %s", spAttrVal);
            ServerGroup srvgrp = null;
            if (spAttrVal.length() > 0) {
                srvgrp = ServerFactoryImpl.getInstance().getServerGroup(spAttrVal, (CRSEntity)this.m_crsResource);
            }
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterResource.CARDINALITY.name());
            String attrVal = attr.getValue().trim();
            Trace.out((Object)"value of CARDINALITY attr : %s", attrVal);
            if (srvgrp != null) {
                Trace.out((Object)"server group : %s", srvgrp.getName());
                if (srvgrp.isServerPool()) {
                    Trace.out("policy-managed service");
                    return attrVal.equals("1") ? ServiceCardinality.SINGLETON : ServiceCardinality.UNIFORM;
                }
                ServiceCardinality card = ServiceCardinality.COUNTED;
                card.setCount(Integer.parseInt(attrVal));
                return card;
            }
            Trace.out("this is a SIHA service");
            if (attrVal.equals("1")) {
                return ServiceCardinality.SINGLETON;
            }
            Trace.out((Object)"SIHA service cannot have cardinality %d", attrVal);
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_SERVICE_CARDINALITY, attrVal);
        }
        catch (CRSException | ServerGroupException | NotExistsException e) {
            Trace.out("failed to retrieve cardinality due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
        catch (ServerException e) {
            Trace.out("failed to retrieve cardinality due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
    }

    public ManagementPolicy getManagementPolicy() throws ServiceException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Service.MANAGEMENT_POLICY.name());
            String attrVal = attr.getValue().trim();
            Trace.out((Object)"value of MANAGEMENT_POLICY attr : %s", attrVal);
            return !attrVal.isEmpty() ? ManagementPolicy.getEnumMember(attrVal) : ManagementPolicy.AUTOMATIC;
        }
        catch (CRSException | DatabaseException e) {
            Trace.out("failed to retrieve mgmt policy due to %s : %s", e.getClass().getName(), e.getMessage());
            throw new ServiceException(e);
        }
    }

    public Network getNetwork() throws ServiceException {
        try {
            return NodeAppsFactoryImpl.getInstance().getNetwork(this.m_crsResource);
        }
        catch (NetworkException ne) {
            Trace.out((Object)"failed to get network due to NE : %s", ne.getMessage());
            throw new ServiceException(ne);
        }
        catch (SoftwareModuleException e) {
            Trace.out((Object)"failed to get network due to SME : %s", e.getMessage());
            throw new ServiceException(e);
        }
    }

    public void setAutoStart(boolean autostart) throws ServiceException {
        try {
            String autoStartVal = autostart ? CRSResource.AutoStart.ALWAYS.toString() : CRSResource.AutoStart.NEVER.toString();
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ClusterResource.AUTO_START.name(), autoStartVal));
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SET_AUTO_START_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    static String getPreconnectServiceName(String serviceName) {
        String servName = serviceName;
        int index = servName.indexOf(46);
        if (index > 0) {
            servName = serviceName.substring(0, index);
            String domain = serviceName.substring(index);
            return (servName + (Object)((Object)ResourceLiterals.PRECONNECT) + domain).toLowerCase();
        }
        return (servName + (Object)((Object)ResourceLiterals.PRECONNECT)).toLowerCase();
    }

    static List<ResourceAttribute> filterOutInternalServiceNames(List<ResourceAttribute> attrList) {
        ArrayList<ResourceAttribute> result = new ArrayList<ResourceAttribute>(attrList.size());
        String precon = "" + (Object)((Object)ResourceLiterals.PRECONNECT) + '.';
        for (ResourceAttribute ra : attrList) {
            if (ra.getValue().contains(precon)) continue;
            result.add(ra);
        }
        return result;
    }

    public static String getResourceName(String dbUniqueName, String serviceName, boolean preConnect) {
        if (preConnect) {
            return "ora." + dbUniqueName.toLowerCase() + '.' + ServiceImpl.getPreconnectServiceName(serviceName) + '.' + (Object)((Object)ResourceLiterals.SVC);
        }
        return "ora." + dbUniqueName.toLowerCase() + '.' + serviceName.toLowerCase() + '.' + (Object)((Object)ResourceLiterals.SVC);
    }

    private String[] updatePullupRTE(List<ResourceAttribute> aList, Database db, boolean isPreconnect, String dep, String depHint) throws ServiceException {
        RTENativeResult result;
        String version = null;
        Map<String, RTEArg> argMap = null;
        Map<String, String> condMap = null;
        try {
            String template = ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString();
            ArrayList<String> argNameList = new ArrayList<String>();
            argNameList.add("mainService");
            argNameList.add("service");
            argNameList.add("cluster_vip_net");
            argNameList.add("database");
            result = CRSFactoryImpl.getInstance().rteGetArgList(template, argNameList, dep, depHint, version, this.m_nameAttr.getValue());
            argMap = result.getRTEArgMap();
            condMap = result.getCondMap();
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        int pullRes = this.setupPullupRTE(aList, db, isPreconnect);
        if (pullRes == 1) {
            if (!isPreconnect) {
                Trace.out("ADD_PULLUP_ALWAYS_DBTrue");
                condMap.put("ADD_PULLUP_ALWAYS_DB", "True");
            } else {
                Trace.out("ADD_PULLUP_ALWAYS_SVCTrue");
                condMap.put("ADD_PULLUP_ALWAYS_SVC", "True");
            }
        } else if (pullRes == 0) {
            if (!isPreconnect) {
                Trace.out("ADD_PULLUP_ALWAYS_DBFalse");
                condMap.put("ADD_PULLUP_ALWAYS_DB", "False");
            } else {
                Trace.out("ADD_PULLUP_ALWAYS_SVCFalse");
                condMap.put("ADD_PULLUP_ALWAYS_SVC", "False");
            }
        }
        try {
            String template = ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString();
            result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, version, condMap, this.m_nameAttr.getValue());
            String newStartDep = result.getAttrValue();
            String newStartDepHint = result.getAttrValueHint();
            return new String[]{newStartDep, newStartDepHint};
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    void handleDbChanges(Database db, ResourceType.Database attrChanged) throws ServiceException {
        switch (attrChanged) {
            case ROLE: {
                try {
                    CRSResourceImpl res = (CRSResourceImpl)this.crsResource();
                    List<ResourceAttribute> aList = res.getAttributes(ResourceType.Service.MANAGEMENT_POLICY.name(), ResourceType.Service.ROLE.name(), ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), ResourceType.Service.TAF_POLICY.name());
                    boolean isPreconnect = false;
                    for (ResourceAttribute attr : aList) {
                        if (!attr.getName().equalsIgnoreCase(ResourceType.Service.TAF_POLICY.name())) continue;
                        isPreconnect = ServiceTAF.PRECONNECT == ServiceTAF.getEnumMember(attr.getValue());
                        break;
                    }
                    String[] deps = this.updatePullupRTE(aList, db, false, aList.get(2).getValue(), aList.get(3).getValue());
                    CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                    res.update(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), deps[0]), crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), deps[1]));
                    if (!isPreconnect) break;
                    CRSFactoryImpl fac = CRSFactoryImpl.getInstance();
                    String dbUniqueName = db.getUserAssignedName();
                    ResourceAttribute preAttr = fac.create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, this.getUserAssignedName(), true));
                    res = (CRSResourceImpl)fac.get(preAttr);
                    aList = res.getAttributes(ResourceType.Service.MANAGEMENT_POLICY.name(), ResourceType.Service.ROLE.name(), ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name());
                    deps = this.updatePullupRTE(aList, db, false, aList.get(2).getValue(), aList.get(3).getValue());
                    crsFactory = CRSFactoryImpl.getInstance();
                    res.update(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), deps[0]), crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), deps[1]));
                    break;
                }
                catch (Exception e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_PULLUP_FAILED, (Throwable)e, this.getUserAssignedName(), e.getMessage());
                }
            }
            case MANAGEMENT_POLICY: {
                try {
                    CRSResourceImpl res = (CRSResourceImpl)this.crsResource();
                    ServiceCardinality curCard = this.getArgs().getServiceCardinality();
                    List<ResourceAttribute> startDeps = res.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name());
                    ResourceAttribute startDep = startDeps.get(0);
                    ResourceAttribute startDepHint = startDeps.get(1);
                    ArrayList<String> argNameList = new ArrayList<String>();
                    argNameList.add("mainService");
                    argNameList.add("service");
                    argNameList.add("cluster_vip_net");
                    argNameList.add("database");
                    String attrValue = startDep.getValue();
                    String attrValueHint = startDepHint.getValue();
                    String version = null;
                    Map<String, RTEArg> argMap = null;
                    Map<String, String> condMap = null;
                    try {
                        String template = ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString();
                        RTENativeResult result = CRSFactoryImpl.getInstance().rteGetArgList(template, argNameList, attrValue, attrValueHint, version, res.getName());
                        argMap = result.getRTEArgMap();
                        condMap = result.getCondMap();
                    }
                    catch (CRSException e) {
                        throw new ServiceException(e);
                    }
                    int netNum = NodeAppsFactoryImpl.getInstance().getNetwork(this.m_crsResource).getNumber();
                    try {
                        argMap.put("cluster_vip_net", new RTEArg("cluster_vip_net", RTEArg.RTEArgType.ResList, ResourceType.ClusterVIP.getVIPNetTypeName(netNum)));
                    }
                    catch (RTENativeException e) {
                        throw new ServiceException(e);
                    }
                    condMap.put("UPDATE_VIP_TYPE", "True");
                    condMap.put("DB_MANAGEMENT_POLICY", db.getMgmtPolicy().toString());
                    String newStartDep = null;
                    String newStartDepHint = null;
                    try {
                        String template = ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString();
                        RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, version, condMap, res.getName());
                        newStartDep = result.getAttrValue();
                        newStartDepHint = result.getAttrValueHint();
                    }
                    catch (CRSException e) {
                        throw new ServiceException(e);
                    }
                    CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                    res.update(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), newStartDep), crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), newStartDepHint));
                    break;
                }
                catch (CRSException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_PULLUP_FAILED, (Throwable)e, this.getUserAssignedName(), e.getMessage());
                }
                catch (DatabaseException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_PULLUP_FAILED, (Throwable)e, this.getUserAssignedName(), e.getMessage());
                }
                catch (NetworkException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_PULLUP_FAILED, (Throwable)e, this.getUserAssignedName(), e.getMessage());
                }
                catch (NotExistsException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_PULLUP_FAILED, (Throwable)e, this.getUserAssignedName(), e.getMessage());
                }
                catch (SoftwareModuleException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_PULLUP_FAILED, (Throwable)e, this.getUserAssignedName(), e.getMessage());
                }
            }
        }
    }

    void handleDBInstRemoved(Database db, DatabaseInstance instance) throws ServiceException {
    }

    private int setupPullupRTE(List<ResourceAttribute> aList, Database db, boolean isPreconnect) throws ServiceException {
        try {
            DBRole dbRole = db.getDBRole();
            DBRole[] srvRoles = null;
            ManagementPolicy srvMP = null;
            String aName = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            for (ResourceAttribute attr : aList) {
                aName = attr.getName();
                if (aName.equals(ResourceType.Service.MANAGEMENT_POLICY.name())) {
                    srvMP = ManagementPolicy.getEnumMember(attr.getValue());
                    continue;
                }
                if (!aName.equals(ResourceType.Service.ROLE.name())) continue;
                srvRoles = DBRole.decode(attr.getValue());
            }
            if (srvMP.toString().equals(ManagementPolicy.MANUAL.toString())) {
                return 0;
            }
            if (!srvMP.toString().equals(ManagementPolicy.AUTOMATIC.toString())) {
                return -1;
            }
            boolean stopFlag = true;
            for (DBRole dbr : srvRoles) {
                Trace.out("dbr " + dbr.name());
                if (!dbr.toString().equals(dbRole.toString())) continue;
                stopFlag = false;
                break;
            }
            if (stopFlag) {
                return 0;
            }
            return 1;
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
    }

    private boolean setupPullup(List<ResourceAttribute> aList, Database db, boolean isPreconnect) throws ServiceException {
        try {
            DBRole dbRole = db.getDBRole();
            DBRole[] srvRoles = null;
            ManagementPolicy srvMP = null;
            String aName = null;
            ResourceAttribute startDep = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute pullupTgt = !isPreconnect ? crsFactory.create(ResourceType.Database.NAME.name(), db.getName()) : crsFactory.create(ResourceType.Service.NAME.name(), this.getPreconnectPullupTarget());
            for (ResourceAttribute attr : aList) {
                aName = attr.getName();
                if (aName.equals(ResourceType.Service.MANAGEMENT_POLICY.name())) {
                    srvMP = ManagementPolicy.getEnumMember(attr.getValue());
                    continue;
                }
                if (aName.equals(ResourceType.Service.ROLE.name())) {
                    srvRoles = DBRole.decode(attr.getValue());
                    continue;
                }
                if (!aName.equals(ResourceType.LocalResource.START_DEPENDENCIES.name())) continue;
                startDep = attr;
            }
            if (srvMP.toString().equals(ManagementPolicy.MANUAL.toString()) && ResourceDependency.hasDependency(startDep, pullupTgt, ResourceDependency.DepType.PULLUP_ALWAYS_DEP)) {
                return ResourceDependency.setPullupDependency(startDep, pullupTgt, false);
            }
            if (!srvMP.toString().equals(ManagementPolicy.AUTOMATIC.toString())) {
                return false;
            }
            boolean stopFlag = true;
            for (DBRole dbr : srvRoles) {
                Trace.out("dbr " + dbr.name());
                if (!dbr.toString().equals(dbRole.toString())) continue;
                stopFlag = false;
                break;
            }
            if (stopFlag) {
                if (startDep == null) {
                    return false;
                }
                if (ResourceDependency.hasDependency(startDep, pullupTgt, ResourceDependency.DepType.PULLUP_ALWAYS_DEP)) {
                    return ResourceDependency.setPullupDependency(startDep, pullupTgt, false);
                }
                return false;
            }
            if (ResourceDependency.hasDependency(startDep, pullupTgt, ResourceDependency.DepType.PULLUP_ALWAYS_DEP)) {
                return false;
            }
            return ResourceDependency.setPullupDependency(startDep, pullupTgt, true);
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ServiceArgs getArgs() throws ServiceException {
        try {
            CRSResource.CSSCritical valEnum;
            List<ResourceAttribute> raL = this.m_crsResource.getAttributes(ResourceType.Service.SERVER_POOLS.name(), ResourceType.ClusterResource.CARDINALITY.name(), ResourceType.Service.USR_ORA_DISCONNECT.name(), ResourceType.Service.ROLE.name(), ResourceType.Service.MANAGEMENT_POLICY.name(), ResourceType.Service.DTP.name(), ResourceType.Service.AQ_HA_NOTIFICATION.name(), ResourceType.Service.COMMIT_OUTCOME.name(), ResourceType.Service.FAILOVER_TYPE.name(), ResourceType.Service.FAILOVER_METHOD.name(), ResourceType.Service.FAILOVER_RETRIES.name(), ResourceType.Service.FAILOVER_RESTORE.name(), ResourceType.Service.TAF_FAILOVER_DELAY.name(), ResourceType.Service.CLB_GOAL.name(), ResourceType.Service.RLB_GOAL.name(), ResourceType.Service.GLOBAL.name(), ResourceType.Service.MAX_LAG_TIME.name(), ResourceType.Service.RETENTION.name(), ResourceType.Service.REPLAY_INITIATION_TIME.name(), ResourceType.Service.SESSION_STATE_CONSISTENCY.name(), ResourceType.Service.SERVICE_NAME_PQ.name(), ResourceType.Service.SERVICE_TYPE.name(), ResourceType.Service.GSM_FLAGS.name(), ResourceType.Service.DRAIN_TIMEOUT.name(), ResourceType.Service.STOP_OPTION.name(), ResourceType.Service.CSS_CRITICAL.name());
            ServiceArgs args = new ServiceArgs();
            Hashtable<String, String> attrs = new Hashtable<String, String>();
            for (ResourceAttribute ra : raL) {
                attrs.put(ra.getName(), ra.getValue());
            }
            String val = null;
            val = (String)attrs.get(ResourceType.Service.SERVER_POOLS.name());
            ServerGroup serverGroup = null;
            if (val.length() > 0) {
                serverGroup = ServerFactoryImpl.getInstance().getServerGroup(val, (CRSEntity)this.m_crsResource);
                args.setServerGroup(serverGroup);
            }
            if ((val = (String)attrs.get(ResourceType.Service.SERVICE_TYPE.name())) != null && val.length() > 0) {
                args.setServiceType(ServiceType.getEnumMember(val));
            }
            if ((val = (String)attrs.get(ResourceType.Service.SERVICE_TYPE.name())) != null && val.length() > 0) {
                ServiceType stype = ServiceType.getEnumMember(val);
                args.setServiceType(stype);
                if (stype == ServiceType.PQ) {
                    args.setMainService(this.getMainService());
                }
            }
            if ((val = (String)attrs.get(ResourceType.Service.SERVICE_NAME_PQ.name())) != null && val.length() > 0) {
                args.setPQService(val);
            }
            args.setServiceCardinality(this.getServiceCardinality());
            val = (String)attrs.get(ResourceType.Service.USR_ORA_DISCONNECT.name());
            args.setDisconnectOpt(Boolean.parseBoolean(val));
            val = (String)attrs.get(ResourceType.Service.ROLE.name());
            args.setRoles(DBRole.decode(val));
            val = (String)attrs.get(ResourceType.Service.MANAGEMENT_POLICY.name());
            if (val.length() > 0) {
                args.setMgmtPolicy(ManagementPolicy.getEnumMember(val));
            }
            val = (String)attrs.get(ResourceType.Service.DTP.name());
            args.setDTP(val.equals("1"));
            val = (String)attrs.get(ResourceType.Service.AQ_HA_NOTIFICATION.name());
            args.setAQHANotification(val.equals("1"));
            val = (String)attrs.get(ResourceType.Service.GLOBAL.name());
            args.setGlobal(val.equalsIgnoreCase("true") || val.equals("1"));
            val = (String)attrs.get(ResourceType.Service.COMMIT_OUTCOME.name());
            args.setCommitOutcome(val.equals("1"));
            val = (String)attrs.get(ResourceType.Service.FAILOVER_TYPE.name());
            if (val.length() > 0) {
                args.setFailoverType(FailoverType.getEnumMember(val));
            }
            if ((val = (String)attrs.get(ResourceType.Service.FAILOVER_METHOD.name())).length() > 0) {
                args.setFailoverMethod(FailoverMethod.getEnumMember(val));
            }
            if ((val = (String)attrs.get(ResourceType.Service.FAILOVER_RETRIES.name())) != null && val.trim().length() > 0) {
                args.setFailoverRetry(Integer.parseInt(val));
            }
            if ((val = (String)attrs.get(ResourceType.Service.FAILOVER_RESTORE.name())) != null && val.trim().length() > 0) {
                args.setFailoverRestore(FailoverRestore.getEnumMember(val));
            }
            if ((val = (String)attrs.get(ResourceType.Service.TAF_FAILOVER_DELAY.name())) != null && val.trim().length() > 0) {
                args.setFailoverDelay(Integer.parseInt(val));
            }
            if (Integer.parseInt(val = (String)attrs.get(ResourceType.Service.RETENTION.name())) > 2592000) {
                throw new ServiceException((MessageKey)PrCdMsgID.INVALID_RETENTION_VALUE, val, 2592000);
            }
            args.setRetention(Integer.parseInt(val));
            val = (String)attrs.get(ResourceType.Service.REPLAY_INITIATION_TIME.name());
            if (Integer.parseInt(val) > 86400) {
                throw new ServiceException((MessageKey)PrCdMsgID.INVALID_REPLAY_INITIATION_TIME, val, 86400);
            }
            args.setReplayInitiationTime(Integer.parseInt(val));
            val = (String)attrs.get(ResourceType.Service.SESSION_STATE_CONSISTENCY.name());
            if (val.length() > 0) {
                args.setSessionState(SessionStateEnum.getEnumMember(val));
            }
            val = (String)attrs.get(ResourceType.Service.CLB_GOAL.name());
            args.setCLBGoal(CLBGoal.getEnumMember(val));
            val = (String)attrs.get(ResourceType.Service.RLB_GOAL.name());
            args.setRLBGoal(RLBGoal.getEnumMember(val));
            val = (String)attrs.get(ResourceType.Service.MAX_LAG_TIME.name());
            args.setMaxLagTime(val);
            val = (String)attrs.get(ResourceType.Service.GSM_FLAGS.name());
            if (val != null && val.trim().length() > 0) {
                args.setGSMFlags(Integer.parseInt(val));
            }
            if ((val = (String)attrs.get(ResourceType.Service.DRAIN_TIMEOUT.name())) != null && !val.trim().isEmpty()) {
                args.setDrainTimeout(Integer.parseInt(val));
            }
            if ((val = (String)attrs.get(ResourceType.Service.STOP_OPTION.name())) != null && val.trim().length() > 0) {
                String[] optValues = val.split(",");
                StopOptions[] soArr = new StopOptions[optValues.length];
                for (int i = 0; i < soArr.length; ++i) {
                    soArr[i] = StopOptions.getEnumMember(optValues[i].trim(), true);
                }
                args.setStopOptions(soArr);
            }
            if ((val = (String)attrs.get(ResourceType.Service.CSS_CRITICAL.name())) != null && !val.trim().isEmpty() && (valEnum = CRSResource.CSSCritical.getEnumMember(val)) == CRSResource.CSSCritical.YES) {
                args.setCSSCriticalOption(CRSResource.CSSCritical.getEnumMember(val));
            }
            return args;
        }
        catch (NotExistsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERV_ARGS_FAILD, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerGroupException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERV_ARGS_FAILD, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERV_ARGS_FAILD, (Throwable)e, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERV_ARGS_FAILD, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERV_ARGS_FAILD, (Throwable)e, this.getUserAssignedName());
        }
        catch (EnumConstNotFoundException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERV_ARGS_FAILD, (Throwable)e, this.getUserAssignedName());
        }
    }

    void modify(ServiceArgs args) throws ServiceException {
        this.modify(args, false);
    }

    void modify(ServiceArgs args, boolean global) throws ServiceException {
        this.modify(args, global, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void modify(ServiceArgs args, boolean global, boolean force) throws ServiceException {
        try {
            CRSResource.CSSCritical cssCritical;
            Integer gsmFlags;
            String maxLagTime;
            RLBGoal rg;
            CLBGoal cg;
            String sqltrans;
            String plugDB;
            String edition;
            FailoverRestore fr;
            Integer iVal;
            FailoverMethod fm;
            FailoverType ft;
            Boolean val;
            ServiceCardinality card;
            ManagementPolicy newMP;
            ServerGroup serverPool;
            ServiceType serviceType;
            DBRole[] roles;
            Common.versionCheck(this.version(), new Version());
            Trace.out("boolean value is " + global);
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> ral = new ArrayList<ResourceAttribute>();
            ResourceAttribute[] overrideAttrs = null;
            String optSet = null;
            Network netw = args.getNetwork();
            if (netw != null) {
                if (!netw.isLeafNW()) throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_BAD_ARG, this.getUserAssignedName(), "Network");
                throw new ServiceException((MessageKey)PrCsMsgID.MODIFY_RESOURCE_ON_LEAF_NETWORK_ERROR, netw.getNumber());
            }
            Boolean disconnect = args.getDisconnectOpt();
            if (disconnect != null) {
                overrideAttrs = new ResourceAttribute[]{cf.create(ResourceType.Service.USR_ORA_DISCONNECT.name(), disconnect.toString())};
            }
            if ((roles = args.getRoles()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.ROLE.name(), DBRole.toString(roles)));
                } else {
                    optSet = "ROLE";
                }
            }
            if ((serviceType = args.getServiceType()) != null) {
                ral.add(cf.create(ResourceType.Service.SERVICE_TYPE.name(), serviceType.toString()));
            }
            if ((serverPool = args.getServerGroup()) != null) {
                if (!serverPool.isServerPool()) {
                    throw new ServiceException((MessageKey)PrCdMsgID.CANNOT_USE_SUBPOOL_FOR_MOD_SVC, serverPool.getUserAssignedName(), this.getUserAssignedName());
                }
                try {
                    if (serviceType == ServiceType.PQ) {
                        Common.checkPQServerCategory(serverPool);
                    } else {
                        Common.checkPrimaryServerCategory(serverPool);
                    }
                }
                catch (DatabaseException e) {
                    throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
                }
            }
            DatabaseImpl dbImpl = (DatabaseImpl)this.database();
            String dbUniqueName = dbImpl.getUserAssignedName();
            if (serverPool != null && dbImpl.isDBCentric()) {
                throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_DB_SERV_CENTRIC_CONFIG, this.getUserAssignedName(), dbUniqueName);
            }
            String pqservice = args.getPQService();
            if (pqservice != null) {
                this.validateServiceName(pqservice, null, null, false);
                ral.add(cf.create(ResourceType.Service.SERVICE_NAME_PQ.name(), pqservice));
            }
            if ((newMP = args.getMgmtPolicy()) != null) {
                if (!this.isGlobal() || global) {
                    ManagementPolicy dbPolicy = dbImpl.getMgmtPolicy();
                    if ((dbPolicy == ManagementPolicy.MANUAL || dbPolicy == ManagementPolicy.NORESTART) && newMP == ManagementPolicy.AUTOMATIC) {
                        throw new ServiceException((MessageKey)PrCdMsgID.DB_SERV_MGMT_POLICY_ERR, this.getUserAssignedName(), dbUniqueName);
                    }
                    ral.add(cf.create(ResourceType.Service.MANAGEMENT_POLICY.name(), newMP.toString()));
                } else {
                    optSet = "MANAGEMENT_POLICY";
                }
            }
            if ((card = args.getServiceCardinality()) != null) {
                int runningCnt;
                if (card == ServiceCardinality.SINGLETON && (runningCnt = this.crsResource().fetchRunningNodes().size()) > 1 && !force) {
                    throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_MODIFY_CARD_FAILED, this.getUserAssignedName(), ServiceCardinality.SINGLETON.name());
                }
                ral.add(cf.create(ResourceType.ClusterResource.CARDINALITY.name(), card.toString()));
                if (dbImpl.isClusterDatabase()) {
                    String template;
                    CRSResourceImpl res = (CRSResourceImpl)this.crsResource();
                    List<ResourceAttribute> startDeps = res.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name());
                    ResourceAttribute startDep = startDeps.get(0);
                    ResourceAttribute startDepHint = startDeps.get(1);
                    String attrValue = startDep.getValue();
                    String attrValueHint = startDepHint.getValue();
                    String version = null;
                    Map<String, RTEArg> argMap = null;
                    Map<String, String> condMap = null;
                    try {
                        template = ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString();
                        ArrayList<String> argNameList = new ArrayList<String>();
                        argNameList.add("mainService");
                        argNameList.add("service");
                        argNameList.add("cluster_vip_net");
                        argNameList.add("database");
                        RTENativeResult result = CRSFactoryImpl.getInstance().rteGetArgList(template, argNameList, attrValue, attrValueHint, version, res.getName());
                        argMap = result.getRTEArgMap();
                        condMap = result.getCondMap();
                    }
                    catch (CRSException e) {
                        throw new ServiceException(e);
                    }
                    condMap.put("UPDATE_SERVICE_TYPE", "True");
                    condMap.put("SERVICE_CARDINALITY", card == ServiceCardinality.SINGLETON ? "1" : "0");
                    try {
                        template = ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString();
                        RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, version, condMap, res.getName());
                        String newStartDep = result.getAttrValue();
                        String newStartDepHint = result.getAttrValueHint();
                        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                        ral.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), newStartDep));
                        ral.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), newStartDepHint));
                    }
                    catch (CRSException e) {
                        throw new ServiceException(e);
                    }
                }
            }
            if (dbImpl.isCardinal()) {
                ral.add(cf.create(ResourceType.Service.RESTART_ATTEMPTS.name(), ResourceType.Service.RESTART_ATTEMPTS.toString()));
            }
            if ((val = args.getDTP()) != null) {
                ral.add(cf.create(ResourceType.Service.DTP.name(), val != false ? "1" : "0"));
            }
            if ((val = args.getAQHANotification()) != null) {
                if (!this.isGlobal() || global) {
                    if (Cluster.isCluster()) {
                        ft = args.getFailoverType();
                        if (!val.booleanValue() && (ft != null && ft.toString().equalsIgnoreCase(FailoverType.TRANSACTION.toString()) || ft == null && this.isFailoverTransactional())) {
                            throw new ServiceException((MessageKey)PrCdMsgID.AQHA_FALSE_FOTYPE_TRANS, new Object[0]);
                        }
                    }
                    ral.add(cf.create(ResourceType.Service.AQ_HA_NOTIFICATION.name(), val != false ? "1" : "0"));
                } else {
                    optSet = "AQ_HA_NOTIFICATION";
                }
            }
            if ((val = args.getCommitOutcome()) != null) {
                if (!val.booleanValue() && ((ft = args.getFailoverType()) != null && ft.toString().equalsIgnoreCase("TRANSACTION") || ft == null && this.isFailoverTransactional())) {
                    throw new ServiceException((MessageKey)PrCdMsgID.UNSET_COMMIT_OUTCOME_FAILED, new Object[0]);
                }
                ral.add(cf.create(ResourceType.Service.COMMIT_OUTCOME.name(), val != false ? "1" : "0"));
            }
            if ((ft = args.getFailoverType()) != null) {
                if (!this.isGlobal() || global) {
                    if (ft.toString().equalsIgnoreCase(FailoverType.TRANSACTION.toString())) {
                        Trace.out("failover type takes transaction");
                        if ((args.getCommitOutcome() == null || !args.getCommitOutcome().booleanValue()) && (args.getCommitOutcome() != null || !this.isCommitSet())) throw new ServiceException((MessageKey)PrCdMsgID.ADD_MODIFY_FAILOVER_TYPE_NOT_ALLOWED, new Object[0]);
                        Trace.out("commit outcome set to true");
                        ral.add(cf.create(ResourceType.Service.FAILOVER_TYPE.name(), ft.toString()));
                        if (Cluster.isCluster() && args.getAQHANotification() == null) {
                            ral.add(cf.create(ResourceType.Service.AQ_HA_NOTIFICATION.name(), "1"));
                        }
                        if (serviceType != ServiceType.PQ && args.getSessionState() == null && this.m_crsResource.getAttribute(ResourceType.Service.SESSION_STATE_CONSISTENCY.name()).getValue().trim().length() == 0) {
                            args.setSessionState(SessionStateEnum.DYNAMIC);
                        }
                    } else {
                        ral.add(cf.create(ResourceType.Service.FAILOVER_TYPE.name(), ft.toString()));
                    }
                } else {
                    optSet = "FAILOVER_TYPE";
                }
            }
            if ((fm = args.getFailoverMethod()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.FAILOVER_METHOD.name(), fm.toString()));
                } else {
                    optSet = "FAILOVER_METHOD";
                }
            }
            if ((iVal = args.getFailoverRetry()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.FAILOVER_RETRIES.name(), iVal.toString()));
                } else {
                    optSet = "FAILOVER_RETRIES";
                }
            }
            if ((fr = args.getFailoverRestore()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.FAILOVER_RESTORE.name(), fr.toString()));
                } else {
                    optSet = "FAILOVER_RESTORE";
                }
            }
            if ((iVal = args.getFailoverDelay()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.TAF_FAILOVER_DELAY.name(), iVal.toString()));
                } else {
                    optSet = "TAF_FAILOVER_DELAY";
                }
            }
            if ((edition = args.getEdition()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.EDITION.name(), edition));
                } else {
                    optSet = "EDITION";
                }
            }
            if ((plugDB = args.getPDB()) != null) {
                ServiceImpl.validatePDB(plugDB);
                this.validateServiceName(this.getUserAssignedName(), plugDB, null, true);
                ral.add(cf.create(ResourceType.Service.PLUGGABLE_DATABASE.name(), plugDB));
            }
            if ((sqltrans = args.getTranslationProfile()) != null) {
                ral.add(cf.create(ResourceType.Service.SQL_TRANSLATION_PROFILE.name(), sqltrans));
            }
            if (serviceType != ServiceType.PQ) {
                SessionStateEnum sessionState;
                Integer replayInittime;
                Integer retention = args.getRetention();
                if (retention != null) {
                    if (retention > 2592000) {
                        throw new ServiceException((MessageKey)PrCdMsgID.INVALID_RETENTION_VALUE, retention, 2592000);
                    }
                    if ((args.getCommitOutcome() == null || !args.getCommitOutcome().booleanValue()) && (args.getCommitOutcome() != null || !this.isCommitSet())) throw new ServiceException((MessageKey)PrCdMsgID.ADD_MODIFY_RETENTION_NOT_ALLOWED, new Object[0]);
                    ral.add(cf.create(ResourceType.Service.RETENTION.name(), retention.toString()));
                }
                if ((replayInittime = args.getReplayInitiationTime()) != null) {
                    if (replayInittime > 86400) {
                        throw new ServiceException((MessageKey)PrCdMsgID.INVALID_REPLAY_INITIATION_TIME, replayInittime, 86400);
                    }
                    ft = args.getFailoverType();
                    if ((ft == null || !ft.toString().equalsIgnoreCase("TRANSACTION")) && (ft != null || !this.isFailoverTransactional())) throw new ServiceException((MessageKey)PrCdMsgID.FAILOVER_TYPE_NOT_TRANS_REPLAY, new Object[0]);
                    ral.add(cf.create(ResourceType.Service.REPLAY_INITIATION_TIME.name(), replayInittime.toString()));
                }
                if ((sessionState = args.getSessionState()) != null) {
                    ft = args.getFailoverType();
                    if ((ft == null || !ft.toString().equalsIgnoreCase(FailoverType.TRANSACTION.toString())) && (ft != null || !this.isFailoverTransactional())) throw new ServiceException((MessageKey)PrCdMsgID.FAILOVER_TYPE_NOT_TRANS_SESSION_STATE, new Object[0]);
                    ral.add(cf.create(ResourceType.Service.SESSION_STATE_CONSISTENCY.name(), sessionState.toString()));
                }
            }
            if ((cg = args.getCLBGoal()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.CLB_GOAL.name(), cg.toString()));
                } else {
                    optSet = "CLB_GOAL";
                }
            }
            if ((rg = args.getRLBGoal()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.RLB_GOAL.name(), rg.toString()));
                } else {
                    optSet = "RLB_GOAL";
                }
            }
            if ((maxLagTime = args.getMaxLagTime()) != null) {
                if (!this.isGlobal() || global) {
                    ral.add(cf.create(ResourceType.Service.MAX_LAG_TIME.name(), maxLagTime.toString()));
                } else {
                    optSet = "MAX_LAG_TIME";
                }
            }
            if ((gsmFlags = args.getGSMFlags()) != null) {
                if (!this.isGlobal()) throw new ServiceException((MessageKey)PrCdMsgID.NON_GLOBAL_SERVICE, this.getUserAssignedName());
                if (global) {
                    ral.add(cf.create(ResourceType.Service.GSM_FLAGS.name(), gsmFlags.toString()));
                } else {
                    optSet = "GSM_FLAGS";
                }
            }
            if (optSet != null) {
                throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_MODIFY_ATTRIBUTES_NOT_ALLOWED, optSet);
            }
            ArrayList<ServerGroup> newSGList = null;
            List<ServerGroup> newPQList = null;
            boolean updateDB = false;
            if (serverPool != null) {
                ServerGroup curSvcSG = this.serverGroup();
                ral.add(cf.create(ResourceType.Service.SERVER_POOLS.name(), serverPool.getName()));
                List<ServerGroup> dbSGList = dbImpl.serverGroups();
                newSGList = new ArrayList<ServerGroup>(dbSGList);
                if (curSvcSG.services().size() == 1) {
                    newSGList.remove(curSvcSG);
                    updateDB = true;
                }
                if (!newSGList.contains(serverPool)) {
                    newSGList.add(serverPool);
                    updateDB = true;
                }
                if (serviceType == ServiceType.PQ) {
                    newPQList = dbImpl.getPQPools();
                    if (curSvcSG.services().size() == 1) {
                        newPQList.remove(curSvcSG);
                        updateDB = true;
                    }
                    if (!newPQList.contains(serverPool)) {
                        newPQList.add(serverPool);
                        updateDB = true;
                    }
                }
            }
            Integer drainTimeout = args.getDrainTimeout();
            Enum[] stopOptions = args.getStopOptions();
            String stopOpt = null;
            if (stopOptions != null) {
                String drainStr;
                stopOpt = oracle.cluster.impl.util.Utils.getEnumString(stopOptions, String.valueOf(","));
                Integer drainTime = null;
                drainTime = drainTimeout != null ? drainTimeout : ((drainStr = this.getDrainTimeout()) != null && drainStr.length() != 0 ? Integer.valueOf(Integer.parseInt(drainStr)) : null);
                Common.checkDrainStopOpt(drainTime, stopOpt);
                ral.add(cf.create(ResourceType.Service.STOP_OPTION.name(), stopOpt));
            }
            if (serviceType != ServiceType.PQ && drainTimeout != null) {
                Common.checkDrainStopOpt(drainTimeout, this.getStopOption());
                String value = drainTimeout == -1 ? "" : drainTimeout.toString();
                ral.add(cf.create(ResourceType.Service.DRAIN_TIMEOUT.name(), value));
            }
            if ((cssCritical = args.getCSSCriticalOption()) != null) {
                if (!dbImpl.isAdminManaged()) {
                    throw new ServiceException((MessageKey)PrCdMsgID.CSS_CRITICAL_NA2, this.getUserAssignedName(), dbUniqueName);
                }
                ral.add(cf.create(ResourceType.Service.CSS_CRITICAL.name(), cssCritical.toString()));
            }
            if (newMP != null) {
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                CRSResourceImpl res = (CRSResourceImpl)this.crsResource();
                ResourceAttribute dbAttr = crsFactory.create(ResourceType.Database.NAME.name(), dbImpl.getName());
                List<ResourceAttribute> raList = res.getAttributes(ResourceType.Service.MANAGEMENT_POLICY.name(), ResourceType.ClusterResource.AUTO_START.name(), ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceType.Service.TAF_POLICY.name());
                ManagementPolicy currMP = null;
                ResourceAttribute raAS = null;
                ResourceAttribute raSD = null;
                boolean isPreconnect = false;
                boolean puAlways = false;
                for (ResourceAttribute ra : raList) {
                    if (ra.getName().equals(ResourceType.Service.MANAGEMENT_POLICY.name())) {
                        currMP = ManagementPolicy.getEnumMember(ra.getValue());
                    }
                    if (ra.getName().equals(ResourceType.Service.TAF_POLICY.name())) {
                        isPreconnect = ServiceTAF.PRECONNECT == ServiceTAF.getEnumMember(ra.getValue());
                        continue;
                    }
                    if (ra.getName().equals(ResourceType.LocalResource.START_DEPENDENCIES.name())) {
                        raSD = ra;
                        continue;
                    }
                    if (!ra.getName().equals(ResourceType.ClusterResource.AUTO_START.name())) continue;
                    raAS = ra;
                }
                if (currMP.toString().equals(ManagementPolicy.AUTOMATIC.toString()) && newMP.toString().equals(ManagementPolicy.MANUAL.toString())) {
                    raAS.setValue(CRSResource.AutoStart.NEVER.toString());
                    ral.add(raAS);
                    puAlways = false;
                    ResourceDependency.setPullupDependency(raSD, dbAttr, puAlways);
                    ral.add(raSD);
                } else if (currMP.toString().equals(ManagementPolicy.MANUAL.toString()) && newMP.toString().equals(ManagementPolicy.AUTOMATIC.toString())) {
                    raAS.setValue(CRSResource.AutoStart.RESTORE.toString());
                    ral.add(raAS);
                    puAlways = true;
                    ResourceDependency.setPullupDependency(raSD, dbAttr, puAlways);
                    ral.add(raSD);
                }
                if (ral.size() > 0) {
                    this.m_crsResource.update(ral.toArray(new ResourceAttribute[ral.size()]));
                }
                if (isPreconnect && raSD != null) {
                    ResourceAttribute preAttr = crsFactory.create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, this.getUserAssignedName(), true));
                    res = (CRSResourceImpl)crsFactory.get(preAttr);
                    ral.remove(raSD);
                    raSD = res.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
                    ResourceAttribute pullupTgt = crsFactory.create(ResourceType.Service.NAME.name(), this.getPreconnectPullupTarget());
                    ResourceDependency.setPullupDependency(raSD, pullupTgt, puAlways);
                    ral.add(raSD);
                    res.update(ral.toArray(new ResourceAttribute[ral.size()]));
                }
            } else if (ral.size() > 0) {
                this.m_crsResource.update(overrideAttrs, force, ral.toArray(new ResourceAttribute[ral.size()]));
            }
            if (!updateDB) return;
            if (newSGList != null) {
                dbImpl.setServerGroups(newSGList, force, true);
            }
            if (newPQList == null) return;
            dbImpl.setPQPools(newPQList, force);
            return;
        }
        catch (NotExistsException ex) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
        catch (DatabaseException ex) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
        catch (CRSException ex) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
        catch (ServerGroupException ex) {
            String exMsg = ex.getMessage();
            if (!exMsg.contains("CRS-0215:") && !exMsg.contains("CRS-2674:") && !exMsg.contains("CRS-5017:")) throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
            Trace.out("Experienced start failure");
            throw new ServiceException(ex);
        }
        catch (NetworkException ne) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ne, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NoVersionAvailableException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    void modifyRFService(ServiceArgs args) throws ServiceException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> ral = new ArrayList<ResourceAttribute>();
            ServerGroup oldRFPool = this.serverGroup();
            Database db = this.database();
            if (this.getServiceType() != ServiceType.RF) {
                throw new ServiceException((MessageKey)PrCsMsgID.MOD_SVC_TO_RF_CONVERT_ERROR, this.getUserAssignedName());
            }
            if (args.getServiceType() != null && args.getServiceType() != ServiceType.RF) {
                throw new ServiceException((MessageKey)PrCsMsgID.MOD_RF_SVC_CONVERT_ERROR, new Object[0]);
            }
            ServerGroup rfPool = args.getRFPool();
            if (rfPool != null) {
                Common.checkRFServerCategory(rfPool);
                ral.add(cf.create(ResourceType.Service.SERVER_POOLS.name(), rfPool.toString()));
            }
            if (ral.size() > 0) {
                this.m_crsResource.update(ral.toArray(new ResourceAttribute[ral.size()]));
            }
            Trace.out("Removing old reader farm pool configuration");
            this.removeOldRFPool(db, oldRFPool);
            Trace.out("Adding new reader farm pool configuration");
            this.updateDBSrvPools(db, ServiceType.RF, rfPool, false);
        }
        catch (CRSException ex) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
        catch (DatabaseException ex) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
        catch (ServerGroupException ex) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERV_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
    }

    private String getPreconnectPullupTarget() {
        return ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP.toString() + ':' + this.m_nameAttr.getValue();
    }

    private void validateServiceName(String serviceName, String dbUniqueName, String dbDomain, boolean isPDB) throws ServiceException {
        char c;
        int i;
        String svcName = serviceName;
        String dbSvcName = dbUniqueName;
        if (dbDomain != null && dbDomain.length() > 0) {
            dbSvcName = dbSvcName + '.' + dbDomain;
            if (svcName.indexOf(46) == -1) {
                svcName = svcName + '.' + dbDomain;
            }
        }
        if (svcName.equalsIgnoreCase(dbSvcName)) {
            if (isPDB) {
                throw new ServiceException((MessageKey)PrCdMsgID.ERR_PDB_DEFAULT_SVC, svcName, dbSvcName);
            }
            throw new ServiceException((MessageKey)PrCdMsgID.ERR_DB_DEFAULT_SVC, svcName, dbSvcName);
        }
        int dotIdx = svcName.indexOf(46);
        String svcDomain = "";
        if (dotIdx != -1) {
            svcDomain = svcName.substring(dotIdx + 1);
            svcName = svcName.substring(0, dotIdx);
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < svcName.length(); ++i) {
            c = svcName.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            sb.append(c);
        }
        for (i = 0; i < svcDomain.length(); ++i) {
            c = svcDomain.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#' || c == '.') continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_SVC_NAME, serviceName, sb.toString());
        }
    }

    @Override
    public void enable(boolean global) throws AlreadyEnabledException, SoftwareModuleException {
        if (this.isGlobal() && !global) {
            throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
        }
        super.enable();
    }

    @Override
    public void enable(List<Node> nodes, boolean global) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException {
        if (this.isGlobal() && !global) {
            throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
        }
        this.enable(nodes);
    }

    @Override
    public void enable(List<Node> nodes) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException {
        if (!Cluster.isCluster()) {
            throw new SoftwareModuleException((MessageKey)PrCdMsgID.SERV_ENABLE_DISABLE_SIDB, this.getUserAssignedName(), this.database().getUserAssignedName());
        }
        super.enable(nodes);
    }

    @Override
    public void disable(boolean global) throws AlreadyDisabledException, SoftwareModuleException {
        if (this.isGlobal() && !global) {
            throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
        }
        super.disable();
    }

    @Override
    public void disable(List<Node> nodes, boolean global) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException {
        if (this.isGlobal() && !global) {
            throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
        }
        this.disable(nodes);
    }

    @Override
    public void disable(List<Node> nodes) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException {
        if (!Cluster.isCluster()) {
            throw new SoftwareModuleException((MessageKey)PrCdMsgID.SERV_ENABLE_DISABLE_SIDB, this.getUserAssignedName(), this.database().getUserAssignedName());
        }
        super.disable(nodes);
    }

    static String getServiceEvtValue(String dbUniqueName) {
        String dbResName = DatabaseImpl.getResourceName(dbUniqueName);
        StringBuilder sb = new StringBuilder();
        sb.append(ResourceLiterals.PROPERTY_TEMPLATE.toString()).append("(");
        sb.append(ResourceLiterals.RESOURCE_CLASS.toString()).append("=");
        sb.append(ResourceLiterals.SERVICE.toString()).append(")").append(" ");
        sb.append(ResourceLiterals.PROPERTY_TEMPLATE.toString()).append("(");
        sb.append(ResourceLiterals.SERVICE_NAME.toString()).append("=%");
        sb.append(ResourceType.Service.GEN_SERVICE_NAME.name()).append("%)").append(" ");
        sb.append(ResourceLiterals.PROPERTY_TEMPLATE.toString()).append("(");
        sb.append(ResourceLiterals.DB_UNIQUE_NAME.toString()).append("=");
        sb.append(ResourceLiterals.CONCAT.toString()).append("(");
        sb.append(ResourceLiterals.PARSE.toString()).append("(%").append(ResourceType.Database.NAME.name()).append("%, ., 2), ");
        sb.append(ResourceLiterals.STAT.toString()).append("(").append(dbResName).append(", ");
        sb.append(ResourceType.Database.USR_ORA_DOMAIN.name()).append("), .)) ");
        sb.append(ResourceLiterals.ELEMENT_TEMPLATE.toString()).append("(");
        sb.append(ResourceLiterals.INSTANCE_NAME.toString()).append("=");
        sb.append(ResourceLiterals.STAT.toString()).append("(").append(dbResName).append(", ");
        sb.append(ResourceType.Database.GEN_USR_ORA_INST_NAME.name()).append(")) ");
        sb.append(ResourceLiterals.ELEMENT_TEMPLATE.toString()).append("(");
        sb.append(ResourceType.Service.DRAIN_TIMEOUT.name()).append("=%");
        sb.append(ResourceType.Service.DRAIN_TIMEOUT.name()).append("%)");
        return sb.toString();
    }

    @Override
    public String getDrainTimeout() throws ServiceException {
        try {
            String drain = this.m_crsResource.getAttribute(ResourceType.Service.DRAIN_TIMEOUT.name()).getValue();
            return drain;
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    public String getStopOption() throws ServiceException {
        try {
            String stopOpt = this.m_crsResource.getAttribute(ResourceType.Service.STOP_OPTION.name()).getValue();
            return stopOpt;
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    static void validatePDB(String name) throws ServiceException {
        char c0;
        if (!(name.trim().length() == 0 || Character.isLetter(c0 = name.charAt(0)) && name.matches("[a-zA-Z0-9$#_]*"))) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_PDB_NAME, name);
        }
    }

    public static String getDbNameFromSvcName(String resName) throws DatabaseException {
        if (resName == null || resName.trim().isEmpty()) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "serviceImpl-getDbNameFromSvcName-1");
        }
        int index = resName.indexOf(46);
        if (index < 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "serviceImpl-getDbNameFromSvcName-2");
        }
        String value = resName.substring(index + 1);
        if ((index = value.indexOf(46)) < 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "serviceImpl-getDbNameFromSvcName-3");
        }
        String dbUniqueName = value.substring(0, index);
        Trace.out("db unique name = " + dbUniqueName);
        return dbUniqueName;
    }

    static String getSvcNameFromResName(String resName) throws ServiceException {
        if (resName == null || resName.trim().isEmpty()) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "serviceImpl-getSvcNameFromResName-1");
        }
        int index = resName.indexOf(46);
        if (index < 0) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "serviceImpl-getSvcNameFromResName-2");
        }
        String value = resName.substring(index + 1);
        if ((index = value.indexOf(46)) < 0) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "serviceImpl-getSvcNameFromResName-3");
        }
        if ((index = (value = value.substring(index + 1)).indexOf(46)) < 0) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "serviceImpl-getSvcNameFromResName-4");
        }
        String svcName = value.substring(0, index);
        Trace.out((Object)"user assigned service name : %s", svcName);
        return svcName;
    }

    static List<ResourceAttribute> getSvcStopOptions(ServiceStopArgs args, String drainID) throws InvalidArgsException, CRSException {
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ServiceImpl-getSvcStopOptions-1");
        }
        Boolean isDisconnect = args.getDisconnectOpt();
        Boolean isNoreplay = args.getNoreplay();
        Enum[] stopOptions = args.getStopModes();
        Integer drainTimeout = args.getDrainTimeout();
        Integer stopTimeout = args.getStopTimeout();
        CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
        ArrayList<ResourceAttribute> optionsList = new ArrayList<ResourceAttribute>();
        if (isDisconnect != null) {
            optionsList.add(cf.create(ResourceType.Service.USR_ORA_DISCONNECT.name(), isDisconnect.toString()));
        }
        if (isNoreplay != null) {
            optionsList.add(cf.create(ResourceType.Service.SESSION_NOREPLAY.name(), isNoreplay.toString()));
        }
        if (stopOptions != null && stopOptions.length > 0) {
            optionsList.add(cf.create(ResourceType.Service.USR_ORA_STOP_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(stopOptions, String.valueOf(" "))));
        }
        if (drainTimeout != null) {
            String timeout = "";
            if (drainTimeout >= 0) {
                timeout = drainTimeout.toString();
                if (drainID != null) {
                    Trace.out((Object)"drain id = %s", drainID);
                    optionsList.add(cf.create(ResourceType.Service.DRAIN_ID.name(), drainID));
                }
            }
            optionsList.add(cf.create(ResourceType.Service.DRAIN_TIMEOUT.name(), timeout));
        }
        if (stopTimeout != null && stopTimeout != -1) {
            optionsList.add(cf.create(ResourceType.Service.STOP_TIMEOUT.name(), String.valueOf(stopTimeout * 60)));
        }
        return optionsList;
    }

    @Override
    public void updateCSSCritical(CRSResource.CSSCritical option) throws InvalidArgsException, ServiceException {
        if (option == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ServiceImpl-updateCSSCritical-01");
        }
        try {
            Database db = this.database();
            if (!db.isAdminManaged()) {
                throw new ServiceException((MessageKey)PrCdMsgID.CSS_CRITICAL_NA2, this.getUserAssignedName(), db.getUserAssignedName());
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Service.CSS_CRITICAL.name(), option.toString()));
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_CSS_CRITICAL_FAILED, (Throwable)e, this.getName());
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.UPDATE_CSS_CRITICAL_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public boolean isCSSCritical() throws ServiceException {
        if (this.m_crsResource == null) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ServiceImpl-isCSSCritical-01");
        }
        try {
            String val = this.m_crsResource.getAttribute(ResourceType.Service.CSS_CRITICAL.name()).getValue();
            Trace.out((Object)"CSS_CRITICAL's value is %s", val);
            return CRSResource.CSSCritical.getEnumMember(val) == CRSResource.CSSCritical.YES;
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.GET_CSS_CRITICAL_FAILED, (Throwable)e, this.getName());
        }
        catch (EnumConstNotFoundException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.GET_CSS_CRITICAL_FAILED, (Throwable)e, this.getName());
        }
    }

    static ServiceStopArgs createSvcStopArgs(ServiceArgs args) throws InvalidArgsException {
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ServiceImpl-createSvcStopArgs-1");
        }
        Boolean isDisconnect = args.getDisconnectOpt();
        Boolean isNoreplay = args.getNoreplay();
        Boolean force = args.getForceFlag();
        Integer drainTime = args.getDrainTimeout();
        Boolean isWait = args.getWait();
        ServiceStopArgs retval = new ServiceStopArgs();
        retval.setStopModes(args.getStopOptions());
        retval.setVerboseListener(args.getVerboseListener());
        if (force != null) {
            retval.setForceFlag(force);
        }
        if (isDisconnect != null) {
            retval.setDisconnectOpt(isDisconnect);
        }
        if (isNoreplay != null) {
            retval.setNoreplay(isNoreplay);
        }
        if (drainTime != null) {
            retval.setDrainTimeout(drainTime);
        }
        if (isWait != null) {
            retval.setWait(args.getWait());
        }
        return retval;
    }

    @Override
    public boolean isJavaService() throws ServiceException, NotRunningException {
        return this.isJavaServiceInternal();
    }

    private boolean isJavaServiceInternal() throws ServiceException, NotRunningException {
        Database db = this.database();
        List<Node> svcNodes = null;
        Object selectedNode = null;
        Map<String, String> instances = null;
        try {
            instances = ((DatabaseImpl)db).getRunningInstances();
        }
        catch (DatabaseException dbe) {
            Trace.out("Exception : " + dbe.getMessage());
            throw new ServiceException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_NOT_RUN, (Throwable)dbe, this.getUserAssignedName());
        }
        if (instances == null || instances.isEmpty()) {
            Trace.out("There are no online db instances");
            throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_RUNNING, this.getUserAssignedName());
        }
        try {
            svcNodes = this.crsResource().fetchRunningNodes();
        }
        catch (CRSException e) {
            Trace.out("Exception : " + e.getMessage());
            throw new ServiceException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_NOT_RUN, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            Trace.out("Exception : " + e.getMessage());
            throw new ServiceException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_NOT_RUN, (Throwable)e, this.getUserAssignedName());
        }
        if (svcNodes == null || svcNodes.isEmpty()) {
            Trace.out("Service not ONLINE");
            throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_RUNNING, this.getUserAssignedName());
        }
        DatabaseAction dbAction = ((DatabaseImpl)db).getDBAction();
        try {
            Trace.out("Initiating isJavaService action on " + Arrays.toString(svcNodes.toArray()));
            return dbAction.isJavaServiceAction(svcNodes, this);
        }
        catch (DatabaseException e) {
            Trace.out("Error obtained during action " + e.getMessage());
            throw new ServiceException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_NOT_RUN, (Throwable)e, this.getUserAssignedName());
        }
    }
}

