/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.MoveDatabaseException;
import oracle.cluster.impl.crs.cops.CRSCompositeOperationException;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

class MutableMoveDatabaseException
extends MoveDatabaseException {
    private Map<String, Map<String, FailureDetails>> m_moveStatus = new HashMap<String, Map<String, FailureDetails>>();
    private long m_creationTime = -1L;
    private MessageBundle m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);

    private MutableMoveDatabaseException(MessageKey key, Object ... args) {
        super(key, args);
        this.m_msgBndl.setPackage("oracle.cluster.resources");
        this.setCreationTime();
        Trace.out("Exiting constructor");
    }

    private MutableMoveDatabaseException(MessageKey key, Exception e, Object ... args) {
        super(key, e, args);
        this.m_msgBndl.setPackage("oracle.cluster.resources");
        this.setCreationTime();
        Trace.out("Exiting constructor");
    }

    private MutableMoveDatabaseException(Exception e) {
        super(e);
        this.m_msgBndl.setPackage("oracle.cluster.resources");
        this.setCreationTime();
        Trace.out("Exiting constructor");
    }

    static MutableMoveDatabaseException getInstance(MessageKey key, Object ... args) {
        return new MutableMoveDatabaseException(key, args);
    }

    static MutableMoveDatabaseException getInstance(MessageKey key, Exception e, Object ... args) {
        return new MutableMoveDatabaseException(key, e, args);
    }

    static MutableMoveDatabaseException getInstance(Exception e) {
        return new MutableMoveDatabaseException(e);
    }

    void setFailure(String node, MoveDatabaseException.Operation failedOp, CompositeOperationException cause) {
        if (cause instanceof CRSCompositeOperationException) {
            CRSCompositeOperationException crse = (CRSCompositeOperationException)cause;
            for (Object id : crse.getOperationIdentifier()) {
                Trace.out("Object id : " + id.toString());
                CRSNativeException cne = null;
                String resID = null;
                try {
                    cne = (CRSNativeException)crse.getException(id);
                    Trace.out("CRSNativeException : " + cne.getMessage());
                    resID = (String)id;
                }
                catch (NoSuchIdentifierException nsie) {
                    Trace.out("NoSuchIDException : " + nsie.getMessage());
                }
                if (resID == null) continue;
                Trace.out("failed database id = " + resID);
                String[] values = resID.split(String.valueOf(" "));
                try {
                    String dbName = DatabaseFactory.getDatabaseUniqueName(values[0]);
                    this.setFailure(node, dbName, failedOp, cne);
                }
                catch (DatabaseException de) {
                    Trace.out("DatabaseException thrown while retrieving db unique name : " + de);
                }
            }
        }
        Trace.out("Exiting setFailure");
    }

    void setFailure(String node, String dbName, MoveDatabaseException.Operation failedOp, Exception cause) {
        if (this.m_moveStatus.containsKey(node)) {
            this.m_moveStatus.get(node).put(dbName, new FailureDetails(failedOp, cause));
        } else {
            HashMap<String, FailureDetails> val = new HashMap<String, FailureDetails>();
            this.m_moveStatus.put(node, val);
            val.put(dbName, new FailureDetails(failedOp, cause));
        }
        Trace.out("Exiting setFailure2");
    }

    @Override
    public List<String> getNodes() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.m_moveStatus.keySet());
        return Collections.unmodifiableList(ret);
    }

    @Override
    public List<String> getFailedDBNames(String node) throws NoSuchIdentifierException {
        if (node == null || !this.m_moveStatus.containsKey(node)) {
            throw new NoSuchIdentifierException((MessageKey)PrCcMsgID.NO_SUCH_IDENTIFIER, node);
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.m_moveStatus.get(node).keySet());
        return Collections.unmodifiableList(ret);
    }

    @Override
    public Exception getFailureCause(String node, String dbName) throws NoSuchIdentifierException {
        if (node == null || !this.m_moveStatus.containsKey(node)) {
            throw new NoSuchIdentifierException((MessageKey)PrCcMsgID.NO_SUCH_IDENTIFIER, node);
        }
        Map<String, FailureDetails> valMap = this.m_moveStatus.get(node);
        if (dbName == null || !valMap.containsKey(dbName)) {
            throw new NoSuchIdentifierException((MessageKey)PrCcMsgID.NO_SUCH_IDENTIFIER, dbName);
        }
        Exception ret = valMap.get(dbName).getException();
        return ret;
    }

    @Override
    public String getReport() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        for (Map.Entry<String, Map<String, FailureDetails>> entry : this.m_moveStatus.entrySet()) {
            String nodeName = entry.getKey();
            Map<String, FailureDetails> valMap = entry.getValue();
            for (Map.Entry<String, FailureDetails> valEntry : valMap.entrySet()) {
                String dbName = valEntry.getKey();
                MoveDatabaseException.Operation failedOp = valEntry.getValue().getFailedOp();
                Exception e = valEntry.getValue().getException();
                PrCdMsgID msgid = PrCdMsgID.MOVE_DB_START_FAILED;
                if (failedOp == MoveDatabaseException.Operation.START) {
                    msgid = PrCdMsgID.MOVE_DB_START_FAILED;
                } else if (failedOp == MoveDatabaseException.Operation.STOP) {
                    msgid = PrCdMsgID.MOVE_DB_STOP_FAILED;
                }
                sb.append(MessageBundle.getMessage(msgid, false, failedOp.toString(), dbName, nodeName));
                sb.append("\n" + e.getMessage() + "\n\n");
            }
        }
        return sb.toString();
    }

    @Override
    public long getCreationTime() {
        return this.m_creationTime;
    }

    private void setCreationTime() {
        this.m_creationTime = System.currentTimeMillis();
    }

    private class FailureDetails {
        private MoveDatabaseException.Operation m_failedOp = null;
        private Exception m_exception = null;

        private FailureDetails(MoveDatabaseException.Operation failedOp, Exception exception) {
            this.m_failedOp = failedOp;
            this.m_exception = exception;
        }

        private MoveDatabaseException.Operation getFailedOp() {
            return this.m_failedOp;
        }

        private Exception getException() {
            return this.m_exception;
        }
    }
}

