/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.MgmtDBInstance;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.DatabaseInstanceImpl;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;

public class MgmtDBInstanceImpl
extends DatabaseInstanceImpl
implements MgmtDBInstance {
    private MgmtDatabase m_database;

    MgmtDBInstanceImpl(MgmtDatabase db, Node node) throws InstanceException {
        String nodeName = "";
        try {
            this.m_name = ResourceLiterals.MGMTDB_UNIQUE_NAME.toString();
            this.m_displayName = ResourceLiterals.MGMTDB_INST_NAME.toString();
            nodeName = node.getName();
            this.m_database = db;
            this.m_node = node;
        }
        catch (NodeException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.CREATE_DBINST_FAILED_NODE, (Throwable)e, this.m_displayName, db.getUserAssignedName(), nodeName);
        }
    }

    @Override
    public MgmtDatabase database() throws DatabaseException {
        return this.m_database;
    }

    @Override
    public boolean isRunning() throws SoftwareModuleException {
        if (this.m_node == null) {
            return this.m_database.isRunning();
        }
        return this.m_database.isRunning(this.m_node);
    }

    @Override
    public boolean isRunning(Node node) throws SoftwareModuleException {
        return this.m_database.isRunning(node);
    }

    @Override
    public void enable() throws AlreadyEnabledException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.enable();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)((Object)this.m_database)).enable(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }

    @Override
    public void disable() throws AlreadyDisabledException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.disable();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)((Object)this.m_database)).disable(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.start();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)((Object)this.m_database)).start(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }

    @Override
    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.stop(force);
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)((Object)this.m_database)).stop(nodelist, force);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }
}

