/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.HashMap;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.GIMRProperties;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.database.DBConnectionException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.GIMRComponent;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.MgmtDBConnection;
import oracle.cluster.database.MgmtDBInstance;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.database.DBConnectionImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.util.NotExistsException;
import oracle.net.nl.InvalidSyntaxException;
import oracle.net.nl.NVPair;
import oracle.ops.mgmt.trace.Trace;

public class MgmtDBConnectionImpl
extends DBConnectionImpl
implements MgmtDBConnection {
    private String m_addressList;
    public static final String JDBC_OCI_URL = "jdbc:oracle:oci:@";
    public static final String JDBC_THIN_URL = "jdbc:oracle:thin:@";
    private String m_clusterGUID;
    private boolean m_isServer = true;

    public MgmtDBConnectionImpl() throws DatabaseException {
        this.m_addressList = this.getMgmtTNSAddressList();
        this.m_connectString = this.getMgmtDBConnectString();
    }

    public MgmtDBConnectionImpl(String clusterGUID, boolean isServer) {
        this.m_clusterGUID = clusterGUID;
        this.m_isServer = isServer;
    }

    public MgmtDBConnectionImpl(String user, String passwd) throws DBConnectionException, DatabaseException {
        this.m_user = user;
        this.m_passwd = passwd;
        this.m_addressList = this.getMgmtTNSAddressList();
        this.m_connectString = this.getMgmtDBConnectString();
        this.m_isServer = true;
        Trace.out(" Address List=" + this.m_addressList + " connectString=" + this.m_connectString);
    }

    @Override
    public String getAddressList() {
        return this.m_addressList;
    }

    private String getMgmtTNSAddressList() throws DatabaseException {
        try {
            NodeAppsFactory naf = NodeAppsFactory.getInstance();
            String lsnrName = ResourceLiterals.MGMTLSNR.toString();
            Listener lsnr = naf.getListener(lsnrName);
            String addr_list = lsnr.getTNSAddressList();
            return addr_list;
        }
        catch (ListenerException le) {
            throw new DatabaseException(le);
        }
        catch (SoftwareModuleException sme) {
            throw new DatabaseException(sme);
        }
        catch (NotExistsException ne) {
            throw new DatabaseException(ne);
        }
    }

    private String getMgmtDBConnectString() throws DatabaseException {
        try {
            GIMRProperties gimrProps = CredentialsFactory.getInstance().getGIMRProperties();
            return this.getMgmtDBConnectString(gimrProps.getServiceName(), true, false);
        }
        catch (CredentialsException | NotExistsException ex) {
            throw new DatabaseException(ex);
        }
    }

    private String getMgmtDBConnectString(String service) throws DatabaseException {
        return this.getMgmtDBConnectString(service, true, false);
    }

    private String getMgmtDBConnectString(String service, boolean isThick, boolean isSecure) throws DatabaseException {
        String url = null;
        try {
            String sec;
            Trace.out("Generating connect string with paramenters: thick " + isThick + ", secure " + isSecure);
            url = isThick ? JDBC_OCI_URL : JDBC_THIN_URL;
            String string = sec = isSecure ? this.generateSecurityEndpoints() : "";
            if (service == null || service.isEmpty()) {
                DatabaseFactory dbFact = DatabaseFactory.getInstance();
                MgmtDatabase mgmtDB = dbFact.getMgmtDatabase();
                MgmtDBInstance mgmtDBInst = mgmtDB.getDBInstance();
                String tnsConnectStr = mgmtDBInst.getTNSConnectString(this.m_addressList);
                if (isSecure) {
                    tnsConnectStr = tnsConnectStr.substring(0, tnsConnectStr.lastIndexOf(")"));
                    url = url + tnsConnectStr + sec + ")";
                } else {
                    url = url + tnsConnectStr;
                }
            } else {
                NVPair srv = new NVPair("SERVICE_NAME", service);
                String con = new NVPair("CONNECT_DATA", srv).toString();
                url = url + new NVPair("DESCRIPTION", this.m_addressList + con + sec).toString();
            }
            Trace.out("jdbc url = " + url);
            return url;
        }
        catch (InvalidSyntaxException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException nee) {
            throw new DatabaseException(nee);
        }
        catch (InstanceException ie) {
            throw new DatabaseException(ie);
        }
        catch (SoftwareModuleException sme) {
            throw new DatabaseException(sme);
        }
    }

    @Override
    public String getConnectString(GIMRComponent gcomp) throws DatabaseException {
        return this.getConnectString(gcomp, true, false);
    }

    @Override
    public String getConnectString(GIMRComponent gcomp, boolean isThick, boolean isSecure) throws DatabaseException {
        try {
            Trace.out("Generate connection String from GIMR properties");
            GIMRProperties gimrProps = CredentialsFactory.getInstance().getGIMRProperties();
            if (this.m_isServer) {
                this.m_addressList = this.getMgmtTNSAddressList();
                Trace.out("Address list " + this.m_addressList);
            } else {
                HashMap<String, String> hosts = new HashMap<String, String>(1);
                hosts.put(gimrProps.getScanName(), gimrProps.getScanPort());
                this.m_addressList = NodeAppsFactoryImpl.getInstance().generateTNSAddressList(hosts);
            }
            return this.getMgmtDBConnectString(gimrProps.getServiceName(), isThick, isSecure);
        }
        catch (SoftwareModuleException | CredentialsException | NotExistsException ex) {
            throw new DatabaseException(ex);
        }
    }

    @Override
    public String getGIMRUser(GIMRComponent comp) throws DatabaseException, NotExistsException {
        try {
            UserPassCredentials cred = CredentialsFactory.getInstance().getGIMRComponentCredFromClusterGUID(comp, this.m_clusterGUID);
            return cred.getUsername();
        }
        catch (CredentialsException ce) {
            throw new DatabaseException(ce);
        }
    }

    @Override
    public byte[] getGIMRPassword(GIMRComponent comp) throws DatabaseException, NotExistsException {
        try {
            UserPassCredentials cred = CredentialsFactory.getInstance().getGIMRComponentCredFromClusterGUID(comp, this.m_clusterGUID);
            return cred.getPassword().getBytes();
        }
        catch (CredentialsException ce) {
            throw new DatabaseException(ce);
        }
    }

    private String generateSecurityEndpoints() throws InvalidSyntaxException {
        NVPair encryptionClient = new NVPair("ENCRYPTION_CLIENT", "required");
        NVPair cryptoChkSumClient = new NVPair("CRYPTO_CHECKSUM_CLIENT", "required");
        return new NVPair("SECURITY", encryptionClient.toString() + cryptoChkSumClient.toString()).toString();
    }
}

