/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.Instance;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.MgmtDBInstance;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotExistsException;
import oracle.net.nl.InvalidSyntaxException;
import oracle.net.nl.NVPair;
import oracle.ops.mgmt.trace.Trace;

public class InstanceImpl
extends SoftwareModuleImpl
implements Instance {
    protected ResourceAttribute m_nameAttr;
    protected Node m_node = null;
    protected Instance.InstanceState m_state = Instance.InstanceState.OFFLINE;
    protected int m_clientNum = 0;
    protected String m_clientNames = "";
    protected Instance.ConnectedToType m_connectedToType = Instance.ConnectedToType.NONE;
    protected String m_connectedToInstance = "";
    protected boolean m_isDBInstance;

    @Override
    public CRSResource crsResource() throws NotExistsException, InstanceException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new InstanceException(e);
        }
    }

    @Override
    public boolean isDatabaseInstance() {
        return this.m_isDBInstance;
    }

    @Override
    public Node node() throws InstanceException {
        return this.m_node;
    }

    @Override
    public void setNode(Node node) throws InstanceException {
        this.m_node = node;
    }

    @Override
    public String getState() {
        return this.m_state.toString();
    }

    @Override
    public int getClientConnected() {
        return this.m_clientNum;
    }

    @Override
    public void setClientConnected(int clientNum) {
        this.m_clientNum = clientNum;
    }

    @Override
    public String getClientNames() {
        return this.m_clientNames;
    }

    @Override
    public void setClientNames(String clientName) {
        this.m_clientNames = clientName;
    }

    @Override
    public String getConnectedToInstance() {
        return this.m_connectedToInstance;
    }

    @Override
    public void setConnectedToInstance(String connectedToInstance) {
        this.m_connectedToInstance = connectedToInstance;
    }

    @Override
    public Instance.ConnectedToType getConnectedToType() {
        return this.m_connectedToType;
    }

    @Override
    public void setConnectedToType(String connectedToType) {
        this.m_connectedToType = Instance.ConnectedToType.getEnumMember(connectedToType);
    }

    public boolean equals(Object obj) {
        try {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            InstanceImpl instance = (InstanceImpl)obj;
            Trace.out("instName = %s, obj.instName = %s ", this.getUserAssignedName(), instance.getUserAssignedName());
            return this.isDatabaseInstance() == instance.isDatabaseInstance() && this.getName().equals(instance.getName()) && this.getUserAssignedName().equals(instance.getUserAssignedName()) && this.m_node != null && this.m_node.equals(instance.node());
        }
        catch (InstanceException e) {
            Trace.out(e.getMessage());
            return false;
        }
    }

    public int hashCode() {
        return this.m_node != null ? this.m_node.hashCode() : 1234567;
    }

    @Override
    public String getTNSConnectString(String addrList) throws InstanceException {
        try {
            String srvName;
            if (this instanceof MgmtDBInstance) {
                DatabaseFactory dbFact = DatabaseFactory.getInstance();
                srvName = dbFact.getPDBName();
            } else {
                srvName = this instanceof DatabaseInstance ? ((DatabaseInstance)((Object)this)).database().getUserAssignedName() : this.getName();
            }
            NVPair srv = new NVPair("SERVICE_NAME", srvName);
            String con = new NVPair("CONNECT_DATA", srv).toString();
            return new NVPair("DESCRIPTION", addrList + con).toString();
        }
        catch (NotExistsException e) {
            throw new InstanceException(e);
        }
        catch (DatabaseException e) {
            throw new InstanceException(e);
        }
        catch (SoftwareModuleException e) {
            throw new InstanceException(e);
        }
        catch (InvalidSyntaxException e) {
            throw new InstanceException(e);
        }
    }
}

