/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.HAService;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class HAServiceImpl
extends ServiceImpl
implements HAService {
    private static boolean s_debugEnabled = Trace.isLevelEnabled(5);

    HAServiceImpl(ResourceAttribute nameAttr) throws ServiceException {
        super(nameAttr, null);
    }

    HAServiceImpl(CRSResourceImpl sibling, ResourceAttribute nameAttr) throws ServiceException {
        super(sibling, nameAttr, null);
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, ServiceException {
        this.create(database, tafPolicy, serviceArgs, version, false);
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version, boolean checkListener) throws AlreadyExistsException, ServiceException {
        try {
            if (!((DatabaseImpl)database).isDBCentric()) {
                throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_DB_ADMIN_MGD_CONFIG, this.getUserAssignedName(), database.getUserAssignedName());
            }
            super.create(database, tafPolicy, serviceArgs, version, checkListener);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<DatabaseInstance> getPreferredInstances() throws ServiceException {
        List<DatabaseInstance> result = new ArrayList<DatabaseInstance>();
        Exception ex = null;
        try {
            Database db = this.database();
            if (db.databaseType() == DatabaseType.RACOneNode) {
                result = db.configuredInstances();
                if (result.size() == 1) {
                    return result;
                }
                throw new ServiceException((MessageKey)PrCdMsgID.GET_PREFINST_OF_RACONE_SVC, this.getUserAssignedName(), db.getUserAssignedName());
            }
            ServiceArgs args = this.getArgs();
            int numOfPref = args.getServiceCardinality().getCount();
            List<Server> servers = args.getServerGroup().configuredServers();
            HashMap<Server, DatabaseInstance> server2instance = new HashMap<Server, DatabaseInstance>();
            this.buildInstNServerMaps(null, server2instance);
            for (int i = 0; i < numOfPref; ++i) {
                Server server = servers.get(i);
                DatabaseInstance di = (DatabaseInstance)server2instance.get(server);
                if (di != null) {
                    result.add(di);
                    if (!s_debugEnabled) continue;
                    Trace.out("server %s => dbinstance %s", server.getUserAssignedName(), di.getUserAssignedName());
                    continue;
                }
                if (!s_debugEnabled) continue;
                Trace.out("cannot find di for server" + server.getUserAssignedName());
            }
        }
        catch (DatabaseException e) {
            ex = e;
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (ServerGroupException e) {
            ex = e;
        }
        catch (IndexOutOfBoundsException e) {
            ex = e;
        }
        catch (UnsupportedOperationException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_GETPREF_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
        return result;
    }

    @Override
    public List<DatabaseInstance> getAvailableInstances() throws ServiceException {
        ArrayList<DatabaseInstance> availInstList = new ArrayList<DatabaseInstance>();
        ManageableEntityException ex = null;
        try {
            if (this.database().databaseType() == DatabaseType.RACOneNode) {
                return availInstList;
            }
            ServiceArgs args = this.getArgs();
            int numOfPref = args.getServiceCardinality().getCount();
            List<Server> servers = args.getServerGroup().configuredServers();
            int numCandidates = servers.size();
            int numOfAvail = numCandidates - numOfPref;
            if (numOfAvail < 1) {
                return availInstList;
            }
            HashMap<Server, DatabaseInstance> server2instance = new HashMap<Server, DatabaseInstance>();
            this.buildInstNServerMaps(null, server2instance);
            for (int index = numOfPref; index < numCandidates; ++index) {
                DatabaseInstance availInst = (DatabaseInstance)server2instance.get(servers.get(index));
                availInstList.add(availInst);
            }
        }
        catch (DatabaseException e) {
            ex = e;
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (ServerGroupException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_GETAVAIL_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
        return availInstList;
    }

    @Override
    public void modify(List<DatabaseInstance> prefInstances, List<DatabaseInstance> availInstances, ServiceTAF taf, boolean disconnect) throws ServiceException {
        Exception ex = null;
        int numOfPrefs = prefInstances.size();
        if (numOfPrefs == 0) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_EMPTY_PREF, this.getUserAssignedName());
        }
        ArrayList<DatabaseInstance> allInstances = new ArrayList<DatabaseInstance>(prefInstances);
        try {
            List<Node> newPrefNodes = this.buildNodeListUsingInstanceList(allInstances);
            List<Node> newAvailNodes = this.buildNodeListUsingInstanceList(availInstances);
            List<Node> runningNodes = this.m_crsResource.fetchRunningNodes();
            ArrayList<Node> nodes2stop = new ArrayList<Node>();
            int need2stop = runningNodes.size() - prefInstances.size();
            if (s_debugEnabled & need2stop > 0) {
                Trace.out("need to stop " + need2stop);
            }
            for (Node node : runningNodes) {
                if (newPrefNodes.contains(node) || newAvailNodes.contains(node)) continue;
                nodes2stop.add(node);
                --need2stop;
            }
            if (need2stop > 0) {
                for (Node node : runningNodes) {
                    if (!newAvailNodes.contains(node)) continue;
                    nodes2stop.add(node);
                    Trace.out((Object)"need to stop on node %s", node.getName());
                    if (--need2stop != 0) continue;
                    break;
                }
            }
            if (nodes2stop.size() > 0) {
                try {
                    this.stop(nodes2stop, true);
                }
                catch (AlreadyStoppedException alreadyStoppedException) {
                    // empty catch block
                }
            }
            allInstances.addAll(availInstances);
            List<Node> newNodes = this.buildNodeListUsingInstanceList(allInstances);
            ArrayList<Server> newServers = new ArrayList<Server>(allInstances.size());
            for (Node node : newNodes) {
                newServers.add(node.server());
            }
            ServiceArgs args = this.getArgs();
            ServerGroup sg = args.getServerGroup();
            Server[] servers = new Server[newServers.size()];
            servers = newServers.toArray(servers);
            sg.setMaxSize(-1);
            sg.setServers(servers);
            ServiceArgs sa = new ServiceArgs();
            ServiceCardinality card = ServiceCardinality.COUNTED;
            card.setCount(numOfPrefs);
            sa.setServiceCardinality(card);
            sa.setDisconnectOpt(disconnect);
            this.modify(sa);
            if (taf != null) {
                this.setTAF(taf);
            }
        }
        catch (CRSException e) {
            ex = e;
        }
        catch (NodeException e) {
            ex = e;
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (ServerGroupException e) {
            ex = e;
        }
        catch (SoftwareModuleException e) {
            ex = e;
        }
        catch (CompositeOperationException e) {
            ex = e;
        }
        catch (IndexOutOfBoundsException e) {
            ex = e;
        }
        catch (UnsupportedOperationException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_MODIFY_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
    }

    @Override
    public void enableInstances(List<DatabaseInstance> instanceList) throws CompositeOperationException, ServiceException {
        ManageableEntityException ex = null;
        try {
            List<Node> nodes2enable = this.buildNodeListUsingInstanceList(instanceList);
            this.enable(nodes2enable);
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (AlreadyEnabledException e) {
            ex = e;
        }
        catch (SoftwareModuleException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_ENABINST_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
    }

    @Override
    public void disableInstances(List<DatabaseInstance> instanceList) throws CompositeOperationException, ServiceException {
        ManageableEntityException ex = null;
        try {
            List<Node> nodes2disable = this.buildNodeListUsingInstanceList(instanceList);
            this.disable(nodes2disable);
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (AlreadyDisabledException e) {
            ex = e;
        }
        catch (SoftwareModuleException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.SERVICE_DISABINST_FAILED, (Throwable)ex, this.getUserAssignedName());
        }
    }

    @Override
    public void start(DatabaseInstance[] instances) throws CompositeOperationException, ServiceException {
        ManageableEntityException ex = null;
        try {
            this.start(this.buildNodeListUsingInstanceList(Arrays.asList(instances)));
        }
        catch (SoftwareModuleException e) {
            ex = e;
        }
        catch (AlreadyRunningException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void stop(DatabaseInstance[] instances, boolean disconnect) throws CompositeOperationException, ServiceException {
        ManageableEntityException ex = null;
        try {
            this.stop(this.buildNodeListUsingInstanceList(Arrays.asList(instances)), false);
        }
        catch (SoftwareModuleException e) {
            ex = e;
        }
        catch (AlreadyStoppedException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void remove(DatabaseInstance instance, boolean force) throws InstanceException, AlreadyRunningException, ServiceException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public void relocate(ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate(options);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    public void relocateTo(Node tgtNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode, options);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node node, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate(node, options);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate(srcNode, tgtNode, options);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    private void buildInstNServerMaps(Map<String, Node> instance2node, Map<Server, DatabaseInstance> server2instance) throws ServiceException {
        try {
            List<DatabaseInstance> myInstances = this.database().instances();
            if (s_debugEnabled) {
                Trace.out("There are " + myInstances.size() + " dis");
            }
            if (instance2node != null) {
                instance2node.clear();
            }
            if (server2instance != null) {
                server2instance.clear();
            }
            for (DatabaseInstance di : myInstances) {
                if (instance2node != null) {
                    instance2node.put(di.getUserAssignedName(), di.node());
                }
                if (server2instance == null) continue;
                server2instance.put(di.node().server(), di);
            }
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
        catch (InstanceException e) {
            throw new ServiceException(e);
        }
        catch (NodeException e) {
            throw new ServiceException(e);
        }
    }

    private List<Node> buildNodeListUsingInstanceList(List<DatabaseInstance> instanceList) throws ServiceException {
        ArrayList<Node> result = new ArrayList<Node>(instanceList.size());
        HashMap<String, Node> instName2node = new HashMap<String, Node>(instanceList.size());
        this.buildInstNServerMaps(instName2node, null);
        StringBuilder sb = null;
        for (DatabaseInstance di : instanceList) {
            Node node = (Node)instName2node.get(di.getUserAssignedName());
            if (node == null) {
                if (sb == null) {
                    sb = new StringBuilder(di.getUserAssignedName());
                    continue;
                }
                sb.append(",").append(di.getUserAssignedName());
                continue;
            }
            result.add(node);
        }
        if (sb != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.NO_INSTANCES_FOUND, this.database(), sb.toString());
        }
        return result;
    }

    @Override
    void handleDBInstRemoved(Database db, DatabaseInstance instance) throws ServiceException {
        block11: {
            try {
                Server server = instance.node().server();
                ServerGroup sg = this.serverGroup();
                List<Server> serverList = sg.configuredServers();
                int serverIndex = serverList.indexOf(server);
                if (serverIndex < 0) {
                    return;
                }
                ServiceArgs args = this.getArgs();
                int numOfPref = args.getServiceCardinality().getCount();
                if (s_debugEnabled) {
                    Trace.out("Instance %s, numOfPref %d, serverIndex %d", instance.getUserAssignedName(), numOfPref, serverIndex);
                }
                serverList.remove(serverIndex);
                Server[] servers = new Server[serverList.size()];
                servers = serverList.toArray(servers);
                sg.setMaxSize(-1);
                sg.setServers(servers);
                if (serverIndex >= numOfPref) break block11;
                if (--numOfPref == 0) {
                    try {
                        this.remove(true);
                    }
                    catch (AlreadyRunningException e) {
                        Trace.out(e);
                    }
                    catch (ServiceException e) {
                        Trace.out(e);
                    }
                    return;
                }
                ServiceArgs sa = new ServiceArgs();
                ServiceCardinality card = ServiceCardinality.COUNTED;
                card.setCount(numOfPref);
                if (s_debugEnabled) {
                    Trace.out("new cardnality should be " + card.getCount());
                }
                sa.setServiceCardinality(card);
                this.modify(sa);
            }
            catch (NodeException e) {
                throw new ServiceException(e);
            }
            catch (InstanceException e) {
                throw new ServiceException(e);
            }
            catch (ServerGroupException e) {
                throw new ServiceException(e);
            }
        }
    }

    static void canRemoveInstance(Database db, DatabaseInstance instance, Filter servicesFilter) throws ServiceException {
        List<Service> services = HAServiceImpl.checkIfInstanceIsTheOnlyPreferred(db, instance, servicesFilter);
        if (services.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Service s : services) {
                String sName = s.getUserAssignedName();
                if (sb.length() > 0) {
                    sb.append(',').append(sName);
                    continue;
                }
                sb.append(sName);
            }
            throw new ServiceException((MessageKey)PrCdMsgID.REMOVE_PREF_INSTANCE, instance.getUserAssignedName(), sb.toString(), db.getUserAssignedName());
        }
    }

    static List<Service> checkIfInstanceIsTheOnlyPreferred(Database db, DatabaseInstance instance, Filter servicesFilter) throws ServiceException {
        Exception ex = null;
        ArrayList<Service> result = new ArrayList<Service>();
        if (s_debugEnabled) {
            Trace.out("db %s, instance %s", db.getUserAssignedName(), instance.getUserAssignedName());
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter card1Filter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.ClusterResource.CARDINALITY.name(), "1");
            Filter theFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, servicesFilter, card1Filter);
            List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.Resource, theFilter);
            if (resList.size() == 0) {
                if (s_debugEnabled) {
                    Trace.out("No cardinality 1 services");
                }
                return result;
            }
            if (s_debugEnabled) {
                Trace.out("Found " + resList.size() + " services");
            }
            Server server = instance.node().server();
            HAServiceImpl haService = null;
            for (ResourceAttribute ra : resList) {
                ServiceArgs args;
                List<Server> serverList;
                haService = new HAServiceImpl(ra);
                if (s_debugEnabled) {
                    Trace.out("checking service " + haService.getName());
                }
                if (!(serverList = (args = haService.getArgs()).getServerGroup().configuredServers()).get(0).equals(server)) continue;
                if (s_debugEnabled) {
                    Trace.out(haService.getName() + " requires the instance");
                }
                result.add(haService);
            }
        }
        catch (CRSException e) {
            ex = e;
        }
        catch (InstanceException e) {
            ex = e;
        }
        catch (NodeException e) {
            ex = e;
        }
        catch (ServerGroupException e) {
            ex = e;
        }
        if (ex != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.THE_ONLY_PREF_INSTANCE_FAILED, (Throwable)ex, instance.getUserAssignedName());
        }
        return result;
    }
}

